// Copyright 2019 Drone IO, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package main

import (
	"github.com/drone/drone/cmd/drone-server/config"
	"github.com/drone/drone/core"
	"github.com/drone/drone/scheduler/queue"

	"github.com/google/wire"
)

// wire set for loading the scheduler.
var schedulerSet = wire.NewSet(
	provideScheduler,
)

// provideScheduler is a Wire provider function that returns a
// scheduler based on the environment configuration.
func provideScheduler(store core.StageStore, config config.Config) core.Scheduler {
	return queue.New(store)
}
