---
layout: page
title: "Terms of Service"
description: "NetLicensing"
permalink: "/legal/terms-of-service/netlicensing/2-5/"
tags:
- legal
- affiliate
- partnership
---

<div class="row NL_banner">
    <div class="col-md-8 col-md-offset-2 NL_about">
        <h1>{{ page.title }}</h1>
        <span>{{ page.description }}</span>
    </div>
</div>

<br><br>

Labs64 NetLicensing – Innovative Licensing

by Labs64 GmbH, Radlkoferstr. 2, 81373 Munich (referred to hereinafter as “Labs64”)

These terms govern all use of the NetLicensing websites at [netlicensing.io](https://netlicensing.io "NetLicensing.IO") and subdomains, open-source libraries, as well as all services available through them and integration partners via NetLicensing API.  
Definitions used within these Terms of Service (Terms) are listed in the [Glossary](https://netlicensing.io/wiki/glossary "NetLicensing Glossary").

### I. Contractual grounds

Labs64 offers the license management system Labs64 NetLicensing – Innovative License Management Solution (referred to hereinafter as “NetLicensing” or “Service”) in accordance with the Terms of Service (Terms). The offer is aimed at manufacturers (referred to hereinafter as “CUSTOMER”, “VENDOR” or “you”) of software and digital services in order to allow them to professionalize and market online their own software to their end-customers.

By accessing or using the NetLicensing website, the NetLicensing service, or any applications (including mobile and demo applications) made available by NetLicensing, you agree to be bound by these Terms of Services. Please read these Terms of Services and [Privacy Policy](/legal/privacy-policy/) carefully. If you do not accept all of the terms contained in these policies, do not register for or use the Service.

In order to gain full access to NetLicensing services, you must first register. By doing so you give your consent to our Terms of Service and we become contractual partners. Your registration becomes effective once your identity is verified and account activated.

Any information submitted to us during registration or in other communication must be complete and correct. Keep your user profile updated so we can contact you at any time.

You represent and warrant that:  
i. you have full power and authority to enter into the NetLicensing Terms;  
ii. NetLicensing has never previously terminated or otherwise disabled a NetLicensing account created by you due to your breach of the NetLicensing Terms or due to invalid activity;  
iii. entering into or performing under the NetLicensing Terms will not violate any agreement you have with a third-party or any third-party rights;  
iv. all of the information provided by you to NetLicensing is correct and current.

If you are registering to use the Service on behalf of a legal entity  
i. you must be the authorized representative of such entity;  
ii. with respect to any Client (end customer) of your, have the full power and authority to bind Client to these Terms and applicable Terms of Services for your product;  
iii. if Client subsequently disputes such power or authority, you shall be liable for any failure of Client to comply with these Terms.

### II. Services rendered by Labs64

During the term of this agreement, Labs64 shall provide the CUSTOMER, via [netlicensing.io](https://netlicensing.io), and it’s subdomains with online access to NetLicensing and the possibility to use NetLicensing for purposes of license management.  
The range of functions of NetLicensing, including the license models provided for by Labs64 between CUSTOMERS and their end-customers, as well as the definitions related thereto ensue from the [functional description](https://netlicensing.io/wiki/overview).

### III. Granting of rights

#### 1\. Scope of the rights of use

For the term of this agreement with the CUSTOMER, Labs64 shall grant to the customer a non-exclusive, non-transferable right of use limited in time with respect to NetLicensing.

If NetLicensing provides you with software in connection with the Services, we grant you a non-exclusive, non-sublicensable, non-transferable license for use of such software. This license is for the sole purpose of enabling you to use and enjoy the benefit of the Services as provided by NetLicensing in the manner permitted by the NetLicensing Terms. You may not copy, modify, distribute, sell, or lease any part of our Services or included software, nor may you reverse engineer or attempt to extract the source code of that software, unless applicable laws prohibit those restrictions or you have our prior written consent. You will not remove, obscure, or alter NetLicensing’s copyright notice, Brand Features, or other proprietary rights notice affixed to or contained within any Services or other NetLicensing software or documentation.

#### 2\. Restriction of the rights of utilization

NetLicensing is protected by copyright; Labs64 shall be entitled to the rights resulting from the copyright to the extent that no third-party products are used. The copyright covers, in particular, the program code, documentation, external appearance, structure and organization of the program files, program names, logos and other forms of representation within the software. In addition to the material protected by copyright, NetLicensing contains trade secrets. The CUSTOMER shall be obliged to safeguard both.

#### 3\. Trademarks

“Labs64” is registered trademark of Labs64. All Labs64 trademarks may not be published or used in any other manner without the prior consent of Labs64.

### IV. Royalties and terms of payment

#### 1\. Royalties

The CUSTOMER shall pay to Labs64 the royalties set down in the [Price List](https://netlicensing.io/pricing/) for the paid plans or upon special agreement for an Enterprise plan. Some features are offered as add-ons to CUSTOMERS NetLicensing account. Such add-on features that have a charge will be billed that additional amount with each billing cycle for as long as the add-on is active.  
We may change our fees at any time by posting a new pricing structure to our Website and/or sending you a notification by email.  
Any and all royalties in per-cent and / or in EURO are quoted net, exclusive of the respectively applicable value-added tax.  
To extent that the CUSTOMER provides Labs64 with a verified value-added tax identification number for his company in a non-EU country, the settlement of the royalties shall take place net pursuant to §§ 3a (2) sentence 1, 13 b of the German Turnover Tax Law \[UStG – Umsatzsteuergesetz\] with notification pertaining to the passing on of the tax liability to the customer (recipient of our service). The CUSTOMER shall be obliged to promptly inform Labs64 of any changes to the performance country, the value-added tax identification number or the withdrawal or discontinuation of the same, and shall be held liable for any and all damage which is incurred from a breach of this duty.

#### 2\. Invoicing

Any and all royalties to be paid to Labs64 in accordance with these Terms shall be dependent on use and/or transaction. With every settlement, Labs64 shall issue an invoice with regard to the royalty to be paid by the CUSTOMER.

#### 3\. Adjustment of the royalties

Labs64 shall, at its own discretion, be entitled to adjust the royalties agreed upon under these Terms. Labs64 may amend the royalties only with effect as of the first of the month of a calendar quarter. Labs64 shall be obliged to inform the CUSTOMER in writing of any and all amendments to the royalties by means of prior notification of no less than 8 weeks prior to the effective date. In this event, the CUSTOMER shall be entitled to terminate this agreement within two weeks as of gaining knowledge of the intended change to the royalties.

#### 4\. Taxes

You are responsible for all taxes (if any) associated with the Services (other than taxes based on Labs64’s net income). All payments to you from Labs64 in relation to the Services (if any) will be treated as inclusive of tax (if applicable) and will not be adjusted.

#### 5\. Default in payment

The CUSTOMER shall be deemed to be in default of payment to the extent that Labs64 has not received a payment within 20 days after invoicing at the latest. As soon as default in payment occurs, Labs64 shall be entitled to charge interest amounting to 8 % p.a. above the base interest rate of the European Central Bank. Should the CUSTOMER be in default of payment, Labs64 shall be entitled to refuse the further rendering of services until full payment, including interest, is rendered in accordance with this agreement. In addition, Labs64 shall be entitled to deactivate the affected licenses of end-customers, and to restrict access to the services by Labs64.

#### 6\. Attribution

We request that you place NetLicensing attribution on your main page or/and in your product when you use free plans.  
You can use this “nofollow” link as a template:

```
<a href="https://netlicensing.io" rel="nofollow"> Powered by Labs64 NetLicensing </a>
```

### V. Duties of the customer

#### 1\. Correct and up-to-date entry of information

The CUSTOMER shall be obliged to keep up-to-date at all times any and all input and data entered in NetLicensing, and to provide correct and truthful information at all times. This shall apply in particular to texts pertaining to the licensing terms applicable to the relationship between the CUSTOMER and the end-customer. The CUSTOMER shall verify all input in terms of its completeness and correctness prior to uploading. The CUSTOMER shall correct any and all mistakes without undue delay.

#### 2\. Compliance with Laws

You represent and warrant that your use of NetLicensing will comply with all applicable laws and regulations. You’re responsible for determining whether our Services are suitable for you to use in light of any regulations like HIPAA, GLB, EU Data Privacy Laws, or other laws. If you’re subject to regulations (like HIPAA) and you use our Service, then we won’t be liable if our Service doesn’t meet those requirements. You may not use our Service for any unlawful or discriminatory activities, including acts prohibited by the Federal Trade Commission Act, Fair Credit Reporting Act, Equal Credit Opportunity Act, or other laws that apply to commerce.  
If you’re located in the European Economic Area (EEA) or send to anyone in the EEA, you represent and warrant that in maintaining your end-customers list, offering licensing services via NetLicensing, and collecting information as a result of licenses distribution and validation, you:  
i. will clearly describe in writing how you plan to use any data collected, including for your use of NetLicensing, by providing own terms and conditions as well as privacy policies to the end-customers. You’ll get express consent to transfer data to NetLicensing and be processed, and you’ll otherwise comply with whatever privacy policy you have posted.  
ii. have complied, and will comply, with all regulations, as well as data protection, electronic communication, and privacy laws that apply to the countries where you’re enabling license management through NetLicensing.  
iii. have collected, stored, used, and transferred all data relating to any individual in compliance with all data protection laws and regulations. You have the necessary permission to allow NetLicensing to receive and process data and send communications to that individual on your behalf.  
iv. agree to indemnify and hold us harmless from any losses, including attorney fees, that result from your breach of any part of these warranties.

#### 3\. Maintaining a PSP Account

The CUSTOMER shall be obliged to maintain in operative order the accounts necessary for the payment method (PSP) selected as well as provide correct payment method configuration details. You must agree to the applicable terms of use of an available payment facilitator supported by NetLicensing (currently PayPal and Stripe, however, the payment facilitators supported by the Service are subject to change from time to time).

#### 4\. Implementation of technical specifications

The CUSTOMER shall be obliged to configure the necessary technical implementation measures in accordance with the specifications provided by Labs64. Labs64 shall assume no responsibility for problems or errors occurring in connection with the integration of NetLicensing in the CUSTOMER’s software.

### VI. Data security

#### 1\. Registration data and passwords

During initial registration on the Labs64 portal, the CUSTOMER shall define a user name and password, and shall enter the name of his company. Any and all data shall be stored carefully. The CUSTOMER may change his password at any time under “Personal settings” in his account. For security reasons, it is recommended that the password be changed on a regular basis. The password may be used only by the CUSTOMER himself and shall be kept secret from third parties. Labs64 reserves the right to temporarily block the account of the CUSTOMER upon repeated entry of a wrong password. We may introduce additional security or verification procedures relating to Account opening and access from time to time.

#### 2\. Data security

Labs64 shall be obliged to adhere to any and all necessary measures of physical data security within its sphere of responsibility and to ensure that these are adhered to.

### VII. Liability, force majeure

#### 1\. Liability

Labs64 shall be held liable without limitation for damage caused by intent, gross negligence and severe organizational culpability, for damage resulting from injury to life, limb or health, independent of the severity of culpability, and in the event of the assumption of a guaranty. In addition, Labs64 shall be held liable for the grossly negligent breach of duties, the fulfilment of which constitutes a pre-requisite for the proper execution of the contract, the breach of which jeopardizes the fulfilment of the contractual purpose, and the adherence to which the CUSTOMER regularly relies on. In the latter case, Labs64 shall, however, not be held liable for non-foreseeable damage which is not typical to the contract.  
Liability for damages above and beyond that, in particular for damage which is not incurred by the subject matter of the agreement itself, for loss of profits, loss of data or other consequential damage shall be excluded. To the extent that the liability of Labs64 is excluded or limited, this shall also apply to the personal liability borne by the employees, representatives and vicarious agents.

#### 2\. Force majeure

In the events of force majeure, the obligation of the parties to effect performance shall remain unaffected to the extent that the reason lies in their respective spheres. Should this not be the case (e.g. war, forces of nature), neither contracting party shall be held liable for delay or non-fulfilment of his duties. Events of force majeure also include external attacks on computer systems which cannot be averted by means of justifiable economic and technical efforts as per the state of the art, and which not only insignificantly impair the affected computer system in terms of its functionality.

### VIII. Coming into effect, term, termination

#### 1\. Coming into effect

This agreement shall come into effect upon the acceptance of the contractual terms of service by the CUSTOMER when registering on the internet sites of Labs64.

#### 2\. Term and termination

This agreement may be terminated by the CUSTOMER at any time subject to a notice period of 4 weeks to the end of the month. Labs64 may terminate this agreement with the CUSTOMER at any time, subject to a notice period of three months to the end of the quarter. The right to extraordinary termination shall remain unaffected.  
If we terminate your account without cause, we’ll refund a prorated portion of your monthly prepayment or reimburse you for unused Service Credits. We won’t refund or reimburse you if there’s cause, like a violation of these Terms. Once terminated, we may permanently delete your account and all the data associated with it, including end-customers data from our Website. If you don’t log in to your account for 12 or more months, we may treat your account as “inactive” and permanently delete the account and all the data associated with it.  
Any and all terminations of this agreement shall be made in writing or text form.

### IX. Maintenance of secrecy

The contracting parties shall, during and following the term of the agreement, undertake to maintain secrecy with respect to documents, information and data to which they have gained access or which have come to their knowledge due to the co-operation or in connection with this co-operation, and to safeguard the same against unauthorized access to the extent that disclosure is not mandatorily necessary for legal reasons or for the protection of legitimate interests. The same shall apply to this agreement. The contracting parties shall impose the duties to maintain secrecy to which they have committed themselves to upon any and all persons or companies who are entrusted by the contracting parties with the services arising from this agreement, or who receive information from this agreement.

You agree not to disclose NetLicensing Confidential Information (as defined below) without our prior written consent. “NetLicensing Confidential Information” includes, but is not limited to, the following: (a) all NetLicensing software, technology, and documentation relating to the Services; (b) the existence of, and information about, beta features in a Service; and (d) any other information made available by NetLicensing that is marked confidential or would normally be considered confidential under the circumstances in which it is presented. NetLicensing Confidential Information does not include information that you already knew prior to your use of the Services, that becomes public through no fault of yours, that was independently developed by you, or that was lawfully given to you by a third-party.

### X. Miscellaneous

#### 1\. Changes to the services and to the ToS

Labs64 reserves the right to change these Terms of Service and may add or remove functionalities or features of NetLicensing at any time, and may suspend or stop services altogether.  
Labs64 shall notify the CUSTOMER of any changes to these Terms of Service in good time. Should the CUSTOMER fail to object to the applicability of the new Terms of Service within six (6) weeks following such notification, the changed Terms shall be deemed as accepted by the CUSTOMER. In the notification, Labs64 shall call the CUSTOMER’s attention to his right of objection and to the significance of the time limit for such objection. If CUSTOMER doesn’t agree to any modified terms in these Terms, CUSTOMER will have to stop using the affected services.

#### 2\. Offsetting and retention

The CUSTOMER shall only be entitled to the right of offsetting or retention if the counter-claims asserted by him have become res judicata, are undisputed or have been acknowledged in writing by Labs64. The CUSTOMER shall be entitled to assert a right of retention in this case as well only to the extent that his counter-claim is based on the same contractual relationship.

#### 3\. Publications / references / reference to Labs64

Labs64 shall be permitted to mention the CUSTOMER as well as to include a general description of the CUSTOMER in customer lists, offers and other marketing documents. Labs64 shall, in particular, be entitled to use the logo, company name or other trademarks and/or labeling rights of the CUSTOMER within the scope of references, in particular in connection with corporate presentations, product descriptions, trade-fair presentations, on the internet, intranet or for other product or corporate information on Labs64 and/or the NetLicensing intended for the public.

#### 4\. Third-Party Links, Sites, and Services

You may not use any NetLicensing features (including the NetLicensing logo) to link to the Service without the prior written consent of NetLicensing or frame any such Brand Feature.

NetLicensing makes no claim or representation regarding, and accepts no responsibility for (whether directly or indirectly) the quality, content, nature or reliability of third-party websites accessible by hyperlink, advertising or special offer from the Services, or websites linking to the Services. Such sites are not under the control of NetLicensing and NetLicensing is not responsible for the contents of any linked site or any link contained in a linked site, or any review, changes or updates to such sites. NetLicensing provides these links to you only as a convenience, and the inclusion of any link does not imply any affiliation, endorsement, or adoption by NetLicensing of any site or any information contained therein. When you are not using the Services, you should be aware that the NetLicensing Terms no longer govern your activities (except as otherwise provided herein). You should review the applicable terms and policies (including privacy and data gathering practices) of any site to which you navigate.

#### 5\. Place of jurisdiction / applicable law

The contracting parties shall agree upon Munich as the place of jurisdiction with respect to any and all disputes arising from these Terms. The law of the Federal Republic of Germany under exclusion of the United Nations Convention on Contracts for the International Sale of Goods shall apply exclusively.

#### 6\. Text form

The contracting parties shall expressly agree upon the text form (e.g. via e-mail) as sufficing for the conclusion of the agreement. There are no verbal collateral agreements to this agreement. Any and all amendments and supplements to this agreement as well as the cancellation or termination of these Terms or parts thereof shall be made in text form to be effective.

#### 7\. Severability clause

Should individual provisions of these Terms be or become ineffective or invalid, all the remaining provisions shall not be affected hereby. In the event of ineffective or invalid provisions, loopholes, ambiguities or in the event of changes to the contractual grounds, the Terms shall be interpreted in a manner which comes closest to the economic interests of the contracting partners, with due consideration to the contractual purpose. The Terms shall – if necessary by duly amending additional provisions affected by the ineffectiveness – be supplemented accordingly.

Effective: May 25, 2018  
Version: v2.5