---
layout: page
title: "Privacy Policy"
description: ""
permalink: "/legal/privacy-policy/2-5/"
tags:
- legal
- privacy policy
---

<div class="row NL_banner">
    <div class="col-md-8 col-md-offset-2 NL_about">
        <h1>{{ page.title }}</h1>
        <span>{{ page.description }}</span>
    </div>
</div>

<br><br>

We are very delighted that you have shown interest in our enterprise. Data protection is of a particularly high priority for the management of Labs64 GmbH. The use of the Internet pages of Labs64 GmbH is possible without any indication of personal data; however, if a data subject wants to use special enterprise services via our website, processing of personal data could become necessary. If the processing of personal data is necessary and there is no statutory basis for such processing, we generally obtain consent from the data subject.

The processing of personal data, such as the name, address, e-mail address, or telephone number of a data subject shall always be in line with the General Data Protection Regulation (GDPR), and in accordance with the country-specific data protection regulations applicable to Labs64 GmbH. By means of this data protection declaration, our enterprise would like to inform the general public of the nature, scope, and purpose of the personal data we collect, use and process. Furthermore, data subjects are informed, by means of this data protection declaration, of the rights to which they are entitled.

As the controller, Labs64 GmbH has implemented numerous technical and organizational measures to ensure the most complete protection of personal data processed through this website. However, Internet-based data transmissions may in principle have security gaps, so absolute protection may not be guaranteed. For this reason, every data subject is free to transfer personal data to us via alternative means, e.g. by telephone.

### 1\. Definitions

The data protection declaration of Labs64 GmbH is based on the terms used by the European legislator for the adoption of the General Data Protection Regulation (GDPR). Our data protection declaration should be legible and understandable for the general public, as well as our customers and business partners. To ensure this, we would like to first explain the terminology used.

In this data protection declaration, we use, inter alia, the following terms:

*   #### a) Personal data
    
    Personal data means any information relating to an identified or identifiable natural person (“data subject”). An identifiable natural person is one who can be identified, directly or indirectly, in particular by reference to an identifier such as a name, an identification number, location data, an online identifier or to one or more factors specific to the physical, physiological, genetic, mental, economic, cultural or social identity of that natural person.
    
*   #### b) Data subject
    
    The data subject is any identified or identifiable natural person, whose personal data is processed by the controller responsible for the processing.
    
*   #### c) Processing
    
    Processing is any operation or set of operations which is performed on personal data or on sets of personal data, whether or not by automated means, such as collection, recording, organisation, structuring, storage, adaptation or alteration, retrieval, consultation, use, disclosure by transmission, dissemination or otherwise making available, alignment or combination, restriction, erasure or destruction.
    
*   #### d) Restriction of processing
    
    Restriction of processing is the marking of stored personal data with the aim of limiting their processing in the future.
    
*   #### e) Profiling
    
    Profiling means any form of automated processing of personal data consisting of the use of personal data to evaluate certain personal aspects relating to a natural person, in particular to analyse or predict aspects concerning that natural person’s performance at work, economic situation, health, personal preferences, interests, reliability, behaviour, location or movements.
    
*   #### f) Pseudonymisation
    
    Pseudonymisation is the processing of personal data in such a manner that the personal data can no longer be attributed to a specific data subject without the use of additional information, provided that such additional information is kept separately and is subject to technical and organisational measures to ensure that the personal data are not attributed to an identified or identifiable natural person.
    
*   #### g) Controller or controller responsible for the processing
    
    Controller or controller responsible for the processing is the natural or legal person, public authority, agency or another body which, alone or jointly with others, determines the purposes and means of the processing of personal data; where the purposes and means of such processing are determined by Union or Member State law, the controller or the specific criteria for its nomination may be provided for by Union or Member State law.
    
*   #### h) Processor
    
    The processor is a natural or legal person, public authority, agency or another body which processes personal data on behalf of the controller.
    
*   #### i) Recipient
    
    The recipient is a natural or legal person, public authority, agency or another body, to which the personal data are disclosed, whether a third party or not. However, public authorities which may receive personal data in the framework of a particular inquiry in accordance with Union or Member State law shall not be regarded as recipients; the processing of those data by those public authorities shall be in compliance with the applicable data protection rules according to the purposes of the processing.
    
*   #### j) Third party
    
    Third party is a natural or legal person, public authority, agency or body other than the data subject, controller, processor and persons who, under the direct authority of the controller or processor, are authorised to process personal data.
    
*   #### k) Consent
    
    Consent of the data subject is any freely given, specific, informed and unambiguous indication of the data subject’s wishes by which he or she, by a statement or by a clear affirmative action, signifies agreement to the processing of personal data relating to him or her.
    

### 2\. Name and Address of the controller

Controller for the purposes of the General Data Protection Regulation (GDPR), other data protection laws applicable in Member states of the European Union and other provisions related to data protection is:

Labs64 GmbH

Radlkoferstr. 2

81373 Munich, Germany

Phone: +49 (89) 741185-130

Email: info@labs64.de

If you have any questions or comments, or if you want to update, delete, or change any Personal Information we hold, or you have a concern about the way in which we have handled any privacy matter, please contact us using the information provided above.

### 3\. Cookies

The Internet pages of Labs64 GmbH use cookies (see our [Cookies Policy](/legal/privacy-policy/cookies-policy/ "Cookies Policy")). Cookies are text files that are stored in a computer system via an Internet browser.

Many Internet sites and servers use cookies. Many cookies contain a so-called cookie ID. A cookie ID is a unique identifier of the cookie. It consists of a character string through which Internet pages and servers can be assigned to the specific Internet browser in which the cookie was stored. This allows visited Internet sites and servers to differentiate the individual browser of the data subject from other Internet browsers that contain other cookies. A specific Internet browser can be recognized and identified using the unique cookie ID.

Through the use of cookies, Labs64 GmbH can provide the users of this website with more user-friendly services that would not be possible without the cookie setting.

By means of a cookie, the information and offers on our website can be optimized with the user in mind. Cookies allow us, as previously mentioned, to recognize our website users. The purpose of this recognition is to make it easier for users to utilize our website. The website user that uses cookies, e.g. does not have to enter access data each time the website is accessed, because this is taken over by the website, and the cookie is thus stored on the user’s computer system. Another example is the cookie of a shopping cart in an online shop. The online store remembers the articles that a customer has placed in the virtual shopping cart via a cookie.

The data subject may, at any time, prevent the setting of cookies through our website by means of a corresponding setting of the Internet browser used, and may thus permanently deny the setting of cookies. Furthermore, already set cookies may be deleted at any time via an Internet browser or other software programs. This is possible in all popular Internet browsers. If the data subject deactivates the setting of cookies in the Internet browser used, not all functions of our website may be entirely usable.

### 4\. Collection of general data and information

The website of Labs64 GmbH collects a series of general data and information when a data subject or automated system calls up the website. This general data and information are stored in the server log files. Collected may be (1) the browser types and versions used, (2) the operating system used by the accessing system, (3) the website from which an accessing system reaches our website (so-called referrers), (4) the sub-websites, (5) the date and time of access to the Internet site, (6) an Internet protocol address (IP address), (7) the Internet service provider of the accessing system, and (8) any other similar data and information that may be used in the event of attacks on our information technology systems.

When using these general data and information, Labs64 GmbH does not draw any conclusions about the data subject. Rather, this information is needed to (1) deliver the content of our website correctly, (2) optimize the content of our website as well as its advertisement, (3) ensure the long-term viability of our information technology systems and website technology, and (4) provide law enforcement authorities with the information necessary for criminal prosecution in case of a cyber-attack. Therefore, Labs64 GmbH analyzes anonymously collected data and information statistically, with the aim of increasing the data protection and data security of our enterprise, and to ensure an optimal level of protection for the personal data we process. The anonymous data of the server log files are stored separately from all personal data provided by a data subject.

### 5\. Registration on our website

The data subject has the possibility to register on the website of the controller with the indication of personal data. Which personal data are transmitted to the controller is determined by the respective input mask used for the registration. The personal data entered by the data subject are collected and stored exclusively for internal use by the controller, and for his own purposes. The controller may request transfer to one or more processors (e.g. a parcel service) that also uses personal data for an internal purpose which is attributable to the controller.

By registering on the website of the controller, the IP address assigned by the Internet service provider (ISP) and used by the data subject, date, and time of the registration are also stored. The storage of this data takes place against the background that this is the only way to prevent the misuse of our services, and, if necessary, to make it possible to investigate committed offenses. Insofar, the storage of this data is necessary to secure the controller. This data is not passed on to third parties unless there is a statutory obligation to pass on the data, or if the transfer serves the aim of criminal prosecution.

The registration of the data subject, with the voluntary indication of personal data, is intended to enable the controller to offer the data subject contents or services that may only be offered to registered users due to the nature of the matter in question. Registered persons are free to change the personal data specified during the registration at any time, or to have them completely deleted from the data stock of the controller.

The data controller shall, at any time, provide information upon request to each data subject as to what personal data are stored about the data subject. In addition, the data controller shall correct or erase personal data at the request or indication of the data subject, insofar as there are no statutory storage obligations. A Data Protection Officer particularly designated in this data protection declaration, as well as the entirety of the controller’s employees are available to the data subject in this respect as contact persons.

### 6\. Subscription to our newsletters

On the website of Labs64 GmbH, users are given the opportunity to subscribe to our enterprise’s newsletter. The input mask used for this purpose determines what personal data are transmitted, as well as when the newsletter is ordered from the controller.

Labs64 GmbH informs its customers and business partners regularly by means of a newsletter about enterprise offers. The enterprise’s newsletter may only be received by the data subject if (1) the data subject has a valid e-mail address and (2) the data subject registers for the newsletter shipping. A confirmation e-mail will be sent to the e-mail address registered by a data subject for the first time for newsletter shipping, for legal reasons, in the double opt-in procedure. This confirmation e-mail is used to prove whether the owner of the e-mail address as the data subject is authorized to receive the newsletter.

During the registration for the newsletter, we also store the IP address of the computer system assigned by the Internet service provider (ISP) and used by the data subject at the time of the registration, as well as the date and time of the registration. The collection of this data is necessary in order to understand the (possible) misuse of the e-mail address of a data subject at a later date, and it, therefore, serves the aim of the legal protection of the controller.

The personal data collected as part of a registration for the newsletter will only be used to send our newsletter. In addition, subscribers to the newsletter may be informed by e-mail, as long as this is necessary for the operation of the newsletter service or a registration in question, as this could be the case in the event of modifications to the newsletter offer, or in the event of a change in technical circumstances. There will be no transfer of personal data collected by the newsletter service to third parties. The subscription to our newsletter may be terminated by the data subject at any time. The consent to the storage of personal data, which the data subject has given for shipping the newsletter, may be revoked at any time. For the purpose of revocation of consent, a corresponding link is found in each newsletter. It is also possible to unsubscribe from the newsletter at any time directly on the website of the controller, or to communicate this to the controller in a different way.

### 7\. Newsletter-Tracking

The newsletter of Labs64 GmbH contains so-called tracking pixels. A tracking pixel is a miniature graphic embedded in such e-mails, which are sent in HTML format to enable log file recording and analysis. This allows a statistical analysis of the success or failure of online marketing campaigns. Based on the embedded tracking pixel, Labs64 GmbH may see if and when an e-mail was opened by a data subject, and which links in the e-mail were called up by data subjects.

Such personal data collected in the tracking pixels contained in the newsletters are stored and analyzed by the controller in order to optimize the shipping of the newsletter, as well as to adapt the content of future newsletters even better to the interests of the data subject. These personal data will not be passed on to third parties. Data subjects are at any time entitled to revoke the respective separate declaration of consent issued by means of the double-opt-in procedure. After a revocation, these personal data will be deleted by the controller. Labs64 GmbH automatically regards a withdrawal from the receipt of the newsletter as a revocation.

### 8\. Contact possibility via the website

If you send us a request or contact us via a contact form, email or phone, your details, including your name, company name, email address, phone number, IP address, timestamp and any other information you include in that request, will be automatically collected. We store this information in our CRM in order to improve our services and provide you with the best customer experience. With the submitting your request you give us explicit consent to contact you upon this requests.  
We do not pass this data to third parties without your consent. You can request modification or deletion of this data at any time.

### 9\. Comments function in the blog on the website

Labs64 GmbH offers users the possibility to leave individual comments on individual blog contributions on a blog, which is on the website of the controller. A blog is a web-based, publicly-accessible portal, through which one or more people called bloggers or web-bloggers may post articles or write down thoughts in so-called blogposts. Blogposts may usually be commented by third parties.

If a data subject leaves a comment on the blog published on this website, the comments made by the data subject are also stored and published, as well as information on the date of the commentary and on the user’s (pseudonym) chosen by the data subject. In addition, the IP address assigned by the Internet service provider (ISP) to the data subject is also logged. This storage of the IP address takes place for security reasons, and in case the data subject violates the rights of third parties, or posts illegal content through a given comment. The storage of these personal data is, therefore, in the own interest of the data controller, so that he can exculpate in the event of an infringement. This collected personal data will not be passed to third parties, unless such a transfer is required by law or serves the aim of the defense of the data controller.

### 10\. Routine erasure and blocking of personal data

The data controller shall process and store the personal data of the data subject only for the period necessary to achieve the purpose of storage, or as far as this is granted by the European legislator or other legislators in laws or regulations to which the controller is subject to.

If the storage purpose is not applicable, or if a storage period prescribed by the European legislator or another competent legislator expires, the personal data are routinely blocked or erased in accordance with legal requirements.

### 11\. Rights of the data subject

*   #### a) Right of confirmation
    
    Each data subject shall have the right granted by the European legislator to obtain from the controller the confirmation as to whether or not personal data concerning him or her are being processed. If a data subject wishes to avail himself of this right of confirmation, he or she may, at any time, contact our Data Protection Officer or another employee of the controller.
    
*   #### b) Right of access
    
    Each data subject shall have the right granted by the European legislator to obtain from the controller free information about his or her personal data stored at any time and a copy of this information. Furthermore, the European directives and regulations grant the data subject access to the following information:
    
    *   the purposes of the processing;
    *   the categories of personal data concerned;
    *   the recipients or categories of recipients to whom the personal data have been or will be disclosed, in particular recipients in third countries or international organisations;
    *   where possible, the envisaged period for which the personal data will be stored, or, if not possible, the criteria used to determine that period;
    *   the existence of the right to request from the controller rectification or erasure of personal data, or restriction of processing of personal data concerning the data subject, or to object to such processing;
    *   the existence of the right to lodge a complaint with a supervisory authority;
    *   where the personal data are not collected from the data subject, any available information as to their source;
    *   the existence of automated decision-making, including profiling, referred to in Article 22(1) and (4) of the GDPR and, at least in those cases, meaningful information about the logic involved, as well as the significance and envisaged consequences of such processing for the data subject.
    
    Furthermore, the data subject shall have a right to obtain information as to whether personal data are transferred to a third country or to an international organisation. Where this is the case, the data subject shall have the right to be informed of the appropriate safeguards relating to the transfer.
    
    If a data subject wishes to avail himself of this right of access, he or she may at any time contact our Data Protection Officer or another employee of the controller.
    
*   #### c) Right to rectification
    
    Each data subject shall have the right granted by the European legislator to obtain from the controller without undue delay the rectification of inaccurate personal data concerning him or her. Taking into account the purposes of the processing, the data subject shall have the right to have incomplete personal data completed, including by means of providing a supplementary statement.
    
    If a data subject wishes to exercise this right to rectification, he or she may, at any time, contact our Data Protection Officer or another employee of the controller.
    
*   #### d) Right to erasure (Right to be forgotten)
    
    Each data subject shall have the right granted by the European legislator to obtain from the controller the erasure of personal data concerning him or her without undue delay, and the controller shall have the obligation to erase personal data without undue delay where one of the following grounds applies, as long as the processing is not necessary:
    
    *   The personal data are no longer necessary in relation to the purposes for which they were collected or otherwise processed.
    *   The data subject withdraws consent to which the processing is based according to point (a) of Article 6(1) of the GDPR, or point (a) of Article 9(2) of the GDPR, and where there is no other legal ground for the processing.
    *   The data subject objects to the processing pursuant to Article 21(1) of the GDPR and there are no overriding legitimate grounds for the processing, or the data subject objects to the processing pursuant to Article 21(2) of the GDPR.
    *   The personal data have been unlawfully processed.
    *   The personal data must be erased for compliance with a legal obligation in Union or Member State law to which the controller is subject.
    *   The personal data have been collected in relation to the offer of information society services referred to in Article 8(1) of the GDPR.
    
    If one of the aforementioned reasons applies, and a data subject wishes to request the erasure of personal data stored by Labs64 GmbH, he or she may at any time contact our Data Protection Officer or another employee of the controller. The Data Protection Officer of Labs64 GmbH or another employee shall promptly ensure that the erasure request is complied with immediately.
    
    Where the controller has made personal data public and is obliged pursuant to Article 17(1) to erase the personal data, the controller, taking account of available technology and the cost of implementation, shall take reasonable steps, including technical measures, to inform other controllers processing the personal data that the data subject has requested erasure by such controllers of any links to, or copy or replication of, those personal data, as far as processing is not required. The Data Protection Officer of Labs64 GmbH or another employee will arrange the necessary measures in individual cases.
    
*   #### e) Right of restriction of processing
    
    Each data subject shall have the right granted by the European legislator to obtain from the controller restriction of processing where one of the following applies:
    
    *   The accuracy of the personal data is contested by the data subject, for a period enabling the controller to verify the accuracy of the personal data.
    *   The processing is unlawful and the data subject opposes the erasure of the personal data and requests instead the restriction of their use instead.
    *   The controller no longer needs the personal data for the purposes of the processing, but they are required by the data subject for the establishment, exercise or defence of legal claims.
    *   The data subject has objected to processing pursuant to Article 21(1) of the GDPR pending the verification whether the legitimate grounds of the controller override those of the data subject.
    
    If one of the aforementioned conditions is met, and a data subject wishes to request the restriction of the processing of personal data stored by Labs64 GmbH, he or she may at any time contact our Data Protection Officer or another employee of the controller. The Data Protection Officer of Labs64 GmbH or another employee will arrange the restriction of the processing.
    
*   #### f) Right to data portability
    
    Each data subject shall have the right granted by the European legislator, to receive the personal data concerning him or her, which was provided to a controller, in a structured, commonly used and machine-readable format. He or she shall have the right to transmit those data to another controller without hindrance from the controller to which the personal data have been provided, as long as the processing is based on consent pursuant to point (a) of Article 6(1) of the GDPR or point (a) of Article 9(2) of the GDPR, or on a contract pursuant to point (b) of Article 6(1) of the GDPR, and the processing is carried out by automated means, as long as the processing is not necessary for the performance of a task carried out in the public interest or in the exercise of official authority vested in the controller.
    
    Furthermore, in exercising his or her right to data portability pursuant to Article 20(1) of the GDPR, the data subject shall have the right to have personal data transmitted directly from one controller to another, where technically feasible and when doing so does not adversely affect the rights and freedoms of others.
    
    In order to assert the right to data portability, the data subject may at any time contact the Data Protection Officer designated by Labs64 GmbH or another employee.
    
*   #### g) Right to object
    
    Each data subject shall have the right granted by the European legislator to object, on grounds relating to his or her particular situation, at any time, to processing of personal data concerning him or her, which is based on point (e) or (f) of Article 6(1) of the GDPR. This also applies to profiling based on these provisions.
    
    Labs64 GmbH shall no longer process the personal data in the event of the objection, unless we can demonstrate compelling legitimate grounds for the processing which override the interests, rights and freedoms of the data subject, or for the establishment, exercise or defence of legal claims.
    
    If Labs64 GmbH processes personal data for direct marketing purposes, the data subject shall have the right to object at any time to processing of personal data concerning him or her for such marketing. This applies to profiling to the extent that it is related to such direct marketing. If the data subject objects to Labs64 GmbH to the processing for direct marketing purposes, Labs64 GmbH will no longer process the personal data for these purposes.
    
    In addition, the data subject has the right, on grounds relating to his or her particular situation, to object to processing of personal data concerning him or her by Labs64 GmbH for scientific or historical research purposes, or for statistical purposes pursuant to Article 89(1) of the GDPR, unless the processing is necessary for the performance of a task carried out for reasons of public interest.
    
    In order to exercise the right to object, the data subject may directly contact the Data Protection Officer of Labs64 GmbH or another employee. In addition, the data subject is free in the context of the use of information society services, and notwithstanding Directive 2002/58/EC, to use his or her right to object by automated means using technical specifications.
    
*   #### h) Automated individual decision-making, including profiling
    
    Each data subject shall have the right granted by the European legislator not to be subject to a decision based solely on automated processing, including profiling, which produces legal effects concerning him or her, or similarly significantly affects him or her, as long as the decision (1) is not is necessary for entering into, or the performance of, a contract between the data subject and a data controller, or (2) is not authorised by Union or Member State law to which the controller is subject and which also lays down suitable measures to safeguard the data subject’s rights and freedoms and legitimate interests, or (3) is not based on the data subject’s explicit consent.
    
    If the decision (1) is necessary for entering into, or the performance of, a contract between the data subject and a data controller, or (2) it is based on the data subject’s explicit consent, Labs64 GmbH shall implement suitable measures to safeguard the data subject’s rights and freedoms and legitimate interests, at least the right to obtain human intervention on the part of the controller, to express his or her point of view and contest the decision.
    
    If the data subject wishes to exercise the rights concerning automated individual decision-making, he or she may at any time directly contact our Data Protection Officer of Labs64 GmbH or another employee of the controller.
    
*   #### i) Right to withdraw data protection consent
    
    Each data subject shall have the right granted by the European legislator to withdraw his or her consent to processing of his or her personal data at any time.
    
    f the data subject wishes to exercise the right to withdraw the consent, he or she may at any time directly contact our Data Protection Officer of Labs64 GmbH or another employee of the controller.
    

### 12\. Data protection for applications and the application procedures

The data controller shall collect and process the personal data of applicants for the purpose of the processing of the application procedure. The processing may also be carried out electronically. This is the case, in particular, if an applicant submits corresponding application documents by e-mail or by means of a web form on the website to the controller. If the data controller concludes an employment contract with an applicant, the submitted data will be stored for the purpose of processing the employment relationship in compliance with legal requirements. If no employment contract is concluded with the applicant by the controller, the application documents shall be automatically erased two months after notification of the refusal decision, provided that no other legitimate interests of the controller are opposed to the erasure. Other legitimate interest in this relation is, e.g. a burden of proof in a procedure under the General Equal Treatment Act (AGG).

### 13\. Data Protection provisions about the application and use of AddThis

On this website, the data controller has integrated components of the enterprise AddThis. AddThis is a so-called bookmarking provider. The service allows for simplified bookmarking of Internet pages via buttons. By clicking on the AddThis component with the mouse, or by clicking on it, a list of bookmarking and sharing services is displayed. AddThis is used on over 15 million websites, and the buttons are displayed, according to the information of the operating enterprise, over 20 billion times a year.

The operating company of AddThis is AddThis, Inc. 1595 Spring Hill Road, Suite 300, Vienna, VA 22182, United States.

By calling up one of the individual pages of the website, which is operated by the controller, and on which an AddThis component has been integrated, the Internet browser of the data subject is automatically prompted by the respective AddThis component to download data from the website www.addthis.com. Within the framework of this technical procedure, AddThis is informed of the visit and the specific individual page of this website that was used by the data subject with the help of information technology. In addition, AddThis is informed about the IP address of the computer system assigned by the Internet service provider (ISP) and used by the data subject, the browser type and language, the web page accessed before our website, the date and the time of the visit to our website. AddThis uses this data to create anonymous user profiles. The data and information transmitted to AddThis in this way will enable the enterprise AddThis, as well as affiliates or their partner-enterprises, to contact visitors of the web pages of the controller with personalized and interest-based advertising.

AddThis displays personalized and interest-based advertising on the basis of a cookie set by the enterprise. This cookie analyzes the individual surfing behavior of the computer system used by the data subject. The cookie saves the computer-based outgoing visits to Internet pages.

The data subject may, at any time, prevent the setting of cookies through our website by means of a corresponding setting of the Internet browser used, and thus permanently deny the setting of cookies. Such a setting of the Internet browser used would also prevent AddThis from setting a cookie on the information technology system of the data subject. Cookies may also be deleted by AddThis at any time via an Internet browser or other software programs.

The data subject also has the possibility of objecting permanently to the processing of personal data by AddThis. For this purpose, the data subject must click on the opt-out button under the link https://www.addthis.com/privacy/opt-out, which sets an opt-out cookie. The opt-out cookie used for this purpose is placed on the information technology system used by the data subject. If the data subject deletes the cookies from his system, then the data subject must call up the link again and set a new opt-out cookie.

With the setting of the opt-out cookie, however, the possibility exists that the websites of the controller are not fully usable anymore by the data subject.

The applicable data protection provisions of AddThis may be accessed under https://www.addthis.com/privacy/privacy-policy.

### 14\. Data protection provisions about the application and use of Facebook

On this website, the controller has integrated components of the enterprise Facebook. Facebook is a social network.

A social network is a place for social meetings on the Internet, an online community, which usually allows users to communicate with each other and interact in a virtual space. A social network may serve as a platform for the exchange of opinions and experiences, or enable the Internet community to provide personal or business-related information. Facebook allows social network users to include the creation of private profiles, upload photos, and network through friend requests.

The operating company of Facebook is Facebook, Inc., 1 Hacker Way, Menlo Park, CA 94025, United States. If a person lives outside of the United States or Canada, the controller is the Facebook Ireland Ltd., 4 Grand Canal Square, Grand Canal Harbour, Dublin 2, Ireland.

With each call-up to one of the individual pages of this Internet website, which is operated by the controller and into which a Facebook component (Facebook plug-ins) was integrated, the web browser on the information technology system of the data subject is automatically prompted to download display of the corresponding Facebook component from Facebook through the Facebook component. An overview of all the Facebook Plug-ins may be accessed under https://developers.facebook.com/docs/plugins/. During the course of this technical procedure, Facebook is made aware of what specific sub-site of our website was visited by the data subject.

If the data subject is logged in at the same time on Facebook, Facebook detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-site of our Internet page was visited by the data subject. This information is collected through the Facebook component and associated with the respective Facebook account of the data subject. If the data subject clicks on one of the Facebook buttons integrated into our website, e.g. the “Like” button, or if the data subject submits a comment, then Facebook matches this information with the personal Facebook user account of the data subject and stores the personal data.

Facebook always receives, through the Facebook component, information about a visit to our website by the data subject, whenever the data subject is logged in at the same time on Facebook during the time of the call-up to our website. This occurs regardless of whether the data subject clicks on the Facebook component or not. If such a transmission of information to Facebook is not desirable for the data subject, then he or she may prevent this by logging off from their Facebook account before a call-up to our website is made.

The data protection guideline published by Facebook, which is available at https://facebook.com/about/privacy/, provides information about the collection, processing and use of personal data by Facebook. In addition, it is explained there what setting options Facebook offers to protect the privacy of the data subject. In addition, different configuration options are made available to allow the elimination of data transmission to Facebook. These applications may be used by the data subject to eliminate a data transmission to Facebook.

### 15\. Data protection provisions about the application and use of Google Analytics (with anonymization function)

On this website, the controller has integrated the component of Google Analytics (with the anonymizer function). Google Analytics is a web analytics service. Web analytics is the collection, gathering, and analysis of data about the behavior of visitors to websites. A web analysis service collects, inter alia, data about the website from which a person has come (the so-called referrer), which sub-pages were visited, or how often and for what duration a sub-page was viewed. Web analytics are mainly used for the optimization of a website and in order to carry out a cost-benefit analysis of Internet advertising.

The operator of the Google Analytics component is Google Inc., 1600 Amphitheatre Pkwy, Mountain View, CA 94043-1351, United States.

For the web analytics through Google Analytics the controller uses the application “\_gat. \_anonymizeIp”. By means of this application the IP address of the Internet connection of the data subject is abridged by Google and anonymised when accessing our websites from a Member State of the European Union or another Contracting State to the Agreement on the European Economic Area.

The purpose of the Google Analytics component is to analyze the traffic on our website. Google uses the collected data and information, inter alia, to evaluate the use of our website and to provide online reports, which show the activities on our websites, and to provide other services concerning the use of our Internet site for us.

Google Analytics places a cookie on the information technology system of the data subject. The definition of cookies is explained above. With the setting of the cookie, Google is enabled to analyze the use of our website. With each call-up to one of the individual pages of this Internet site, which is operated by the controller and into which a Google Analytics component was integrated, the Internet browser on the information technology system of the data subject will automatically submit data through the Google Analytics component for the purpose of online advertising and the settlement of commissions to Google. During the course of this technical procedure, the enterprise Google gains knowledge of personal information, such as the IP address of the data subject, which serves Google, inter alia, to understand the origin of visitors and clicks, and subsequently create commission settlements.

The cookie is used to store personal information, such as the access time, the location from which the access was made, and the frequency of visits of our website by the data subject. With each visit to our Internet site, such personal data, including the IP address of the Internet access used by the data subject, will be transmitted to Google in the United States of America. These personal data are stored by Google in the United States of America. Google may pass these personal data collected through the technical procedure to third parties.

The data subject may, as stated above, prevent the setting of cookies through our website at any time by means of a corresponding adjustment of the web browser used and thus permanently deny the setting of cookies. Such an adjustment to the Internet browser used would also prevent Google Analytics from setting a cookie on the information technology system of the data subject. In addition, cookies already in use by Google Analytics may be deleted at any time via a web browser or other software programs.

In addition, the data subject has the possibility of objecting to a collection of data that are generated by Google Analytics, which is related to the use of this website, as well as the processing of this data by Google and the chance to preclude any such. For this purpose, the data subject must download a browser add-on under the link https://tools.google.com/dlpage/gaoptout and install it. This browser add-on tells Google Analytics through a JavaScript, that any data and information about the visits of Internet pages may not be transmitted to Google Analytics. The installation of the browser add-ons is considered an objection by Google. If the information technology system of the data subject is later deleted, formatted, or newly installed, then the data subject must reinstall the browser add-ons to disable Google Analytics. If the browser add-on was uninstalled by the data subject or any other person who is attributable to their sphere of competence, or is disabled, it is possible to execute the reinstallation or reactivation of the browser add-ons.

Further information and the applicable data protection provisions of Google may be retrieved under https://www.google.com/intl/en/policies/privacy/ and under https://www.google.com/analytics/terms/us.html. Google Analytics is further explained under the following Link https://www.google.com/analytics/.

### 16\. Data protection provisions about the application and use of Google Remarketing

On this website, the controller has integrated Google Remarketing services. Google Remarketing is a feature of Google AdWords, which allows an enterprise to display advertising to Internet users who have previously resided on the enterprise’s Internet site. The integration of Google Remarketing therefore allows an enterprise to create user-based advertising and thus shows relevant advertisements to interested Internet users.

The operating company of the Google Remarketing services is the Google Inc., 1600 Amphitheatre Pkwy, Mountain View, CA 94043-1351, United States.

The purpose of Google Remarketing is the insertion of interest-relevant advertising. Google Remarketing allows us to display ads on the Google network or on other websites, which are based on individual needs and matched to the interests of Internet users.

Google Remarketing sets a cookie on the information technology system of the data subject. The definition of cookies is explained above. With the setting of the cookie, Google enables a recognition of the visitor of our website if he calls up consecutive web pages, which are also a member of the Google advertising network. With each call-up to an Internet site on which the service has been integrated by Google Remarketing, the web browser of the data subject identifies automatically with Google. During the course of this technical procedure, Google receives personal information, such as the IP address or the surfing behaviour of the user, which Google uses, inter alia, for the insertion of interest relevant advertising.

The cookie is used to store personal information, e.g. the Internet pages visited by the data subject. Each time we visit our Internet pages, personal data, including the IP address of the Internet access used by the data subject, is transmitted to Google in the United States of America. These personal data are stored by Google in the United States of America. Google may pass these personal data collected through the technical procedure to third parties.

The data subject may, as stated above, prevent the setting of cookies through our website at any time by means of a corresponding adjustment of the web browser used and thus permanently deny the setting of cookies. Such an adjustment to the Internet browser used would also prevent Google from setting a cookie on the information technology system of the data subject. In addition, cookies already in use by Google may be deleted at any time via a web browser or other software programs.

In addition, the data subject has the possibility of objecting to the interest-based advertising by Google. For this purpose, the data subject must call up the link to www.google.de/settings/ads and make the desired settings on each Internet browser used by the data subject.

Further information and the actual data protection provisions of Google may be retrieved under https://www.google.com/intl/en/policies/privacy/.

### 17\. Data protection provisions about the application and use of Google+

On this website, the controller has integrated the Google+ button as a component. Google+ is a so-called social network. A social network is a social meeting place on the Internet, an online community, which usually allows users to communicate with each other and interact in a virtual space. A social network may serve as a platform for the exchange of opinions and experiences, or enable the Internet community to provide personal or business-related information. Google+ allows users of the social network to include the creation of private profiles, upload photos and network through friend requests.

The operating company of Google+ is Google Inc., 1600 Amphitheatre Pkwy, Mountain View, CA 94043-1351, UNITED STATES.

With each call-up to one of the individual pages of this website, which is operated by the controller and on which a Google+ button has been integrated, the Internet browser on the information technology system of the data subject automatically downloads a display of the corresponding Google+ button of Google through the respective Google+ button component. During the course of this technical procedure, Google is made aware of what specific sub-page of our website was visited by the data subject. More detailed information about Google+ is available under https://developers.google.com/+/.

If the data subject is logged in at the same time to Google+, Google recognizes with each call-up to our website by the data subject and for the entire duration of his or her stay on our Internet site, which specific sub-pages of our Internet page were visited by the data subject. This information is collected through the Google+ button and Google matches this with the respective Google+ account associated with the data subject.

If the data subject clicks on the Google+ button integrated on our website and thus gives a Google+ 1 recommendation, then Google assigns this information to the personal Google+ user account of the data subject and stores the personal data. Google stores the Google+ 1 recommendation of the data subject, making it publicly available in accordance with the terms and conditions accepted by the data subject in this regard. Subsequently, a Google+ 1 recommendation given by the data subject on this website together with other personal data, such as the Google+ account name used by the data subject and the stored photo, is stored and processed on other Google services, such as search-engine results of the Google search engine, the Google account of the data subject or in other places, e.g. on Internet pages, or in relation to advertisements. Google is also able to link the visit to this website with other personal data stored on Google. Google further records this personal information with the purpose of improving or optimizing the various Google services.

Through the Google+ button, Google receives information that the data subject visited our website, if the data subject at the time of the call-up to our website is logged in to Google+. This occurs regardless of whether the data subject clicks or doesn’t click on the Google+ button.

If the data subject does not wish to transmit personal data to Google, he or she may prevent such transmission by logging out of his Google+ account before calling up our website.

Further information and the data protection provisions of Google may be retrieved under https://www.google.com/intl/en/policies/privacy/. More references from Google about the Google+ 1 button may be obtained under https://developers.google.com/+/web/buttons-policy.

### 18\. Data protection provisions about the application and use of Google-AdWords

On this website, the controller has integrated Google AdWords. Google AdWords is a service for Internet advertising that allows the advertiser to place ads in Google search engine results and the Google advertising network. Google AdWords allows an advertiser to pre-define specific keywords with the help of which an ad on Google’s search results only then displayed, when the user utilizes the search engine to retrieve a keyword-relevant search result. In the Google Advertising Network, the ads are distributed on relevant web pages using an automatic algorithm, taking into account the previously defined keywords.

The operating company of Google AdWords is Google Inc., 1600 Amphitheatre Pkwy, Mountain View, CA 94043-1351, UNITED STATES.

The purpose of Google AdWords is the promotion of our website by the inclusion of relevant advertising on the websites of third parties and in the search engine results of the search engine Google and an insertion of third-party advertising on our website.

If a data subject reaches our website via a Google ad, a conversion cookie is filed on the information technology system of the data subject through Google. The definition of cookies is explained above. A conversion cookie loses its validity after 30 days and is not used to identify the data subject. If the cookie has not expired, the conversion cookie is used to check whether certain sub-pages, e.g, the shopping cart from an online shop system, were called up on our website. Through the conversion cookie, both Google and the controller can understand whether a person who reached an AdWords ad on our website generated sales, that is, executed or canceled a sale of goods.

The data and information collected through the use of the conversion cookie is used by Google to create visit statistics for our website. These visit statistics are used in order to determine the total number of users who have been served through AdWords ads to ascertain the success or failure of each AdWords ad and to optimize our AdWords ads in the future. Neither our company nor other Google AdWords advertisers receive information from Google that could identify the data subject.

The conversion cookie stores personal information, e.g. the Internet pages visited by the data subject. Each time we visit our Internet pages, personal data, including the IP address of the Internet access used by the data subject, is transmitted to Google in the United States of America. These personal data are stored by Google in the United States of America. Google may pass these personal data collected through the technical procedure to third parties.

The data subject may, at any time, prevent the setting of cookies by our website, as stated above, by means of a corresponding setting of the Internet browser used and thus permanently deny the setting of cookies. Such a setting of the Internet browser used would also prevent Google from placing a conversion cookie on the information technology system of the data subject. In addition, a cookie set by Google AdWords may be deleted at any time via the Internet browser or other software programs.

The data subject has a possibility of objecting to the interest based advertisement of Google. Therefore, the data subject must access from each of the browsers in use the link www.google.de/settings/ads and set the desired settings.

Further information and the applicable data protection provisions of Google may be retrieved under https://www.google.com/intl/en/policies/privacy/.

### 19\. Data protection provisions about the application and use of Instagram

On this website, the controller has integrated components of the service Instagram. Instagram is a service that may be qualified as an audiovisual platform, which allows users to share photos and videos, as well as disseminate such data in other social networks.

The operating company of the services offered by Instagram is Instagram LLC, 1 Hacker Way, Building 14 First Floor, Menlo Park, CA, UNITED STATES.

With each call-up to one of the individual pages of this Internet site, which is operated by the controller and on which an Instagram component (Insta button) was integrated, the Internet browser on the information technology system of the data subject is automatically prompted to the download of a display of the corresponding Instagram component of Instagram. During the course of this technical procedure, Instagram becomes aware of what specific sub-page of our website was visited by the data subject.

If the data subject is logged in at the same time on Instagram, Instagram detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-page of our Internet page was visited by the data subject. This information is collected through the Instagram component and is associated with the respective Instagram account of the data subject. If the data subject clicks on one of the Instagram buttons integrated on our website, then Instagram matches this information with the personal Instagram user account of the data subject and stores the personal data.

Instagram receives information via the Instagram component that the data subject has visited our website provided that the data subject is logged in at Instagram at the time of the call to our website. This occurs regardless of whether the person clicks on the Instagram button or not. If such a transmission of information to Instagram is not desirable for the data subject, then he or she can prevent this by logging off from their Instagram account before a call-up to our website is made.

Further information and the applicable data protection provisions of Instagram may be retrieved under https://help.instagram.com/155833707900388 and https://www.instagram.com/about/legal/privacy/.

### 20\. Data protection provisions about the application and use of LinkedIn

The controller has integrated components of the LinkedIn Corporation on this website. LinkedIn is a web-based social network that enables users with existing business contacts to connect and to make new business contacts. Over 400 million registered people in more than 200 countries use LinkedIn. Thus, LinkedIn is currently the largest platform for business contacts and one of the most visited websites in the world.

The operating company of LinkedIn is LinkedIn Corporation, 2029 Stierlin Court Mountain View, CA 94043, UNITED STATES. For privacy matters outside of the UNITED STATES LinkedIn Ireland, Privacy Policy Issues, Wilton Plaza, Wilton Place, Dublin 2, Ireland, is responsible.

With each call-up to one of the individual pages of this Internet site, which is operated by the controller and on which a LinkedIn component (LinkedIn plug-in) was integrated, the Internet browser on the information technology system of the data subject is automatically prompted to the download of a display of the corresponding LinkedIn component of LinkedIn. Further information about the LinkedIn plug-in may be accessed under https://developer.linkedin.com/plugins. During the course of this technical procedure, LinkedIn gains knowledge of what specific sub-page of our website was visited by the data subject.

If the data subject is logged in at the same time on LinkedIn, LinkedIn detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-page of our Internet page was visited by the data subject. This information is collected through the LinkedIn component and associated with the respective LinkedIn account of the data subject. If the data subject clicks on one of the LinkedIn buttons integrated on our website, then LinkedIn assigns this information to the personal LinkedIn user account of the data subject and stores the personal data.

LinkedIn receives information via the LinkedIn component that the data subject has visited our website, provided that the data subject is logged in at LinkedIn at the time of the call-up to our website. This occurs regardless of whether the person clicks on the LinkedIn button or not. If such a transmission of information to LinkedIn is not desirable for the data subject, then he or she may prevent this by logging off from their LinkedIn account before a call-up to our website is made.

LinkedIn provides under https://www.linkedin.com/psettings/guest-controls the possibility to unsubscribe from e-mail messages, SMS messages and targeted ads, as well as the ability to manage ad settings. LinkedIn also uses affiliates such as Eire, Google Analytics, BlueKai, DoubleClick, Nielsen, Comscore, Eloqua, and Lotame. The setting of such cookies may be denied under https://www.linkedin.com/legal/cookie-policy. The applicable privacy policy for LinkedIn is available under https://www.linkedin.com/legal/privacy-policy. The LinkedIn Cookie Policy is available under https://www.linkedin.com/legal/cookie-policy.

### 21\. Data protection provisions about the application and use of Pinterest

On this website, the controller has integrated components of Pinterest Inc. Pinterest is a so-called social network. A social network is an Internet social meeting place, an online community that allows users to communicate and interact with each other in a virtual space. A social network may serve as a platform for the exchange of opinions and experiences, or allow the Internet community to provide personal or company-related information. Pinterest enables the users of the social network to publish, inter alia, picture collections and individual pictures as well as descriptions on virtual pinboards (so-called pins), which can then be shared by other user’s (so-called re-pins) or commented on.

The operating company of Pinterest is Pinterest Inc., 808 Brannan Street, San Francisco, CA 94103, UNITED STATES.

With each call-up to one of the individual pages of this Internet site, which is operated by the controller and on which a Pinterest component (Pinterest plug-in) was integrated, the Internet browser on the information technology system of the data subject automatically prompted to download through the respective Pinterest component a display of the corresponding Pinterest component. Further information on Pinterest is available under https://pinterest.com/. During the course of this technical procedure, Pinterest gains knowledge of what specific sub-page of our website is visited by the data subject.

If the data subject is logged in at the same time on Pinterest, Pinterest detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-page of our Internet page was visited by the data subject. This information is collected through the Pinterest component and associated with the respective Pinterest account of the data subject. If the data subject clicks on one of the Pinterest buttons, integrated on our website, then Pinterest assigns this information to the personal Pinterest user account of the data subject and stores the personal data.

Pinterest receives information via the Pinterest component that the data subject has visited our website, provided that the data subject is logged in at Pinterest at the time of the call-up to our website. This occurs regardless of whether the person clicks on the Pinterest component or not. If such a transmission of information to Pinterest is not desirable for the data subject, then he or she may prevent this by logging off from their Pinterest account before a call-up to our website is made.

The data protection guideline published by Pinterest, which is available under https://about.pinterest.com/privacy-policy, provides information on the collection, processing and use of personal data by Pinterest.

### 22\. Data protection provisions about the application and use of Shariff

On this website, the controller has integrated the component of Shariff. The Shariff component provides social media buttons that are compliant with data protection. Shariff was developed for the German computer magazine c’t and is published by GitHub, Inc.

The developers of the component is GitHub, Inc. 88 Colin P. Kelly Junior Street, San Francisco, CA 94107, United States.

Typically, the button solutions provided by the social networks already transmits personal data to the respective social network, when a user visits a website in which a social media button was integrated. By using the Shariff component, personal data is only transferred to social networks, when the visitor actively activates one of the social media buttons. Further information on the Shariff component may be found in the computer magazine c’t under https://www.heise.de/newsticker/meldung/Datenschutz-und-Social-Media-Der-ct-Shariff-ist-im-Usatz-2470103. Html provided. The use of the Shariff component is intended to protect the personal data of the visitors of our website and to enable us to integrate a button solution for social networks on this website.

Further information and the applicable data protection provisions of GitHub are retrievable under https://help.github.com/articles/github-privacy-policy/.

### 23\. Data protection provisions about the application and use of Tumblr

On this website, the controller has integrated components of Tumblr. Tumblr is a platform that allows users to create and run a blog. A blog is a web-based, generally publicly-accessible portal on which one or more people called bloggers or web bloggers may post articles or write down thoughts in so-called blogposts. For example, in a Tumblr blog the user can publish text, images, links, and videos, and spread them in the digital space. Furthermore, Tumblr users may import content from other websites into their own blog.

The operating company of Tumblr is Tumblr, Inc., 35 East 21st St, Ground Floor, New York, NY 10010, UNITED STATES.

Through each call to one of the individual pages of this Internet site, which is operated by the controller and on which a Tumblr component (Tumblr button) has been integrated, the Internet browser on the information technology system of the data subject causes automatically the download of a display of the corresponding Tumblr component of Tumblr. Learn more about the Tumblr-buttons that are available under https://www.tumblr.com/buttons. During the course of this technical procedure, Tumblr becomes aware of what concrete sub-page of our website was visited by the data subject. The purpose of the integration of the Tumblr component is a retransmission of the contents of this website to allow our users to introduce this web page to the digital world and to increase our visitor numbers.

If the data subject is logged in at Tumblr, Tumblr detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-page of our Internet page was visited by the data subject. This information is collected through the Tumblr component and associated with the respective Tumblr account of the data subject. If the data subject clicks on one of the Tumblr buttons, integrated on our website, then Tumblr assigns this information to the personal Tumblr user account of the data subject and stores the personal data.

Tumblr receives information via the Tumblr component that the data subject has visited our website, provided that the data subject is logged in at Tumblr at the time of the call-up to our website. This occurs regardless of whether the person clicks on the Tumblr component or not. If such a transfer of information to Tumblr is not desirable for the data subject, then he or she may prevent this by logging off from their Tumblr account before a call-up to our website is made.

The applicable data protection provisions of Tumblr may be accessed under https://www.tumblr.com/policy/en/privacy.

### 24\. Data protection provisions about the application and use of Twitter

On this website, the controller has integrated components of Twitter. Twitter is a multilingual, publicly-accessible microblogging service on which users may publish and spread so-called tweets, e.g. short messages, which are limited to 140 characters. These short messages are available for everyone, including those who are not logged on to Twitter. The tweets are also displayed to so-called followers of the respective user. Followers are other Twitter users who follow a user’s tweets. Furthermore, Twitter allows you to address a wide audience via hashtags, links or retweets.

The operating company of Twitter is Twitter, Inc., 1355 Market Street, Suite 900, San Francisco, CA 94103, UNITED STATES.

With each call-up to one of the individual pages of this Internet site, which is operated by the controller and on which a Twitter component (Twitter button) was integrated, the Internet browser on the information technology system of the data subject is automatically prompted to download a display of the corresponding Twitter component of Twitter. Further information about the Twitter buttons is available under https://about.twitter.com/de/resources/buttons. During the course of this technical procedure, Twitter gains knowledge of what specific sub-page of our website was visited by the data subject. The purpose of the integration of the Twitter component is a retransmission of the contents of this website to allow our users to introduce this web page to the digital world and increase our visitor numbers.

If the data subject is logged in at the same time on Twitter, Twitter detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-page of our Internet page was visited by the data subject. This information is collected through the Twitter component and associated with the respective Twitter account of the data subject. If the data subject clicks on one of the Twitter buttons integrated on our website, then Twitter assigns this information to the personal Twitter user account of the data subject and stores the personal data.

Twitter receives information via the Twitter component that the data subject has visited our website, provided that the data subject is logged in on Twitter at the time of the call-up to our website. This occurs regardless of whether the person clicks on the Twitter component or not. If such a transmission of information to Twitter is not desirable for the data subject, then he or she may prevent this by logging off from their Twitter account before a call-up to our website is made.

The applicable data protection provisions of Twitter may be accessed under https://twitter.com/privacy?lang=en.

### 25\. Data protection provisions about the application and use of Xing

On this website, the controller has integrated components of XING. XING is an Internet-based social network that enables users to connect with existing business contacts and to create new business contacts. The individual users can create a personal profile of themselves at XING. Companies may, e.g. create company profiles or publish jobs on XING.

The operating company of XING is XING SE, DammtorstraÃŸe 30, 20354 Hamburg, Germany.

With each call-up to one of the individual pages of this Internet site, which is operated by the controller and on which a XING component (XING plug-in) was integrated, the Internet browser on the information technology system of the data subject is automatically prompted to download a display of the corresponding XING component of XING. Further information about the XING plug-in the may be accessed under https://dev.xing.com/plugins. During the course of this technical procedure, XING gains knowledge of what specific sub-page of our website was visited by the data subject.

If the data subject is logged in at the same time on XING, XING detects with every call-up to our website by the data subject and for the entire duration of their stay on our Internet site which specific sub-page of our Internet page was visited by the data subject. This information is collected through the XING component and associated with the respective XING account of the data subject. If the data subject clicks on the XING button integrated on our Internet site, e.g. the “Share”-button, then XING assigns this information to the personal XING user account of the data subject and stores the personal data.

XING receives information via the XING component that the data subject has visited our website, provided that the data subject is logged in at XING at the time of the call to our website. This occurs regardless of whether the person clicks on the XING component or not. If such a transmission of information to XING is not desirable for the data subject, then he or she can prevent this by logging off from their XING account before a call-up to our website is made.

The data protection provisions published by XING, which is available under https://www.xing.com/privacy, provide information on the collection, processing and use of personal data by XING. In addition, XING has published privacy notices for the XING share button under https://www.xing.com/app/share?op=data\_protection.

### 26\. Data protection provisions about the application and use of YouTube

On this website, the controller has integrated components of YouTube. YouTube is an Internet video portal that enables video publishers to set video clips and other users free of charge, which also provides free viewing, review and commenting on them. YouTube allows you to publish all kinds of videos, so you can access both full movies and TV broadcasts, as well as music videos, trailers, and videos made by users via the Internet portal.

The operating company of YouTube is YouTube, LLC, 901 Cherry Ave., San Bruno, CA 94066, UNITED STATES. The YouTube, LLC is a subsidiary of Google Inc., 1600 Amphitheatre Pkwy, Mountain View, CA 94043-1351, UNITED STATES.

With each call-up to one of the individual pages of this Internet site, which is operated by the controller and on which a YouTube component (YouTube video) was integrated, the Internet browser on the information technology system of the data subject is automatically prompted to download a display of the corresponding YouTube component. Further information about YouTube may be obtained under https://www.youtube.com/yt/about/en/. During the course of this technical procedure, YouTube and Google gain knowledge of what specific sub-page of our website was visited by the data subject.

If the data subject is logged in on YouTube, YouTube recognizes with each call-up to a sub-page that contains a YouTube video, which specific sub-page of our Internet site was visited by the data subject. This information is collected by YouTube and Google and assigned to the respective YouTube account of the data subject.

YouTube and Google will receive information through the YouTube component that the data subject has visited our website, if the data subject at the time of the call to our website is logged in on YouTube; this occurs regardless of whether the person clicks on a YouTube video or not. If such a transmission of this information to YouTube and Google is not desirable for the data subject, the delivery may be prevented if the data subject logs off from their own YouTube account before a call-up to our website is made.

YouTube’s data protection provisions, available at https://www.google.com/intl/en/policies/privacy/, provide information about the collection, processing and use of personal data by YouTube and Google.

### 27\. Payment Method: Data protection provisions about the use of PayPal as a payment processor

On this website, the controller has integrated components of PayPal. PayPal is an online payment service provider. Payments are processed via so-called PayPal accounts, which represent virtual private or business accounts. PayPal is also able to process virtual payments through credit cards when a user does not have a PayPal account. A PayPal account is managed via an e-mail address, which is why there are no classic account numbers. PayPal makes it possible to trigger online payments to third parties or to receive payments. PayPal also accepts trustee functions and offers buyer protection services.

The European operating company of PayPal is PayPal (Europe) S.Ã .r.l. & Cie. S.C.A., 22-24 Boulevard Royal, 2449 Luxembourg, Luxembourg.

If the data subject chooses “PayPal” as the payment option in the online shop during the ordering process, we automatically transmit the data of the data subject to PayPal. By selecting this payment option, the data subject agrees to the transfer of personal data required for payment processing.

The personal data transmitted to PayPal is usually first name, last name, address, email address, IP address, telephone number, mobile phone number, or other data necessary for payment processing. The processing of the purchase contract also requires such personal data, which are in connection with the respective order.

The transmission of the data is aimed at payment processing and fraud prevention. The controller will transfer personal data to PayPal, in particular, if a legitimate interest in the transmission is given. The personal data exchanged between PayPal and the controller for the processing of the data will be transmitted by PayPal to economic credit agencies. This transmission is intended for identity and creditworthiness checks.

PayPal will, if necessary, pass on personal data to affiliates and service providers or subcontractors to the extent that this is necessary to fulfill contractual obligations or for data to be processed in the order.

The data subject has the possibility to revoke consent for the handling of personal data at any time from PayPal. A revocation shall not have any effect on personal data which must be processed, used or transmitted in accordance with (contractual) payment processing.

The applicable data protection provisions of PayPal may be retrieved under https://www.paypal.com/us/webapps/mpp/ua/privacy-full.

### 28\. Data protection provisions about the application and use of Yandex Metrica (Yandey LLC) (with anonymization function)

This website uses Yandex Metrica, a web analysis service provided by Yandex LLC ,16 Lva Tolstogo st., Moscow, 119021, Russia (www.yandex.com).

We use Yandex Metrica for optimisation and marketing purposes pursuant to Article 6 paragraph 1 lit. f GDPR. This entails us collecting, storing and analysing pseudonymised data about our visitors on the basis of our legitimate interest in analysing the behaviour of our users. We may use these data to create and analyse pseudonymised user profiles that serve the same purposes. Yandex Metrica uses so-called “cookies”, which are small text files that are locally stored in the visitor’s browser buffer memory. These cookies serve, among others, the purpose of recognising the browser and thereby allow us to collect more precise statistical data. The user’s IP address is part of the collected information but is pseudonymised immediately after collection and prior to storage in order to eliminate any possibility of connecting the data with an individual person.

For the purpose of safeguarding the aforementioned interests, the information generated by the cookie (including the pdeudonmyised IP address) will be transmitted to a Yandex server in the Russian Federation and stored there.

The data collected using Yandex technology will never be used to personally identify the visitor without the data subject’s consent and will not be merged with personal data by means of the data carrier on which the pseudonym is stored.

If you would like to deactivate the analysis of your user behaviour via cookies, you can change the settings of your browser so that it will inform you prior to placing any cookies and allow you to accept or reject each individual cookie, or to prevent the placement of cookies categorically or only in certain cases.

Alternatively, you can also object against the collection of data by Yandex by downloading and installing the opt-out add-on available at the following link:

https://yandex.com/support/metrica/general/opt-out.xml

Data Protection Statement of Yandex Metrica:https://metrica.yandex.com/about/info/privacy-policy

### 29\. Legal basis for the processing

Art. 6(1) lit. a GDPR serves as the legal basis for processing operations for which we obtain consent for a specific processing purpose. If the processing of personal data is necessary for the performance of a contract to which the data subject is party, as is the case, for example, when processing operations are necessary for the supply of goods or to provide any other service, the processing is based on Article 6(1) lit. b GDPR. The same applies to such processing operations which are necessary for carrying out pre-contractual measures, for example in the case of inquiries concerning our products or services. Is our company subject to a legal obligation by which processing of personal data is required, such as for the fulfillment of tax obligations, the processing is based on Art. 6(1) lit. c GDPR. In rare cases, the processing of personal data may be necessary to protect the vital interests of the data subject or of another natural person. This would be the case, for example, if a visitor were injured in our company and his name, age, health insurance data or other vital information would have to be passed on to a doctor, hospital or other third party. Then the processing would be based on Art. 6(1) lit. d GDPR. Finally, processing operations could be based on Article 6(1) lit. f GDPR. This legal basis is used for processing operations which are not covered by any of the abovementioned legal grounds, if processing is necessary for the purposes of the legitimate interests pursued by our company or by a third party, except where such interests are overridden by the interests or fundamental rights and freedoms of the data subject which require protection of personal data. Such processing operations are particularly permissible because they have been specifically mentioned by the European legislator. He considered that a legitimate interest could be assumed if the data subject is a client of the controller (Recital 47 Sentence 2 GDPR).

### 30\. The legitimate interests pursued by the controller or by a third party

Where the processing of personal data is based on Article 6(1) lit. f GDPR our legitimate interest is to carry out our business in favor of the well-being of all our employees and the shareholders.

### 31\. Data Collected for and by our Users

As you use our Services, you may import into our system Personal Information you have collected from your end-customers or other individuals. We have no direct relationship with your end-customers or any person other than you, and for that reason, you are responsible for making sure you have the appropriate permission for us to collect and process information about those individuals. Consistent with the uses of Personal Information covered in these Policies, we may transfer Personal Information of you or your end-customers to companies that help us promote, provide, or support our Services or the services of our Members (“Service Providers”). All Service Providers enter into a contract with us that protects Personal Information and restricts their use of any Personal Information consistent with this policy. As part of our Services, we may use and incorporate into features information you have provided, we have collected from you, or we have collected about end-customers. We may share this information, including end-customers email addresses, with third parties in line with the approved uses in these Policies.

We will retain Personal Information we process on behalf of our users for as long as needed to provide our Services or to comply with our legal obligations, resolve disputes, prevent abuse, and enforce our agreements.

### 32\. Accuracy and Retention of Data

We do our best to keep your data accurate and up to date, to the extent that you provide us with the information we need to do so. If your data changes, then you are responsible for notifying us of those changes. Upon request, we will provide you with information about whether we hold, or process on behalf of a third party, any of your Personal Information. We will retain your information for as long as your account is active or as long as needed to provide you with our Services. We may also retain and use your information in order to comply with our legal obligations, resolve disputes, prevent abuse, and enforce our Agreements.

### 33\. Access

We will give an individual, either you or an end-customer, access to any Personal Information we hold about them within 30 days of any request for that information. Individuals may request to access, correct, amend or delete information we hold about them by contacting us using contact data in section 2. Unless it is prohibited by law, we will remove any Personal Information about an individual, either you or an end-customer, from our servers at your or their request. There is no charge for an individual to access or update their Personal Information.

### 34\. Period for which the personal data will be stored

The criteria used to determine the period of storage of personal data is the respective statutory retention period. After expiration of that period, the corresponding data is routinely deleted, as long as it is no longer necessary for the fulfillment of the contract or the initiation of a contract.

### 35\. Provision of personal data as statutory or contractual requirement; Requirement necessary to enter into a contract; Obligation of the data subject to provide the personal data; possible consequences of failure to provide such data

We clarify that the provision of personal data is partly required by law (e.g. tax regulations) or can also result from contractual provisions (e.g. information on the contractual partner). Sometimes it may be necessary to conclude a contract that the data subject provides us with personal data, which must subsequently be processed by us. The data subject is, for example, obliged to provide us with personal data when our company signs a contract with him or her. The non-provision of the personal data would have the consequence that the contract with the data subject could not be concluded. Before personal data is provided by the data subject, the data subject must contact our Data Protection Officer. Our Data Protection Officer clarifies to the data subject whether the provision of the personal data is required by law or contract or is necessary for the conclusion of the contract, whether there is an obligation to provide the personal data and the consequences of non-provision of the personal data.

### 36\. Existence of automated decision-making

As a responsible company, we do not use automatic decision-making or profiling.

### 37\. Changes

We may change this Privacy Policy at any time and from time to time. The most recent version of the Privacy Policy is reflected by the version date located at the bottom of this Privacy Policy. All updates and amendments are effective immediately upon notice, which we may give by any means, including, but not limited to, by posting a revised version of this Privacy Policy or other notice on the Website. We encourage you to review this Privacy Policy often to stay informed of changes that may affect you, as your continued use of the Website signifies your continuing consent to be bound by this Privacy Policy. Our electronically or otherwise properly stored copies of this Privacy Policy are each deemed to be the true, complete, valid, authentic, and enforceable copy of the version of this Privacy Policy which was in effect on each respective date you visited the Website.

This Privacy Policy has been generated by the Privacy Policy Generator of the External Data Protection Officers ( https://dg-datenschutz.de/services/external-data-protection-officer/?lang=en ) that was developed in cooperation with RC GmbH, which sells [used notebooks](https://remarketing.company/){:target="_blank"}{:rel="noopener nofollow"} and the [Media Law Lawyers](https://www.wbs-law.de/medienrecht/){:target="_blank"}{:rel="noopener nofollow"} from WBS-LAW.

Effective: May 25, 2018  
Version: v2.5