---
layout: page
title: "Service Level Agreement"
description: "NetLicensing"
permalink: "/legal/terms-of-service/netlicensing/service-level-agreement-1-0/"
tags:
- legal
- SLA
---

<div class="row NL_banner">
    <div class="col-md-8 col-md-offset-2 NL_about">
        <h1>{{ page.title }}</h1>
        <span>{{ page.description }}</span>
    </div>
</div>

<br><br>

This Labs64 NetLicensing Service Level Agreement (“SLA”) is a policy governing the use of NetLicensing cloud-based services (“NetLicensing Services”) under the terms of the [NetLicensing Terms of Service](/legal/terms-of-service/netlicensing/) (the “Terms of Service”) between Labs64 GmbH (“NetLicensing”, “us” or “we”) and users of NetLicensing Services (“you”). This SLA applies separately to each account using NetLicensing Services. Unless otherwise provided herein, this SLA is subject to the terms of the Terms of Service. NetLicensing reserves the right to change the terms of this SLA in accordance with the Terms of Service.

### 1\. Service Commitment

NetLicensing will use commercially reasonable efforts to make NetLicensing instances available with a Monthly Uptime Percentage (defined below) of at least 99.00%, in each case during any monthly billing cycle (the “Service Commitment”). In the event NetLicensing does not meet the Service Commitment, you will be eligible to receive a Service Credit as described below.

### 2\. Definitions

The following capitalized terms shall be given the meaning set forth below:

*   **“Monthly Uptime Percentage”** is calculated by subtracting from 100% the percentage of continuous 5-minute periods during the month in which a NetLicensing instance was in a state of “Unavailable”. Monthly Uptime Percentage measurements exclude downtime resulting (directly or indirectly) from any NetLicensing SLA Exclusions defined below.
*   **“Unavailable”** and **“Unavailability”** means when a running NetLicensing instance has no external connectivity.
*   A **“Service Credit”** is a Euro credit, calculated as set forth below, that we may credit back to an eligible account.

### 3\. Service Commitments and Service Credits

Service Credits are calculated as a percentage of the total charges paid by you (excluding one-time payments such as upfront payments) for a NetLicensing instance for the monthly billing cycle in which the Unavailability occurred in accordance with the schedule below.

**Monthly Uptime Percentage**  => **Service Credit Percentage**  
Less than 99.00% but equal to or greater than 98.50%  => 10%  
Less than 98.50%  => 30%  

We will apply any Service Credits only against future NetLicensing payments otherwise due from you. At our discretion, we may issue the Service Credit to the credit card you used to pay for the billing cycle in which the Unavailability occurred. Service Credits will not entitle you to any refund or other payment from NetLicensing. A Service Credit will be applicable and issued only if the credit amount for the applicable monthly billing cycle is greater than one Euro (1 EUR). Service Credits may not be transferred or applied to any other account. Unless otherwise provided in the Terms of Service, your sole and exclusive remedy for any unavailability, non-performance, or other failure by us to provide NetLicensing Services is the receipt of a Service Credit (if eligible) in accordance with the terms of this SLA.

### 4\. Credit Request and Payment Procedures

To receive a Service Credit, you must submit a claim by sending an email to support@NetLicensing.com. To be eligible, the credit request must be received by us by the end of the second billing cycle after which the incident occurred and must include:

*   the words “SLA Credit Request” in the subject line
*   the dates and times of each Unavailability incident that you are claiming
*   the affected NetLicensing instance URLs
*   your request logs that document the errors and corroborate your claimed outage (any confidential or sensitive information in these logs should be removed or replaced with asterisks).

If the Monthly Uptime Percentage of such request is confirmed by us and is less than the Service Commitment, then we will issue the Service Credit to you within one billing cycle following the month in which your request is confirmed by us. Your failure to provide the request and other information as required above will disqualify you from receiving a Service Credit.

### 5\. NetLicensing SLA Exclusions

The Service Commitment does not apply to any unavailability, suspension or termination of NetLicensing Services, or any other NetLicensing or NetLicensing Services performance issues:

(i) caused by factors outside of our reasonable control, including, without limitation, any force majeure event or Internet access or related problems beyond the demarcation point of NetLicensing Services or its direct hosting subcontractors (i.e. beyond the point in the network where NetLicensing maintains access and control over the NetLicensing Services);

(ii) that result from any actions or inactions of you or any third party (other than NetLicensing’s direct hosting subcontractor);

(iii) that result from your equipment, software or other technology and/or third party equipment, software or other technology (other than third party equipment within our direct control);

(iv) that result from any scheduled maintenance;

(v) or arising from our suspension and termination of your right to use NetLicensing Services in connection with any breach by you of the Terms of Service or otherwise in accordance with the Terms of Service (collectively, the “NetLicensing SLA Exclusions”). If availability is impacted by factors other than those used in our Monthly Uptime Percentage calculation, then we may issue a Service Credit considering such factors at our discretion.

Effective: October 1, 2016  
Version: v1.0