---
layout: page
title: "Terms of Service"
description: "NetLicensing"
permalink: "/legal/terms-of-service/netlicensing/2-0/"
tags:
- legal
- affiliate
- partnership
---

<div class="row NL_banner">
    <div class="col-md-8 col-md-offset-2 NL_about">
        <h1>{{ page.title }}</h1>
        <span>{{ page.description }}</span>
    </div>
</div>

<br><br>

NetLicensing – Innovative Licensing

by Labs64 GmbH, Radlkoferstr. 2, 81373 Munich (referred to hereinafter as “Labs64”)

Definitions used within this TOS are listed in the [Glossary](https://netlicensing.io/wiki/glossary "NetLicensing Glossary").

### I. Contractual grounds

Labs64 offers the CUSTOMER the use of the license management system NetLicensing – Innovative Licensing (referred to hereinafter as “NetLicensing”) in accordance with the General Terms and Conditions (T&C). The offer is aimed at manufacturers of software in order to allow them to professionalize and market online their own software to their end-customers.

### II. Services rendered by Labs64

During the term of this agreement, Labs64 shall provide the CUSTOMER, via [https://www.labs64.com](https://www.labs64.com "labs64.com"), with online access to NetLicensing and the possibility to use NetLicensing for purposes of license management.  
The range of functions of NetLicensing, including the license models provided for by Labs64 between CUSTOMERS and their end-customers, as well as the definitions related thereto ensue from the [functional description](https://netlicensing.io/wiki/overview).

### III. Granting of rights

#### 1\. Scope of the rights of use

For the term of this agreement with the CUSTOMER, Labs64 shall grant to the customer a non-exclusive, non-transferable right of use limited in time with respect to NetLicensing.

#### 2\. Restriction of the rights of utilization

NetLicensing is protected by copyright; Labs64 shall be entitled to the rights resulting from the copyright to the extent that no third-party products are used. The copyright covers in particular the program code, documentation, external appearance, structure and organization of the program files, program names, logos and other forms of representation within the software. In addition to the material protected by copyright, NetLicensing contains trade secrets. The CUSTOMER shall be obliged to safeguard both.

#### 3\. Trademarks

“Labs64” is registered trademark of Labs64. All Labs64 trademarks may not be published or used in any other manner without the prior consent of Labs64.

### IV. Royalties and terms of payment

#### 1\. Royalties

The CUSTOMER shall pay to Labs64 the royalties set down in the [Price List](https://netlicensing.io/pricing/). Any and all royalties in percent and / or in EURO are quoted net, exclusive of the respectively applicable value-added tax.  
To extent that the CUSTOMER provides Labs64 with a verified value-added tax identification number for his company in a non-EU country, the settlement of the royalties shall take place net pursuant to §§ 3a (2) sentence 1, 13 b of the German Turnover Tax Law \[UStG – Umsatzsteuergesetz\] with notification pertaining to the passing on of the tax liability to the customer (recipient of our service). The CUSTOMER shall be obliged to promptly inform Labs64 of any changes to the performance country, the value-added tax identification number or the withdrawal or discontinuation of the same, and shall be held liable for any and all damage which is incurred from a breach of this duty.

#### 2\. Invoicing

Any and all royalties to be paid to Labs64 in accordance with these T&C shall be dependent on use and/or transaction. With every settlement, Las64 shall issue an invoice with regard to the royalty to be paid by the CUSTOMER.

#### 3\. Adjustment of the royalties

Labs64 shall, at its own discretion, be entitled to adjust the royalties agreed upon under these T&C. Labs64 may amend the royalties only with effect as of the first of the month of a calendar quarter. Labs64 shall be obliged to inform the CUSTOMER in writing of any and all amendments to the royalties by means of prior notification of no less than 8 weeks prior to the effective date. In this event, the CUSTOMER shall be entitled to terminate this agreement within two weeks as of gaining knowledge of the intended change to the royalties.

#### 4\. Default in payment

The CUSTOMER shall be deemed to be in default of payment to the extent that Labs64 has not received payment within 30 days after invoicing at the latest. As soon as default in payment occurs, Labs64 shall be entitled to charge interest amounting to 8 % p.a. above the base interest rate of the European Central Bank. Should the CUSTOMER be in default of payment, Labs64 shall be entitled to refuse the further rendering of services until full payment, including interest, is rendered in accordance with this agreement. In addition, Labs64 shall be entitled to deactivate the affected licenses of end-customers, and to restrict access to the services by Labs64.

### V. Duties of the customer

#### 1\. Correct and up-to-date entry of information

The CUSTOMER shall be obliged to keep up-to-date at all times any and all input and data entered in NetLicensing, and to provide correct and truthful information at all times. This shall apply in particular to texts pertaining to the licensing terms applicable to the relationship between the CUSTOMER and the end-customer. The CUSTOMER shall verify all input in terms of its completeness and correctness prior to uploading. The CUSTOMER shall correct any and all mistakes without undue delay.

#### 2\. Maintaining a PayPal Account

The CUSTOMER shall be obliged to maintain in operative order the accounts necessary for the payment method selected. Currently, payment can be processed via PayPal. It is necessary to activate the PayPal Account for the payment of digital goods as well.

#### 3\. Implementation of technical specifications

The CUSTOMER shall be obliged to configure the necessary technical implementation measures in accordance with the specifications provided by Labs64. Labs64 shall assume no responsibility for problems or errors occurring in connection with the integration of NetLicensing in the CUSTOMER’s software.

### VI. Data security

#### 1\. Registration data and passwords

During initial registration on the Labs64 portal, the CUSTOMER shall define a user name and password, and shall enter the name of his company. Any and all data shall be stored carefully. The CUSTOMER may change his password at any time under “Personal settings” in his account. For security reasons, it is recommended that the password be changed on a regular basis. The password may be used only by the CUSTOMER himself, and shall be kept secret from third parties. Labs64 reserves the right to temporarily block the account of the CUSTOMER upon repeated entry of a wrong password.

#### 2\. Data security

Labs64 shall be obliged to adhere to any and all necessary measures of physical data security within its sphere of responsibility and to ensure that these are adhered to.

### VII. Liability, force majeure

#### 1\. Liability

Labs64 shall be held liable without limitation for damage caused by intent, gross negligence and severe organizational culpability, for damage resulting from injury to life, limb or health, independent of the severity of culpability, and in the event of the assumption of a guaranty. In addition, Labs64 shall be held liable for the grossly negligent breach of duties, the fulfillment of which constitutes a pre-requisite for the proper execution of the contract, the breach of which jeopardizes the fulfillment of the contractual purpose, and the adherence to which the CUSTOMER regularly relies on. In the latter case, Labs64 shall, however, not be held liable for non-foreseeable damage which is not typical to the contract.  
Liability for damages above and beyond that, in particular for damage which is not incurred by the subject matter of the agreement itself, for loss of profits, loss of data or other consequential damage shall be excluded. To the extent that the liability of Labs64 is excluded or limited, this shall also apply to the personal liability borne by the employees, representatives and vicarious agents.

#### 2\. Force majeure

In the events of force majeure, the obligation of the parties to effect performance shall remain unaffected to the extent that the reason lies in their respective spheres. Should this not be the case (e.g. war, forces of nature), neither contracting party shall be held liable for delay or non-fulfillment of his duties. Events of force majeure also include external attacks on computer systems which cannot be averted by means of justifiable economic and technical efforts as per the state of the art, and which not only insignificantly impair the affected computer system in terms of its functionality.

### VIII. Coming into effect, term, termination

#### 1\. Coming into effect

This agreement shall come into effect upon the acceptance of the contractual terms and conditions by the CUSTOMER when registering on the internet sites of Lab64.

#### 2\. Term and termination

This agreement may be terminated by the CUSTOMER at any time subject to a notice period of 4 weeks to the end of the month. Labs64 may terminate this agreement with the CUSTOMER at any time, subject to a notice period of three months to the end of the quarter. The right to extraordinary termination shall remain unaffected. Any and all terminations of this agreement shall be made in writing or text form.

### IX. Maintenance of secrecy

The contracting parties shall, during and following the term of the agreement, undertake to maintain secrecy with respect to documents, information and data to which they have gained access or which have come to their knowledge due to the co-operation or in connection with this co-operation, and to safeguard the same against unauthorized access to the extent that disclosure is not mandatorily necessary for legal reasons or for the protection of legitimate interests. The same shall apply to this agreement. The contracting parties shall impose the duties to maintain secrecy to which they have committed themselves to upon any and all persons or companies who are entrusted by the contracting parties with the services arising from this agreement, or who receive information from this agreement.

### X. Miscellaneous

#### 1\. Amendments to the services and these Terms and Conditions

Labs64 reserves the right to amend these Terms and Conditions and the services offered unless such amendment is unacceptable for the CUSTOMER.  
Labs64 shall notify the CUSTOMER of any amendments to these Terms and Conditions in good time. Should the CUSTOMER fail to object to the applicability of the new Terms and Conditions within six (6) weeks following such notification, the amended T&C shall be deemed as accepted by the CUSTOMER. In the notification, Labs64 shall call the CUSTOMER’s attention to his right of objection and to the significance of the time limit for such objection.

#### 2\. Offsetting and retention

The CUSTOMER shall only be entitled to the right of offsetting or retention if the counter-claims asserted by him have become res judicata, are undisputed or have been acknowledged in writing by Labs64. The CUSTOMER shall be entitled to assert a right of retention in this case as well only to the extent that his counter-claim is based on the same contractual relationship.

#### 3\. Publications / references / reference to Labs64

Labs64 shall be permitted to mention the CUSTOMER as well as to include a general description of the CUSTOMER in customer lists, offers and other marketing documents. Labs64 shall, in particular, be entitled to use the logo, company name or other trademarks and/or labeling rights of the CUSTOMER within the scope of references, in particular in connection with corporate presentations, product descriptions, trade-fair presentations, on the internet, intranet or for other product or corporate information on Labs64 and/or the NetLicensing intended for the public.

#### 4\. Place of jurisdiction / applicable law

The contracting parties shall agree upon Munich as the place of jurisdiction with respect to any and all disputes arising from these T&C. The law of the Federal Republic of Germany under exclusion of the United Nations Convention on Contracts for the International Sale of Goods shall apply exclusively.

#### 5\. Text form

The contracting parties shall expressly agree upon the text form (e.g. via e-mail) as sufficing for the conclusion of the agreement. There are no verbal collateral agreements to this agreement. Any and all amendments and supplements to this agreement as well as the cancellation or termination of these T&C or parts thereof shall be made in text form to be effective.

#### 6\. Severability clause

Should individual provisions of these T&C be or become ineffective or invalid, all the remaining provisions shall not be affected hereby. In the event of ineffective or invalid provisions, loopholes, ambiguities or in the event of changes to the contractual grounds, the T&C shall be interpreted in a manner which comes closest to the economic interests of the contracting partners, with due consideration to the contractual purpose. The T&C shall – if necessary by duly amending additional provisions affected by the ineffectiveness – be supplemented accordingly.

Effective: October 1, 2013  
Version: v2.0