---
layout: page
title: "Privacy Policy"
description: ""
permalink: "/legal/privacy-policy/2-0/"
tags:
- legal
- privacy policy
---

<div class="row NL_banner">
    <div class="col-md-8 col-md-offset-2 NL_about">
        <h1>{{ page.title }}</h1>
        <span>{{ page.description }}</span>
    </div>
</div>

<br><br>

Your privacy is important to Labs64. So we’ve developed a Privacy Policy that covers how we collect, use, disclose, transfer, and store your information. Please take a moment to familiarize yourself with our privacy practices and let us know if you have any questions.

### Collection and Use of Personal Information

Personal information is data that can be used to uniquely identify or contact a single person.

You may be asked to provide your personal information anytime you are in contact with Labs64 or a Labs64 affiliated company, or by using of services offered by Labs64. Labs64 and its affiliates may share this personal information with each other and use it consistent with this Privacy Policy. They may also combine it with other information to provide and improve our products, services, content, and advertising.

Here are some examples of the types of personal information Labs64 may collect and how we may use it.

### What personal information we collect

When you create an Labs64 or Labs64 online service account, register your products, apply for commercial credit, purchase a product or content, download a software or digital content, register for a class at an Labs64 Retail Store, or participate in an online survey, we may collect a variety of information, including your name, mailing address, phone number, email address, contact preferences, and payment information.  
When you share your content with family and friends using Labs64 products, send gift certificates and products, or invite others to join you on Labs64 forums or online services, Labs64 may collect the information you provide about those people such as name, mailing address, email address, and phone number.

### How we use your personal information

The personal information we collect allows us to keep you posted on Labs64’s latest product announcements, software updates, and upcoming events. It also helps us to improve our services, content, and advertising. If you don’t want to be on our mailing list, you can opt out anytime by updating your preferences or by sending us an email.  
We also use personal information to help us develop, deliver, and improve our products, services, content, and advertising.  
From time to time, we may use your personal information to send important notices, such as communications about purchases and changes to our terms, conditions, and policies. Because this information is important to your interaction with Labs64, you may not opt out of receiving these communications.  
We may also use personal information for internal purposes such as auditing, data analysis, and research to improve Labs64’s products, services, and customer communications.  
If you enter into a sweepstake, contest, or similar promotion we may use the information you provide to administer those programs.

### Collection and Use of Non-Personal Information

We also collect non-personal information – data in a form that does not permit direct association with any specific individual. We may collect, use, transfer, and disclose non-personal information for any purpose. The following are some examples of non-personal information that we collect and how we may use it:

We may collect information such as occupation, language, zip code, area code, unique device identifier, location, and the time zone where an Labs64 product is used so that we can better understand customer behavior and improve our products, services, and advertising.  
We also may collect information regarding customer activities on our website and from our other products and services. This information is aggregated and used to help us provide more useful information to our customers and to understand which parts of our website, products, and services are of most interest. Aggregated data is considered non-personal information for the purposes of this Privacy Policy.  
If we do combine non-personal information with personal information the combined information will be treated as personal information for as long as it remains combined.

### Cookies and Other Technologies

Labs64’s website, online services, interactive applications, email messages, and advertisements may use “cookies” (see our [Cookies Policy](/legal/privacy-policy/cookies-policy/ "Cookies Policy")) and other technologies such as pixel tags and web beacons. These technologies help us better understand user behavior, tell us which parts of our website people have visited, and facilitate and measure the effectiveness of advertisements and web searches. We treat information collected by cookies and other technologies as non-personal information. However, to the extent that Internet Protocol (IP) addresses or similar identifiers are considered personal information by local law, we also treat these identifiers as personal information. Similarly, to the extent that non-personal information is combined with personal information, we treat the combined information as personal information for the purposes of this Privacy Policy.

Labs64 and its partners use cookies and other technologies in mobile advertising services to control the number of times you see a given ad, deliver ads that relate to your interests, and measure the effectiveness of ad campaigns.

Labs64 and our partners also use cookies and other technologies to remember personal information when you use our website, online services, and applications. Our goal in these cases is to make your experience with Labs64 more convenient and personal.

If you want to disable cookies and you’re using the web browser, go to browser preferences and then to the privacy pane to disable cookies. On your mobile device, go to Settings Cookies section. Please note that certain features of the Labs64 website(-s) will not be available once cookies are disabled.

As is true of most websites, we gather some information automatically and store it in log files. This information includes Internet Protocol (IP) addresses, browser type and language, Internet Service Provider (ISP), referring and exit pages, operating system, date/time stamp, and clickstream data.

We use this information to understand and analyze trends, to administer the site, to learn about user behavior on the site, and to gather demographic information about our user base as a whole. Labs64 may use this information in our marketing and advertising services.

In some of our email messages, we use a “click-through URL” linked to content on the Labs64 website(-s). When customers click one of these URLs, they pass through a separate web server before arriving at the destination page on our website. We track this click-through data to help us determine interest in particular topics and measure the effectiveness of our customer communications. If you prefer not to be tracked in this way, you should not click text or graphic links in the email messages.

Pixel tags enable us to send email messages in a format customers can read, and they tell us whether mail has been opened. We may use this information to reduce or eliminate messages sent to customers.

### Disclosure to Third Parties

At times Labs64 may make certain personal information available to strategic partners that work with Labs64 to provide products and services, or that help Labs64 market to customers. Personal information will only be shared by Labs64 to provide or improve our products, services and advertising; it will not be shared with third parties for their marketing purposes.

### Service Providers

Labs64 shares personal information with companies who provide services such as information processing, extending credit, fulfilling customer orders, delivering products to you, managing and enhancing customer data, providing customer service, assessing your interest in our products and services, and conducting customer research or satisfaction surveys. These companies are obligated to protect your information and may be located wherever Labs64 operates.

### Others

It may be necessary – by law, legal process, litigation, and/or requests from public and governmental authorities within or outside your country of residence – for Labs64 to disclose your personal information. We may also disclose information about you if we determine that for purposes of national security, law enforcement, or other issues of public importance, disclosure is necessary or appropriate.

We may also disclose information about you if we determine that disclosure is reasonably necessary to enforce our terms and conditions or protect our operations or users. Additionally, in the event of a reorganization, merger, or sale we may transfer any and all personal information we collect to the relevant third party.

### Protection of Personal Information

Labs64 takes precautions — including administrative, technical, and physical measures — to safeguard your personal information against loss, theft, and misuse, as well as against unauthorized access, disclosure, alteration, and destruction.

Labs64 online services (such as the NetLicensing, Photolancer Zone, etc.) use Secure Sockets Layer (SSL) encryption on all web pages where personal information is collected. To make purchases from these services, you must use an SSL-enabled browser. Doing so protects the confidentiality of your personal information while it’s transmitted over the Internet.

When you use some Labs64 products, services, or applications or post on an Labs64 forum, chat room, or social networking service, the personal information you share is visible to other users and can be read, collected, or used by them. You are responsible for the personal information you choose to submit in these instances. For example, if you list your name and email address in a forum posting, that information is public. Please take care when using these features.

### Integrity and Retention of Personal Information

Labs64 makes it easy for you to keep your personal information accurate, complete, and up to date. We will retain your personal information for the period necessary to fulfill the purposes outlined in this Privacy Policy unless a longer retention period is required or permitted by law.

### Children

We do not knowingly collect personal information from children under 18. If we learn that we have collected the personal information of a child under 18 we will take steps to delete the information as soon as possible.

### Location-Based Services

To provide location-based services on Labs64 products, Labs64 and our partners and licensees may collect, use, and share precise location data, including the real-time geographic location of your Labs64 computer or device. This location data is collected anonymously in a form that does not personally identify you and is used by Labs64 and our partners and licensees to provide and improve location-based products and services. For example, we may share geographic location with application providers when you opt in to their location services.

### Third-Party Sites and Services

Labs64 websites, products, applications, and services may contain links to third-party websites, products, and services. Our products and services may also use or offer products or services from third parties. Information collected by third parties, which may include such things as location data or contact details, is governed by their privacy practices. We encourage you to learn about the privacy practices of those third parties.

### International Users

Information you provide may be transferred or accessed by entities around the world as described in this Privacy Policy. Labs64 abides by the “safe harbor” frameworks set forth by the U.S. Department of Commerce regarding the collection, use, and retention of personal information collected by organizations in the European Economic Area and Switzerland.

### Our Companywide Commitment to Your Privacy

To make sure your personal information is secure, we communicate our privacy and security guidelines to Labs64 employees and strictly enforce privacy safeguards within the company.

### Privacy Questions

If you have any questions or concerns about Labs64’s Privacy Policy or data processing, please contact us.

Labs64 may update its Privacy Policy from time to time. When we change the policy in a material way, a notice will be posted on our website along with the updated Privacy Policy.

Effective: October 1, 2013  
Version: v2.0