---
layout: page
title: "Cookies Policy"
description: ""
permalink: "/legal/privacy-policy/cookies-policy/"
tags:
- legal
- privacy policy
---

<div class="row NL_banner">
    <div class="col-md-8 col-md-offset-2 NL_about">
        <h1>{{ page.title }}</h1>
        <span>{{ page.description }}</span>
    </div>
</div>

<br><br>

A cookie is a file that is stored on your computer when you visit a website. Most websites use them and they are generally harmless. When you revisit the website later or visit a different webpage a copy of the cookie file is sent to the website.  
They can be used to store information and have many uses. With the most common being tracking, remembering your details or settings, and to keep you logged in to an account

To learn more about cookies and how to manage them, visit [AboutCookies.org](https://www.aboutcookies.org){:target="_blank"}{:rel="noopener nofollow"}. Or please read on to find out more about how and where we use cookies.

### When are cookies created?

Writing data to a cookie is usually done when a new webpage is loaded – for example after a ‘submit’ button is pressed the data handling page would be responsible for storing the values in a cookie. If the user has elected to disable cookies then the write operation will fail, and subsequent sites which rely on the cookie will either have to take a default action, or prompt the user to re-enter the information that would have been stored in the cookie.

### Why are cookies used?

Cookies are a convenient way to carry information from one session on a website to another, or between sessions on related websites, without having to burden a server machine with massive amounts of data storage. Storing the data on the server without using cookies would also be problematic because it would be difficult to retrieve a particular user’s information without requiring a login on each visit to the website.  
If there is a large amount of information to store, then a cookie can simply be used as a means to identify a given user so that further related information can be looked up on a server-side database. For example the first time a user visits a site they may choose a username which is stored in the cookie, and then provide data such as password, name, address, preferred font size, page layout, etc. – this information would all be stored on the database using the username as a key. Subsequently when the site is revisited the server will read the cookie to find the username, and then retrieve all the user’s information from the database without it having to be re-entered.

This is a list of the cookies set by our site, and what each is used for:

<table border="1" class="cookielawinfo-row-cat-table cookielawinfo-classic"><thead><tr><th class="cookielawinfo-column-1 first">Cookie</th><th class="cookielawinfo-column-2">Type</th><th class="cookielawinfo-column-3">Duration</th><th class="cookielawinfo-column-4 last">Description</th></tr></thead><tbody><tr class="cookielawinfo-row"><td class="cookielawinfo-column-1">JSESSIONID</td><td class="cookielawinfo-column-2">Strictly Necessary Cookies</td><td class="cookielawinfo-column-3">End of session</td><td class="cookielawinfo-column-4">Cookies that are used for storing session information (Labs64 NetLicensing sites only).</td></tr><tr class="cookielawinfo-row"><td class="cookielawinfo-column-1">__utma</td><td class="cookielawinfo-column-2">Performance Cookies</td><td class="cookielawinfo-column-3">2 years</td><td class="cookielawinfo-column-4">Google Analytics:&nbsp;This cookie is typically written to the browser upon the first visit to our site from that web browser. If the cookie has been deleted by the browser operator, and the browser subsequently visits our site, a new utma cookie is written with a different unique ID. This cookie is used to determine unique visitors to our site and it is updated with each page view. Additionally, this cookie is provided with a unique ID that Google Analytics uses to ensure both the validity and accessibility of the cookie as an extra security measure.
<br>
For more information see <a href="https://www.google.com/intl/en/privacypolicy.html" target="_blank">https://www.google.com/intl/en/privacypolicy.html</a></td></tr><tr class="cookielawinfo-row"><td class="cookielawinfo-column-1">__utmb</td><td class="cookielawinfo-column-2">Performance Cookies</td><td class="cookielawinfo-column-3">30 minutes</td><td class="cookielawinfo-column-4">Google Analytics:&nbsp;This cookie is used to establish and continue a user session with our site. When a user views a page on our site, the Google Analytics code attempts to update this cookie. If it does not find the cookie, a new one is written and a new session is established. Each time a user visits a different page on our site, this cookie is updated to expire in 30 minutes, thus continuing a single session for as long as user activity continues within 30-minute intervals. This cookie expires when a user pauses on a page on our site for longer than 30 minutes.
<br>
For more information see <a href="https://www.google.com/intl/en/privacypolicy.html" target="_blank">https://www.google.com/intl/en/privacypolicy.html</a></td></tr><tr class="cookielawinfo-row"><td class="cookielawinfo-column-1">__utmc</td><td class="cookielawinfo-column-2">Performance Cookies</td><td class="cookielawinfo-column-3">End of session</td><td class="cookielawinfo-column-4">Google Analytics:&nbsp;This cookie operates in conjunction with the utmb cookie to determine whether or not to establish a new session for the user. In particular, this cookie is not provided with an expiration date, so it expires when the user exits the browser. Should a user visit our site, exit the browser and then return to your website within 30 minutes, the absence of the utmc cookie indicates that a new session needs to be established, despite the fact that the utmb cookie has not yet expired.
<br>
For more information see <a href="https://www.google.com/intl/en/privacypolicy.html" target="_blank">https://www.google.com/intl/en/privacypolicy.html</a></td></tr><tr class="cookielawinfo-row"><td class="cookielawinfo-column-1">__utmz</td><td class="cookielawinfo-column-2">Performance Cookies</td><td class="cookielawinfo-column-3">6 months</td><td class="cookielawinfo-column-4">Google Analytics:&nbsp;This cookie stores the type of referral used by the visitor to reach our site, whether via a direct method, a referring link, a website search, or a campaign such as an ad or an email link. It is used to calculate search engine traffic, ad campaigns and page navigation within our own site. The cookie is updated with each page view to our site.
<br>
For more information see <a href="https://www.google.com/intl/en/privacypolicy.html" target="_blank">https://www.google.com/intl/en/privacypolicy.html</a></td></tr></tbody></table>

We may update this list from time to time to reflect changes in the cookies that are used on our site.

### What types of cookie are there?

Broadly speaking, there are four types of cookie: strictly necessary cookies, performance cookies, functionality cookies and targeting or advertising cookies.

**Strictly Necessary Cookies**  
These cookies are essential to enable you to move around the website and use its features, such as accessing secure areas of the website. Without these cookies, our website won’t work properly.

**Performance Cookies**  
These cookies collect information about how you use our websites, for instance, which pages you go to most often and if you get error messages from those pages. We only use these cookies to improve how our websites work.

**Functionality Cookies**  
These cookies allow us to remember the choices you make (such as your user name) and provide enhanced, more personal features. These cookies can also be used to remember changes you have made to text size, fonts and other parts of our web pages that you can customise. They may also be used to provide services you have requested such as watching a video or commenting.

**Advertising or Tracking Cookies**  
The cookies show us where you saw the advert; help us measure the effectiveness of our advertising campaigns; and limit the number of times you see an advert.

### There is an unlisted cookie here?

As our website uses a content management system and added third-party plugins it can sometimes be difficult for us to notice every single cookie being used, especially after software updates.  
If you do notice a cookie that slips past us or have a question about cookies then please [contact us](/contact/ "Contact").  
There are also some essential cookies which are required for the website to work; these can only be blocked by changing your browser settings.

### User agreement

By continuing to use our site, you agree to the placement of cookies on your device. If you choose not to receive our cookies, we cannot guarantee that your experience will be as fulfilling as it would otherwise be.

Effective: October 1, 2013  
Version: v2.0