// ThreeWebGL.js - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{REVISION:"49"};self.Int32Array||(self.Int32Array=Array,self.Float32Array=Array);
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c){window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=Date.now(),g=Math.max(0,16-(c-a)),h=window.setTimeout(function(){b(c+g)},g);a=c+g;return h};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,f,g;if(c===0)this.r=this.g=this.b=0;else{d=Math.floor(a*6);f=a*6-d;a=c*(1-b);g=c*(1-b*f);b=c*(1-b*(1-f));switch(d){case 1:this.r=g;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=g;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=g;break;case 6:case 0:this.r=c;this.g=b;this.b=a}}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},lerpSelf:function(a,b){this.r=this.r+(a.r-this.r)*b;this.g=this.g+(a.g-this.g)*b;this.b=this.b+(a.b-this.b)*b;return this},getHex:function(){return Math.floor(this.r*255)<<16^Math.floor(this.g*255)<<8^Math.floor(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x=this.x+a.x;this.y=this.y+a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x=this.x-a.x;this.y=this.y-a.y;return this},multiplyScalar:function(a){this.x=this.x*a;this.y=this.y*a;return this},divideScalar:function(a){if(a){this.x=
this.x/a;this.y=this.y/a}else this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x=this.x+(a.x-this.x)*b;this.y=this.y+(a.y-this.y)*b;return this},equals:function(a){return a.x===this.x&&a.y===this.y},isZero:function(){return this.lengthSq()<1.0E-4},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x=this.x+a.x;this.y=this.y+a.y;this.z=this.z+a.z;return this},addScalar:function(a){this.x=this.x+a;this.y=this.y+
a;this.z=this.z+a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x=this.x-a.x;this.y=this.y-a.y;this.z=this.z-a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x=this.x*a.x;this.y=this.y*a.y;this.z=this.z*a.z;return this},multiplyScalar:function(a){this.x=this.x*a;this.y=this.y*a;this.z=this.z*a;return this},divideSelf:function(a){this.x=this.x/a.x;this.y=
this.y/a.y;this.z=this.z/a.z;return this},divideScalar:function(a){if(a){this.x=this.x/a;this.y=this.y/a;this.z=this.z/a}else this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},
setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x=this.x+(a.x-this.x)*b;this.y=this.y+(a.y-this.y)*b;this.z=this.z+(a.z-this.z)*b;return this},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,
a).lengthSq()},getPositionFromMatrix:function(a){this.x=a.elements[12];this.y=a.elements[13];this.z=a.elements[14];return this},getRotationFromMatrix:function(a,b){var c=b?b.x:1,d=b?b.y:1,f=b?b.z:1,g=a.elements[0]/c,h=a.elements[4]/d,c=a.elements[1]/c,d=a.elements[5]/d,l=a.elements[9]/f,m=a.elements[10]/f;this.y=Math.asin(a.elements[8]/f);f=Math.cos(this.y);if(Math.abs(f)>1.0E-5){this.x=Math.atan2(-l/f,m/f);this.z=Math.atan2(-h/f,g/f)}else{this.x=0;this.z=Math.atan2(c,d)}return this},getScaleFromMatrix:function(a){var b=
this.set(a.elements[0],a.elements[1],a.elements[2]).length(),c=this.set(a.elements[4],a.elements[5],a.elements[6]).length(),a=this.set(a.elements[8],a.elements[9],a.elements[10]).length();this.x=b;this.y=c;this.z=a},equals:function(a){return a.x===this.x&&a.y===this.y&&a.z===this.z},isZero:function(){return this.lengthSq()<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=d!==void 0?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w!==void 0?a.w:1;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x=this.x+a.x;this.y=this.y+a.y;this.z=this.z+a.z;this.w=this.w+a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x=
this.x-a.x;this.y=this.y-a.y;this.z=this.z-a.z;this.w=this.w-a.w;return this},multiplyScalar:function(a){this.x=this.x*a;this.y=this.y*a;this.z=this.z*a;this.w=this.w*a;return this},divideScalar:function(a){if(a){this.x=this.x/a;this.y=this.y/a;this.z=this.z/a;this.w=this.w/a}else{this.z=this.y=this.x=0;this.w=1}return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x=this.x+(a.x-this.x)*b;this.y=this.y+(a.y-this.y)*b;this.z=this.z+(a.z-this.z)*b;this.w=this.w+(a.w-this.w)*b;return this},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes,d=a.elements,a=d[0];b=d[1];var f=d[2],g=d[3],h=d[4],l=d[5],m=d[6],j=d[7],i=d[8],o=d[9],k=d[10],u=d[11],r=d[12],n=d[13],p=d[14],d=d[15];c[0].set(g-a,j-h,u-i,d-r);c[1].set(g+a,j+h,u+i,d+r);c[2].set(g+b,j+l,u+o,d+n);c[3].set(g-b,j-l,u-o,d-n);c[4].set(g-f,j-m,u-k,d-p);c[5].set(g+f,j+m,u+k,d+p);for(a=0;a<6;a++){b=c[a];b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))}};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=c.elements,c=-a.geometry.boundingSphere.radius*c.getMaxScaleOnAxis(),f=0;f<6;f++){a=b[f].x*d[12]+b[f].y*d[13]+b[f].z*d[14]+b[f].w;if(a<=c)return false}return true};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){r.sub(c,a);w=r.dot(b);q=n.add(a,p.copy(b).multiplyScalar(w));return I=c.distanceTo(q)}function d(a,b,c,d){r.sub(d,b);n.sub(c,b);p.sub(a,b);B=r.dot(r);s=r.dot(n);J=r.dot(p);C=n.dot(n);G=n.dot(p);F=1/(B*C-s*s);P=(C*J-s*G)*F;Q=(B*G-s*J)*F;return P>=0&&Q>=0&&P+Q<1}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;var f=1.0E-4;this.setPrecision=function(a){f=a};var g=new THREE.Vector3,h=new THREE.Vector3,l=new THREE.Vector3,m=new THREE.Vector3,
j=new THREE.Vector3,i=new THREE.Vector3,o=new THREE.Vector3,k=new THREE.Vector3,u=new THREE.Vector3;this.intersectObject=function(a){var b,n=[];if(a instanceof THREE.Particle){var r=c(this.origin,this.direction,a.matrixWorld.getPosition());if(r>a.scale.x)return[];b={distance:r,point:a.position,face:null,object:a};n.push(b)}else if(a instanceof THREE.Mesh){var r=c(this.origin,this.direction,a.matrixWorld.getPosition()),p=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),
a.matrixWorld.getColumnZ().length());if(r>a.geometry.boundingSphere.radius*Math.max(p.x,Math.max(p.y,p.z)))return n;var q,e,w=a.geometry,s=w.vertices,D;a.matrixRotationWorld.extractRotation(a.matrixWorld);r=0;for(p=w.faces.length;r<p;r++){b=w.faces[r];j.copy(this.origin);i.copy(this.direction);D=a.matrixWorld;o=D.multiplyVector3(o.copy(b.centroid)).subSelf(j);k=a.matrixRotationWorld.multiplyVector3(k.copy(b.normal));q=i.dot(k);if(!(Math.abs(q)<f)){e=k.dot(o)/q;if(!(e<0)&&(a.doubleSided||(a.flipSided?
q>0:q<0))){u.add(j,i.multiplyScalar(e));if(b instanceof THREE.Face3){g=D.multiplyVector3(g.copy(s[b.a]));h=D.multiplyVector3(h.copy(s[b.b]));l=D.multiplyVector3(l.copy(s[b.c]));if(d(u,g,h,l)){b={distance:j.distanceTo(u),point:u.clone(),face:b,object:a};n.push(b)}}else if(b instanceof THREE.Face4){g=D.multiplyVector3(g.copy(s[b.a]));h=D.multiplyVector3(h.copy(s[b.b]));l=D.multiplyVector3(l.copy(s[b.c]));m=D.multiplyVector3(m.copy(s[b.d]));if(d(u,g,h,m)||d(u,h,l,m)){b={distance:j.distanceTo(u),point:u.clone(),
face:b,object:a};n.push(b)}}}}}}return n};this.intersectObjects=function(a){for(var b=[],c=0,d=a.length;c<d;c++)Array.prototype.push.apply(b,this.intersectObject(a[c]));b.sort(function(a,b){return a.distance-b.distance});return b};var r=new THREE.Vector3,n=new THREE.Vector3,p=new THREE.Vector3,w,q,I,B,s,J,C,G,F,P,Q};
THREE.Rectangle=function(){function a(){g=d-b;h=f-c}var b,c,d,f,g,h,l=true;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return h};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return f};this.set=function(g,h,i,o){l=false;b=g;c=h;d=i;f=o;a()};this.addPoint=function(g,h){if(l){l=false;b=g;c=h;d=g;f=h}else{b=b<g?b:g;c=c<h?c:h;d=d>g?d:g;f=f>h?
f:h}a()};this.add3Points=function(g,h,i,o,k,u){if(l){l=false;b=g<i?g<k?g:k:i<k?i:k;c=h<o?h<u?h:u:o<u?o:u;d=g>i?g>k?g:k:i>k?i:k;f=h>o?h>u?h:u:o>u?o:u}else{b=g<i?g<k?g<b?g:b:k<b?k:b:i<k?i<b?i:b:k<b?k:b;c=h<o?h<u?h<c?h:c:u<c?u:c:o<u?o<c?o:c:u<c?u:c;d=g>i?g>k?g>d?g:d:k>d?k:d:i>k?i>d?i:d:k>d?k:d;f=h>o?h>u?h>f?h:f:u>f?u:f:o>u?o>f?o:f:u>f?u:f}a()};this.addRectangle=function(g){if(l){l=false;b=g.getLeft();c=g.getTop();d=g.getRight();f=g.getBottom()}else{b=b<g.getLeft()?b:g.getLeft();c=c<g.getTop()?c:g.getTop();
d=d>g.getRight()?d:g.getRight();f=f>g.getBottom()?f:g.getBottom()}a()};this.inflate=function(g){b=b-g;c=c-g;d=d+g;f=f+g;a()};this.minSelf=function(g){b=b>g.getLeft()?b:g.getLeft();c=c>g.getTop()?c:g.getTop();d=d<g.getRight()?d:g.getRight();f=f<g.getBottom()?f:g.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||f<a.getTop()||c>a.getBottom()?false:true};this.empty=function(){l=true;f=d=c=b=0;a()};this.isEmpty=function(){return l}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,f){return d+(a-b)*(f-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())},sign:function(a){return a<0?-1:a>0?1:0}};THREE.Matrix3=function(){this.elements=new Float32Array(9)};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,getInverse:function(a){var b=a.elements,a=b[10]*b[5]-b[6]*b[9],c=-b[10]*b[1]+b[2]*b[9],d=b[6]*b[1]-b[2]*b[5],f=-b[10]*b[4]+b[6]*b[8],g=b[10]*b[0]-b[2]*b[8],h=-b[6]*b[0]+b[2]*b[4],l=b[9]*b[4]-b[5]*b[8],m=-b[9]*b[0]+b[1]*b[8],j=b[5]*b[0]-b[1]*b[4],b=b[0]*a+b[1]*f+b[2]*l;b===0&&console.warn("Matrix3.getInverse(): determinant == 0");var b=1/b,i=this.elements;i[0]=b*a;i[1]=b*c;i[2]=b*d;i[3]=b*f;i[4]=b*g;i[5]=b*h;i[6]=b*l;i[7]=b*m;i[8]=b*j;return this},
transpose:function(){var a,b=this.elements;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,f,g,h,l,m,j,i,o,k,u,r,n){this.elements=new Float32Array(16);this.set(a!==void 0?a:1,b||0,c||0,d||0,f||0,g!==void 0?g:1,h||0,l||0,m||0,j||0,i!==void 0?i:1,o||0,k||0,u||0,r||0,n!==void 0?n:1)};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,f,g,h,l,m,j,i,o,k,u,r,n){var p=this.elements;p[0]=a;p[4]=b;p[8]=c;p[12]=d;p[1]=f;p[5]=g;p[9]=h;p[13]=l;p[2]=m;p[6]=j;p[10]=i;p[14]=o;p[3]=k;p[7]=u;p[11]=r;p[15]=n;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){a=a.elements;this.set(a[0],a[4],a[8],a[12],a[1],a[5],a[9],a[13],a[2],a[6],a[10],a[14],a[3],a[7],a[11],a[15]);return this},lookAt:function(a,b,c){var d=this.elements,
f=THREE.Matrix4.__v1,g=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;h.sub(a,b).normalize();if(h.length()===0)h.z=1;f.cross(c,h).normalize();if(f.length()===0){h.x=h.x+1.0E-4;f.cross(c,h).normalize()}g.cross(h,f);d[0]=f.x;d[4]=g.x;d[8]=h.x;d[1]=f.y;d[5]=g.y;d[9]=h.y;d[2]=f.z;d[6]=g.z;d[10]=h.z;return this},multiply:function(a,b){var c=a.elements,d=b.elements,f=this.elements,g=c[0],h=c[4],l=c[8],m=c[12],j=c[1],i=c[5],o=c[9],k=c[13],u=c[2],r=c[6],n=c[10],p=c[14],w=c[3],q=c[7],I=c[11],c=c[15],B=d[0],s=d[4],
J=d[8],C=d[12],G=d[1],F=d[5],P=d[9],Q=d[13],T=d[2],Z=d[6],R=d[10],z=d[14],H=d[3],E=d[7],e=d[11],d=d[15];f[0]=g*B+h*G+l*T+m*H;f[4]=g*s+h*F+l*Z+m*E;f[8]=g*J+h*P+l*R+m*e;f[12]=g*C+h*Q+l*z+m*d;f[1]=j*B+i*G+o*T+k*H;f[5]=j*s+i*F+o*Z+k*E;f[9]=j*J+i*P+o*R+k*e;f[13]=j*C+i*Q+o*z+k*d;f[2]=u*B+r*G+n*T+p*H;f[6]=u*s+r*F+n*Z+p*E;f[10]=u*J+r*P+n*R+p*e;f[14]=u*C+r*Q+n*z+p*d;f[3]=w*B+q*G+I*T+c*H;f[7]=w*s+q*F+I*Z+c*E;f[11]=w*J+q*P+I*R+c*e;f[15]=w*C+q*Q+I*z+c*d;return this},multiplySelf:function(a){return this.multiply(this,
a)},multiplyToArray:function(a,b,c){var d=this.elements;this.multiply(a,b);c[0]=d[0];c[1]=d[1];c[2]=d[2];c[3]=d[3];c[4]=d[4];c[5]=d[5];c[6]=d[6];c[7]=d[7];c[8]=d[8];c[9]=d[9];c[10]=d[10];c[11]=d[11];c[12]=d[12];c[13]=d[13];c[14]=d[14];c[15]=d[15];return this},multiplyScalar:function(a){var b=this.elements;b[0]=b[0]*a;b[4]=b[4]*a;b[8]=b[8]*a;b[12]=b[12]*a;b[1]=b[1]*a;b[5]=b[5]*a;b[9]=b[9]*a;b[13]=b[13]*a;b[2]=b[2]*a;b[6]=b[6]*a;b[10]=b[10]*a;b[14]=b[14]*a;b[3]=b[3]*a;b[7]=b[7]*a;b[11]=b[11]*a;b[15]=
b[15]*a;return this},multiplyVector3:function(a){var b=this.elements,c=a.x,d=a.y,f=a.z,g=1/(b[3]*c+b[7]*d+b[11]*f+b[15]);a.x=(b[0]*c+b[4]*d+b[8]*f+b[12])*g;a.y=(b[1]*c+b[5]*d+b[9]*f+b[13])*g;a.z=(b[2]*c+b[6]*d+b[10]*f+b[14])*g;return a},multiplyVector4:function(a){var b=this.elements,c=a.x,d=a.y,f=a.z,g=a.w;a.x=b[0]*c+b[4]*d+b[8]*f+b[12]*g;a.y=b[1]*c+b[5]*d+b[9]*f+b[13]*g;a.z=b[2]*c+b[6]*d+b[10]*f+b[14]*g;a.w=b[3]*c+b[7]*d+b[11]*f+b[15]*g;return a},rotateAxis:function(a){var b=this.elements,c=a.x,
d=a.y,f=a.z;a.x=c*b[0]+d*b[4]+f*b[8];a.y=c*b[1]+d*b[5]+f*b[9];a.z=c*b[2]+d*b[6]+f*b[10];a.normalize();return a},crossVector:function(a){var b=this.elements,c=new THREE.Vector4;c.x=b[0]*a.x+b[4]*a.y+b[8]*a.z+b[12]*a.w;c.y=b[1]*a.x+b[5]*a.y+b[9]*a.z+b[13]*a.w;c.z=b[2]*a.x+b[6]*a.y+b[10]*a.z+b[14]*a.w;c.w=a.w?b[3]*a.x+b[7]*a.y+b[11]*a.z+b[15]*a.w:1;return c},determinant:function(){var a=this.elements,b=a[0],c=a[4],d=a[8],f=a[12],g=a[1],h=a[5],l=a[9],m=a[13],j=a[2],i=a[6],o=a[10],k=a[14],u=a[3],r=a[7],
n=a[11],a=a[15];return f*l*i*u-d*m*i*u-f*h*o*u+c*m*o*u+d*h*k*u-c*l*k*u-f*l*j*r+d*m*j*r+f*g*o*r-b*m*o*r-d*g*k*r+b*l*k*r+f*h*j*n-c*m*j*n-f*g*i*n+b*m*i*n+c*g*k*n-b*h*k*n-d*h*j*a+c*l*j*a+d*g*i*a-b*l*i*a-c*g*o*a+b*h*o*a},transpose:function(){var a=this.elements,b;b=a[1];a[1]=a[4];a[4]=b;b=a[2];a[2]=a[8];a[8]=b;b=a[6];a[6]=a[9];a[9]=b;b=a[3];a[3]=a[12];a[12]=b;b=a[7];a[7]=a[13];a[13]=b;b=a[11];a[11]=a[14];a[14]=b;return this},flattenToArray:function(a){var b=this.elements;a[0]=b[0];a[1]=b[1];a[2]=b[2];
a[3]=b[3];a[4]=b[4];a[5]=b[5];a[6]=b[6];a[7]=b[7];a[8]=b[8];a[9]=b[9];a[10]=b[10];a[11]=b[11];a[12]=b[12];a[13]=b[13];a[14]=b[14];a[15]=b[15];return a},flattenToArrayOffset:function(a,b){var c=this.elements;a[b]=c[0];a[b+1]=c[1];a[b+2]=c[2];a[b+3]=c[3];a[b+4]=c[4];a[b+5]=c[5];a[b+6]=c[6];a[b+7]=c[7];a[b+8]=c[8];a[b+9]=c[9];a[b+10]=c[10];a[b+11]=c[11];a[b+12]=c[12];a[b+13]=c[13];a[b+14]=c[14];a[b+15]=c[15];return a},getPosition:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[12],a[13],
a[14])},setPosition:function(a){var b=this.elements;b[12]=a.x;b[13]=a.y;b[14]=a.z;return this},getColumnX:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[0],a[1],a[2])},getColumnY:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[4],a[5],a[6])},getColumnZ:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[8],a[9],a[10])},getInverse:function(a){var b=this.elements,c=a.elements,d=c[0],f=c[4],g=c[8],h=c[12],l=c[1],m=c[5],j=c[9],i=c[13],o=c[2],k=c[6],u=c[10],r=
c[14],n=c[3],p=c[7],w=c[11],c=c[15];b[0]=j*r*p-i*u*p+i*k*w-m*r*w-j*k*c+m*u*c;b[4]=h*u*p-g*r*p-h*k*w+f*r*w+g*k*c-f*u*c;b[8]=g*i*p-h*j*p+h*m*w-f*i*w-g*m*c+f*j*c;b[12]=h*j*k-g*i*k-h*m*u+f*i*u+g*m*r-f*j*r;b[1]=i*u*n-j*r*n-i*o*w+l*r*w+j*o*c-l*u*c;b[5]=g*r*n-h*u*n+h*o*w-d*r*w-g*o*c+d*u*c;b[9]=h*j*n-g*i*n-h*l*w+d*i*w+g*l*c-d*j*c;b[13]=g*i*o-h*j*o+h*l*u-d*i*u-g*l*r+d*j*r;b[2]=m*r*n-i*k*n+i*o*p-l*r*p-m*o*c+l*k*c;b[6]=h*k*n-f*r*n-h*o*p+d*r*p+f*o*c-d*k*c;b[10]=f*i*n-h*m*n+h*l*p-d*i*p-f*l*c+d*m*c;b[14]=h*m*o-
f*i*o-h*l*k+d*i*k+f*l*r-d*m*r;b[3]=j*k*n-m*u*n-j*o*p+l*u*p+m*o*w-l*k*w;b[7]=f*u*n-g*k*n+g*o*p-d*u*p-f*o*w+d*k*w;b[11]=g*m*n-f*j*n-g*l*p+d*j*p+f*l*w-d*m*w;b[15]=f*j*o-g*m*o+g*l*k-d*j*k-f*l*u+d*m*u;this.multiplyScalar(1/a.determinant());return this},setRotationFromEuler:function(a,b){var c=this.elements,d=a.x,f=a.y,g=a.z,h=Math.cos(d),d=Math.sin(d),l=Math.cos(f),f=Math.sin(f),m=Math.cos(g),g=Math.sin(g);switch(b){case "YXZ":var j=l*m,i=l*g,o=f*m,k=f*g;c[0]=j+k*d;c[4]=o*d-i;c[8]=h*f;c[1]=h*g;c[5]=h*
m;c[9]=-d;c[2]=i*d-o;c[6]=k+j*d;c[10]=h*l;break;case "ZXY":j=l*m;i=l*g;o=f*m;k=f*g;c[0]=j-k*d;c[4]=-h*g;c[8]=o+i*d;c[1]=i+o*d;c[5]=h*m;c[9]=k-j*d;c[2]=-h*f;c[6]=d;c[10]=h*l;break;case "ZYX":j=h*m;i=h*g;o=d*m;k=d*g;c[0]=l*m;c[4]=o*f-i;c[8]=j*f+k;c[1]=l*g;c[5]=k*f+j;c[9]=i*f-o;c[2]=-f;c[6]=d*l;c[10]=h*l;break;case "YZX":j=h*l;i=h*f;o=d*l;k=d*f;c[0]=l*m;c[4]=k-j*g;c[8]=o*g+i;c[1]=g;c[5]=h*m;c[9]=-d*m;c[2]=-f*m;c[6]=i*g+o;c[10]=j-k*g;break;case "XZY":j=h*l;i=h*f;o=d*l;k=d*f;c[0]=l*m;c[4]=-g;c[8]=f*m;
c[1]=j*g+k;c[5]=h*m;c[9]=i*g-o;c[2]=o*g-i;c[6]=d*m;c[10]=k*g+j;break;default:j=h*m;i=h*g;o=d*m;k=d*g;c[0]=l*m;c[4]=-l*g;c[8]=f;c[1]=i+o*f;c[5]=j-k*f;c[9]=-d*l;c[2]=k-j*f;c[6]=o+i*f;c[10]=h*l}return this},setRotationFromQuaternion:function(a){var b=this.elements,c=a.x,d=a.y,f=a.z,g=a.w,h=c+c,l=d+d,m=f+f,a=c*h,j=c*l,c=c*m,i=d*l,d=d*m,f=f*m,h=g*h,l=g*l,g=g*m;b[0]=1-(i+f);b[4]=j-g;b[8]=c+l;b[1]=j+g;b[5]=1-(a+f);b[9]=d-h;b[2]=c-l;b[6]=d+h;b[10]=1-(a+i);return this},compose:function(a,b,c){var d=this.elements,
f=THREE.Matrix4.__m1,g=THREE.Matrix4.__m2;f.identity();f.setRotationFromQuaternion(b);g.makeScale(c.x,c.y,c.z);this.multiply(f,g);d[12]=a.x;d[13]=a.y;d[14]=a.z;return this},decompose:function(a,b,c){var d=this.elements,f=THREE.Matrix4.__v1,g=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;f.set(d[0],d[1],d[2]);g.set(d[4],d[5],d[6]);h.set(d[8],d[9],d[10]);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;
c.x=f.length();c.y=g.length();c.z=h.length();a.x=d[12];a.y=d[13];a.z=d[14];d=THREE.Matrix4.__m1;d.copy(this);d.elements[0]=d.elements[0]/c.x;d.elements[1]=d.elements[1]/c.x;d.elements[2]=d.elements[2]/c.x;d.elements[4]=d.elements[4]/c.y;d.elements[5]=d.elements[5]/c.y;d.elements[6]=d.elements[6]/c.y;d.elements[8]=d.elements[8]/c.z;d.elements[9]=d.elements[9]/c.z;d.elements[10]=d.elements[10]/c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){var b=this.elements,a=a.elements;
b[12]=a[12];b[13]=a[13];b[14]=a[14];return this},extractRotation:function(a){var b=this.elements,a=a.elements,c=THREE.Matrix4.__v1,d=1/c.set(a[0],a[1],a[2]).length(),f=1/c.set(a[4],a[5],a[6]).length(),c=1/c.set(a[8],a[9],a[10]).length();b[0]=a[0]*d;b[1]=a[1]*d;b[2]=a[2]*d;b[4]=a[4]*f;b[5]=a[5]*f;b[6]=a[6]*f;b[8]=a[8]*c;b[9]=a[9]*c;b[10]=a[10]*c;return this},translate:function(a){var b=this.elements,c=a.x,d=a.y,a=a.z;b[12]=b[0]*c+b[4]*d+b[8]*a+b[12];b[13]=b[1]*c+b[5]*d+b[9]*a+b[13];b[14]=b[2]*c+b[6]*
d+b[10]*a+b[14];b[15]=b[3]*c+b[7]*d+b[11]*a+b[15];return this},rotateX:function(a){var b=this.elements,c=b[4],d=b[5],f=b[6],g=b[7],h=b[8],l=b[9],m=b[10],j=b[11],i=Math.cos(a),a=Math.sin(a);b[4]=i*c+a*h;b[5]=i*d+a*l;b[6]=i*f+a*m;b[7]=i*g+a*j;b[8]=i*h-a*c;b[9]=i*l-a*d;b[10]=i*m-a*f;b[11]=i*j-a*g;return this},rotateY:function(a){var b=this.elements,c=b[0],d=b[1],f=b[2],g=b[3],h=b[8],l=b[9],m=b[10],j=b[11],i=Math.cos(a),a=Math.sin(a);b[0]=i*c-a*h;b[1]=i*d-a*l;b[2]=i*f-a*m;b[3]=i*g-a*j;b[8]=i*h+a*c;b[9]=
i*l+a*d;b[10]=i*m+a*f;b[11]=i*j+a*g;return this},rotateZ:function(a){var b=this.elements,c=b[0],d=b[1],f=b[2],g=b[3],h=b[4],l=b[5],m=b[6],j=b[7],i=Math.cos(a),a=Math.sin(a);b[0]=i*c+a*h;b[1]=i*d+a*l;b[2]=i*f+a*m;b[3]=i*g+a*j;b[4]=i*h-a*c;b[5]=i*l-a*d;b[6]=i*m-a*f;b[7]=i*j-a*g;return this},rotateByAxis:function(a,b){var c=this.elements;if(a.x===1&&a.y===0&&a.z===0)return this.rotateX(b);if(a.x===0&&a.y===1&&a.z===0)return this.rotateY(b);if(a.x===0&&a.y===0&&a.z===1)return this.rotateZ(b);var d=a.x,
f=a.y,g=a.z,h=Math.sqrt(d*d+f*f+g*g),d=d/h,f=f/h,g=g/h,h=d*d,l=f*f,m=g*g,j=Math.cos(b),i=Math.sin(b),o=1-j,k=d*f*o,u=d*g*o,o=f*g*o,d=d*i,r=f*i,i=g*i,g=h+(1-h)*j,h=k+i,f=u-r,k=k-i,l=l+(1-l)*j,i=o+d,u=u+r,o=o-d,m=m+(1-m)*j,j=c[0],d=c[1],r=c[2],n=c[3],p=c[4],w=c[5],q=c[6],I=c[7],B=c[8],s=c[9],J=c[10],C=c[11];c[0]=g*j+h*p+f*B;c[1]=g*d+h*w+f*s;c[2]=g*r+h*q+f*J;c[3]=g*n+h*I+f*C;c[4]=k*j+l*p+i*B;c[5]=k*d+l*w+i*s;c[6]=k*r+l*q+i*J;c[7]=k*n+l*I+i*C;c[8]=u*j+o*p+m*B;c[9]=u*d+o*w+m*s;c[10]=u*r+o*q+m*J;c[11]=
u*n+o*I+m*C;return this},scale:function(a){var b=this.elements,c=a.x,d=a.y,a=a.z;b[0]=b[0]*c;b[4]=b[4]*d;b[8]=b[8]*a;b[1]=b[1]*c;b[5]=b[5]*d;b[9]=b[9]*a;b[2]=b[2]*c;b[6]=b[6]*d;b[10]=b[10]*a;b[3]=b[3]*c;b[7]=b[7]*d;b[11]=b[11]*a;return this},getMaxScaleOnAxis:function(){var a=this.elements;return Math.sqrt(Math.max(a[0]*a[0]+a[1]*a[1]+a[2]*a[2],Math.max(a[4]*a[4]+a[5]*a[5]+a[6]*a[6],a[8]*a[8]+a[9]*a[9]+a[10]*a[10])))},makeTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},
makeRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},makeRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},makeRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},makeRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),f=1-c,g=a.x,h=a.y,l=a.z,m=f*g,j=f*h;this.set(m*g+c,m*h-d*l,m*l+d*h,0,m*h+d*l,j*h+c,j*l-d*g,0,m*l-
d*h,j*l+d*g,f*l*l+c,0,0,0,0,1);return this},makeScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},makeFrustum:function(a,b,c,d,f,g){var h=this.elements;h[0]=2*f/(b-a);h[4]=0;h[8]=(b+a)/(b-a);h[12]=0;h[1]=0;h[5]=2*f/(d-c);h[9]=(d+c)/(d-c);h[13]=0;h[2]=0;h[6]=0;h[10]=-(g+f)/(g-f);h[14]=-2*g*f/(g-f);h[3]=0;h[7]=0;h[11]=-1;h[15]=0;return this},makePerspective:function(a,b,c,d){var a=c*Math.tan(a*Math.PI/360),f=-a;return this.makeFrustum(f*b,a*b,f,a,c,d)},makeOrthographic:function(a,
b,c,d,f,g){var h=this.elements,l=b-a,m=c-d,j=g-f;h[0]=2/l;h[4]=0;h[8]=0;h[12]=-((b+a)/l);h[1]=0;h[5]=2/m;h[9]=0;h[13]=-((c+d)/m);h[2]=0;h[6]=0;h[10]=-2/j;h[14]=-((g+f)/j);h[3]=0;h[7]=0;h[11]=0;h[15]=1;return this},clone:function(){var a=this.elements;return new THREE.Matrix4(a[0],a[4],a[8],a[12],a[1],a[5],a[9],a[13],a[2],a[6],a[10],a[14],a[3],a[7],a[11],a[15])}};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;
THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=false;this.renderDepth=null;this.rotationAutoUpdate=true;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
true;this.quaternion=new THREE.Quaternion;this.useQuaternion=false;this.boundRadius=0;this.boundRadiusScale=1;this.visible=true;this.receiveShadow=this.castShadow=false;this.frustumCulled=true;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,applyMatrix:function(a){this.matrix.multiply(a,this.matrix);this.scale.getScaleFromMatrix(this.matrix);this.rotation.getRotationFromMatrix(this.matrix,this.scale);this.position.getPositionFromMatrix(this.matrix)},translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,
this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)},add:function(a){if(a===this)console.warn("THREE.Object3D.add: An object can't be added as a child of itself.");else if(a instanceof THREE.Object3D){a.parent!==void 0&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.__addObject(a)}},remove:function(a){var b=
this.children.indexOf(a);if(b!==-1){a.parent=void 0;this.children.splice(b,1);for(b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.__removeObject(a)}},getChildByName:function(a,b){var c,d,f;c=0;for(d=this.children.length;c<d;c++){f=this.children[c];if(f.name===a)return f;if(b){f=f.getChildByName(a,b);if(f!==void 0)return f}}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,
this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}this.matrixWorldNeedsUpdate=true},updateMatrixWorld:function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a){this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=false;a=true}for(var b=0,c=this.children.length;b<
c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=h[g]=h[g]||new THREE.RenderableObject;g++;return a}function b(){var a=j[m]=j[m]||new THREE.RenderableVertex;m++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,f=a.z+a.w,e=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;if(f>=0&&e>=0&&g>=0&&h>=0)return true;if(f<0&&e<0||g<0&&h<0)return false;f<0?c=Math.max(c,f/(f-e)):e<0&&(d=Math.min(d,f/(f-e)));g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h)));if(d<c)return false;a.lerpSelf(b,c);b.lerpSelf(a,1-
d);return true}var f,g,h=[],l,m,j=[],i,o,k=[],u,r=[],n,p,w=[],q,I,B=[],s={objects:[],sprites:[],lights:[],elements:[]},J=new THREE.Vector3,C=new THREE.Vector4,G=new THREE.Matrix4,F=new THREE.Matrix4,P=new THREE.Frustum,Q=new THREE.Vector4,T=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);G.multiply(b.projectionMatrix,b.matrixWorldInverse);G.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);
G.multiply(b.matrixWorld,b.projectionMatrixInverse);G.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){g=0;s.objects.length=0;s.sprites.length=0;s.lights.length=0;var h=function(b){if(b.visible!==false){if((b instanceof THREE.Mesh||b instanceof THREE.Line)&&(b.frustumCulled===false||P.contains(b))){J.copy(b.matrixWorld.getPosition());
G.multiplyVector3(J);f=a();f.object=b;f.z=J.z;s.objects.push(f)}else if(b instanceof THREE.Sprite||b instanceof THREE.Particle){J.copy(b.matrixWorld.getPosition());G.multiplyVector3(J);f=a();f.object=b;f.z=J.z;s.sprites.push(f)}else b instanceof THREE.Light&&s.lights.push(b);for(var c=0,e=b.children.length;c<e;c++)h(b.children[c])}};h(b);d&&s.objects.sort(c);return s};this.projectScene=function(a,f,g){var h=f.near,E=f.far,e=false,J,X,D,la,S,ma,ua,ra,L,Aa,Ca,Na,Ua,Oa,Fa;I=p=u=o=0;s.elements.length=
0;if(f.parent===void 0){console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it...");a.add(f)}a.updateMatrixWorld();f.matrixWorldInverse.getInverse(f.matrixWorld);G.multiply(f.projectionMatrix,f.matrixWorldInverse);P.setFromMatrix(G);s=this.projectGraph(a,false);a=0;for(J=s.objects.length;a<J;a++){L=s.objects[a].object;Aa=L.matrixWorld;m=0;if(L instanceof THREE.Mesh){Ca=L.geometry;Na=L.geometry.materials;la=Ca.vertices;Ua=Ca.faces;Oa=Ca.faceVertexUvs;Ca=L.matrixRotationWorld.extractRotation(Aa);
X=0;for(D=la.length;X<D;X++){l=b();l.positionWorld.copy(la[X]);Aa.multiplyVector3(l.positionWorld);l.positionScreen.copy(l.positionWorld);G.multiplyVector4(l.positionScreen);l.positionScreen.x=l.positionScreen.x/l.positionScreen.w;l.positionScreen.y=l.positionScreen.y/l.positionScreen.w;l.visible=l.positionScreen.z>h&&l.positionScreen.z<E}la=0;for(X=Ua.length;la<X;la++){D=Ua[la];if(D instanceof THREE.Face3){S=j[D.a];ma=j[D.b];ua=j[D.c];if(S.visible&&ma.visible&&ua.visible){e=(ua.positionScreen.x-
S.positionScreen.x)*(ma.positionScreen.y-S.positionScreen.y)-(ua.positionScreen.y-S.positionScreen.y)*(ma.positionScreen.x-S.positionScreen.x)<0;if(L.doubleSided||e!=L.flipSided){ra=k[o]=k[o]||new THREE.RenderableFace3;o++;i=ra;i.v1.copy(S);i.v2.copy(ma);i.v3.copy(ua)}else continue}else continue}else if(D instanceof THREE.Face4){S=j[D.a];ma=j[D.b];ua=j[D.c];ra=j[D.d];if(S.visible&&ma.visible&&ua.visible&&ra.visible){e=(ra.positionScreen.x-S.positionScreen.x)*(ma.positionScreen.y-S.positionScreen.y)-
(ra.positionScreen.y-S.positionScreen.y)*(ma.positionScreen.x-S.positionScreen.x)<0||(ma.positionScreen.x-ua.positionScreen.x)*(ra.positionScreen.y-ua.positionScreen.y)-(ma.positionScreen.y-ua.positionScreen.y)*(ra.positionScreen.x-ua.positionScreen.x)<0;if(L.doubleSided||e!=L.flipSided){Fa=r[u]=r[u]||new THREE.RenderableFace4;u++;i=Fa;i.v1.copy(S);i.v2.copy(ma);i.v3.copy(ua);i.v4.copy(ra)}else continue}else continue}i.normalWorld.copy(D.normal);!e&&(L.flipSided||L.doubleSided)&&i.normalWorld.negate();
Ca.multiplyVector3(i.normalWorld);i.centroidWorld.copy(D.centroid);Aa.multiplyVector3(i.centroidWorld);i.centroidScreen.copy(i.centroidWorld);G.multiplyVector3(i.centroidScreen);ua=D.vertexNormals;S=0;for(ma=ua.length;S<ma;S++){ra=i.vertexNormalsWorld[S];ra.copy(ua[S]);!e&&(L.flipSided||L.doubleSided)&&ra.negate();Ca.multiplyVector3(ra)}S=0;for(ma=Oa.length;S<ma;S++)if(Fa=Oa[S][la]){ua=0;for(ra=Fa.length;ua<ra;ua++)i.uvs[S][ua]=Fa[ua]}i.material=L.material;i.faceMaterial=D.materialIndex!==null?Na[D.materialIndex]:
null;i.z=i.centroidScreen.z;s.elements.push(i)}}else if(L instanceof THREE.Line){F.multiply(G,Aa);la=L.geometry.vertices;S=b();S.positionScreen.copy(la[0]);F.multiplyVector4(S.positionScreen);Aa=L.type===THREE.LinePieces?2:1;X=1;for(D=la.length;X<D;X++){S=b();S.positionScreen.copy(la[X]);F.multiplyVector4(S.positionScreen);if(!((X+1)%Aa>0)){ma=j[m-2];Q.copy(S.positionScreen);T.copy(ma.positionScreen);if(d(Q,T)){Q.multiplyScalar(1/Q.w);T.multiplyScalar(1/T.w);Na=w[p]=w[p]||new THREE.RenderableLine;
p++;n=Na;n.v1.positionScreen.copy(Q);n.v2.positionScreen.copy(T);n.z=Math.max(Q.z,T.z);n.material=L.material;s.elements.push(n)}}}}}a=0;for(J=s.sprites.length;a<J;a++){L=s.sprites[a].object;Aa=L.matrixWorld;if(L instanceof THREE.Particle){C.set(Aa.elements[12],Aa.elements[13],Aa.elements[14],1);G.multiplyVector4(C);C.z=C.z/C.w;if(C.z>0&&C.z<1){h=B[I]=B[I]||new THREE.RenderableParticle;I++;q=h;q.x=C.x/C.w;q.y=C.y/C.w;q.z=C.z;q.rotation=L.rotation.z;q.scale.x=L.scale.x*Math.abs(q.x-(C.x+f.projectionMatrix.elements[0])/
(C.w+f.projectionMatrix.elements[12]));q.scale.y=L.scale.y*Math.abs(q.y-(C.y+f.projectionMatrix.elements[5])/(C.w+f.projectionMatrix.elements[13]));q.material=L.material;s.elements.push(q)}}}g&&s.elements.sort(c);return s}};THREE.Quaternion=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=d!==void 0?d:1};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,f=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-f),f=Math.sin(-f),g=Math.cos(c),c=Math.sin(c),h=a*b,l=d*f;this.w=h*g-l*c;this.x=h*c+l*g;this.y=d*b*g+a*f*c;this.z=a*f*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.elements[0]+a.elements[5]+a.elements[10]))/2;this.x=Math.sqrt(Math.max(0,b+a.elements[0]-a.elements[5]-a.elements[10]))/2;this.y=Math.sqrt(Math.max(0,b-a.elements[0]+a.elements[5]-a.elements[10]))/2;this.z=Math.sqrt(Math.max(0,b-a.elements[0]-a.elements[5]+a.elements[10]))/2;this.x=a.elements[6]-a.elements[9]<0?-Math.abs(this.x):
Math.abs(this.x);this.y=a.elements[8]-a.elements[2]<0?-Math.abs(this.y):Math.abs(this.y);this.z=a.elements[1]-a.elements[4]<0?-Math.abs(this.z):Math.abs(this.z);this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x=this.x*-1;this.y=this.y*-1;this.z=this.z*-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=
Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a===0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x=this.x*a;this.y=this.y*a;this.z=this.z*a;this.w=this.w*a}return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,f=this.w,g=a.x,h=a.y,l=a.z,a=a.w;this.x=b*a+f*g+c*l-d*h;this.y=
c*a+f*h+d*g-b*l;this.z=d*a+f*l+b*h-c*g;this.w=f*a-b*g-c*h-d*l;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,f=a.z,g=this.x,h=this.y,l=this.z,m=this.w,j=m*c+h*f-l*d,i=m*d+l*c-g*f,o=m*f+g*d-h*c,c=-g*c-h*d-l*f;b.x=j*m+c*-g+i*-l-o*-h;b.y=i*m+c*-h+o*-g-j*-l;b.z=o*m+c*-l+j*-h-i*-g;return b},clone:function(){return new THREE.Quaternion(this.x,this.y,this.z,this.w)}};
THREE.Quaternion.slerp=function(a,b,c,d){var f=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(f<0){c.w=-b.w;c.x=-b.x;c.y=-b.y;c.z=-b.z;f=-f}else c.copy(b);if(Math.abs(f)>=1){c.w=a.w;c.x=a.x;c.y=a.y;c.z=a.z;return c}var g=Math.acos(f),f=Math.sqrt(1-f*f);if(Math.abs(f)<0.001){c.w=0.5*(a.w+b.w);c.x=0.5*(a.x+b.x);c.y=0.5*(a.y+b.y);c.z=0.5*(a.z+b.z);return c}b=Math.sin((1-d)*g)/f;d=Math.sin(d*g)/f;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(){console.warn("THREE.Vertex has been DEPRECATED. Use THREE.Vector3 instead.")};
THREE.Face3=function(a,b,c,d,f,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};
THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){var a=new THREE.Face3(this.a,this.b,this.c);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;b=0;for(c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();b=0;for(c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();b=0;for(c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.Face4=function(a,b,c,d,f,g,h){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materialIndex=h;this.centroid=new THREE.Vector3};
THREE.Face4.prototype={constructor:THREE.Face4,clone:function(){var a=new THREE.Face4(this.a,this.b,this.c,this.d);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;b=0;for(c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();b=0;for(c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();b=0;for(c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},lerpSelf:function(a,b){this.u=this.u+(a.u-this.u)*b;this.v=this.v+(a.v-this.v)*b;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.morphNormals=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=false};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a);for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c]);c=0;for(d=this.faces.length;c<d;c++){var f=this.faces[c];b.multiplyVector3(f.normal);for(var g=0,h=f.vertexNormals.length;g<h;g++)b.multiplyVector3(f.vertexNormals[g]);a.multiplyVector3(f.centroid)}},computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];c.centroid.set(0,
0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a]);c.centroid.addSelf(this.vertices[c.b]);c.centroid.addSelf(this.vertices[c.c]);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a]);c.centroid.addSelf(this.vertices[c.b]);c.centroid.addSelf(this.vertices[c.c]);c.centroid.addSelf(this.vertices[c.d]);c.centroid.divideScalar(4)}}},computeFaceNormals:function(){var a,b,c,d,f,g,h=new THREE.Vector3,l=new THREE.Vector3;a=0;for(b=this.faces.length;a<
b;a++){c=this.faces[a];d=this.vertices[c.a];f=this.vertices[c.b];g=this.vertices[c.c];h.sub(g,f);l.sub(d,f);h.crossSelf(l);h.isZero()||h.normalize();c.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices===void 0){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];
else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal);d[c.d].addSelf(c.normal)}}a=0;
for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c]);c.vertexNormals[3].copy(d[c.d])}}},computeMorphNormals:function(){var a,b,c,d,f;c=0;for(d=this.faces.length;c<d;c++){f=this.faces[c];f.__originalFaceNormal?
f.__originalFaceNormal.copy(f.normal):f.__originalFaceNormal=f.normal.clone();if(!f.__originalVertexNormals)f.__originalVertexNormals=[];a=0;for(b=f.vertexNormals.length;a<b;a++)f.__originalVertexNormals[a]?f.__originalVertexNormals[a].copy(f.vertexNormals[a]):f.__originalVertexNormals[a]=f.vertexNormals[a].clone()}var g=new THREE.Geometry;g.faces=this.faces;a=0;for(b=this.morphTargets.length;a<b;a++){if(!this.morphNormals[a]){this.morphNormals[a]={};this.morphNormals[a].faceNormals=[];this.morphNormals[a].vertexNormals=
[];var h=this.morphNormals[a].faceNormals,l=this.morphNormals[a].vertexNormals,m,j;c=0;for(d=this.faces.length;c<d;c++){f=this.faces[c];m=new THREE.Vector3;j=f instanceof THREE.Face3?{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3}:{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3,d:new THREE.Vector3};h.push(m);l.push(j)}}h=this.morphNormals[a];g.vertices=this.morphTargets[a].vertices;g.computeFaceNormals();g.computeVertexNormals();c=0;for(d=this.faces.length;c<d;c++){f=this.faces[c];
m=h.faceNormals[c];j=h.vertexNormals[c];m.copy(f.normal);if(f instanceof THREE.Face3){j.a.copy(f.vertexNormals[0]);j.b.copy(f.vertexNormals[1]);j.c.copy(f.vertexNormals[2])}else{j.a.copy(f.vertexNormals[0]);j.b.copy(f.vertexNormals[1]);j.c.copy(f.vertexNormals[2]);j.d.copy(f.vertexNormals[3])}}}c=0;for(d=this.faces.length;c<d;c++){f=this.faces[c];f.normal=f.__originalFaceNormal;f.vertexNormals=f.__originalVertexNormals}},computeTangents:function(){function a(a,b,c,d,f,g,S){l=a.vertices[b];m=a.vertices[c];
j=a.vertices[d];i=h[f];o=h[g];k=h[S];u=m.x-l.x;r=j.x-l.x;n=m.y-l.y;p=j.y-l.y;w=m.z-l.z;q=j.z-l.z;I=o.u-i.u;B=k.u-i.u;s=o.v-i.v;J=k.v-i.v;C=1/(I*J-B*s);Q.set((J*u-s*r)*C,(J*n-s*p)*C,(J*w-s*q)*C);T.set((I*r-B*u)*C,(I*p-B*n)*C,(I*q-B*w)*C);F[b].addSelf(Q);F[c].addSelf(Q);F[d].addSelf(Q);P[b].addSelf(T);P[c].addSelf(T);P[d].addSelf(T)}var b,c,d,f,g,h,l,m,j,i,o,k,u,r,n,p,w,q,I,B,s,J,C,G,F=[],P=[],Q=new THREE.Vector3,T=new THREE.Vector3,Z=new THREE.Vector3,R=new THREE.Vector3,z=new THREE.Vector3;b=0;for(c=
this.vertices.length;b<c;b++){F[b]=new THREE.Vector3;P[b]=new THREE.Vector3}b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];h=this.faceVertexUvs[0][b];if(g instanceof THREE.Face3)a(this,g.a,g.b,g.c,0,1,2);else if(g instanceof THREE.Face4){a(this,g.a,g.b,g.d,0,1,3);a(this,g.b,g.c,g.d,1,2,3)}}var H=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++){z.copy(g.vertexNormals[d]);f=g[H[d]];G=F[f];Z.copy(G);Z.subSelf(z.multiplyScalar(z.dot(G))).normalize();
R.cross(g.vertexNormals[d],G);f=R.dot(P[f]);f=f<0?-1:1;g.vertexTangents[d]=new THREE.Vector4(Z.x,Z.y,Z.z,f)}}this.hasTangents=true},computeBoundingBox:function(){if(!this.boundingBox)this.boundingBox={min:new THREE.Vector3,max:new THREE.Vector3};if(this.vertices.length>0){var a;a=this.vertices[0];this.boundingBox.min.copy(a);this.boundingBox.max.copy(a);for(var b=this.boundingBox.min,c=this.boundingBox.max,d=1,f=this.vertices.length;d<f;d++){a=this.vertices[d];if(a.x<b.x)b.x=a.x;else if(a.x>c.x)c.x=
a.x;if(a.y<b.y)b.y=a.y;else if(a.y>c.y)c.y=a.y;if(a.z<b.z)b.z=a.z;else if(a.z>c.z)c.z=a.z}}else{this.boundingBox.min.set(0,0,0);this.boundingBox.max.set(0,0,0)}},computeBoundingSphere:function(){if(!this.boundingSphere)this.boundingSphere={radius:0};for(var a,b=0,c=0,d=this.vertices.length;c<d;c++){a=this.vertices[c].length();a>b&&(b=a)}this.boundingSphere.radius=b},mergeVertices:function(){var a={},b=[],c=[],d,f=Math.pow(10,4),g,h,l;g=0;for(h=this.vertices.length;g<h;g++){d=this.vertices[g];d=[Math.round(d.x*
f),Math.round(d.y*f),Math.round(d.z*f)].join("_");if(a[d]===void 0){a[d]=g;b.push(this.vertices[g]);c[g]=b.length-1}else c[g]=c[a[d]]}g=0;for(h=this.faces.length;g<h;g++){f=this.faces[g];if(f instanceof THREE.Face3){f.a=c[f.a];f.b=c[f.b];f.c=c[f.c]}else if(f instanceof THREE.Face4){f.a=c[f.a];f.b=c[f.b];f.c=c[f.c];f.d=c[f.d];d=[f.a,f.b,f.c,f.d];for(a=3;a>0;a--)if(d.indexOf(f["abcd"[a]])!=a){d.splice(a,1);this.faces[g]=new THREE.Face3(d[0],d[1],d[2]);f=0;for(d=this.faceVertexUvs.length;f<d;f++)(l=
this.faceVertexUvs[f][g])&&l.splice(a,1);break}}}c=this.vertices.length-b.length;this.vertices=b;return c}};THREE.GeometryCount=0;
THREE.Spline=function(a){function b(a,b,c,d,f,g,h){a=(c-a)*0.5;d=(d-b)*0.5;return(2*(b-c)+a+d)*h+(-3*(b-c)-2*a-d)*g+a*f+b}this.points=a;var c=[],d={x:0,y:0,z:0},f,g,h,l,m,j,i,o,k;this.initFromArray=function(a){this.points=[];for(var b=0;b<a.length;b++)this.points[b]={x:a[b][0],y:a[b][1],z:a[b][2]}};this.getPoint=function(a){f=(this.points.length-1)*a;g=Math.floor(f);h=f-g;c[0]=g===0?g:g-1;c[1]=g;c[2]=g>this.points.length-2?this.points.length-1:g+1;c[3]=g>this.points.length-3?this.points.length-1:
g+2;j=this.points[c[0]];i=this.points[c[1]];o=this.points[c[2]];k=this.points[c[3]];l=h*h;m=h*l;d.x=b(j.x,i.x,o.x,k.x,h,l,m);d.y=b(j.y,i.y,o.y,k.y,h,l,m);d.z=b(j.z,i.z,o.z,k.z,h,l,m);return d};this.getControlPointsArray=function(){var a,b,c=this.points.length,d=[];for(a=0;a<c;a++){b=this.points[a];d[a]=[b.x,b.y,b.z]}return d};this.getLength=function(a){var b,c,d,f=b=b=0,g=new THREE.Vector3,h=new THREE.Vector3,i=[],l=0;i[0]=0;a||(a=100);c=this.points.length*a;g.copy(this.points[0]);for(a=1;a<c;a++){b=
a/c;d=this.getPoint(b);h.copy(d);l=l+h.distanceTo(g);g.copy(d);b=(this.points.length-1)*b;b=Math.floor(b);if(b!=f){i[b]=l;f=b}}i[i.length]=l;return{chunks:i,total:l}};this.reparametrizeByArcLength=function(a){var b,c,d,f,g,h,i=[],l=new THREE.Vector3,k=this.getLength();i.push(l.copy(this.points[0]).clone());for(b=1;b<this.points.length;b++){c=k.chunks[b]-k.chunks[b-1];h=Math.ceil(a*c/k.total);f=(b-1)/(this.points.length-1);g=b/(this.points.length-1);for(c=1;c<h-1;c++){d=f+c*(1/h)*(g-f);d=this.getPoint(d);
i.push(l.copy(d).clone())}i.push(l.copy(this.points[b]).clone())}this.points=i}};THREE.Camera=function(){THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)};
THREE.OrthographicCamera=function(a,b,c,d,f,g){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=f!==void 0?f:0.1;this.far=g!==void 0?g:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix.makeOrthographic(this.left,this.right,this.top,this.bottom,this.near,this.far)};
THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=a!==void 0?a:50;this.aspect=b!==void 0?b:1;this.near=c!==void 0?c:0.1;this.far=d!==void 0?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((b!==void 0?b:24)/(a*2))*(180/Math.PI);this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,f,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=f;this.height=g;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0;this.onlyShadow=this.castShadow=false;this.shadowCameraNear=50;this.shadowCameraFar=5E3;this.shadowCameraLeft=-500;this.shadowCameraTop=this.shadowCameraRight=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=false;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;
this.shadowCascade=false;this.shadowCascadeOffset=new THREE.Vector3(0,0,-1E3);this.shadowCascadeCount=2;this.shadowCascadeBias=[0,0,0];this.shadowCascadeWidth=[512,512,512];this.shadowCascadeHeight=[512,512,512];this.shadowCascadeNearZ=[-1,0.99,0.998];this.shadowCascadeFarZ=[0.99,0.998,1];this.shadowCascadeArray=[];this.shadowMatrix=this.shadowCamera=this.shadowMapSize=this.shadowMap=null};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.SpotLight=function(a,b,c,d,f){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0;this.angle=d!==void 0?d:Math.PI/2;this.exponent=f!==void 0?f:10;this.onlyShadow=this.castShadow=false;this.shadowCameraNear=50;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowCameraVisible=false;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowMatrix=
this.shadowCamera=this.shadowMapSize=this.shadowMap=null};THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={constructor:THREE.Loader,crossOrigin:"anonymous",addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var b="Loaded ",b=a.total?b+((100*a.loaded/
a.total).toFixed(0)+"%"):b+((a.loaded/1E3).toFixed(2)+" KB");this.statusDomElement.innerHTML=b},extractUrlBase:function(a){a=a.split("/");a.pop();return(a.length<1?".":a.join("/"))+"/"},initMaterials:function(a,b,c){a.materials=[];for(var d=0;d<b.length;++d)a.materials[d]=THREE.Loader.prototype.createMaterial(b[d],c)},hasNormals:function(a){var b,c,d=a.materials.length;for(c=0;c<d;c++){b=a.materials[c];if(b instanceof THREE.ShaderMaterial)return true}return false},createMaterial:function(a,b){function c(a){a=
Math.log(a)/Math.LN2;return Math.floor(a)==a}function d(a){a=Math.log(a)/Math.LN2;return Math.pow(2,Math.round(a))}function f(a,b){var f=new Image;f.onload=function(){if(!c(this.width)||!c(this.height)){var b=d(this.width),f=d(this.height);a.image.width=b;a.image.height=f;a.image.getContext("2d").drawImage(this,0,0,b,f)}else a.image=this;a.needsUpdate=true};f.crossOrigin=l.crossOrigin;f.src=b}function g(a,c,d,g,h,i){var l=document.createElement("canvas");a[c]=new THREE.Texture(l);a[c].sourceFile=
d;if(g){a[c].repeat.set(g[0],g[1]);if(g[0]!=1)a[c].wrapS=THREE.RepeatWrapping;if(g[1]!=1)a[c].wrapT=THREE.RepeatWrapping}h&&a[c].offset.set(h[0],h[1]);if(i){g={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(g[i[0]]!==void 0)a[c].wrapS=g[i[0]];if(g[i[1]]!==void 0)a[c].wrapT=g[i[1]]}f(a[c],b+"/"+d)}function h(a){return(a[0]*255<<16)+(a[1]*255<<8)+a[2]*255}var l=this,m="MeshLambertMaterial",j={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,wireframe:a.wireframe};
if(a.shading){var i=a.shading.toLowerCase();i==="phong"?m="MeshPhongMaterial":i==="basic"&&(m="MeshBasicMaterial")}if(a.blending!==void 0&&THREE[a.blending]!==void 0)j.blending=THREE[a.blending];if(a.transparent!==void 0||a.opacity<1)j.transparent=a.transparent;if(a.depthTest!==void 0)j.depthTest=a.depthTest;if(a.depthWrite!==void 0)j.depthWrite=a.depthWrite;if(a.vertexColors!==void 0)if(a.vertexColors=="face")j.vertexColors=THREE.FaceColors;else if(a.vertexColors)j.vertexColors=THREE.VertexColors;
if(a.colorDiffuse)j.color=h(a.colorDiffuse);else if(a.DbgColor)j.color=a.DbgColor;if(a.colorSpecular)j.specular=h(a.colorSpecular);if(a.colorAmbient)j.ambient=h(a.colorAmbient);if(a.transparency)j.opacity=a.transparency;if(a.specularCoef)j.shininess=a.specularCoef;a.mapDiffuse&&b&&g(j,"map",a.mapDiffuse,a.mapDiffuseRepeat,a.mapDiffuseOffset,a.mapDiffuseWrap);a.mapLight&&b&&g(j,"lightMap",a.mapLight,a.mapLightRepeat,a.mapLightOffset,a.mapLightWrap);a.mapNormal&&b&&g(j,"normalMap",a.mapNormal,a.mapNormalRepeat,
a.mapNormalOffset,a.mapNormalWrap);a.mapSpecular&&b&&g(j,"specularMap",a.mapSpecular,a.mapSpecularRepeat,a.mapSpecularOffset,a.mapSpecularWrap);if(a.mapNormal){m=THREE.ShaderUtils.lib.normal;i=THREE.UniformsUtils.clone(m.uniforms);i.tNormal.texture=j.normalMap;if(a.mapNormalFactor)i.uNormalScale.value=a.mapNormalFactor;if(j.map){i.tDiffuse.texture=j.map;i.enableDiffuse.value=true}if(j.specularMap){i.tSpecular.texture=j.specularMap;i.enableSpecular.value=true}if(j.lightMap){i.tAO.texture=j.lightMap;
i.enableAO.value=true}i.uDiffuseColor.value.setHex(j.color);i.uSpecularColor.value.setHex(j.specular);i.uAmbientColor.value.setHex(j.ambient);i.uShininess.value=j.shininess;if(j.opacity!==void 0)i.uOpacity.value=j.opacity;j=new THREE.ShaderMaterial({fragmentShader:m.fragmentShader,vertexShader:m.vertexShader,uniforms:i,lights:true,fog:true})}else j=new THREE[m](j);if(a.DbgName!==void 0)j.name=a.DbgName;return j}};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};
THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.load=function(a,b,c,d){var c=c?c:this.extractUrlBase(a),d=d?d:this.extractUrlBase(a),f=this.showProgress?THREE.Loader.prototype.updateProgress:null;this.onLoadStart();this.loadAjaxJSON(this,a,b,c,d,f)};
THREE.BinaryLoader.prototype.loadAjaxJSON=function(a,b,c,d,f,g){var h=new XMLHttpRequest;h.onreadystatechange=function(){if(h.readyState==4)if(h.status==200||h.status==0){var l=JSON.parse(h.responseText);a.loadAjaxBuffers(l,c,f,d,g)}else console.error("THREE.BinaryLoader: Couldn't load ["+b+"] ["+h.status+"]")};h.open("GET",b,true);h.overrideMimeType&&h.overrideMimeType("text/plain; charset=x-user-defined");h.setRequestHeader("Content-Type","text/plain");h.send(null)};
THREE.BinaryLoader.prototype.loadAjaxBuffers=function(a,b,c,d,f){var g=new XMLHttpRequest,h=c+"/"+a.buffers,l=0;g.onreadystatechange=function(){if(g.readyState==4)g.status==200||g.status==0?THREE.BinaryLoader.prototype.createBinModel(g.response,b,d,a.materials):console.error("THREE.BinaryLoader: Couldn't load ["+h+"] ["+g.status+"]");else if(g.readyState==3){if(f){l==0&&(l=g.getResponseHeader("Content-Length"));f({total:l,loaded:g.responseText.length})}}else g.readyState==2&&(l=g.getResponseHeader("Content-Length"))};
g.open("GET",h,true);g.responseType="arraybuffer";g.send(null)};
THREE.BinaryLoader.prototype.createBinModel=function(a,b,c,d){var f=function(b){var c,f,m,j,i,o,k,u,r,n,p,w,q,I,B;function s(a){return a%4?4-a%4:0}function J(a,b){return(new Uint8Array(a,b,1))[0]}function C(a,b){return(new Uint32Array(a,b,1))[0]}function G(b,c){var e,d,f,g,h,i,l,j,k=new Uint32Array(a,c,3*b);for(e=0;e<b;e++){d=k[e*3];f=k[e*3+1];g=k[e*3+2];h=E[d*2];d=E[d*2+1];i=E[f*2];l=E[f*2+1];f=E[g*2];j=E[g*2+1];g=R.faceVertexUvs[0];var m=[];m.push(new THREE.UV(h,d));m.push(new THREE.UV(i,l));m.push(new THREE.UV(f,
j));g.push(m)}}function F(b,c){var e,d,f,g,h,i,l,k,j,m,n=new Uint32Array(a,c,4*b);for(e=0;e<b;e++){d=n[e*4];f=n[e*4+1];g=n[e*4+2];h=n[e*4+3];i=E[d*2];d=E[d*2+1];l=E[f*2];j=E[f*2+1];k=E[g*2];m=E[g*2+1];g=E[h*2];f=E[h*2+1];h=R.faceVertexUvs[0];var o=[];o.push(new THREE.UV(i,d));o.push(new THREE.UV(l,j));o.push(new THREE.UV(k,m));o.push(new THREE.UV(g,f));h.push(o)}}function P(b,c,e){for(var d,f,g,h,c=new Uint32Array(a,c,3*b),i=new Uint16Array(a,e,b),e=0;e<b;e++){d=c[e*3];f=c[e*3+1];g=c[e*3+2];h=i[e];
R.faces.push(new THREE.Face3(d,f,g,null,null,h))}}function Q(b,c,e){for(var d,f,g,h,i,c=new Uint32Array(a,c,4*b),l=new Uint16Array(a,e,b),e=0;e<b;e++){d=c[e*4];f=c[e*4+1];g=c[e*4+2];h=c[e*4+3];i=l[e];R.faces.push(new THREE.Face4(d,f,g,h,null,null,i))}}function T(b,c,e,d){for(var f,g,h,i,l,k,j,c=new Uint32Array(a,c,3*b),e=new Uint32Array(a,e,3*b),m=new Uint16Array(a,d,b),d=0;d<b;d++){f=c[d*3];g=c[d*3+1];h=c[d*3+2];l=e[d*3];k=e[d*3+1];j=e[d*3+2];i=m[d];var n=H[k*3],o=H[k*3+1];k=H[k*3+2];var r=H[j*3],
p=H[j*3+1];j=H[j*3+2];R.faces.push(new THREE.Face3(f,g,h,[new THREE.Vector3(H[l*3],H[l*3+1],H[l*3+2]),new THREE.Vector3(n,o,k),new THREE.Vector3(r,p,j)],null,i))}}function Z(b,c,e,d){for(var f,g,h,i,l,k,j,m,n,c=new Uint32Array(a,c,4*b),e=new Uint32Array(a,e,4*b),o=new Uint16Array(a,d,b),d=0;d<b;d++){f=c[d*4];g=c[d*4+1];h=c[d*4+2];i=c[d*4+3];k=e[d*4];j=e[d*4+1];m=e[d*4+2];n=e[d*4+3];l=o[d];var r=H[j*3],p=H[j*3+1];j=H[j*3+2];var q=H[m*3],u=H[m*3+1];m=H[m*3+2];var s=H[n*3],w=H[n*3+1];n=H[n*3+2];R.faces.push(new THREE.Face4(f,
g,h,i,[new THREE.Vector3(H[k*3],H[k*3+1],H[k*3+2]),new THREE.Vector3(r,p,j),new THREE.Vector3(q,u,m),new THREE.Vector3(s,w,n)],null,l))}}var R=this,z=0,H=[],E=[],e,Ba,X;THREE.Geometry.call(this);THREE.Loader.prototype.initMaterials(R,d,b);(function(a,b,c){for(var a=new Uint8Array(a,b,c),e="",d=0;d<c;d++)e=e+String.fromCharCode(a[b+d]);return e})(a,z,12);c=J(a,z+12);J(a,z+13);J(a,z+14);J(a,z+15);f=J(a,z+16);m=J(a,z+17);j=J(a,z+18);i=J(a,z+19);o=C(a,z+20);k=C(a,z+20+4);u=C(a,z+20+8);b=C(a,z+20+12);
r=C(a,z+20+16);n=C(a,z+20+20);p=C(a,z+20+24);w=C(a,z+20+28);q=C(a,z+20+32);I=C(a,z+20+36);B=C(a,z+20+40);z=z+c;c=f*3+i;X=f*4+i;e=b*c;Ba=r*(c+m*3);f=n*(c+j*3);i=p*(c+m*3+j*3);c=w*X;m=q*(X+m*4);j=I*(X+j*4);z=z+function(b){var b=new Float32Array(a,b,o*3),c,e,d,f;for(c=0;c<o;c++){e=b[c*3];d=b[c*3+1];f=b[c*3+2];R.vertices.push(new THREE.Vector3(e,d,f))}return o*3*Float32Array.BYTES_PER_ELEMENT}(z);z=z+function(b){if(k){var b=new Int8Array(a,b,k*3),c,e,d,f;for(c=0;c<k;c++){e=b[c*3];d=b[c*3+1];f=b[c*3+2];
H.push(e/127,d/127,f/127)}}return k*3*Int8Array.BYTES_PER_ELEMENT}(z);z=z+s(k*3);z=z+function(b){if(u){var b=new Float32Array(a,b,u*2),c,e,d;for(c=0;c<u;c++){e=b[c*2];d=b[c*2+1];E.push(e,d)}}return u*2*Float32Array.BYTES_PER_ELEMENT}(z);e=z+e+s(b*2);Ba=e+Ba+s(r*2);f=Ba+f+s(n*2);i=f+i+s(p*2);c=i+c+s(w*2);m=c+m+s(q*2);j=m+j+s(I*2);(function(a){if(n){var b=a+n*Uint32Array.BYTES_PER_ELEMENT*3;P(n,a,b+n*Uint32Array.BYTES_PER_ELEMENT*3);G(n,b)}})(Ba);(function(a){if(p){var b=a+p*Uint32Array.BYTES_PER_ELEMENT*
3,c=b+p*Uint32Array.BYTES_PER_ELEMENT*3;T(p,a,b,c+p*Uint32Array.BYTES_PER_ELEMENT*3);G(p,c)}})(f);(function(a){if(I){var b=a+I*Uint32Array.BYTES_PER_ELEMENT*4;Q(I,a,b+I*Uint32Array.BYTES_PER_ELEMENT*4);F(I,b)}})(m);(function(a){if(B){var b=a+B*Uint32Array.BYTES_PER_ELEMENT*4,c=b+B*Uint32Array.BYTES_PER_ELEMENT*4;Z(B,a,b,c+B*Uint32Array.BYTES_PER_ELEMENT*4);F(B,c)}})(j);b&&P(b,z,z+b*Uint32Array.BYTES_PER_ELEMENT*3);(function(a){if(r){var b=a+r*Uint32Array.BYTES_PER_ELEMENT*3;T(r,a,b,b+r*Uint32Array.BYTES_PER_ELEMENT*
3)}})(e);w&&Q(w,i,i+w*Uint32Array.BYTES_PER_ELEMENT*4);(function(a){if(q){var b=a+q*Uint32Array.BYTES_PER_ELEMENT*4;Z(q,a,b,b+q*Uint32Array.BYTES_PER_ELEMENT*4)}})(c);this.computeCentroids();this.computeFaceNormals();THREE.Loader.prototype.hasNormals(this)&&this.computeTangents()};f.prototype=new THREE.Geometry;f.prototype.constructor=f;b(new f(c))};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;
THREE.JSONLoader.prototype.load=function(a,b,c){c=c?c:this.extractUrlBase(a);this.onLoadStart();this.loadAjaxJSON(this,a,b,c)};
THREE.JSONLoader.prototype.loadAjaxJSON=function(a,b,c,d,f){var g=new XMLHttpRequest,h=0;g.onreadystatechange=function(){if(g.readyState===g.DONE)if(g.status===200||g.status===0){if(g.responseText){var l=JSON.parse(g.responseText);a.createModel(l,c,d)}else console.warn("THREE.JSONLoader: ["+b+"] seems to be unreachable or file there is empty");a.onLoadComplete()}else console.error("THREE.JSONLoader: Couldn't load ["+b+"] ["+g.status+"]");else if(g.readyState===g.LOADING){if(f){h===0&&(h=g.getResponseHeader("Content-Length"));
f({total:h,loaded:g.responseText.length})}}else g.readyState===g.HEADERS_RECEIVED&&(h=g.getResponseHeader("Content-Length"))};g.open("GET",b,true);g.overrideMimeType&&g.overrideMimeType("text/plain; charset=x-user-defined");g.setRequestHeader("Content-Type","text/plain");g.send(null)};
THREE.JSONLoader.prototype.createModel=function(a,b,c){var d=new THREE.Geometry,f=a.scale!==void 0?1/a.scale:1;this.initMaterials(d,a.materials,c);(function(b){var c,f,m,j,i,o,k,u,r,n,p,w,q,I,B=a.faces;o=a.vertices;var s=a.normals,J=a.colors,C=0;for(c=0;c<a.uvs.length;c++)a.uvs[c].length&&C++;for(c=0;c<C;c++){d.faceUvs[c]=[];d.faceVertexUvs[c]=[]}j=0;for(i=o.length;j<i;){k=new THREE.Vector3;k.x=o[j++]*b;k.y=o[j++]*b;k.z=o[j++]*b;d.vertices.push(k)}j=0;for(i=B.length;j<i;){b=B[j++];o=b&1;m=b&2;c=b&
4;f=b&8;u=b&16;k=b&32;n=b&64;b=b&128;if(o){p=new THREE.Face4;p.a=B[j++];p.b=B[j++];p.c=B[j++];p.d=B[j++];o=4}else{p=new THREE.Face3;p.a=B[j++];p.b=B[j++];p.c=B[j++];o=3}if(m){m=B[j++];p.materialIndex=m}m=d.faces.length;if(c)for(c=0;c<C;c++){w=a.uvs[c];r=B[j++];I=w[r*2];r=w[r*2+1];d.faceUvs[c][m]=new THREE.UV(I,r)}if(f)for(c=0;c<C;c++){w=a.uvs[c];q=[];for(f=0;f<o;f++){r=B[j++];I=w[r*2];r=w[r*2+1];q[f]=new THREE.UV(I,r)}d.faceVertexUvs[c][m]=q}if(u){u=B[j++]*3;f=new THREE.Vector3;f.x=s[u++];f.y=s[u++];
f.z=s[u];p.normal=f}if(k)for(c=0;c<o;c++){u=B[j++]*3;f=new THREE.Vector3;f.x=s[u++];f.y=s[u++];f.z=s[u];p.vertexNormals.push(f)}if(n){k=B[j++];k=new THREE.Color(J[k]);p.color=k}if(b)for(c=0;c<o;c++){k=B[j++];k=new THREE.Color(J[k]);p.vertexColors.push(k)}d.faces.push(p)}})(f);(function(){var b,c,f,m;if(a.skinWeights){b=0;for(c=a.skinWeights.length;b<c;b=b+2){f=a.skinWeights[b];m=a.skinWeights[b+1];d.skinWeights.push(new THREE.Vector4(f,m,0,0))}}if(a.skinIndices){b=0;for(c=a.skinIndices.length;b<c;b=
b+2){f=a.skinIndices[b];m=a.skinIndices[b+1];d.skinIndices.push(new THREE.Vector4(f,m,0,0))}}d.bones=a.bones;d.animation=a.animation})();(function(b){if(a.morphTargets!==void 0){var c,f,m,j,i,o;c=0;for(f=a.morphTargets.length;c<f;c++){d.morphTargets[c]={};d.morphTargets[c].name=a.morphTargets[c].name;d.morphTargets[c].vertices=[];i=d.morphTargets[c].vertices;o=a.morphTargets[c].vertices;m=0;for(j=o.length;m<j;m=m+3){var k=new THREE.Vector3;k.x=o[m]*b;k.y=o[m+1]*b;k.z=o[m+2]*b;i.push(k)}}}if(a.morphColors!==
void 0){c=0;for(f=a.morphColors.length;c<f;c++){d.morphColors[c]={};d.morphColors[c].name=a.morphColors[c].name;d.morphColors[c].colors=[];j=d.morphColors[c].colors;i=a.morphColors[c].colors;b=0;for(m=i.length;b<m;b=b+3){o=new THREE.Color(16755200);o.setRGB(i[b],i[b+1],i[b+2]);j.push(o)}}}})(f);d.computeCentroids();d.computeFaceNormals();this.hasNormals(d)&&d.computeTangents();b(d)};
THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};THREE.SceneLoader.prototype.constructor=THREE.SceneLoader;
THREE.SceneLoader.prototype.load=function(a,b){var c=this,d=new XMLHttpRequest;d.onreadystatechange=function(){if(d.readyState==4)if(d.status==200||d.status==0){var f=JSON.parse(d.responseText);c.createScene(f,b,a)}else console.error("THREE.SceneLoader: Couldn't load ["+a+"] ["+d.status+"]")};d.open("GET",a,true);d.overrideMimeType&&d.overrideMimeType("text/plain; charset=x-user-defined");d.setRequestHeader("Content-Type","text/plain");d.send(null)};
THREE.SceneLoader.prototype.createScene=function(a,b,c){function d(a,b){return b=="relativeToHTML"?a:j+"/"+a}function f(){var a;for(k in z.objects)if(!D.objects[k]){w=z.objects[k];if(w.geometry!==void 0){if(Q=D.geometries[w.geometry]){a=false;T=D.materials[w.materials[0]];(a=T instanceof THREE.ShaderMaterial)&&Q.computeTangents();s=w.position;J=w.rotation;C=w.quaternion;G=w.scale;q=w.matrix;C=0;w.materials.length==0&&(T=new THREE.MeshFaceMaterial);w.materials.length>1&&(T=new THREE.MeshFaceMaterial);
a=new THREE.Mesh(Q,T);a.name=k;if(q){a.matrixAutoUpdate=false;a.matrix.set(q[0],q[1],q[2],q[3],q[4],q[5],q[6],q[7],q[8],q[9],q[10],q[11],q[12],q[13],q[14],q[15])}else{a.position.set(s[0],s[1],s[2]);if(C){a.quaternion.set(C[0],C[1],C[2],C[3]);a.useQuaternion=true}else a.rotation.set(J[0],J[1],J[2]);a.scale.set(G[0],G[1],G[2])}a.visible=w.visible;a.doubleSided=w.doubleSided;a.castShadow=w.castShadow;a.receiveShadow=w.receiveShadow;D.scene.add(a);D.objects[k]=a}}else{s=w.position;J=w.rotation;C=w.quaternion;
G=w.scale;C=0;a=new THREE.Object3D;a.name=k;a.position.set(s[0],s[1],s[2]);if(C){a.quaternion.set(C[0],C[1],C[2],C[3]);a.useQuaternion=true}else a.rotation.set(J[0],J[1],J[2]);a.scale.set(G[0],G[1],G[2]);a.visible=w.visible!==void 0?w.visible:false;D.scene.add(a);D.objects[k]=a;D.empties[k]=a}}}function g(a){return function(b){D.geometries[a]=b;f();E=E-1;m.onLoadComplete();l()}}function h(a){return function(b){D.geometries[a]=b}}function l(){m.callbackProgress({totalModels:Ba,totalTextures:X,loadedModels:Ba-
E,loadedTextures:X-e},D);m.onLoadProgress();E==0&&e==0&&b(D)}var m=this,j=THREE.Loader.prototype.extractUrlBase(c),i,o,k,u,r,n,p,w,q,I,B,s,J,C,G,F,P,Q,T,Z,R,z,H,E,e,Ba,X,D;z=a;c=new THREE.BinaryLoader;H=new THREE.JSONLoader;e=E=0;D={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},empties:{}};if(z.transform){a=z.transform.position;I=z.transform.rotation;F=z.transform.scale;a&&D.scene.position.set(a[0],a[1],a[2]);I&&D.scene.rotation.set(I[0],I[1],
I[2]);F&&D.scene.scale.set(F[0],F[1],F[2]);if(a||I||F){D.scene.updateMatrix();D.scene.updateMatrixWorld()}}a=function(){e=e-1;l();m.onLoadComplete()};for(r in z.cameras){F=z.cameras[r];F.type=="perspective"?Z=new THREE.PerspectiveCamera(F.fov,F.aspect,F.near,F.far):F.type=="ortho"&&(Z=new THREE.OrthographicCamera(F.left,F.right,F.top,F.bottom,F.near,F.far));s=F.position;I=F.target;F=F.up;Z.position.set(s[0],s[1],s[2]);Z.target=new THREE.Vector3(I[0],I[1],I[2]);F&&Z.up.set(F[0],F[1],F[2]);D.cameras[r]=
Z}for(u in z.lights){I=z.lights[u];r=I.color!==void 0?I.color:16777215;Z=I.intensity!==void 0?I.intensity:1;if(I.type=="directional"){s=I.direction;B=new THREE.DirectionalLight(r,Z);B.position.set(s[0],s[1],s[2]);B.position.normalize()}else if(I.type=="point"){s=I.position;B=I.distance;B=new THREE.PointLight(r,Z,B);B.position.set(s[0],s[1],s[2])}else I.type=="ambient"&&(B=new THREE.AmbientLight(r));D.scene.add(B);D.lights[u]=B}for(n in z.fogs){u=z.fogs[n];u.type=="linear"?R=new THREE.Fog(0,u.near,
u.far):u.type=="exp2"&&(R=new THREE.FogExp2(0,u.density));F=u.color;R.color.setRGB(F[0],F[1],F[2]);D.fogs[n]=R}if(D.cameras&&z.defaults.camera)D.currentCamera=D.cameras[z.defaults.camera];if(D.fogs&&z.defaults.fog)D.scene.fog=D.fogs[z.defaults.fog];F=z.defaults.bgcolor;D.bgColor=new THREE.Color;D.bgColor.setRGB(F[0],F[1],F[2]);D.bgColorAlpha=z.defaults.bgalpha;for(i in z.geometries){n=z.geometries[i];if(n.type=="bin_mesh"||n.type=="ascii_mesh"){E=E+1;m.onLoadStart()}}Ba=E;for(i in z.geometries){n=
z.geometries[i];if(n.type=="cube"){Q=new THREE.CubeGeometry(n.width,n.height,n.depth,n.segmentsWidth,n.segmentsHeight,n.segmentsDepth,null,n.flipped,n.sides);D.geometries[i]=Q}else if(n.type=="plane"){Q=new THREE.PlaneGeometry(n.width,n.height,n.segmentsWidth,n.segmentsHeight);D.geometries[i]=Q}else if(n.type=="sphere"){Q=new THREE.SphereGeometry(n.radius,n.segmentsWidth,n.segmentsHeight);D.geometries[i]=Q}else if(n.type=="cylinder"){Q=new THREE.CylinderGeometry(n.topRad,n.botRad,n.height,n.radSegs,
n.heightSegs);D.geometries[i]=Q}else if(n.type=="torus"){Q=new THREE.TorusGeometry(n.radius,n.tube,n.segmentsR,n.segmentsT);D.geometries[i]=Q}else if(n.type=="icosahedron"){Q=new THREE.IcosahedronGeometry(n.radius,n.subdivisions);D.geometries[i]=Q}else if(n.type=="bin_mesh")c.load(d(n.url,z.urlBaseType),g(i));else if(n.type=="ascii_mesh")H.load(d(n.url,z.urlBaseType),g(i));else if(n.type=="embedded_mesh"){n=z.embeds[n.id];n.metadata=z.metadata;n&&H.createModel(n,h(i),"")}}for(p in z.textures){i=z.textures[p];
if(i.url instanceof Array){e=e+i.url.length;for(n=0;n<i.url.length;n++)m.onLoadStart()}else{e=e+1;m.onLoadStart()}}X=e;for(p in z.textures){i=z.textures[p];if(i.mapping!=void 0&&THREE[i.mapping]!=void 0)i.mapping=new THREE[i.mapping];if(i.url instanceof Array){n=[];for(R=0;R<i.url.length;R++)n[R]=d(i.url[R],z.urlBaseType);n=THREE.ImageUtils.loadTextureCube(n,i.mapping,a)}else{n=THREE.ImageUtils.loadTexture(d(i.url,z.urlBaseType),i.mapping,a);if(THREE[i.minFilter]!=void 0)n.minFilter=THREE[i.minFilter];
if(THREE[i.magFilter]!=void 0)n.magFilter=THREE[i.magFilter];if(i.repeat){n.repeat.set(i.repeat[0],i.repeat[1]);if(i.repeat[0]!=1)n.wrapS=THREE.RepeatWrapping;if(i.repeat[1]!=1)n.wrapT=THREE.RepeatWrapping}i.offset&&n.offset.set(i.offset[0],i.offset[1]);if(i.wrap){R={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(R[i.wrap[0]]!==void 0)n.wrapS=R[i.wrap[0]];if(R[i.wrap[1]]!==void 0)n.wrapT=R[i.wrap[1]]}}D.textures[p]=n}for(o in z.materials){q=z.materials[o];for(P in q.parameters)if(P==
"envMap"||P=="map"||P=="lightMap")q.parameters[P]=D.textures[q.parameters[P]];else if(P=="shading")q.parameters[P]=q.parameters[P]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(P=="blending")q.parameters[P]=THREE[q.parameters[P]]?THREE[q.parameters[P]]:THREE.NormalBlending;else if(P=="combine")q.parameters[P]=q.parameters[P]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(P=="vertexColors")if(q.parameters[P]=="face")q.parameters[P]=THREE.FaceColors;else if(q.parameters[P])q.parameters[P]=
THREE.VertexColors;if(q.parameters.opacity!==void 0&&q.parameters.opacity<1)q.parameters.transparent=true;if(q.parameters.normalMap){p=THREE.ShaderUtils.lib.normal;a=THREE.UniformsUtils.clone(p.uniforms);i=q.parameters.color;n=q.parameters.specular;R=q.parameters.ambient;c=q.parameters.shininess;a.tNormal.texture=D.textures[q.parameters.normalMap];if(q.parameters.normalMapFactor)a.uNormalScale.value=q.parameters.normalMapFactor;if(q.parameters.map){a.tDiffuse.texture=q.parameters.map;a.enableDiffuse.value=
true}if(q.parameters.lightMap){a.tAO.texture=q.parameters.lightMap;a.enableAO.value=true}if(q.parameters.specularMap){a.tSpecular.texture=D.textures[q.parameters.specularMap];a.enableSpecular.value=true}a.uDiffuseColor.value.setHex(i);a.uSpecularColor.value.setHex(n);a.uAmbientColor.value.setHex(R);a.uShininess.value=c;if(q.parameters.opacity)a.uOpacity.value=q.parameters.opacity;T=new THREE.ShaderMaterial({fragmentShader:p.fragmentShader,vertexShader:p.vertexShader,uniforms:a,lights:true,fog:true})}else T=
new THREE[q.type](q.parameters);D.materials[o]=T}f();m.callbackSync(D);l()};
THREE.Material=function(a){a=a||{};this.id=THREE.MaterialCount++;this.name="";this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:false;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.blendSrc=a.blendSrc!==void 0?a.blendSrc:THREE.SrcAlphaFactor;this.blendDst=a.blendDst!==void 0?a.blendDst:THREE.OneMinusSrcAlphaFactor;this.blendEquation=a.blendEquation!==void 0?a.blendEquation:THREE.AddEquation;this.depthTest=a.depthTest!==void 0?
a.depthTest:true;this.depthWrite=a.depthWrite!==void 0?a.depthWrite:true;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:false;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0;this.overdraw=a.overdraw!==void 0?a.overdraw:false;this.needsUpdate=this.visible=true};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;
THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NoBlending=0;THREE.NormalBlending=1;THREE.AdditiveBlending=2;THREE.SubtractiveBlending=3;THREE.MultiplyBlending=4;THREE.AdditiveAlphaBlending=5;THREE.CustomBlending=6;THREE.AddEquation=100;THREE.SubtractEquation=101;THREE.ReverseSubtractEquation=102;THREE.ZeroFactor=200;THREE.OneFactor=201;THREE.SrcColorFactor=202;THREE.OneMinusSrcColorFactor=203;THREE.SrcAlphaFactor=204;THREE.OneMinusSrcAlphaFactor=205;
THREE.DstAlphaFactor=206;THREE.OneMinusDstAlphaFactor=207;THREE.DstColorFactor=208;THREE.OneMinusDstColorFactor=209;THREE.SrcAlphaSaturateFactor=210;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:false;this.fog=a.fog!==void 0?a.fog:true};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:
true;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:THREE.NoColors;this.skinning=a.skinning!==void 0?a.skinning:false;this.morphTargets=a.morphTargets!==
void 0?a.morphTargets:false};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(16777215);this.emissive=a.emissive!==void 0?new THREE.Color(a.emissive):new THREE.Color(0);this.wrapAround=a.wrapAround!==void 0?a.wrapAround:false;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=
a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:true;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?
a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:THREE.NoColors;this.skinning=a.skinning!==void 0?a.skinning:false;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:false;this.morphNormals=a.morphNormals!==void 0?a.morphNormals:false};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(16777215);this.emissive=a.emissive!==void 0?new THREE.Color(a.emissive):new THREE.Color(0);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.metal=a.metal!==void 0?a.metal:false;this.perPixel=
a.perPixel!==void 0?a.perPixel:false;this.wrapAround=a.wrapAround!==void 0?a.wrapAround:false;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:true;this.shading=
a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:THREE.NoColors;this.skinning=a.skinning!==void 0?a.skinning:false;this.morphTargets=a.morphTargets!==void 0?
a.morphTargets:false;this.morphNormals=a.morphNormals!==void 0?a.morphNormals:false};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};
THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;
THREE.MeshFaceMaterial=function(){};THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:true;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:false;this.fog=a.fog!==void 0?a.fog:true};THREE.ParticleBasicMaterial.prototype=new THREE.Material;
THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ShaderMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.fragmentShader=a.fragmentShader!==void 0?a.fragmentShader:"void main() {}";this.vertexShader=a.vertexShader!==void 0?a.vertexShader:"void main() {}";this.uniforms=a.uniforms!==void 0?a.uniforms:{};this.attributes=a.attributes;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.fog=
a.fog!==void 0?a.fog:false;this.lights=a.lights!==void 0?a.lights:false;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:THREE.NoColors;this.skinning=a.skinning!==void 0?a.skinning:false;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:false;this.morphNormals=a.morphNormals!==void 0?a.morphNormals:false};THREE.ShaderMaterial.prototype=new THREE.Material;THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial;
THREE.Texture=function(a,b,c,d,f,g,h,l){this.id=THREE.TextureCount++;this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==void 0?d:THREE.ClampToEdgeWrapping;this.magFilter=f!==void 0?f:THREE.LinearFilter;this.minFilter=g!==void 0?g:THREE.LinearMipMapLinearFilter;this.format=h!==void 0?h:THREE.RGBAFormat;this.type=l!==void 0?l:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
true;this.needsUpdate=this.premultiplyAlpha=false;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.UVMapping=function(){};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;
THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(a,b,c,d,f,g,h,l,m,j){THREE.Texture.call(this,null,g,h,l,m,j,d,f);this.image={data:a,width:b,height:c}};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var a=new THREE.DataTexture(this.image.data,this.image.width,this.image.height,this.format,this.type,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.ParticleSystem=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b!==void 0?b:new THREE.ParticleBasicMaterial({color:Math.random()*16777215});this.sortParticles=false;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius}this.frustumCulled=false};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=b!==void 0?b:new THREE.LineBasicMaterial({color:Math.random()*16777215});this.type=c!==void 0?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b!==void 0?b:new THREE.MeshBasicMaterial({color:Math.random()*16777215,wireframe:true});if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius;if(this.geometry.morphTargets.length){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++){this.morphTargetInfluences.push(0);
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}}}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b=b|this.updateMatrix());if(b||this.matrixWorldNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixWorldNeedsUpdate=false;b=true}var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.SkinnedMesh=function(a,b){THREE.Mesh.call(this,a,b);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var c,d,f,g,h,l;if(this.geometry.bones!==void 0){for(c=0;c<this.geometry.bones.length;c++){f=this.geometry.bones[c];g=f.pos;h=f.rotq;l=f.scl;d=this.addBone();d.name=f.name;d.position.set(g[0],g[1],g[2]);d.quaternion.set(h[0],h[1],h[2],h[3]);d.useQuaternion=true;l!==void 0?d.scale.set(l[0],l[1],l[2]):d.scale.set(1,1,1)}for(c=0;c<this.bones.length;c++){f=this.geometry.bones[c];
d=this.bones[c];f.parent===-1?this.add(d):this.bones[f.parent].add(d)}this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;THREE.SkinnedMesh.prototype.addBone=function(a){a===void 0&&(a=new THREE.Bone(this));this.bones.push(a);return a};
THREE.SkinnedMesh.prototype.updateMatrixWorld=function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a){this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=false}for(var a=0,b=this.children.length;a<b;a++){var c=this.children[a];c instanceof THREE.Bone?c.update(this.identityMatrix,false):c.updateMatrixWorld(true)}for(var b=this.bones.length,c=this.bones,d=this.boneMatrices,a=0;a<b;a++)c[a].skinMatrix.flattenToArrayOffset(d,
a*16)};
THREE.SkinnedMesh.prototype.pose=function(){this.updateMatrixWorld(true);for(var a,b=[],c=0;c<this.bones.length;c++){a=this.bones[c];var d=new THREE.Matrix4;d.getInverse(a.skinMatrix);b.push(d);a.skinMatrix.flattenToArrayOffset(this.boneMatrices,c*16)}if(this.geometry.skinVerticesA===void 0){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];for(a=0;a<this.geometry.skinIndices.length;a++){var c=this.geometry.vertices[a],f=this.geometry.skinIndices[a].x,g=this.geometry.skinIndices[a].y,d=
new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesA.push(b[f].multiplyVector3(d));d=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesB.push(b[g].multiplyVector3(d));if(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y!==1){c=(1-(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y))*0.5;this.geometry.skinWeights[a].x=this.geometry.skinWeights[a].x+c;this.geometry.skinWeights[a].y=this.geometry.skinWeights[a].y+c}}}};
THREE.Ribbon=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b};THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;
THREE.LOD.prototype.addLevel=function(a,b){b===void 0&&(b=0);for(var b=Math.abs(b),c=0;c<this.LODs.length;c++)if(b<this.LODs[c].visibleAtDistance)break;this.LODs.splice(c,0,{visibleAtDistance:b,object3D:a});this.add(a)};
THREE.LOD.prototype.update=function(a){if(this.LODs.length>1){a.matrixWorldInverse.getInverse(a.matrixWorld);a=a.matrixWorldInverse;a=-(a.elements[2]*this.matrixWorld.elements[12]+a.elements[6]*this.matrixWorld.elements[13]+a.elements[10]*this.matrixWorld.elements[14]+a.elements[14]);this.LODs[0].object3D.visible=true;for(var b=1;b<this.LODs.length;b++)if(a>=this.LODs[b].visibleAtDistance){this.LODs[b-1].object3D.visible=false;this.LODs[b].object3D.visible=true}else break;for(;b<this.LODs.length;b++)this.LODs[b].object3D.visible=
false}};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:new THREE.Texture;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.blendSrc=a.blendSrc!==void 0?a.blendSrc:THREE.SrcAlphaFactor;this.blendDst=a.blendDst!==void 0?a.blendDst:THREE.OneMinusSrcAlphaFactor;this.blendEquation=a.blendEquation!==void 0?a.blendEquation:THREE.AddEquation;this.useScreenCoordinates=a.useScreenCoordinates!==void 0?
a.useScreenCoordinates:true;this.mergeWith3D=a.mergeWith3D!==void 0?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=a.affectedByDistance!==void 0?a.affectedByDistance:!this.useScreenCoordinates;this.scaleByViewport=a.scaleByViewport!==void 0?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=
new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,this.scale.y)}this.matrixWorldNeedsUpdate=true};THREE.SpriteAlignment={};
THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);
THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=false;this.__objects=[];this.__lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.__addObject=function(a){if(a instanceof THREE.Light)this.__lights.indexOf(a)===-1&&this.__lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.__objects.indexOf(a)===-1){this.__objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);b!==-1&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.__addObject(a.children[b])};
THREE.Scene.prototype.__removeObject=function(a){if(a instanceof THREE.Light){var b=this.__lights.indexOf(a);b!==-1&&this.__lights.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.__objects.indexOf(a);if(b!==-1){this.__objects.splice(b,1);this.__objectsRemoved.push(a);b=this.__objectsAdded.indexOf(a);b!==-1&&this.__objectsAdded.splice(b,1)}}for(b=0;b<a.children.length;b++)this.__removeObject(a.children[b])};
THREE.Fog=function(a,b,c){this.color=new THREE.Color(a);this.near=b!==void 0?b:1;this.far=c!==void 0?c:1E3};THREE.FogExp2=function(a,b){this.color=new THREE.Color(a);this.density=b!==void 0?b:2.5E-4};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform float flipEnvMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\n#ifdef DOUBLE_SIDED\nfloat flipNormal = ( -1.0 + 2.0 * float( gl_FrontFacing ) );\nvec4 cubeColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * vReflect.x, vReflect.yz ) );\n#else\nvec4 cubeColor = textureCube( envMap, vec3( flipEnvMap * vReflect.x, vReflect.yz ) );\n#endif\n#ifdef GAMMA_INPUT\ncubeColor.xyz *= cubeColor.xyz;\n#endif\nif ( combine == 1 ) {\ngl_FragColor.xyz = mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity );\n} else {\ngl_FragColor.xyz = gl_FragColor.xyz * cubeColor.xyz;\n}\n#endif",
envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\n#ifdef GAMMA_INPUT\nvec4 texelColor = texture2D( map, vUv );\ntexelColor.xyz *= texelColor.xyz;\ngl_FragColor = gl_FragColor * texelColor;\n#else\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif\n#endif",
lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_lambert_pars_vertex:"uniform vec3 ambient;\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#endif\n#if MAX_SPOT_LIGHTS > 0\nuniform vec3 spotLightColor[ MAX_SPOT_LIGHTS ];\nuniform vec3 spotLightPosition[ MAX_SPOT_LIGHTS ];\nuniform vec3 spotLightDirection[ MAX_SPOT_LIGHTS ];\nuniform float spotLightDistance[ MAX_SPOT_LIGHTS ];\nuniform float spotLightAngle[ MAX_SPOT_LIGHTS ];\nuniform float spotLightExponent[ MAX_SPOT_LIGHTS ];\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif",
lights_lambert_vertex:"vLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\nvLightBack = vec3( 0.0 );\n#endif\ntransformedNormal = normalize( transformedNormal );\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nfloat dotProduct = dot( transformedNormal, dirVector );\nvec3 directionalLightWeighting = vec3( max( dotProduct, 0.0 ) );\n#ifdef DOUBLE_SIDED\nvec3 directionalLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n#ifdef WRAP_AROUND\nvec3 directionalLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n#endif\n#endif\n#ifdef WRAP_AROUND\nvec3 directionalLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\ndirectionalLightWeighting = mix( directionalLightWeighting, directionalLightWeightingHalf, wrapRGB );\n#ifdef DOUBLE_SIDED\ndirectionalLightWeightingBack = mix( directionalLightWeightingBack, directionalLightWeightingHalfBack, wrapRGB );\n#endif\n#endif\nvLightFront += directionalLightColor[ i ] * directionalLightWeighting;\n#ifdef DOUBLE_SIDED\nvLightBack += directionalLightColor[ i ] * directionalLightWeightingBack;\n#endif\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat dotProduct = dot( transformedNormal, lVector );\nvec3 pointLightWeighting = vec3( max( dotProduct, 0.0 ) );\n#ifdef DOUBLE_SIDED\nvec3 pointLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n#ifdef WRAP_AROUND\nvec3 pointLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n#endif\n#endif\n#ifdef WRAP_AROUND\nvec3 pointLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\npointLightWeighting = mix( pointLightWeighting, pointLightWeightingHalf, wrapRGB );\n#ifdef DOUBLE_SIDED\npointLightWeightingBack = mix( pointLightWeightingBack, pointLightWeightingHalfBack, wrapRGB );\n#endif\n#endif\nvLightFront += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef DOUBLE_SIDED\nvLightBack += pointLightColor[ i ] * pointLightWeightingBack * lDistance;\n#endif\n}\n#endif\n#if MAX_SPOT_LIGHTS > 0\nfor( int i = 0; i < MAX_SPOT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( spotLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nlVector = normalize( lVector );\nfloat spotEffect = dot( spotLightDirection[ i ], normalize( spotLightPosition[ i ] - mPosition.xyz ) );\nif ( spotEffect > spotLightAngle[ i ] ) {\nspotEffect = pow( spotEffect, spotLightExponent[ i ] );\nfloat lDistance = 1.0;\nif ( spotLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / spotLightDistance[ i ] ), 1.0 );\nfloat dotProduct = dot( transformedNormal, lVector );\nvec3 spotLightWeighting = vec3( max( dotProduct, 0.0 ) );\n#ifdef DOUBLE_SIDED\nvec3 spotLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n#ifdef WRAP_AROUND\nvec3 spotLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n#endif\n#endif\n#ifdef WRAP_AROUND\nvec3 spotLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\nspotLightWeighting = mix( spotLightWeighting, spotLightWeightingHalf, wrapRGB );\n#ifdef DOUBLE_SIDED\nspotLightWeightingBack = mix( spotLightWeightingBack, spotLightWeightingHalfBack, wrapRGB );\n#endif\n#endif\nvLightFront += spotLightColor[ i ] * spotLightWeighting * lDistance * spotEffect;\n#ifdef DOUBLE_SIDED\nvLightBack += spotLightColor[ i ] * spotLightWeightingBack * lDistance * spotEffect;\n#endif\n}\n}\n#endif\nvLightFront = vLightFront * diffuse + ambient * ambientLightColor + emissive;\n#ifdef DOUBLE_SIDED\nvLightBack = vLightBack * diffuse + ambient * ambientLightColor + emissive;\n#endif",
lights_phong_pars_vertex:"#ifndef PHONG_PER_PIXEL\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#if MAX_SPOT_LIGHTS > 0\nuniform vec3 spotLightPosition[ MAX_SPOT_LIGHTS ];\nuniform float spotLightDistance[ MAX_SPOT_LIGHTS ];\nvarying vec4 vSpotLight[ MAX_SPOT_LIGHTS ];\n#endif\n#endif\n#if MAX_SPOT_LIGHTS > 0\nvarying vec3 vWorldPosition;\n#endif",lights_phong_vertex:"#ifndef PHONG_PER_PIXEL\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#if MAX_SPOT_LIGHTS > 0\nfor( int i = 0; i < MAX_SPOT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( spotLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( spotLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / spotLightDistance[ i ] ), 1.0 );\nvSpotLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#endif\n#if MAX_SPOT_LIGHTS > 0\nvWorldPosition = mPosition.xyz;\n#endif",
lights_phong_pars_fragment:"uniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\n#ifdef PHONG_PER_PIXEL\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#else\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif\n#if MAX_SPOT_LIGHTS > 0\nuniform vec3 spotLightColor[ MAX_SPOT_LIGHTS ];\nuniform vec3 spotLightPosition[ MAX_SPOT_LIGHTS ];\nuniform vec3 spotLightDirection[ MAX_SPOT_LIGHTS ];\nuniform float spotLightAngle[ MAX_SPOT_LIGHTS ];\nuniform float spotLightExponent[ MAX_SPOT_LIGHTS ];\n#ifdef PHONG_PER_PIXEL\nuniform float spotLightDistance[ MAX_SPOT_LIGHTS ];\n#else\nvarying vec4 vSpotLight[ MAX_SPOT_LIGHTS ];\n#endif\nvarying vec3 vWorldPosition;\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",
lights_phong_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#ifdef DOUBLE_SIDED\nnormal = normal * ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n#endif\n#if MAX_POINT_LIGHTS > 0\nvec3 pointDiffuse  = vec3( 0.0 );\nvec3 pointSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\n#ifdef PHONG_PER_PIXEL\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz + vViewPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\n#else\nvec3 lVector = normalize( vPointLight[ i ].xyz );\nfloat lDistance = vPointLight[ i ].w;\n#endif\nfloat dotProduct = dot( normal, lVector );\n#ifdef WRAP_AROUND\nfloat pointDiffuseWeightFull = max( dotProduct, 0.0 );\nfloat pointDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\nvec3 pointDiffuseWeight = mix( vec3 ( pointDiffuseWeightFull ), vec3( pointDiffuseWeightHalf ), wrapRGB );\n#else\nfloat pointDiffuseWeight = max( dotProduct, 0.0 );\n#endif\npointDiffuse  += diffuse * pointLightColor[ i ] * pointDiffuseWeight * lDistance;\nvec3 pointHalfVector = normalize( lVector + viewPosition );\nfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointSpecularWeight = max( pow( pointDotNormalHalf, shininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nfloat specularNormalization = ( shininess + 2.0001 ) / 8.0;\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( 1.0 - dot( lVector, pointHalfVector ), 5.0 );\npointSpecular += schlick * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * lDistance * specularNormalization;\n#else\npointSpecular += specular * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * lDistance;\n#endif\n}\n#endif\n#if MAX_SPOT_LIGHTS > 0\nvec3 spotDiffuse  = vec3( 0.0 );\nvec3 spotSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_SPOT_LIGHTS; i ++ ) {\n#ifdef PHONG_PER_PIXEL\nvec4 lPosition = viewMatrix * vec4( spotLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz + vViewPosition.xyz;\nfloat lDistance = 1.0;\nif ( spotLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / spotLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\n#else\nvec3 lVector = normalize( vSpotLight[ i ].xyz );\nfloat lDistance = vSpotLight[ i ].w;\n#endif\nfloat spotEffect = dot( spotLightDirection[ i ], normalize( spotLightPosition[ i ] - vWorldPosition ) );\nif ( spotEffect > spotLightAngle[ i ] ) {\nspotEffect = pow( spotEffect, spotLightExponent[ i ] );\nfloat dotProduct = dot( normal, lVector );\n#ifdef WRAP_AROUND\nfloat spotDiffuseWeightFull = max( dotProduct, 0.0 );\nfloat spotDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\nvec3 spotDiffuseWeight = mix( vec3 ( spotDiffuseWeightFull ), vec3( spotDiffuseWeightHalf ), wrapRGB );\n#else\nfloat spotDiffuseWeight = max( dotProduct, 0.0 );\n#endif\nspotDiffuse += diffuse * spotLightColor[ i ] * spotDiffuseWeight * lDistance * spotEffect;\nvec3 spotHalfVector = normalize( lVector + viewPosition );\nfloat spotDotNormalHalf = max( dot( normal, spotHalfVector ), 0.0 );\nfloat spotSpecularWeight = max( pow( spotDotNormalHalf, shininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nfloat specularNormalization = ( shininess + 2.0001 ) / 8.0;\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( 1.0 - dot( lVector, spotHalfVector ), 5.0 );\nspotSpecular += schlick * spotLightColor[ i ] * spotSpecularWeight * spotDiffuseWeight * lDistance * specularNormalization * spotEffect;\n#else\nspotSpecular += specular * spotLightColor[ i ] * spotSpecularWeight * spotDiffuseWeight * lDistance * spotEffect;\n#endif\n}\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec3 dirDiffuse  = vec3( 0.0 );\nvec3 dirSpecular = vec3( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nfloat dotProduct = dot( normal, dirVector );\n#ifdef WRAP_AROUND\nfloat dirDiffuseWeightFull = max( dotProduct, 0.0 );\nfloat dirDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\nvec3 dirDiffuseWeight = mix( vec3( dirDiffuseWeightFull ), vec3( dirDiffuseWeightHalf ), wrapRGB );\n#else\nfloat dirDiffuseWeight = max( dotProduct, 0.0 );\n#endif\ndirDiffuse  += diffuse * directionalLightColor[ i ] * dirDiffuseWeight;\nvec3 dirHalfVector = normalize( dirVector + viewPosition );\nfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirSpecularWeight = max( pow( dirDotNormalHalf, shininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nfloat specularNormalization = ( shininess + 2.0001 ) / 8.0;\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( 1.0 - dot( dirVector, dirHalfVector ), 5.0 );\ndirSpecular += schlick * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight * specularNormalization;\n#else\ndirSpecular += specular * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight;\n#endif\n}\n#endif\nvec3 totalDiffuse = vec3( 0.0 );\nvec3 totalSpecular = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\ntotalDiffuse += dirDiffuse;\ntotalSpecular += dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalDiffuse += pointDiffuse;\ntotalSpecular += pointSpecular;\n#endif\n#if MAX_SPOT_LIGHTS > 0\ntotalDiffuse += spotDiffuse;\ntotalSpecular += spotSpecular;\n#endif\n#ifdef METAL\ngl_FragColor.xyz = gl_FragColor.xyz * ( emissive + totalDiffuse + ambientLightColor * ambient + totalSpecular );\n#else\ngl_FragColor.xyz = gl_FragColor.xyz * ( emissive + totalDiffuse + ambientLightColor * ambient ) + totalSpecular;\n#endif",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n#ifdef GAMMA_INPUT\nvColor = color * color;\n#else\nvColor = color;\n#endif\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * modelViewMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n#ifndef USE_MORPHNORMALS\nuniform float morphTargetInfluences[ 8 ];\n#else\nuniform float morphTargetInfluences[ 4 ];\n#endif\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n#ifndef USE_MORPHNORMALS\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n#endif\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\nvec3 morphedNormal = vec3( 0.0 );\nmorphedNormal +=  ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\nmorphedNormal +=  ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\nmorphedNormal +=  ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\nmorphedNormal +=  ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\nmorphedNormal += normal;\nvec3 transformedNormal = normalMatrix * morphedNormal;\n#else\nvec3 transformedNormal = normalMatrix * normal;\n#endif",
shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform vec2 shadowMapSize[ MAX_SHADOWS ];\nuniform float shadowDarkness[ MAX_SHADOWS ];\nuniform float shadowBias[ MAX_SHADOWS ];\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",shadowmap_fragment:"#ifdef USE_SHADOWMAP\n#ifdef SHADOWMAP_DEBUG\nvec3 frustumColors[3];\nfrustumColors[0] = vec3( 1.0, 0.5, 0.0 );\nfrustumColors[1] = vec3( 0.0, 1.0, 0.8 );\nfrustumColors[2] = vec3( 0.0, 0.5, 1.0 );\n#endif\n#ifdef SHADOWMAP_CASCADE\nint inFrustumCount = 0;\n#endif\nfloat fDepth;\nvec3 shadowColor = vec3( 1.0 );\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\nbool inFrustum = all( inFrustumVec );\n#ifdef SHADOWMAP_CASCADE\ninFrustumCount += int( inFrustum );\nbvec3 frustumTestVec = bvec3( inFrustum, inFrustumCount == 1, shadowCoord.z <= 1.0 );\n#else\nbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n#endif\nbool frustumTest = all( frustumTestVec );\nif ( frustumTest ) {\nshadowCoord.z += shadowBias[ i ];\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nconst float shadowDelta = 1.0 / 9.0;\nfloat xPixelOffset = 1.0 / shadowMapSize[ i ].x;\nfloat yPixelOffset = 1.0 / shadowMapSize[ i ].y;\nfloat dx0 = -1.25 * xPixelOffset;\nfloat dy0 = -1.25 * yPixelOffset;\nfloat dx1 = 1.25 * xPixelOffset;\nfloat dy1 = 1.25 * yPixelOffset;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, 0.0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, 0.0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nshadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness[ i ] * shadow ) );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < shadowCoord.z )\nshadowColor = shadowColor * vec3( 1.0 - shadowDarkness[ i ] );\n#endif\n}\n#ifdef SHADOWMAP_DEBUG\n#ifdef SHADOWMAP_CASCADE\nif ( inFrustum && inFrustumCount == 1 ) gl_FragColor.xyz *= frustumColors[ i ];\n#else\nif ( inFrustum ) gl_FragColor.xyz *= frustumColors[ i ];\n#endif\n#endif\n}\n#ifdef GAMMA_OUTPUT\nshadowColor *= shadowColor;\n#endif\ngl_FragColor.xyz = gl_FragColor.xyz * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\n#ifdef USE_MORPHTARGETS\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( morphed, 1.0 );\n#else\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n#endif\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif",
linear_to_gamma_fragment:"#ifdef GAMMA_OUTPUT\ngl_FragColor.xyz = sqrt( gl_FragColor.xyz );\n#endif"};
THREE.UniformsUtils={merge:function(a){var b,c,d,f={};for(b=0;b<a.length;b++){d=this.clone(a[b]);for(c in d)f[c]=d[c]}return f},clone:function(a){var b,c,d,f={};for(b in a){f[b]={};for(c in a[b]){d=a[b][c];f[b][c]=d instanceof THREE.Color||d instanceof THREE.Vector2||d instanceof THREE.Vector3||d instanceof THREE.Vector4||d instanceof THREE.Matrix4||d instanceof THREE.Texture?d.clone():d instanceof Array?d.slice():d}}return f}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},flipEnvMap:{type:"f",value:-1},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",
value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]},spotLightColor:{type:"fv",value:[]},spotLightPosition:{type:"fv",value:[]},spotLightDirection:{type:"fv",value:[]},spotLightDistance:{type:"fv1",
value:[]},spotLightAngle:{type:"fv1",value:[]},spotLightExponent:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:6,texture:[]},shadowMapSize:{type:"v2v",value:[]},shadowBias:{type:"fv1",
value:[]},shadowDarkness:{type:"fv1",value:[]},shadowMatrix:{type:"m4v",value:[]}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}"},normal:{uniforms:{opacity:{type:"f",
value:1}},vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalMatrix * normal;\ngl_Position = projectionMatrix * mvPosition;\n}",fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),vertexShader:[THREE.ShaderChunk.map_pars_vertex,
THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,
THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,
THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(16777215)},emissive:{type:"c",value:new THREE.Color(0)},wrapRGB:{type:"v3",value:new THREE.Vector3(1,
1,1)}}]),vertexShader:["varying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\nvarying vec3 vLightBack;\n#endif",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_lambert_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,
THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.morphnormal_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif",THREE.ShaderChunk.lights_lambert_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\nvarying vec3 vLightBack;\n#endif",
THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"#ifdef DOUBLE_SIDED\nif ( gl_FrontFacing )\ngl_FragColor.xyz *= vLightFront;\nelse\ngl_FragColor.xyz *= vLightBack;\n#else\ngl_FragColor.xyz *= vLightFront;\n#endif",
THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(16777215)},emissive:{type:"c",value:new THREE.Color(0)},specular:{type:"c",value:new THREE.Color(1118481)},
shininess:{type:"f",value:30},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),vertexShader:["varying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_phong_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",
THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = -mvPosition.xyz;",THREE.ShaderChunk.morphnormal_vertex,"vNormal = transformedNormal;",THREE.ShaderChunk.lights_phong_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_phong_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",
THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_phong_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,THREE.UniformsLib.shadowmap]),vertexShader:["uniform float size;\nuniform float scale;",
THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,
THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},depthRGBA:{uniforms:{},vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",
THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n"),fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}"}};
THREE.WebGLRenderer=function(a){function b(a,b){var c=a.vertices.length,d=b.material;if(d.attributes){if(a.__webglCustomAttributesList===void 0)a.__webglCustomAttributesList=[];for(var f in d.attributes){var g=d.attributes[f];if(!g.__webglInitialized||g.createUniqueBuffers){g.__webglInitialized=true;var h=1;g.type==="v2"?h=2:g.type==="v3"?h=3:g.type==="v4"?h=4:g.type==="c"&&(h=3);g.size=h;g.array=new Float32Array(c*h);g.buffer=e.createBuffer();g.buffer.belongsToAttribute=f;g.needsUpdate=true}a.__webglCustomAttributesList.push(g)}}}
function c(a,b){if(a.material&&!(a.material instanceof THREE.MeshFaceMaterial))return a.material;if(b.materialIndex>=0)return a.geometry.materials[b.materialIndex]}function d(a){return a instanceof THREE.MeshBasicMaterial&&!a.envMap||a instanceof THREE.MeshDepthMaterial?false:a&&a.shading!==void 0&&a.shading===THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading}function f(a){return a.map||a.lightMap||a instanceof THREE.ShaderMaterial?true:false}function g(a,b,c){var d,f,g,h,i=a.vertices;h=i.length;
var j=a.colors,k=j.length,l=a.__vertexArray,m=a.__colorArray,n=a.__sortArray,o=a.verticesNeedUpdate,r=a.colorsNeedUpdate,p=a.__webglCustomAttributesList;if(c.sortParticles){Pb.copy(tb);Pb.multiplySelf(c.matrixWorld);for(d=0;d<h;d++){f=i[d];Pa.copy(f);Pb.multiplyVector3(Pa);n[d]=[Pa.z,d]}n.sort(function(a,b){return b[0]-a[0]});for(d=0;d<h;d++){f=i[n[d][1]];g=d*3;l[g]=f.x;l[g+1]=f.y;l[g+2]=f.z}for(d=0;d<k;d++){g=d*3;f=j[n[d][1]];m[g]=f.r;m[g+1]=f.g;m[g+2]=f.b}if(p){j=0;for(k=p.length;j<k;j++){i=p[j];
if(i.boundTo===void 0||i.boundTo==="vertices"){g=0;f=i.value.length;if(i.size===1)for(d=0;d<f;d++){h=n[d][1];i.array[d]=i.value[h]}else if(i.size===2)for(d=0;d<f;d++){h=n[d][1];h=i.value[h];i.array[g]=h.x;i.array[g+1]=h.y;g=g+2}else if(i.size===3)if(i.type==="c")for(d=0;d<f;d++){h=n[d][1];h=i.value[h];i.array[g]=h.r;i.array[g+1]=h.g;i.array[g+2]=h.b;g=g+3}else for(d=0;d<f;d++){h=n[d][1];h=i.value[h];i.array[g]=h.x;i.array[g+1]=h.y;i.array[g+2]=h.z;g=g+3}else if(i.size===4)for(d=0;d<f;d++){h=n[d][1];
h=i.value[h];i.array[g]=h.x;i.array[g+1]=h.y;i.array[g+2]=h.z;i.array[g+3]=h.w;g=g+4}}}}}else{if(o)for(d=0;d<h;d++){f=i[d];g=d*3;l[g]=f.x;l[g+1]=f.y;l[g+2]=f.z}if(r)for(d=0;d<k;d++){f=j[d];g=d*3;m[g]=f.r;m[g+1]=f.g;m[g+2]=f.b}if(p){j=0;for(k=p.length;j<k;j++){i=p[j];if(i.needsUpdate&&(i.boundTo===void 0||i.boundTo==="vertices")){f=i.value.length;g=0;if(i.size===1)for(d=0;d<f;d++)i.array[d]=i.value[d];else if(i.size===2)for(d=0;d<f;d++){h=i.value[d];i.array[g]=h.x;i.array[g+1]=h.y;g=g+2}else if(i.size===
3)if(i.type==="c")for(d=0;d<f;d++){h=i.value[d];i.array[g]=h.r;i.array[g+1]=h.g;i.array[g+2]=h.b;g=g+3}else for(d=0;d<f;d++){h=i.value[d];i.array[g]=h.x;i.array[g+1]=h.y;i.array[g+2]=h.z;g=g+3}else if(i.size===4)for(d=0;d<f;d++){h=i.value[d];i.array[g]=h.x;i.array[g+1]=h.y;i.array[g+2]=h.z;i.array[g+3]=h.w;g=g+4}}}}}if(o||c.sortParticles){e.bindBuffer(e.ARRAY_BUFFER,a.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,l,b)}if(r||c.sortParticles){e.bindBuffer(e.ARRAY_BUFFER,a.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,
m,b)}if(p){j=0;for(k=p.length;j<k;j++){i=p[j];if(i.needsUpdate||c.sortParticles){e.bindBuffer(e.ARRAY_BUFFER,i.buffer);e.bufferData(e.ARRAY_BUFFER,i.array,b)}}}}function h(a,b){return b.z-a.z}function l(a,b,c){if(a.length)for(var d=0,e=a.length;d<e;d++){ma=X=null;la=S=L=ra=Fa=Oa=Aa=-1;nb=true;a[d].render(b,c,sc,Zb);ma=X=null;la=S=L=ra=Fa=Oa=Aa=-1;nb=true}}function m(a,b,c,d,e,f,g,h){var i,j,k,l;if(b){j=a.length-1;l=b=-1}else{j=0;b=a.length;l=1}for(var m=j;m!==b;m=m+l){i=a[m];if(i.render){j=i.object;
k=i.buffer;if(h)i=h;else{i=i[c];if(!i)continue;g&&E.setBlending(i.blending,i.blendEquation,i.blendSrc,i.blendDst);E.setDepthTest(i.depthTest);E.setDepthWrite(i.depthWrite);w(i.polygonOffset,i.polygonOffsetFactor,i.polygonOffsetUnits)}E.setObjectFaces(j);k instanceof THREE.BufferGeometry?E.renderBufferDirect(d,e,f,i,k,j):E.renderBuffer(d,e,f,i,k,j)}}}function j(a,b,c,d,e,f,g){for(var i,h,j=0,k=a.length;j<k;j++){i=a[j];h=i.object;if(h.visible){if(g)i=g;else{i=i[b];if(!i)continue;f&&E.setBlending(i.blending,
i.blendEquation,i.blendSrc,i.blendDst);E.setDepthTest(i.depthTest);E.setDepthWrite(i.depthWrite);w(i.polygonOffset,i.polygonOffsetFactor,i.polygonOffsetUnits)}E.renderImmediateObject(c,d,e,i,h)}}}function i(a,b,c){a.push({buffer:b,object:c,opaque:null,transparent:null})}function o(a){for(var b in a.attributes)if(a.attributes[b].needsUpdate)return true;return false}function k(a){for(var b in a.attributes)a.attributes[b].needsUpdate=false}function u(a,b){for(var c=a.length-1;c>=0;c--)a[c].object===
b&&a.splice(c,1)}function r(a,b){for(var c=a.length-1;c>=0;c--)a[c]===b&&a.splice(c,1)}function n(a,b,c,d,f){if(!d.program||d.needsUpdate){E.initMaterial(d,b,c,f);d.needsUpdate=false}if(d.morphTargets&&!f.__webglMorphTargetInfluences){f.__webglMorphTargetInfluences=new Float32Array(E.maxMorphTargets);for(var g=0,i=E.maxMorphTargets;g<i;g++)f.__webglMorphTargetInfluences[g]=0}var h=false,g=d.program,i=g.uniforms,j=d.uniforms;if(g!==X){e.useProgram(g);X=g;h=true}if(d.id!==la){la=d.id;h=true}if(h||a!==
ma){e.uniformMatrix4fv(i.projectionMatrix,false,a._projectionMatrixArray);a!==ma&&(ma=a)}if(h){if(c&&d.fog){j.fogColor.value=c.color;if(c instanceof THREE.Fog){j.fogNear.value=c.near;j.fogFar.value=c.far}else if(c instanceof THREE.FogExp2)j.fogDensity.value=c.density}if(d instanceof THREE.MeshPhongMaterial||d instanceof THREE.MeshLambertMaterial||d.lights){if(nb){for(var k,l=0,m=0,n=0,o,r,p,q=$b,u=q.directional.colors,s=q.directional.positions,w=q.point.colors,z=q.point.positions,B=q.point.distances,
D=q.spot.colors,F=q.spot.positions,H=q.spot.distances,P=q.spot.directions,Q=q.spot.angles,R=q.spot.exponents,G=0,S=0,T=0,L=p=0,c=L=0,h=b.length;c<h;c++){k=b[c];if(!k.onlyShadow){o=k.color;r=k.intensity;p=k.distance;if(k instanceof THREE.AmbientLight)if(E.gammaInput){l=l+o.r*o.r;m=m+o.g*o.g;n=n+o.b*o.b}else{l=l+o.r;m=m+o.g;n=n+o.b}else if(k instanceof THREE.DirectionalLight){p=G*3;if(E.gammaInput){u[p]=o.r*o.r*r*r;u[p+1]=o.g*o.g*r*r;u[p+2]=o.b*o.b*r*r}else{u[p]=o.r*r;u[p+1]=o.g*r;u[p+2]=o.b*r}La.copy(k.matrixWorld.getPosition());
La.subSelf(k.target.matrixWorld.getPosition());La.normalize();s[p]=La.x;s[p+1]=La.y;s[p+2]=La.z;G=G+1}else if(k instanceof THREE.PointLight){L=S*3;if(E.gammaInput){w[L]=o.r*o.r*r*r;w[L+1]=o.g*o.g*r*r;w[L+2]=o.b*o.b*r*r}else{w[L]=o.r*r;w[L+1]=o.g*r;w[L+2]=o.b*r}o=k.matrixWorld.getPosition();z[L]=o.x;z[L+1]=o.y;z[L+2]=o.z;B[S]=p;S=S+1}else if(k instanceof THREE.SpotLight){L=T*3;if(E.gammaInput){D[L]=o.r*o.r*r*r;D[L+1]=o.g*o.g*r*r;D[L+2]=o.b*o.b*r*r}else{D[L]=o.r*r;D[L+1]=o.g*r;D[L+2]=o.b*r}o=k.matrixWorld.getPosition();
F[L]=o.x;F[L+1]=o.y;F[L+2]=o.z;H[T]=p;La.copy(o);La.subSelf(k.target.matrixWorld.getPosition());La.normalize();P[L]=La.x;P[L+1]=La.y;P[L+2]=La.z;Q[T]=Math.cos(k.angle);R[T]=k.exponent;T=T+1}}}c=G*3;for(h=u.length;c<h;c++)u[c]=0;c=S*3;for(h=w.length;c<h;c++)w[c]=0;c=T*3;for(h=D.length;c<h;c++)D[c]=0;q.directional.length=G;q.point.length=S;q.spot.length=T;q.ambient[0]=l;q.ambient[1]=m;q.ambient[2]=n;nb=false}c=$b;j.ambientLightColor.value=c.ambient;j.directionalLightColor.value=c.directional.colors;
j.directionalLightDirection.value=c.directional.positions;j.pointLightColor.value=c.point.colors;j.pointLightPosition.value=c.point.positions;j.pointLightDistance.value=c.point.distances;j.spotLightColor.value=c.spot.colors;j.spotLightPosition.value=c.spot.positions;j.spotLightDistance.value=c.spot.distances;j.spotLightDirection.value=c.spot.directions;j.spotLightAngle.value=c.spot.angles;j.spotLightExponent.value=c.spot.exponents}if(d instanceof THREE.MeshBasicMaterial||d instanceof THREE.MeshLambertMaterial||
d instanceof THREE.MeshPhongMaterial){j.opacity.value=d.opacity;E.gammaInput?j.diffuse.value.copyGammaToLinear(d.color):j.diffuse.value=d.color;(j.map.texture=d.map)&&j.offsetRepeat.value.set(d.map.offset.x,d.map.offset.y,d.map.repeat.x,d.map.repeat.y);j.lightMap.texture=d.lightMap;j.envMap.texture=d.envMap;j.flipEnvMap.value=d.envMap instanceof THREE.WebGLRenderTargetCube?1:-1;j.reflectivity.value=d.reflectivity;j.refractionRatio.value=d.refractionRatio;j.combine.value=d.combine;j.useRefract.value=
d.envMap&&d.envMap.mapping instanceof THREE.CubeRefractionMapping}if(d instanceof THREE.LineBasicMaterial){j.diffuse.value=d.color;j.opacity.value=d.opacity}else if(d instanceof THREE.ParticleBasicMaterial){j.psColor.value=d.color;j.opacity.value=d.opacity;j.size.value=d.size;j.scale.value=C.height/2;j.map.texture=d.map}else if(d instanceof THREE.MeshPhongMaterial){j.shininess.value=d.shininess;if(E.gammaInput){j.ambient.value.copyGammaToLinear(d.ambient);j.emissive.value.copyGammaToLinear(d.emissive);
j.specular.value.copyGammaToLinear(d.specular)}else{j.ambient.value=d.ambient;j.emissive.value=d.emissive;j.specular.value=d.specular}d.wrapAround&&j.wrapRGB.value.copy(d.wrapRGB)}else if(d instanceof THREE.MeshLambertMaterial){if(E.gammaInput){j.ambient.value.copyGammaToLinear(d.ambient);j.emissive.value.copyGammaToLinear(d.emissive)}else{j.ambient.value=d.ambient;j.emissive.value=d.emissive}d.wrapAround&&j.wrapRGB.value.copy(d.wrapRGB)}else if(d instanceof THREE.MeshDepthMaterial){j.mNear.value=
a.near;j.mFar.value=a.far;j.opacity.value=d.opacity}else if(d instanceof THREE.MeshNormalMaterial)j.opacity.value=d.opacity;if(f.receiveShadow&&!d._shadowPass&&j.shadowMatrix){h=c=0;for(k=b.length;h<k;h++){l=b[h];if(l.castShadow&&(l instanceof THREE.SpotLight||l instanceof THREE.DirectionalLight&&!l.shadowCascade)){j.shadowMap.texture[c]=l.shadowMap;j.shadowMapSize.value[c]=l.shadowMapSize;j.shadowMatrix.value[c]=l.shadowMatrix;j.shadowDarkness.value[c]=l.shadowDarkness;j.shadowBias.value[c]=l.shadowBias;
c++}}}b=d.uniformsList;j=0;for(c=b.length;j<c;j++)if(l=g.uniforms[b[j][1]]){h=b[j][0];m=h.type;k=h.value;switch(m){case "i":e.uniform1i(l,k);break;case "f":e.uniform1f(l,k);break;case "v2":e.uniform2f(l,k.x,k.y);break;case "v3":e.uniform3f(l,k.x,k.y,k.z);break;case "v4":e.uniform4f(l,k.x,k.y,k.z,k.w);break;case "c":e.uniform3f(l,k.r,k.g,k.b);break;case "fv1":e.uniform1fv(l,k);break;case "fv":e.uniform3fv(l,k);break;case "v2v":if(!h._array)h._array=new Float32Array(2*k.length);m=0;for(n=k.length;m<
n;m++){q=m*2;h._array[q]=k[m].x;h._array[q+1]=k[m].y}e.uniform2fv(l,h._array);break;case "v3v":if(!h._array)h._array=new Float32Array(3*k.length);m=0;for(n=k.length;m<n;m++){q=m*3;h._array[q]=k[m].x;h._array[q+1]=k[m].y;h._array[q+2]=k[m].z}e.uniform3fv(l,h._array);break;case "v4v":if(!h._array)h._array=new Float32Array(4*k.length);m=0;for(n=k.length;m<n;m++){q=m*4;h._array[q]=k[m].x;h._array[q+1]=k[m].y;h._array[q+2]=k[m].z;h._array[q+3]=k[m].w}e.uniform4fv(l,h._array);break;case "m4":if(!h._array)h._array=
new Float32Array(16);k.flattenToArray(h._array);e.uniformMatrix4fv(l,false,h._array);break;case "m4v":if(!h._array)h._array=new Float32Array(16*k.length);m=0;for(n=k.length;m<n;m++)k[m].flattenToArrayOffset(h._array,m*16);e.uniformMatrix4fv(l,false,h._array);break;case "t":e.uniform1i(l,k);l=h.texture;if(!l)continue;if(l.image instanceof Array&&l.image.length===6){h=l;if(h.image.length===6)if(h.needsUpdate){if(!h.image.__webglTextureCube)h.image.__webglTextureCube=e.createTexture();e.activeTexture(e.TEXTURE0+
k);e.bindTexture(e.TEXTURE_CUBE_MAP,h.image.__webglTextureCube);k=[];for(l=0;l<6;l++){m=k;n=l;if(E.autoScaleCubemaps){q=h.image[l];s=Ic;if(!(q.width<=s&&q.height<=s)){w=Math.max(q.width,q.height);u=Math.floor(q.width*s/w);s=Math.floor(q.height*s/w);w=document.createElement("canvas");w.width=u;w.height=s;w.getContext("2d").drawImage(q,0,0,q.width,q.height,0,0,u,s);q=w}}else q=h.image[l];m[n]=q}l=k[0];m=(l.width&l.width-1)===0&&(l.height&l.height-1)===0;n=J(h.format);q=J(h.type);I(e.TEXTURE_CUBE_MAP,
h,m);for(l=0;l<6;l++)e.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+l,0,n,n,q,k[l]);h.generateMipmaps&&m&&e.generateMipmap(e.TEXTURE_CUBE_MAP);h.needsUpdate=false;if(h.onUpdate)h.onUpdate()}else{e.activeTexture(e.TEXTURE0+k);e.bindTexture(e.TEXTURE_CUBE_MAP,h.image.__webglTextureCube)}}else if(l instanceof THREE.WebGLRenderTargetCube){h=l;e.activeTexture(e.TEXTURE0+k);e.bindTexture(e.TEXTURE_CUBE_MAP,h.__webglTexture)}else E.setTexture(l,k);break;case "tv":if(!h._array){h._array=[];m=0;for(n=h.texture.length;m<
n;m++)h._array[m]=k+m}e.uniform1iv(l,h._array);m=0;for(n=h.texture.length;m<n;m++)(l=h.texture[m])&&E.setTexture(l,h._array[m])}}if((d instanceof THREE.ShaderMaterial||d instanceof THREE.MeshPhongMaterial||d.envMap)&&i.cameraPosition!==null){b=a.matrixWorld.getPosition();e.uniform3f(i.cameraPosition,b.x,b.y,b.z)}(d instanceof THREE.MeshPhongMaterial||d instanceof THREE.MeshLambertMaterial||d instanceof THREE.ShaderMaterial||d.skinning)&&i.viewMatrix!==null&&e.uniformMatrix4fv(i.viewMatrix,false,a._viewMatrixArray);
d.skinning&&e.uniformMatrix4fv(i.boneGlobalMatrices,false,f.boneMatrices)}e.uniformMatrix4fv(i.modelViewMatrix,false,f._modelViewMatrix.elements);i.normalMatrix&&e.uniformMatrix3fv(i.normalMatrix,false,f._normalMatrix.elements);i.objectMatrix!==null&&e.uniformMatrix4fv(i.objectMatrix,false,f.matrixWorld.elements);return g}function p(a,b){a._modelViewMatrix.multiply(b.matrixWorldInverse,a.matrixWorld);a._normalMatrix.getInverse(a._modelViewMatrix);a._normalMatrix.transpose()}function w(a,b,c){if(pc!==
a){a?e.enable(e.POLYGON_OFFSET_FILL):e.disable(e.POLYGON_OFFSET_FILL);pc=a}if(a&&(qc!==b||rc!==c)){e.polygonOffset(b,c);qc=b;rc=c}}function q(a,b){var c;a==="fragment"?c=e.createShader(e.FRAGMENT_SHADER):a==="vertex"&&(c=e.createShader(e.VERTEX_SHADER));e.shaderSource(c,b);e.compileShader(c);if(!e.getShaderParameter(c,e.COMPILE_STATUS)){console.error(e.getShaderInfoLog(c));console.error(b);return null}return c}function I(a,b,c){if(c){e.texParameteri(a,e.TEXTURE_WRAP_S,J(b.wrapS));e.texParameteri(a,
e.TEXTURE_WRAP_T,J(b.wrapT));e.texParameteri(a,e.TEXTURE_MAG_FILTER,J(b.magFilter));e.texParameteri(a,e.TEXTURE_MIN_FILTER,J(b.minFilter))}else{e.texParameteri(a,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE);e.texParameteri(a,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE);e.texParameteri(a,e.TEXTURE_MAG_FILTER,s(b.magFilter));e.texParameteri(a,e.TEXTURE_MIN_FILTER,s(b.minFilter))}}function B(a,b){e.bindRenderbuffer(e.RENDERBUFFER,a);if(b.depthBuffer&&!b.stencilBuffer){e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_COMPONENT16,
b.width,b.height);e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,a)}else if(b.depthBuffer&&b.stencilBuffer){e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_STENCIL,b.width,b.height);e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,a)}else e.renderbufferStorage(e.RENDERBUFFER,e.RGBA4,b.width,b.height)}function s(a){switch(a){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return e.NEAREST;default:return e.LINEAR}}
function J(a){switch(a){case THREE.RepeatWrapping:return e.REPEAT;case THREE.ClampToEdgeWrapping:return e.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return e.MIRRORED_REPEAT;case THREE.NearestFilter:return e.NEAREST;case THREE.NearestMipMapNearestFilter:return e.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return e.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return e.LINEAR;case THREE.LinearMipMapNearestFilter:return e.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return e.LINEAR_MIPMAP_LINEAR;
case THREE.ByteType:return e.BYTE;case THREE.UnsignedByteType:return e.UNSIGNED_BYTE;case THREE.ShortType:return e.SHORT;case THREE.UnsignedShortType:return e.UNSIGNED_SHORT;case THREE.IntType:return e.INT;case THREE.UnsignedIntType:return e.UNSIGNED_INT;case THREE.FloatType:return e.FLOAT;case THREE.AlphaFormat:return e.ALPHA;case THREE.RGBFormat:return e.RGB;case THREE.RGBAFormat:return e.RGBA;case THREE.LuminanceFormat:return e.LUMINANCE;case THREE.LuminanceAlphaFormat:return e.LUMINANCE_ALPHA;
case THREE.AddEquation:return e.FUNC_ADD;case THREE.SubtractEquation:return e.FUNC_SUBTRACT;case THREE.ReverseSubtractEquation:return e.FUNC_REVERSE_SUBTRACT;case THREE.ZeroFactor:return e.ZERO;case THREE.OneFactor:return e.ONE;case THREE.SrcColorFactor:return e.SRC_COLOR;case THREE.OneMinusSrcColorFactor:return e.ONE_MINUS_SRC_COLOR;case THREE.SrcAlphaFactor:return e.SRC_ALPHA;case THREE.OneMinusSrcAlphaFactor:return e.ONE_MINUS_SRC_ALPHA;case THREE.DstAlphaFactor:return e.DST_ALPHA;case THREE.OneMinusDstAlphaFactor:return e.ONE_MINUS_DST_ALPHA;
case THREE.DstColorFactor:return e.DST_COLOR;case THREE.OneMinusDstColorFactor:return e.ONE_MINUS_DST_COLOR;case THREE.SrcAlphaSaturateFactor:return e.SRC_ALPHA_SATURATE}return 0}console.log("THREE.WebGLRenderer",THREE.REVISION);var a=a||{},C=a.canvas!==void 0?a.canvas:document.createElement("canvas"),G=a.precision!==void 0?a.precision:"highp",F=a.alpha!==void 0?a.alpha:true,P=a.premultipliedAlpha!==void 0?a.premultipliedAlpha:true,Q=a.antialias!==void 0?a.antialias:false,T=a.stencil!==void 0?a.stencil:
true,Z=a.preserveDrawingBuffer!==void 0?a.preserveDrawingBuffer:false,R=a.clearColor!==void 0?new THREE.Color(a.clearColor):new THREE.Color(0),z=a.clearAlpha!==void 0?a.clearAlpha:0,H=a.maxLights!==void 0?a.maxLights:4;this.domElement=C;this.context=null;this.autoUpdateScene=this.autoUpdateObjects=this.sortObjects=this.autoClearStencil=this.autoClearDepth=this.autoClearColor=this.autoClear=true;this.shadowMapEnabled=this.physicallyBasedShading=this.gammaOutput=this.gammaInput=false;this.shadowMapCullFrontFaces=
this.shadowMapSoft=this.shadowMapAutoUpdate=true;this.shadowMapCascade=this.shadowMapDebug=false;this.maxMorphTargets=8;this.maxMorphNormals=4;this.autoScaleCubemaps=true;this.renderPluginsPre=[];this.renderPluginsPost=[];this.info={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}};var E=this,e,Ba=[],X=null,D=null,la=-1,S=null,ma=null,ua=0,ra=-1,L=-1,Aa=-1,Ca=-1,Na=-1,Ua=-1,Oa=-1,Fa=-1,pc=null,qc=null,rc=null,mb=null,Ob=0,Yb=0,Hb=0,ac=0,sc=0,Zb=0,Ib=new THREE.Frustum,
tb=new THREE.Matrix4,Pb=new THREE.Matrix4,Pa=new THREE.Vector4,La=new THREE.Vector3,nb=true,$b={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]},spot:{length:0,colors:[],positions:[],distances:[],directions:[],angles:[],exponents:[]}};e=function(){var a;try{if(!(a=C.getContext("experimental-webgl",{alpha:F,premultipliedAlpha:P,antialias:Q,stencil:T,preserveDrawingBuffer:Z})))throw"Error creating WebGL context.";}catch(b){console.error(b)}a.getExtension("OES_texture_float")||
console.log("THREE.WebGLRenderer: Float textures not supported.");return a}();e.clearColor(0,0,0,1);e.clearDepth(1);e.clearStencil(0);e.enable(e.DEPTH_TEST);e.depthFunc(e.LEQUAL);e.frontFace(e.CCW);e.cullFace(e.BACK);e.enable(e.CULL_FACE);e.enable(e.BLEND);e.blendEquation(e.FUNC_ADD);e.blendFunc(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA);e.clearColor(R.r,R.g,R.b,z);this.context=e;var bc=e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS);e.getParameter(e.MAX_TEXTURE_SIZE);var Ic=e.getParameter(e.MAX_CUBE_MAP_TEXTURE_SIZE);
this.getContext=function(){return e};this.supportsVertexTextures=function(){return bc>0};this.setSize=function(a,b){C.width=a;C.height=b;this.setViewport(0,0,C.width,C.height)};this.setViewport=function(a,b,c,d){Ob=a;Yb=b;Hb=c;ac=d;e.viewport(Ob,Yb,Hb,ac)};this.setScissor=function(a,b,c,d){e.scissor(a,b,c,d)};this.enableScissorTest=function(a){a?e.enable(e.SCISSOR_TEST):e.disable(e.SCISSOR_TEST)};this.setClearColorHex=function(a,b){R.setHex(a);z=b;e.clearColor(R.r,R.g,R.b,z)};this.setClearColor=function(a,
b){R.copy(a);z=b;e.clearColor(R.r,R.g,R.b,z)};this.getClearColor=function(){return R};this.getClearAlpha=function(){return z};this.clear=function(a,b,c){var d=0;if(a===void 0||a)d=d|e.COLOR_BUFFER_BIT;if(b===void 0||b)d=d|e.DEPTH_BUFFER_BIT;if(c===void 0||c)d=d|e.STENCIL_BUFFER_BIT;e.clear(d)};this.clearTarget=function(a,b,c,d){this.setRenderTarget(a);this.clear(b,c,d)};this.addPostPlugin=function(a){a.init(this);this.renderPluginsPost.push(a)};this.addPrePlugin=function(a){a.init(this);this.renderPluginsPre.push(a)};
this.deallocateObject=function(a){if(a.__webglInit){a.__webglInit=false;delete a._modelViewMatrix;delete a._normalMatrix;delete a._normalMatrixArray;delete a._modelViewMatrixArray;delete a._objectMatrixArray;if(a instanceof THREE.Mesh)for(var b in a.geometry.geometryGroups){var c=a.geometry.geometryGroups[b];e.deleteBuffer(c.__webglVertexBuffer);e.deleteBuffer(c.__webglNormalBuffer);e.deleteBuffer(c.__webglTangentBuffer);e.deleteBuffer(c.__webglColorBuffer);e.deleteBuffer(c.__webglUVBuffer);e.deleteBuffer(c.__webglUV2Buffer);
e.deleteBuffer(c.__webglSkinVertexABuffer);e.deleteBuffer(c.__webglSkinVertexBBuffer);e.deleteBuffer(c.__webglSkinIndicesBuffer);e.deleteBuffer(c.__webglSkinWeightsBuffer);e.deleteBuffer(c.__webglFaceBuffer);e.deleteBuffer(c.__webglLineBuffer);var d=void 0,f=void 0;if(c.numMorphTargets){d=0;for(f=c.numMorphTargets;d<f;d++)e.deleteBuffer(c.__webglMorphTargetsBuffers[d])}if(c.numMorphNormals){d=0;for(f=c.numMorphNormals;d<f;d++)e.deleteBuffer(c.__webglMorphNormalsBuffers[d])}if(c.__webglCustomAttributesList){d=
void 0;for(d in c.__webglCustomAttributesList)e.deleteBuffer(c.__webglCustomAttributesList[d].buffer)}E.info.memory.geometries--}else if(a instanceof THREE.Ribbon){a=a.geometry;e.deleteBuffer(a.__webglVertexBuffer);e.deleteBuffer(a.__webglColorBuffer);E.info.memory.geometries--}else if(a instanceof THREE.Line){a=a.geometry;e.deleteBuffer(a.__webglVertexBuffer);e.deleteBuffer(a.__webglColorBuffer);E.info.memory.geometries--}else if(a instanceof THREE.ParticleSystem){a=a.geometry;e.deleteBuffer(a.__webglVertexBuffer);
e.deleteBuffer(a.__webglColorBuffer);E.info.memory.geometries--}}};this.deallocateTexture=function(a){if(a.__webglInit){a.__webglInit=false;e.deleteTexture(a.__webglTexture);E.info.memory.textures--}};this.deallocateRenderTarget=function(a){if(a&&a.__webglTexture){e.deleteTexture(a.__webglTexture);if(a instanceof THREE.WebGLRenderTargetCube)for(var b=0;b<6;b++){e.deleteFramebuffer(a.__webglFramebuffer[b]);e.deleteRenderbuffer(a.__webglRenderbuffer[b])}else{e.deleteFramebuffer(a.__webglFramebuffer);
e.deleteRenderbuffer(a.__webglRenderbuffer)}}};this.updateShadowMap=function(a,b){X=null;la=S=Fa=Oa=Aa=-1;nb=true;L=ra=-1;this.shadowMapPlugin.update(a,b)};this.renderBufferImmediate=function(a,b,c){if(!a.__webglVertexBuffer)a.__webglVertexBuffer=e.createBuffer();if(!a.__webglNormalBuffer)a.__webglNormalBuffer=e.createBuffer();if(a.hasPos){e.bindBuffer(e.ARRAY_BUFFER,a.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,a.positionArray,e.DYNAMIC_DRAW);e.enableVertexAttribArray(b.attributes.position);
e.vertexAttribPointer(b.attributes.position,3,e.FLOAT,false,0,0)}if(a.hasNormal){e.bindBuffer(e.ARRAY_BUFFER,a.__webglNormalBuffer);if(c===THREE.FlatShading){var d,f,g,h,i,j,k,l,m,n,o=a.count*3;for(n=0;n<o;n=n+9){c=a.normalArray;d=c[n];f=c[n+1];g=c[n+2];h=c[n+3];j=c[n+4];l=c[n+5];i=c[n+6];k=c[n+7];m=c[n+8];d=(d+h+i)/3;f=(f+j+k)/3;g=(g+l+m)/3;c[n]=d;c[n+1]=f;c[n+2]=g;c[n+3]=d;c[n+4]=f;c[n+5]=g;c[n+6]=d;c[n+7]=f;c[n+8]=g}}e.bufferData(e.ARRAY_BUFFER,a.normalArray,e.DYNAMIC_DRAW);e.enableVertexAttribArray(b.attributes.normal);
e.vertexAttribPointer(b.attributes.normal,3,e.FLOAT,false,0,0)}e.drawArrays(e.TRIANGLES,0,a.count);a.count=0};this.renderBufferDirect=function(a,b,c,d,f,g){if(d.visible!==false){c=n(a,b,c,d,g);a=c.attributes;b=false;d=f.id*16777215+c.id*2+(d.wireframe?1:0);if(d!==S){S=d;b=true}if(g instanceof THREE.Mesh){g=f.offsets;d=0;for(c=g.length;d<c;++d){if(b){e.bindBuffer(e.ARRAY_BUFFER,f.vertexPositionBuffer);e.vertexAttribPointer(a.position,f.vertexPositionBuffer.itemSize,e.FLOAT,false,0,g[d].index*12);if(a.normal>=
0&&f.vertexNormalBuffer){e.bindBuffer(e.ARRAY_BUFFER,f.vertexNormalBuffer);e.vertexAttribPointer(a.normal,f.vertexNormalBuffer.itemSize,e.FLOAT,false,0,g[d].index*12)}if(a.uv>=0&&f.vertexUvBuffer)if(f.vertexUvBuffer){e.bindBuffer(e.ARRAY_BUFFER,f.vertexUvBuffer);e.vertexAttribPointer(a.uv,f.vertexUvBuffer.itemSize,e.FLOAT,false,0,g[d].index*8);e.enableVertexAttribArray(a.uv)}else e.disableVertexAttribArray(a.uv);if(a.color>=0&&f.vertexColorBuffer){e.bindBuffer(e.ARRAY_BUFFER,f.vertexColorBuffer);
e.vertexAttribPointer(a.color,f.vertexColorBuffer.itemSize,e.FLOAT,false,0,g[d].index*16)}e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,f.vertexIndexBuffer)}e.drawElements(e.TRIANGLES,g[d].count,e.UNSIGNED_SHORT,g[d].start*2);E.info.render.calls++;E.info.render.vertices=E.info.render.vertices+g[d].count;E.info.render.faces=E.info.render.faces+g[d].count/3}}}};this.renderBuffer=function(a,b,c,d,f,g){if(d.visible!==false){var h,i,c=n(a,b,c,d,g),b=c.attributes,a=false,c=f.id*16777215+c.id*2+(d.wireframe?1:0);
if(c!==S){S=c;a=true}if(!d.morphTargets&&b.position>=0){if(a){e.bindBuffer(e.ARRAY_BUFFER,f.__webglVertexBuffer);e.vertexAttribPointer(b.position,3,e.FLOAT,false,0,0)}}else if(g.morphTargetBase){c=d.program.attributes;if(g.morphTargetBase!==-1){e.bindBuffer(e.ARRAY_BUFFER,f.__webglMorphTargetsBuffers[g.morphTargetBase]);e.vertexAttribPointer(c.position,3,e.FLOAT,false,0,0)}else if(c.position>=0){e.bindBuffer(e.ARRAY_BUFFER,f.__webglVertexBuffer);e.vertexAttribPointer(c.position,3,e.FLOAT,false,0,
0)}if(g.morphTargetForcedOrder.length){h=0;var j=g.morphTargetForcedOrder;for(i=g.morphTargetInfluences;h<d.numSupportedMorphTargets&&h<j.length;){e.bindBuffer(e.ARRAY_BUFFER,f.__webglMorphTargetsBuffers[j[h]]);e.vertexAttribPointer(c["morphTarget"+h],3,e.FLOAT,false,0,0);if(d.morphNormals){e.bindBuffer(e.ARRAY_BUFFER,f.__webglMorphNormalsBuffers[j[h]]);e.vertexAttribPointer(c["morphNormal"+h],3,e.FLOAT,false,0,0)}g.__webglMorphTargetInfluences[h]=i[j[h]];h++}}else{var j=[],k=-1,l=0;i=g.morphTargetInfluences;
var m,o=i.length;h=0;for(g.morphTargetBase!==-1&&(j[g.morphTargetBase]=true);h<d.numSupportedMorphTargets;){for(m=0;m<o;m++)if(!j[m]&&i[m]>k){l=m;k=i[l]}e.bindBuffer(e.ARRAY_BUFFER,f.__webglMorphTargetsBuffers[l]);e.vertexAttribPointer(c["morphTarget"+h],3,e.FLOAT,false,0,0);if(d.morphNormals){e.bindBuffer(e.ARRAY_BUFFER,f.__webglMorphNormalsBuffers[l]);e.vertexAttribPointer(c["morphNormal"+h],3,e.FLOAT,false,0,0)}g.__webglMorphTargetInfluences[h]=k;j[l]=1;k=-1;h++}}d.program.uniforms.morphTargetInfluences!==
null&&e.uniform1fv(d.program.uniforms.morphTargetInfluences,g.__webglMorphTargetInfluences)}if(a){if(f.__webglCustomAttributesList){h=0;for(i=f.__webglCustomAttributesList.length;h<i;h++){c=f.__webglCustomAttributesList[h];if(b[c.buffer.belongsToAttribute]>=0){e.bindBuffer(e.ARRAY_BUFFER,c.buffer);e.vertexAttribPointer(b[c.buffer.belongsToAttribute],c.size,e.FLOAT,false,0,0)}}}if(b.color>=0){e.bindBuffer(e.ARRAY_BUFFER,f.__webglColorBuffer);e.vertexAttribPointer(b.color,3,e.FLOAT,false,0,0)}if(b.normal>=
0){e.bindBuffer(e.ARRAY_BUFFER,f.__webglNormalBuffer);e.vertexAttribPointer(b.normal,3,e.FLOAT,false,0,0)}if(b.tangent>=0){e.bindBuffer(e.ARRAY_BUFFER,f.__webglTangentBuffer);e.vertexAttribPointer(b.tangent,4,e.FLOAT,false,0,0)}if(b.uv>=0)if(f.__webglUVBuffer){e.bindBuffer(e.ARRAY_BUFFER,f.__webglUVBuffer);e.vertexAttribPointer(b.uv,2,e.FLOAT,false,0,0);e.enableVertexAttribArray(b.uv)}else e.disableVertexAttribArray(b.uv);if(b.uv2>=0)if(f.__webglUV2Buffer){e.bindBuffer(e.ARRAY_BUFFER,f.__webglUV2Buffer);
e.vertexAttribPointer(b.uv2,2,e.FLOAT,false,0,0);e.enableVertexAttribArray(b.uv2)}else e.disableVertexAttribArray(b.uv2);if(d.skinning&&b.skinVertexA>=0&&b.skinVertexB>=0&&b.skinIndex>=0&&b.skinWeight>=0){e.bindBuffer(e.ARRAY_BUFFER,f.__webglSkinVertexABuffer);e.vertexAttribPointer(b.skinVertexA,4,e.FLOAT,false,0,0);e.bindBuffer(e.ARRAY_BUFFER,f.__webglSkinVertexBBuffer);e.vertexAttribPointer(b.skinVertexB,4,e.FLOAT,false,0,0);e.bindBuffer(e.ARRAY_BUFFER,f.__webglSkinIndicesBuffer);e.vertexAttribPointer(b.skinIndex,
4,e.FLOAT,false,0,0);e.bindBuffer(e.ARRAY_BUFFER,f.__webglSkinWeightsBuffer);e.vertexAttribPointer(b.skinWeight,4,e.FLOAT,false,0,0)}}if(g instanceof THREE.Mesh){if(d.wireframe){d=d.wireframeLinewidth;if(d!==mb){e.lineWidth(d);mb=d}a&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,f.__webglLineBuffer);e.drawElements(e.LINES,f.__webglLineCount,e.UNSIGNED_SHORT,0)}else{a&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,f.__webglFaceBuffer);e.drawElements(e.TRIANGLES,f.__webglFaceCount,e.UNSIGNED_SHORT,0)}E.info.render.calls++;
E.info.render.vertices=E.info.render.vertices+f.__webglFaceCount;E.info.render.faces=E.info.render.faces+f.__webglFaceCount/3}else if(g instanceof THREE.Line){g=g.type===THREE.LineStrip?e.LINE_STRIP:e.LINES;d=d.linewidth;if(d!==mb){e.lineWidth(d);mb=d}e.drawArrays(g,0,f.__webglLineCount);E.info.render.calls++}else if(g instanceof THREE.ParticleSystem){e.drawArrays(e.POINTS,0,f.__webglParticleCount);E.info.render.calls++;E.info.render.points=E.info.render.points+f.__webglParticleCount}else if(g instanceof
THREE.Ribbon){e.drawArrays(e.TRIANGLE_STRIP,0,f.__webglVertexCount);E.info.render.calls++}}};this.render=function(a,b,c,d){var f,g,i,k,n=a.__lights,o=a.fog;la=-1;nb=true;if(b.parent===void 0){console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it...");a.add(b)}this.autoUpdateScene&&a.updateMatrixWorld();if(!b._viewMatrixArray)b._viewMatrixArray=new Float32Array(16);if(!b._projectionMatrixArray)b._projectionMatrixArray=new Float32Array(16);b.matrixWorldInverse.getInverse(b.matrixWorld);
b.matrixWorldInverse.flattenToArray(b._viewMatrixArray);b.projectionMatrix.flattenToArray(b._projectionMatrixArray);tb.multiply(b.projectionMatrix,b.matrixWorldInverse);Ib.setFromMatrix(tb);this.autoUpdateObjects&&this.initWebGLObjects(a);l(this.renderPluginsPre,a,b);E.info.render.calls=0;E.info.render.vertices=0;E.info.render.faces=0;E.info.render.points=0;this.setRenderTarget(c);(this.autoClear||d)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil);k=a.__webglObjects;d=0;
for(f=k.length;d<f;d++){g=k[d];i=g.object;g.render=false;if(i.visible&&(!(i instanceof THREE.Mesh||i instanceof THREE.ParticleSystem)||!i.frustumCulled||Ib.contains(i))){p(i,b);var r=g,q=r.object,u=r.buffer,s=void 0,s=s=void 0,s=q.material;if(s instanceof THREE.MeshFaceMaterial){s=u.materialIndex;if(s>=0){s=q.geometry.materials[s];if(s.transparent){r.transparent=s;r.opaque=null}else{r.opaque=s;r.transparent=null}}}else if(s)if(s.transparent){r.transparent=s;r.opaque=null}else{r.opaque=s;r.transparent=
null}g.render=true;if(this.sortObjects)if(i.renderDepth)g.z=i.renderDepth;else{Pa.copy(i.matrixWorld.getPosition());tb.multiplyVector3(Pa);g.z=Pa.z}}}this.sortObjects&&k.sort(h);k=a.__webglObjectsImmediate;d=0;for(f=k.length;d<f;d++){g=k[d];i=g.object;if(i.visible){p(i,b);i=g.object.material;if(i.transparent){g.transparent=i;g.opaque=null}else{g.opaque=i;g.transparent=null}}}if(a.overrideMaterial){d=a.overrideMaterial;this.setBlending(d.blending,d.blendEquation,d.blendSrc,d.blendDst);this.setDepthTest(d.depthTest);
this.setDepthWrite(d.depthWrite);w(d.polygonOffset,d.polygonOffsetFactor,d.polygonOffsetUnits);m(a.__webglObjects,false,"",b,n,o,true,d);j(a.__webglObjectsImmediate,"",b,n,o,false,d)}else{this.setBlending(THREE.NormalBlending);m(a.__webglObjects,true,"opaque",b,n,o,false);j(a.__webglObjectsImmediate,"opaque",b,n,o,false);m(a.__webglObjects,false,"transparent",b,n,o,true);j(a.__webglObjectsImmediate,"transparent",b,n,o,true)}l(this.renderPluginsPost,a,b);if(c&&c.generateMipmaps&&c.minFilter!==THREE.NearestFilter&&
c.minFilter!==THREE.LinearFilter)if(c instanceof THREE.WebGLRenderTargetCube){e.bindTexture(e.TEXTURE_CUBE_MAP,c.__webglTexture);e.generateMipmap(e.TEXTURE_CUBE_MAP);e.bindTexture(e.TEXTURE_CUBE_MAP,null)}else{e.bindTexture(e.TEXTURE_2D,c.__webglTexture);e.generateMipmap(e.TEXTURE_2D);e.bindTexture(e.TEXTURE_2D,null)}this.setDepthTest(true);this.setDepthWrite(true)};this.renderImmediateObject=function(a,b,c,d,f){var g=n(a,b,c,d,f);S=-1;E.setObjectFaces(f);f.immediateRenderCallback?f.immediateRenderCallback(g,
e,Ib):f.render(function(a){E.renderBufferImmediate(a,g,d.shading)})};this.initWebGLObjects=function(a){if(!a.__webglObjects){a.__webglObjects=[];a.__webglObjectsImmediate=[];a.__webglSprites=[];a.__webglFlares=[]}for(;a.__objectsAdded.length;){var h=a.__objectsAdded[0],j=a,l=void 0,m=void 0,n=void 0;if(!h.__webglInit){h.__webglInit=true;h._modelViewMatrix=new THREE.Matrix4;h._normalMatrix=new THREE.Matrix3;if(h instanceof THREE.Mesh){m=h.geometry;if(m instanceof THREE.Geometry){if(m.geometryGroups===
void 0){var q=m,p=void 0,s=void 0,w=void 0,z=void 0,B=void 0,C=void 0,D=void 0,F={},I=q.morphTargets.length,J=q.morphNormals.length;q.geometryGroups={};p=0;for(s=q.faces.length;p<s;p++){w=q.faces[p];z=w.materialIndex;C=z!==void 0?z:-1;F[C]===void 0&&(F[C]={hash:C,counter:0});D=F[C].hash+"_"+F[C].counter;q.geometryGroups[D]===void 0&&(q.geometryGroups[D]={faces3:[],faces4:[],materialIndex:z,vertices:0,numMorphTargets:I,numMorphNormals:J});B=w instanceof THREE.Face3?3:4;if(q.geometryGroups[D].vertices+
B>65535){F[C].counter=F[C].counter+1;D=F[C].hash+"_"+F[C].counter;q.geometryGroups[D]===void 0&&(q.geometryGroups[D]={faces3:[],faces4:[],materialIndex:z,vertices:0,numMorphTargets:I,numMorphNormals:J})}w instanceof THREE.Face3?q.geometryGroups[D].faces3.push(p):q.geometryGroups[D].faces4.push(p);q.geometryGroups[D].vertices=q.geometryGroups[D].vertices+B}q.geometryGroupsList=[];var P=void 0;for(P in q.geometryGroups){q.geometryGroups[P].id=ua++;q.geometryGroupsList.push(q.geometryGroups[P])}}for(l in m.geometryGroups){n=
m.geometryGroups[l];if(!n.__webglVertexBuffer){var H=n;H.__webglVertexBuffer=e.createBuffer();H.__webglNormalBuffer=e.createBuffer();H.__webglTangentBuffer=e.createBuffer();H.__webglColorBuffer=e.createBuffer();H.__webglUVBuffer=e.createBuffer();H.__webglUV2Buffer=e.createBuffer();H.__webglSkinVertexABuffer=e.createBuffer();H.__webglSkinVertexBBuffer=e.createBuffer();H.__webglSkinIndicesBuffer=e.createBuffer();H.__webglSkinWeightsBuffer=e.createBuffer();H.__webglFaceBuffer=e.createBuffer();H.__webglLineBuffer=
e.createBuffer();var L=void 0,Q=void 0;if(H.numMorphTargets){H.__webglMorphTargetsBuffers=[];L=0;for(Q=H.numMorphTargets;L<Q;L++)H.__webglMorphTargetsBuffers.push(e.createBuffer())}if(H.numMorphNormals){H.__webglMorphNormalsBuffers=[];L=0;for(Q=H.numMorphNormals;L<Q;L++)H.__webglMorphNormalsBuffers.push(e.createBuffer())}E.info.memory.geometries++;var G=n,R=h,S=R.geometry,T=G.faces3,Z=G.faces4,X=T.length*3+Z.length*4,ma=T.length*1+Z.length*2,ra=T.length*3+Z.length*4,la=c(R,G),Aa=f(la),Ba=d(la),La=
la.vertexColors?la.vertexColors:false;G.__vertexArray=new Float32Array(X*3);if(Ba)G.__normalArray=new Float32Array(X*3);if(S.hasTangents)G.__tangentArray=new Float32Array(X*4);if(La)G.__colorArray=new Float32Array(X*3);if(Aa){if(S.faceUvs.length>0||S.faceVertexUvs.length>0)G.__uvArray=new Float32Array(X*2);if(S.faceUvs.length>1||S.faceVertexUvs.length>1)G.__uv2Array=new Float32Array(X*2)}if(R.geometry.skinWeights.length&&R.geometry.skinIndices.length){G.__skinVertexAArray=new Float32Array(X*4);G.__skinVertexBArray=
new Float32Array(X*4);G.__skinIndexArray=new Float32Array(X*4);G.__skinWeightArray=new Float32Array(X*4)}G.__faceArray=new Uint16Array(ma*3);G.__lineArray=new Uint16Array(ra*2);var Ca=void 0,Fa=void 0;if(G.numMorphTargets){G.__morphTargetsArrays=[];Ca=0;for(Fa=G.numMorphTargets;Ca<Fa;Ca++)G.__morphTargetsArrays.push(new Float32Array(X*3))}if(G.numMorphNormals){G.__morphNormalsArrays=[];Ca=0;for(Fa=G.numMorphNormals;Ca<Fa;Ca++)G.__morphNormalsArrays.push(new Float32Array(X*3))}G.__webglFaceCount=ma*
3;G.__webglLineCount=ra*2;if(la.attributes){if(G.__webglCustomAttributesList===void 0)G.__webglCustomAttributesList=[];var Oa=void 0;for(Oa in la.attributes){var Na=la.attributes[Oa],Ma={},Ua;for(Ua in Na)Ma[Ua]=Na[Ua];if(!Ma.__webglInitialized||Ma.createUniqueBuffers){Ma.__webglInitialized=true;var Pa=1;Ma.type==="v2"?Pa=2:Ma.type==="v3"?Pa=3:Ma.type==="v4"?Pa=4:Ma.type==="c"&&(Pa=3);Ma.size=Pa;Ma.array=new Float32Array(X*Pa);Ma.buffer=e.createBuffer();Ma.buffer.belongsToAttribute=Oa;Na.needsUpdate=
true;Ma.__original=Na}G.__webglCustomAttributesList.push(Ma)}}G.__inittedArrays=true;m.verticesNeedUpdate=true;m.morphTargetsNeedUpdate=true;m.elementsNeedUpdate=true;m.uvsNeedUpdate=true;m.normalsNeedUpdate=true;m.tangetsNeedUpdate=true;m.colorsNeedUpdate=true}}}}else if(h instanceof THREE.Ribbon){m=h.geometry;if(!m.__webglVertexBuffer){var nb=m;nb.__webglVertexBuffer=e.createBuffer();nb.__webglColorBuffer=e.createBuffer();E.info.memory.geometries++;var mb=m,tb=mb.vertices.length;mb.__vertexArray=
new Float32Array(tb*3);mb.__colorArray=new Float32Array(tb*3);mb.__webglVertexCount=tb;m.verticesNeedUpdate=true;m.colorsNeedUpdate=true}}else if(h instanceof THREE.Line){m=h.geometry;if(!m.__webglVertexBuffer){var Ob=m;Ob.__webglVertexBuffer=e.createBuffer();Ob.__webglColorBuffer=e.createBuffer();E.info.memory.geometries++;var cc=m,Yb=h,Hb=cc.vertices.length;cc.__vertexArray=new Float32Array(Hb*3);cc.__colorArray=new Float32Array(Hb*3);cc.__webglLineCount=Hb;b(cc,Yb);m.verticesNeedUpdate=true;m.colorsNeedUpdate=
true}}else if(h instanceof THREE.ParticleSystem){m=h.geometry;if(!m.__webglVertexBuffer){var Pb=m;Pb.__webglVertexBuffer=e.createBuffer();Pb.__webglColorBuffer=e.createBuffer();E.info.geometries++;var Qb=m,ac=h,Ib=Qb.vertices.length;Qb.__vertexArray=new Float32Array(Ib*3);Qb.__colorArray=new Float32Array(Ib*3);Qb.__sortArray=[];Qb.__webglParticleCount=Ib;b(Qb,ac);m.verticesNeedUpdate=true;m.colorsNeedUpdate=true}}}if(!h.__webglActive){if(h instanceof THREE.Mesh){m=h.geometry;if(m instanceof THREE.BufferGeometry)i(j.__webglObjects,
m,h);else for(l in m.geometryGroups){n=m.geometryGroups[l];i(j.__webglObjects,n,h)}}else if(h instanceof THREE.Ribbon||h instanceof THREE.Line||h instanceof THREE.ParticleSystem){m=h.geometry;i(j.__webglObjects,m,h)}else h instanceof THREE.ImmediateRenderObject||h.immediateRenderCallback?j.__webglObjectsImmediate.push({object:h,opaque:null,transparent:null}):h instanceof THREE.Sprite?j.__webglSprites.push(h):h instanceof THREE.LensFlare&&j.__webglFlares.push(h);h.__webglActive=true}a.__objectsAdded.splice(0,
1)}for(;a.__objectsRemoved.length;){var Qa=a.__objectsRemoved[0],tc=a;Qa instanceof THREE.Mesh||Qa instanceof THREE.ParticleSystem||Qa instanceof THREE.Ribbon||Qa instanceof THREE.Line?u(tc.__webglObjects,Qa):Qa instanceof THREE.Sprite?r(tc.__webglSprites,Qa):Qa instanceof THREE.LensFlare?r(tc.__webglFlares,Qa):(Qa instanceof THREE.ImmediateRenderObject||Qa.immediateRenderCallback)&&u(tc.__webglObjectsImmediate,Qa);Qa.__webglActive=false;a.__objectsRemoved.splice(0,1)}for(var Jc=0,pc=a.__webglObjects.length;Jc<
pc;Jc++){var Va=a.__webglObjects[Jc].object,Y=Va.geometry,dc=void 0,Rb=void 0,Ga=void 0;if(Va instanceof THREE.Mesh)if(Y instanceof THREE.BufferGeometry){Y.verticesNeedUpdate=false;Y.elementsNeedUpdate=false;Y.uvsNeedUpdate=false;Y.normalsNeedUpdate=false;Y.colorsNeedUpdate=false}else{for(var Kc=0,qc=Y.geometryGroupsList.length;Kc<qc;Kc++){dc=Y.geometryGroupsList[Kc];Ga=c(Va,dc);Rb=Ga.attributes&&o(Ga);if(Y.verticesNeedUpdate||Y.morphTargetsNeedUpdate||Y.elementsNeedUpdate||Y.uvsNeedUpdate||Y.normalsNeedUpdate||
Y.colorsNeedUpdate||Y.tangetsNeedUpdate||Rb){var V=dc,rc=Va,Ia=e.DYNAMIC_DRAW,sc=!Y.dynamic,Jb=Ga;if(V.__inittedArrays){var Zb=d(Jb),Lc=Jb.vertexColors?Jb.vertexColors:false,$b=f(Jb),uc=Zb===THREE.SmoothShading,x=void 0,K=void 0,Ta=void 0,A=void 0,Sb=void 0,ub=void 0,Wa=void 0,vc=void 0,ob=void 0,Tb=void 0,Ub=void 0,M=void 0,N=void 0,O=void 0,ca=void 0,Xa=void 0,Ya=void 0,Za=void 0,ec=void 0,$a=void 0,ab=void 0,bb=void 0,fc=void 0,cb=void 0,db=void 0,eb=void 0,gc=void 0,fb=void 0,gb=void 0,hb=void 0,
hc=void 0,ib=void 0,jb=void 0,kb=void 0,ic=void 0,vb=void 0,wb=void 0,xb=void 0,wc=void 0,yb=void 0,zb=void 0,Ab=void 0,xc=void 0,$=void 0,bc=void 0,Bb=void 0,Vb=void 0,Wb=void 0,va=void 0,Tc=void 0,sa=void 0,ta=void 0,Cb=void 0,pb=void 0,na=0,qa=0,qb=0,rb=0,Ra=0,za=0,da=0,Da=0,oa=0,y=0,U=0,v=0,Ja=void 0,wa=V.__vertexArray,jc=V.__uvArray,kc=V.__uv2Array,Sa=V.__normalArray,fa=V.__tangentArray,xa=V.__colorArray,ga=V.__skinVertexAArray,ha=V.__skinVertexBArray,ia=V.__skinIndexArray,ja=V.__skinWeightArray,
Mc=V.__morphTargetsArrays,Nc=V.__morphNormalsArrays,Oc=V.__webglCustomAttributesList,t=void 0,lb=V.__faceArray,Ka=V.__lineArray,Ea=rc.geometry,Ic=Ea.elementsNeedUpdate,Uc=Ea.uvsNeedUpdate,ad=Ea.normalsNeedUpdate,bd=Ea.tangetsNeedUpdate,cd=Ea.colorsNeedUpdate,dd=Ea.morphTargetsNeedUpdate,Kb=Ea.vertices,aa=V.faces3,ba=V.faces4,pa=Ea.faces,Pc=Ea.faceVertexUvs[0],Qc=Ea.faceVertexUvs[1],Lb=Ea.skinVerticesA,Mb=Ea.skinVerticesB,Nb=Ea.skinIndices,Db=Ea.skinWeights,Eb=Ea.morphTargets,yc=Ea.morphNormals;if(Ea.verticesNeedUpdate){x=
0;for(K=aa.length;x<K;x++){A=pa[aa[x]];M=Kb[A.a];N=Kb[A.b];O=Kb[A.c];wa[qa]=M.x;wa[qa+1]=M.y;wa[qa+2]=M.z;wa[qa+3]=N.x;wa[qa+4]=N.y;wa[qa+5]=N.z;wa[qa+6]=O.x;wa[qa+7]=O.y;wa[qa+8]=O.z;qa=qa+9}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];M=Kb[A.a];N=Kb[A.b];O=Kb[A.c];ca=Kb[A.d];wa[qa]=M.x;wa[qa+1]=M.y;wa[qa+2]=M.z;wa[qa+3]=N.x;wa[qa+4]=N.y;wa[qa+5]=N.z;wa[qa+6]=O.x;wa[qa+7]=O.y;wa[qa+8]=O.z;wa[qa+9]=ca.x;wa[qa+10]=ca.y;wa[qa+11]=ca.z;qa=qa+12}e.bindBuffer(e.ARRAY_BUFFER,V.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,
wa,Ia)}if(dd){va=0;for(Tc=Eb.length;va<Tc;va++){x=U=0;for(K=aa.length;x<K;x++){Cb=aa[x];A=pa[Cb];M=Eb[va].vertices[A.a];N=Eb[va].vertices[A.b];O=Eb[va].vertices[A.c];sa=Mc[va];sa[U]=M.x;sa[U+1]=M.y;sa[U+2]=M.z;sa[U+3]=N.x;sa[U+4]=N.y;sa[U+5]=N.z;sa[U+6]=O.x;sa[U+7]=O.y;sa[U+8]=O.z;if(Jb.morphNormals){if(uc){pb=yc[va].vertexNormals[Cb];$a=pb.a;ab=pb.b;bb=pb.c}else bb=ab=$a=yc[va].faceNormals[Cb];ta=Nc[va];ta[U]=$a.x;ta[U+1]=$a.y;ta[U+2]=$a.z;ta[U+3]=ab.x;ta[U+4]=ab.y;ta[U+5]=ab.z;ta[U+6]=bb.x;ta[U+
7]=bb.y;ta[U+8]=bb.z}U=U+9}x=0;for(K=ba.length;x<K;x++){Cb=ba[x];A=pa[Cb];M=Eb[va].vertices[A.a];N=Eb[va].vertices[A.b];O=Eb[va].vertices[A.c];ca=Eb[va].vertices[A.d];sa=Mc[va];sa[U]=M.x;sa[U+1]=M.y;sa[U+2]=M.z;sa[U+3]=N.x;sa[U+4]=N.y;sa[U+5]=N.z;sa[U+6]=O.x;sa[U+7]=O.y;sa[U+8]=O.z;sa[U+9]=ca.x;sa[U+10]=ca.y;sa[U+11]=ca.z;if(Jb.morphNormals){if(uc){pb=yc[va].vertexNormals[Cb];$a=pb.a;ab=pb.b;bb=pb.c;fc=pb.d}else fc=bb=ab=$a=yc[va].faceNormals[Cb];ta=Nc[va];ta[U]=$a.x;ta[U+1]=$a.y;ta[U+2]=$a.z;ta[U+
3]=ab.x;ta[U+4]=ab.y;ta[U+5]=ab.z;ta[U+6]=bb.x;ta[U+7]=bb.y;ta[U+8]=bb.z;ta[U+9]=fc.x;ta[U+10]=fc.y;ta[U+11]=fc.z}U=U+12}e.bindBuffer(e.ARRAY_BUFFER,V.__webglMorphTargetsBuffers[va]);e.bufferData(e.ARRAY_BUFFER,Mc[va],Ia);if(Jb.morphNormals){e.bindBuffer(e.ARRAY_BUFFER,V.__webglMorphNormalsBuffers[va]);e.bufferData(e.ARRAY_BUFFER,Nc[va],Ia)}}}if(Db.length){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];fb=Db[A.a];gb=Db[A.b];hb=Db[A.c];ja[y]=fb.x;ja[y+1]=fb.y;ja[y+2]=fb.z;ja[y+3]=fb.w;ja[y+4]=gb.x;ja[y+
5]=gb.y;ja[y+6]=gb.z;ja[y+7]=gb.w;ja[y+8]=hb.x;ja[y+9]=hb.y;ja[y+10]=hb.z;ja[y+11]=hb.w;ib=Nb[A.a];jb=Nb[A.b];kb=Nb[A.c];ia[y]=ib.x;ia[y+1]=ib.y;ia[y+2]=ib.z;ia[y+3]=ib.w;ia[y+4]=jb.x;ia[y+5]=jb.y;ia[y+6]=jb.z;ia[y+7]=jb.w;ia[y+8]=kb.x;ia[y+9]=kb.y;ia[y+10]=kb.z;ia[y+11]=kb.w;vb=Lb[A.a];wb=Lb[A.b];xb=Lb[A.c];ga[y]=vb.x;ga[y+1]=vb.y;ga[y+2]=vb.z;ga[y+3]=1;ga[y+4]=wb.x;ga[y+5]=wb.y;ga[y+6]=wb.z;ga[y+7]=1;ga[y+8]=xb.x;ga[y+9]=xb.y;ga[y+10]=xb.z;ga[y+11]=1;yb=Mb[A.a];zb=Mb[A.b];Ab=Mb[A.c];ha[y]=yb.x;
ha[y+1]=yb.y;ha[y+2]=yb.z;ha[y+3]=1;ha[y+4]=zb.x;ha[y+5]=zb.y;ha[y+6]=zb.z;ha[y+7]=1;ha[y+8]=Ab.x;ha[y+9]=Ab.y;ha[y+10]=Ab.z;ha[y+11]=1;y=y+12}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];fb=Db[A.a];gb=Db[A.b];hb=Db[A.c];hc=Db[A.d];ja[y]=fb.x;ja[y+1]=fb.y;ja[y+2]=fb.z;ja[y+3]=fb.w;ja[y+4]=gb.x;ja[y+5]=gb.y;ja[y+6]=gb.z;ja[y+7]=gb.w;ja[y+8]=hb.x;ja[y+9]=hb.y;ja[y+10]=hb.z;ja[y+11]=hb.w;ja[y+12]=hc.x;ja[y+13]=hc.y;ja[y+14]=hc.z;ja[y+15]=hc.w;ib=Nb[A.a];jb=Nb[A.b];kb=Nb[A.c];ic=Nb[A.d];ia[y]=ib.x;ia[y+1]=
ib.y;ia[y+2]=ib.z;ia[y+3]=ib.w;ia[y+4]=jb.x;ia[y+5]=jb.y;ia[y+6]=jb.z;ia[y+7]=jb.w;ia[y+8]=kb.x;ia[y+9]=kb.y;ia[y+10]=kb.z;ia[y+11]=kb.w;ia[y+12]=ic.x;ia[y+13]=ic.y;ia[y+14]=ic.z;ia[y+15]=ic.w;vb=Lb[A.a];wb=Lb[A.b];xb=Lb[A.c];wc=Lb[A.d];ga[y]=vb.x;ga[y+1]=vb.y;ga[y+2]=vb.z;ga[y+3]=1;ga[y+4]=wb.x;ga[y+5]=wb.y;ga[y+6]=wb.z;ga[y+7]=1;ga[y+8]=xb.x;ga[y+9]=xb.y;ga[y+10]=xb.z;ga[y+11]=1;ga[y+12]=wc.x;ga[y+13]=wc.y;ga[y+14]=wc.z;ga[y+15]=1;yb=Mb[A.a];zb=Mb[A.b];Ab=Mb[A.c];xc=Mb[A.d];ha[y]=yb.x;ha[y+1]=yb.y;
ha[y+2]=yb.z;ha[y+3]=1;ha[y+4]=zb.x;ha[y+5]=zb.y;ha[y+6]=zb.z;ha[y+7]=1;ha[y+8]=Ab.x;ha[y+9]=Ab.y;ha[y+10]=Ab.z;ha[y+11]=1;ha[y+12]=xc.x;ha[y+13]=xc.y;ha[y+14]=xc.z;ha[y+15]=1;y=y+16}if(y>0){e.bindBuffer(e.ARRAY_BUFFER,V.__webglSkinVertexABuffer);e.bufferData(e.ARRAY_BUFFER,ga,Ia);e.bindBuffer(e.ARRAY_BUFFER,V.__webglSkinVertexBBuffer);e.bufferData(e.ARRAY_BUFFER,ha,Ia);e.bindBuffer(e.ARRAY_BUFFER,V.__webglSkinIndicesBuffer);e.bufferData(e.ARRAY_BUFFER,ia,Ia);e.bindBuffer(e.ARRAY_BUFFER,V.__webglSkinWeightsBuffer);
e.bufferData(e.ARRAY_BUFFER,ja,Ia)}}if(cd&&Lc){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];Wa=A.vertexColors;vc=A.color;if(Wa.length===3&&Lc===THREE.VertexColors){cb=Wa[0];db=Wa[1];eb=Wa[2]}else eb=db=cb=vc;xa[oa]=cb.r;xa[oa+1]=cb.g;xa[oa+2]=cb.b;xa[oa+3]=db.r;xa[oa+4]=db.g;xa[oa+5]=db.b;xa[oa+6]=eb.r;xa[oa+7]=eb.g;xa[oa+8]=eb.b;oa=oa+9}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];Wa=A.vertexColors;vc=A.color;if(Wa.length===4&&Lc===THREE.VertexColors){cb=Wa[0];db=Wa[1];eb=Wa[2];gc=Wa[3]}else gc=eb=db=cb=
vc;xa[oa]=cb.r;xa[oa+1]=cb.g;xa[oa+2]=cb.b;xa[oa+3]=db.r;xa[oa+4]=db.g;xa[oa+5]=db.b;xa[oa+6]=eb.r;xa[oa+7]=eb.g;xa[oa+8]=eb.b;xa[oa+9]=gc.r;xa[oa+10]=gc.g;xa[oa+11]=gc.b;oa=oa+12}if(oa>0){e.bindBuffer(e.ARRAY_BUFFER,V.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,xa,Ia)}}if(bd&&Ea.hasTangents){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];ob=A.vertexTangents;Xa=ob[0];Ya=ob[1];Za=ob[2];fa[da]=Xa.x;fa[da+1]=Xa.y;fa[da+2]=Xa.z;fa[da+3]=Xa.w;fa[da+4]=Ya.x;fa[da+5]=Ya.y;fa[da+6]=Ya.z;fa[da+7]=Ya.w;fa[da+
8]=Za.x;fa[da+9]=Za.y;fa[da+10]=Za.z;fa[da+11]=Za.w;da=da+12}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];ob=A.vertexTangents;Xa=ob[0];Ya=ob[1];Za=ob[2];ec=ob[3];fa[da]=Xa.x;fa[da+1]=Xa.y;fa[da+2]=Xa.z;fa[da+3]=Xa.w;fa[da+4]=Ya.x;fa[da+5]=Ya.y;fa[da+6]=Ya.z;fa[da+7]=Ya.w;fa[da+8]=Za.x;fa[da+9]=Za.y;fa[da+10]=Za.z;fa[da+11]=Za.w;fa[da+12]=ec.x;fa[da+13]=ec.y;fa[da+14]=ec.z;fa[da+15]=ec.w;da=da+16}e.bindBuffer(e.ARRAY_BUFFER,V.__webglTangentBuffer);e.bufferData(e.ARRAY_BUFFER,fa,Ia)}if(ad&&Zb){x=0;for(K=
aa.length;x<K;x++){A=pa[aa[x]];Sb=A.vertexNormals;ub=A.normal;if(Sb.length===3&&uc)for($=0;$<3;$++){Bb=Sb[$];Sa[za]=Bb.x;Sa[za+1]=Bb.y;Sa[za+2]=Bb.z;za=za+3}else for($=0;$<3;$++){Sa[za]=ub.x;Sa[za+1]=ub.y;Sa[za+2]=ub.z;za=za+3}}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];Sb=A.vertexNormals;ub=A.normal;if(Sb.length===4&&uc)for($=0;$<4;$++){Bb=Sb[$];Sa[za]=Bb.x;Sa[za+1]=Bb.y;Sa[za+2]=Bb.z;za=za+3}else for($=0;$<4;$++){Sa[za]=ub.x;Sa[za+1]=ub.y;Sa[za+2]=ub.z;za=za+3}}e.bindBuffer(e.ARRAY_BUFFER,V.__webglNormalBuffer);
e.bufferData(e.ARRAY_BUFFER,Sa,Ia)}if(Uc&&Pc&&$b){x=0;for(K=aa.length;x<K;x++){Ta=aa[x];A=pa[Ta];Tb=Pc[Ta];if(Tb!==void 0)for($=0;$<3;$++){Vb=Tb[$];jc[qb]=Vb.u;jc[qb+1]=Vb.v;qb=qb+2}}x=0;for(K=ba.length;x<K;x++){Ta=ba[x];A=pa[Ta];Tb=Pc[Ta];if(Tb!==void 0)for($=0;$<4;$++){Vb=Tb[$];jc[qb]=Vb.u;jc[qb+1]=Vb.v;qb=qb+2}}if(qb>0){e.bindBuffer(e.ARRAY_BUFFER,V.__webglUVBuffer);e.bufferData(e.ARRAY_BUFFER,jc,Ia)}}if(Uc&&Qc&&$b){x=0;for(K=aa.length;x<K;x++){Ta=aa[x];A=pa[Ta];Ub=Qc[Ta];if(Ub!==void 0)for($=
0;$<3;$++){Wb=Ub[$];kc[rb]=Wb.u;kc[rb+1]=Wb.v;rb=rb+2}}x=0;for(K=ba.length;x<K;x++){Ta=ba[x];A=pa[Ta];Ub=Qc[Ta];if(Ub!==void 0)for($=0;$<4;$++){Wb=Ub[$];kc[rb]=Wb.u;kc[rb+1]=Wb.v;rb=rb+2}}if(rb>0){e.bindBuffer(e.ARRAY_BUFFER,V.__webglUV2Buffer);e.bufferData(e.ARRAY_BUFFER,kc,Ia)}}if(Ic){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];lb[Ra]=na;lb[Ra+1]=na+1;lb[Ra+2]=na+2;Ra=Ra+3;Ka[Da]=na;Ka[Da+1]=na+1;Ka[Da+2]=na;Ka[Da+3]=na+2;Ka[Da+4]=na+1;Ka[Da+5]=na+2;Da=Da+6;na=na+3}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];
lb[Ra]=na;lb[Ra+1]=na+1;lb[Ra+2]=na+3;lb[Ra+3]=na+1;lb[Ra+4]=na+2;lb[Ra+5]=na+3;Ra=Ra+6;Ka[Da]=na;Ka[Da+1]=na+1;Ka[Da+2]=na;Ka[Da+3]=na+3;Ka[Da+4]=na+1;Ka[Da+5]=na+2;Ka[Da+6]=na+2;Ka[Da+7]=na+3;Da=Da+8;na=na+4}e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,V.__webglFaceBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,lb,Ia);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,V.__webglLineBuffer);e.bufferData(e.ELEMENT_ARRAY_BUFFER,Ka,Ia)}if(Oc){$=0;for(bc=Oc.length;$<bc;$++){t=Oc[$];if(t.__original.needsUpdate){v=0;if(t.size===
1)if(t.boundTo===void 0||t.boundTo==="vertices"){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];t.array[v]=t.value[A.a];t.array[v+1]=t.value[A.b];t.array[v+2]=t.value[A.c];v=v+3}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];t.array[v]=t.value[A.a];t.array[v+1]=t.value[A.b];t.array[v+2]=t.value[A.c];t.array[v+3]=t.value[A.d];v=v+4}}else{if(t.boundTo==="faces"){x=0;for(K=aa.length;x<K;x++){Ja=t.value[aa[x]];t.array[v]=Ja;t.array[v+1]=Ja;t.array[v+2]=Ja;v=v+3}x=0;for(K=ba.length;x<K;x++){Ja=t.value[ba[x]];t.array[v]=
Ja;t.array[v+1]=Ja;t.array[v+2]=Ja;t.array[v+3]=Ja;v=v+4}}}else if(t.size===2)if(t.boundTo===void 0||t.boundTo==="vertices"){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];M=t.value[A.a];N=t.value[A.b];O=t.value[A.c];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=N.x;t.array[v+3]=N.y;t.array[v+4]=O.x;t.array[v+5]=O.y;v=v+6}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];M=t.value[A.a];N=t.value[A.b];O=t.value[A.c];ca=t.value[A.d];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=N.x;t.array[v+3]=N.y;t.array[v+4]=O.x;
t.array[v+5]=O.y;t.array[v+6]=ca.x;t.array[v+7]=ca.y;v=v+8}}else{if(t.boundTo==="faces"){x=0;for(K=aa.length;x<K;x++){O=N=M=Ja=t.value[aa[x]];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=N.x;t.array[v+3]=N.y;t.array[v+4]=O.x;t.array[v+5]=O.y;v=v+6}x=0;for(K=ba.length;x<K;x++){ca=O=N=M=Ja=t.value[ba[x]];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=N.x;t.array[v+3]=N.y;t.array[v+4]=O.x;t.array[v+5]=O.y;t.array[v+6]=ca.x;t.array[v+7]=ca.y;v=v+8}}}else if(t.size===3){var W;W=t.type==="c"?["r","g","b"]:
["x","y","z"];if(t.boundTo===void 0||t.boundTo==="vertices"){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];M=t.value[A.a];N=t.value[A.b];O=t.value[A.c];t.array[v]=M[W[0]];t.array[v+1]=M[W[1]];t.array[v+2]=M[W[2]];t.array[v+3]=N[W[0]];t.array[v+4]=N[W[1]];t.array[v+5]=N[W[2]];t.array[v+6]=O[W[0]];t.array[v+7]=O[W[1]];t.array[v+8]=O[W[2]];v=v+9}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];M=t.value[A.a];N=t.value[A.b];O=t.value[A.c];ca=t.value[A.d];t.array[v]=M[W[0]];t.array[v+1]=M[W[1]];t.array[v+2]=M[W[2]];
t.array[v+3]=N[W[0]];t.array[v+4]=N[W[1]];t.array[v+5]=N[W[2]];t.array[v+6]=O[W[0]];t.array[v+7]=O[W[1]];t.array[v+8]=O[W[2]];t.array[v+9]=ca[W[0]];t.array[v+10]=ca[W[1]];t.array[v+11]=ca[W[2]];v=v+12}}else if(t.boundTo==="faces"){x=0;for(K=aa.length;x<K;x++){O=N=M=Ja=t.value[aa[x]];t.array[v]=M[W[0]];t.array[v+1]=M[W[1]];t.array[v+2]=M[W[2]];t.array[v+3]=N[W[0]];t.array[v+4]=N[W[1]];t.array[v+5]=N[W[2]];t.array[v+6]=O[W[0]];t.array[v+7]=O[W[1]];t.array[v+8]=O[W[2]];v=v+9}x=0;for(K=ba.length;x<K;x++){ca=
O=N=M=Ja=t.value[ba[x]];t.array[v]=M[W[0]];t.array[v+1]=M[W[1]];t.array[v+2]=M[W[2]];t.array[v+3]=N[W[0]];t.array[v+4]=N[W[1]];t.array[v+5]=N[W[2]];t.array[v+6]=O[W[0]];t.array[v+7]=O[W[1]];t.array[v+8]=O[W[2]];t.array[v+9]=ca[W[0]];t.array[v+10]=ca[W[1]];t.array[v+11]=ca[W[2]];v=v+12}}}else if(t.size===4)if(t.boundTo===void 0||t.boundTo==="vertices"){x=0;for(K=aa.length;x<K;x++){A=pa[aa[x]];M=t.value[A.a];N=t.value[A.b];O=t.value[A.c];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=M.z;t.array[v+3]=
M.w;t.array[v+4]=N.x;t.array[v+5]=N.y;t.array[v+6]=N.z;t.array[v+7]=N.w;t.array[v+8]=O.x;t.array[v+9]=O.y;t.array[v+10]=O.z;t.array[v+11]=O.w;v=v+12}x=0;for(K=ba.length;x<K;x++){A=pa[ba[x]];M=t.value[A.a];N=t.value[A.b];O=t.value[A.c];ca=t.value[A.d];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=M.z;t.array[v+3]=M.w;t.array[v+4]=N.x;t.array[v+5]=N.y;t.array[v+6]=N.z;t.array[v+7]=N.w;t.array[v+8]=O.x;t.array[v+9]=O.y;t.array[v+10]=O.z;t.array[v+11]=O.w;t.array[v+12]=ca.x;t.array[v+13]=ca.y;t.array[v+
14]=ca.z;t.array[v+15]=ca.w;v=v+16}}else if(t.boundTo==="faces"){x=0;for(K=aa.length;x<K;x++){O=N=M=Ja=t.value[aa[x]];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=M.z;t.array[v+3]=M.w;t.array[v+4]=N.x;t.array[v+5]=N.y;t.array[v+6]=N.z;t.array[v+7]=N.w;t.array[v+8]=O.x;t.array[v+9]=O.y;t.array[v+10]=O.z;t.array[v+11]=O.w;v=v+12}x=0;for(K=ba.length;x<K;x++){ca=O=N=M=Ja=t.value[ba[x]];t.array[v]=M.x;t.array[v+1]=M.y;t.array[v+2]=M.z;t.array[v+3]=M.w;t.array[v+4]=N.x;t.array[v+5]=N.y;t.array[v+6]=N.z;
t.array[v+7]=N.w;t.array[v+8]=O.x;t.array[v+9]=O.y;t.array[v+10]=O.z;t.array[v+11]=O.w;t.array[v+12]=ca.x;t.array[v+13]=ca.y;t.array[v+14]=ca.z;t.array[v+15]=ca.w;v=v+16}}e.bindBuffer(e.ARRAY_BUFFER,t.buffer);e.bufferData(e.ARRAY_BUFFER,t.array,Ia)}}}if(sc){delete V.__inittedArrays;delete V.__colorArray;delete V.__normalArray;delete V.__tangentArray;delete V.__uvArray;delete V.__uv2Array;delete V.__faceArray;delete V.__vertexArray;delete V.__lineArray;delete V.__skinVertexAArray;delete V.__skinVertexBArray;
delete V.__skinIndexArray;delete V.__skinWeightArray}}}}Y.verticesNeedUpdate=false;Y.morphTargetsNeedUpdate=false;Y.elementsNeedUpdate=false;Y.uvsNeedUpdate=false;Y.normalsNeedUpdate=false;Y.colorsNeedUpdate=false;Y.tangetsNeedUpdate=false;Ga.attributes&&k(Ga)}else if(Va instanceof THREE.Ribbon){if(Y.verticesNeedUpdate||Y.colorsNeedUpdate){var Fb=Y,Vc=e.DYNAMIC_DRAW,lc=void 0,mc=void 0,zc=void 0,Gb=void 0,Ac=void 0,Wc=Fb.vertices,Xc=Fb.colors,ed=Wc.length,fd=Xc.length,Bc=Fb.__vertexArray,Cc=Fb.__colorArray,
gd=Fb.colorsNeedUpdate;if(Fb.verticesNeedUpdate){for(lc=0;lc<ed;lc++){zc=Wc[lc];Gb=lc*3;Bc[Gb]=zc.x;Bc[Gb+1]=zc.y;Bc[Gb+2]=zc.z}e.bindBuffer(e.ARRAY_BUFFER,Fb.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,Bc,Vc)}if(gd){for(mc=0;mc<fd;mc++){Ac=Xc[mc];Gb=mc*3;Cc[Gb]=Ac.r;Cc[Gb+1]=Ac.g;Cc[Gb+2]=Ac.b}e.bindBuffer(e.ARRAY_BUFFER,Fb.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,Cc,Vc)}}Y.verticesNeedUpdate=false;Y.colorsNeedUpdate=false}else if(Va instanceof THREE.Line){Ga=c(Va,dc);Rb=Ga.attributes&&
o(Ga);if(Y.verticesNeedUpdate||Y.colorsNeedUpdate||Rb){var sb=Y,Rc=e.DYNAMIC_DRAW,nc=void 0,oc=void 0,Dc=void 0,ka=void 0,Ec=void 0,Yc=sb.vertices,Zc=sb.colors,hd=Yc.length,id=Zc.length,Fc=sb.__vertexArray,Gc=sb.__colorArray,jd=sb.colorsNeedUpdate,Sc=sb.__webglCustomAttributesList,Hc=void 0,$c=void 0,ya=void 0,Xb=void 0,Ha=void 0,ea=void 0;if(sb.verticesNeedUpdate){for(nc=0;nc<hd;nc++){Dc=Yc[nc];ka=nc*3;Fc[ka]=Dc.x;Fc[ka+1]=Dc.y;Fc[ka+2]=Dc.z}e.bindBuffer(e.ARRAY_BUFFER,sb.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,
Fc,Rc)}if(jd){for(oc=0;oc<id;oc++){Ec=Zc[oc];ka=oc*3;Gc[ka]=Ec.r;Gc[ka+1]=Ec.g;Gc[ka+2]=Ec.b}e.bindBuffer(e.ARRAY_BUFFER,sb.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,Gc,Rc)}if(Sc){Hc=0;for($c=Sc.length;Hc<$c;Hc++){ea=Sc[Hc];if(ea.needsUpdate&&(ea.boundTo===void 0||ea.boundTo==="vertices")){ka=0;Xb=ea.value.length;if(ea.size===1)for(ya=0;ya<Xb;ya++)ea.array[ya]=ea.value[ya];else if(ea.size===2)for(ya=0;ya<Xb;ya++){Ha=ea.value[ya];ea.array[ka]=Ha.x;ea.array[ka+1]=Ha.y;ka=ka+2}else if(ea.size===
3)if(ea.type==="c")for(ya=0;ya<Xb;ya++){Ha=ea.value[ya];ea.array[ka]=Ha.r;ea.array[ka+1]=Ha.g;ea.array[ka+2]=Ha.b;ka=ka+3}else for(ya=0;ya<Xb;ya++){Ha=ea.value[ya];ea.array[ka]=Ha.x;ea.array[ka+1]=Ha.y;ea.array[ka+2]=Ha.z;ka=ka+3}else if(ea.size===4)for(ya=0;ya<Xb;ya++){Ha=ea.value[ya];ea.array[ka]=Ha.x;ea.array[ka+1]=Ha.y;ea.array[ka+2]=Ha.z;ea.array[ka+3]=Ha.w;ka=ka+4}e.bindBuffer(e.ARRAY_BUFFER,ea.buffer);e.bufferData(e.ARRAY_BUFFER,ea.array,Rc)}}}}Y.verticesNeedUpdate=false;Y.colorsNeedUpdate=
false;Ga.attributes&&k(Ga)}else if(Va instanceof THREE.ParticleSystem){Ga=c(Va,dc);Rb=Ga.attributes&&o(Ga);(Y.verticesNeedUpdate||Y.colorsNeedUpdate||Va.sortParticles||Rb)&&g(Y,e.DYNAMIC_DRAW,Va);Y.verticesNeedUpdate=false;Y.colorsNeedUpdate=false;Ga.attributes&&k(Ga)}}};this.initMaterial=function(a,b,c,d){var f,g,h;a instanceof THREE.MeshDepthMaterial?h="depth":a instanceof THREE.MeshNormalMaterial?h="normal":a instanceof THREE.MeshBasicMaterial?h="basic":a instanceof THREE.MeshLambertMaterial?h=
"lambert":a instanceof THREE.MeshPhongMaterial?h="phong":a instanceof THREE.LineBasicMaterial?h="basic":a instanceof THREE.ParticleBasicMaterial&&(h="particle_basic");if(h){var i=THREE.ShaderLib[h];a.uniforms=THREE.UniformsUtils.clone(i.uniforms);a.vertexShader=i.vertexShader;a.fragmentShader=i.fragmentShader}var j,k,l,m,n;j=m=n=i=0;for(k=b.length;j<k;j++){l=b[j];if(!l.onlyShadow){l instanceof THREE.DirectionalLight&&m++;l instanceof THREE.PointLight&&n++;l instanceof THREE.SpotLight&&i++}}if(n+i+
m<=H){k=m;l=n;m=i}else{k=Math.ceil(H*m/(n+m));m=l=H-k}var o=0,i=0;for(n=b.length;i<n;i++){j=b[i];if(j.castShadow){j instanceof THREE.SpotLight&&o++;j instanceof THREE.DirectionalLight&&!j.shadowCascade&&o++}}var r=50;if(d!==void 0&&d instanceof THREE.SkinnedMesh)r=d.bones.length;var p;a:{n=a.fragmentShader;j=a.vertexShader;var i=a.uniforms,b=a.attributes,c={map:!!a.map,envMap:!!a.envMap,lightMap:!!a.lightMap,vertexColors:a.vertexColors,fog:c,useFog:a.fog,sizeAttenuation:a.sizeAttenuation,skinning:a.skinning,
maxBones:r,morphTargets:a.morphTargets,morphNormals:a.morphNormals,maxMorphTargets:this.maxMorphTargets,maxMorphNormals:this.maxMorphNormals,maxDirLights:k,maxPointLights:l,maxSpotLights:m,maxShadows:o,shadowMapEnabled:this.shadowMapEnabled&&d.receiveShadow,shadowMapSoft:this.shadowMapSoft,shadowMapDebug:this.shadowMapDebug,shadowMapCascade:this.shadowMapCascade,alphaTest:a.alphaTest,metal:a.metal,perPixel:a.perPixel,wrapAround:a.wrapAround,doubleSided:d&&d.doubleSided},s,d=[];if(h)d.push(h);else{d.push(n);
d.push(j)}for(s in c){d.push(s);d.push(c[s])}h=d.join();s=0;for(d=Ba.length;s<d;s++)if(Ba[s].code===h){p=Ba[s].program;break a}s=e.createProgram();d=["precision "+G+" float;",bc>0?"#define VERTEX_TEXTURES":"",E.gammaInput?"#define GAMMA_INPUT":"",E.gammaOutput?"#define GAMMA_OUTPUT":"",E.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":"","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SPOT_LIGHTS "+c.maxSpotLights,"#define MAX_SHADOWS "+
c.maxShadows,"#define MAX_BONES "+c.maxBones,c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.skinning?"#define USE_SKINNING":"",c.morphTargets?"#define USE_MORPHTARGETS":"",c.morphNormals?"#define USE_MORPHNORMALS":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.wrapAround?"#define WRAP_AROUND":"",c.doubleSided?"#define DOUBLE_SIDED":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":
"",c.shadowMapDebug?"#define SHADOWMAP_DEBUG":"",c.shadowMapCascade?"#define SHADOWMAP_CASCADE":"",c.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\n#ifdef USE_MORPHNORMALS\nattribute vec3 morphNormal0;\nattribute vec3 morphNormal1;\nattribute vec3 morphNormal2;\nattribute vec3 morphNormal3;\n#else\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
k=["precision "+G+" float;","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SPOT_LIGHTS "+c.maxSpotLights,"#define MAX_SHADOWS "+c.maxShadows,c.alphaTest?"#define ALPHATEST "+c.alphaTest:"",E.gammaInput?"#define GAMMA_INPUT":"",E.gammaOutput?"#define GAMMA_OUTPUT":"",E.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":"",c.useFog&&c.fog?"#define USE_FOG":"",c.useFog&&c.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",c.map?"#define USE_MAP":
"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.metal?"#define METAL":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.wrapAround?"#define WRAP_AROUND":"",c.doubleSided?"#define DOUBLE_SIDED":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.shadowMapDebug?"#define SHADOWMAP_DEBUG":"",c.shadowMapCascade?"#define SHADOWMAP_CASCADE":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");
e.attachShader(s,q("fragment",k+n));e.attachShader(s,q("vertex",d+j));e.linkProgram(s);e.getProgramParameter(s,e.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+e.getProgramParameter(s,e.VALIDATE_STATUS)+", gl error ["+e.getError()+"]");s.uniforms={};s.attributes={};var u,d=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","boneGlobalMatrices","morphTargetInfluences"];for(u in i)d.push(u);u=d;d=0;for(i=u.length;d<i;d++){n=
u[d];s.uniforms[n]=e.getUniformLocation(s,n)}d=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(u=0;u<c.maxMorphTargets;u++)d.push("morphTarget"+u);for(u=0;u<c.maxMorphNormals;u++)d.push("morphNormal"+u);for(p in b)d.push(p);p=d;u=0;for(b=p.length;u<b;u++){c=p[u];s.attributes[c]=e.getAttribLocation(s,c)}s.id=Ba.length;Ba.push({program:s,code:h});E.info.memory.programs=Ba.length;p=s}a.program=p;p=a.program.attributes;p.position>=0&&e.enableVertexAttribArray(p.position);
p.color>=0&&e.enableVertexAttribArray(p.color);p.normal>=0&&e.enableVertexAttribArray(p.normal);p.tangent>=0&&e.enableVertexAttribArray(p.tangent);if(a.skinning&&p.skinVertexA>=0&&p.skinVertexB>=0&&p.skinIndex>=0&&p.skinWeight>=0){e.enableVertexAttribArray(p.skinVertexA);e.enableVertexAttribArray(p.skinVertexB);e.enableVertexAttribArray(p.skinIndex);e.enableVertexAttribArray(p.skinWeight)}if(a.attributes)for(g in a.attributes)p[g]!==void 0&&p[g]>=0&&e.enableVertexAttribArray(p[g]);if(a.morphTargets){a.numSupportedMorphTargets=
0;s="morphTarget";for(g=0;g<this.maxMorphTargets;g++){u=s+g;if(p[u]>=0){e.enableVertexAttribArray(p[u]);a.numSupportedMorphTargets++}}}if(a.morphNormals){a.numSupportedMorphNormals=0;s="morphNormal";for(g=0;g<this.maxMorphNormals;g++){u=s+g;if(p[u]>=0){e.enableVertexAttribArray(p[u]);a.numSupportedMorphNormals++}}}a.uniformsList=[];for(f in a.uniforms)a.uniformsList.push([a.uniforms[f],f])};this.setFaceCulling=function(a,b){if(a){!b||b==="ccw"?e.frontFace(e.CCW):e.frontFace(e.CW);a==="back"?e.cullFace(e.BACK):
a==="front"?e.cullFace(e.FRONT):e.cullFace(e.FRONT_AND_BACK);e.enable(e.CULL_FACE)}else e.disable(e.CULL_FACE)};this.setObjectFaces=function(a){if(ra!==a.doubleSided){a.doubleSided?e.disable(e.CULL_FACE):e.enable(e.CULL_FACE);ra=a.doubleSided}if(L!==a.flipSided){a.flipSided?e.frontFace(e.CW):e.frontFace(e.CCW);L=a.flipSided}};this.setDepthTest=function(a){if(Oa!==a){a?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST);Oa=a}};this.setDepthWrite=function(a){if(Fa!==a){e.depthMask(a);Fa=a}};this.setBlending=
function(a,b,c,d){if(a!==Aa){switch(a){case THREE.NoBlending:e.disable(e.BLEND);break;case THREE.AdditiveBlending:e.enable(e.BLEND);e.blendEquation(e.FUNC_ADD);e.blendFunc(e.SRC_ALPHA,e.ONE);break;case THREE.SubtractiveBlending:e.enable(e.BLEND);e.blendEquation(e.FUNC_ADD);e.blendFunc(e.ZERO,e.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:e.enable(e.BLEND);e.blendEquation(e.FUNC_ADD);e.blendFunc(e.ZERO,e.SRC_COLOR);break;case THREE.CustomBlending:e.enable(e.BLEND);break;default:e.enable(e.BLEND);
e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD);e.blendFuncSeparate(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA)}Aa=a}if(a===THREE.CustomBlending){if(b!==Ca){e.blendEquation(J(b));Ca=b}if(c!==Na||d!==Ua){e.blendFunc(J(c),J(d));Na=c;Ua=d}}else Ua=Na=Ca=null};this.setTexture=function(a,b){if(a.needsUpdate){if(!a.__webglInit){a.__webglInit=true;a.__webglTexture=e.createTexture();E.info.memory.textures++}e.activeTexture(e.TEXTURE0+b);e.bindTexture(e.TEXTURE_2D,a.__webglTexture);e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,
a.premultiplyAlpha);var c=a.image,d=(c.width&c.width-1)===0&&(c.height&c.height-1)===0,f=J(a.format),g=J(a.type);I(e.TEXTURE_2D,a,d);a instanceof THREE.DataTexture?e.texImage2D(e.TEXTURE_2D,0,f,c.width,c.height,0,f,g,c.data):e.texImage2D(e.TEXTURE_2D,0,f,f,g,a.image);a.generateMipmaps&&d&&e.generateMipmap(e.TEXTURE_2D);a.needsUpdate=false;if(a.onUpdate)a.onUpdate()}else{e.activeTexture(e.TEXTURE0+b);e.bindTexture(e.TEXTURE_2D,a.__webglTexture)}};this.setRenderTarget=function(a){var b=a instanceof
THREE.WebGLRenderTargetCube;if(a&&!a.__webglFramebuffer){if(a.depthBuffer===void 0)a.depthBuffer=true;if(a.stencilBuffer===void 0)a.stencilBuffer=true;a.__webglTexture=e.createTexture();var c=(a.width&a.width-1)===0&&(a.height&a.height-1)===0,d=J(a.format),f=J(a.type);if(b){a.__webglFramebuffer=[];a.__webglRenderbuffer=[];e.bindTexture(e.TEXTURE_CUBE_MAP,a.__webglTexture);I(e.TEXTURE_CUBE_MAP,a,c);for(var g=0;g<6;g++){a.__webglFramebuffer[g]=e.createFramebuffer();a.__webglRenderbuffer[g]=e.createRenderbuffer();
e.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+g,0,d,a.width,a.height,0,d,f,null);var h=a,i=e.TEXTURE_CUBE_MAP_POSITIVE_X+g;e.bindFramebuffer(e.FRAMEBUFFER,a.__webglFramebuffer[g]);e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,i,h.__webglTexture,0);B(a.__webglRenderbuffer[g],a)}c&&e.generateMipmap(e.TEXTURE_CUBE_MAP)}else{a.__webglFramebuffer=e.createFramebuffer();a.__webglRenderbuffer=e.createRenderbuffer();e.bindTexture(e.TEXTURE_2D,a.__webglTexture);I(e.TEXTURE_2D,a,c);e.texImage2D(e.TEXTURE_2D,
0,d,a.width,a.height,0,d,f,null);d=e.TEXTURE_2D;e.bindFramebuffer(e.FRAMEBUFFER,a.__webglFramebuffer);e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,d,a.__webglTexture,0);B(a.__webglRenderbuffer,a);c&&e.generateMipmap(e.TEXTURE_2D)}b?e.bindTexture(e.TEXTURE_CUBE_MAP,null):e.bindTexture(e.TEXTURE_2D,null);e.bindRenderbuffer(e.RENDERBUFFER,null);e.bindFramebuffer(e.FRAMEBUFFER,null)}if(a){b=b?a.__webglFramebuffer[a.activeCubeFace]:a.__webglFramebuffer;c=a.width;a=a.height;f=d=0}else{b=null;
c=Hb;a=ac;d=Ob;f=Yb}if(b!==D){e.bindFramebuffer(e.FRAMEBUFFER,b);e.viewport(d,f,c,a);D=b}sc=c;Zb=a};this.shadowMapPlugin=new THREE.ShadowMapPlugin;this.addPrePlugin(this.shadowMapPlugin);this.addPostPlugin(new THREE.SpritePlugin);this.addPostPlugin(new THREE.LensFlarePlugin)};
THREE.WebGLRenderTarget=function(a,b,c){this.width=a;this.height=b;c=c||{};this.wrapS=c.wrapS!==void 0?c.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=c.wrapT!==void 0?c.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=c.magFilter!==void 0?c.magFilter:THREE.LinearFilter;this.minFilter=c.minFilter!==void 0?c.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=c.format!==void 0?c.format:THREE.RGBAFormat;this.type=c.type!==void 0?c.type:
THREE.UnsignedByteType;this.depthBuffer=c.depthBuffer!==void 0?c.depthBuffer:true;this.stencilBuffer=c.stencilBuffer!==void 0?c.stencilBuffer:true;this.generateMipmaps=true};
THREE.WebGLRenderTarget.prototype.clone=function(){var a=new THREE.WebGLRenderTarget(this.width,this.height);a.wrapS=this.wrapS;a.wrapT=this.wrapT;a.magFilter=this.magFilter;a.minFilter=this.minFilter;a.offset.copy(this.offset);a.repeat.copy(this.repeat);a.format=this.format;a.type=this.type;a.depthBuffer=this.depthBuffer;a.stencilBuffer=this.stencilBuffer;return a};THREE.WebGLRenderTargetCube=function(a,b,c){THREE.WebGLRenderTarget.call(this,a,b,c);this.activeCubeFace=0};
THREE.WebGLRenderTargetCube.prototype=new THREE.WebGLRenderTarget;THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=true};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
THREE.BufferGeometry=function(){this.id=THREE.GeometryCount++;this.vertexColorArray=this.vertexUvArray=this.vertexNormalArray=this.vertexPositionArray=this.vertexIndexArray=this.vertexColorBuffer=this.vertexUvBuffer=this.vertexNormalBuffer=this.vertexPositionBuffer=this.vertexIndexBuffer=null;this.dynamic=false;this.boundingSphere=this.boundingBox=null;this.morphTargets=[]};THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,computeBoundingBox:function(){},computeBoundingSphere:function(){}};
THREE.Gyroscope=function(){THREE.Object3D.call(this)};THREE.Gyroscope.prototype=new THREE.Object3D;THREE.Gyroscope.prototype.constructor=THREE.Gyroscope;
THREE.Gyroscope.prototype.updateMatrixWorld=function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a){if(this.parent){this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix);this.matrixWorld.decompose(this.translationWorld,this.rotationWorld,this.scaleWorld);this.matrix.decompose(this.translationObject,this.rotationObject,this.scaleObject);this.matrixWorld.compose(this.translationWorld,this.rotationObject,this.scaleWorld)}else this.matrixWorld.copy(this.matrix);
this.matrixWorldNeedsUpdate=false;a=true}for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)};THREE.Gyroscope.prototype.translationWorld=new THREE.Vector3;THREE.Gyroscope.prototype.translationObject=new THREE.Vector3;THREE.Gyroscope.prototype.rotationWorld=new THREE.Quaternion;THREE.Gyroscope.prototype.rotationObject=new THREE.Quaternion;THREE.Gyroscope.prototype.scaleWorld=new THREE.Vector3;THREE.Gyroscope.prototype.scaleObject=new THREE.Vector3;
THREE.CameraHelper=function(a){function b(a,b,d){c(a,d);c(b,d)}function c(a,b){d.lineGeometry.vertices.push(new THREE.Vector3);d.lineGeometry.colors.push(new THREE.Color(b));d.pointMap[a]===void 0&&(d.pointMap[a]=[]);d.pointMap[a].push(d.lineGeometry.vertices.length-1)}THREE.Object3D.call(this);var d=this;this.lineGeometry=new THREE.Geometry;this.lineMaterial=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors});this.pointMap={};b("n1","n2",16755200);b("n2","n4",16755200);b("n4",
"n3",16755200);b("n3","n1",16755200);b("f1","f2",16755200);b("f2","f4",16755200);b("f4","f3",16755200);b("f3","f1",16755200);b("n1","f1",16755200);b("n2","f2",16755200);b("n3","f3",16755200);b("n4","f4",16755200);b("p","n1",16711680);b("p","n2",16711680);b("p","n3",16711680);b("p","n4",16711680);b("u1","u2",43775);b("u2","u3",43775);b("u3","u1",43775);b("c","t",16777215);b("p","c",3355443);b("cn1","cn2",3355443);b("cn3","cn4",3355443);b("cf1","cf2",3355443);b("cf3","cf4",3355443);this.camera=a;this.update(a);
this.lines=new THREE.Line(this.lineGeometry,this.lineMaterial,THREE.LinePieces);this.add(this.lines)};THREE.CameraHelper.prototype=new THREE.Object3D;THREE.CameraHelper.prototype.constructor=THREE.CameraHelper;
THREE.CameraHelper.prototype.update=function(){function a(a,d,f,g){THREE.CameraHelper.__v.set(d,f,g);THREE.CameraHelper.__projector.unprojectVector(THREE.CameraHelper.__v,THREE.CameraHelper.__c);a=b.pointMap[a];if(a!==void 0){d=0;for(f=a.length;d<f;d++)b.lineGeometry.vertices[a[d]].copy(THREE.CameraHelper.__v)}}var b=this;THREE.CameraHelper.__c.projectionMatrix.copy(this.camera.projectionMatrix);a("c",0,0,-1);a("t",0,0,1);a("n1",-1,-1,-1);a("n2",1,-1,-1);a("n3",-1,1,-1);a("n4",1,1,-1);a("f1",-1,-1,
1);a("f2",1,-1,1);a("f3",-1,1,1);a("f4",1,1,1);a("u1",0.7,1.1,-1);a("u2",-0.7,1.1,-1);a("u3",0,2,-1);a("cf1",-1,0,1);a("cf2",1,0,1);a("cf3",0,-1,1);a("cf4",0,1,1);a("cn1",-1,0,-1);a("cn2",1,0,-1);a("cn3",0,-1,-1);a("cn4",0,1,-1);this.lineGeometry.verticesNeedUpdate=true};THREE.CameraHelper.__projector=new THREE.Projector;THREE.CameraHelper.__v=new THREE.Vector3;THREE.CameraHelper.__c=new THREE.Camera;
THREE.LensFlare=function(a,b,c,d,f){THREE.Object3D.call(this);this.lensFlares=[];this.positionScreen=new THREE.Vector3;this.customUpdateCallback=void 0;a!==void 0&&this.add(a,b,c,d,f)};THREE.LensFlare.prototype=new THREE.Object3D;THREE.LensFlare.prototype.constructor=THREE.LensFlare;THREE.LensFlare.prototype.supr=THREE.Object3D.prototype;
THREE.LensFlare.prototype.add=function(a,b,c,d,f,g){b===void 0&&(b=-1);c===void 0&&(c=0);g===void 0&&(g=1);f===void 0&&(f=new THREE.Color(16777215));if(d===void 0)d=THREE.NormalBlending;c=Math.min(c,Math.max(0,c));this.lensFlares.push({texture:a,size:b,distance:c,x:0,y:0,z:0,scale:1,rotation:1,opacity:g,color:f,blending:d})};
THREE.LensFlare.prototype.updateLensFlares=function(){var a,b=this.lensFlares.length,c,d=-this.positionScreen.x*2,f=-this.positionScreen.y*2;for(a=0;a<b;a++){c=this.lensFlares[a];c.x=this.positionScreen.x+d*c.distance;c.y=this.positionScreen.y+f*c.distance;c.wantedRotation=c.x*Math.PI*0.25;c.rotation=c.rotation+(c.wantedRotation-c.rotation)*0.25}};THREE.ImmediateRenderObject=function(){THREE.Object3D.call(this);this.render=function(){}};THREE.ImmediateRenderObject.prototype=new THREE.Object3D;
THREE.ImmediateRenderObject.prototype.constructor=THREE.ImmediateRenderObject;
THREE.LensFlarePlugin=function(){function a(a){var c=b.createProgram(),d=b.createShader(b.FRAGMENT_SHADER),f=b.createShader(b.VERTEX_SHADER);b.shaderSource(d,a.fragmentShader);b.shaderSource(f,a.vertexShader);b.compileShader(d);b.compileShader(f);b.attachShader(c,d);b.attachShader(c,f);b.linkProgram(c);return c}var b,c,d,f,g,h,l,m,j,i,o,k,u;this.init=function(r){b=r.context;c=r;d=new Float32Array(16);f=new Uint16Array(6);r=0;d[r++]=-1;d[r++]=-1;d[r++]=0;d[r++]=0;d[r++]=1;d[r++]=-1;d[r++]=1;d[r++]=
0;d[r++]=1;d[r++]=1;d[r++]=1;d[r++]=1;d[r++]=-1;d[r++]=1;d[r++]=0;d[r++]=1;r=0;f[r++]=0;f[r++]=1;f[r++]=2;f[r++]=0;f[r++]=2;f[r++]=3;g=b.createBuffer();h=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,g);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.bufferData(b.ELEMENT_ARRAY_BUFFER,f,b.STATIC_DRAW);l=b.createTexture();m=b.createTexture();b.bindTexture(b.TEXTURE_2D,l);b.texImage2D(b.TEXTURE_2D,0,b.RGB,16,16,0,b.RGB,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,
b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);b.bindTexture(b.TEXTURE_2D,m);b.texImage2D(b.TEXTURE_2D,0,b.RGBA,16,16,0,b.RGBA,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);
b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);if(b.getParameter(b.MAX_VERTEX_TEXTURE_IMAGE_UNITS)<=0){j=false;i=a(THREE.ShaderFlares.lensFlare)}else{j=true;i=a(THREE.ShaderFlares.lensFlareVertexTexture)}o={};k={};o.vertex=b.getAttribLocation(i,"position");o.uv=b.getAttribLocation(i,"uv");k.renderType=b.getUniformLocation(i,"renderType");k.map=b.getUniformLocation(i,"map");k.occlusionMap=b.getUniformLocation(i,"occlusionMap");k.opacity=b.getUniformLocation(i,"opacity");k.color=b.getUniformLocation(i,
"color");k.scale=b.getUniformLocation(i,"scale");k.rotation=b.getUniformLocation(i,"rotation");k.screenPosition=b.getUniformLocation(i,"screenPosition");u=false};this.render=function(a,d,f,w){var a=a.__webglFlares,q=a.length;if(q){var I=new THREE.Vector3,B=w/f,s=f*0.5,J=w*0.5,C=16/w,G=new THREE.Vector2(C*B,C),F=new THREE.Vector3(1,1,0),P=new THREE.Vector2(1,1),Q=k,C=o;b.useProgram(i);if(!u){b.enableVertexAttribArray(o.vertex);b.enableVertexAttribArray(o.uv);u=true}b.uniform1i(Q.occlusionMap,0);b.uniform1i(Q.map,
1);b.bindBuffer(b.ARRAY_BUFFER,g);b.vertexAttribPointer(C.vertex,2,b.FLOAT,false,16,0);b.vertexAttribPointer(C.uv,2,b.FLOAT,false,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.disable(b.CULL_FACE);b.depthMask(false);var T,Z,R,z,H;for(T=0;T<q;T++){C=16/w;G.set(C*B,C);z=a[T];I.set(z.matrixWorld.elements[12],z.matrixWorld.elements[13],z.matrixWorld.elements[14]);d.matrixWorldInverse.multiplyVector3(I);d.projectionMatrix.multiplyVector3(I);F.copy(I);P.x=F.x*s+s;P.y=F.y*J+J;if(j||P.x>0&&P.x<f&&P.y>0&&
P.y<w){b.activeTexture(b.TEXTURE1);b.bindTexture(b.TEXTURE_2D,l);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGB,P.x-8,P.y-8,16,16,0);b.uniform1i(Q.renderType,0);b.uniform2f(Q.scale,G.x,G.y);b.uniform3f(Q.screenPosition,F.x,F.y,F.z);b.disable(b.BLEND);b.enable(b.DEPTH_TEST);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0);b.activeTexture(b.TEXTURE0);b.bindTexture(b.TEXTURE_2D,m);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGBA,P.x-8,P.y-8,16,16,0);b.uniform1i(Q.renderType,1);b.disable(b.DEPTH_TEST);b.activeTexture(b.TEXTURE1);
b.bindTexture(b.TEXTURE_2D,l);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0);z.positionScreen.copy(F);z.customUpdateCallback?z.customUpdateCallback(z):z.updateLensFlares();b.uniform1i(Q.renderType,2);b.enable(b.BLEND);Z=0;for(R=z.lensFlares.length;Z<R;Z++){H=z.lensFlares[Z];if(H.opacity>0.001&&H.scale>0.001){F.x=H.x;F.y=H.y;F.z=H.z;C=H.size*H.scale/w;G.x=C*B;G.y=C;b.uniform3f(Q.screenPosition,F.x,F.y,F.z);b.uniform2f(Q.scale,G.x,G.y);b.uniform1f(Q.rotation,H.rotation);b.uniform1f(Q.opacity,H.opacity);
b.uniform3f(Q.color,H.color.r,H.color.g,H.color.b);c.setBlending(H.blending,H.blendEquation,H.blendSrc,H.blendDst);c.setTexture(H.texture,1);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0)}}}}b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(true)}}};
THREE.ShadowMapPlugin=function(){var a,b,c,d,f=new THREE.Frustum,g=new THREE.Matrix4,h=new THREE.Vector3,l=new THREE.Vector3;this.init=function(f){a=f.context;b=f;var f=THREE.ShaderLib.depthRGBA,g=THREE.UniformsUtils.clone(f.uniforms);c=new THREE.ShaderMaterial({fragmentShader:f.fragmentShader,vertexShader:f.vertexShader,uniforms:g});d=new THREE.ShaderMaterial({fragmentShader:f.fragmentShader,vertexShader:f.vertexShader,uniforms:g,morphTargets:true});c._shadowPass=true;d._shadowPass=true};this.render=
function(a,c){b.shadowMapEnabled&&b.shadowMapAutoUpdate&&this.update(a,c)};this.update=function(m,j){var i,o,k,u,r,n,p,w,q,I=[];u=0;a.clearColor(1,1,1,1);a.disable(a.BLEND);a.enable(a.CULL_FACE);b.shadowMapCullFrontFaces?a.cullFace(a.FRONT):a.cullFace(a.BACK);b.setDepthTest(true);i=0;for(o=m.__lights.length;i<o;i++){k=m.__lights[i];if(k.castShadow)if(k instanceof THREE.DirectionalLight&&k.shadowCascade)for(r=0;r<k.shadowCascadeCount;r++){var B;if(k.shadowCascadeArray[r])B=k.shadowCascadeArray[r];
else{q=k;p=r;B=new THREE.DirectionalLight;B.isVirtual=true;B.onlyShadow=true;B.castShadow=true;B.shadowCameraNear=q.shadowCameraNear;B.shadowCameraFar=q.shadowCameraFar;B.shadowCameraLeft=q.shadowCameraLeft;B.shadowCameraRight=q.shadowCameraRight;B.shadowCameraBottom=q.shadowCameraBottom;B.shadowCameraTop=q.shadowCameraTop;B.shadowCameraVisible=q.shadowCameraVisible;B.shadowDarkness=q.shadowDarkness;B.shadowBias=q.shadowCascadeBias[p];B.shadowMapWidth=q.shadowCascadeWidth[p];B.shadowMapHeight=q.shadowCascadeHeight[p];
B.pointsWorld=[];B.pointsFrustum=[];w=B.pointsWorld;n=B.pointsFrustum;for(var s=0;s<8;s++){w[s]=new THREE.Vector3;n[s]=new THREE.Vector3}w=q.shadowCascadeNearZ[p];q=q.shadowCascadeFarZ[p];n[0].set(-1,-1,w);n[1].set(1,-1,w);n[2].set(-1,1,w);n[3].set(1,1,w);n[4].set(-1,-1,q);n[5].set(1,-1,q);n[6].set(-1,1,q);n[7].set(1,1,q);B.originalCamera=j;n=new THREE.Gyroscope;n.position=k.shadowCascadeOffset;n.add(B);n.add(B.target);j.add(n);k.shadowCascadeArray[r]=B;console.log("Created virtualLight",B)}p=k;w=
r;q=p.shadowCascadeArray[w];q.position.copy(p.position);q.target.position.copy(p.target.position);q.lookAt(q.target);q.shadowCameraVisible=p.shadowCameraVisible;q.shadowDarkness=p.shadowDarkness;q.shadowBias=p.shadowCascadeBias[w];n=p.shadowCascadeNearZ[w];p=p.shadowCascadeFarZ[w];q=q.pointsFrustum;q[0].z=n;q[1].z=n;q[2].z=n;q[3].z=n;q[4].z=p;q[5].z=p;q[6].z=p;q[7].z=p;I[u]=B;u++}else{I[u]=k;u++}}i=0;for(o=I.length;i<o;i++){k=I[i];if(!k.shadowMap){k.shadowMap=new THREE.WebGLRenderTarget(k.shadowMapWidth,
k.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat});k.shadowMapSize=new THREE.Vector2(k.shadowMapWidth,k.shadowMapHeight);k.shadowMatrix=new THREE.Matrix4}if(!k.shadowCamera){if(k instanceof THREE.SpotLight)k.shadowCamera=new THREE.PerspectiveCamera(k.shadowCameraFov,k.shadowMapWidth/k.shadowMapHeight,k.shadowCameraNear,k.shadowCameraFar);else if(k instanceof THREE.DirectionalLight)k.shadowCamera=new THREE.OrthographicCamera(k.shadowCameraLeft,k.shadowCameraRight,
k.shadowCameraTop,k.shadowCameraBottom,k.shadowCameraNear,k.shadowCameraFar);else{console.error("Unsupported light type for shadow");continue}m.add(k.shadowCamera);b.autoUpdateScene&&m.updateMatrixWorld()}if(k.shadowCameraVisible&&!k.cameraHelper){k.cameraHelper=new THREE.CameraHelper(k.shadowCamera);k.shadowCamera.add(k.cameraHelper)}if(k.isVirtual&&B.originalCamera==j){r=j;u=k.shadowCamera;n=k.pointsFrustum;q=k.pointsWorld;h.set(Infinity,Infinity,Infinity);l.set(-Infinity,-Infinity,-Infinity);for(p=
0;p<8;p++){w=q[p];w.copy(n[p]);THREE.ShadowMapPlugin.__projector.unprojectVector(w,r);u.matrixWorldInverse.multiplyVector3(w);if(w.x<h.x)h.x=w.x;if(w.x>l.x)l.x=w.x;if(w.y<h.y)h.y=w.y;if(w.y>l.y)l.y=w.y;if(w.z<h.z)h.z=w.z;if(w.z>l.z)l.z=w.z}u.left=h.x;u.right=l.x;u.top=l.y;u.bottom=h.y;u.updateProjectionMatrix()}u=k.shadowMap;n=k.shadowMatrix;r=k.shadowCamera;r.position.copy(k.matrixWorld.getPosition());r.lookAt(k.target.matrixWorld.getPosition());r.updateMatrixWorld();r.matrixWorldInverse.getInverse(r.matrixWorld);
if(k.cameraHelper)k.cameraHelper.lines.visible=k.shadowCameraVisible;k.shadowCameraVisible&&k.cameraHelper.update();n.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);n.multiplySelf(r.projectionMatrix);n.multiplySelf(r.matrixWorldInverse);if(!r._viewMatrixArray)r._viewMatrixArray=new Float32Array(16);if(!r._projectionMatrixArray)r._projectionMatrixArray=new Float32Array(16);r.matrixWorldInverse.flattenToArray(r._viewMatrixArray);r.projectionMatrix.flattenToArray(r._projectionMatrixArray);g.multiply(r.projectionMatrix,
r.matrixWorldInverse);f.setFromMatrix(g);b.setRenderTarget(u);b.clear();q=m.__webglObjects;k=0;for(u=q.length;k<u;k++){p=q[k];n=p.object;p.render=false;if(n.visible&&n.castShadow&&(!(n instanceof THREE.Mesh)||!n.frustumCulled||f.contains(n))){n._modelViewMatrix.multiply(r.matrixWorldInverse,n.matrixWorld);p.render=true}}k=0;for(u=q.length;k<u;k++){p=q[k];if(p.render){n=p.object;p=p.buffer;w=n.customDepthMaterial?n.customDepthMaterial:n.geometry.morphTargets.length?d:c;p instanceof THREE.BufferGeometry?
b.renderBufferDirect(r,m.__lights,null,w,p,n):b.renderBuffer(r,m.__lights,null,w,p,n)}}q=m.__webglObjectsImmediate;k=0;for(u=q.length;k<u;k++){p=q[k];n=p.object;if(n.visible&&n.castShadow){n._modelViewMatrix.multiply(r.matrixWorldInverse,n.matrixWorld);b.renderImmediateObject(r,m.__lights,null,c,n)}}}i=b.getClearColor();o=b.getClearAlpha();a.clearColor(i.r,i.g,i.b,o);a.enable(a.BLEND);b.shadowMapCullFrontFaces&&a.cullFace(a.BACK)}};THREE.ShadowMapPlugin.__projector=new THREE.Projector;
THREE.SpritePlugin=function(){function a(a,b){return b.z-a.z}var b,c,d,f,g,h,l,m,j,i;this.init=function(a){b=a.context;c=a;d=new Float32Array(16);f=new Uint16Array(6);a=0;d[a++]=-1;d[a++]=-1;d[a++]=0;d[a++]=1;d[a++]=1;d[a++]=-1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=0;d[a++]=-1;d[a++]=1;d[a++]=0;a=d[a++]=0;f[a++]=0;f[a++]=1;f[a++]=2;f[a++]=0;f[a++]=2;f[a++]=3;g=b.createBuffer();h=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,g);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,
h);b.bufferData(b.ELEMENT_ARRAY_BUFFER,f,b.STATIC_DRAW);var a=THREE.ShaderSprite.sprite,k=b.createProgram(),u=b.createShader(b.FRAGMENT_SHADER),r=b.createShader(b.VERTEX_SHADER);b.shaderSource(u,a.fragmentShader);b.shaderSource(r,a.vertexShader);b.compileShader(u);b.compileShader(r);b.attachShader(k,u);b.attachShader(k,r);b.linkProgram(k);l=k;m={};j={};m.position=b.getAttribLocation(l,"position");m.uv=b.getAttribLocation(l,"uv");j.uvOffset=b.getUniformLocation(l,"uvOffset");j.uvScale=b.getUniformLocation(l,
"uvScale");j.rotation=b.getUniformLocation(l,"rotation");j.scale=b.getUniformLocation(l,"scale");j.alignment=b.getUniformLocation(l,"alignment");j.color=b.getUniformLocation(l,"color");j.map=b.getUniformLocation(l,"map");j.opacity=b.getUniformLocation(l,"opacity");j.useScreenCoordinates=b.getUniformLocation(l,"useScreenCoordinates");j.affectedByDistance=b.getUniformLocation(l,"affectedByDistance");j.screenPosition=b.getUniformLocation(l,"screenPosition");j.modelViewMatrix=b.getUniformLocation(l,"modelViewMatrix");
j.projectionMatrix=b.getUniformLocation(l,"projectionMatrix");i=false};this.render=function(d,f,u,r){var d=d.__webglSprites,n=d.length;if(n){var p=m,w=j,q=r/u,u=u*0.5,I=r*0.5,B=true;b.useProgram(l);if(!i){b.enableVertexAttribArray(p.position);b.enableVertexAttribArray(p.uv);i=true}b.disable(b.CULL_FACE);b.enable(b.BLEND);b.depthMask(true);b.bindBuffer(b.ARRAY_BUFFER,g);b.vertexAttribPointer(p.position,2,b.FLOAT,false,16,0);b.vertexAttribPointer(p.uv,2,b.FLOAT,false,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,
h);b.uniformMatrix4fv(w.projectionMatrix,false,f._projectionMatrixArray);b.activeTexture(b.TEXTURE0);b.uniform1i(w.map,0);for(var s,J=[],p=0;p<n;p++){s=d[p];if(s.visible&&s.opacity!==0)if(s.useScreenCoordinates)s.z=-s.position.z;else{s._modelViewMatrix.multiply(f.matrixWorldInverse,s.matrixWorld);s.z=-s._modelViewMatrix.elements[14]}}d.sort(a);for(p=0;p<n;p++){s=d[p];if(s.visible&&s.opacity!==0&&s.map&&s.map.image&&s.map.image.width){if(s.useScreenCoordinates){b.uniform1i(w.useScreenCoordinates,1);
b.uniform3f(w.screenPosition,(s.position.x-u)/u,(I-s.position.y)/I,Math.max(0,Math.min(1,s.position.z)))}else{b.uniform1i(w.useScreenCoordinates,0);b.uniform1i(w.affectedByDistance,s.affectedByDistance?1:0);b.uniformMatrix4fv(w.modelViewMatrix,false,s._modelViewMatrix.elements)}f=s.map.image.width/(s.scaleByViewport?r:1);J[0]=f*q*s.scale.x;J[1]=f*s.scale.y;b.uniform2f(w.uvScale,s.uvScale.x,s.uvScale.y);b.uniform2f(w.uvOffset,s.uvOffset.x,s.uvOffset.y);b.uniform2f(w.alignment,s.alignment.x,s.alignment.y);
b.uniform1f(w.opacity,s.opacity);b.uniform3f(w.color,s.color.r,s.color.g,s.color.b);b.uniform1f(w.rotation,s.rotation);b.uniform2fv(w.scale,J);if(s.mergeWith3D&&!B){b.enable(b.DEPTH_TEST);B=true}else if(!s.mergeWith3D&&B){b.disable(b.DEPTH_TEST);B=false}c.setBlending(s.blending,s.blendEquation,s.blendSrc,s.blendDst);c.setTexture(s.map,0);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0)}}b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(true)}}};
THREE.ShaderFlares={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * vVisibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * visibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"}};
THREE.ShaderSprite={sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"precision mediump float;\nuniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\n}"}};
