// ThreeExtras.js - http://github.com/mrdoob/three.js
'use strict';THREE.ColorUtils={adjustHSV:function(b,a,c,d){var e=THREE.ColorUtils.__hsv;THREE.ColorUtils.rgbToHsv(b,e);e.h=THREE.Math.clamp(e.h+a,0,1);e.s=THREE.Math.clamp(e.s+c,0,1);e.v=THREE.Math.clamp(e.v+d,0,1);b.setHSV(e.h,e.s,e.v)},rgbToHsv:function(b,a){var c=b.r,d=b.g,e=b.b,f=Math.max(Math.max(c,d),e),g=Math.min(Math.min(c,d),e);if(g===f)g=c=0;else{var h=f-g,g=h/f,c=(c===f?(d-e)/h:d===f?2+(e-c)/h:4+(c-d)/h)/6;0>c&&(c+=1);1<c&&(c-=1)}void 0===a&&(a={h:0,s:0,v:0});a.h=c;a.s=g;a.v=f;return a}};
THREE.ColorUtils.__hsv={h:0,s:0,v:0};
THREE.GeometryUtils={merge:function(b,a){for(var c,d,e=b.vertices.length,f=a instanceof THREE.Mesh?a.geometry:a,g=b.vertices,h=f.vertices,i=b.faces,j=f.faces,l=b.faceVertexUvs[0],n=f.faceVertexUvs[0],k={},m=0;m<b.materials.length;m++)k[b.materials[m].id]=m;a instanceof THREE.Mesh&&(a.matrixAutoUpdate&&a.updateMatrix(),c=a.matrix,d=new THREE.Matrix4,d.extractRotation(c,a.scale));for(var m=0,o=h.length;m<o;m++){var q=h[m].clone();c&&c.multiplyVector3(q);g.push(q)}m=0;for(o=j.length;m<o;m++){var g=j[m],
r,s,t=g.vertexNormals,v=g.vertexColors;g instanceof THREE.Face3?r=new THREE.Face3(g.a+e,g.b+e,g.c+e):g instanceof THREE.Face4&&(r=new THREE.Face4(g.a+e,g.b+e,g.c+e,g.d+e));r.normal.copy(g.normal);d&&d.multiplyVector3(r.normal);h=0;for(q=t.length;h<q;h++)s=t[h].clone(),d&&d.multiplyVector3(s),r.vertexNormals.push(s);r.color.copy(g.color);h=0;for(q=v.length;h<q;h++)s=v[h],r.vertexColors.push(s.clone());void 0!==g.materialIndex&&(h=f.materials[g.materialIndex],q=h.id,v=k[q],void 0===v&&(v=b.materials.length,
k[q]=v,b.materials.push(h)),r.materialIndex=v);r.centroid.copy(g.centroid);c&&c.multiplyVector3(r.centroid);i.push(r)}m=0;for(o=n.length;m<o;m++){c=n[m];d=[];h=0;for(q=c.length;h<q;h++)d.push(new THREE.UV(c[h].u,c[h].v));l.push(d)}},clone:function(b){var a=new THREE.Geometry,c,d=b.vertices,e=b.faces,f=b.faceVertexUvs[0];b.materials&&(a.materials=b.materials.slice());b=0;for(c=d.length;b<c;b++)a.vertices.push(d[b].clone());b=0;for(c=e.length;b<c;b++)a.faces.push(e[b].clone());b=0;for(c=f.length;b<
c;b++){for(var d=f[b],e=[],g=0,h=d.length;g<h;g++)e.push(new THREE.UV(d[g].u,d[g].v));a.faceVertexUvs[0].push(e)}return a},randomPointInTriangle:function(b,a,c){var d,e,f,g=new THREE.Vector3,h=THREE.GeometryUtils.__v1;d=THREE.GeometryUtils.random();e=THREE.GeometryUtils.random();1<d+e&&(d=1-d,e=1-e);f=1-d-e;g.copy(b);g.multiplyScalar(d);h.copy(a);h.multiplyScalar(e);g.addSelf(h);h.copy(c);h.multiplyScalar(f);g.addSelf(h);return g},randomPointInFace:function(b,a,c){var d,e,f;if(b instanceof THREE.Face3)return d=
a.vertices[b.a],e=a.vertices[b.b],f=a.vertices[b.c],THREE.GeometryUtils.randomPointInTriangle(d,e,f);if(b instanceof THREE.Face4){d=a.vertices[b.a];e=a.vertices[b.b];f=a.vertices[b.c];var a=a.vertices[b.d],g;c?b._area1&&b._area2?(c=b._area1,g=b._area2):(c=THREE.GeometryUtils.triangleArea(d,e,a),g=THREE.GeometryUtils.triangleArea(e,f,a),b._area1=c,b._area2=g):(c=THREE.GeometryUtils.triangleArea(d,e,a),g=THREE.GeometryUtils.triangleArea(e,f,a));return THREE.GeometryUtils.random()*(c+g)<c?THREE.GeometryUtils.randomPointInTriangle(d,
e,a):THREE.GeometryUtils.randomPointInTriangle(e,f,a)}},randomPointsInGeometry:function(b,a){function c(a){function b(c,d){if(d<c)return c;var e=c+Math.floor((d-c)/2);return j[e]>a?b(c,e-1):j[e]<a?b(e+1,d):e}return b(0,j.length-1)}var d,e,f=b.faces,g=b.vertices,h=f.length,i=0,j=[],l,n,k,m;for(e=0;e<h;e++)d=f[e],d instanceof THREE.Face3?(l=g[d.a],n=g[d.b],k=g[d.c],d._area=THREE.GeometryUtils.triangleArea(l,n,k)):d instanceof THREE.Face4&&(l=g[d.a],n=g[d.b],k=g[d.c],m=g[d.d],d._area1=THREE.GeometryUtils.triangleArea(l,
n,m),d._area2=THREE.GeometryUtils.triangleArea(n,k,m),d._area=d._area1+d._area2),i+=d._area,j[e]=i;d=[];for(e=0;e<a;e++)g=THREE.GeometryUtils.random()*i,g=c(g),d[e]=THREE.GeometryUtils.randomPointInFace(f[g],b,!0);return d},triangleArea:function(b,a,c){var d,e=THREE.GeometryUtils.__v1;e.sub(b,a);d=e.length();e.sub(b,c);b=e.length();e.sub(a,c);c=e.length();a=0.5*(d+b+c);return Math.sqrt(a*(a-d)*(a-b)*(a-c))},center:function(b){b.computeBoundingBox();var a=b.boundingBox,c=new THREE.Vector3;c.add(a.min,
a.max);c.multiplyScalar(-0.5);b.applyMatrix((new THREE.Matrix4).makeTranslation(c.x,c.y,c.z));b.computeBoundingBox();return c},normalizeUVs:function(b){for(var b=b.faceVertexUvs[0],a=0,c=b.length;a<c;a++)for(var d=b[a],e=0,f=d.length;e<f;e++)if(1!==d[e].u&&(d[e].u-=Math.floor(d[e].u)),1!==d[e].v)d[e].v-=Math.floor(d[e].v)},triangulateQuads:function(b){var a,c,d,e,f=[],g=[],h=[];a=0;for(c=b.faceUvs.length;a<c;a++)g[a]=[];a=0;for(c=b.faceVertexUvs.length;a<c;a++)h[a]=[];a=0;for(c=b.faces.length;a<c;a++)if(d=
b.faces[a],d instanceof THREE.Face4){e=d.a;var i=d.b,j=d.c,l=d.d,n=new THREE.Face3,k=new THREE.Face3;n.color.copy(d.color);k.color.copy(d.color);n.materialIndex=d.materialIndex;k.materialIndex=d.materialIndex;n.a=e;n.b=i;n.c=l;k.a=i;k.b=j;k.c=l;4===d.vertexColors.length&&(n.vertexColors[0]=d.vertexColors[0].clone(),n.vertexColors[1]=d.vertexColors[1].clone(),n.vertexColors[2]=d.vertexColors[3].clone(),k.vertexColors[0]=d.vertexColors[1].clone(),k.vertexColors[1]=d.vertexColors[2].clone(),k.vertexColors[2]=
d.vertexColors[3].clone());f.push(n,k);d=0;for(e=b.faceVertexUvs.length;d<e;d++)b.faceVertexUvs[d].length&&(n=b.faceVertexUvs[d][a],i=n[1],j=n[2],l=n[3],n=[n[0].clone(),i.clone(),l.clone()],i=[i.clone(),j.clone(),l.clone()],h[d].push(n,i));d=0;for(e=b.faceUvs.length;d<e;d++)b.faceUvs[d].length&&(i=b.faceUvs[d][a],g[d].push(i,i))}else{f.push(d);d=0;for(e=b.faceUvs.length;d<e;d++)g[d].push(b.faceUvs[d]);d=0;for(e=b.faceVertexUvs.length;d<e;d++)h[d].push(b.faceVertexUvs[d])}b.faces=f;b.faceUvs=g;b.faceVertexUvs=
h;b.computeCentroids();b.computeFaceNormals();b.computeVertexNormals();b.hasTangents&&b.computeTangents()},explode:function(b){for(var a=[],c=0,d=b.faces.length;c<d;c++){var e=a.length,f=b.faces[c];if(f instanceof THREE.Face4){var g=f.a,h=f.b,i=f.c,g=b.vertices[g],h=b.vertices[h],i=b.vertices[i],j=b.vertices[f.d];a.push(g.clone());a.push(h.clone());a.push(i.clone());a.push(j.clone());f.a=e;f.b=e+1;f.c=e+2;f.d=e+3}else g=f.a,h=f.b,i=f.c,g=b.vertices[g],h=b.vertices[h],i=b.vertices[i],a.push(g.clone()),
a.push(h.clone()),a.push(i.clone()),f.a=e,f.b=e+1,f.c=e+2}b.vertices=a;delete b.__tmpVertices},tessellate:function(b,a){var c,d,e,f,g,h,i,j,l,n,k,m,o,q,r,s,t,v,p,x=[],A=[];c=0;for(d=b.faceVertexUvs.length;c<d;c++)A[c]=[];c=0;for(d=b.faces.length;c<d;c++)if(e=b.faces[c],e instanceof THREE.Face3)if(f=e.a,g=e.b,h=e.c,j=b.vertices[f],l=b.vertices[g],n=b.vertices[h],m=j.distanceTo(l),o=l.distanceTo(n),k=j.distanceTo(n),m>a||o>a||k>a){i=b.vertices.length;v=e.clone();p=e.clone();m>=o&&m>=k?(j=j.clone(),
j.lerpSelf(l,0.5),v.a=f,v.b=i,v.c=h,p.a=i,p.b=g,p.c=h,3===e.vertexNormals.length&&(f=e.vertexNormals[0].clone(),f.lerpSelf(e.vertexNormals[1],0.5),v.vertexNormals[1].copy(f),p.vertexNormals[0].copy(f)),3===e.vertexColors.length&&(f=e.vertexColors[0].clone(),f.lerpSelf(e.vertexColors[1],0.5),v.vertexColors[1].copy(f),p.vertexColors[0].copy(f)),e=0):o>=m&&o>=k?(j=l.clone(),j.lerpSelf(n,0.5),v.a=f,v.b=g,v.c=i,p.a=i,p.b=h,p.c=f,3===e.vertexNormals.length&&(f=e.vertexNormals[1].clone(),f.lerpSelf(e.vertexNormals[2],
0.5),v.vertexNormals[2].copy(f),p.vertexNormals[0].copy(f),p.vertexNormals[1].copy(e.vertexNormals[2]),p.vertexNormals[2].copy(e.vertexNormals[0])),3===e.vertexColors.length&&(f=e.vertexColors[1].clone(),f.lerpSelf(e.vertexColors[2],0.5),v.vertexColors[2].copy(f),p.vertexColors[0].copy(f),p.vertexColors[1].copy(e.vertexColors[2]),p.vertexColors[2].copy(e.vertexColors[0])),e=1):(j=j.clone(),j.lerpSelf(n,0.5),v.a=f,v.b=g,v.c=i,p.a=i,p.b=g,p.c=h,3===e.vertexNormals.length&&(f=e.vertexNormals[0].clone(),
f.lerpSelf(e.vertexNormals[2],0.5),v.vertexNormals[2].copy(f),p.vertexNormals[0].copy(f)),3===e.vertexColors.length&&(f=e.vertexColors[0].clone(),f.lerpSelf(e.vertexColors[2],0.5),v.vertexColors[2].copy(f),p.vertexColors[0].copy(f)),e=2);x.push(v,p);b.vertices.push(j);f=0;for(g=b.faceVertexUvs.length;f<g;f++)b.faceVertexUvs[f].length&&(j=b.faceVertexUvs[f][c],p=j[0],h=j[1],v=j[2],0===e?(l=p.clone(),l.lerpSelf(h,0.5),j=[p.clone(),l.clone(),v.clone()],h=[l.clone(),h.clone(),v.clone()]):1===e?(l=h.clone(),
l.lerpSelf(v,0.5),j=[p.clone(),h.clone(),l.clone()],h=[l.clone(),v.clone(),p.clone()]):(l=p.clone(),l.lerpSelf(v,0.5),j=[p.clone(),h.clone(),l.clone()],h=[l.clone(),h.clone(),v.clone()]),A[f].push(j,h))}else{x.push(e);f=0;for(g=b.faceVertexUvs.length;f<g;f++)A[f].push(b.faceVertexUvs[f][c])}else if(f=e.a,g=e.b,h=e.c,i=e.d,j=b.vertices[f],l=b.vertices[g],n=b.vertices[h],k=b.vertices[i],m=j.distanceTo(l),o=l.distanceTo(n),q=n.distanceTo(k),r=j.distanceTo(k),m>a||o>a||q>a||r>a){s=b.vertices.length;t=
b.vertices.length+1;v=e.clone();p=e.clone();m>=o&&m>=q&&m>=r||q>=o&&q>=m&&q>=r?(m=j.clone(),m.lerpSelf(l,0.5),l=n.clone(),l.lerpSelf(k,0.5),v.a=f,v.b=s,v.c=t,v.d=i,p.a=s,p.b=g,p.c=h,p.d=t,4===e.vertexNormals.length&&(f=e.vertexNormals[0].clone(),f.lerpSelf(e.vertexNormals[1],0.5),g=e.vertexNormals[2].clone(),g.lerpSelf(e.vertexNormals[3],0.5),v.vertexNormals[1].copy(f),v.vertexNormals[2].copy(g),p.vertexNormals[0].copy(f),p.vertexNormals[3].copy(g)),4===e.vertexColors.length&&(f=e.vertexColors[0].clone(),
f.lerpSelf(e.vertexColors[1],0.5),g=e.vertexColors[2].clone(),g.lerpSelf(e.vertexColors[3],0.5),v.vertexColors[1].copy(f),v.vertexColors[2].copy(g),p.vertexColors[0].copy(f),p.vertexColors[3].copy(g)),e=0):(m=l.clone(),m.lerpSelf(n,0.5),l=k.clone(),l.lerpSelf(j,0.5),v.a=f,v.b=g,v.c=s,v.d=t,p.a=t,p.b=s,p.c=h,p.d=i,4===e.vertexNormals.length&&(f=e.vertexNormals[1].clone(),f.lerpSelf(e.vertexNormals[2],0.5),g=e.vertexNormals[3].clone(),g.lerpSelf(e.vertexNormals[0],0.5),v.vertexNormals[2].copy(f),v.vertexNormals[3].copy(g),
p.vertexNormals[0].copy(g),p.vertexNormals[1].copy(f)),4===e.vertexColors.length&&(f=e.vertexColors[1].clone(),f.lerpSelf(e.vertexColors[2],0.5),g=e.vertexColors[3].clone(),g.lerpSelf(e.vertexColors[0],0.5),v.vertexColors[2].copy(f),v.vertexColors[3].copy(g),p.vertexColors[0].copy(g),p.vertexColors[1].copy(f)),e=1);x.push(v,p);b.vertices.push(m,l);f=0;for(g=b.faceVertexUvs.length;f<g;f++)b.faceVertexUvs[f].length&&(j=b.faceVertexUvs[f][c],p=j[0],h=j[1],v=j[2],j=j[3],0===e?(l=p.clone(),l.lerpSelf(h,
0.5),n=v.clone(),n.lerpSelf(j,0.5),p=[p.clone(),l.clone(),n.clone(),j.clone()],h=[l.clone(),h.clone(),v.clone(),n.clone()]):(l=h.clone(),l.lerpSelf(v,0.5),n=j.clone(),n.lerpSelf(p,0.5),p=[p.clone(),h.clone(),l.clone(),n.clone()],h=[n.clone(),l.clone(),v.clone(),j.clone()]),A[f].push(p,h))}else{x.push(e);f=0;for(g=b.faceVertexUvs.length;f<g;f++)A[f].push(b.faceVertexUvs[f][c])}b.faces=x;b.faceVertexUvs=A}};THREE.GeometryUtils.random=THREE.Math.random16;THREE.GeometryUtils.__v1=new THREE.Vector3;
THREE.ImageUtils={crossOrigin:"anonymous",loadTexture:function(b,a,c){var d=new Image,e=new THREE.Texture(d,a);d.onload=function(){e.needsUpdate=!0;c&&c(this)};d.crossOrigin=this.crossOrigin;d.src=b;return e},loadTextureCube:function(b,a,c){var d,e=[],f=new THREE.Texture(e,a),a=e.loadCount=0;for(d=b.length;a<d;++a)e[a]=new Image,e[a].onload=function(){e.loadCount+=1;6===e.loadCount&&(f.needsUpdate=!0);c&&c(this)},e[a].crossOrigin=this.crossOrigin,e[a].src=b[a];return f},getNormalMap:function(b,a){var c=
function(a){var b=Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]);return[a[0]/b,a[1]/b,a[2]/b]},a=a|1,d=b.width,e=b.height,f=document.createElement("canvas");f.width=d;f.height=e;var g=f.getContext("2d");g.drawImage(b,0,0);for(var h=g.getImageData(0,0,d,e).data,i=g.createImageData(d,e),j=i.data,l=0;l<d;l++)for(var n=0;n<e;n++){var k=0>n-1?0:n-1,m=n+1>e-1?e-1:n+1,o=0>l-1?0:l-1,q=l+1>d-1?d-1:l+1,r=[],s=[0,0,h[4*(n*d+l)]/255*a];r.push([-1,0,h[4*(n*d+o)]/255*a]);r.push([-1,-1,h[4*(k*d+o)]/255*a]);r.push([0,
-1,h[4*(k*d+l)]/255*a]);r.push([1,-1,h[4*(k*d+q)]/255*a]);r.push([1,0,h[4*(n*d+q)]/255*a]);r.push([1,1,h[4*(m*d+q)]/255*a]);r.push([0,1,h[4*(m*d+l)]/255*a]);r.push([-1,1,h[4*(m*d+o)]/255*a]);k=[];o=r.length;for(m=0;m<o;m++){var q=r[m],t=r[(m+1)%o],q=[q[0]-s[0],q[1]-s[1],q[2]-s[2]],t=[t[0]-s[0],t[1]-s[1],t[2]-s[2]];k.push(c([q[1]*t[2]-q[2]*t[1],q[2]*t[0]-q[0]*t[2],q[0]*t[1]-q[1]*t[0]]))}r=[0,0,0];for(m=0;m<k.length;m++)r[0]+=k[m][0],r[1]+=k[m][1],r[2]+=k[m][2];r[0]/=k.length;r[1]/=k.length;r[2]/=k.length;
s=4*(n*d+l);j[s]=255*((r[0]+1)/2)|0;j[s+1]=255*(r[1]+0.5)|0;j[s+2]=255*r[2]|0;j[s+3]=255}g.putImageData(i,0,0);return f},generateDataTexture:function(b,a,c){for(var d=b*a,e=new Uint8Array(3*d),f=Math.floor(255*c.r),g=Math.floor(255*c.g),c=Math.floor(255*c.b),h=0;h<d;h++)e[3*h]=f,e[3*h+1]=g,e[3*h+2]=c;b=new THREE.DataTexture(e,b,a,THREE.RGBFormat);b.needsUpdate=!0;return b}};
THREE.SceneUtils={showHierarchy:function(b,a){THREE.SceneUtils.traverseHierarchy(b,function(b){b.visible=a})},traverseHierarchy:function(b,a){var c,d,e=b.children.length;for(d=0;d<e;d++)c=b.children[d],a(c),THREE.SceneUtils.traverseHierarchy(c,a)},createMultiMaterialObject:function(b,a){var c,d=a.length,e=new THREE.Object3D;for(c=0;c<d;c++){var f=new THREE.Mesh(b,a[c]);e.add(f)}return e},cloneObject:function(b){var a;b instanceof THREE.MorphAnimMesh?(a=new THREE.MorphAnimMesh(b.geometry,b.material),
a.duration=b.duration,a.mirroredLoop=b.mirroredLoop,a.time=b.time,a.lastKeyframe=b.lastKeyframe,a.currentKeyframe=b.currentKeyframe,a.direction=b.direction,a.directionBackwards=b.directionBackwards):b instanceof THREE.SkinnedMesh?a=new THREE.SkinnedMesh(b.geometry,b.material):b instanceof THREE.Mesh?a=new THREE.Mesh(b.geometry,b.material):b instanceof THREE.Line?a=new THREE.Line(b.geometry,b.material,b.type):b instanceof THREE.Ribbon?a=new THREE.Ribbon(b.geometry,b.material):b instanceof THREE.ParticleSystem?
(a=new THREE.ParticleSystem(b.geometry,b.material),a.sortParticles=b.sortParticles):b instanceof THREE.Particle?a=new THREE.Particle(b.material):b instanceof THREE.Sprite?(a=new THREE.Sprite({}),a.color.copy(b.color),a.map=b.map,a.blending=b.blending,a.useScreenCoordinates=b.useScreenCoordinates,a.mergeWith3D=b.mergeWith3D,a.affectedByDistance=b.affectedByDistance,a.scaleByViewport=b.scaleByViewport,a.alignment=b.alignment,a.rotation3d.copy(b.rotation3d),a.rotation=b.rotation,a.opacity=b.opacity,
a.uvOffset.copy(b.uvOffset),a.uvScale.copy(b.uvScale)):b instanceof THREE.LOD?a=new THREE.LOD:b instanceof THREE.Object3D&&(a=new THREE.Object3D);a.name=b.name;a.parent=b.parent;a.up.copy(b.up);a.position.copy(b.position);a.rotation instanceof THREE.Vector3&&a.rotation.copy(b.rotation);a.eulerOrder=b.eulerOrder;a.scale.copy(b.scale);a.dynamic=b.dynamic;a.doubleSided=b.doubleSided;a.flipSided=b.flipSided;a.renderDepth=b.renderDepth;a.rotationAutoUpdate=b.rotationAutoUpdate;a.matrix.copy(b.matrix);
a.matrixWorld.copy(b.matrixWorld);a.matrixRotationWorld.copy(b.matrixRotationWorld);a.matrixAutoUpdate=b.matrixAutoUpdate;a.matrixWorldNeedsUpdate=b.matrixWorldNeedsUpdate;a.quaternion.copy(b.quaternion);a.useQuaternion=b.useQuaternion;a.boundRadius=b.boundRadius;a.boundRadiusScale=b.boundRadiusScale;a.visible=b.visible;a.castShadow=b.castShadow;a.receiveShadow=b.receiveShadow;a.frustumCulled=b.frustumCulled;for(var c=0;c<b.children.length;c++){var d=THREE.SceneUtils.cloneObject(b.children[c]);a.children[c]=
d;d.parent=a}if(b instanceof THREE.LOD)for(c=0;c<b.LODs.length;c++)a.LODs[c]={visibleAtDistance:b.LODs[c].visibleAtDistance,object3D:a.children[c]};return a},detach:function(b,a,c){b.applyMatrix(a.matrixWorld);a.remove(b);c.add(b)},attach:function(b,a,c){var d=new THREE.Matrix4;d.getInverse(c.matrixWorld);b.applyMatrix(d);a.remove(b);c.add(b)}};
THREE.WebGLRenderer&&(THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},enableReflection:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tCube:{type:"t",value:1,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},tDisplacement:{type:"t",value:5,texture:null},uNormalScale:{type:"f",
value:1},uDisplacementBias:{type:"f",value:0},uDisplacementScale:{type:"f",value:1},uDiffuseColor:{type:"c",value:new THREE.Color(16777215)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(16777215)},uShininess:{type:"f",value:30},uOpacity:{type:"f",value:1},uReflectivity:{type:"f",value:0.5},uOffset:{type:"v2",value:new THREE.Vector2(0,0)},uRepeat:{type:"v2",value:new THREE.Vector2(1,1)},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),
fragmentShader:["uniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform float uOpacity;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform bool enableReflection;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform samplerCube tCube;\nuniform float uNormalScale;\nuniform float uReflectivity;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.shadowmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3( 1.0 ), uOpacity );\nvec3 specularTex = vec3( 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse ) {\n#ifdef GAMMA_INPUT\nvec4 texelColor = texture2D( tDiffuse, vUv );\ntexelColor.xyz *= texelColor.xyz;\ngl_FragColor = gl_FragColor * texelColor;\n#else\ngl_FragColor = gl_FragColor * texture2D( tDiffuse, vUv );\n#endif\n}\nif( enableAO ) {\n#ifdef GAMMA_INPUT\nvec4 aoColor = texture2D( tAO, vUv );\naoColor.xyz *= aoColor.xyz;\ngl_FragColor.xyz = gl_FragColor.xyz * aoColor.xyz;\n#else\ngl_FragColor.xyz = gl_FragColor.xyz * texture2D( tAO, vUv ).xyz;\n#endif\n}\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( normalize( vTangent ), normalize( vBinormal ), normalize( vNormal ) );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec3 pointDiffuse = vec3( 0.0 );\nvec3 pointSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nfloat pointDistance = vPointLight[ i ].w;\n#ifdef WRAP_AROUND\nfloat pointDiffuseWeightFull = max( dot( normal, pointVector ), 0.0 );\nfloat pointDiffuseWeightHalf = max( 0.5 * dot( normal, pointVector ) + 0.5, 0.0 );\nvec3 pointDiffuseWeight = mix( vec3 ( pointDiffuseWeightFull ), vec3( pointDiffuseWeightHalf ), wrapRGB );\n#else\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\n#endif\npointDiffuse += pointDistance * pointLightColor[ i ] * uDiffuseColor * pointDiffuseWeight;\nvec3 pointHalfVector = normalize( pointVector + viewPosition );\nfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointSpecularWeight = specularTex.r * max( pow( pointDotNormalHalf, uShininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nfloat specularNormalization = ( uShininess + 2.0001 ) / 8.0;\nvec3 schlick = uSpecularColor + vec3( 1.0 - uSpecularColor ) * pow( 1.0 - dot( pointVector, pointHalfVector ), 5.0 );\npointSpecular += schlick * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * pointDistance * specularNormalization;\n#else\npointSpecular += pointDistance * pointLightColor[ i ] * uSpecularColor * pointSpecularWeight * pointDiffuseWeight;\n#endif\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec3 dirDiffuse = vec3( 0.0 );\nvec3 dirSpecular = vec3( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\n#ifdef WRAP_AROUND\nfloat directionalLightWeightingFull = max( dot( normal, dirVector ), 0.0 );\nfloat directionalLightWeightingHalf = max( 0.5 * dot( normal, dirVector ) + 0.5, 0.0 );\nvec3 dirDiffuseWeight = mix( vec3( directionalLightWeightingFull ), vec3( directionalLightWeightingHalf ), wrapRGB );\n#else\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\n#endif\ndirDiffuse += directionalLightColor[ i ] * uDiffuseColor * dirDiffuseWeight;\nvec3 dirHalfVector = normalize( dirVector + viewPosition );\nfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirSpecularWeight = specularTex.r * max( pow( dirDotNormalHalf, uShininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nfloat specularNormalization = ( uShininess + 2.0001 ) / 8.0;\nvec3 schlick = uSpecularColor + vec3( 1.0 - uSpecularColor ) * pow( 1.0 - dot( dirVector, dirHalfVector ), 5.0 );\ndirSpecular += schlick * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight * specularNormalization;\n#else\ndirSpecular += directionalLightColor[ i ] * uSpecularColor * dirSpecularWeight * dirDiffuseWeight;\n#endif\n}\n#endif\nvec3 totalDiffuse = vec3( 0.0 );\nvec3 totalSpecular = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\ntotalDiffuse += dirDiffuse;\ntotalSpecular += dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalDiffuse += pointDiffuse;\ntotalSpecular += pointSpecular;\n#endif\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * uAmbientColor) + totalSpecular;\nif ( enableReflection ) {\nvec3 wPos = cameraPosition - vViewPosition;\nvec3 vReflect = reflect( normalize( wPos ), normal );\nvec4 cubeColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\n#ifdef GAMMA_INPUT\ncubeColor.xyz *= cubeColor.xyz;\n#endif\ngl_FragColor.xyz = mix( gl_FragColor.xyz, cubeColor.xyz, specularTex.r * uReflectivity );\n}",
THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["attribute vec4 tangent;\nuniform vec2 uOffset;\nuniform vec2 uRepeat;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvViewPosition = -mvPosition.xyz;\nvNormal = normalMatrix * normal;\nvTangent = normalMatrix * tangent.xyz;\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvUv = uv * uRepeat + uOffset;\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( normalize( vNormal.xyz ) * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},cube:{uniforms:{tCube:{type:"t",value:1,texture:null},tFlip:{type:"f",value:-1}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nuniform float tFlip;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( tFlip * wPos.x, wPos.yz ) );\n}"}}});
THREE.BufferGeometry=function(){this.id=THREE.GeometryCount++;this.vertexColorArray=this.vertexUvArray=this.vertexNormalArray=this.vertexPositionArray=this.vertexIndexArray=this.vertexColorBuffer=this.vertexUvBuffer=this.vertexNormalBuffer=this.vertexPositionBuffer=this.vertexIndexBuffer=null;this.dynamic=false;this.boundingSphere=this.boundingBox=null;this.morphTargets=[]};THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,computeBoundingBox:function(){},computeBoundingSphere:function(){}};
THREE.Curve=function(){};THREE.Curve.prototype.getPoint=function(){console.log("Warning, getPoint() not implemented!");return null};THREE.Curve.prototype.getPointAt=function(b){return this.getPoint(this.getUtoTmapping(b))};THREE.Curve.prototype.getPoints=function(b){b||(b=5);var a,c=[];for(a=0;a<=b;a++)c.push(this.getPoint(a/b));return c};THREE.Curve.prototype.getSpacedPoints=function(b){b||(b=5);var a,c=[];for(a=0;a<=b;a++)c.push(this.getPointAt(a/b));return c};
THREE.Curve.prototype.getLength=function(){var b=this.getLengths();return b[b.length-1]};THREE.Curve.prototype.getLengths=function(b){b||(b=this.__arcLengthDivisions?this.__arcLengthDivisions:200);if(this.cacheArcLengths&&this.cacheArcLengths.length==b+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=false;var a=[],c,d=this.getPoint(0),e,f=0;a.push(0);for(e=1;e<=b;e++){c=this.getPoint(e/b);f=f+c.distanceTo(d);a.push(f);d=c}return this.cacheArcLengths=a};
THREE.Curve.prototype.updateArcLengths=function(){this.needsUpdate=true;this.getLengths()};THREE.Curve.prototype.getUtoTmapping=function(b,a){var c=this.getLengths(),d=0,e=c.length,f;f=a?a:b*c[e-1];for(var g=0,h=e-1,i;g<=h;){d=Math.floor(g+(h-g)/2);i=c[d]-f;if(i<0)g=d+1;else if(i>0)h=d-1;else{h=d;break}}d=h;if(c[d]==f)return d/(e-1);g=c[d];return c=(d+(f-g)/(c[d+1]-g))/(e-1)};THREE.Curve.prototype.getNormalVector=function(b){b=this.getTangent(b);return new THREE.Vector2(-b.y,b.x)};
THREE.Curve.prototype.getTangent=function(b){var a=b-1.0E-4,b=b+1.0E-4;a<0&&(a=0);b>1&&(b=1);a=this.getPoint(a);return this.getPoint(b).clone().subSelf(a).normalize()};THREE.Curve.prototype.getTangentAt=function(b){return this.getTangent(this.getUtoTmapping(b))};THREE.LineCurve=function(b,a){this.v1=b;this.v2=a};THREE.LineCurve.prototype=new THREE.Curve;THREE.LineCurve.prototype.constructor=THREE.LineCurve;
THREE.LineCurve.prototype.getPoint=function(b){var a=this.v2.clone().subSelf(this.v1);a.multiplyScalar(b).addSelf(this.v1);return a};THREE.LineCurve.prototype.getPointAt=function(b){return this.getPoint(b)};THREE.LineCurve.prototype.getTangent=function(){return this.v2.clone().subSelf(this.v1).normalize()};THREE.QuadraticBezierCurve=function(b,a,c){this.v0=b;this.v1=a;this.v2=c};THREE.QuadraticBezierCurve.prototype=new THREE.Curve;THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve;
THREE.QuadraticBezierCurve.prototype.getPoint=function(b){var a;a=THREE.Shape.Utils.b2(b,this.v0.x,this.v1.x,this.v2.x);b=THREE.Shape.Utils.b2(b,this.v0.y,this.v1.y,this.v2.y);return new THREE.Vector2(a,b)};THREE.QuadraticBezierCurve.prototype.getTangent=function(b){var a;a=THREE.Curve.Utils.tangentQuadraticBezier(b,this.v0.x,this.v1.x,this.v2.x);b=THREE.Curve.Utils.tangentQuadraticBezier(b,this.v0.y,this.v1.y,this.v2.y);a=new THREE.Vector2(a,b);a.normalize();return a};
THREE.CubicBezierCurve=function(b,a,c,d){this.v0=b;this.v1=a;this.v2=c;this.v3=d};THREE.CubicBezierCurve.prototype=new THREE.Curve;THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve;THREE.CubicBezierCurve.prototype.getPoint=function(b){var a;a=THREE.Shape.Utils.b3(b,this.v0.x,this.v1.x,this.v2.x,this.v3.x);b=THREE.Shape.Utils.b3(b,this.v0.y,this.v1.y,this.v2.y,this.v3.y);return new THREE.Vector2(a,b)};
THREE.CubicBezierCurve.prototype.getTangent=function(b){var a;a=THREE.Curve.Utils.tangentCubicBezier(b,this.v0.x,this.v1.x,this.v2.x,this.v3.x);b=THREE.Curve.Utils.tangentCubicBezier(b,this.v0.y,this.v1.y,this.v2.y,this.v3.y);a=new THREE.Vector2(a,b);a.normalize();return a};THREE.SplineCurve=function(b){this.points=b==void 0?[]:b};THREE.SplineCurve.prototype=new THREE.Curve;THREE.SplineCurve.prototype.constructor=THREE.SplineCurve;
THREE.SplineCurve.prototype.getPoint=function(b){var a=new THREE.Vector2,c=[],d=this.points,e;e=(d.length-1)*b;b=Math.floor(e);e=e-b;c[0]=b==0?b:b-1;c[1]=b;c[2]=b>d.length-2?d.length-1:b+1;c[3]=b>d.length-3?d.length-1:b+2;a.x=THREE.Curve.Utils.interpolate(d[c[0]].x,d[c[1]].x,d[c[2]].x,d[c[3]].x,e);a.y=THREE.Curve.Utils.interpolate(d[c[0]].y,d[c[1]].y,d[c[2]].y,d[c[3]].y,e);return a};
THREE.ArcCurve=function(b,a,c,d,e,f){this.aX=b;this.aY=a;this.aRadius=c;this.aStartAngle=d;this.aEndAngle=e;this.aClockwise=f};THREE.ArcCurve.prototype=new THREE.Curve;THREE.ArcCurve.prototype.constructor=THREE.ArcCurve;THREE.ArcCurve.prototype.getPoint=function(b){var a=this.aEndAngle-this.aStartAngle;this.aClockwise||(b=1-b);a=this.aStartAngle+b*a;b=this.aX+this.aRadius*Math.cos(a);a=this.aY+this.aRadius*Math.sin(a);return new THREE.Vector2(b,a)};
THREE.Curve.Utils={tangentQuadraticBezier:function(b,a,c,d){return 2*(1-b)*(c-a)+2*b*(d-c)},tangentCubicBezier:function(b,a,c,d,e){return-3*a*(1-b)*(1-b)+3*c*(1-b)*(1-b)-6*b*c*(1-b)+6*b*d*(1-b)-3*b*b*d+3*b*b*e},tangentSpline:function(b){return 6*b*b-6*b+(3*b*b-4*b+1)+(-6*b*b+6*b)+(3*b*b-2*b)},interpolate:function(b,a,c,d,e){var b=(c-b)*0.5,d=(d-a)*0.5,f=e*e;return(2*a-2*c+b+d)*e*f+(-3*a+3*c-2*b-d)*f+b*e+a}};
THREE.Curve.create=function(b,a){b.prototype=new THREE.Curve;b.prototype.constructor=b;b.prototype.getPoint=a;return b};THREE.LineCurve3=THREE.Curve.create(function(b,a){this.v1=b;this.v2=a},function(b){var a=new THREE.Vector3;a.sub(this.v2,this.v1);a.multiplyScalar(b);a.addSelf(this.v1);return a});
THREE.QuadraticBezierCurve3=THREE.Curve.create(function(b,a,c){this.v0=b;this.v1=a;this.v2=c},function(b){var a,c;a=THREE.Shape.Utils.b2(b,this.v0.x,this.v1.x,this.v2.x);c=THREE.Shape.Utils.b2(b,this.v0.y,this.v1.y,this.v2.y);b=THREE.Shape.Utils.b2(b,this.v0.z,this.v1.z,this.v2.z);return new THREE.Vector3(a,c,b)});
THREE.CubicBezierCurve3=THREE.Curve.create(function(b,a,c,d){this.v0=b;this.v1=a;this.v2=c;this.v3=d},function(b){var a,c;a=THREE.Shape.Utils.b3(b,this.v0.x,this.v1.x,this.v2.x,this.v3.x);c=THREE.Shape.Utils.b3(b,this.v0.y,this.v1.y,this.v2.y,this.v3.y);b=THREE.Shape.Utils.b3(b,this.v0.z,this.v1.z,this.v2.z,this.v3.z);return new THREE.Vector3(a,c,b)});
THREE.SplineCurve3=THREE.Curve.create(function(b){this.points=b==void 0?[]:b},function(b){var a=new THREE.Vector3,c=[],d=this.points,e,b=(d.length-1)*b;e=Math.floor(b);b=b-e;c[0]=e==0?e:e-1;c[1]=e;c[2]=e>d.length-2?d.length-1:e+1;c[3]=e>d.length-3?d.length-1:e+2;e=d[c[0]];var f=d[c[1]],g=d[c[2]],c=d[c[3]];a.x=THREE.Curve.Utils.interpolate(e.x,f.x,g.x,c.x,b);a.y=THREE.Curve.Utils.interpolate(e.y,f.y,g.y,c.y,b);a.z=THREE.Curve.Utils.interpolate(e.z,f.z,g.z,c.z,b);return a});
THREE.ClosedSplineCurve3=THREE.Curve.create(function(b){this.points=b==void 0?[]:b},function(b){var a=new THREE.Vector3,c=[],d=this.points,e;e=(d.length-0)*b;b=Math.floor(e);e=e-b;b=b+(b>0?0:(Math.floor(Math.abs(b)/d.length)+1)*d.length);c[0]=(b-1)%d.length;c[1]=b%d.length;c[2]=(b+1)%d.length;c[3]=(b+2)%d.length;a.x=THREE.Curve.Utils.interpolate(d[c[0]].x,d[c[1]].x,d[c[2]].x,d[c[3]].x,e);a.y=THREE.Curve.Utils.interpolate(d[c[0]].y,d[c[1]].y,d[c[2]].y,d[c[3]].y,e);a.z=THREE.Curve.Utils.interpolate(d[c[0]].z,
d[c[1]].z,d[c[2]].z,d[c[3]].z,e);return a});THREE.CurvePath=function(){this.curves=[];this.bends=[];this.autoClose=false};THREE.CurvePath.prototype=new THREE.Curve;THREE.CurvePath.prototype.constructor=THREE.CurvePath;THREE.CurvePath.prototype.add=function(b){this.curves.push(b)};THREE.CurvePath.prototype.checkConnection=function(){};
THREE.CurvePath.prototype.closePath=function(){var b=this.curves[0].getPoint(0),a=this.curves[this.curves.length-1].getPoint(1);b.equals(a)||this.curves.push(new THREE.LineCurve(a,b))};THREE.CurvePath.prototype.getPoint=function(b){for(var a=b*this.getLength(),c=this.getCurveLengths(),b=0;b<c.length;){if(c[b]>=a){a=c[b]-a;b=this.curves[b];a=1-a/b.getLength();return b.getPointAt(a)}b++}return null};THREE.CurvePath.prototype.getLength=function(){var b=this.getCurveLengths();return b[b.length-1]};
THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length==this.curves.length)return this.cacheLengths;var b=[],a=0,c,d=this.curves.length;for(c=0;c<d;c++){a=a+this.curves[c].getLength();b.push(a)}return this.cacheLengths=b};
THREE.CurvePath.prototype.getBoundingBox=function(){var b=this.getPoints(),a,c,d,e;a=c=Number.NEGATIVE_INFINITY;d=e=Number.POSITIVE_INFINITY;var f,g,h,i;i=new THREE.Vector2;g=0;for(h=b.length;g<h;g++){f=b[g];if(f.x>a)a=f.x;else if(f.x<d)d=f.x;if(f.y>c)c=f.y;else if(f.y<c)e=f.y;i.addSelf(f.x,f.y)}return{minX:d,minY:e,maxX:a,maxY:c,centroid:i.divideScalar(h)}};THREE.CurvePath.prototype.createPointsGeometry=function(b){return this.createGeometry(this.getPoints(b,true))};
THREE.CurvePath.prototype.createSpacedPointsGeometry=function(b){return this.createGeometry(this.getSpacedPoints(b,true))};THREE.CurvePath.prototype.createGeometry=function(b){for(var a=new THREE.Geometry,c=0;c<b.length;c++)a.vertices.push(new THREE.Vector3(b[c].x,b[c].y,0));return a};THREE.CurvePath.prototype.addWrapPath=function(b){this.bends.push(b)};
THREE.CurvePath.prototype.getTransformedPoints=function(b,a){var c=this.getPoints(b),d,e;if(!a)a=this.bends;d=0;for(e=a.length;d<e;d++)c=this.getWrapPoints(c,a[d]);return c};THREE.CurvePath.prototype.getTransformedSpacedPoints=function(b,a){var c=this.getSpacedPoints(b),d,e;if(!a)a=this.bends;d=0;for(e=a.length;d<e;d++)c=this.getWrapPoints(c,a[d]);return c};
THREE.CurvePath.prototype.getWrapPoints=function(b,a){var c=this.getBoundingBox(),d,e,f,g,h,i;d=0;for(e=b.length;d<e;d++){f=b[d];g=f.x;h=f.y;i=g/c.maxX;i=a.getUtoTmapping(i,g);g=a.getPoint(i);h=a.getNormalVector(i).multiplyScalar(h);f.x=g.x+h.x;f.y=g.y+h.y}return b};
THREE.EventTarget=function(){var b={};this.addEventListener=function(a,c){b[a]==void 0&&(b[a]=[]);b[a].indexOf(c)===-1&&b[a].push(c)};this.dispatchEvent=function(a){for(var c in b[a.type])b[a.type][c](a)};this.removeEventListener=function(a,c){var d=b[a].indexOf(c);d!==-1&&b[a].splice(d,1)}};THREE.Gyroscope=function(){THREE.Object3D.call(this)};THREE.Gyroscope.prototype=new THREE.Object3D;THREE.Gyroscope.prototype.constructor=THREE.Gyroscope;
THREE.Gyroscope.prototype.updateMatrixWorld=function(b){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b){if(this.parent){this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix);this.matrixWorld.decompose(this.translationWorld,this.rotationWorld,this.scaleWorld);this.matrix.decompose(this.translationObject,this.rotationObject,this.scaleObject);this.matrixWorld.compose(this.translationWorld,this.rotationObject,this.scaleWorld)}else this.matrixWorld.copy(this.matrix);
this.matrixWorldNeedsUpdate=false;b=true}for(var a=0,c=this.children.length;a<c;a++)this.children[a].updateMatrixWorld(b)};THREE.Gyroscope.prototype.translationWorld=new THREE.Vector3;THREE.Gyroscope.prototype.translationObject=new THREE.Vector3;THREE.Gyroscope.prototype.rotationWorld=new THREE.Quaternion;THREE.Gyroscope.prototype.rotationObject=new THREE.Quaternion;THREE.Gyroscope.prototype.scaleWorld=new THREE.Vector3;THREE.Gyroscope.prototype.scaleObject=new THREE.Vector3;
THREE.Path=function(b){THREE.CurvePath.call(this);this.actions=[];b&&this.fromPoints(b)};THREE.Path.prototype=new THREE.CurvePath;THREE.Path.prototype.constructor=THREE.Path;THREE.PathActions={MOVE_TO:"moveTo",LINE_TO:"lineTo",QUADRATIC_CURVE_TO:"quadraticCurveTo",BEZIER_CURVE_TO:"bezierCurveTo",CSPLINE_THRU:"splineThru",ARC:"arc"};THREE.Path.prototype.fromPoints=function(b){this.moveTo(b[0].x,b[0].y);for(var a=1,c=b.length;a<c;a++)this.lineTo(b[a].x,b[a].y)};
THREE.Path.prototype.moveTo=function(b,a){var c=Array.prototype.slice.call(arguments);this.actions.push({action:THREE.PathActions.MOVE_TO,args:c})};THREE.Path.prototype.lineTo=function(b,a){var c=Array.prototype.slice.call(arguments),d=this.actions[this.actions.length-1].args;this.curves.push(new THREE.LineCurve(new THREE.Vector2(d[d.length-2],d[d.length-1]),new THREE.Vector2(b,a)));this.actions.push({action:THREE.PathActions.LINE_TO,args:c})};
THREE.Path.prototype.quadraticCurveTo=function(b,a,c,d){var e=Array.prototype.slice.call(arguments),f=this.actions[this.actions.length-1].args;this.curves.push(new THREE.QuadraticBezierCurve(new THREE.Vector2(f[f.length-2],f[f.length-1]),new THREE.Vector2(b,a),new THREE.Vector2(c,d)));this.actions.push({action:THREE.PathActions.QUADRATIC_CURVE_TO,args:e})};
THREE.Path.prototype.bezierCurveTo=function(b,a,c,d,e,f){var g=Array.prototype.slice.call(arguments),h=this.actions[this.actions.length-1].args;this.curves.push(new THREE.CubicBezierCurve(new THREE.Vector2(h[h.length-2],h[h.length-1]),new THREE.Vector2(b,a),new THREE.Vector2(c,d),new THREE.Vector2(e,f)));this.actions.push({action:THREE.PathActions.BEZIER_CURVE_TO,args:g})};
THREE.Path.prototype.splineThru=function(b){var a=Array.prototype.slice.call(arguments),c=this.actions[this.actions.length-1].args,c=[new THREE.Vector2(c[c.length-2],c[c.length-1])];Array.prototype.push.apply(c,b);this.curves.push(new THREE.SplineCurve(c));this.actions.push({action:THREE.PathActions.CSPLINE_THRU,args:a})};
THREE.Path.prototype.arc=function(b,a,c,d,e,f){var g=Array.prototype.slice.call(arguments),h=this.actions[this.actions.length-1],h=new THREE.ArcCurve(h.x+b,h.y+a,c,d,e,f);this.curves.push(h);h=h.getPoint(f?1:0);g.push(h.x);g.push(h.y);this.actions.push({action:THREE.PathActions.ARC,args:g})};
THREE.Path.prototype.absarc=function(b,a,c,d,e,f){var g=Array.prototype.slice.call(arguments),h=new THREE.ArcCurve(b,a,c,d,e,f);this.curves.push(h);h=h.getPoint(f?1:0);g.push(h.x);g.push(h.y);this.actions.push({action:THREE.PathActions.ARC,args:g})};THREE.Path.prototype.getSpacedPoints=function(b){b||(b=40);for(var a=[],c=0;c<b;c++)a.push(this.getPoint(c/b));return a};
THREE.Path.prototype.getPoints=function(b,a){if(this.useSpacedPoints){console.log("tata");return this.getSpacedPoints(b,a)}var b=b||12,c=[],d,e,f,g,h,i,j,l,n,k,m,o,q;d=0;for(e=this.actions.length;d<e;d++){f=this.actions[d];g=f.action;f=f.args;switch(g){case THREE.PathActions.MOVE_TO:c.push(new THREE.Vector2(f[0],f[1]));break;case THREE.PathActions.LINE_TO:c.push(new THREE.Vector2(f[0],f[1]));break;case THREE.PathActions.QUADRATIC_CURVE_TO:h=f[2];i=f[3];n=f[0];k=f[1];if(c.length>0){g=c[c.length-1];
m=g.x;o=g.y}else{g=this.actions[d-1].args;m=g[g.length-2];o=g[g.length-1]}for(f=1;f<=b;f++){q=f/b;g=THREE.Shape.Utils.b2(q,m,n,h);q=THREE.Shape.Utils.b2(q,o,k,i);c.push(new THREE.Vector2(g,q))}break;case THREE.PathActions.BEZIER_CURVE_TO:h=f[4];i=f[5];n=f[0];k=f[1];j=f[2];l=f[3];if(c.length>0){g=c[c.length-1];m=g.x;o=g.y}else{g=this.actions[d-1].args;m=g[g.length-2];o=g[g.length-1]}for(f=1;f<=b;f++){q=f/b;g=THREE.Shape.Utils.b3(q,m,n,j,h);q=THREE.Shape.Utils.b3(q,o,k,l,i);c.push(new THREE.Vector2(g,
q))}break;case THREE.PathActions.CSPLINE_THRU:g=this.actions[d-1].args;q=[new THREE.Vector2(g[g.length-2],g[g.length-1])];g=b*f[0].length;q=q.concat(f[0]);q=new THREE.SplineCurve(q);for(f=1;f<=g;f++)c.push(q.getPointAt(f/g));break;case THREE.PathActions.ARC:h=f[0];i=f[1];j=f[2];n=f[3];k=!!f[5];l=f[4]-n;m=b*2;for(f=1;f<=m;f++){q=f/m;k||(q=1-q);q=n+q*l;g=h+j*Math.cos(q);q=i+j*Math.sin(q);c.push(new THREE.Vector2(g,q))}}}d=c[c.length-1];Math.abs(d.x-c[0].x)<1.0E-10&&Math.abs(d.y-c[0].y)<1.0E-10&&c.splice(c.length-
1,1);a&&c.push(c[0]);return c};THREE.Path.prototype.transform=function(b,a){this.getBoundingBox();return this.getWrapPoints(this.getPoints(a),b)};THREE.Path.prototype.nltransform=function(b,a,c,d,e,f){var g=this.getPoints(),h,i,j,l,n;h=0;for(i=g.length;h<i;h++){j=g[h];l=j.x;n=j.y;j.x=b*l+a*n+c;j.y=d*n+e*l+f}return g};
THREE.Path.prototype.debug=function(b){var a=this.getBoundingBox();if(!b){b=document.createElement("canvas");b.setAttribute("width",a.maxX+100);b.setAttribute("height",a.maxY+100);document.body.appendChild(b)}a=b.getContext("2d");a.fillStyle="white";a.fillRect(0,0,b.width,b.height);a.strokeStyle="black";a.beginPath();var c,d,e,b=0;for(c=this.actions.length;b<c;b++){d=this.actions[b];e=d.args;d=d.action;d!=THREE.PathActions.CSPLINE_THRU&&a[d].apply(a,e)}a.stroke();a.closePath();a.strokeStyle="red";
d=this.getPoints();b=0;for(c=d.length;b<c;b++){e=d[b];a.beginPath();a.arc(e.x,e.y,1.5,0,Math.PI*2,false);a.stroke();a.closePath()}};
THREE.Path.prototype.toShapes=function(){var b,a,c,d,e=[],f=new THREE.Path;b=0;for(a=this.actions.length;b<a;b++){c=this.actions[b];d=c.args;c=c.action;if(c==THREE.PathActions.MOVE_TO&&f.actions.length!=0){e.push(f);f=new THREE.Path}f[c].apply(f,d)}f.actions.length!=0&&e.push(f);if(e.length==0)return[];var g;d=[];b=!THREE.Shape.Utils.isClockWise(e[0].getPoints());if(e.length==1){f=e[0];g=new THREE.Shape;g.actions=f.actions;g.curves=f.curves;d.push(g);return d}if(b){g=new THREE.Shape;b=0;for(a=e.length;b<
a;b++){f=e[b];if(THREE.Shape.Utils.isClockWise(f.getPoints())){g.actions=f.actions;g.curves=f.curves;d.push(g);g=new THREE.Shape}else g.holes.push(f)}}else{b=0;for(a=e.length;b<a;b++){f=e[b];if(THREE.Shape.Utils.isClockWise(f.getPoints())){g&&d.push(g);g=new THREE.Shape;g.actions=f.actions;g.curves=f.curves}else g.holes.push(f)}d.push(g)}return d};THREE.Shape=function(){THREE.Path.apply(this,arguments);this.holes=[]};THREE.Shape.prototype=new THREE.Path;THREE.Shape.prototype.constructor=THREE.Path;
THREE.Shape.prototype.extrude=function(b){return new THREE.ExtrudeGeometry(this,b)};THREE.Shape.prototype.getPointsHoles=function(b){var a,c=this.holes.length,d=[];for(a=0;a<c;a++)d[a]=this.holes[a].getTransformedPoints(b,this.bends);return d};THREE.Shape.prototype.getSpacedPointsHoles=function(b){var a,c=this.holes.length,d=[];for(a=0;a<c;a++)d[a]=this.holes[a].getTransformedSpacedPoints(b,this.bends);return d};
THREE.Shape.prototype.extractAllPoints=function(b){return{shape:this.getTransformedPoints(b),holes:this.getPointsHoles(b)}};THREE.Shape.prototype.extractPoints=function(b){return this.useSpacedPoints?this.extractAllSpacedPoints(b):this.extractAllPoints(b)};THREE.Shape.prototype.extractAllSpacedPoints=function(b){return{shape:this.getTransformedSpacedPoints(b),holes:this.getSpacedPointsHoles(b)}};
THREE.Shape.Utils={removeHoles:function(b,a){var c=b.concat(),d=c.concat(),e,f,g,h,i,j,l,n,k,m,o=[];for(i=0;i<a.length;i++){j=a[i];Array.prototype.push.apply(d,j);f=Number.POSITIVE_INFINITY;for(e=0;e<j.length;e++){k=j[e];m=[];for(n=0;n<c.length;n++){l=c[n];l=k.distanceToSquared(l);m.push(l);if(l<f){f=l;g=e;h=n}}}e=h-1>=0?h-1:c.length-1;f=g-1>=0?g-1:j.length-1;var q=[j[g],c[h],c[e]];n=THREE.FontUtils.Triangulate.area(q);var r=[j[g],j[f],c[h]];k=THREE.FontUtils.Triangulate.area(r);m=h;l=g;h=h+1;g=g+
-1;h<0&&(h=h+c.length);h=h%c.length;g<0&&(g=g+j.length);g=g%j.length;e=h-1>=0?h-1:c.length-1;f=g-1>=0?g-1:j.length-1;q=[j[g],c[h],c[e]];q=THREE.FontUtils.Triangulate.area(q);r=[j[g],j[f],c[h]];r=THREE.FontUtils.Triangulate.area(r);if(n+k>q+r){h=m;g=l;h<0&&(h=h+c.length);h=h%c.length;g<0&&(g=g+j.length);g=g%j.length;e=h-1>=0?h-1:c.length-1;f=g-1>=0?g-1:j.length-1}n=c.slice(0,h);k=c.slice(h);m=j.slice(g);l=j.slice(0,g);f=[j[g],j[f],c[h]];o.push([j[g],c[h],c[e]]);o.push(f);c=n.concat(m).concat(l).concat(k)}return{shape:c,
isolatedPts:o,allpoints:d}},triangulateShape:function(b,a){var c=THREE.Shape.Utils.removeHoles(b,a),d=c.allpoints,e=c.isolatedPts,c=THREE.FontUtils.Triangulate(c.shape,false),f,g,h,i,j={};f=0;for(g=d.length;f<g;f++){i=d[f].x+":"+d[f].y;j[i]!==void 0&&console.log("Duplicate point",i);j[i]=f}f=0;for(g=c.length;f<g;f++){h=c[f];for(d=0;d<3;d++){i=h[d].x+":"+h[d].y;i=j[i];i!==void 0&&(h[d]=i)}}f=0;for(g=e.length;f<g;f++){h=e[f];for(d=0;d<3;d++){i=h[d].x+":"+h[d].y;i=j[i];i!==void 0&&(h[d]=i)}}return c.concat(e)},
isClockWise:function(b){return THREE.FontUtils.Triangulate.area(b)<0},b2p0:function(b,a){var c=1-b;return c*c*a},b2p1:function(b,a){return 2*(1-b)*b*a},b2p2:function(b,a){return b*b*a},b2:function(b,a,c,d){return this.b2p0(b,a)+this.b2p1(b,c)+this.b2p2(b,d)},b3p0:function(b,a){var c=1-b;return c*c*c*a},b3p1:function(b,a){var c=1-b;return 3*c*c*b*a},b3p2:function(b,a){return 3*(1-b)*b*b*a},b3p3:function(b,a){return b*b*b*a},b3:function(b,a,c,d,e){return this.b3p0(b,a)+this.b3p1(b,c)+this.b3p2(b,d)+
this.b3p3(b,e)}};THREE.TextPath=function(b,a){THREE.Path.call(this);this.parameters=a||{};this.set(b)};THREE.TextPath.prototype.set=function(b,a){a=a||this.parameters;this.text=b;var c=a.curveSegments!==void 0?a.curveSegments:4,d=a.font!==void 0?a.font:"helvetiker",e=a.weight!==void 0?a.weight:"normal",f=a.style!==void 0?a.style:"normal";THREE.FontUtils.size=a.size!==void 0?a.size:100;THREE.FontUtils.divisions=c;THREE.FontUtils.face=d;THREE.FontUtils.weight=e;THREE.FontUtils.style=f};
THREE.TextPath.prototype.toShapes=function(){for(var b=THREE.FontUtils.drawText(this.text).paths,a=[],c=0,d=b.length;c<d;c++)Array.prototype.push.apply(a,b[c].toShapes());return a};
THREE.AnimationHandler=function(){var b=[],a={},c={update:function(a){for(var c=0;c<b.length;c++)b[c].update(a)},addToUpdate:function(a){b.indexOf(a)===-1&&b.push(a)},removeFromUpdate:function(a){a=b.indexOf(a);a!==-1&&b.splice(a,1)},add:function(b){a[b.name]!==void 0&&console.log("THREE.AnimationHandler.add: Warning! "+b.name+" already exists in library. Overwriting.");a[b.name]=b;if(b.initialized!==true){for(var c=0;c<b.hierarchy.length;c++){for(var d=0;d<b.hierarchy[c].keys.length;d++){if(b.hierarchy[c].keys[d].time<
0)b.hierarchy[c].keys[d].time=0;if(b.hierarchy[c].keys[d].rot!==void 0&&!(b.hierarchy[c].keys[d].rot instanceof THREE.Quaternion)){var h=b.hierarchy[c].keys[d].rot;b.hierarchy[c].keys[d].rot=new THREE.Quaternion(h[0],h[1],h[2],h[3])}}if(b.hierarchy[c].keys.length&&b.hierarchy[c].keys[0].morphTargets!==void 0){h={};for(d=0;d<b.hierarchy[c].keys.length;d++)for(var i=0;i<b.hierarchy[c].keys[d].morphTargets.length;i++){var j=b.hierarchy[c].keys[d].morphTargets[i];h[j]=-1}b.hierarchy[c].usedMorphTargets=
h;for(d=0;d<b.hierarchy[c].keys.length;d++){var l={};for(j in h){for(i=0;i<b.hierarchy[c].keys[d].morphTargets.length;i++)if(b.hierarchy[c].keys[d].morphTargets[i]===j){l[j]=b.hierarchy[c].keys[d].morphTargetsInfluences[i];break}i===b.hierarchy[c].keys[d].morphTargets.length&&(l[j]=0)}b.hierarchy[c].keys[d].morphTargetsInfluences=l}}for(d=1;d<b.hierarchy[c].keys.length;d++)if(b.hierarchy[c].keys[d].time===b.hierarchy[c].keys[d-1].time){b.hierarchy[c].keys.splice(d,1);d--}for(d=0;d<b.hierarchy[c].keys.length;d++)b.hierarchy[c].keys[d].index=
d}d=parseInt(b.length*b.fps,10);b.JIT={};b.JIT.hierarchy=[];for(c=0;c<b.hierarchy.length;c++)b.JIT.hierarchy.push(Array(d));b.initialized=true}},get:function(b){if(typeof b==="string"){if(a[b])return a[b];console.log("THREE.AnimationHandler.get: Couldn't find animation "+b);return null}},parse:function(a){var b=[];if(a instanceof THREE.SkinnedMesh)for(var c=0;c<a.bones.length;c++)b.push(a.bones[c]);else d(a,b);return b}},d=function(a,b){b.push(a);for(var c=0;c<a.children.length;c++)d(a.children[c],
b)};c.LINEAR=0;c.CATMULLROM=1;c.CATMULLROM_FORWARD=2;return c}();THREE.Animation=function(b,a,c,d){this.root=b;this.data=THREE.AnimationHandler.get(a);this.hierarchy=THREE.AnimationHandler.parse(b);this.currentTime=0;this.timeScale=1;this.isPlaying=false;this.loop=this.isPaused=true;this.interpolationType=c!==void 0?c:THREE.AnimationHandler.LINEAR;this.JITCompile=d!==void 0?d:true;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(b,a){if(!this.isPlaying){this.isPlaying=true;this.loop=b!==void 0?b:true;this.currentTime=a!==void 0?a:0;var c,d=this.hierarchy.length,e;for(c=0;c<d;c++){e=this.hierarchy[c];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)e.useQuaternion=true;e.matrixAutoUpdate=true;if(e.animationCache===void 0){e.animationCache={};e.animationCache.prevKey={pos:0,rot:0,scl:0};e.animationCache.nextKey={pos:0,rot:0,scl:0};e.animationCache.originalMatrix=
e instanceof THREE.Bone?e.skinMatrix:e.matrix}var f=e.animationCache.prevKey;e=e.animationCache.nextKey;f.pos=this.data.hierarchy[c].keys[0];f.rot=this.data.hierarchy[c].keys[0];f.scl=this.data.hierarchy[c].keys[0];e.pos=this.getNextKeyWith("pos",c,1);e.rot=this.getNextKeyWith("rot",c,1);e.scl=this.getNextKeyWith("scl",c,1)}this.update(0)}this.isPaused=false;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPaused=this.isPlaying=false;THREE.AnimationHandler.removeFromUpdate(this);for(var b=0;b<this.hierarchy.length;b++)if(this.hierarchy[b].animationCache!==void 0){this.hierarchy[b]instanceof THREE.Bone?this.hierarchy[b].skinMatrix=this.hierarchy[b].animationCache.originalMatrix:this.hierarchy[b].matrix=this.hierarchy[b].animationCache.originalMatrix;delete this.hierarchy[b].animationCache}};
THREE.Animation.prototype.update=function(b){if(this.isPlaying){var a=["pos","rot","scl"],c,d,e,f,g,h,i,j,l=this.data.JIT.hierarchy,n,k;k=this.currentTime=this.currentTime+b*this.timeScale;n=this.currentTime=this.currentTime%this.data.length;j=parseInt(Math.min(n*this.data.fps,this.data.length*this.data.fps),10);for(var m=0,o=this.hierarchy.length;m<o;m++){b=this.hierarchy[m];i=b.animationCache;if(this.JITCompile&&l[m][j]!==void 0)if(b instanceof THREE.Bone){b.skinMatrix=l[m][j];b.matrixAutoUpdate=
false;b.matrixWorldNeedsUpdate=false}else{b.matrix=l[m][j];b.matrixAutoUpdate=false;b.matrixWorldNeedsUpdate=true}else{if(this.JITCompile)b instanceof THREE.Bone?b.skinMatrix=b.animationCache.originalMatrix:b.matrix=b.animationCache.originalMatrix;for(var q=0;q<3;q++){c=a[q];g=i.prevKey[c];h=i.nextKey[c];if(h.time<=k){if(n<k)if(this.loop){g=this.data.hierarchy[m].keys[0];for(h=this.getNextKeyWith(c,m,1);h.time<n;){g=h;h=this.getNextKeyWith(c,m,h.index+1)}}else{this.stop();return}else{do{g=h;h=this.getNextKeyWith(c,
m,h.index+1)}while(h.time<n)}i.prevKey[c]=g;i.nextKey[c]=h}b.matrixAutoUpdate=true;b.matrixWorldNeedsUpdate=true;d=(n-g.time)/(h.time-g.time);e=g[c];f=h[c];if(d<0||d>1){console.log("THREE.Animation.update: Warning! Scale out of bounds:"+d+" on bone "+m);d=d<0?0:1}if(c==="pos"){c=b.position;if(this.interpolationType===THREE.AnimationHandler.LINEAR){c.x=e[0]+(f[0]-e[0])*d;c.y=e[1]+(f[1]-e[1])*d;c.z=e[2]+(f[2]-e[2])*d}else if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===
THREE.AnimationHandler.CATMULLROM_FORWARD){this.points[0]=this.getPrevKeyWith("pos",m,g.index-1).pos;this.points[1]=e;this.points[2]=f;this.points[3]=this.getNextKeyWith("pos",m,h.index+1).pos;d=d*0.33+0.33;e=this.interpolateCatmullRom(this.points,d);c.x=e[0];c.y=e[1];c.z=e[2];if(this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){d=this.interpolateCatmullRom(this.points,d*1.01);this.target.set(d[0],d[1],d[2]);this.target.subSelf(c);this.target.y=0;this.target.normalize();d=Math.atan2(this.target.x,
this.target.z);b.rotation.set(0,d,0)}}}else if(c==="rot")THREE.Quaternion.slerp(e,f,b.quaternion,d);else if(c==="scl"){c=b.scale;c.x=e[0]+(f[0]-e[0])*d;c.y=e[1]+(f[1]-e[1])*d;c.z=e[2]+(f[2]-e[2])*d}}}}if(this.JITCompile&&l[0][j]===void 0){this.hierarchy[0].updateMatrixWorld(true);for(m=0;m<this.hierarchy.length;m++)l[m][j]=this.hierarchy[m]instanceof THREE.Bone?this.hierarchy[m].skinMatrix.clone():this.hierarchy[m].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(b,a){var c=[],d=[],e,f,g,h,i,j;e=(b.length-1)*a;f=Math.floor(e);e=e-f;c[0]=f===0?f:f-1;c[1]=f;c[2]=f>b.length-2?f:f+1;c[3]=f>b.length-3?f:f+2;f=b[c[0]];h=b[c[1]];i=b[c[2]];j=b[c[3]];c=e*e;g=e*c;d[0]=this.interpolate(f[0],h[0],i[0],j[0],e,c,g);d[1]=this.interpolate(f[1],h[1],i[1],j[1],e,c,g);d[2]=this.interpolate(f[2],h[2],i[2],j[2],e,c,g);return d};
THREE.Animation.prototype.interpolate=function(b,a,c,d,e,f,g){b=(c-b)*0.5;d=(d-a)*0.5;return(2*(a-c)+b+d)*g+(-3*(a-c)-2*b-d)*f+b*e+a};THREE.Animation.prototype.getNextKeyWith=function(b,a,c){for(var d=this.data.hierarchy[a].keys,c=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c<d.length-1?c:d.length-1:c%d.length;c<d.length;c++)if(d[c][b]!==void 0)return d[c];return this.data.hierarchy[a].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(b,a,c){for(var d=this.data.hierarchy[a].keys,c=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c>0?c:0:c>=0?c:c+d.length;c>=0;c--)if(d[c][b]!==void 0)return d[c];return this.data.hierarchy[a].keys[d.length-1]};
THREE.KeyFrameAnimation=function(b,a,c){this.root=b;this.data=THREE.AnimationHandler.get(a);this.hierarchy=THREE.AnimationHandler.parse(b);this.currentTime=0;this.timeScale=0.001;this.isPlaying=false;this.loop=this.isPaused=true;this.JITCompile=c!==void 0?c:true;b=0;for(a=this.hierarchy.length;b<a;b++){var c=this.data.hierarchy[b].sids,d=this.hierarchy[b];if(this.data.hierarchy[b].keys.length&&c){for(var e=0;e<c.length;e++){var f=c[e],g=this.getNextKeyWith(f,b,0);g&&g.apply(f)}d.matrixAutoUpdate=
false;this.data.hierarchy[b].node.updateMatrix();d.matrixWorldNeedsUpdate=true}}};
THREE.KeyFrameAnimation.prototype.play=function(b,a){if(!this.isPlaying){this.isPlaying=true;this.loop=b!==void 0?b:true;this.currentTime=a!==void 0?a:0;this.startTimeMs=a;this.startTime=1E7;this.endTime=-this.startTime;var c,d=this.hierarchy.length,e,f;for(c=0;c<d;c++){e=this.hierarchy[c];f=this.data.hierarchy[c];e.useQuaternion=true;if(f.animationCache===void 0){f.animationCache={};f.animationCache.prevKey=null;f.animationCache.nextKey=null;f.animationCache.originalMatrix=e instanceof THREE.Bone?
e.skinMatrix:e.matrix}e=this.data.hierarchy[c].keys;if(e.length){f.animationCache.prevKey=e[0];f.animationCache.nextKey=e[1];this.startTime=Math.min(e[0].time,this.startTime);this.endTime=Math.max(e[e.length-1].time,this.endTime)}}this.update(0)}this.isPaused=false;THREE.AnimationHandler.addToUpdate(this)};THREE.KeyFrameAnimation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.KeyFrameAnimation.prototype.stop=function(){this.isPaused=this.isPlaying=false;THREE.AnimationHandler.removeFromUpdate(this);for(var b=0;b<this.data.hierarchy.length;b++){var a=this.hierarchy[b],c=this.data.hierarchy[b];if(c.animationCache!==void 0){var d=c.animationCache.originalMatrix;if(a instanceof THREE.Bone){d.copy(a.skinMatrix);a.skinMatrix=d}else{d.copy(a.matrix);a.matrix=d}delete c.animationCache}}};
THREE.KeyFrameAnimation.prototype.update=function(b){if(this.isPlaying){var a,c,d,e,f=this.data.JIT.hierarchy,g,h,i;h=this.currentTime=this.currentTime+b*this.timeScale;g=this.currentTime=this.currentTime%this.data.length;if(g<this.startTimeMs)g=this.currentTime=this.startTimeMs+g;e=parseInt(Math.min(g*this.data.fps,this.data.length*this.data.fps),10);if((i=g<h)&&!this.loop){for(var b=0,j=this.hierarchy.length;b<j;b++){var l=this.data.hierarchy[b].keys,f=this.data.hierarchy[b].sids;d=l.length-1;e=
this.hierarchy[b];if(l.length){for(l=0;l<f.length;l++){g=f[l];(h=this.getPrevKeyWith(g,b,d))&&h.apply(g)}this.data.hierarchy[b].node.updateMatrix();e.matrixWorldNeedsUpdate=true}}this.stop()}else if(!(g<this.startTime)){b=0;for(j=this.hierarchy.length;b<j;b++){d=this.hierarchy[b];a=this.data.hierarchy[b];var l=a.keys,n=a.animationCache;if(this.JITCompile&&f[b][e]!==void 0)if(d instanceof THREE.Bone){d.skinMatrix=f[b][e];d.matrixWorldNeedsUpdate=false}else{d.matrix=f[b][e];d.matrixWorldNeedsUpdate=
true}else if(l.length){if(this.JITCompile&&n)d instanceof THREE.Bone?d.skinMatrix=n.originalMatrix:d.matrix=n.originalMatrix;a=n.prevKey;c=n.nextKey;if(a&&c){if(c.time<=h){if(i&&this.loop){a=l[0];for(c=l[1];c.time<g;){a=c;c=l[a.index+1]}}else if(!i)for(var k=l.length-1;c.time<g&&c.index!==k;){a=c;c=l[a.index+1]}n.prevKey=a;n.nextKey=c}c.time>=g?a.interpolate(c,g):a.interpolate(c,c.time)}this.data.hierarchy[b].node.updateMatrix();d.matrixWorldNeedsUpdate=true}}if(this.JITCompile&&f[0][e]===void 0){this.hierarchy[0].updateMatrixWorld(true);
for(b=0;b<this.hierarchy.length;b++)f[b][e]=this.hierarchy[b]instanceof THREE.Bone?this.hierarchy[b].skinMatrix.clone():this.hierarchy[b].matrix.clone()}}}};THREE.KeyFrameAnimation.prototype.getNextKeyWith=function(b,a,c){a=this.data.hierarchy[a].keys;for(c=c%a.length;c<a.length;c++)if(a[c].hasTarget(b))return a[c];return a[0]};
THREE.KeyFrameAnimation.prototype.getPrevKeyWith=function(b,a,c){a=this.data.hierarchy[a].keys;for(c=c>=0?c:c+a.length;c>=0;c--)if(a[c].hasTarget(b))return a[c];return a[a.length-1]};
THREE.CubeCamera=function(b,a,c){THREE.Object3D.call(this);var d=new THREE.PerspectiveCamera(90,1,b,a);d.up.set(0,-1,0);d.lookAt(new THREE.Vector3(1,0,0));this.add(d);var e=new THREE.PerspectiveCamera(90,1,b,a);e.up.set(0,-1,0);e.lookAt(new THREE.Vector3(-1,0,0));this.add(e);var f=new THREE.PerspectiveCamera(90,1,b,a);f.up.set(0,0,1);f.lookAt(new THREE.Vector3(0,1,0));this.add(f);var g=new THREE.PerspectiveCamera(90,1,b,a);g.up.set(0,0,-1);g.lookAt(new THREE.Vector3(0,-1,0));this.add(g);var h=new THREE.PerspectiveCamera(90,
1,b,a);h.up.set(0,-1,0);h.lookAt(new THREE.Vector3(0,0,1));this.add(h);var i=new THREE.PerspectiveCamera(90,1,b,a);i.up.set(0,-1,0);i.lookAt(new THREE.Vector3(0,0,-1));this.add(i);this.renderTarget=new THREE.WebGLRenderTargetCube(c,c,{format:THREE.RGBFormat,magFilter:THREE.LinearFilter,minFilter:THREE.LinearFilter});this.updateCubeMap=function(a,b){var c=this.renderTarget,k=c.generateMipmaps;c.generateMipmaps=false;c.activeCubeFace=0;a.render(b,d,c);c.activeCubeFace=1;a.render(b,e,c);c.activeCubeFace=
2;a.render(b,f,c);c.activeCubeFace=3;a.render(b,g,c);c.activeCubeFace=4;a.render(b,h,c);c.generateMipmaps=k;c.activeCubeFace=5;a.render(b,i,c)}};THREE.CubeCamera.prototype=new THREE.Object3D;THREE.CubeCamera.prototype.constructor=THREE.CubeCamera;
THREE.CombinedCamera=function(b,a,c,d,e,f,g){THREE.Camera.call(this);this.fov=c;this.left=-b/2;this.right=b/2;this.top=a/2;this.bottom=-a/2;this.cameraO=new THREE.OrthographicCamera(b/-2,b/2,a/2,a/-2,f,g);this.cameraP=new THREE.PerspectiveCamera(c,b/a,d,e);this.zoom=1;this.toPerspective()};THREE.CombinedCamera.prototype=new THREE.Camera;THREE.CombinedCamera.prototype.constructor=THREE.CombinedCamera;
THREE.CombinedCamera.prototype.toPerspective=function(){this.near=this.cameraP.near;this.far=this.cameraP.far;this.cameraP.fov=this.fov/this.zoom;this.cameraP.updateProjectionMatrix();this.projectionMatrix=this.cameraP.projectionMatrix;this.inPersepectiveMode=true;this.inOrthographicMode=false};
THREE.CombinedCamera.prototype.toOrthographic=function(){var b=this.cameraP.aspect,a=(this.cameraP.near+this.cameraP.far)/2,a=Math.tan(this.fov/2)*a,b=2*a*b/2,a=a/this.zoom,b=b/this.zoom;this.cameraO.left=-b;this.cameraO.right=b;this.cameraO.top=a;this.cameraO.bottom=-a;this.cameraO.updateProjectionMatrix();this.near=this.cameraO.near;this.far=this.cameraO.far;this.projectionMatrix=this.cameraO.projectionMatrix;this.inPersepectiveMode=false;this.inOrthographicMode=true};
THREE.CombinedCamera.prototype.setSize=function(b,a){this.cameraP.aspect=b/a;this.left=-b/2;this.right=b/2;this.top=a/2;this.bottom=-a/2};THREE.CombinedCamera.prototype.setFov=function(b){this.fov=b;this.inPersepectiveMode?this.toPerspective():this.toOrthographic()};THREE.CombinedCamera.prototype.updateProjectionMatrix=function(){if(this.inPersepectiveMode)this.toPerspective();else{this.toPerspective();this.toOrthographic()}};
THREE.CombinedCamera.prototype.setLens=function(b,a){var c=2*Math.atan((a!==void 0?a:24)/(b*2))*(180/Math.PI);this.setFov(c);return c};THREE.CombinedCamera.prototype.setZoom=function(b){this.zoom=b;this.inPersepectiveMode?this.toPerspective():this.toOrthographic()};THREE.CombinedCamera.prototype.toFrontView=function(){this.rotation.x=0;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=false};
THREE.CombinedCamera.prototype.toBackView=function(){this.rotation.x=0;this.rotation.y=Math.PI;this.rotation.z=0;this.rotationAutoUpdate=false};THREE.CombinedCamera.prototype.toLeftView=function(){this.rotation.x=0;this.rotation.y=-Math.PI/2;this.rotation.z=0;this.rotationAutoUpdate=false};THREE.CombinedCamera.prototype.toRightView=function(){this.rotation.x=0;this.rotation.y=Math.PI/2;this.rotation.z=0;this.rotationAutoUpdate=false};
THREE.CombinedCamera.prototype.toTopView=function(){this.rotation.x=-Math.PI/2;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=false};THREE.CombinedCamera.prototype.toBottomView=function(){this.rotation.x=Math.PI/2;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=false};
THREE.FirstPersonControls=function(b,a){function c(a,b){return function(){b.apply(a,arguments)}}this.object=b;this.target=new THREE.Vector3(0,0,0);this.domElement=a!==void 0?a:document;this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=false;this.lookVertical=true;this.autoForward=false;this.activeLook=true;this.heightSpeed=false;this.heightCoef=1;this.heightMin=0;this.constrainVertical=false;this.verticalMin=0;this.verticalMax=Math.PI;this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=
this.autoSpeedFactor=0;this.mouseDragOn=this.freeze=this.moveRight=this.moveLeft=this.moveBackward=this.moveForward=false;if(this.domElement===document){this.viewHalfX=window.innerWidth/2;this.viewHalfY=window.innerHeight/2}else{this.viewHalfX=this.domElement.offsetWidth/2;this.viewHalfY=this.domElement.offsetHeight/2;this.domElement.setAttribute("tabindex",-1)}this.onMouseDown=function(a){this.domElement!==document&&this.domElement.focus();a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=
true;break;case 2:this.moveBackward=true}this.mouseDragOn=true};this.onMouseUp=function(a){a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=false;break;case 2:this.moveBackward=false}this.mouseDragOn=false};this.onMouseMove=function(a){if(this.domElement===document){this.mouseX=a.pageX-this.viewHalfX;this.mouseY=a.pageY-this.viewHalfY}else{this.mouseX=a.pageX-this.domElement.offsetLeft-this.viewHalfX;this.mouseY=a.pageY-this.domElement.offsetTop-this.viewHalfY}};
this.onKeyDown=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=true;break;case 37:case 65:this.moveLeft=true;break;case 40:case 83:this.moveBackward=true;break;case 39:case 68:this.moveRight=true;break;case 82:this.moveUp=true;break;case 70:this.moveDown=true;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=false;break;case 37:case 65:this.moveLeft=false;break;case 40:case 83:this.moveBackward=false;break;case 39:case 68:this.moveRight=
false;break;case 82:this.moveUp=false;break;case 70:this.moveDown=false}};this.update=function(a){var b=0;if(!this.freeze){if(this.heightSpeed){b=THREE.Math.clamp(this.object.position.y,this.heightMin,this.heightMax)-this.heightMin;this.autoSpeedFactor=a*b*this.heightCoef}else this.autoSpeedFactor=0;b=a*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.object.translateZ(-(b+this.autoSpeedFactor));this.moveBackward&&this.object.translateZ(b);this.moveLeft&&this.object.translateX(-b);
this.moveRight&&this.object.translateX(b);this.moveUp&&this.object.translateY(b);this.moveDown&&this.object.translateY(-b);a=a*this.lookSpeed;this.activeLook||(a=0);this.lon=this.lon+this.mouseX*a;if(this.lookVertical)this.lat=this.lat-this.mouseY*a;this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var b=this.target,c=this.object.position;b.x=c.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=c.y+100*Math.cos(this.phi);b.z=c.z+100*Math.sin(this.phi)*
Math.sin(this.theta);b=1;this.constrainVertical&&(b=Math.PI/(this.verticalMax-this.verticalMin));this.lon=this.lon+this.mouseX*a;if(this.lookVertical)this.lat=this.lat-this.mouseY*a*b;this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=THREE.Math.mapLinear(this.phi,0,Math.PI,this.verticalMin,this.verticalMax);b=this.target;c=this.object.position;b.x=c.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=c.y+
100*Math.cos(this.phi);b.z=c.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.object.lookAt(b)}};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},false);this.domElement.addEventListener("mousemove",c(this,this.onMouseMove),false);this.domElement.addEventListener("mousedown",c(this,this.onMouseDown),false);this.domElement.addEventListener("mouseup",c(this,this.onMouseUp),false);this.domElement.addEventListener("keydown",c(this,this.onKeyDown),false);this.domElement.addEventListener("keyup",
c(this,this.onKeyUp),false)};
THREE.PathControls=function(b,a){function c(a){return(a=a*2)<1?0.5*a*a:-0.5*(--a*(a-2)-1)}function d(a,b){return function(){b.apply(a,arguments)}}function e(a,b,c,d){var e={name:c,fps:0.6,length:d,hierarchy:[]},f,g=b.getControlPointsArray(),h=b.getLength(),r=g.length,s=0;f=r-1;b={parent:-1,keys:[]};b.keys[0]={time:0,pos:g[0],rot:[0,0,0,1],scl:[1,1,1]};b.keys[f]={time:d,pos:g[f],rot:[0,0,0,1],scl:[1,1,1]};for(f=1;f<r-1;f++){s=d*h.chunks[f]/h.total;b.keys[f]={time:s,pos:g[f]}}e.hierarchy[0]=b;THREE.AnimationHandler.add(e);
return new THREE.Animation(a,c,THREE.AnimationHandler.CATMULLROM_FORWARD,false)}function f(a,b){var c,d,e=new THREE.Geometry;for(c=0;c<a.points.length*b;c++){d=c/(a.points.length*b);d=a.getPoint(d);e.vertices[c]=new THREE.Vector3(d.x,d.y,d.z)}return e}this.object=b;this.domElement=a!==void 0?a:document;this.id="PathControls"+THREE.PathControlsIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=true;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;
this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookHorizontal=this.lookVertical=true;this.verticalAngleMap={srcRange:[0,2*Math.PI],dstRange:[0,2*Math.PI]};this.horizontalAngleMap={srcRange:[0,2*Math.PI],dstRange:[0,2*Math.PI]};this.target=new THREE.Object3D;this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;if(this.domElement===document){this.viewHalfX=window.innerWidth/2;this.viewHalfY=window.innerHeight/2}else{this.viewHalfX=this.domElement.offsetWidth/2;this.viewHalfY=
this.domElement.offsetHeight/2;this.domElement.setAttribute("tabindex",-1)}var g=Math.PI*2,h=Math.PI/180;this.update=function(a){var b;if(this.lookHorizontal)this.lon=this.lon+this.mouseX*this.lookSpeed*a;if(this.lookVertical)this.lat=this.lat-this.mouseY*this.lookSpeed*a;this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*h;this.theta=this.lon*h;a=this.phi%g;this.phi=a>=0?a:a+g;b=this.verticalAngleMap.srcRange;a=this.verticalAngleMap.dstRange;
b=THREE.Math.mapLinear(this.phi,b[0],b[1],a[0],a[1]);var d=a[1]-a[0];this.phi=c((b-a[0])/d)*d+a[0];b=this.horizontalAngleMap.srcRange;a=this.horizontalAngleMap.dstRange;b=THREE.Math.mapLinear(this.theta,b[0],b[1],a[0],a[1]);d=a[1]-a[0];this.theta=c((b-a[0])/d)*d+a[0];a=this.target.position;a.x=100*Math.sin(this.phi)*Math.cos(this.theta);a.y=100*Math.cos(this.phi);a.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.object.lookAt(this.target.position)};this.onMouseMove=function(a){if(this.domElement===
document){this.mouseX=a.pageX-this.viewHalfX;this.mouseY=a.pageY-this.viewHalfY}else{this.mouseX=a.pageX-this.domElement.offsetLeft-this.viewHalfX;this.mouseY=a.pageY-this.domElement.offsetTop-this.viewHalfY}};this.init=function(){this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){var a=new THREE.MeshLambertMaterial({color:30719}),b=new THREE.MeshLambertMaterial({color:65280}),
c=new THREE.CubeGeometry(10,10,20),g=new THREE.CubeGeometry(2,2,10);this.animationParent=new THREE.Mesh(c,a);a=new THREE.Mesh(g,b);a.position.set(0,10,0);this.animation=e(this.animationParent,this.spline,this.id,this.duration);this.animationParent.add(this.object);this.animationParent.add(this.target);this.animationParent.add(a)}else{this.animation=e(this.animationParent,this.spline,this.id,this.duration);this.animationParent.add(this.target);this.animationParent.add(this.object)}if(this.createDebugPath){var a=
this.debugPath,b=this.spline,g=f(b,10),c=f(b,10),h=new THREE.LineBasicMaterial({color:16711680,linewidth:3}),g=new THREE.Line(g,h),c=new THREE.ParticleSystem(c,new THREE.ParticleBasicMaterial({color:16755200,size:3}));g.scale.set(1,1,1);a.add(g);c.scale.set(1,1,1);a.add(c);for(var g=new THREE.SphereGeometry(1,16,8),h=new THREE.MeshBasicMaterial({color:65280}),m=0;m<b.points.length;m++){c=new THREE.Mesh(g,h);c.position.copy(b.points[m]);a.add(c)}}this.domElement.addEventListener("mousemove",d(this,
this.onMouseMove),false)}};THREE.PathControlsIdCounter=0;
THREE.FlyControls=function(b,a){function c(a,b){return function(){b.apply(a,arguments)}}this.object=b;this.domElement=a!==void 0?a:document;a&&this.domElement.setAttribute("tabindex",-1);this.movementSpeed=1;this.rollSpeed=0.005;this.autoForward=this.dragToLook=false;this.object.useQuaternion=true;this.tmpQuaternion=new THREE.Quaternion;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=
new THREE.Vector3(0,0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.keydown=function(a){if(!a.altKey){switch(a.keyCode){case 16:this.movementSpeedMultiplier=0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=
1;break;case 40:this.moveState.pitchDown=1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};this.keyup=function(a){switch(a.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=
0;break;case 70:this.moveState.down=0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(a){this.domElement!==document&&this.domElement.focus();a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(a.button){case 0:this.object.moveForward=
true;break;case 2:this.object.moveBackward=true}};this.mousemove=function(a){if(!this.dragToLook||this.mouseStatus>0){var b=this.getContainerDimensions(),c=b.size[0]/2,g=b.size[1]/2;this.moveState.yawLeft=-(a.pageX-b.offset[0]-c)/c;this.moveState.pitchDown=(a.pageY-b.offset[1]-g)/g;this.updateRotationVector()}};this.mouseup=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook){this.mouseStatus--;this.moveState.yawLeft=this.moveState.pitchDown=0}else switch(a.button){case 0:this.moveForward=
false;break;case 2:this.moveBackward=false}this.updateRotationVector()};this.update=function(a){var b=a*this.movementSpeed,a=a*this.rollSpeed;this.object.translateX(this.moveVector.x*b);this.object.translateY(this.moveVector.y*b);this.object.translateZ(this.moveVector.z*b);this.tmpQuaternion.set(this.rotationVector.x*a,this.rotationVector.y*a,this.rotationVector.z*a,1).normalize();this.object.quaternion.multiplySelf(this.tmpQuaternion);this.object.matrix.setPosition(this.object.position);this.object.matrix.setRotationFromQuaternion(this.object.quaternion);
this.object.matrixWorldNeedsUpdate=true};this.updateMovementVector=function(){var a=this.moveState.forward||this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-a+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=
-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",c(this,this.mousemove),false);this.domElement.addEventListener("mousedown",c(this,this.mousedown),false);this.domElement.addEventListener("mouseup",
c(this,this.mouseup),false);this.domElement.addEventListener("keydown",c(this,this.keydown),false);this.domElement.addEventListener("keyup",c(this,this.keyup),false);this.updateMovementVector();this.updateRotationVector()};
THREE.RollControls=function(b,a){this.object=b;this.domElement=a!==void 0?a:document;this.mouseLook=true;this.autoForward=false;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.object.matrixAutoUpdate=false;this.forward=new THREE.Vector3(0,0,1);this.roll=0;var c=new THREE.Vector3,d=new THREE.Vector3,e=new THREE.Vector3,f=new THREE.Matrix4,g=false,h=1,i=0,j=0,l=0,n=0,k=0,m=window.innerWidth/2,o=window.innerHeight/2;this.update=function(a){if(this.mouseLook){var b=
a*this.lookSpeed;this.rotateHorizontally(b*n);this.rotateVertically(b*k)}b=a*this.movementSpeed;this.object.translateZ(-b*(i>0||this.autoForward&&!(i<0)?1:i));this.object.translateX(b*j);this.object.translateY(b*l);if(g)this.roll=this.roll+this.rollSpeed*a*h;if(this.forward.y>this.constrainVertical[1]){this.forward.y=this.constrainVertical[1];this.forward.normalize()}else if(this.forward.y<this.constrainVertical[0]){this.forward.y=this.constrainVertical[0];this.forward.normalize()}e.copy(this.forward);
d.set(0,1,0);c.cross(d,e).normalize();d.cross(e,c).normalize();this.object.matrix.elements[0]=c.x;this.object.matrix.elements[4]=d.x;this.object.matrix.elements[8]=e.x;this.object.matrix.elements[1]=c.y;this.object.matrix.elements[5]=d.y;this.object.matrix.elements[9]=e.y;this.object.matrix.elements[2]=c.z;this.object.matrix.elements[6]=d.z;this.object.matrix.elements[10]=e.z;f.identity();f.elements[0]=Math.cos(this.roll);f.elements[4]=-Math.sin(this.roll);f.elements[1]=Math.sin(this.roll);f.elements[5]=
Math.cos(this.roll);this.object.matrix.multiplySelf(f);this.object.matrixWorldNeedsUpdate=true;this.object.matrix.elements[12]=this.object.position.x;this.object.matrix.elements[13]=this.object.position.y;this.object.matrix.elements[14]=this.object.position.z};this.translateX=function(a){this.object.position.x=this.object.position.x+this.object.matrix.elements[0]*a;this.object.position.y=this.object.position.y+this.object.matrix.elements[1]*a;this.object.position.z=this.object.position.z+this.object.matrix.elements[2]*
a};this.translateY=function(a){this.object.position.x=this.object.position.x+this.object.matrix.elements[4]*a;this.object.position.y=this.object.position.y+this.object.matrix.elements[5]*a;this.object.position.z=this.object.position.z+this.object.matrix.elements[6]*a};this.translateZ=function(a){this.object.position.x=this.object.position.x-this.object.matrix.elements[8]*a;this.object.position.y=this.object.position.y-this.object.matrix.elements[9]*a;this.object.position.z=this.object.position.z-
this.object.matrix.elements[10]*a};this.rotateHorizontally=function(a){c.set(this.object.matrix.elements[0],this.object.matrix.elements[1],this.object.matrix.elements[2]);c.multiplyScalar(a);this.forward.subSelf(c);this.forward.normalize()};this.rotateVertically=function(a){d.set(this.object.matrix.elements[4],this.object.matrix.elements[5],this.object.matrix.elements[6]);d.multiplyScalar(a);this.forward.addSelf(d);this.forward.normalize()};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},
false);this.domElement.addEventListener("mousemove",function(a){n=(a.clientX-m)/window.innerWidth;k=(a.clientY-o)/window.innerHeight},false);this.domElement.addEventListener("mousedown",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:i=1;break;case 2:i=-1}},false);this.domElement.addEventListener("mouseup",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:i=0;break;case 2:i=0}},false);this.domElement.addEventListener("keydown",function(a){switch(a.keyCode){case 38:case 87:i=
1;break;case 37:case 65:j=-1;break;case 40:case 83:i=-1;break;case 39:case 68:j=1;break;case 81:g=true;h=1;break;case 69:g=true;h=-1;break;case 82:l=1;break;case 70:l=-1}},false);this.domElement.addEventListener("keyup",function(a){switch(a.keyCode){case 38:case 87:i=0;break;case 37:case 65:j=0;break;case 40:case 83:i=0;break;case 39:case 68:j=0;break;case 81:g=false;break;case 69:g=false;break;case 82:l=0;break;case 70:l=0}},false)};
THREE.TrackballControls=function(b,a){THREE.EventTarget.call(this);var c=this;this.object=b;this.domElement=a!==void 0?a:document;this.enabled=true;this.screen={width:window.innerWidth,height:window.innerHeight,offsetLeft:0,offsetTop:0};this.radius=(this.screen.width+this.screen.height)/4;this.rotateSpeed=1;this.zoomSpeed=1.2;this.panSpeed=0.3;this.staticMoving=this.noPan=this.noZoom=this.noRotate=false;this.dynamicDampingFactor=0.2;this.minDistance=0;this.maxDistance=Infinity;this.keys=[65,83,68];
this.target=new THREE.Vector3;var d=new THREE.Vector3,e=false,f=-1,g=new THREE.Vector3,h=new THREE.Vector3,i=new THREE.Vector3,j=new THREE.Vector2,l=new THREE.Vector2,n=new THREE.Vector2,k=new THREE.Vector2,m={type:"change"};this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.getMouseOnScreen=function(a,b){return new THREE.Vector2((a-c.screen.offsetLeft)/c.radius*0.5,(b-c.screen.offsetTop)/c.radius*0.5)};this.getMouseProjectionOnBall=function(a,b){var d=new THREE.Vector3((a-
c.screen.width*0.5-c.screen.offsetLeft)/c.radius,(c.screen.height*0.5+c.screen.offsetTop-b)/c.radius,0),e=d.length();e>1?d.normalize():d.z=Math.sqrt(1-e*e);g.copy(c.object.position).subSelf(c.target);e=c.object.up.clone().setLength(d.y);e.addSelf(c.object.up.clone().crossSelf(g).setLength(d.x));e.addSelf(g.setLength(d.z));return e};this.rotateCamera=function(){var a=Math.acos(h.dot(i)/h.length()/i.length());if(a){var b=(new THREE.Vector3).cross(h,i).normalize(),d=new THREE.Quaternion,a=a*c.rotateSpeed;
d.setFromAxisAngle(b,-a);d.multiplyVector3(g);d.multiplyVector3(c.object.up);d.multiplyVector3(i);if(c.staticMoving)h=i;else{d.setFromAxisAngle(b,a*(c.dynamicDampingFactor-1));d.multiplyVector3(h)}}};this.zoomCamera=function(){var a=1+(l.y-j.y)*c.zoomSpeed;if(a!==1&&a>0){g.multiplyScalar(a);c.staticMoving?j=l:j.y=j.y+(l.y-j.y)*this.dynamicDampingFactor}};this.panCamera=function(){var a=k.clone().subSelf(n);if(a.lengthSq()){a.multiplyScalar(g.length()*c.panSpeed);var b=g.clone().crossSelf(c.object.up).setLength(a.x);
b.addSelf(c.object.up.clone().setLength(a.y));c.object.position.addSelf(b);c.target.addSelf(b);c.staticMoving?n=k:n.addSelf(a.sub(k,n).multiplyScalar(c.dynamicDampingFactor))}};this.checkDistances=function(){if(!c.noZoom||!c.noPan){c.object.position.lengthSq()>c.maxDistance*c.maxDistance&&c.object.position.setLength(c.maxDistance);g.lengthSq()<c.minDistance*c.minDistance&&c.object.position.add(c.target,g.setLength(c.minDistance))}};this.update=function(){g.copy(c.object.position).subSelf(c.target);
c.noRotate||c.rotateCamera();c.noZoom||c.zoomCamera();c.noPan||c.panCamera();c.object.position.add(c.target,g);c.checkDistances();c.object.lookAt(c.target);if(d.distanceTo(c.object.position)>0){c.dispatchEvent(m);d.copy(c.object.position)}};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},false);this.domElement.addEventListener("mousemove",function(a){if(c.enabled){if(e){h=i=c.getMouseProjectionOnBall(a.clientX,a.clientY);j=l=c.getMouseOnScreen(a.clientX,a.clientY);n=
k=c.getMouseOnScreen(a.clientX,a.clientY);e=false}f!==-1&&(f===0&&!c.noRotate?i=c.getMouseProjectionOnBall(a.clientX,a.clientY):f===1&&!c.noZoom?l=c.getMouseOnScreen(a.clientX,a.clientY):f===2&&!c.noPan&&(k=c.getMouseOnScreen(a.clientX,a.clientY)))}},false);this.domElement.addEventListener("mousedown",function(a){if(c.enabled){a.preventDefault();a.stopPropagation();if(f===-1){f=a.button;f===0&&!c.noRotate?h=i=c.getMouseProjectionOnBall(a.clientX,a.clientY):f===1&&!c.noZoom?j=l=c.getMouseOnScreen(a.clientX,
a.clientY):this.noPan||(n=k=c.getMouseOnScreen(a.clientX,a.clientY))}}},false);this.domElement.addEventListener("mouseup",function(a){if(c.enabled){a.preventDefault();a.stopPropagation();f=-1}},false);window.addEventListener("keydown",function(a){if(c.enabled&&f===-1){a.keyCode===c.keys[0]&&!c.noRotate?f=0:a.keyCode===c.keys[1]&&!c.noZoom?f=1:a.keyCode===c.keys[2]&&!c.noPan&&(f=2);f!==-1&&(e=true)}},false);window.addEventListener("keyup",function(){c.enabled&&f!==-1&&(f=-1)},false)};
THREE.CubeGeometry=function(b,a,c,d,e,f,g,h){function i(a,b,c,g,h,i,k,l){var m,n=d||1,o=e||1,q=h/2,r=i/2,s=j.vertices.length;if(a==="x"&&b==="y"||a==="y"&&b==="x")m="z";else if(a==="x"&&b==="z"||a==="z"&&b==="x"){m="y";o=f||1}else if(a==="z"&&b==="y"||a==="y"&&b==="z"){m="x";n=f||1}var t=n+1,v=o+1,L=h/n,J=i/o,M=new THREE.Vector3;M[m]=k>0?1:-1;for(h=0;h<v;h++)for(i=0;i<t;i++){var y=new THREE.Vector3;y[a]=(i*L-q)*c;y[b]=(h*J-r)*g;y[m]=k;j.vertices.push(y)}for(h=0;h<o;h++)for(i=0;i<n;i++){a=new THREE.Face4(i+
t*h+s,i+t*(h+1)+s,i+1+t*(h+1)+s,i+1+t*h+s);a.normal.copy(M);a.vertexNormals.push(M.clone(),M.clone(),M.clone(),M.clone());a.materialIndex=l;j.faces.push(a);j.faceVertexUvs[0].push([new THREE.UV(i/n,h/o),new THREE.UV(i/n,(h+1)/o),new THREE.UV((i+1)/n,(h+1)/o),new THREE.UV((i+1)/n,h/o)])}}THREE.Geometry.call(this);var j=this,l=b/2,n=a/2,k=c/2,m,o,q,r,s,t;if(g!==void 0){if(g instanceof Array)this.materials=g;else{this.materials=[];for(m=0;m<6;m++)this.materials.push(g)}m=0;r=1;o=2;s=3;q=4;t=5}else this.materials=
[];this.sides={px:true,nx:true,py:true,ny:true,pz:true,nz:true};if(h!=void 0)for(var v in h)this.sides[v]!==void 0&&(this.sides[v]=h[v]);this.sides.px&&i("z","y",-1,-1,c,a,l,m);this.sides.nx&&i("z","y",1,-1,c,a,-l,r);this.sides.py&&i("x","z",1,1,b,c,n,o);this.sides.ny&&i("x","z",1,-1,b,c,-n,s);this.sides.pz&&i("x","y",1,-1,b,a,k,q);this.sides.nz&&i("x","y",-1,-1,b,a,-k,t);this.computeCentroids();this.mergeVertices()};THREE.CubeGeometry.prototype=new THREE.Geometry;
THREE.CubeGeometry.prototype.constructor=THREE.CubeGeometry;
THREE.CylinderGeometry=function(b,a,c,d,e,f){THREE.Geometry.call(this);var b=b!==void 0?b:20,a=a!==void 0?a:20,c=c!==void 0?c:100,g=c/2,d=d||8,e=e||1,h,i,j=[],l=[];for(i=0;i<=e;i++){var n=[],k=[],m=i/e,o=m*(a-b)+b;for(h=0;h<=d;h++){var q=h/d,r=new THREE.Vector3;r.x=o*Math.sin(q*Math.PI*2);r.y=-m*c+g;r.z=o*Math.cos(q*Math.PI*2);this.vertices.push(r);n.push(this.vertices.length-1);k.push(new THREE.UV(q,m))}j.push(n);l.push(k)}c=(a-b)/c;for(h=0;h<d;h++){if(b!==0){n=this.vertices[j[0][h]].clone();k=this.vertices[j[0][h+
1]].clone()}else{n=this.vertices[j[1][h]].clone();k=this.vertices[j[1][h+1]].clone()}n.setY(Math.sqrt(n.x*n.x+n.z*n.z)*c).normalize();k.setY(Math.sqrt(k.x*k.x+k.z*k.z)*c).normalize();for(i=0;i<e;i++){var m=j[i][h],o=j[i+1][h],q=j[i+1][h+1],r=j[i][h+1],s=n.clone(),t=n.clone(),v=k.clone(),p=k.clone(),x=l[i][h].clone(),A=l[i+1][h].clone(),z=l[i+1][h+1].clone(),u=l[i][h+1].clone();this.faces.push(new THREE.Face4(m,o,q,r,[s,t,v,p]));this.faceVertexUvs[0].push([x,A,z,u])}}if(!f&&b>0){this.vertices.push(new THREE.Vector3(0,
g,0));for(h=0;h<d;h++){m=j[0][h];o=j[0][h+1];q=this.vertices.length-1;s=new THREE.Vector3(0,1,0);t=new THREE.Vector3(0,1,0);v=new THREE.Vector3(0,1,0);x=l[0][h].clone();A=l[0][h+1].clone();z=new THREE.UV(A.u,0);this.faces.push(new THREE.Face3(m,o,q,[s,t,v]));this.faceVertexUvs[0].push([x,A,z])}}if(!f&&a>0){this.vertices.push(new THREE.Vector3(0,-g,0));for(h=0;h<d;h++){m=j[i][h+1];o=j[i][h];q=this.vertices.length-1;s=new THREE.Vector3(0,-1,0);t=new THREE.Vector3(0,-1,0);v=new THREE.Vector3(0,-1,0);
x=l[i][h+1].clone();A=l[i][h].clone();z=new THREE.UV(A.u,1);this.faces.push(new THREE.Face3(m,o,q,[s,t,v]));this.faceVertexUvs[0].push([x,A,z])}}this.computeCentroids();this.computeFaceNormals()};THREE.CylinderGeometry.prototype=new THREE.Geometry;THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;
THREE.ExtrudeGeometry=function(b,a){if(typeof b!=="undefined"){THREE.Geometry.call(this);b=b instanceof Array?b:[b];this.shapebb=b[b.length-1].getBoundingBox();this.addShapeList(b,a);this.computeCentroids();this.computeFaceNormals()}};THREE.ExtrudeGeometry.prototype=new THREE.Geometry;THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry;THREE.ExtrudeGeometry.prototype.addShapeList=function(b,a){for(var c=b.length,d=0;d<c;d++)this.addShape(b[d],a)};
THREE.ExtrudeGeometry.prototype.addShape=function(b,a){function c(a,b,c){b||console.log("die");return b.clone().multiplyScalar(c).addSelf(a)}function d(a,b,c){var d=THREE.ExtrudeGeometry.__v1,e=THREE.ExtrudeGeometry.__v2,f=THREE.ExtrudeGeometry.__v3,g=THREE.ExtrudeGeometry.__v4,h=THREE.ExtrudeGeometry.__v5,i=THREE.ExtrudeGeometry.__v6;d.set(a.x-b.x,a.y-b.y);e.set(a.x-c.x,a.y-c.y);d=d.normalize();e=e.normalize();f.set(-d.y,d.x);g.set(e.y,-e.x);h.copy(a).addSelf(f);i.copy(a).addSelf(g);if(h.equals(i))return g.clone();
h.copy(b).addSelf(f);i.copy(c).addSelf(g);f=d.dot(g);g=i.subSelf(h).dot(g);if(f===0){console.log("Either infinite or no solutions!");g===0?console.log("Its finite solutions."):console.log("Too bad, no solutions.")}g=g/f;if(g<0){b=Math.atan2(b.y-a.y,b.x-a.x);a=Math.atan2(c.y-a.y,c.x-a.x);b>a&&(a=a+Math.PI*2);c=(b+a)/2;a=-Math.cos(c);c=-Math.sin(c);a=new THREE.Vector2(a,c)}else a=d.multiplyScalar(g).addSelf(h).subSelf(a).clone();return a}function e(c,d){var e,f;for(y=c.length;--y>=0;){e=y;f=y-1;f<0&&
(f=c.length-1);for(var g=0,h=k+l*2,g=0;g<h;g++){var i=L*g,j=L*(g+1),m=d+e+i,i=d+f+i,n=d+f+j,j=d+e+j,o=c,q=g,p=h,m=m+C,i=i+C,n=n+C,j=j+C;F.faces.push(new THREE.Face4(m,i,n,j,null,null,t));m=Q.generateSideWallUV(F,b,o,a,m,i,n,j,q,p);F.faceVertexUvs[0].push(m)}}}function f(a,b,c){F.vertices.push(new THREE.Vector3(a,b,c))}function g(c,d,e,f){c=c+C;d=d+C;e=e+C;F.faces.push(new THREE.Face3(c,d,e,null,null,s));c=f?Q.generateBottomUV(F,b,a,c,d,e):Q.generateTopUV(F,b,a,c,d,e);F.faceVertexUvs[0].push(c)}var h=
a.amount!==void 0?a.amount:100,i=a.bevelThickness!==void 0?a.bevelThickness:6,j=a.bevelSize!==void 0?a.bevelSize:i-2,l=a.bevelSegments!==void 0?a.bevelSegments:3,n=a.bevelEnabled!==void 0?a.bevelEnabled:true,k=a.steps!==void 0?a.steps:1,m=a.bendPath,o=a.extrudePath,q,r=false,s=a.material,t=a.extrudeMaterial,v,p,x,A;if(o){q=o.getSpacedPoints(k);r=true;n=false;v=new THREE.TubeGeometry.FrenetFrames(o,k,false);p=new THREE.Vector3;x=new THREE.Vector3;A=new THREE.Vector3}if(!n)j=i=l=0;var z,u,w,F=this,
C=this.vertices.length;m&&b.addWrapPath(m);var o=b.extractPoints(),m=o.shape,B=o.holes;if(o=!THREE.Shape.Utils.isClockWise(m)){m=m.reverse();u=0;for(w=B.length;u<w;u++){z=B[u];THREE.Shape.Utils.isClockWise(z)&&(B[u]=z.reverse())}o=false}var I=THREE.Shape.Utils.triangulateShape(m,B),K=m;u=0;for(w=B.length;u<w;u++){z=B[u];m=m.concat(z)}var E,D,G,N,H,L=m.length,J,M=I.length,o=[],y=0;G=K.length;E=G-1;for(D=y+1;y<G;y++,E++,D++){E===G&&(E=0);D===G&&(D=0);o[y]=d(K[y],K[E],K[D])}var R=[],O,P=o.concat();u=
0;for(w=B.length;u<w;u++){z=B[u];O=[];y=0;G=z.length;E=G-1;for(D=y+1;y<G;y++,E++,D++){E===G&&(E=0);D===G&&(D=0);O[y]=d(z[y],z[E],z[D])}R.push(O);P=P.concat(O)}for(E=0;E<l;E++){G=E/l;N=i*(1-G);D=j*Math.sin(G*Math.PI/2);y=0;for(G=K.length;y<G;y++){H=c(K[y],o[y],D);f(H.x,H.y,-N)}u=0;for(w=B.length;u<w;u++){z=B[u];O=R[u];y=0;for(G=z.length;y<G;y++){H=c(z[y],O[y],D);f(H.x,H.y,-N)}}}D=j;for(y=0;y<L;y++){H=n?c(m[y],P[y],D):m[y];if(r){x.copy(v.normals[0]).multiplyScalar(H.x);p.copy(v.binormals[0]).multiplyScalar(H.y);
A.copy(q[0]).addSelf(x).addSelf(p);f(A.x,A.y,A.z)}else f(H.x,H.y,0)}for(G=1;G<=k;G++)for(y=0;y<L;y++){H=n?c(m[y],P[y],D):m[y];if(r){x.copy(v.normals[G]).multiplyScalar(H.x);p.copy(v.binormals[G]).multiplyScalar(H.y);A.copy(q[G]).addSelf(x).addSelf(p);f(A.x,A.y,A.z)}else f(H.x,H.y,h/k*G)}for(E=l-1;E>=0;E--){G=E/l;N=i*(1-G);D=j*Math.sin(G*Math.PI/2);y=0;for(G=K.length;y<G;y++){H=c(K[y],o[y],D);f(H.x,H.y,h+N)}u=0;for(w=B.length;u<w;u++){z=B[u];O=R[u];y=0;for(G=z.length;y<G;y++){H=c(z[y],O[y],D);r?f(H.x,
H.y+q[k-1].y,q[k-1].x+N):f(H.x,H.y,h+N)}}}var Q=THREE.ExtrudeGeometry.WorldUVGenerator;(function(){if(n){var a;a=L*0;for(y=0;y<M;y++){J=I[y];g(J[2]+a,J[1]+a,J[0]+a,true)}a=k+l*2;a=L*a;for(y=0;y<M;y++){J=I[y];g(J[0]+a,J[1]+a,J[2]+a,false)}}else{for(y=0;y<M;y++){J=I[y];g(J[2],J[1],J[0],true)}for(y=0;y<M;y++){J=I[y];g(J[0]+L*k,J[1]+L*k,J[2]+L*k,false)}}})();(function(){var a=0;e(K,a);a=a+K.length;u=0;for(w=B.length;u<w;u++){z=B[u];e(z,a);a=a+z.length}})()};
THREE.ExtrudeGeometry.WorldUVGenerator={generateTopUV:function(b,a,c,d,e,f){a=b.vertices[e].x;e=b.vertices[e].y;c=b.vertices[f].x;f=b.vertices[f].y;return[new THREE.UV(b.vertices[d].x,1-b.vertices[d].y),new THREE.UV(a,1-e),new THREE.UV(c,1-f)]},generateBottomUV:function(b,a,c,d,e,f){return this.generateTopUV(b,a,c,d,e,f)},generateSideWallUV:function(b,a,c,d,e,f,g,h){var a=b.vertices[e].x,c=b.vertices[e].y,e=b.vertices[e].z,d=b.vertices[f].x,i=b.vertices[f].y,f=b.vertices[f].z,j=b.vertices[g].x,l=
b.vertices[g].y,g=b.vertices[g].z,n=b.vertices[h].x,k=b.vertices[h].y,b=b.vertices[h].z;return Math.abs(c-i)<0.01?[new THREE.UV(a,e),new THREE.UV(d,f),new THREE.UV(j,g),new THREE.UV(n,b)]:[new THREE.UV(c,e),new THREE.UV(i,f),new THREE.UV(l,g),new THREE.UV(k,b)]}};THREE.ExtrudeGeometry.__v1=new THREE.Vector2;THREE.ExtrudeGeometry.__v2=new THREE.Vector2;THREE.ExtrudeGeometry.__v3=new THREE.Vector2;THREE.ExtrudeGeometry.__v4=new THREE.Vector2;THREE.ExtrudeGeometry.__v5=new THREE.Vector2;
THREE.ExtrudeGeometry.__v6=new THREE.Vector2;
THREE.LatheGeometry=function(b,a,c){THREE.Geometry.call(this);for(var a=a||12,c=c||2*Math.PI,d=[],e=(new THREE.Matrix4).makeRotationZ(c/a),f=0;f<b.length;f++){d[f]=b[f].clone();this.vertices.push(d[f])}for(var g=a+1,c=0;c<g;c++)for(f=0;f<d.length;f++){d[f]=e.multiplyVector3(d[f].clone());this.vertices.push(d[f])}for(c=0;c<a;c++){d=0;for(e=b.length;d<e-1;d++){this.faces.push(new THREE.Face4(c*e+d,(c+1)%g*e+d,(c+1)%g*e+(d+1)%e,c*e+(d+1)%e));this.faceVertexUvs[0].push([new THREE.UV(1-c/a,d/e),new THREE.UV(1-
(c+1)/a,d/e),new THREE.UV(1-(c+1)/a,(d+1)/e),new THREE.UV(1-c/a,(d+1)/e)])}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.LatheGeometry.prototype=new THREE.Geometry;THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;
THREE.PlaneGeometry=function(b,a,c,d){THREE.Geometry.call(this);for(var e=b/2,f=a/2,c=c||1,d=d||1,g=c+1,h=d+1,i=b/c,j=a/d,l=new THREE.Vector3(0,1,0),b=0;b<h;b++)for(a=0;a<g;a++)this.vertices.push(new THREE.Vector3(a*i-e,0,b*j-f));for(b=0;b<d;b++)for(a=0;a<c;a++){e=new THREE.Face4(a+g*b,a+g*(b+1),a+1+g*(b+1),a+1+g*b);e.normal.copy(l);e.vertexNormals.push(l.clone(),l.clone(),l.clone(),l.clone());this.faces.push(e);this.faceVertexUvs[0].push([new THREE.UV(a/c,b/d),new THREE.UV(a/c,(b+1)/d),new THREE.UV((a+
1)/c,(b+1)/d),new THREE.UV((a+1)/c,b/d)])}this.computeCentroids()};THREE.PlaneGeometry.prototype=new THREE.Geometry;THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;
THREE.SphereGeometry=function(b,a,c,d,e,f,g){THREE.Geometry.call(this);var b=b||50,d=d!==void 0?d:0,e=e!==void 0?e:Math.PI*2,f=f!==void 0?f:0,g=g!==void 0?g:Math.PI,a=Math.max(3,Math.floor(a)||8),c=Math.max(2,Math.floor(c)||6),h,i,j=[],l=[];for(i=0;i<=c;i++){var n=[],k=[];for(h=0;h<=a;h++){var m=h/a,o=i/c,q=new THREE.Vector3;q.x=-b*Math.cos(d+m*e)*Math.sin(f+o*g);q.y=b*Math.cos(f+o*g);q.z=b*Math.sin(d+m*e)*Math.sin(f+o*g);this.vertices.push(q);n.push(this.vertices.length-1);k.push(new THREE.UV(m,
o))}j.push(n);l.push(k)}for(i=0;i<c;i++)for(h=0;h<a;h++){var d=j[i][h+1],e=j[i][h],f=j[i+1][h],g=j[i+1][h+1],n=this.vertices[d].clone().normalize(),k=this.vertices[e].clone().normalize(),m=this.vertices[f].clone().normalize(),o=this.vertices[g].clone().normalize(),q=l[i][h+1].clone(),r=l[i][h].clone(),s=l[i+1][h].clone(),t=l[i+1][h+1].clone();if(Math.abs(this.vertices[d].y)==b){this.faces.push(new THREE.Face3(d,f,g,[n,m,o]));this.faceVertexUvs[0].push([q,s,t])}else if(Math.abs(this.vertices[f].y)==
b){this.faces.push(new THREE.Face3(d,e,f,[n,k,m]));this.faceVertexUvs[0].push([q,r,s])}else{this.faces.push(new THREE.Face4(d,e,f,g,[n,k,m,o]));this.faceVertexUvs[0].push([q,r,s,t])}}this.computeCentroids();this.computeFaceNormals();this.boundingSphere={radius:b}};THREE.SphereGeometry.prototype=new THREE.Geometry;THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;
THREE.TextGeometry=function(b,a){var c=(new THREE.TextPath(b,a)).toShapes();a.amount=a.height!==void 0?a.height:50;if(a.bevelThickness===void 0)a.bevelThickness=10;if(a.bevelSize===void 0)a.bevelSize=8;if(a.bevelEnabled===void 0)a.bevelEnabled=false;if(a.bend){var d=c[c.length-1].getBoundingBox().maxX;a.bendPath=new THREE.QuadraticBezierCurve(new THREE.Vector2(0,0),new THREE.Vector2(d/2,120),new THREE.Vector2(d,0))}THREE.ExtrudeGeometry.call(this,c,a)};THREE.TextGeometry.prototype=new THREE.ExtrudeGeometry;
THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;
THREE.FontUtils={faces:{},face:"helvetiker",weight:"normal",style:"normal",size:150,divisions:10,getFace:function(){return this.faces[this.face][this.weight][this.style]},loadFace:function(b){var a=b.familyName.toLowerCase();this.faces[a]=this.faces[a]||{};this.faces[a][b.cssFontWeight]=this.faces[a][b.cssFontWeight]||{};this.faces[a][b.cssFontWeight][b.cssFontStyle]=b;return this.faces[a][b.cssFontWeight][b.cssFontStyle]=b},drawText:function(b){for(var a=this.getFace(),c=this.size/a.resolution,d=
0,e=(""+b).split(""),f=e.length,g=[],b=0;b<f;b++){var h=new THREE.Path,h=this.extractGlyphPoints(e[b],a,c,d,h),d=d+h.offset;g.push(h.path)}return{paths:g,offset:d/2}},extractGlyphPoints:function(b,a,c,d,e){var f=[],g,h,i,j,l,n,k,m,o,q,r,s=a.glyphs[b]||a.glyphs["?"];if(s){if(s.o){a=s._cachedOutline||(s._cachedOutline=s.o.split(" "));j=a.length;for(b=0;b<j;){i=a[b++];switch(i){case "m":i=a[b++]*c+d;l=a[b++]*c;f.push(new THREE.Vector2(i,l));e.moveTo(i,l);break;case "l":i=a[b++]*c+d;l=a[b++]*c;f.push(new THREE.Vector2(i,
l));e.lineTo(i,l);break;case "q":i=a[b++]*c+d;l=a[b++]*c;m=a[b++]*c+d;o=a[b++]*c;e.quadraticCurveTo(m,o,i,l);if(g=f[f.length-1]){n=g.x;k=g.y;g=1;for(h=this.divisions;g<=h;g++){var t=g/h,v=THREE.Shape.Utils.b2(t,n,m,i),t=THREE.Shape.Utils.b2(t,k,o,l);f.push(new THREE.Vector2(v,t))}}break;case "b":i=a[b++]*c+d;l=a[b++]*c;m=a[b++]*c+d;o=a[b++]*-c;q=a[b++]*c+d;r=a[b++]*-c;e.bezierCurveTo(i,l,m,o,q,r);if(g=f[f.length-1]){n=g.x;k=g.y;g=1;for(h=this.divisions;g<=h;g++){t=g/h;v=THREE.Shape.Utils.b3(t,n,m,
q,i);t=THREE.Shape.Utils.b3(t,k,o,r,l);f.push(new THREE.Vector2(v,t))}}}}}return{offset:s.ha*c,points:f,path:e}}}};
(function(b){var a=function(a){for(var b=a.length,e=0,f=b-1,g=0;g<b;f=g++)e=e+(a[f].x*a[g].y-a[g].x*a[f].y);return e*0.5};b.Triangulate=function(b,d){var e=b.length;if(e<3)return null;var f=[],g=[],h=[],i,j,l;if(a(b)>0)for(j=0;j<e;j++)g[j]=j;else for(j=0;j<e;j++)g[j]=e-1-j;var n=2*e;for(j=e-1;e>2;){if(n--<=0){console.log("Warning, unable to triangulate polygon!");break}i=j;e<=i&&(i=0);j=i+1;e<=j&&(j=0);l=j+1;e<=l&&(l=0);var k;a:{k=b;var m=i,o=j,q=l,r=e,s=g,t=void 0,v=void 0,p=void 0,x=void 0,A=void 0,
z=void 0,u=void 0,w=void 0,F=void 0,v=k[s[m]].x,p=k[s[m]].y,x=k[s[o]].x,A=k[s[o]].y,z=k[s[q]].x,u=k[s[q]].y;if(1.0E-10>(x-v)*(u-p)-(A-p)*(z-v))k=false;else{for(t=0;t<r;t++)if(!(t==m||t==o||t==q)){var w=k[s[t]].x,F=k[s[t]].y,C=void 0,B=void 0,I=void 0,K=void 0,E=void 0,D=void 0,G=void 0,N=void 0,H=void 0,L=void 0,J=void 0,M=void 0,C=I=E=void 0,C=z-x,B=u-A,I=v-z,K=p-u,E=x-v,D=A-p,G=w-v,N=F-p,H=w-x,L=F-A,J=w-z,M=F-u,C=C*L-B*H,E=E*N-D*G,I=I*M-K*J;if(C>=0&&I>=0&&E>=0){k=false;break a}}k=true}}if(k){f.push([b[g[i]],
b[g[j]],b[g[l]]]);h.push([g[i],g[j],g[l]]);i=j;for(l=j+1;l<e;i++,l++)g[i]=g[l];e--;n=2*e}}return d?h:f};b.Triangulate.area=a;return b})(THREE.FontUtils);self._typeface_js={faces:THREE.FontUtils.faces,loadFace:THREE.FontUtils.loadFace};
THREE.TorusGeometry=function(b,a,c,d,e){THREE.Geometry.call(this);this.radius=b||100;this.tube=a||40;this.segmentsR=c||8;this.segmentsT=d||6;this.arc=e||Math.PI*2;e=new THREE.Vector3;b=[];a=[];for(c=0;c<=this.segmentsR;c++)for(d=0;d<=this.segmentsT;d++){var f=d/this.segmentsT*this.arc,g=c/this.segmentsR*Math.PI*2;e.x=this.radius*Math.cos(f);e.y=this.radius*Math.sin(f);var h=new THREE.Vector3;h.x=(this.radius+this.tube*Math.cos(g))*Math.cos(f);h.y=(this.radius+this.tube*Math.cos(g))*Math.sin(f);h.z=
this.tube*Math.sin(g);this.vertices.push(h);b.push(new THREE.UV(d/this.segmentsT,1-c/this.segmentsR));a.push(h.clone().subSelf(e).normalize())}for(c=1;c<=this.segmentsR;c++)for(d=1;d<=this.segmentsT;d++){var e=(this.segmentsT+1)*c+d-1,f=(this.segmentsT+1)*(c-1)+d-1,g=(this.segmentsT+1)*(c-1)+d,h=(this.segmentsT+1)*c+d,i=new THREE.Face4(e,f,g,h,[a[e],a[f],a[g],a[h]]);i.normal.addSelf(a[e]);i.normal.addSelf(a[f]);i.normal.addSelf(a[g]);i.normal.addSelf(a[h]);i.normal.normalize();this.faces.push(i);
this.faceVertexUvs[0].push([b[e].clone(),b[f].clone(),b[g].clone(),b[h].clone()])}this.computeCentroids()};THREE.TorusGeometry.prototype=new THREE.Geometry;THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;
THREE.TorusKnotGeometry=function(b,a,c,d,e,f,g){function h(a,b,c,d,e,f){var g=Math.cos(a);Math.cos(b);b=Math.sin(a);a=c/d*a;c=Math.cos(a);g=e*(2+c)*0.5*g;b=e*(2+c)*b*0.5;e=f*e*Math.sin(a)*0.5;return new THREE.Vector3(g,b,e)}THREE.Geometry.call(this);this.radius=b||200;this.tube=a||40;this.segmentsR=c||64;this.segmentsT=d||8;this.p=e||2;this.q=f||3;this.heightScale=g||1;this.grid=Array(this.segmentsR);c=new THREE.Vector3;d=new THREE.Vector3;e=new THREE.Vector3;for(b=0;b<this.segmentsR;++b){this.grid[b]=
Array(this.segmentsT);for(a=0;a<this.segmentsT;++a){var i=b/this.segmentsR*2*this.p*Math.PI,g=a/this.segmentsT*2*Math.PI,f=h(i,g,this.q,this.p,this.radius,this.heightScale),i=h(i+0.01,g,this.q,this.p,this.radius,this.heightScale);c.sub(i,f);d.add(i,f);e.cross(c,d);d.cross(e,c);e.normalize();d.normalize();i=-this.tube*Math.cos(g);g=this.tube*Math.sin(g);f.x=f.x+(i*d.x+g*e.x);f.y=f.y+(i*d.y+g*e.y);f.z=f.z+(i*d.z+g*e.z);this.grid[b][a]=this.vertices.push(new THREE.Vector3(f.x,f.y,f.z))-1}}for(b=0;b<
this.segmentsR;++b)for(a=0;a<this.segmentsT;++a){var e=(b+1)%this.segmentsR,f=(a+1)%this.segmentsT,c=this.grid[b][a],d=this.grid[e][a],e=this.grid[e][f],f=this.grid[b][f],g=new THREE.UV(b/this.segmentsR,a/this.segmentsT),i=new THREE.UV((b+1)/this.segmentsR,a/this.segmentsT),j=new THREE.UV((b+1)/this.segmentsR,(a+1)/this.segmentsT),l=new THREE.UV(b/this.segmentsR,(a+1)/this.segmentsT);this.faces.push(new THREE.Face4(c,d,e,f));this.faceVertexUvs[0].push([g,i,j,l])}this.computeCentroids();this.computeFaceNormals();
this.computeVertexNormals()};THREE.TorusKnotGeometry.prototype=new THREE.Geometry;THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;
THREE.TubeGeometry=function(b,a,c,d,e,f){THREE.Geometry.call(this);this.path=b;this.segments=a||64;this.radius=c||1;this.segmentsRadius=d||8;this.closed=e||false;if(f)this.debug=new THREE.Object3D;this.grid=[];var g,h,f=this.segments+1,i,j,l,n=new THREE.Vector3,k,m,o,a=new THREE.TubeGeometry.FrenetFrames(b,a,e);k=a.tangents;m=a.normals;o=a.binormals;this.tangents=k;this.normals=m;this.binormals=o;for(a=0;a<f;a++){this.grid[a]=[];d=a/(f-1);l=b.getPointAt(d);d=k[a];g=m[a];h=o[a];if(this.debug){this.debug.add(new THREE.ArrowHelper(d,
l,c,255));this.debug.add(new THREE.ArrowHelper(g,l,c,16711680));this.debug.add(new THREE.ArrowHelper(h,l,c,65280))}for(d=0;d<this.segmentsRadius;d++){i=d/this.segmentsRadius*2*Math.PI;j=-this.radius*Math.cos(i);i=this.radius*Math.sin(i);n.copy(l);n.x=n.x+(j*g.x+i*h.x);n.y=n.y+(j*g.y+i*h.y);n.z=n.z+(j*g.z+i*h.z);this.grid[a][d]=this.vertices.push(new THREE.Vector3(n.x,n.y,n.z))-1}}for(a=0;a<this.segments;a++)for(d=0;d<this.segmentsRadius;d++){f=e?(a+1)%this.segments:a+1;n=(d+1)%this.segmentsRadius;
b=this.grid[a][d];c=this.grid[f][d];f=this.grid[f][n];n=this.grid[a][n];k=new THREE.UV(a/this.segments,d/this.segmentsRadius);m=new THREE.UV((a+1)/this.segments,d/this.segmentsRadius);o=new THREE.UV((a+1)/this.segments,(d+1)/this.segmentsRadius);g=new THREE.UV(a/this.segments,(d+1)/this.segmentsRadius);this.faces.push(new THREE.Face4(b,c,f,n));this.faceVertexUvs[0].push([k,m,o,g])}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.TubeGeometry.prototype=new THREE.Geometry;
THREE.TubeGeometry.prototype.constructor=THREE.TubeGeometry;
THREE.TubeGeometry.FrenetFrames=function(b,a,c){new THREE.Vector3;var d=new THREE.Vector3;new THREE.Vector3;var e=[],f=[],g=[],h=new THREE.Vector3,i=new THREE.Matrix4,a=a+1,j,l,n;this.tangents=e;this.normals=f;this.binormals=g;for(j=0;j<a;j++){l=j/(a-1);e[j]=b.getTangentAt(l);e[j].normalize()}f[0]=new THREE.Vector3;g[0]=new THREE.Vector3;b=Number.MAX_VALUE;j=Math.abs(e[0].x);l=Math.abs(e[0].y);n=Math.abs(e[0].z);if(j<=b){b=j;d.set(1,0,0)}if(l<=b){b=l;d.set(0,1,0)}n<=b&&d.set(0,0,1);h.cross(e[0],d).normalize();
f[0].cross(e[0],h);g[0].cross(e[0],f[0]);for(j=1;j<a;j++){f[j]=f[j-1].clone();g[j]=g[j-1].clone();h.cross(e[j-1],e[j]);if(h.length()>1.0E-4){h.normalize();d=Math.acos(e[j-1].dot(e[j]));i.makeRotationAxis(h,d).multiplyVector3(f[j])}g[j].cross(e[j],f[j])}if(c){d=Math.acos(f[0].dot(f[a-1]));d=d/(a-1);e[0].dot(h.cross(f[0],f[a-1]))>0&&(d=-d);for(j=1;j<a;j++){i.makeRotationAxis(e[j],d*j).multiplyVector3(f[j]);g[j].cross(e[j],f[j])}}};
THREE.PolyhedronGeometry=function(b,a,c,d){function e(a){var b=a.normalize().clone();b.index=i.vertices.push(b)-1;var c=Math.atan2(a.z,-a.x)/2/Math.PI+0.5,a=Math.atan2(-a.y,Math.sqrt(a.x*a.x+a.z*a.z))/Math.PI+0.5;b.uv=new THREE.UV(c,a);return b}function f(a,b,c,d){if(d<1){d=new THREE.Face3(a.index,b.index,c.index,[a.clone(),b.clone(),c.clone()]);d.centroid.addSelf(a).addSelf(b).addSelf(c).divideScalar(3);d.normal=d.centroid.clone().normalize();i.faces.push(d);d=Math.atan2(d.centroid.z,-d.centroid.x);
i.faceVertexUvs[0].push([h(a.uv,a,d),h(b.uv,b,d),h(c.uv,c,d)])}else{d=d-1;f(a,g(a,b),g(a,c),d);f(g(a,b),b,g(b,c),d);f(g(a,c),g(b,c),c,d);f(g(a,b),g(b,c),g(a,c),d)}}function g(a,b){n[a.index]||(n[a.index]=[]);n[b.index]||(n[b.index]=[]);var c=n[a.index][b.index];c===void 0&&(n[a.index][b.index]=n[b.index][a.index]=c=e((new THREE.Vector3).add(a,b).divideScalar(2)));return c}function h(a,b,c){c<0&&a.u===1&&(a=new THREE.UV(a.u-1,a.v));b.x===0&&b.z===0&&(a=new THREE.UV(c/2/Math.PI+0.5,a.v));return a}THREE.Geometry.call(this);
for(var c=c||1,d=d||0,i=this,j=0,l=b.length;j<l;j++)e(new THREE.Vector3(b[j][0],b[j][1],b[j][2]));for(var n=[],b=this.vertices,j=0,l=a.length;j<l;j++)f(b[a[j][0]],b[a[j][1]],b[a[j][2]],d);this.mergeVertices();j=0;for(l=this.vertices.length;j<l;j++)this.vertices[j].multiplyScalar(c);this.computeCentroids();this.boundingSphere={radius:c}};THREE.PolyhedronGeometry.prototype=new THREE.Geometry;THREE.PolyhedronGeometry.prototype.constructor=THREE.PolyhedronGeometry;
THREE.IcosahedronGeometry=function(b,a){var c=(1+Math.sqrt(5))/2;THREE.PolyhedronGeometry.call(this,[[-1,c,0],[1,c,0],[-1,-c,0],[1,-c,0],[0,-1,c],[0,1,c],[0,-1,-c],[0,1,-c],[c,0,-1],[c,0,1],[-c,0,-1],[-c,0,1]],[[0,11,5],[0,5,1],[0,1,7],[0,7,10],[0,10,11],[1,5,9],[5,11,4],[11,10,2],[10,7,6],[7,1,8],[3,9,4],[3,4,2],[3,2,6],[3,6,8],[3,8,9],[4,9,5],[2,4,11],[6,2,10],[8,6,7],[9,8,1]],b,a)};THREE.IcosahedronGeometry.prototype=new THREE.Geometry;THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;
THREE.OctahedronGeometry=function(b,a){THREE.PolyhedronGeometry.call(this,[[1,0,0],[-1,0,0],[0,1,0],[0,-1,0],[0,0,1],[0,0,-1]],[[0,2,4],[0,4,3],[0,3,5],[0,5,2],[1,2,5],[1,5,3],[1,3,4],[1,4,2]],b,a)};THREE.OctahedronGeometry.prototype=new THREE.Geometry;THREE.OctahedronGeometry.prototype.constructor=THREE.OctahedronGeometry;THREE.TetrahedronGeometry=function(b,a){THREE.PolyhedronGeometry.call(this,[[1,1,1],[-1,-1,1],[-1,1,-1],[1,-1,-1]],[[2,1,0],[0,3,2],[1,3,0],[2,3,1]],b,a)};
THREE.TetrahedronGeometry.prototype=new THREE.Geometry;THREE.TetrahedronGeometry.prototype.constructor=THREE.TetrahedronGeometry;
THREE.ParametricGeometry=function(b,a,c,d){THREE.Geometry.call(this);var e=this.vertices,f=this.faces,g=this.faceVertexUvs[0],d=d===void 0?false:d,h,i,j,l,n=a+1;for(h=0;h<=c;h++){l=h/c;for(i=0;i<=a;i++){j=i/a;j=b(j,l);e.push(j)}}var k,m,o,q;for(h=0;h<c;h++)for(i=0;i<a;i++){b=h*n+i;e=h*n+i+1;l=(h+1)*n+i;j=(h+1)*n+i+1;k=new THREE.UV(h/a,i/c);m=new THREE.UV(h/a,(i+1)/c);o=new THREE.UV((h+1)/a,i/c);q=new THREE.UV((h+1)/a,(i+1)/c);if(d){f.push(new THREE.Face3(b,e,l));f.push(new THREE.Face3(e,j,l));g.push([k,
m,o]);g.push([m,q,o])}else{f.push(new THREE.Face4(b,e,j,l));g.push([k,m,o,q])}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.ParametricGeometry.prototype=new THREE.Geometry;THREE.ParametricGeometry.prototype.constructor=THREE.ParametricGeometry;
THREE.AxisHelper=function(){THREE.Object3D.call(this);var b=new THREE.Geometry;b.vertices.push(new THREE.Vector3);b.vertices.push(new THREE.Vector3(0,100,0));var a=new THREE.CylinderGeometry(0,5,25,5,1),c;c=new THREE.Line(b,new THREE.LineBasicMaterial({color:16711680}));c.rotation.z=-Math.PI/2;this.add(c);c=new THREE.Mesh(a,new THREE.MeshBasicMaterial({color:16711680}));c.position.x=100;c.rotation.z=-Math.PI/2;this.add(c);c=new THREE.Line(b,new THREE.LineBasicMaterial({color:65280}));this.add(c);
c=new THREE.Mesh(a,new THREE.MeshBasicMaterial({color:65280}));c.position.y=100;this.add(c);c=new THREE.Line(b,new THREE.LineBasicMaterial({color:255}));c.rotation.x=Math.PI/2;this.add(c);c=new THREE.Mesh(a,new THREE.MeshBasicMaterial({color:255}));c.position.z=100;c.rotation.x=Math.PI/2;this.add(c)};THREE.AxisHelper.prototype=new THREE.Object3D;THREE.AxisHelper.prototype.constructor=THREE.AxisHelper;
THREE.ArrowHelper=function(b,a,c,d){THREE.Object3D.call(this);d===void 0&&(d=16776960);c===void 0&&(c=20);var e=new THREE.Geometry;e.vertices.push(new THREE.Vector3(0,0,0));e.vertices.push(new THREE.Vector3(0,1,0));this.line=new THREE.Line(e,new THREE.LineBasicMaterial({color:d}));this.add(this.line);e=new THREE.CylinderGeometry(0,0.05,0.25,5,1);this.cone=new THREE.Mesh(e,new THREE.MeshBasicMaterial({color:d}));this.cone.position.set(0,1,0);this.add(this.cone);if(a instanceof THREE.Vector3)this.position=
a;this.setDirection(b);this.setLength(c)};THREE.ArrowHelper.prototype=new THREE.Object3D;THREE.ArrowHelper.prototype.constructor=THREE.ArrowHelper;THREE.ArrowHelper.prototype.setDirection=function(b){var a=(new THREE.Vector3(0,1,0)).crossSelf(b),b=Math.acos((new THREE.Vector3(0,1,0)).dot(b.clone().normalize()));this.matrix=(new THREE.Matrix4).makeRotationAxis(a.normalize(),b);this.rotation.getRotationFromMatrix(this.matrix,this.scale)};
THREE.ArrowHelper.prototype.setLength=function(b){this.scale.set(b,b,b)};THREE.ArrowHelper.prototype.setColor=function(b){this.line.material.color.setHex(b);this.cone.material.color.setHex(b)};
THREE.CameraHelper=function(b){function a(a,b,d){c(a,d);c(b,d)}function c(a,b){d.lineGeometry.vertices.push(new THREE.Vector3);d.lineGeometry.colors.push(new THREE.Color(b));d.pointMap[a]===void 0&&(d.pointMap[a]=[]);d.pointMap[a].push(d.lineGeometry.vertices.length-1)}THREE.Object3D.call(this);var d=this;this.lineGeometry=new THREE.Geometry;this.lineMaterial=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors});this.pointMap={};a("n1","n2",16755200);a("n2","n4",16755200);a("n4",
"n3",16755200);a("n3","n1",16755200);a("f1","f2",16755200);a("f2","f4",16755200);a("f4","f3",16755200);a("f3","f1",16755200);a("n1","f1",16755200);a("n2","f2",16755200);a("n3","f3",16755200);a("n4","f4",16755200);a("p","n1",16711680);a("p","n2",16711680);a("p","n3",16711680);a("p","n4",16711680);a("u1","u2",43775);a("u2","u3",43775);a("u3","u1",43775);a("c","t",16777215);a("p","c",3355443);a("cn1","cn2",3355443);a("cn3","cn4",3355443);a("cf1","cf2",3355443);a("cf3","cf4",3355443);this.camera=b;this.update(b);
this.lines=new THREE.Line(this.lineGeometry,this.lineMaterial,THREE.LinePieces);this.add(this.lines)};THREE.CameraHelper.prototype=new THREE.Object3D;THREE.CameraHelper.prototype.constructor=THREE.CameraHelper;
THREE.CameraHelper.prototype.update=function(){function b(b,d,e,f){THREE.CameraHelper.__v.set(d,e,f);THREE.CameraHelper.__projector.unprojectVector(THREE.CameraHelper.__v,THREE.CameraHelper.__c);b=a.pointMap[b];if(b!==void 0){d=0;for(e=b.length;d<e;d++)a.lineGeometry.vertices[b[d]].copy(THREE.CameraHelper.__v)}}var a=this;THREE.CameraHelper.__c.projectionMatrix.copy(this.camera.projectionMatrix);b("c",0,0,-1);b("t",0,0,1);b("n1",-1,-1,-1);b("n2",1,-1,-1);b("n3",-1,1,-1);b("n4",1,1,-1);b("f1",-1,-1,
1);b("f2",1,-1,1);b("f3",-1,1,1);b("f4",1,1,1);b("u1",0.7,1.1,-1);b("u2",-0.7,1.1,-1);b("u3",0,2,-1);b("cf1",-1,0,1);b("cf2",1,0,1);b("cf3",0,-1,1);b("cf4",0,1,1);b("cn1",-1,0,-1);b("cn2",1,0,-1);b("cn3",0,-1,-1);b("cn4",0,1,-1);this.lineGeometry.verticesNeedUpdate=true};THREE.CameraHelper.__projector=new THREE.Projector;THREE.CameraHelper.__v=new THREE.Vector3;THREE.CameraHelper.__c=new THREE.Camera;
THREE.SubdivisionModifier=function(b){this.subdivisions=b===void 0?1:b;this.useOldVertexColors=false;this.supportUVs=true;this.debug=false};THREE.SubdivisionModifier.prototype.constructor=THREE.SubdivisionModifier;THREE.SubdivisionModifier.prototype.modify=function(b){for(var a=this.subdivisions;a-- >0;)this.smooth(b)};
THREE.SubdivisionModifier.prototype.smooth=function(b){function a(){k.debug&&console.log.apply(console,arguments)}function c(){console&&console.log.apply(console,arguments)}function d(b,c,d,e,g,h,i){var j=new THREE.Face4(b,c,d,e,null,g.color,g.material);if(k.useOldVertexColors){j.vertexColors=[];for(var m,o,q,p=0;p<4;p++){q=h[p];m=new THREE.Color;m.setRGB(0,0,0);for(var r=0;r<q.length;r++){o=g.vertexColors[q[r]-1];m.r=m.r+o.r;m.g=m.g+o.g;m.b=m.b+o.b}m.r=m.r/q.length;m.g=m.g/q.length;m.b=m.b/q.length;
j.vertexColors[p]=m}}l.push(j);if(k.supportUVs){g=[f(b,""),f(c,i),f(d,i),f(e,i)];g[0]?g[1]?g[2]?g[3]?n.push(g):a("d :( ",e+":"+i):a("c :( ",d+":"+i):a("b :( ",c+":"+i):a("a :( ",b+":"+i)}}function e(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function f(b,d){var e=b+":"+d,f=t[e];if(!f){b>=v&&b<v+o.length?a("face pt"):a("edge pt");c("warning, UV not found for",e);return null}return f}function g(a,b,d){var e=a+":"+b;e in t?c("dup vertexNo",a,"oldFaceNo",b,"value",d,"key",e,t[e]):t[e]=d}function h(a,
b){I[a]===void 0&&(I[a]=[]);I[a].push(b)}function i(a,b,c){K[a]===void 0&&(K[a]={});K[a][b]=c}var j=[],l=[],n=[],k=this,m=b.vertices,o=b.faces,j=m.concat(),q=[],r={},s={},t={},v=m.length,p,x,A,z,u,w=b.faceVertexUvs[0],F;a("originalFaces, uvs, originalVerticesLength",o.length,w.length,v);if(k.supportUVs){p=0;for(x=w.length;p<x;p++){A=0;for(z=w[p].length;A<z;A++){F=o[p]["abcd".charAt(A)];g(F,p,w[p][A])}}}if(w.length==0)k.supportUVs=false;p=0;for(u in t)p++;if(!p){k.supportUVs=false;a("no uvs")}a("-- Original Faces + Vertices UVs completed",
t,"vs",w.length);p=0;for(x=o.length;p<x;p++){u=o[p];q.push(u.centroid);j.push(u.centroid);if(k.supportUVs){w=new THREE.UV;if(u instanceof THREE.Face3){w.u=f(u.a,p).u+f(u.b,p).u+f(u.c,p).u;w.v=f(u.a,p).v+f(u.b,p).v+f(u.c,p).v;w.u=w.u/3;w.v=w.v/3}else if(u instanceof THREE.Face4){w.u=f(u.a,p).u+f(u.b,p).u+f(u.c,p).u+f(u.d,p).u;w.v=f(u.a,p).v+f(u.b,p).v+f(u.c,p).v+f(u.d,p).v;w.u=w.u/4;w.v=w.v/4}g(v+p,"",w)}}a("-- added UVs for new Faces",t);x=function(a){function b(a,c){h[a]===void 0&&(h[a]=[]);h[a].push(c)}
var c,d,f,g,h={};c=0;for(d=a.faces.length;c<d;c++){f=a.faces[c];if(f instanceof THREE.Face3){g=e(f.a,f.b);b(g,c);g=e(f.b,f.c);b(g,c);g=e(f.c,f.a);b(g,c)}else if(f instanceof THREE.Face4){g=e(f.a,f.b);b(g,c);g=e(f.b,f.c);b(g,c);g=e(f.c,f.d);b(g,c);g=e(f.d,f.a);b(g,c)}}return h}(b);F=0;var C,B,I={},K={};for(p in x){w=x[p];C=p.split("_");B=C[0];C=C[1];h(B,[B,C]);h(C,[B,C]);A=0;for(z=w.length;A<z;A++){u=w[A];i(B,u,p);i(C,u,p)}w.length<2&&(s[p]=true)}a("vertexEdgeMap",I,"vertexFaceMap",K);for(p in x){w=
x[p];u=w[0];z=w[1];C=p.split("_");B=C[0];C=C[1];w=new THREE.Vector3;if(s[p]){w.addSelf(m[B]);w.addSelf(m[C]);w.multiplyScalar(0.5)}else{w.addSelf(q[u]);w.addSelf(q[z]);w.addSelf(m[B]);w.addSelf(m[C]);w.multiplyScalar(0.25)}r[p]=v+o.length+F;j.push(w);F++;if(k.supportUVs){w=new THREE.UV;w.u=f(B,u).u+f(C,u).u;w.v=f(B,u).v+f(C,u).v;w.u=w.u/2;w.v=w.v/2;g(r[p],u,w);if(!s[p]){w=new THREE.UV;w.u=f(B,z).u+f(C,z).u;w.v=f(B,z).v+f(C,z).v;w.u=w.u/2;w.v=w.v/2;g(r[p],z,w)}}}a("-- Step 2 done");var E,D;z=["123",
"12","2","23"];C=["123","23","3","31"];var G=["123","31","1","12"],N=["1234","12","2","23"],H=["1234","23","3","34"],L=["1234","34","4","41"],J=["1234","41","1","12"];p=0;for(x=q.length;p<x;p++){u=o[p];w=v+p;if(u instanceof THREE.Face3){F=e(u.a,u.b);B=e(u.b,u.c);E=e(u.c,u.a);d(w,r[F],u.b,r[B],u,z,p);d(w,r[B],u.c,r[E],u,C,p);d(w,r[E],u.a,r[F],u,G,p)}else if(u instanceof THREE.Face4){F=e(u.a,u.b);B=e(u.b,u.c);E=e(u.c,u.d);D=e(u.d,u.a);d(w,r[F],u.b,r[B],u,N,p);d(w,r[B],u.c,r[E],u,H,p);d(w,r[E],u.d,r[D],
u,L,p);d(w,r[D],u.a,r[F],u,J,p)}else a("face should be a face!",u)}r=new THREE.Vector3;u=new THREE.Vector3;p=0;for(x=m.length;p<x;p++)if(I[p]!==void 0){r.set(0,0,0);u.set(0,0,0);B=new THREE.Vector3(0,0,0);w=0;for(A in K[p]){r.addSelf(q[A]);w++}z=0;F=I[p].length;for(A=0;A<F;A++)s[e(I[p][A][0],I[p][A][1])]&&z++;if(z!=2){r.divideScalar(w);for(A=0;A<F;A++){w=I[p][A];w=m[w[0]].clone().addSelf(m[w[1]]).divideScalar(2);u.addSelf(w)}u.divideScalar(F);B.addSelf(m[p]);B.multiplyScalar(F-3);B.addSelf(r);B.addSelf(u.multiplyScalar(2));
B.divideScalar(F);j[p]=B}}b.vertices=j;b.faces=l;b.faceVertexUvs[0]=n;delete b.__tmpVertices;b.computeCentroids();b.computeFaceNormals();b.computeVertexNormals()};THREE.ImmediateRenderObject=function(){THREE.Object3D.call(this);this.render=function(){}};THREE.ImmediateRenderObject.prototype=new THREE.Object3D;THREE.ImmediateRenderObject.prototype.constructor=THREE.ImmediateRenderObject;
THREE.LensFlare=function(b,a,c,d,e){THREE.Object3D.call(this);this.lensFlares=[];this.positionScreen=new THREE.Vector3;this.customUpdateCallback=void 0;b!==void 0&&this.add(b,a,c,d,e)};THREE.LensFlare.prototype=new THREE.Object3D;THREE.LensFlare.prototype.constructor=THREE.LensFlare;THREE.LensFlare.prototype.supr=THREE.Object3D.prototype;
THREE.LensFlare.prototype.add=function(b,a,c,d,e,f){a===void 0&&(a=-1);c===void 0&&(c=0);f===void 0&&(f=1);e===void 0&&(e=new THREE.Color(16777215));if(d===void 0)d=THREE.NormalBlending;c=Math.min(c,Math.max(0,c));this.lensFlares.push({texture:b,size:a,distance:c,x:0,y:0,z:0,scale:1,rotation:1,opacity:f,color:e,blending:d})};
THREE.LensFlare.prototype.updateLensFlares=function(){var b,a=this.lensFlares.length,c,d=-this.positionScreen.x*2,e=-this.positionScreen.y*2;for(b=0;b<a;b++){c=this.lensFlares[b];c.x=this.positionScreen.x+d*c.distance;c.y=this.positionScreen.y+e*c.distance;c.wantedRotation=c.x*Math.PI*0.25;c.rotation=c.rotation+(c.wantedRotation-c.rotation)*0.25}};
THREE.MorphBlendMesh=function(b,a){THREE.Mesh.call(this,b,a);this.animationsMap={};this.animationsList=[];var c=this.geometry.morphTargets.length;this.createAnimation("__default",0,c-1,c/1);this.setAnimationWeight("__default",1)};THREE.MorphBlendMesh.prototype=new THREE.Mesh;THREE.MorphBlendMesh.prototype.constructor=THREE.MorphBlendMesh;
THREE.MorphBlendMesh.prototype.createAnimation=function(b,a,c,d){a={startFrame:a,endFrame:c,length:c-a+1,fps:d,duration:(c-a)/d,lastFrame:0,currentFrame:0,active:false,time:0,direction:1,weight:1,directionBackwards:false,mirroredLoop:false};this.animationsMap[b]=a;this.animationsList.push(a)};
THREE.MorphBlendMesh.prototype.autoCreateAnimations=function(b){for(var a=/([a-z]+)(\d+)/,c,d={},e=this.geometry,f=0,g=e.morphTargets.length;f<g;f++){var h=e.morphTargets[f].name.match(a);if(h&&h.length>1){var i=h[1];d[i]||(d[i]={start:Infinity,end:-Infinity});h=d[i];if(f<h.start)h.start=f;if(f>h.end)h.end=f;c||(c=i)}}for(i in d){h=d[i];this.createAnimation(i,h.start,h.end,b)}this.firstAnimation=c};
THREE.MorphBlendMesh.prototype.setAnimationDirectionForward=function(b){if(b=this.animationsMap[b]){b.direction=1;b.directionBackwards=false}};THREE.MorphBlendMesh.prototype.setAnimationDirectionBackward=function(b){if(b=this.animationsMap[b]){b.direction=-1;b.directionBackwards=true}};THREE.MorphBlendMesh.prototype.setAnimationFPS=function(b,a){var c=this.animationsMap[b];if(c){c.fps=a;c.duration=(c.end-c.start)/c.fps}};
THREE.MorphBlendMesh.prototype.setAnimationDuration=function(b,a){var c=this.animationsMap[b];if(c){c.duration=a;c.fps=(c.end-c.start)/c.duration}};THREE.MorphBlendMesh.prototype.setAnimationWeight=function(b,a){var c=this.animationsMap[b];if(c)c.weight=a};THREE.MorphBlendMesh.prototype.setAnimationTime=function(b,a){var c=this.animationsMap[b];if(c)c.time=a};THREE.MorphBlendMesh.prototype.getAnimationTime=function(b){var a=0;if(b=this.animationsMap[b])a=b.time;return a};
THREE.MorphBlendMesh.prototype.getAnimationDuration=function(b){var a=-1;if(b=this.animationsMap[b])a=b.duration;return a};THREE.MorphBlendMesh.prototype.playAnimation=function(b){var a=this.animationsMap[b];if(a){a.time=0;a.active=true}else console.warn("animation["+b+"] undefined")};THREE.MorphBlendMesh.prototype.stopAnimation=function(b){if(b=this.animationsMap[b])b.active=false};
THREE.MorphBlendMesh.prototype.update=function(b){for(var a=0,c=this.animationsList.length;a<c;a++){var d=this.animationsList[a];if(d.active){var e=d.duration/d.length;d.time=d.time+d.direction*b;if(d.mirroredLoop){if(d.time>d.duration||d.time<0){d.direction=d.direction*-1;if(d.time>d.duration){d.time=d.duration;d.directionBackwards=true}if(d.time<0){d.time=0;d.directionBackwards=false}}}else{d.time=d.time%d.duration;if(d.time<0)d.time=d.time+d.duration}var f=d.startFrame+THREE.Math.clamp(Math.floor(d.time/
e),0,d.length-1),g=d.weight;if(f!==d.currentFrame){this.morphTargetInfluences[d.lastFrame]=0;this.morphTargetInfluences[d.currentFrame]=1*g;this.morphTargetInfluences[f]=0;d.lastFrame=d.currentFrame;d.currentFrame=f}e=d.time%e/e;d.directionBackwards&&(e=1-e);this.morphTargetInfluences[d.currentFrame]=e*g;this.morphTargetInfluences[d.lastFrame]=(1-e)*g}}};
THREE.LensFlarePlugin=function(){function b(b){var c=a.createProgram(),d=a.createShader(a.FRAGMENT_SHADER),e=a.createShader(a.VERTEX_SHADER);a.shaderSource(d,b.fragmentShader);a.shaderSource(e,b.vertexShader);a.compileShader(d);a.compileShader(e);a.attachShader(c,d);a.attachShader(c,e);a.linkProgram(c);return c}var a,c,d,e,f,g,h,i,j,l,n,k,m;this.init=function(o){a=o.context;c=o;d=new Float32Array(16);e=new Uint16Array(6);o=0;d[o++]=-1;d[o++]=-1;d[o++]=0;d[o++]=0;d[o++]=1;d[o++]=-1;d[o++]=1;d[o++]=
0;d[o++]=1;d[o++]=1;d[o++]=1;d[o++]=1;d[o++]=-1;d[o++]=1;d[o++]=0;d[o++]=1;o=0;e[o++]=0;e[o++]=1;e[o++]=2;e[o++]=0;e[o++]=2;e[o++]=3;f=a.createBuffer();g=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,f);a.bufferData(a.ARRAY_BUFFER,d,a.STATIC_DRAW);a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,g);a.bufferData(a.ELEMENT_ARRAY_BUFFER,e,a.STATIC_DRAW);h=a.createTexture();i=a.createTexture();a.bindTexture(a.TEXTURE_2D,h);a.texImage2D(a.TEXTURE_2D,0,a.RGB,16,16,0,a.RGB,a.UNSIGNED_BYTE,null);a.texParameteri(a.TEXTURE_2D,
a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.NEAREST);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.NEAREST);a.bindTexture(a.TEXTURE_2D,i);a.texImage2D(a.TEXTURE_2D,0,a.RGBA,16,16,0,a.RGBA,a.UNSIGNED_BYTE,null);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE);a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.NEAREST);
a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.NEAREST);if(a.getParameter(a.MAX_VERTEX_TEXTURE_IMAGE_UNITS)<=0){j=false;l=b(THREE.ShaderFlares.lensFlare)}else{j=true;l=b(THREE.ShaderFlares.lensFlareVertexTexture)}n={};k={};n.vertex=a.getAttribLocation(l,"position");n.uv=a.getAttribLocation(l,"uv");k.renderType=a.getUniformLocation(l,"renderType");k.map=a.getUniformLocation(l,"map");k.occlusionMap=a.getUniformLocation(l,"occlusionMap");k.opacity=a.getUniformLocation(l,"opacity");k.color=a.getUniformLocation(l,
"color");k.scale=a.getUniformLocation(l,"scale");k.rotation=a.getUniformLocation(l,"rotation");k.screenPosition=a.getUniformLocation(l,"screenPosition");m=false};this.render=function(b,d,e,s){var b=b.__webglFlares,t=b.length;if(t){var v=new THREE.Vector3,p=s/e,x=e*0.5,A=s*0.5,z=16/s,u=new THREE.Vector2(z*p,z),w=new THREE.Vector3(1,1,0),F=new THREE.Vector2(1,1),C=k,z=n;a.useProgram(l);if(!m){a.enableVertexAttribArray(n.vertex);a.enableVertexAttribArray(n.uv);m=true}a.uniform1i(C.occlusionMap,0);a.uniform1i(C.map,
1);a.bindBuffer(a.ARRAY_BUFFER,f);a.vertexAttribPointer(z.vertex,2,a.FLOAT,false,16,0);a.vertexAttribPointer(z.uv,2,a.FLOAT,false,16,8);a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,g);a.disable(a.CULL_FACE);a.depthMask(false);var B,I,K,E,D;for(B=0;B<t;B++){z=16/s;u.set(z*p,z);E=b[B];v.set(E.matrixWorld.elements[12],E.matrixWorld.elements[13],E.matrixWorld.elements[14]);d.matrixWorldInverse.multiplyVector3(v);d.projectionMatrix.multiplyVector3(v);w.copy(v);F.x=w.x*x+x;F.y=w.y*A+A;if(j||F.x>0&&F.x<e&&F.y>0&&
F.y<s){a.activeTexture(a.TEXTURE1);a.bindTexture(a.TEXTURE_2D,h);a.copyTexImage2D(a.TEXTURE_2D,0,a.RGB,F.x-8,F.y-8,16,16,0);a.uniform1i(C.renderType,0);a.uniform2f(C.scale,u.x,u.y);a.uniform3f(C.screenPosition,w.x,w.y,w.z);a.disable(a.BLEND);a.enable(a.DEPTH_TEST);a.drawElements(a.TRIANGLES,6,a.UNSIGNED_SHORT,0);a.activeTexture(a.TEXTURE0);a.bindTexture(a.TEXTURE_2D,i);a.copyTexImage2D(a.TEXTURE_2D,0,a.RGBA,F.x-8,F.y-8,16,16,0);a.uniform1i(C.renderType,1);a.disable(a.DEPTH_TEST);a.activeTexture(a.TEXTURE1);
a.bindTexture(a.TEXTURE_2D,h);a.drawElements(a.TRIANGLES,6,a.UNSIGNED_SHORT,0);E.positionScreen.copy(w);E.customUpdateCallback?E.customUpdateCallback(E):E.updateLensFlares();a.uniform1i(C.renderType,2);a.enable(a.BLEND);I=0;for(K=E.lensFlares.length;I<K;I++){D=E.lensFlares[I];if(D.opacity>0.001&&D.scale>0.001){w.x=D.x;w.y=D.y;w.z=D.z;z=D.size*D.scale/s;u.x=z*p;u.y=z;a.uniform3f(C.screenPosition,w.x,w.y,w.z);a.uniform2f(C.scale,u.x,u.y);a.uniform1f(C.rotation,D.rotation);a.uniform1f(C.opacity,D.opacity);
a.uniform3f(C.color,D.color.r,D.color.g,D.color.b);c.setBlending(D.blending,D.blendEquation,D.blendSrc,D.blendDst);c.setTexture(D.texture,1);a.drawElements(a.TRIANGLES,6,a.UNSIGNED_SHORT,0)}}}}a.enable(a.CULL_FACE);a.enable(a.DEPTH_TEST);a.depthMask(true)}}};
THREE.ShadowMapPlugin=function(){var b,a,c,d,e=new THREE.Frustum,f=new THREE.Matrix4,g=new THREE.Vector3,h=new THREE.Vector3;this.init=function(e){b=e.context;a=e;var e=THREE.ShaderLib.depthRGBA,f=THREE.UniformsUtils.clone(e.uniforms);c=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f});d=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f,morphTargets:true});c._shadowPass=true;d._shadowPass=true};this.render=
function(b,c){a.shadowMapEnabled&&a.shadowMapAutoUpdate&&this.update(b,c)};this.update=function(i,j){var l,n,k,m,o,q,r,s,t,v=[];m=0;b.clearColor(1,1,1,1);b.disable(b.BLEND);b.enable(b.CULL_FACE);a.shadowMapCullFrontFaces?b.cullFace(b.FRONT):b.cullFace(b.BACK);a.setDepthTest(true);l=0;for(n=i.__lights.length;l<n;l++){k=i.__lights[l];if(k.castShadow)if(k instanceof THREE.DirectionalLight&&k.shadowCascade)for(o=0;o<k.shadowCascadeCount;o++){var p;if(k.shadowCascadeArray[o])p=k.shadowCascadeArray[o];
else{t=k;r=o;p=new THREE.DirectionalLight;p.isVirtual=true;p.onlyShadow=true;p.castShadow=true;p.shadowCameraNear=t.shadowCameraNear;p.shadowCameraFar=t.shadowCameraFar;p.shadowCameraLeft=t.shadowCameraLeft;p.shadowCameraRight=t.shadowCameraRight;p.shadowCameraBottom=t.shadowCameraBottom;p.shadowCameraTop=t.shadowCameraTop;p.shadowCameraVisible=t.shadowCameraVisible;p.shadowDarkness=t.shadowDarkness;p.shadowBias=t.shadowCascadeBias[r];p.shadowMapWidth=t.shadowCascadeWidth[r];p.shadowMapHeight=t.shadowCascadeHeight[r];
p.pointsWorld=[];p.pointsFrustum=[];s=p.pointsWorld;q=p.pointsFrustum;for(var x=0;x<8;x++){s[x]=new THREE.Vector3;q[x]=new THREE.Vector3}s=t.shadowCascadeNearZ[r];t=t.shadowCascadeFarZ[r];q[0].set(-1,-1,s);q[1].set(1,-1,s);q[2].set(-1,1,s);q[3].set(1,1,s);q[4].set(-1,-1,t);q[5].set(1,-1,t);q[6].set(-1,1,t);q[7].set(1,1,t);p.originalCamera=j;q=new THREE.Gyroscope;q.position=k.shadowCascadeOffset;q.add(p);q.add(p.target);j.add(q);k.shadowCascadeArray[o]=p;console.log("Created virtualLight",p)}r=k;s=
o;t=r.shadowCascadeArray[s];t.position.copy(r.position);t.target.position.copy(r.target.position);t.lookAt(t.target);t.shadowCameraVisible=r.shadowCameraVisible;t.shadowDarkness=r.shadowDarkness;t.shadowBias=r.shadowCascadeBias[s];q=r.shadowCascadeNearZ[s];r=r.shadowCascadeFarZ[s];t=t.pointsFrustum;t[0].z=q;t[1].z=q;t[2].z=q;t[3].z=q;t[4].z=r;t[5].z=r;t[6].z=r;t[7].z=r;v[m]=p;m++}else{v[m]=k;m++}}l=0;for(n=v.length;l<n;l++){k=v[l];if(!k.shadowMap){k.shadowMap=new THREE.WebGLRenderTarget(k.shadowMapWidth,
k.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat});k.shadowMapSize=new THREE.Vector2(k.shadowMapWidth,k.shadowMapHeight);k.shadowMatrix=new THREE.Matrix4}if(!k.shadowCamera){if(k instanceof THREE.SpotLight)k.shadowCamera=new THREE.PerspectiveCamera(k.shadowCameraFov,k.shadowMapWidth/k.shadowMapHeight,k.shadowCameraNear,k.shadowCameraFar);else if(k instanceof THREE.DirectionalLight)k.shadowCamera=new THREE.OrthographicCamera(k.shadowCameraLeft,k.shadowCameraRight,
k.shadowCameraTop,k.shadowCameraBottom,k.shadowCameraNear,k.shadowCameraFar);else{console.error("Unsupported light type for shadow");continue}i.add(k.shadowCamera);a.autoUpdateScene&&i.updateMatrixWorld()}if(k.shadowCameraVisible&&!k.cameraHelper){k.cameraHelper=new THREE.CameraHelper(k.shadowCamera);k.shadowCamera.add(k.cameraHelper)}if(k.isVirtual&&p.originalCamera==j){o=j;m=k.shadowCamera;q=k.pointsFrustum;t=k.pointsWorld;g.set(Infinity,Infinity,Infinity);h.set(-Infinity,-Infinity,-Infinity);for(r=
0;r<8;r++){s=t[r];s.copy(q[r]);THREE.ShadowMapPlugin.__projector.unprojectVector(s,o);m.matrixWorldInverse.multiplyVector3(s);if(s.x<g.x)g.x=s.x;if(s.x>h.x)h.x=s.x;if(s.y<g.y)g.y=s.y;if(s.y>h.y)h.y=s.y;if(s.z<g.z)g.z=s.z;if(s.z>h.z)h.z=s.z}m.left=g.x;m.right=h.x;m.top=h.y;m.bottom=g.y;m.updateProjectionMatrix()}m=k.shadowMap;q=k.shadowMatrix;o=k.shadowCamera;o.position.copy(k.matrixWorld.getPosition());o.lookAt(k.target.matrixWorld.getPosition());o.updateMatrixWorld();o.matrixWorldInverse.getInverse(o.matrixWorld);
if(k.cameraHelper)k.cameraHelper.lines.visible=k.shadowCameraVisible;k.shadowCameraVisible&&k.cameraHelper.update();q.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);q.multiplySelf(o.projectionMatrix);q.multiplySelf(o.matrixWorldInverse);if(!o._viewMatrixArray)o._viewMatrixArray=new Float32Array(16);if(!o._projectionMatrixArray)o._projectionMatrixArray=new Float32Array(16);o.matrixWorldInverse.flattenToArray(o._viewMatrixArray);o.projectionMatrix.flattenToArray(o._projectionMatrixArray);f.multiply(o.projectionMatrix,
o.matrixWorldInverse);e.setFromMatrix(f);a.setRenderTarget(m);a.clear();t=i.__webglObjects;k=0;for(m=t.length;k<m;k++){r=t[k];q=r.object;r.render=false;if(q.visible&&q.castShadow&&(!(q instanceof THREE.Mesh)||!q.frustumCulled||e.contains(q))){q._modelViewMatrix.multiply(o.matrixWorldInverse,q.matrixWorld);r.render=true}}k=0;for(m=t.length;k<m;k++){r=t[k];if(r.render){q=r.object;r=r.buffer;s=q.customDepthMaterial?q.customDepthMaterial:q.geometry.morphTargets.length?d:c;r instanceof THREE.BufferGeometry?
a.renderBufferDirect(o,i.__lights,null,s,r,q):a.renderBuffer(o,i.__lights,null,s,r,q)}}t=i.__webglObjectsImmediate;k=0;for(m=t.length;k<m;k++){r=t[k];q=r.object;if(q.visible&&q.castShadow){q._modelViewMatrix.multiply(o.matrixWorldInverse,q.matrixWorld);a.renderImmediateObject(o,i.__lights,null,c,q)}}}l=a.getClearColor();n=a.getClearAlpha();b.clearColor(l.r,l.g,l.b,n);b.enable(b.BLEND);a.shadowMapCullFrontFaces&&b.cullFace(b.BACK)}};THREE.ShadowMapPlugin.__projector=new THREE.Projector;
THREE.SpritePlugin=function(){function b(a,b){return b.z-a.z}var a,c,d,e,f,g,h,i,j,l;this.init=function(b){a=b.context;c=b;d=new Float32Array(16);e=new Uint16Array(6);b=0;d[b++]=-1;d[b++]=-1;d[b++]=0;d[b++]=1;d[b++]=1;d[b++]=-1;d[b++]=1;d[b++]=1;d[b++]=1;d[b++]=1;d[b++]=1;d[b++]=0;d[b++]=-1;d[b++]=1;d[b++]=0;b=d[b++]=0;e[b++]=0;e[b++]=1;e[b++]=2;e[b++]=0;e[b++]=2;e[b++]=3;f=a.createBuffer();g=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,f);a.bufferData(a.ARRAY_BUFFER,d,a.STATIC_DRAW);a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,
g);a.bufferData(a.ELEMENT_ARRAY_BUFFER,e,a.STATIC_DRAW);var b=THREE.ShaderSprite.sprite,k=a.createProgram(),m=a.createShader(a.FRAGMENT_SHADER),o=a.createShader(a.VERTEX_SHADER);a.shaderSource(m,b.fragmentShader);a.shaderSource(o,b.vertexShader);a.compileShader(m);a.compileShader(o);a.attachShader(k,m);a.attachShader(k,o);a.linkProgram(k);h=k;i={};j={};i.position=a.getAttribLocation(h,"position");i.uv=a.getAttribLocation(h,"uv");j.uvOffset=a.getUniformLocation(h,"uvOffset");j.uvScale=a.getUniformLocation(h,
"uvScale");j.rotation=a.getUniformLocation(h,"rotation");j.scale=a.getUniformLocation(h,"scale");j.alignment=a.getUniformLocation(h,"alignment");j.color=a.getUniformLocation(h,"color");j.map=a.getUniformLocation(h,"map");j.opacity=a.getUniformLocation(h,"opacity");j.useScreenCoordinates=a.getUniformLocation(h,"useScreenCoordinates");j.affectedByDistance=a.getUniformLocation(h,"affectedByDistance");j.screenPosition=a.getUniformLocation(h,"screenPosition");j.modelViewMatrix=a.getUniformLocation(h,"modelViewMatrix");
j.projectionMatrix=a.getUniformLocation(h,"projectionMatrix");l=false};this.render=function(d,e,m,o){var d=d.__webglSprites,q=d.length;if(q){var r=i,s=j,t=o/m,m=m*0.5,v=o*0.5,p=true;a.useProgram(h);if(!l){a.enableVertexAttribArray(r.position);a.enableVertexAttribArray(r.uv);l=true}a.disable(a.CULL_FACE);a.enable(a.BLEND);a.depthMask(true);a.bindBuffer(a.ARRAY_BUFFER,f);a.vertexAttribPointer(r.position,2,a.FLOAT,false,16,0);a.vertexAttribPointer(r.uv,2,a.FLOAT,false,16,8);a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,
g);a.uniformMatrix4fv(s.projectionMatrix,false,e._projectionMatrixArray);a.activeTexture(a.TEXTURE0);a.uniform1i(s.map,0);for(var x,A=[],r=0;r<q;r++){x=d[r];if(x.visible&&x.opacity!==0)if(x.useScreenCoordinates)x.z=-x.position.z;else{x._modelViewMatrix.multiply(e.matrixWorldInverse,x.matrixWorld);x.z=-x._modelViewMatrix.elements[14]}}d.sort(b);for(r=0;r<q;r++){x=d[r];if(x.visible&&x.opacity!==0&&x.map&&x.map.image&&x.map.image.width){if(x.useScreenCoordinates){a.uniform1i(s.useScreenCoordinates,1);
a.uniform3f(s.screenPosition,(x.position.x-m)/m,(v-x.position.y)/v,Math.max(0,Math.min(1,x.position.z)))}else{a.uniform1i(s.useScreenCoordinates,0);a.uniform1i(s.affectedByDistance,x.affectedByDistance?1:0);a.uniformMatrix4fv(s.modelViewMatrix,false,x._modelViewMatrix.elements)}e=x.map.image.width/(x.scaleByViewport?o:1);A[0]=e*t*x.scale.x;A[1]=e*x.scale.y;a.uniform2f(s.uvScale,x.uvScale.x,x.uvScale.y);a.uniform2f(s.uvOffset,x.uvOffset.x,x.uvOffset.y);a.uniform2f(s.alignment,x.alignment.x,x.alignment.y);
a.uniform1f(s.opacity,x.opacity);a.uniform3f(s.color,x.color.r,x.color.g,x.color.b);a.uniform1f(s.rotation,x.rotation);a.uniform2fv(s.scale,A);if(x.mergeWith3D&&!p){a.enable(a.DEPTH_TEST);p=true}else if(!x.mergeWith3D&&p){a.disable(a.DEPTH_TEST);p=false}c.setBlending(x.blending,x.blendEquation,x.blendSrc,x.blendDst);c.setTexture(x.map,0);a.drawElements(a.TRIANGLES,6,a.UNSIGNED_SHORT,0)}}a.enable(a.CULL_FACE);a.enable(a.DEPTH_TEST);a.depthMask(true)}}};
THREE.DepthPassPlugin=function(){this.enabled=false;this.renderTarget=null;var b,a,c,d,e=new THREE.Frustum,f=new THREE.Matrix4;this.init=function(e){b=e.context;a=e;var e=THREE.ShaderLib.depthRGBA,f=THREE.UniformsUtils.clone(e.uniforms);c=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f});d=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f,morphTargets:true});c._shadowPass=true;d._shadowPass=true};this.render=
function(a,b){this.enabled&&this.update(a,b)};this.update=function(g,h){var i,j,l,n,k,m;b.clearColor(1,1,1,1);b.disable(b.BLEND);a.setDepthTest(true);a.autoUpdateScene&&g.updateMatrixWorld();if(!h._viewMatrixArray)h._viewMatrixArray=new Float32Array(16);if(!h._projectionMatrixArray)h._projectionMatrixArray=new Float32Array(16);h.matrixWorldInverse.getInverse(h.matrixWorld);h.matrixWorldInverse.flattenToArray(h._viewMatrixArray);h.projectionMatrix.flattenToArray(h._projectionMatrixArray);f.multiply(h.projectionMatrix,
h.matrixWorldInverse);e.setFromMatrix(f);a.setRenderTarget(this.renderTarget);a.clear();m=g.__webglObjects;i=0;for(j=m.length;i<j;i++){l=m[i];k=l.object;l.render=false;if(k.visible&&(!(k instanceof THREE.Mesh)||!k.frustumCulled||e.contains(k))){k._modelViewMatrix.multiply(h.matrixWorldInverse,k.matrixWorld);l.render=true}}i=0;for(j=m.length;i<j;i++){l=m[i];if(l.render){k=l.object;l=l.buffer;a.setObjectFaces(k);n=k.customDepthMaterial?k.customDepthMaterial:k.geometry.morphTargets.length?d:c;l instanceof
THREE.BufferGeometry?a.renderBufferDirect(h,g.__lights,null,n,l,k):a.renderBuffer(h,g.__lights,null,n,l,k)}}m=g.__webglObjectsImmediate;i=0;for(j=m.length;i<j;i++){l=m[i];k=l.object;if(k.visible&&k.castShadow){k._modelViewMatrix.multiply(h.matrixWorldInverse,k.matrixWorld);a.renderImmediateObject(h,g.__lights,null,c,k)}}i=a.getClearColor();j=a.getClearAlpha();b.clearColor(i.r,i.g,i.b,j);b.enable(b.BLEND)}};
THREE.ShaderFlares={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * vVisibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * visibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"}};
THREE.ShaderSprite={sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"precision mediump float;\nuniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\n}"}};
