// ThreeSVG.js r43 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,f,g;if(c==0)this.r=this.g=this.b=0;else switch(d=Math.floor(a*6),f=a*6-d,a=c*(1-b),g=c*(1-b*f),b=c*(1-b*(1-f)),d){case 1:this.r=g;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=g;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=
c;this.g=a;this.b=g;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
unit:function(){return this.normalize()},equals:function(a){return a.x==this.x&&a.y==this.y}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=
a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){return this.divide(this,a)},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},
dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*
a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<
1.0E-4}};THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){return this.set(a.x,a.y,a.z,a.w||1)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},
subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):this.set(0,0,0,1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},
setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)d=d.concat(this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d,c=c.matrixWorld.getPosition();d=c.clone().subSelf(a).dot(b);a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),
c=c.clone().subSelf(b),f=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(f),e=c.dot(c),c=c.dot(f),f=1/(a*e-b*b),e=(e*d-b*c)*f,a=(a*c-b*d)*f;return e>0&&a>0&&e+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a);if(!d||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a);if(!d||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,Math.max(a.scale.y,a.scale.z)))return[];var f,g,e,h,
l,i,k,j,n,m,p=a.geometry,q=p.vertices,w=[],d=0;for(f=p.faces.length;d<f;d++)if(g=p.faces[d],n=this.origin.clone(),m=this.direction.clone(),i=a.matrixWorld,e=i.multiplyVector3(q[g.a].position.clone()),h=i.multiplyVector3(q[g.b].position.clone()),l=i.multiplyVector3(q[g.c].position.clone()),i=g instanceof THREE.Face4?i.multiplyVector3(q[g.d].position.clone()):null,k=a.matrixRotationWorld.multiplyVector3(g.normal.clone()),j=m.dot(k),a.doubleSided||(a.flipSided?j>0:j<0))if(k=k.dot((new THREE.Vector3).sub(e,
n))/j,n=n.addSelf(m.multiplyScalar(k)),g instanceof THREE.Face3)c(n,e,h,l)&&(g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},w.push(g));else if(g instanceof THREE.Face4&&(c(n,e,h,i)||c(n,h,l,i)))g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},w.push(g);return w}else return[]}};
THREE.Rectangle=function(){function a(){g=d-b;e=f-c}var b,c,d,f,g,e,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return e};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return f};this.set=function(e,g,k,j){h=!1;b=e;c=g;d=k;f=j;a()};this.addPoint=function(e,g){h?(h=!1,b=e,c=g,d=e,f=g):(b=b<e?b:e,c=c<g?c:g,d=d>e?d:e,f=f>g?f:g);a()};this.add3Points=
function(e,g,k,j,n,m){h?(h=!1,b=e<k?e<n?e:n:k<n?k:n,c=g<j?g<m?g:m:j<m?j:m,d=e>k?e>n?e:n:k>n?k:n,f=g>j?g>m?g:m:j>m?j:m):(b=e<k?e<n?e<b?e:b:n<b?n:b:k<n?k<b?k:b:n<b?n:b,c=g<j?g<m?g<c?g:c:m<c?m:c:j<m?j<c?j:c:m<c?m:c,d=e>k?e>n?e>d?e:d:n>d?n:d:k>n?k>d?k:d:n>d?n:d,f=g>j?g>m?g>f?g:f:m>f?m:f:j>m?j>f?j:f:m>f?m:f);a()};this.addRectangle=function(e){h?(h=!1,b=e.getLeft(),c=e.getTop(),d=e.getRight(),f=e.getBottom()):(b=b<e.getLeft()?b:e.getLeft(),c=c<e.getTop()?c:e.getTop(),d=d>e.getRight()?d:e.getRight(),f=f>
e.getBottom()?f:e.getBottom());a()};this.inflate=function(e){b-=e;c-=e;d+=e;f+=e;a()};this.minSelf=function(e){b=b>e.getLeft()?b:e.getLeft();c=c>e.getTop()?c:e.getTop();d=d<e.getRight()?d:e.getRight();f=f<e.getBottom()?f:e.getBottom();a()};this.instersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(f,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;f=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,f,g,e,h,l,i,k,j,n,m,p,q){this.set(a||1,b||0,c||0,d||0,f||0,g||1,e||0,h||0,l||0,i||0,k||1,j||0,n||0,m||0,p||0,q||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,f,g,e,h,l,i,k,j,n,m,p,q){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=f;this.n22=g;this.n23=e;this.n24=h;this.n31=l;this.n32=i;this.n33=k;this.n34=j;this.n41=n;this.n42=m;this.n43=p;this.n44=q;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;d.cross(c,g).normalize();d.length()===0&&(g.x+=1.0E-4,d.cross(c,g).normalize());f.cross(g,d).normalize();this.n11=d.x;this.n12=f.x;this.n13=g.x;this.n21=d.y;this.n22=f.y;this.n23=g.y;this.n31=d.z;this.n32=f.z;this.n33=g.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,f=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*f;
a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*f;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*f;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,f=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*f;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*f;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*f;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*f;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+
c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,e=a.n21,h=a.n22,l=a.n23,i=a.n24,k=a.n31,j=a.n32,n=a.n33,m=a.n34,p=a.n41,q=a.n42,w=a.n43,v=a.n44,A=b.n11,H=b.n12,
s=b.n13,r=b.n14,o=b.n21,E=b.n22,B=b.n23,x=b.n24,C=b.n31,I=b.n32,J=b.n33,z=b.n34,O=b.n41,L=b.n42,M=b.n43,P=b.n44;this.n11=c*A+d*o+f*C+g*O;this.n12=c*H+d*E+f*I+g*L;this.n13=c*s+d*B+f*J+g*M;this.n14=c*r+d*x+f*z+g*P;this.n21=e*A+h*o+l*C+i*O;this.n22=e*H+h*E+l*I+i*L;this.n23=e*s+h*B+l*J+i*M;this.n24=e*r+h*x+l*z+i*P;this.n31=k*A+j*o+n*C+m*O;this.n32=k*H+j*E+n*I+m*L;this.n33=k*s+j*B+n*J+m*M;this.n34=k*r+j*x+n*z+m*P;this.n41=p*A+q*o+w*C+v*O;this.n42=p*H+q*E+w*I+v*L;this.n43=p*s+q*B+w*J+v*M;this.n44=p*r+q*
x+w*z+v*P;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=
a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,f=this.n21,g=this.n22,e=this.n23,h=this.n24,l=this.n31,i=this.n32,k=this.n33,j=this.n34,n=this.n41,m=this.n42,p=this.n43,q=this.n44;return d*e*i*n-c*h*i*n-d*g*k*n+b*h*k*n+c*g*j*n-b*e*j*n-d*e*l*m+c*h*l*m+d*f*k*m-a*h*k*m-c*f*j*m+a*e*j*m+d*g*l*p-b*h*l*p-d*f*i*p+a*h*i*p+b*f*j*p-a*g*j*p-c*g*l*q+b*e*l*q+c*f*i*q-a*e*i*q-b*f*k*q+a*g*k*q},
transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;
a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;
a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;
a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,
0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),f=1-c,g=a.x,e=a.y,h=a.z,l=f*g,i=f*e;this.set(l*g+c,l*e-d*h,l*h+d*e,0,l*e+d*h,i*e+c,i*h-d*g,0,l*h-d*e,i*h+d*g,f*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,f=a.z,g=Math.cos(c),c=Math.sin(c),e=Math.cos(d),d=Math.sin(d),h=Math.cos(f),f=Math.sin(f);switch(b){case "YXZ":var l=
e*h,i=e*f,k=d*h,j=d*f;this.n11=l+j*c;this.n12=k*c-i;this.n13=g*d;this.n21=g*f;this.n22=g*h;this.n23=-c;this.n31=i*c-k;this.n32=j+l*c;this.n33=g*e;break;case "ZXY":l=e*h;i=e*f;k=d*h;j=d*f;this.n11=l-j*c;this.n12=-g*f;this.n13=k+i*c;this.n21=i+k*c;this.n22=g*h;this.n23=j-l*c;this.n31=-g*d;this.n32=c;this.n33=g*e;break;case "ZYX":l=g*h;i=g*f;k=c*h;j=c*f;this.n11=e*h;this.n12=k*d-i;this.n13=l*d+j;this.n21=e*f;this.n22=j*d+l;this.n23=i*d-k;this.n31=-d;this.n32=c*e;this.n33=g*e;break;case "YZX":l=g*e;i=
g*d;k=c*e;j=c*d;this.n11=e*h;this.n12=j-l*f;this.n13=k*f+i;this.n21=f;this.n22=g*h;this.n23=-c*h;this.n31=-d*h;this.n32=i*f+k;this.n33=l-j*f;break;case "XZY":l=g*e;i=g*d;k=c*e;j=c*d;this.n11=e*h;this.n12=-f;this.n13=d*h;this.n21=l*f+j;this.n22=g*h;this.n23=i*f-k;this.n31=k*f-i;this.n32=c*h;this.n33=j*f+l;break;default:l=g*h,i=g*f,k=c*h,j=c*f,this.n11=e*h,this.n12=-e*f,this.n13=d,this.n21=i+k*d,this.n22=l-j*d,this.n23=-c*e,this.n31=j-l*d,this.n32=k+i*d,this.n33=g*e}return this},setRotationFromQuaternion:function(a){var b=
a.x,c=a.y,d=a.z,f=a.w,g=b+b,e=c+c,h=d+d,a=b*g,l=b*e;b*=h;var i=c*e;c*=h;d*=h;g*=f;e*=f;f*=h;this.n11=1-(i+d);this.n12=l-f;this.n13=b+e;this.n21=l+f;this.n22=1-(a+d);this.n23=c-g;this.n31=b-e;this.n32=c+g;this.n33=1-(a+i);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34},
extractRotation:function(a,b){var c=1/b.x,d=1/b.y,f=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*f;this.n23=a.n23*f;this.n33=a.n33*f}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,e=a.n21,h=a.n22,l=a.n23,i=a.n24,k=a.n31,j=a.n32,n=a.n33,m=a.n34,p=a.n41,q=a.n42,w=a.n43,v=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=l*m*q-i*n*q+i*j*w-h*m*w-l*j*v+h*n*v;b.n12=g*n*q-f*m*q-g*j*w+d*m*w+f*j*v-d*n*v;b.n13=f*i*q-g*l*q+g*h*w-d*i*w-f*h*v+d*l*v;b.n14=g*l*j-f*i*j-g*h*n+d*i*n+f*h*m-d*l*m;b.n21=i*n*p-l*m*p-i*k*w+e*m*w+l*k*v-e*n*v;b.n22=f*m*p-g*n*p+g*k*w-c*m*w-f*k*v+c*n*v;b.n23=g*l*p-f*i*p-g*e*w+c*i*w+f*e*v-c*l*v;b.n24=
f*i*k-g*l*k+g*e*n-c*i*n-f*e*m+c*l*m;b.n31=h*m*p-i*j*p+i*k*q-e*m*q-h*k*v+e*j*v;b.n32=g*j*p-d*m*p-g*k*q+c*m*q+d*k*v-c*j*v;b.n33=f*i*p-g*h*p+g*e*q-c*i*q-d*e*v+c*h*v;b.n34=g*h*k-d*i*k-g*e*j+c*i*j+d*e*m-c*h*m;b.n41=l*j*p-h*n*p-l*k*q+e*n*q+h*k*w-e*j*w;b.n42=d*n*p-f*j*p+f*k*q-c*n*q-d*k*w+c*j*w;b.n43=f*h*p-d*l*p-f*e*q+c*l*q+d*e*w-c*h*w;b.n44=d*l*k-f*h*k+f*e*j-c*l*j-d*e*n+c*h*n;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,f=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,e=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,l=-a.n32*a.n11+a.n31*a.n12,i=a.n23*a.n12-a.n22*a.n13,k=-a.n23*a.n11+a.n21*a.n13,j=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*e+a.n31*i;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*f;c[2]=a*g;c[3]=a*e;c[4]=a*h;c[5]=a*l;c[6]=a*i;c[7]=a*k;c[8]=a*j;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,f,g){var e;e=new THREE.Matrix4;e.n11=2*f/(b-a);e.n12=0;e.n13=(b+a)/(b-a);e.n14=0;e.n21=0;e.n22=2*f/(d-c);e.n23=(d+c)/(d-c);e.n24=0;e.n31=0;e.n32=0;e.n33=-(g+f)/(g-f);e.n34=-2*g*f/(g-f);e.n41=0;e.n42=0;e.n43=-1;e.n44=0;return e};THREE.Matrix4.makePerspective=function(a,b,c,d){var f,a=c*Math.tan(a*Math.PI/360);f=-a;return THREE.Matrix4.makeFrustum(f*b,a*b,f,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,f,g){var e,h,l,i;e=new THREE.Matrix4;h=b-a;l=c-d;i=g-f;e.n11=2/h;e.n12=0;e.n13=0;e.n14=-((b+a)/h);e.n21=0;e.n22=2/l;e.n23=0;e.n24=-((c+d)/l);e.n31=0;e.n32=0;e.n33=-2/i;e.n34=-((g+f)/i);e.n41=0;e.n42=0;e.n43=0;e.n44=1;return e};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;
this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1)a.parent=void 0,this.children.splice(b,1)},getChildByName:function(a,b){var c,d,f;c=0;for(d=this.children.length;c<d;c++){f=this.children[c];if(f.name===a)return f;if(b&&(f=f.getChildByName(a,b),f!==void 0))return f}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,f=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-f),f=Math.sin(-f),g=Math.cos(c),c=Math.sin(c),e=a*b,h=d*f;this.w=e*g-h*c;this.x=e*c+h*g;this.y=d*b*g+a*f*c;this.z=a*f*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=
a,this.w*=a);return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,f=this.w,g=a.x,e=a.y,h=a.z,a=a.w;this.x=b*a+f*g+c*h-d*e;this.y=c*a+f*e+d*g-b*h;this.z=d*a+f*h+b*e-c*g;this.w=f*a-b*g-c*e-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,f=a.z,g=this.x,e=this.y,h=this.z,
l=this.w,i=l*c+e*f-h*d,k=l*d+h*c-g*f,j=l*f+g*d-e*c,c=-g*c-e*d-h*f;b.x=i*l+c*-g+k*-h-j*-e;b.y=k*l+c*-e+j*-g-i*-h;b.z=j*l+c*-h+i*-e-k*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var f=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(f)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(f),e=Math.sqrt(1-f*f);if(Math.abs(e)<0.001)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;f=Math.sin((1-d)*g)/e;d=Math.sin(d*g)/e;c.w=a.w*f+b.w*d;c.x=a.x*f+b.x*d;c.y=a.y*f+b.y*d;c.z=a.z*f+b.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,f,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,f,g,e){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=e instanceof Array?e:[e];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.set(a||0,b||0)};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),
c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,c,d,f,g,e,h=new THREE.Vector3,l=new THREE.Vector3;d=0;for(f=this.faces.length;d<f;d++){g=this.faces[d];if(a&&g.vertexNormals.length){h.set(0,0,0);b=0;for(c=g.vertexNormals.length;b<c;b++)h.addSelf(g.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[g.a],c=this.vertices[g.b],e=this.vertices[g.c],h.sub(e.position,c.position),l.sub(b.position,c.position),h.crossSelf(l);h.isZero()||
h.normalize();g.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=
this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,f,g,D){h=a.vertices[b].position;l=a.vertices[c].position;i=a.vertices[d].position;k=e[f];j=e[g];n=e[D];m=l.x-h.x;p=i.x-h.x;q=l.y-h.y;w=i.y-h.y;v=l.z-h.z;A=i.z-h.z;H=j.u-k.u;s=n.u-k.u;r=j.v-k.v;o=n.v-k.v;E=1/(H*o-s*r);I.set((o*m-r*p)*
E,(o*q-r*w)*E,(o*v-r*A)*E);J.set((H*p-s*m)*E,(H*w-s*q)*E,(H*A-s*v)*E);x[b].addSelf(I);x[c].addSelf(I);x[d].addSelf(I);C[b].addSelf(J);C[c].addSelf(J);C[d].addSelf(J)}var b,c,d,f,g,e,h,l,i,k,j,n,m,p,q,w,v,A,H,s,r,o,E,B,x=[],C=[],I=new THREE.Vector3,J=new THREE.Vector3,z=new THREE.Vector3,O=new THREE.Vector3,L=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)x[b]=new THREE.Vector3,C[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],e=this.faceVertexUvs[0][b],g instanceof
THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var M=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)L.copy(g.vertexNormals[d]),f=g[M[d]],B=x[f],z.copy(B),z.subSelf(L.multiplyScalar(L.dot(B))).normalize(),O.cross(g.vertexNormals[d],B),f=O.dot(C[f]),f=f<0?-1:1,g.vertexTangents[d]=new THREE.Vector4(z.x,z.y,z.z,f)}this.hasTangents=!0},computeBoundingBox:function(){var a;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;
else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function b(a,b,c){a[b]===
void 0?(a[b]={set:{},array:[]},a[b].set[c]=1,a[b].array.push(c)):a[b].set[c]===void 0&&(a[b].set[c]=1,a[b].array.push(c))}var c,d,f,g,e,h={};c=0;for(d=this.faces.length;c<d;c++)e=this.faces[c],e instanceof THREE.Face3?(f=a(e.a,e.b),b(h,f,c),f=a(e.b,e.c),b(h,f,c),f=a(e.a,e.c),b(h,f,c)):e instanceof THREE.Face4&&(f=a(e.b,e.d),b(h,f,c),f=a(e.a,e.b),b(h,f,c),f=a(e.a,e.d),b(h,f,c),f=a(e.b,e.c),b(h,f,c),f=a(e.c,e.d),b(h,f,c));c=0;for(d=this.edges.length;c<d;c++){e=this.edges[c];f=e.vertexIndices[0];g=e.vertexIndices[1];
e.faceIndices=h[a(f,g)].array;for(f=0;f<e.faceIndices.length;f++)g=e.faceIndices[f],e.faces.push(this.faces[g])}}};THREE.GeometryIdCounter=0;THREE.Camera=function(a,b,c,d,f){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=f||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);b.multiplyScalar(a);this.position.addSelf(b);this.target.position.addSelf(b)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(a,b,c,d,f,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=f;this.height=g;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),b=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1;this.distance=c||0;this.castShadow=d!==void 0?d:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1;this.distance=c||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){this.id=THREE.MaterialCount++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:
0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==
void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,f=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<f;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<f;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1)this.objects.push(a),this.__objectsAdded.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;
THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(){var a=l[h]=l[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return e>=0&&f>=0&&g>=0&&h>=0?!0:e<0&&f<0||g<0&&h<0?!1:(e<0?c=Math.max(c,e/(e-f)):f<0&&(d=Math.min(d,e/(e-f))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,f,g=[],e,h,l=[],i,k,j=[],n,m=[],p,q,w=[],v,A,H=[],s=new THREE.Vector4,r=new THREE.Vector4,
o=new THREE.Matrix4,E=new THREE.Matrix4,B=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],x=new THREE.Vector4,C=new THREE.Vector4;this.projectVector=function(a,b){o.multiply(b.projectionMatrix,b.matrixWorldInverse);o.multiplyVector3(a);return a};this.unprojectVector=function(a,b){o.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));o.multiplyVector3(a);return a};this.projectObjects=function(a,c,e){var c=[],h,i,l;f=0;i=
a.objects;a=0;for(h=i.length;a<h;a++){l=i[a];var j;if(!(j=!l.visible))if(j=l instanceof THREE.Mesh){a:{j=void 0;for(var k=l.matrixWorld,n=-l.geometry.boundingSphere.radius*Math.max(l.scale.x,Math.max(l.scale.y,l.scale.z)),m=0;m<6;m++)if(j=B[m].x*k.n14+B[m].y*k.n24+B[m].z*k.n34+B[m].w,j<=n){j=!1;break a}j=!0}j=!j}if(!j)j=g[f]=g[f]||new THREE.RenderableObject,f++,d=j,s.copy(l.position),o.multiplyVector3(s),d.object=l,d.z=s.z,c.push(d)}e&&c.sort(b);return c};this.projectScene=function(d,f,g){var s=[],
L=f.near,M=f.far,P,Q,F,N,y,G,D,K,u,t,R,U,W,X,S,V,T;A=q=n=k=0;f.matrixAutoUpdate&&f.update(void 0,!0);d.update(void 0,!1,f);o.multiply(f.projectionMatrix,f.matrixWorldInverse);B[0].set(o.n41-o.n11,o.n42-o.n12,o.n43-o.n13,o.n44-o.n14);B[1].set(o.n41+o.n11,o.n42+o.n12,o.n43+o.n13,o.n44+o.n14);B[2].set(o.n41+o.n21,o.n42+o.n22,o.n43+o.n23,o.n44+o.n24);B[3].set(o.n41-o.n21,o.n42-o.n22,o.n43-o.n23,o.n44-o.n24);B[4].set(o.n41-o.n31,o.n42-o.n32,o.n43-o.n33,o.n44-o.n34);B[5].set(o.n41+o.n31,o.n42+o.n32,o.n43+
o.n33,o.n44+o.n34);for(P=0;P<6;P++)u=B[P],u.divideScalar(Math.sqrt(u.x*u.x+u.y*u.y+u.z*u.z));u=this.projectObjects(d,f,!0);d=0;for(P=u.length;d<P;d++)if(t=u[d].object,t.visible)if(R=t.matrixWorld,U=t.matrixRotationWorld,W=t.materials,X=t.overdraw,h=0,t instanceof THREE.Mesh){S=t.geometry;N=S.vertices;V=S.faces;S=S.faceVertexUvs;Q=0;for(F=N.length;Q<F;Q++)e=a(),e.positionWorld.copy(N[Q].position),R.multiplyVector3(e.positionWorld),e.positionScreen.copy(e.positionWorld),o.multiplyVector4(e.positionScreen),
e.positionScreen.x/=e.positionScreen.w,e.positionScreen.y/=e.positionScreen.w,e.visible=e.positionScreen.z>L&&e.positionScreen.z<M;N=0;for(Q=V.length;N<Q;N++){F=V[N];if(F instanceof THREE.Face3)if(y=l[F.a],G=l[F.b],D=l[F.c],y.visible&&G.visible&&D.visible&&(t.doubleSided||t.flipSided!=(D.positionScreen.x-y.positionScreen.x)*(G.positionScreen.y-y.positionScreen.y)-(D.positionScreen.y-y.positionScreen.y)*(G.positionScreen.x-y.positionScreen.x)<0))K=j[k]=j[k]||new THREE.RenderableFace3,k++,i=K,i.v1.copy(y),
i.v2.copy(G),i.v3.copy(D);else continue;else if(F instanceof THREE.Face4)if(y=l[F.a],G=l[F.b],D=l[F.c],K=l[F.d],y.visible&&G.visible&&D.visible&&K.visible&&(t.doubleSided||t.flipSided!=((K.positionScreen.x-y.positionScreen.x)*(G.positionScreen.y-y.positionScreen.y)-(K.positionScreen.y-y.positionScreen.y)*(G.positionScreen.x-y.positionScreen.x)<0||(G.positionScreen.x-D.positionScreen.x)*(K.positionScreen.y-D.positionScreen.y)-(G.positionScreen.y-D.positionScreen.y)*(K.positionScreen.x-D.positionScreen.x)<
0)))T=m[n]=m[n]||new THREE.RenderableFace4,n++,i=T,i.v1.copy(y),i.v2.copy(G),i.v3.copy(D),i.v4.copy(K);else continue;i.normalWorld.copy(F.normal);U.multiplyVector3(i.normalWorld);i.centroidWorld.copy(F.centroid);R.multiplyVector3(i.centroidWorld);i.centroidScreen.copy(i.centroidWorld);o.multiplyVector3(i.centroidScreen);D=F.vertexNormals;y=0;for(G=D.length;y<G;y++)K=i.vertexNormalsWorld[y],K.copy(D[y]),U.multiplyVector3(K);y=0;for(G=S.length;y<G;y++)if(T=S[y][N]){D=0;for(K=T.length;D<K;D++)i.uvs[y][D]=
T[D]}i.meshMaterials=W;i.faceMaterials=F.materials;i.overdraw=X;i.z=i.centroidScreen.z;s.push(i)}}else if(t instanceof THREE.Line){E.multiply(o,R);N=t.geometry.vertices;y=a();y.positionScreen.copy(N[0].position);E.multiplyVector4(y.positionScreen);Q=1;for(F=N.length;Q<F;Q++)if(y=a(),y.positionScreen.copy(N[Q].position),E.multiplyVector4(y.positionScreen),G=l[h-2],x.copy(y.positionScreen),C.copy(G.positionScreen),c(x,C))x.multiplyScalar(1/x.w),C.multiplyScalar(1/C.w),R=w[q]=w[q]||new THREE.RenderableLine,
q++,p=R,p.v1.positionScreen.copy(x),p.v2.positionScreen.copy(C),p.z=Math.max(x.z,C.z),p.materials=t.materials,s.push(p)}else if(t instanceof THREE.Particle&&(r.set(t.matrixWorld.n14,t.matrixWorld.n24,t.matrixWorld.n34,1),o.multiplyVector4(r),r.z/=r.w,r.z>0&&r.z<1))R=H[A]=H[A]||new THREE.RenderableParticle,A++,v=R,v.x=r.x/r.w,v.y=r.y/r.w,v.z=r.z,v.rotation=t.rotation.z,v.scale.x=t.scale.x*Math.abs(v.x-(r.x+f.projectionMatrix.n11)/(r.w+f.projectionMatrix.n14)),v.scale.y=t.scale.y*Math.abs(v.y-(r.y+
f.projectionMatrix.n22)/(r.w+f.projectionMatrix.n24)),v.materials=t.materials,s.push(v);g&&s.sort(b);return s}};
THREE.SVGRenderer=function(){function a(a,b,c){var d,f,e,g;d=0;for(f=a.lights.length;d<f;d++)e=a.lights[d],e instanceof THREE.DirectionalLight?(g=b.normalWorld.dot(e.position)*e.intensity,g>0&&(c.r+=e.color.r*g,c.g+=e.color.g*g,c.b+=e.color.b*g)):e instanceof THREE.PointLight&&(C.sub(e.position,b.centroidWorld),C.normalize(),g=b.normalWorld.dot(C)*e.intensity,g>0&&(c.r+=e.color.r*g,c.g+=e.color.g*g,c.b+=e.color.b*g))}function b(b,c,e,h,i,j){g.data.vertices+=3;g.data.faces++;z=d(O++);z.setAttribute("d",
"M "+b.positionScreen.x+" "+b.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+e.positionScreen.x+","+e.positionScreen.y+"z");i instanceof THREE.MeshBasicMaterial?s.copy(i.color):i instanceof THREE.MeshLambertMaterial?H?(r.r=o.r,r.g=o.g,r.b=o.b,a(j,h,r),s.r=Math.max(0,Math.min(i.color.r*r.r,1)),s.g=Math.max(0,Math.min(i.color.g*r.g,1)),s.b=Math.max(0,Math.min(i.color.b*r.b,1))):s.copy(i.color):i instanceof THREE.MeshDepthMaterial?(x=1-i.__2near/(i.__farPlusNear-h.z*i.__farMinusNear),
s.setRGB(x,x,x)):i instanceof THREE.MeshNormalMaterial&&s.setRGB(f(h.normalWorld.x),f(h.normalWorld.y),f(h.normalWorld.z));i.wireframe?z.setAttribute("style","fill: none; stroke: "+s.getContextStyle()+"; stroke-width: "+i.wireframeLinewidth+"; stroke-opacity: "+i.opacity+"; stroke-linecap: "+i.wireframeLinecap+"; stroke-linejoin: "+i.wireframeLinejoin):z.setAttribute("style","fill: "+s.getContextStyle()+"; fill-opacity: "+i.opacity);l.appendChild(z)}function c(b,c,e,h,i,j,k){g.data.vertices+=4;g.data.faces++;
z=d(O++);z.setAttribute("d","M "+b.positionScreen.x+" "+b.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+e.positionScreen.x+","+e.positionScreen.y+" L "+h.positionScreen.x+","+h.positionScreen.y+"z");j instanceof THREE.MeshBasicMaterial?s.copy(j.color):j instanceof THREE.MeshLambertMaterial?H?(r.r=o.r,r.g=o.g,r.b=o.b,a(k,i,r),s.r=Math.max(0,Math.min(j.color.r*r.r,1)),s.g=Math.max(0,Math.min(j.color.g*r.g,1)),s.b=Math.max(0,Math.min(j.color.b*r.b,1))):s.copy(j.color):j instanceof
THREE.MeshDepthMaterial?(x=1-j.__2near/(j.__farPlusNear-i.z*j.__farMinusNear),s.setRGB(x,x,x)):j instanceof THREE.MeshNormalMaterial&&s.setRGB(f(i.normalWorld.x),f(i.normalWorld.y),f(i.normalWorld.z));j.wireframe?z.setAttribute("style","fill: none; stroke: "+s.getContextStyle()+"; stroke-width: "+j.wireframeLinewidth+"; stroke-opacity: "+j.opacity+"; stroke-linecap: "+j.wireframeLinecap+"; stroke-linejoin: "+j.wireframeLinejoin):z.setAttribute("style","fill: "+s.getContextStyle()+"; fill-opacity: "+
j.opacity);l.appendChild(z)}function d(a){I[a]==null&&(I[a]=document.createElementNS("http://www.w3.org/2000/svg","path"),M==0&&I[a].setAttribute("shape-rendering","crispEdges"));return I[a]}function f(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}var g=this,e=null,h=new THREE.Projector,l=document.createElementNS("http://www.w3.org/2000/svg","svg"),i,k,j,n,m,p,q,w,v=new THREE.Rectangle,A=new THREE.Rectangle,H=!1,s=new THREE.Color(16777215),r=new THREE.Color(16777215),o=new THREE.Color(0),E=new THREE.Color(0),
B=new THREE.Color(0),x,C=new THREE.Vector3,I=[],J=[],z,O,L,M=1;this.domElement=l;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,faces:0};this.setQuality=function(a){switch(a){case "high":M=1;break;case "low":M=0}};this.setSize=function(a,b){i=a;k=b;j=i/2;n=k/2;l.setAttribute("viewBox",-j+" "+-n+" "+i+" "+k);l.setAttribute("width",i);l.setAttribute("height",k);v.set(-j,-n,j,n)};this.clear=function(){for(;l.childNodes.length>0;)l.removeChild(l.childNodes[0])};this.render=
function(a,d){var f,i,k,r,s,x,u,t;this.autoClear&&this.clear();g.data.vertices=0;g.data.faces=0;e=h.projectScene(a,d,this.sortElements);L=O=0;if(H=a.lights.length>0){u=a.lights;o.setRGB(0,0,0);E.setRGB(0,0,0);B.setRGB(0,0,0);f=0;for(i=u.length;f<i;f++)k=u[f],r=k.color,k instanceof THREE.AmbientLight?(o.r+=r.r,o.g+=r.g,o.b+=r.b):k instanceof THREE.DirectionalLight?(E.r+=r.r,E.g+=r.g,E.b+=r.b):k instanceof THREE.PointLight&&(B.r+=r.r,B.g+=r.g,B.b+=r.b)}f=0;for(i=e.length;f<i;f++)if(u=e[f],A.empty(),
u instanceof THREE.RenderableParticle){m=u;m.x*=j;m.y*=-n;k=0;for(r=u.materials.length;k<r;)k++}else if(u instanceof THREE.RenderableLine){if(m=u.v1,p=u.v2,m.positionScreen.x*=j,m.positionScreen.y*=-n,p.positionScreen.x*=j,p.positionScreen.y*=-n,A.addPoint(m.positionScreen.x,m.positionScreen.y),A.addPoint(p.positionScreen.x,p.positionScreen.y),v.instersects(A)){k=0;for(r=u.materials.length;k<r;)if((t=u.materials[k++])&&t.opacity!=0){s=m;x=p;var C=L++;J[C]==null&&(J[C]=document.createElementNS("http://www.w3.org/2000/svg",
"line"),M==0&&J[C].setAttribute("shape-rendering","crispEdges"));z=J[C];z.setAttribute("x1",s.positionScreen.x);z.setAttribute("y1",s.positionScreen.y);z.setAttribute("x2",x.positionScreen.x);z.setAttribute("y2",x.positionScreen.y);t instanceof THREE.LineBasicMaterial&&(z.setAttribute("style","fill: none; stroke: "+t.color.getContextStyle()+"; stroke-width: "+t.linewidth+"; stroke-opacity: "+t.opacity+"; stroke-linecap: "+t.linecap+"; stroke-linejoin: "+t.linejoin),l.appendChild(z))}}}else if(u instanceof
THREE.RenderableFace3){if(m=u.v1,p=u.v2,q=u.v3,m.positionScreen.x*=j,m.positionScreen.y*=-n,p.positionScreen.x*=j,p.positionScreen.y*=-n,q.positionScreen.x*=j,q.positionScreen.y*=-n,A.addPoint(m.positionScreen.x,m.positionScreen.y),A.addPoint(p.positionScreen.x,p.positionScreen.y),A.addPoint(q.positionScreen.x,q.positionScreen.y),v.instersects(A)){k=0;for(r=u.meshMaterials.length;k<r;)if(t=u.meshMaterials[k++],t instanceof THREE.MeshFaceMaterial){s=0;for(x=u.faceMaterials.length;s<x;)(t=u.faceMaterials[s++])&&
t.opacity!=0&&b(m,p,q,u,t,a)}else t&&t.opacity!=0&&b(m,p,q,u,t,a)}}else if(u instanceof THREE.RenderableFace4&&(m=u.v1,p=u.v2,q=u.v3,w=u.v4,m.positionScreen.x*=j,m.positionScreen.y*=-n,p.positionScreen.x*=j,p.positionScreen.y*=-n,q.positionScreen.x*=j,q.positionScreen.y*=-n,w.positionScreen.x*=j,w.positionScreen.y*=-n,A.addPoint(m.positionScreen.x,m.positionScreen.y),A.addPoint(p.positionScreen.x,p.positionScreen.y),A.addPoint(q.positionScreen.x,q.positionScreen.y),A.addPoint(w.positionScreen.x,w.positionScreen.y),
v.instersects(A))){k=0;for(r=u.meshMaterials.length;k<r;)if(t=u.meshMaterials[k++],t instanceof THREE.MeshFaceMaterial){s=0;for(x=u.faceMaterials.length;s<x;)(t=u.faceMaterials[s++])&&t.opacity!=0&&c(m,p,q,w,u,t,a)}else t&&t.opacity!=0&&c(m,p,q,w,u,t,a)}}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
