package org.traccar.protocol;

import org.junit.Test;
import org.traccar.ProtocolTest;

public class UlbotechProtocolDecoderTest extends ProtocolTest {

    @Test
    public void testDecode() throws Exception {

        UlbotechProtocolDecoder decoder = new UlbotechProtocolDecoder(null);

        verifyNull(decoder, buffer(
                "*TS01,353323081464660#"));

        verifyAttributes(decoder, buffer(
                "*TS01,868323025245751,134955140317,WFE:0#"));

        verifyPosition(decoder, binary(
                "f801010868323028799515251e10d3010e03b52df8ff99fde500000000270f030402020000040402c62a7e0506057c1929220d060800000000000000000f040071eb621001018536f8"),
                position("2019-09-25 11:49:39.000", false, 62.20543, -6.68521));

        verifyPosition(decoder, binary(
                "f8010103515810532780699f7e2e3f010e015ee4c906bde45c00000000008b0304004000000404002c776005060373193622110b00240b00fee8ffff807dffff606d0b00fee9af000000af0000000b00feee7d78807dffffffff100101cc2af8"));

        verifyPosition(decoder, binary(
                "F8010103596580420045259CFB3329010E015ED91506BDE5A800000000009E030402420000040400492AA405060344197E220D071131058F410C1591310D48312F8F413107C60804027666B00C138254D182607A826EE083BE554385F50019423CAD1DF8"));

        verifyNotNull(decoder, binary(
                "F8010108683230231070781EA3676E020BFFFFFFFFFFFFFFFFFFFF780304000000030404000002C20506032A1790220E100101AC72F8"));

        verifyNotNull(decoder, binary(
                "f8010108683230220996561ea6ce1c020bffffffffffffffffffff78030400000000040400087b710506035519ad2214060800000000000000006220f8"));

        verifyAttributes(decoder, binary(
                "f8010108683230220996561ea6ce3f020b02cc00114e86000002f153030400000000040400087b710506035619a4221406080000000000000000fbcff8"));

        verifyAttributes(decoder, binary(
                "f8010108683230211861161e9d8c48020b00de0063eb730128b56161030400010001040400127d0705060174179422021005e000000001db06f8"));

        verifyPosition(decoder, binary(
                "f8010108683230220996561ea6cdf9010eff47465cfb68d7a000000000270f030400000000040400087b710506035119ba22140608000000000000000022cef8"));

        verifyPosition(decoder, binary(
                "f8010108683230220996561ea74274010eff47477bfb68d89000000000270f030400000000040400087b710506035419472214060800000000000000006661f8"));

        verifyPosition(decoder, binary(
                "f8010103515790566431569e5fbb9d010e015ee2b906bde4a000000000009f03040a4000000404000115fe05060340173f22030711310583410c0000310d00312f834131000008040000b78c09077320290082c021100101120af8"));

        verifyNull(decoder, buffer(
                "*TS01,354043051389460#"));

        verifyPosition(decoder, binary(
                "f8010108679650230646339de69054010e015ee17506bde2c60000000000ac0304024000000404000009f705060390181422170711310583410c0000310d00312f834131018608040003130a100101136cf8"));

        verifyPosition(decoder, binary(
                "f8010108679650230651689dc8e45b010e01194a26fbd47fa6001f003c0054030402420000040400024d7b0506037c18692212071131057f410c0ee0310d1b312f41413112ef0804000dd59fcc32f8"));

        verifyPosition(decoder, binary(
                "f8010103596580419465449da89d16010efe5580fe0923d82100140129005903040242000004040001a7f10506037818be220e070e31057b410c1324310d144131fa3208040020b1418297f8"));
        
        verifyPosition(decoder, binary(
                "f8010103596580419465449da8564e010efe55a1800923d04b0000000000710304000000000404000178d2050603571876220ec3caf8"));
        
        verifyPosition(decoder, binary(
                "f8010103545500500179009ccb4b62010e00144db906310d3f0000000000cb0304000000000404000a8123050603211860221006080000000100000000ef97f8"));

        verifyPosition(decoder, binary(
                "F80101035785203457289495D60235010E016175A506C2C838000000000064"));

        verifyPosition(decoder, binary(
                "F8010108621060211481299C4247FA010E015EE1D606BDE797000301370081030402420000040400523CAF050603921743220706080000000000000000071131058E410C0E30310D48312F8E4131046A080402C8F2545445F8"));
        
        verifyPosition(decoder, binary(
                "F8010108621060211481299C4249FA010E015EE27506BDE80900020000008F030402420000040400523CAF05060392173F220706080000000000000000071131058E410C0E40310D48312F8E41310884080402CA60E43872F8"));

        verifyNotNull(decoder, binary(
                "f8010108653280262660481cdacf830209ffffffffffffffff780304000300000404000000030506017418a021f99697f8"));

        verifyNotNull(decoder, binary(
                "f801010865328026266048fffeae800209ffffffffffffffff7803040200000004040000000005060375175421f3060800000000000000009c28f8"));

        verifyPosition(decoder, binary(
                "f8010108653280262660489ce260b4010e01e757bd022340d7002b010d01570304020200000404000000260506036a17d42200060800000000000000000a0101ab9ff8"));

        verifyPosition(decoder, binary(
                "f8010108653280262660489ce260df010e01e756f30223384a0003010a02a80304020200000404000001280506036217fe22010608000000000000000005aaf8"));

        verifyPosition(decoder, binary(
                "f8010108653280262660489ce26128010e01e769ac022336290014010300730304020200000404000003c905060371181c2201060800000000000000000a0140e471f8"));

    }

}
