package org.traccar.protocol;

import org.junit.Test;
import org.traccar.ProtocolTest;

public class OmnicommProtocolDecoderTest extends ProtocolTest {

    @Test
    public void testDecode() throws Exception {

        OmnicommProtocolDecoder decoder = new OmnicommProtocolDecoder(null);

        verifyNull(decoder, binary(
                "c080080061a61915340100001dec"));

        verifyPositions(decoder, binary(
                "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"));

        verifyPositions(decoder, binary(
                "C0866300CD1400002273231400580008011308A2E68DA10110002006280030003800400048005000600068007000142B08EC979EB60410EEB7CC8C02180020002804300038A2E68DA1012C33080010001800200028003000344308381000180220382800300244DF2A"));

        verifyPositions(decoder, binary(
                "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"));

    }

}
