package org.traccar.protocol;

import org.junit.Test;
import org.traccar.ProtocolTest;

public class Minifinder2ProtocolDecoderTest extends ProtocolTest {

    @Test
    public void testDecode() throws Exception {

        Minifinder2ProtocolDecoder decoder = new Minifinder2ProtocolDecoder(null);

        verifyNull(decoder, binary(
                "ab10150076f1320003100133353534363530373130323933303602105a"));

        verifyNotNull(decoder, binary(
                "ab1024009b3f9742011001383635323039303336333430303235113154cfc95d0a00000080d0c95d0a000000"));

        verifyPosition(decoder, binary(
                "ab103f007e2533000110013335353436353037313032393330360930e09d245d210100000924b49e245d01025b201620e6c03b1ef367420400000000aa026d00c90e0000100110"));

        verifyAttributes(decoder, binary(
                "ab1845005d39370301100133353836383830303030303338303209245b92b55c84004b610502001000002221ca00050b4a005cc30f4a0056c80f4a003ba90e4a0055c8074a005dc3034a0057c8"));

        verifyAttributes(decoder, binary(
                "ab185c001db78b03011001333538363838303030303033383032092448bd8a5c82003b130502010000003922ca923bad10f794bd30b5c2cb0595b2944a0c49a4f9b6a4b1e9991e79ba0026bb78c08fb4581faae7ee3fb0e091f5778e96b074a78ed46528"));

        verifyNotNull(decoder, binary(
                "ab18ba0339dd89030110013335383638383030303030333830320924b9298a5c940083392221ca0005154a005dc3144a003ba90d4a00876c0d4a00406c0c4a00856c0a4a0056c80924a92a8a5c94003b452221ca0005154a005dc3154a003ba9124a0056c80e4a00876c0d4a00856c064a0057c80924d52b8a5c94007b4e2221ca0005124a005dc31a4a003ba90d4a0056c80d4a005cc30c4a00856c0c4a00406c1931a4298a5c8c050000d02a8a5c7e040000fc2b8a5c422200000924012d8a5c94009b592221ca0005134a005dc3174a003ba9164a0056c8114a00856c104a00406c0f4a0057c809242d2e8a5c9400bb5f2221ca00051a4a005dc3164a003ba9124a0056c8104a00406c0d4a00856c0c4a005cc30924592f8a5c9400bb642221ca00051a4a005dc3154a003ba9114a00406c104a0056c80c4a00856c0c4a005cc3092485308a5c9400bb642221ca00051a4a005dc3154a003ba9114a0056c8104a00406c0c4a005cc30b4a0057c80924b1318a5c9400bb642221ca00051a4a005dc3154a003ba9124a0056c80c4a00856c0b4a005cc30a4a0057c80924dd328a5c9400bb642221ca00051a4a005dc3154a003ba9114a0056c8104a00406c0c4a00856c0b4a005cc30931542e8a5c34440000092409348a5c9400bb642221ca00051a4a005dc3134a003ba9124a0056c80c4a005cc30c4a00856c0a4a0057c8092436358a5c9400bb642221ca00051b4a005dc3164a003ba9124a0056c8114a00406c0c4a00856c0c4a005cc3092462368a5c9400bb642221ca00051b4a005dc3154a003ba9134a0056c80f4a00406c0e4a005cc30c4a00856c09248e378a5c9400bb642221ca00051b4a005dc3174a003ba9134a0056c8104a00406c0e4a005cc30c4a00856c0924ba388a5c9400bb642221ca00051b4a005dc3164a003ba9134a0056c8114a00406c0d4a00856c0c4a0057c80924e6398a5c9400bb642221ca00051b4a005dc3134a0056c8104a00406c0e4a00856c0c4a005cc30a4a0057c80924123b8a5c9400b3642221ca0005194a005dc3184a003ba9134a0056c8104a00406c0d4a00856c0d4a005cc309243e3c8a5c9400bb642221ca00051a4a005dc3164a003ba9114a0056c8104a00406c0e4a00856c0c4a005cc309246a3d8a5c940063642221ca00051a4a005dc3174a003ba9114a00406c0f4a0056c80d4a00856c0c4a0057c80924963e8a5c840083642221ca0005144a005dc31d4a0056c81a4a00d73a174a003ba9164a00856c134a005cc30924c43f8a5c840083632221ca0005164a005cc31b4a0056c8174a003ba9164a006903134a005dc3124a006803"));

    }

}
