package org.traccar.protocol;

import org.junit.Test;
import org.traccar.ProtocolTest;

public class ItsFrameDecoderTest extends ProtocolTest {

    @Test
    public void testDecode() throws Exception {

        ItsFrameDecoder decoder = new ItsFrameDecoder();

        verifyFrame(
                binary("242c2c3836383732383033373731373434312c312e3444335f4149533134305f312e302c56455253494f4e312e302c32382e3633333731372c4e2c37372e3232323730322c45"),
                decoder.decode(null, null, binary("242c2c3836383732383033373731373434312c312e3444335f4149533134305f312e302c56455253494f4e312e302c32382e3633333731372c4e2c37372e3232323730322c45242c43502c41544c2c312e3444335f4149533134305f312e302c49462c30382c4c2c3836383732383033373731373434312c2c312c31373034323031392c3133313830392c32382e3633333731352c4e2c37372e3232323730322c452c302e302c342e30302c302c3231312e302c312e312c362e362c496465612c302c312c31322e362c332e392c302c4f2c31322c3430342c31312c3430612c3564332c326464642c3430612c30392c3438622c3430612c30362c3564342c3430612c30352c6165392c3430612c30352c303131312c30302c3236303831342c662a")));

        verifyFrame(
                binary("244865616465722c69547269616e676c65312c4b41303147313233342c3836343439353033343433343631302c315f333654303242303136344d4149535f362c4149533134302c302e3030303030302c4e2c302e3030303030302c452a3545"),
                decoder.decode(null, null, binary("244865616465722c69547269616e676c65312c4b41303147313233342c3836343439353033343433343631302c315f333654303242303136344d4149535f362c4149533134302c302e3030303030302c4e2c302e3030303030302c452a35450d0a")));

        verifyFrame(
                binary("242c43502c41544c2c312e3444335f4149533134305f312e302c50432c31322c4c2c3836383732383033373731373434312c2c312c31363034323031392c3037333432372c32382e3633333533352c4e2c37372e3232323733332c452c302e302c3333392e30302c302c302e302c312e302c302e372c216465612c302c312c31332e372c332e392c302c4f2c32312c3430342c20342c38382c616433352c616437622c38382c32322c636661612c38382c31362c363666392c38382c31342c336632632c64372c31332c303131312c30302c3236303731312c"),
                decoder.decode(null, null, binary("242c43502c41544c2c312e3444335f4149533134305f312e302c50432c31322c4c2c3836383732383033373731373434312c2c312c31363034323031392c3037333432372c32382e3633333533352c4e2c37372e3232323733332c452c302e302c3333392e30302c302c302e302c312e302c302e372c216465612c302c312c31332e372c332e392c302c4f2c32312c3430342c20342c38382c616433352c616437622c38382c32322c636661612c38382c31362c363666392c38382c31342c336632632c64372c31332c303131312c30302c3236303731312c3a2a2c4f2c532c2b393138373433393530333938")));

        verifyFrame(
                binary("242c43502c41544c2c312e3444335f4149533134305f312e302c45412c31302c482c3836383732383033373731373434312c2c312c32393033323031392c3232353931332c32382e3533343031362c4e2c37372e3236383933362c452c302e302c34382e30302c302c302e302c312e322c302e372c216465612c302c312c31322e362c332e392c312c4f2c32322c3430342c20342c3161612c346230622c643433642c3161612c31352c643433622c3161612c31352c346230632c3161612c31342c346136322c3161612c31322c303131312c30302c3232313333322c"),
                decoder.decode(null, null, binary("242c43502c41544c2c312e3444335f4149533134305f312e302c45412c31302c482c3836383732383033373731373434312c2c312c32393033323031392c3232353931332c32382e3533343031362c4e2c37372e3236383933362c452c302e302c34382e30302c302c302e302c312e322c302e372c216465612c302c312c31322e362c332e392c312c4f2c32322c3430342c20342c3161612c346230622c643433642c3161612c31352c643433622c3161612c31352c346230632c3161612c31342c346136322c3161612c31322c303131312c30302c3232313333322cbc2a")));

        verifyFrame(
                binary("242c43502c41544c2c312e3444335f4149533134305f312e302c45412c31302c482c3836383732383033373731373434312c2c312c32393033323031392c3232353931332c32382e3533343031362c4e2c37372e3236383933362c452c302e302c34382e30302c302c302e302c312e322c302e372c216465612c302c312c31322e362c332e392c312c4f2c32322c3430342c20342c3161612c346230622c643433642c3161612c31352c643433622c3161612c31352c346230632c3161612c31342c346136322c3161612c31322c303131312c30302c3232313333322c"),
                decoder.decode(null, null, binary("242c43502c41544c2c312e3444335f4149533134305f312e302c45412c31302c482c3836383732383033373731373434312c2c312c32393033323031392c3232353931332c32382e3533343031362c4e2c37372e3236383933362c452c302e302c34382e30302c302c302e302c312e322c302e372c216465612c302c312c31322e362c332e392c312c4f2c32322c3430342c20342c3161612c346230622c643433642c3161612c31352c643433622c3161612c31352c346230632c3161612c31342c346136322c3161612c31322c303131312c30302c3232313333322c2a2a")));

        verifyFrame(
                binary("244e524d2c524f41445250412c312e394149532c4e522c30312c4c2c3836393836373033363031353636392c2c312c30383034323031392c3230303530362c32362e39303634353636372c4e2c37352e37383936323333332c452c302e302c3238302e37342c31342c3437312e322c302e38302c302e36302c566f6461666f6e65202d2052616a61737468616e2c302c312c31322e392c342e322c302c4f2c32302c3430342c36302c303746352c333939462c31302c303746352c324434372c31302c303746352c333941312c31302c303746352c324136452c30382c303746352c333536382c303030302c30302c3030333838342c3936443446373031"),
                decoder.decode(null, null, binary("244e524d2c524f41445250412c312e394149532c4e522c30312c4c2c3836393836373033363031353636392c2c312c30383034323031392c3230303530362c32362e39303634353636372c4e2c37352e37383936323333332c452c302e302c3238302e37342c31342c3437312e322c302e38302c302e36302c566f6461666f6e65202d2052616a61737468616e2c302c312c31322e392c342e322c302c4f2c32302c3430342c36302c303746352c333939462c31302c303746352c324434372c31302c303746352c333941312c31302c303746352c324136452c30382c303746352c333536382c303030302c30302c3030333838342c39364434463730312a")));

    }

}
