# Contributing to Traccar

Please make sure you read this guide before commenting on any issue or creating a new issue or pull request.

Before asking anything, please search for an answer in:

- [Traccar documentation](https://www.traccar.org/documentation/)
- [Traccar forums](https://www.traccar.org/forums/)
- Relevant repositories (see below)
- [Google Search](https://www.google.com/)

GitHub issues should be used ONLY for feature requests, code discussions and bug reports. For general discussions please use [Traccar forums](https://www.traccar.org/forums/).

There are multiple Traccar projects. If you create a new issue you MUST do it in the relevant repository:

- [Traccar Server](https://github.com/tananaev/traccar/issues)
- [Traccar Web Interface](https://github.com/tananaev/traccar-web/issues)
- [Traccar Client for Android](https://github.com/tananaev/traccar-client-android/issues)
- [Traccar Client for iOS](https://github.com/tananaev/traccar-client-ios/issues)
- [Traccar Manager for Android](https://github.com/tananaev/traccar-manager-android/issues)
- [Traccar Manager for iOS](https://github.com/tananaev/traccar-manager-ios/issues)

If you are not sure where your issue belongs to, please use Traccar Server main repository.

If you want to discuss something that applies to both Android and iOS apps, please use Android repository.

## Bug Reports

Before creating a bug report make sure that you have tested latest official release with default configuration.

Only create a bug report issue if you are confident that there is a problem in Traccar software.

Provide as much details as possible, including log fragments, operating system and hardware information.

## Feature Requests

Before creating a feature request make sure that the feature or modification that you are requesting is not yet implemented.

Search reposiroty to ensure that there is no existing issues for your request. If there is, add a new comment on that issue.

Provide as much details as possible, including use case for your feature and any benefits that you can think of.

## Pull Requests

If you want to contribute some code to Traccar, it is recommended to discuss your solution with maintainers before starting any work.

Any code that you want to contribute must be of high quality and follow existing code patterns and styles.
