# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv
from tools.translate import _
import wizard
import pooler

#===============================================================================
# Put original wizard because of action in init
# Remove it after solution foraction in init
#===============================================================================

class phonecall2meeting(wizard.interface):

    def _makeMeeting(self, cr, uid, data, context=None):
        pool = pooler.get_pool(cr.dbname)
        phonecall_case_obj = pool.get('crm.phonecall')                   
        data_obj = pool.get('ir.model.data')
        result = data_obj._get_id(cr, uid, 'crm', 'view_crm_case_meetings_filter')
        id = data_obj.read(cr, uid, result, ['res_id'])
        id1 = data_obj._get_id(cr, uid, 'crm', 'crm_case_calendar_view_meet')
        id2 = data_obj._get_id(cr, uid, 'crm', 'crm_case_form_view_meet')
        id3 = data_obj._get_id(cr, uid, 'crm', 'crm_case_tree_view_meet')
        if id1:
            id1 = data_obj.browse(cr, uid, id1, context=context).res_id
        if id2:
            id2 = data_obj.browse(cr, uid, id2, context=context).res_id
        if id3:
            id3 = data_obj.browse(cr, uid, id3, context=context).res_id
        phonecall = phonecall_case_obj.browse(cr, uid, data['id'], context=context)
        partner_id = phonecall.partner_id and phonecall.partner_id.id or False
        name = phonecall.name
        email = phonecall.email_from
        section_id = phonecall.section_id and phonecall.section_id.id or False      
        return {            
            'name': _('Meetings'),
            'domain' : "[('user_id','=',%s)]"%(uid), 
            'context': {'default_partner_id': partner_id, 'default_section_id': section_id, 'default_email_from': email, 'default_state':'open', 'default_name':name},        
            'view_type': 'form',
            'view_mode': 'calendar,form,tree',
            'res_model': 'crm.meeting',
            'view_id': False,
            'views': [(id1,'calendar'),(id2,'form'),(id3,'tree')],
            'type': 'ir.actions.act_window',
            'search_view_id': id['res_id']
            }

    states = {
        'init': {
            'actions': [],
            'result': {'type': 'action', 'action': _makeMeeting, 'state': 'order'}
        },
        'order': {
            'actions': [],
            'result': {'type': 'state', 'state': 'end'}
        }
    }
phonecall2meeting('crm.phonecall.meeting_set')

class crm_phonecall2meeting(osv.osv_memory):
    """ Phonecall to Meeting """

    _name = 'crm.phonecall2meeting'
    _description = 'Phonecall To Meeting'

    def action_cancel(self, cr, uid, ids, context=None):
        """
        Closes Phonecall to Meeting form
        @param self: The object pointer
        @param cr: the current row, from the database cursor,
        @param uid: the current user’s ID for security checks,
        @param ids: List of Phonecall to Meeting IDs
        @param context: A standard dictionary for contextual values

        """
        return {'type':'ir.actions.act_window_close'}

    def action_make_meeting(self, cr, uid, ids, context=None):
        """
        This opens Meeting's calendar view to schedule meeting on current Phonecall
        @param self: The object pointer
        @param cr: the current row, from the database cursor,
        @param uid: the current user’s ID for security checks,
        @param ids: List of Phonecall to Meeting IDs
        @param context: A standard dictionary for contextual values

        @return : Dictionary value for created Meeting view
        """
        value = {}
        record_id = context and context.get('active_id', False) or False

        if record_id:
            phonecall_obj = self.pool.get('crm.phonecall')                   
            data_obj = self.pool.get('ir.model.data')

            # Get meeting views
            result = data_obj._get_id(cr, uid, 'crm', 'view_crm_case_meetings_filter')
            res = data_obj.read(cr, uid, result, ['res_id'])
            id1 = data_obj._get_id(cr, uid, 'crm', 'crm_case_calendar_view_meet')
            id2 = data_obj._get_id(cr, uid, 'crm', 'crm_case_form_view_meet')
            id3 = data_obj._get_id(cr, uid, 'crm', 'crm_case_tree_view_meet')
            if id1:
                id1 = data_obj.browse(cr, uid, id1, context=context).res_id
            if id2:
                id2 = data_obj.browse(cr, uid, id2, context=context).res_id
            if id3:
                id3 = data_obj.browse(cr, uid, id3, context=context).res_id

            phonecall = phonecall_obj.browse(cr, uid, record_id, context=context)
            context = {
                        'default_phonecall_id': phonecall.id, 
                        'default_partner_id': phonecall.partner_id and phonecall.partner_id.id or False, 
                        'default_email': phonecall.email_from , 
                        'default_name': phonecall.name
                    }

            value = {
                'name': _('Meetings'), 
                'domain' : "[('user_id','=',%s)]" % (uid), 
                'context': context, 
                'view_type': 'form', 
                'view_mode': 'calendar,form,tree', 
                'res_model': 'crm.meeting', 
                'view_id': False, 
                'views': [(id1, 'calendar'), (id2, 'form'), (id3, 'tree')], 
                'type': 'ir.actions.act_window', 
                'search_view_id': res['res_id']
                }

        return value

crm_phonecall2meeting()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
