## TFSA-2021-091: Integer overflow in TFLite concatentation

### CVE Number
CVE-2021-29601

### Impact
The TFLite implementation of concatenation is [vulnerable to an integer overflow
issue](https://github.com/tensorflow/tensorflow/blob/7b7352a724b690b11bfaae2cd54bc3907daf6285/tensorflow/lite/kernels/concatenation.cc#L70-L76):

```cc
for (int d = 0; d < t0->dims->size; ++d) {
  if (d == axis) {
    sum_axis += t->dims->data[axis];
  } else {
    TF_LITE_ENSURE_EQ(context, t->dims->data[d], t0->dims->data[d]);
  }
}
```

An attacker can craft a model such that the dimensions of one of the
concatenation input overflow the values of `int`. TFLite uses `int` to represent
tensor dimensions, whereas TF uses `int64`. Hence, valid TF models can trigger
an integer overflow when converted to TFLite format.

### Patches
We have patched the issue in GitHub commit
[4253f96a58486ffe84b61c0415bb234a4632ee73](https://github.com/tensorflow/tensorflow/commit/4253f96a58486ffe84b61c0415bb234a4632ee73).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
