// Copyright 2017 The TensorFlow Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// DO NOT EDIT
// This file was machine generated by github.com/tensorflow/tensorflow/tensorflow/go/genop/internal
//
// WARNING: This generation of wrapper function for TensorFlow ops is in an
// experimental state. The generated API can change without notice.

package op

import tf "github.com/tensorflow/tensorflow/tensorflow/go"

// optionalAttr is an intentionally un-exported type to hide
// details of how optional attributes to operations are implemented.
type optionalAttr map[string]interface{}

func makeOutputList(op *tf.Operation, start int, output string) ([]tf.Output, int, error) {
	size, err := op.OutputListSize(output)
	if err != nil {
		return nil, start, err
	}
	list := make([]tf.Output, size)
	for i := 0; i < size; i++ {
		list[i] = op.Output(start + i)
	}
	return list, start + size, nil
}

// XlaSpmdShardToFullShapeAttr is an optional argument to XlaSpmdShardToFullShape.
type XlaSpmdShardToFullShapeAttr func(optionalAttr)

// XlaSpmdShardToFullShapeDim sets the optional dim attribute to value.
// If not specified, defaults to -1
func XlaSpmdShardToFullShapeDim(value int64) XlaSpmdShardToFullShapeAttr {
	return func(m optionalAttr) {
		m["dim"] = value
	}
}

// XlaSpmdShardToFullShapeUnspecifiedDims sets the optional unspecified_dims attribute to value.
// If not specified, defaults to {}
func XlaSpmdShardToFullShapeUnspecifiedDims(value []int64) XlaSpmdShardToFullShapeAttr {
	return func(m optionalAttr) {
		m["unspecified_dims"] = value
	}
}

// An op used by XLA SPMD partitioner to switch from manual partitioning to
//
// automatic partitioning. It converts the shard-shaped, manually partitioned input
// into full-shaped tensor to be partitioned automatically with the same sharding
// used by manual partitioning. The conversion can happen partially in subgroups,
// by specifying the dim attribute, where only that dim will be converted.
func XlaSpmdShardToFullShape(scope *Scope, input tf.Output, manual_sharding string, full_shape tf.Shape, optional ...XlaSpmdShardToFullShapeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"manual_sharding": manual_sharding, "full_shape": full_shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "XlaSpmdShardToFullShape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps the XLA Sort operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#sort
// .
//
// Sorts a tensor. Currently only sorts in ascending order are supported.
//
// Arguments:
//	input: A `Tensor` of type T.
//
// Returns A `Tensor` of type T.
func XlaSort(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaSort",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Receives the named tensor from another XLA computation. Wraps the XLA Recv
//
// operator documented at
//  https://www.tensorflow.org/performance/xla/operation_semantics#recv .
//
// Arguments:
//	dtype: The type of the tensor.
//	tensor_name: A string key that identifies the channel.
//	shape: The shape of the tensor.
//
// Returns The tensor to receive.
func XlaRecv(scope *Scope, dtype tf.DataType, tensor_name string, shape tf.Shape) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "tensor_name": tensor_name, "shape": shape}
	opspec := tf.OpSpec{
		Type: "XlaRecv",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps the XLA DynamicSlice operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#dynamicslice
// .
//
// DynamicSlice extracts a sub-array from the input array at dynamic
// start_indices. The size of the slice in each dimension is passed in
// size_indices, which specify the end point of exclusive slice intervals in each
// dimension -- [start, start + size). The shape of start_indices must have rank 1,
// with dimension size equal to the rank of operand.
//
// Arguments:
//	input: A `Tensor` of type T.
//	start_indices: List of N integers containing the slice size for each
// dimension. Each value must be strictly greater than zero, and start + size
// must be less than or equal to the size of the dimension to avoid
// implementation defined behavior.
//
func XlaDynamicSlice(scope *Scope, input tf.Output, start_indices tf.Output, size_indices tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaDynamicSlice",
		Input: []tf.Input{
			input, start_indices, size_indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Set a bound for the given input value as a hint to Xla compiler,
//
//         returns the same value.
func XlaSetBound(scope *Scope, input tf.Output, bound tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaSetBound",
		Input: []tf.Input{
			input, bound,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps the XLA DotGeneral operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#dotgeneral
// .
//
// Arguments:
//	lhs: the LHS tensor
//	rhs: the RHS tensor
//	dimension_numbers: a serialized xla::DotDimensionNumbers proto.
//	precision_config: a serialized xla::PrecisionConfig proto.
func XlaDot(scope *Scope, lhs tf.Output, rhs tf.Output, dimension_numbers string, precision_config string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dimension_numbers": dimension_numbers, "precision_config": precision_config}
	opspec := tf.OpSpec{
		Type: "XlaDot",
		Input: []tf.Input{
			lhs, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Output a fact about factorials.
func Fact(scope *Scope) (fact tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fact",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxVarsGradientAttr is an optional argument to FakeQuantWithMinMaxVarsGradient.
type FakeQuantWithMinMaxVarsGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsGradientNumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization; between 2 and 8, inclusive.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsGradientNumBits(value int64) FakeQuantWithMinMaxVarsGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsGradientNarrowRange sets the optional narrow_range attribute to value.
//
// value: Whether to quantize into 2^num_bits - 1 distinct values.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsGradientNarrowRange(value bool) FakeQuantWithMinMaxVarsGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxVars operation.
//
// Arguments:
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxVars operation.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxVars operation.
// min, max: Quantization interval, scalar floats.
//
//
//
// Returns:
//	backprops_wrt_input: Backpropagated gradients w.r.t. inputs:
// `gradients * (inputs >= min && inputs <= max)`.
//	backprop_wrt_min: Backpropagated gradients w.r.t. min parameter:
// `sum(gradients * (inputs < min))`.
//	backprop_wrt_max: Backpropagated gradients w.r.t. max parameter:
// `sum(gradients * (inputs > max))`.
func FakeQuantWithMinMaxVarsGradient(scope *Scope, gradients tf.Output, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsGradientAttr) (backprops_wrt_input tf.Output, backprop_wrt_min tf.Output, backprop_wrt_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsGradient",
		Input: []tf.Input{
			gradients, inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes the eigen decomposition of a batch of self-adjoint matrices
//
// (Note: Only real inputs are supported).
//
// Computes the eigenvalues and eigenvectors of the innermost M-by-N matrices in
// tensor such that tensor[...,:,:] = u[..., :, :] * Diag(s[..., :]) * Transpose(v[...,:,:]).
//
// Arguments:
//	a: the input tensor.
//	max_iter: maximum number of sweep update, i.e., the whole lower triangular
// part or upper triangular part based on parameter lower. Heuristically, it has
// been argued that approximately log(min (M, N)) sweeps are needed in practice
// (Ref: Golub & van Loan "Matrix Computation").
//	epsilon: the tolerance ratio.
//	precision_config: a serialized xla::PrecisionConfig proto.
//
// Returns:
//	s: Singular values. The values are sorted in reverse order of magnitude, so
// s[..., 0] is the largest value, s[..., 1] is the second largest, etc.
//	u: Left singular vectors.
//	v: Right singular vectors.
func XlaSvd(scope *Scope, a tf.Output, max_iter int64, epsilon float32, precision_config string) (s tf.Output, u tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_iter": max_iter, "epsilon": epsilon, "precision_config": precision_config}
	opspec := tf.OpSpec{
		Type: "XlaSvd",
		Input: []tf.Input{
			a,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// FakeQuantWithMinMaxArgsGradientAttr is an optional argument to FakeQuantWithMinMaxArgsGradient.
type FakeQuantWithMinMaxArgsGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxArgsGradientMin sets the optional min attribute to value.
// If not specified, defaults to -6
func FakeQuantWithMinMaxArgsGradientMin(value float32) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["min"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientMax sets the optional max attribute to value.
// If not specified, defaults to 6
func FakeQuantWithMinMaxArgsGradientMax(value float32) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["max"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxArgsGradientNumBits(value int64) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxArgsGradientNarrowRange(value bool) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxArgs operation.
//
// Arguments:
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxArgs operation.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxArgs operation.
//
// Returns Backpropagated gradients below the FakeQuantWithMinMaxArgs operation:
// `gradients * (inputs >= min && inputs <= max)`.
func FakeQuantWithMinMaxArgsGradient(scope *Scope, gradients tf.Output, inputs tf.Output, optional ...FakeQuantWithMinMaxArgsGradientAttr) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxArgsGradient",
		Input: []tf.Input{
			gradients, inputs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Helper operator for performing XLA-style broadcasts
//
// Broadcasts `lhs` and `rhs` to the same rank, by adding size 1 dimensions to
// whichever of `lhs` and `rhs` has the lower rank, using XLA's broadcasting rules
// for binary operators.
//
// Arguments:
//	lhs: the LHS input tensor
//	rhs: the RHS input tensor
//	broadcast_dims: an XLA-style broadcast dimension specification
//
// Returns:
//	lhs_output: the broadcasted LHS tensor
//	rhs_output: the broadcasted RHS tensor
func XlaBroadcastHelper(scope *Scope, lhs tf.Output, rhs tf.Output, broadcast_dims tf.Output) (lhs_output tf.Output, rhs_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaBroadcastHelper",
		Input: []tf.Input{
			lhs, rhs, broadcast_dims,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Subtracts sparse `updates` from an existing tensor according to `indices`.
//
// This operation creates a new tensor by subtracting sparse `updates` from the
// passed in `tensor`.
// This operation is very similar to `tf.scatter_nd_sub`, except that the updates
// are subtracted from an existing tensor (as opposed to a variable). If the memory
// for the existing tensor cannot be re-used, a copy is made and updated.
//
// `indices` is an integer tensor containing indices into a new tensor of shape
// `shape`.  The last dimension of `indices` can be at most the rank of `shape`:
//
//     indices.shape[-1] <= shape.rank
//
// The last dimension of `indices` corresponds to indices into elements
// (if `indices.shape[-1] = shape.rank`) or slices
// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
// `shape`.  `updates` is a tensor with shape
//
//     indices.shape[:-1] + shape[indices.shape[-1]:]
//
// The simplest form of tensor_scatter_sub is to subtract individual elements
// from a tensor by index. For example, say we want to insert 4 scattered elements
// in a rank-1 tensor with 8 elements.
//
// In Python, this scatter subtract operation would look like this:
//
// ```python
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     tensor = tf.ones([8], dtype=tf.int32)
//     updated = tf.tensor_scatter_nd_sub(tensor, indices, updates)
//     print(updated)
// ```
//
// The resulting tensor would look like this:
//
//     [1, -10, 1, -9, -8, 1, 1, -11]
//
// We can also, insert entire slices of a higher rank tensor all at once. For
// example, if we wanted to insert two slices in the first dimension of a
// rank-3 tensor with two matrices of new values.
//
// In Python, this scatter add operation would look like this:
//
// ```python
//     indices = tf.constant([[0], [2]])
//     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]],
//                            [[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]]])
//     tensor = tf.ones([4, 4, 4],dtype=tf.int32)
//     updated = tf.tensor_scatter_nd_sub(tensor, indices, updates)
//     print(updated)
// ```
//
// The resulting tensor would look like this:
//
//     [[[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
//      [[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, the index is ignored.
//
// Arguments:
//	tensor: Tensor to copy/update.
//	indices: Index tensor.
//	updates: Updates to scatter into output.
//
// Returns A new tensor copied from tensor and updates subtracted according to the indices.
func TensorScatterSub(scope *Scope, tensor tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorScatterSub",
		Input: []tf.Input{
			tensor, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds sparse `updates` to an existing tensor according to `indices`.
//
// This operation creates a new tensor by adding sparse `updates` to the passed
// in `tensor`.
// This operation is very similar to `tf.compat.v1.scatter_nd_add`, except that the updates
// are added onto an existing tensor (as opposed to a variable). If the memory
// for the existing tensor cannot be re-used, a copy is made and updated.
//
// `indices` is an integer tensor containing indices into a new tensor of shape
// `tensor.shape`.  The last dimension of `indices` can be at most the rank of
// `tensor.shape`:
//
//     indices.shape[-1] <= tensor.shape.rank
//
// The last dimension of `indices` corresponds to indices into elements
// (if `indices.shape[-1] = tensor.shape.rank`) or slices
// (if `indices.shape[-1] < tensor.shape.rank`) along dimension
// `indices.shape[-1]` of `tensor.shape`.  `updates` is a tensor with shape
//
//     indices.shape[:-1] + tensor.shape[indices.shape[-1]:]
//
// The simplest form of tensor_scatter_add is to add individual elements to a
// tensor by index. For example, say we want to add 4 elements in a rank-1
// tensor with 8 elements.
//
// In Python, this scatter add operation would look like this:
//
// ```python
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     tensor = tf.ones([8], dtype=tf.int32)
//     updated = tf.tensor_scatter_nd_add(tensor, indices, updates)
//     print(updated)
// ```
//
// The resulting tensor would look like this:
//
//     [1, 12, 1, 11, 10, 1, 1, 13]
//
// We can also, insert entire slices of a higher rank tensor all at once. For
// example, if we wanted to insert two slices in the first dimension of a
// rank-3 tensor with two matrices of new values.
//
// In Python, this scatter add operation would look like this:
//
// ```python
//     indices = tf.constant([[0], [2]])
//     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]],
//                            [[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]]])
//     tensor = tf.ones([4, 4, 4],dtype=tf.int32)
//     updated = tf.tensor_scatter_nd_add(tensor, indices, updates)
//     print(updated)
// ```
//
// The resulting tensor would look like this:
//
//     [[[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
//      [[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, the index is ignored.
//
// Arguments:
//	tensor: Tensor to copy/update.
//	indices: Index tensor.
//	updates: Updates to scatter into output.
//
// Returns A new tensor copied from tensor and updates added according to the indices.
func TensorScatterAdd(scope *Scope, tensor tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorScatterAdd",
		Input: []tf.Input{
			tensor, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reshapes a quantized tensor as per the Reshape op.
//
// ```
//
// Arguments:
//
//	shape: Defines the shape of the output tensor.
//	input_min: The minimum value of the input.
//	input_max: The maximum value of the input.
//
// Returns:
//	output
//	output_min: This value is copied from input_min.
//	output_max: This value is copied from input_max.
func QuantizedReshape(scope *Scope, tensor tf.Output, shape tf.Output, input_min tf.Output, input_max tf.Output) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "QuantizedReshape",
		Input: []tf.Input{
			tensor, shape, input_min, input_max,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizeAndDequantizeV4GradAttr is an optional argument to QuantizeAndDequantizeV4Grad.
type QuantizeAndDequantizeV4GradAttr func(optionalAttr)

// QuantizeAndDequantizeV4GradAxis sets the optional axis attribute to value.
// If not specified, defaults to -1
func QuantizeAndDequantizeV4GradAxis(value int64) QuantizeAndDequantizeV4GradAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Returns the gradient of `QuantizeAndDequantizeV4`.
//
// Returns a gradient of 1 for inputs that are within the quantization range,
// or 0 otherwise.
func QuantizeAndDequantizeV4Grad(scope *Scope, gradients tf.Output, input tf.Output, input_min tf.Output, input_max tf.Output, optional ...QuantizeAndDequantizeV4GradAttr) (input_backprop tf.Output, input_min_backprop tf.Output, input_max_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeAndDequantizeV4Grad",
		Input: []tf.Input{
			gradients, input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizeAndDequantizeV2Attr is an optional argument to QuantizeAndDequantizeV2.
type QuantizeAndDequantizeV2Attr func(optionalAttr)

// QuantizeAndDequantizeV2SignedInput sets the optional signed_input attribute to value.
//
// value: Whether the quantization is signed or unsigned. (actually this parameter should
// have been called <b>`signed_output`</b>)
// If not specified, defaults to true
func QuantizeAndDequantizeV2SignedInput(value bool) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["signed_input"] = value
	}
}

// QuantizeAndDequantizeV2NumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization.
// If not specified, defaults to 8
func QuantizeAndDequantizeV2NumBits(value int64) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// QuantizeAndDequantizeV2RangeGiven sets the optional range_given attribute to value.
//
// value: Whether the range is given or should be determined from the `input` tensor.
// If not specified, defaults to false
func QuantizeAndDequantizeV2RangeGiven(value bool) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["range_given"] = value
	}
}

// QuantizeAndDequantizeV2RoundMode sets the optional round_mode attribute to value.
//
// value: The 'round_mode' attribute controls which rounding tie-breaking algorithm is
// used when rounding float values to their quantized equivalents. The following
// rounding modes are currently supported:
//
// *   HALF_TO_EVEN: this is the default round_mode.
// *   HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
//     rounds up to -7.
//
// If not specified, defaults to "HALF_TO_EVEN"
func QuantizeAndDequantizeV2RoundMode(value string) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["round_mode"] = value
	}
}

// QuantizeAndDequantizeV2NarrowRange sets the optional narrow_range attribute to value.
//
// value: If True, then the absolute value of the quantized minimum value is the same as
// the quantized maximum value, instead of 1 greater.
// i.e. for 8 bit quantization, the minimum value is -127 instead of -128.
// If not specified, defaults to false
func QuantizeAndDequantizeV2NarrowRange(value bool) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// QuantizeAndDequantizeV2Axis sets the optional axis attribute to value.
//
// value: If specified, this axis is treated as a channel or slice axis, and a separate
// quantization range is used for each channel or slice along this axis.
// If not specified, defaults to -1
func QuantizeAndDequantizeV2Axis(value int64) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Quantizes then dequantizes a tensor.
//
// This op simulates the precision loss from the quantized forward pass by:
//
// 1. Quantizing the tensor to fixed point numbers, which should match the target
//    quantization method when it is used in inference.
// 2. Dequantizing it back to floating point numbers for the following ops, most
//    likely matmul.
//
// There are different ways to quantize. This version uses only scaling, so 0.0
// maps to 0.
//
// From the specified 'num_bits' in the quantized output type, it determines
// minimum and maximum representable quantized values.
//
// e.g.
//
// *   [-128, 127] for signed, num_bits = 8, or
// *   [0, 255] for unsigned, num_bits = 8.
//
// If range_given == False, the initial input_min, input_max will be determined
// automatically as the minimum and maximum values in the input tensor, otherwise
// the specified values of input_min, input_max are used.
//
// Note: If the input_min, input_max are specified, they do not need to equal the
// actual minimum and maximum values in the tensor. e.g. in some cases it may be
// beneficial to specify these values such that the low probability extremes of the
// input distribution are clipped.
//
// This op determines the maximum scale_factor that would map the initial
// [input_min, input_max] range to a range that lies within the representable
// quantized range.
//
// It determines the scale from one of input_min and input_max, then updates the
// other one to maximize the representable range.
//
// e.g.
//
// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
//     5.0]: it would use a scale_factor of -128 / -10.0 = 12.8 In this case, it
//     would update input_max to be 127 / 12.8 = 9.921875
// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
//     10.0]: it would use a scale_factor of 127 / 10.0 = 12.7 In this case, it
//     would update input_min to be 128.0 / 12.7 = -10.07874
// *   if the output is unsigned, input_min is forced to be 0, and only the
//     specified input_max is used.
//
// After determining the scale_factor and updating the input range, it applies the
// following to each value in the 'input' tensor.
//
// output = round(clamp(value, input_min, input_max) * scale_factor) / scale_factor.
//
// The above round function rounds the value based on the given round_mode.
//
//
// Arguments:
//	input: Tensor to quantize and then dequantize.
//	input_min: If `range_given == True`, this specifies the minimum input value that needs to
// be represented, otherwise it is determined from the min value of the `input`
// tensor.
//	input_max: If `range_given == True`, this specifies the maximum input value that needs to
// be represented, otherwise it is determined from the max value of the `input`
// tensor.
func QuantizeAndDequantizeV2(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, optional ...QuantizeAndDequantizeV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeAndDequantizeV2",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizeAndDequantizeAttr is an optional argument to QuantizeAndDequantize.
type QuantizeAndDequantizeAttr func(optionalAttr)

// QuantizeAndDequantizeSignedInput sets the optional signed_input attribute to value.
// If not specified, defaults to true
func QuantizeAndDequantizeSignedInput(value bool) QuantizeAndDequantizeAttr {
	return func(m optionalAttr) {
		m["signed_input"] = value
	}
}

// QuantizeAndDequantizeNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func QuantizeAndDequantizeNumBits(value int64) QuantizeAndDequantizeAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// QuantizeAndDequantizeRangeGiven sets the optional range_given attribute to value.
// If not specified, defaults to false
func QuantizeAndDequantizeRangeGiven(value bool) QuantizeAndDequantizeAttr {
	return func(m optionalAttr) {
		m["range_given"] = value
	}
}

// QuantizeAndDequantizeInputMin sets the optional input_min attribute to value.
// If not specified, defaults to 0
func QuantizeAndDequantizeInputMin(value float32) QuantizeAndDequantizeAttr {
	return func(m optionalAttr) {
		m["input_min"] = value
	}
}

// QuantizeAndDequantizeInputMax sets the optional input_max attribute to value.
// If not specified, defaults to 0
func QuantizeAndDequantizeInputMax(value float32) QuantizeAndDequantizeAttr {
	return func(m optionalAttr) {
		m["input_max"] = value
	}
}

// Use QuantizeAndDequantizeV2 instead.
//
// DEPRECATED at GraphDef version 22: Replaced by QuantizeAndDequantizeV2
func QuantizeAndDequantize(scope *Scope, input tf.Output, optional ...QuantizeAndDequantizeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeAndDequantize",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OneHotAttr is an optional argument to OneHot.
type OneHotAttr func(optionalAttr)

// OneHotAxis sets the optional axis attribute to value.
//
// value: The axis to fill (default: -1, a new inner-most axis).
// If not specified, defaults to -1
func OneHotAxis(value int64) OneHotAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Returns a one-hot tensor.
//
// The locations represented by indices in `indices` take value `on_value`,
// while all other locations take value `off_value`.
//
// If the input `indices` is rank `N`, the output will have rank `N+1`,
// The new axis is created at dimension `axis` (default: the new axis is
// appended at the end).
//
// If `indices` is a scalar the output shape will be a vector of length `depth`.
//
// If `indices` is a vector of length `features`, the output shape will be:
// ```
//   features x depth if axis == -1
//   depth x features if axis == 0
// ```
//
// If `indices` is a matrix (batch) with shape `[batch, features]`,
// the output shape will be:
// ```
//   batch x features x depth if axis == -1
//   batch x depth x features if axis == 1
//   depth x batch x features if axis == 0
// ```
//
//
// Examples
// =========
//
// Suppose that
// ```
//   indices = [0, 2, -1, 1]
//   depth = 3
//   on_value = 5.0
//   off_value = 0.0
//   axis = -1
// ```
//
// Then output is `[4 x 3]`:
// ```
// output =
//   [5.0 0.0 0.0]  // one_hot(0)
//   [0.0 0.0 5.0]  // one_hot(2)
//   [0.0 0.0 0.0]  // one_hot(-1)
//   [0.0 5.0 0.0]  // one_hot(1)
// ```
//
// Suppose that
// ```
//   indices = [0, 2, -1, 1]
//   depth = 3
//   on_value = 0.0
//   off_value = 3.0
//   axis = 0
// ```
//
// Then output is `[3 x 4]`:
// ```
// output =
//   [0.0 3.0 3.0 3.0]
//   [3.0 3.0 3.0 0.0]
//   [3.0 3.0 3.0 3.0]
//   [3.0 0.0 3.0 3.0]
// //  ^                one_hot(0)
// //      ^            one_hot(2)
// //          ^        one_hot(-1)
// //              ^    one_hot(1)
// ```
//
// Suppose that
// ```
//   indices = [[0, 2], [1, -1]]
//   depth = 3
//   on_value = 1.0
//   off_value = 0.0
//   axis = -1
// ```
//
// Then output is `[2 x 2 x 3]`:
// ```
// output =
//   [
//     [1.0, 0.0, 0.0]  // one_hot(0)
//     [0.0, 0.0, 1.0]  // one_hot(2)
//   ][
//     [0.0, 1.0, 0.0]  // one_hot(1)
//     [0.0, 0.0, 0.0]  // one_hot(-1)
//   ]
// ```
//
// Arguments:
//	indices: A tensor of indices.
//	depth: A scalar defining the depth of the one hot dimension.
//	on_value: A scalar defining the value to fill in output when `indices[j] = i`.
//	off_value: A scalar defining the value to fill in output when `indices[j] != i`.
//
// Returns The one-hot tensor.
func OneHot(scope *Scope, indices tf.Output, depth tf.Output, on_value tf.Output, off_value tf.Output, optional ...OneHotAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OneHot",
		Input: []tf.Input{
			indices, depth, on_value, off_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Extract `patches` from `input` and put them in the `"depth"` output dimension. 3D extension of `extract_image_patches`.
//
// Arguments:
//	input: 5-D Tensor with shape `[batch, in_planes, in_rows, in_cols, depth]`.
//	ksizes: The size of the sliding window for each dimension of `input`.
//	strides: 1-D of length 5. How far the centers of two consecutive patches are in
// `input`. Must be: `[1, stride_planes, stride_rows, stride_cols, 1]`.
//	padding: The type of padding algorithm to use.
//
// The size-related attributes are specified as follows:
//
// ```python
// ksizes = [1, ksize_planes, ksize_rows, ksize_cols, 1]
// strides = [1, stride_planes, strides_rows, strides_cols, 1]
// ```
//
// Returns 5-D Tensor with shape `[batch, out_planes, out_rows, out_cols,
// ksize_planes * ksize_rows * ksize_cols * depth]` containing patches
// with size `ksize_planes x ksize_rows x ksize_cols x depth` vectorized
// in the "depth" dimension. Note `out_planes`, `out_rows` and `out_cols`
// are the dimensions of the output patches.
func ExtractVolumePatches(scope *Scope, input tf.Output, ksizes []int64, strides []int64, padding string) (patches tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksizes": ksizes, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "ExtractVolumePatches",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthToSpaceAttr is an optional argument to DepthToSpace.
type DepthToSpaceAttr func(optionalAttr)

// DepthToSpaceDataFormat sets the optional data_format attribute to value.
// If not specified, defaults to "NHWC"
func DepthToSpaceDataFormat(value string) DepthToSpaceAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthToSpace for tensors of type T.
//
// Rearranges data from depth into blocks of spatial data.
// This is the reverse transformation of SpaceToDepth. More specifically,
// this op outputs a copy of the input tensor where values from the `depth`
// dimension are moved in spatial blocks to the `height` and `width` dimensions.
// The attr `block_size` indicates the input block size and how the data is moved.
//
//   * Chunks of data of size `block_size * block_size` from depth are rearranged
//     into non-overlapping blocks of size `block_size x block_size`
//   * The width the output tensor is `input_depth * block_size`, whereas the
//     height is `input_height * block_size`.
//   * The Y, X coordinates within each block of the output image are determined
//     by the high order component of the input channel index.
//   * The depth of the input tensor must be divisible by
//     `block_size * block_size`.
//
// The `data_format` attr specifies the layout of the input and output tensors
// with the following options:
//   "NHWC": `[ batch, height, width, channels ]`
//   "NCHW": `[ batch, channels, height, width ]`
//   "NCHW_VECT_C":
//       `qint8 [ batch, channels / 4, height, width, 4 ]`
//
// It is useful to consider the operation as transforming a 6-D Tensor.
// e.g. for data_format = NHWC,
//      Each element in the input tensor can be specified via 6 coordinates,
//      ordered by decreasing memory layout significance as:
//      n,iY,iX,bY,bX,oC  (where n=batch index, iX, iY means X or Y coordinates
//                         within the input image, bX, bY means coordinates
//                         within the output block, oC means output channels).
//      The output would be the input transposed to the following layout:
//      n,iY,bY,iX,bX,oC
//
// This operation is useful for resizing the activations between convolutions
// (but keeping all data), e.g. instead of pooling. It is also useful for training
// purely convolutional models.
//
// For example, given an input of shape `[1, 1, 1, 4]`, data_format = "NHWC" and
// block_size = 2:
//
// ```
// x = [[[[1, 2, 3, 4]]]]
//
// ```
//
// This operation will output a tensor of shape `[1, 2, 2, 1]`:
//
// ```
//    [[[[1], [2]],
//      [[3], [4]]]]
// ```
//
// Here, the input has a batch of 1 and each batch element has shape `[1, 1, 4]`,
// the corresponding output will have 2x2 elements and will have a depth of
// 1 channel (1 = `4 / (block_size * block_size)`).
// The output element shape is `[2, 2, 1]`.
//
// For an input tensor with larger depth, here of shape `[1, 1, 1, 12]`, e.g.
//
// ```
// x = [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
// ```
//
// This operation, for block size of 2, will return the following tensor of shape
// `[1, 2, 2, 3]`
//
// ```
//    [[[[1, 2, 3], [4, 5, 6]],
//      [[7, 8, 9], [10, 11, 12]]]]
//
// ```
//
// Similarly, for the following input of shape `[1 2 2 4]`, and a block size of 2:
//
// ```
// x =  [[[[1, 2, 3, 4],
//        [5, 6, 7, 8]],
//       [[9, 10, 11, 12],
//        [13, 14, 15, 16]]]]
// ```
//
// the operator will return the following tensor of shape `[1 4 4 1]`:
//
// ```
// x = [[[ [1],   [2],  [5],  [6]],
//       [ [3],   [4],  [7],  [8]],
//       [ [9],  [10], [13],  [14]],
//       [ [11], [12], [15],  [16]]]]
//
// ```
//
// Arguments:
//
//	block_size: The size of the spatial block, same as in Space2Depth.
func DepthToSpace(scope *Scope, input tf.Output, block_size int64, optional ...DepthToSpaceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthToSpace",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SpaceToDepthAttr is an optional argument to SpaceToDepth.
type SpaceToDepthAttr func(optionalAttr)

// SpaceToDepthDataFormat sets the optional data_format attribute to value.
// If not specified, defaults to "NHWC"
func SpaceToDepthDataFormat(value string) SpaceToDepthAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// SpaceToDepth for tensors of type T.
//
// Rearranges blocks of spatial data, into depth. More specifically,
// this op outputs a copy of the input tensor where values from the `height`
// and `width` dimensions are moved to the `depth` dimension.
// The attr `block_size` indicates the input block size.
//
//   * Non-overlapping blocks of size `block_size x block size` are rearranged
//     into depth at each location.
//   * The depth of the output tensor is `block_size * block_size * input_depth`.
//   * The Y, X coordinates within each block of the input become the high order
//     component of the output channel index.
//   * The input tensor's height and width must be divisible by block_size.
//
// The `data_format` attr specifies the layout of the input and output tensors
// with the following options:
//   "NHWC": `[ batch, height, width, channels ]`
//   "NCHW": `[ batch, channels, height, width ]`
//   "NCHW_VECT_C":
//       `qint8 [ batch, channels / 4, height, width, 4 ]`
//
// It is useful to consider the operation as transforming a 6-D Tensor.
// e.g. for data_format = NHWC,
//      Each element in the input tensor can be specified via 6 coordinates,
//      ordered by decreasing memory layout significance as:
//      n,oY,bY,oX,bX,iC  (where n=batch index, oX, oY means X or Y coordinates
//                         within the output image, bX, bY means coordinates
//                         within the input block, iC means input channels).
//      The output would be a transpose to the following layout:
//      n,oY,oX,bY,bX,iC
//
// This operation is useful for resizing the activations between convolutions
// (but keeping all data), e.g. instead of pooling. It is also useful for training
// purely convolutional models.
//
// For example, given an input of shape `[1, 2, 2, 1]`, data_format = "NHWC" and
// block_size = 2:
//
// ```
// x = [[[[1], [2]],
//       [[3], [4]]]]
// ```
//
// This operation will output a tensor of shape `[1, 1, 1, 4]`:
//
// ```
// [[[[1, 2, 3, 4]]]]
// ```
//
// Here, the input has a batch of 1 and each batch element has shape `[2, 2, 1]`,
// the corresponding output will have a single element (i.e. width and height are
// both 1) and will have a depth of 4 channels (1 * block_size * block_size).
// The output element shape is `[1, 1, 4]`.
//
// For an input tensor with larger depth, here of shape `[1, 2, 2, 3]`, e.g.
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// This operation, for block_size of 2, will return the following tensor of shape
// `[1, 1, 1, 12]`
//
// ```
// [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
// ```
//
// Similarly, for the following input of shape `[1 4 4 1]`, and a block size of 2:
//
// ```
// x = [[[[1],   [2],  [5],  [6]],
//       [[3],   [4],  [7],  [8]],
//       [[9],  [10], [13],  [14]],
//       [[11], [12], [15],  [16]]]]
// ```
//
// the operator will return the following tensor of shape `[1 2 2 4]`:
//
// ```
// x = [[[[1, 2, 3, 4],
//        [5, 6, 7, 8]],
//       [[9, 10, 11, 12],
//        [13, 14, 15, 16]]]]
// ```
//
// Arguments:
//
//	block_size: The size of the spatial block.
func SpaceToDepth(scope *Scope, input tf.Output, block_size int64, optional ...SpaceToDepthAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SpaceToDepth",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchToSpace for 4-D tensors of type T.
//
// This is a legacy version of the more general BatchToSpaceND.
//
// Rearranges (permutes) data from batch into blocks of spatial data, followed by
// cropping. This is the reverse transformation of SpaceToBatch. More specifically,
// this op outputs a copy of the input tensor where values from the `batch`
// dimension are moved in spatial blocks to the `height` and `width` dimensions,
// followed by cropping along the `height` and `width` dimensions.
//
// Arguments:
//	input: 4-D tensor with shape
// `[batch*block_size*block_size, height_pad/block_size, width_pad/block_size,
//   depth]`. Note that the batch size of the input tensor must be divisible by
// `block_size * block_size`.
//	crops: 2-D tensor of non-negative integers with shape `[2, 2]`. It specifies
// how many elements to crop from the intermediate result across the spatial
// dimensions as follows:
//
//     crops = [[crop_top, crop_bottom], [crop_left, crop_right]]
//
//
// Returns 4-D with shape `[batch, height, width, depth]`, where:
//
//       height = height_pad - crop_top - crop_bottom
//       width = width_pad - crop_left - crop_right
//
// The attr `block_size` must be greater than one. It indicates the block size.
//
// Some examples:
//
// (1) For the following input of shape `[4, 1, 1, 1]` and block_size of 2:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// (2) For the following input of shape `[4, 1, 1, 3]` and block_size of 2:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 3]` and value:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[4, 2, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// The output tensor has shape `[1, 4, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//      [[5],   [6],  [7],  [8]],
//      [[9],  [10], [11],  [12]],
//      [[13], [14], [15],  [16]]]]
// ```
//
// (4) For the following input of shape `[8, 1, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [3]]], [[[9], [11]]], [[[2], [4]]], [[[10], [12]]],
//      [[[5], [7]]], [[[13], [15]]], [[[6], [8]]], [[[14], [16]]]]
// ```
//
// The output tensor has shape `[2, 2, 4, 1]` and value:
//
// ```
// x = [[[[1], [3]], [[5], [7]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
func BatchToSpace(scope *Scope, input tf.Output, crops tf.Output, block_size int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	opspec := tf.OpSpec{
		Type: "BatchToSpace",
		Input: []tf.Input{
			input, crops,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SpaceToBatch for 4-D tensors of type T.
//
// This is a legacy version of the more general SpaceToBatchND.
//
// Zero-pads and then rearranges (permutes) blocks of spatial data into batch.
// More specifically, this op outputs a copy of the input tensor where values from
// the `height` and `width` dimensions are moved to the `batch` dimension. After
// the zero-padding, both `height` and `width` of the input must be divisible by the
// block size.
//
// The attr `block_size` must be greater than one. It indicates the block size.
//
//   * Non-overlapping blocks of size `block_size x block size` in the height and
//     width dimensions are rearranged into the batch dimension at each location.
//   * The batch of the output tensor is `batch * block_size * block_size`.
//   * Both height_pad and width_pad must be divisible by block_size.
//
// The shape of the output will be:
//
//     [batch*block_size*block_size, height_pad/block_size, width_pad/block_size,
//      depth]
//
// Some examples:
//
// (1) For the following input of shape `[1, 2, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 1]` and value:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// (2) For the following input of shape `[1, 2, 2, 3]` and block_size of 2:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 3]` and value:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[1, 4, 4, 1]` and block_size of 2:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]],
//       [[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[4, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// (4) For the following input of shape `[2, 2, 4, 1]` and block_size of 2:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]]],
//      [[[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[8, 1, 2, 1]` and value:
//
// ```
// x = [[[[1], [3]]], [[[9], [11]]], [[[2], [4]]], [[[10], [12]]],
//      [[[5], [7]]], [[[13], [15]]], [[[6], [8]]], [[[14], [16]]]]
// ```
//
// Among others, this operation is useful for reducing atrous convolution into
// regular convolution.
//
// Arguments:
//	input: 4-D with shape `[batch, height, width, depth]`.
//	paddings: 2-D tensor of non-negative integers with shape `[2, 2]`. It specifies
//   the padding of the input with zeros across the spatial dimensions as follows:
//
//       paddings = [[pad_top, pad_bottom], [pad_left, pad_right]]
//
//   The effective spatial dimensions of the zero-padded input tensor will be:
//
//       height_pad = pad_top + height + pad_bottom
//       width_pad = pad_left + width + pad_right
//
func SpaceToBatch(scope *Scope, input tf.Output, paddings tf.Output, block_size int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	opspec := tf.OpSpec{
		Type: "SpaceToBatch",
		Input: []tf.Input{
			input, paddings,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SqueezeAttr is an optional argument to Squeeze.
type SqueezeAttr func(optionalAttr)

// SqueezeAxis sets the optional axis attribute to value.
//
// value: If specified, only squeezes the dimensions listed. The dimension
// index starts at 0. It is an error to squeeze a dimension that is not 1. Must
// be in the range `[-rank(input), rank(input))`.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func SqueezeAxis(value []int64) SqueezeAttr {
	return func(m optionalAttr) {
		m["squeeze_dims"] = value
	}
}

// Removes dimensions of size 1 from the shape of a tensor.
//
// Given a tensor `input`, this operation returns a tensor of the same type with
// all dimensions of size 1 removed. If you don't want to remove all size 1
// dimensions, you can remove specific size 1 dimensions by specifying
// `axis`.
//
// For example:
//
// ```
// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
// shape(squeeze(t)) ==> [2, 3]
// ```
//
// Or, to remove specific size 1 dimensions:
//
// ```
// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
// shape(squeeze(t, [2, 4])) ==> [1, 2, 3, 1]
// ```
//
// Arguments:
//	input: The `input` to squeeze.
//
// Returns Contains the same data as `input`, but has one or more dimensions of
// size 1 removed.
func Squeeze(scope *Scope, input tf.Output, optional ...SqueezeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Squeeze",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A placeholder op that passes through `input` when its output is not fed.
//
// Arguments:
//	input: The default value to produce when `output` is not fed.
//	shape: The (possibly partial) shape of the tensor.
//
// Returns A placeholder tensor that defaults to `input` if it is not fed.
func PlaceholderWithDefault(scope *Scope, input tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "PlaceholderWithDefault",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PlaceholderAttr is an optional argument to Placeholder.
type PlaceholderAttr func(optionalAttr)

// PlaceholderShape sets the optional shape attribute to value.
//
// value: (Optional) The shape of the tensor. If the shape has 0 dimensions, the
// shape is unconstrained.
// If not specified, defaults to {unknown_rank:true}
func PlaceholderShape(value tf.Shape) PlaceholderAttr {
	return func(m optionalAttr) {
		m["shape"] = value
	}
}

// A placeholder op for a value that will be fed into the computation.
//
// N.B. This operation will fail with an error if it is executed. It is
// intended as a way to represent a value that will always be fed, and to
// provide attrs that enable the fed value to be checked at runtime.
//
// Arguments:
//	dtype: The type of elements in the tensor.
//
// Returns A placeholder tensor that must be replaced using the feed mechanism.
func Placeholder(scope *Scope, dtype tf.DataType, optional ...PlaceholderAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Placeholder",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return the reduction indices for computing gradients of s0 op s1 with broadcast.
//
// This is typically used by gradient computations for a broadcasting operation.
func BroadcastGradientArgs(scope *Scope, s0 tf.Output, s1 tf.Output) (r0 tf.Output, r1 tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastGradientArgs",
		Input: []tf.Input{
			s0, s1,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Return the shape of s0 op s1 with broadcast.
//
// Given `s0` and `s1`, tensors that represent shapes, compute `r0`, the
// broadcasted shape. `s0`, `s1` and `r0` are all integer vectors.
func BroadcastArgs(scope *Scope, s0 tf.Output, s1 tf.Output) (r0 tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastArgs",
		Input: []tf.Input{
			s0, s1,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorStridedSliceUpdateAttr is an optional argument to TensorStridedSliceUpdate.
type TensorStridedSliceUpdateAttr func(optionalAttr)

// TensorStridedSliceUpdateBeginMask sets the optional begin_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateBeginMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["begin_mask"] = value
	}
}

// TensorStridedSliceUpdateEndMask sets the optional end_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateEndMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["end_mask"] = value
	}
}

// TensorStridedSliceUpdateEllipsisMask sets the optional ellipsis_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateEllipsisMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["ellipsis_mask"] = value
	}
}

// TensorStridedSliceUpdateNewAxisMask sets the optional new_axis_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateNewAxisMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["new_axis_mask"] = value
	}
}

// TensorStridedSliceUpdateShrinkAxisMask sets the optional shrink_axis_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateShrinkAxisMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["shrink_axis_mask"] = value
	}
}

// Assign `value` to the sliced l-value reference of `input`.
//
// The values of `value` are assigned to the positions in the tensor `input` that
// are selected by the slice parameters. The slice parameters `begin` `end`
// `strides` etc. work exactly as in `StridedSlice`.
//
// NOTE this op currently does not support broadcasting and so `value`'s shape
// must be exactly the shape produced by the slice of `input`.
func TensorStridedSliceUpdate(scope *Scope, input tf.Output, begin tf.Output, end tf.Output, strides tf.Output, value tf.Output, optional ...TensorStridedSliceUpdateAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorStridedSliceUpdate",
		Input: []tf.Input{
			input, begin, end, strides, value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StridedSliceAttr is an optional argument to StridedSlice.
type StridedSliceAttr func(optionalAttr)

// StridedSliceBeginMask sets the optional begin_mask attribute to value.
//
// value: a bitmask where a bit i being 1 means to ignore the begin
// value and instead use the largest interval possible. At runtime
// begin[i] will be replaced with `[0, n-1)` if `stride[i] > 0` or
// `[-1, n-1]` if `stride[i] < 0`
// If not specified, defaults to 0
func StridedSliceBeginMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["begin_mask"] = value
	}
}

// StridedSliceEndMask sets the optional end_mask attribute to value.
//
// value: analogous to `begin_mask`
// If not specified, defaults to 0
func StridedSliceEndMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["end_mask"] = value
	}
}

// StridedSliceEllipsisMask sets the optional ellipsis_mask attribute to value.
//
// value: a bitmask where bit `i` being 1 means the `i`th
// position is actually an ellipsis. One bit at most can be 1.
// If `ellipsis_mask == 0`, then an implicit ellipsis mask of `1 << (m+1)`
// is provided. This means that `foo[3:5] == foo[3:5, ...]`. An ellipsis
// implicitly creates as many range specifications as necessary to fully
// specify the sliced range for every dimension. For example for a 4-dimensional
// tensor `foo` the slice `foo[2, ..., 5:8]` implies `foo[2, :, :, 5:8]`.
// If not specified, defaults to 0
func StridedSliceEllipsisMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["ellipsis_mask"] = value
	}
}

// StridedSliceNewAxisMask sets the optional new_axis_mask attribute to value.
//
// value: a bitmask where bit `i` being 1 means the `i`th
// specification creates a new shape 1 dimension. For example
// `foo[:4, tf.newaxis, :2]` would produce a shape `(4, 1, 2)` tensor.
// If not specified, defaults to 0
func StridedSliceNewAxisMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["new_axis_mask"] = value
	}
}

// StridedSliceShrinkAxisMask sets the optional shrink_axis_mask attribute to value.
//
// value: a bitmask where bit `i` implies that the `i`th
// specification should shrink the dimensionality. begin and end
// must imply a slice of size 1 in the dimension. For example in
// python one might do `foo[:, 3, :]` which would result in
// `shrink_axis_mask` being 2.
// If not specified, defaults to 0
func StridedSliceShrinkAxisMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["shrink_axis_mask"] = value
	}
}

// Return a strided slice from `input`.
//
// Note, most python users will want to use the Python `Tensor.__getitem__`
// or `Variable.__getitem__` rather than this op directly.
//
// The goal of this op is to produce a new tensor with a subset of
// the elements from the `n` dimensional `input` tensor. The subset is chosen using
// a sequence of `m` sparse range specifications encoded into the arguments
// of this function. Note, in some cases
// `m` could be equal to `n`, but this need not be the case. Each
// range specification entry can be one of the following:
//
// - An ellipsis (...). Ellipses are used to imply zero or more
//   dimensions of full-dimension selection and are produced using
//   `ellipsis_mask`. For example, `foo[...]` is the identity slice.
//
// - A new axis. This is used to insert a new shape=1 dimension and is
//   produced using `new_axis_mask`. For example, `foo[:, ...]` where
//   `foo` is shape `(3, 4)` produces a `(1, 3, 4)` tensor.
//
//
// - A range `begin:end:stride`. This is used to specify how much to choose from
//   a given dimension. `stride` can be any integer but 0.  `begin` is an integer
//   which represents the index of the first value to select while `end` represents
//   the index of the last value to select. The number of values selected in each
//   dimension is `end - begin` if `stride > 0` and `begin - end` if `stride < 0`.
//   `begin` and `end` can be negative where `-1` is the last element, `-2` is
//   the second to last. `begin_mask` controls whether to replace the explicitly
//   given `begin` with an implicit effective value of `0` if `stride > 0` and
//   `-1` if `stride < 0`. `end_mask` is analogous but produces the number
//   required to create the largest open interval. For example, given a shape
//   `(3,)` tensor `foo[:]`, the effective `begin` and `end` are `0` and `3`. Do
//   not assume this is equivalent to `foo[0:-1]` which has an effective `begin`
//   and `end` of `0` and `2`. Another example is `foo[-2::-1]` which reverses the
//   first dimension of a tensor while dropping the last two (in the original
//   order elements). For example `foo = [1,2,3,4]; foo[-2::-1]` is `[4,3]`.
//
// - A single index. This is used to keep only elements that have a given
//   index. For example (`foo[2, :]` on a shape `(5,6)` tensor produces a
//   shape `(6,)` tensor. This is encoded in `begin` and `end` and
//   `shrink_axis_mask`.
//
// Each conceptual range specification is encoded in the op's argument. This
// encoding is best understand by considering a non-trivial example. In
// particular,
// `foo[1, 2:4, None, ..., :-3:-1, :]` will be encoded as
//
// ```
// begin = [1, 2, x, x, 0, x] # x denotes don't care (usually 0)
// end = [2, 4, x, x, -3, x]
// strides = [1, 1, x, x, -1, 1]
// begin_mask = 1<<4 | 1<<5 = 48
// end_mask = 1<<5 = 32
// ellipsis_mask = 1<<3 = 8
// new_axis_mask = 1<<2 = 4
// shrink_axis_mask = 1<<0 = 1
// ```
//
// In this case if `foo.shape` is (5, 5, 5, 5, 5, 5) the final shape of
// the slice becomes (2, 1, 5, 5, 2, 5).
// Let us walk step by step through each argument specification.
//
// 1.  The first argument in the example slice is turned into `begin = 1` and
// `end = begin + 1 = 2`. To disambiguate from the original spec `2:4` we
// also set the appropriate bit in `shrink_axis_mask`.
//
// 2. `2:4` is contributes 2, 4, 1 to begin, end, and stride. All masks have
// zero bits contributed.
//
// 3. None is a synonym for `tf.newaxis`. This means insert a dimension of size 1
// dimension in the final shape. Dummy values are contributed to begin,
// end and stride, while the new_axis_mask bit is set.
//
// 4. `...` grab the full ranges from as many dimensions as needed to
// fully specify a slice for every dimension of the input shape.
//
// 5. `:-3:-1` shows the use of negative indices. A negative index `i` associated
// with a dimension that has shape `s` is converted to a positive index
// `s + i`. So `-1` becomes `s-1` (i.e. the last element). This conversion
// is done internally so begin, end and strides receive x, -3, and -1.
// The appropriate begin_mask bit is set to indicate the start range is the
// full range (ignoring the x).
//
// 6. `:` indicates that the entire contents of the corresponding dimension
// is selected. This is equivalent to `::` or `0::1`. begin, end, and strides
// receive 0, 0, and 1, respectively. The appropriate bits in `begin_mask` and
// `end_mask` are also set.
//
// *Requirements*:
//   `0 != strides[i] for i in [0, m)`
//   `ellipsis_mask must be a power of two (only one ellipsis)`
//
// Arguments:
//
//	begin: `begin[k]` specifies the offset into the `k`th range specification.
// The exact dimension this corresponds to will be determined by context.
// Out-of-bounds values will be silently clamped. If the `k`th bit of
// `begin_mask` then `begin[k]` is ignored and the full range of the
// appropriate dimension is used instead. Negative values causes indexing
// to start from the highest element e.g. If `foo==[1,2,3]` then `foo[-1]==3`.
//	end: `end[i]` is like `begin` with the exception that `end_mask` is
// used to determine full ranges.
//	strides: `strides[i]` specifies the increment in the `i`th specification
// after extracting a given element. Negative indices will reverse
// the original order. Out or range values are
// clamped to `[0,dim[i]) if slice[i]>0` or `[-1,dim[i]-1] if slice[i] < 0`
func StridedSlice(scope *Scope, input tf.Output, begin tf.Output, end tf.Output, strides tf.Output, optional ...StridedSliceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StridedSlice",
		Input: []tf.Input{
			input, begin, end, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the eigen decomposition of a batch of self-adjoint matrices
//
// (Note: Only real inputs are supported).
//
// Computes the eigenvalues and eigenvectors of the innermost N-by-N matrices in
// tensor such that tensor[...,:,:] * v[..., :,i] = e[..., i] * v[...,:,i], for
// i=0...N-1.
//
// Arguments:
//	a: the input tensor.
//	lower: a boolean specifies whether the calculation is done with the lower
// triangular part or the upper triangular part.
//	max_iter: maximum number of sweep update, i.e., the whole lower triangular
// part or upper triangular part based on parameter lower. Heuristically, it has
// been argued that approximately logN sweeps are needed in practice (Ref: Golub &
// van Loan "Matrix Computation").
//	epsilon: the tolerance ratio.
//
// Returns:
//	w: The eigenvalues in ascending order, each repeated according to its
// multiplicity.
//	v: The column v[..., :, i] is the normalized eigenvector corresponding to the
// eigenvalue w[..., i].
func XlaSelfAdjointEig(scope *Scope, a tf.Output, lower bool, max_iter int64, epsilon float32) (w tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"lower": lower, "max_iter": max_iter, "epsilon": epsilon}
	opspec := tf.OpSpec{
		Type: "XlaSelfAdjointEig",
		Input: []tf.Input{
			a,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Ensures that the tensor's shape matches the expected shape.
//
// Raises an error if the input tensor's shape does not match the specified shape.
// Returns the input tensor otherwise.
//
// Arguments:
//	input: A tensor, whose shape is to be validated.
//	shape: The expected (possibly partially specified) shape of the input tensor.
//
// Returns A tensor with the same shape and contents as the input tensor or value.
func EnsureShape(scope *Scope, input tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "EnsureShape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShapeAttr is an optional argument to Shape.
type ShapeAttr func(optionalAttr)

// ShapeOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_INT32
func ShapeOutType(value tf.DataType) ShapeAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Returns the shape of a tensor.
//
// This operation returns a 1-D integer tensor representing the shape of `input`.
//
// For example:
//
// ```
// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
// shape(t) ==> [2, 2, 3]
// ```
func Shape(scope *Scope, input tf.Output, optional ...ShapeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Shape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UniqueWithCountsV2Attr is an optional argument to UniqueWithCountsV2.
type UniqueWithCountsV2Attr func(optionalAttr)

// UniqueWithCountsV2OutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueWithCountsV2OutIdx(value tf.DataType) UniqueWithCountsV2Attr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements along an axis of a tensor.
//
// This operation either returns a tensor `y` containing unique elements
// along the `axis` of a tensor. The returned unique elements is sorted
// in the same order as they occur along `axis` in `x`.
// This operation also returns a tensor `idx` and a tensor `count`
// that are the same size as the number of the elements in `x` along the
// `axis` dimension. The `idx` contains the index in the unique output `y`
// and the `count` contains the count in the unique output `y`.
// In other words, for an `1-D` tensor `x` with `axis = None:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// For example:
//
// ```
// x = tf.constant([1, 1, 2, 4, 4, 4, 7, 8, 8])
// y, idx, count = UniqueWithCountsV2(x, axis = [0])
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// count ==> [2, 1, 3, 1, 2]
// ```
//
// For a `2-D` tensor `x` with `axis = 0`:
//
// ```
// x = tf.constant([[1, 0, 0],
//                 [1, 0, 0],
//                 [2, 0, 0]])
// y, idx, count = UniqueWithCountsV2(x, axis=[0])
// y ==> [[1, 0, 0],
//        [2, 0, 0]]
// idx ==> [0, 0, 1]
// count ==> [2, 1]
// ```
//
// For a `2-D` tensor `x` with `axis = 1`:
//
// ```
// x = tf.constant([[1, 0, 0],
//                 [1, 0, 0],
//                 [2, 0, 0]])
// y, idx, count = UniqueWithCountsV2(x, axis=[1])
// y ==> [[1, 0],
//        [1, 0],
//        [2, 0]]
// idx ==> [0, 1, 1]
// count ==> [1, 2]
// ```
//
// Arguments:
//	x: A `Tensor`.
//	axis: A `Tensor` of type `int32` (default: None). The axis of the Tensor to
// find the unique elements.
//
// Returns:
//	y: A `Tensor`. Unique elements along the `axis` of `Tensor` x.
//	idx: A 1-D Tensor. Has the same type as x that contains the index of each
// value of x in the output y.
//	count: A 1-D Tensor. The count of each value of x in the output y.
func UniqueWithCountsV2(scope *Scope, x tf.Output, axis tf.Output, optional ...UniqueWithCountsV2Attr) (y tf.Output, idx tf.Output, count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniqueWithCountsV2",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Shuffle dimensions of x according to a permutation and conjugate the result.
//
// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
//   `y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
//   `y[i,j,k,...,s,t,u] == conj(x[perm[i], perm[j], perm[k],...,perm[s], perm[t], perm[u]])`
func ConjugateTranspose(scope *Scope, x tf.Output, perm tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConjugateTranspose",
		Input: []tf.Input{
			x, perm,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the inverse permutation of a tensor.
//
// This operation computes the inverse of an index permutation. It takes a 1-D
// integer tensor `x`, which represents the indices of a zero-based array, and
// swaps each value with its index position. In other words, for an output tensor
// `y` and an input tensor `x`, this operation computes the following:
//
// `y[x[i]] = i for i in [0, 1, ..., len(x) - 1]`
//
// The values must include 0. There can be no duplicate values or negative values.
//
// For example:
//
// ```
// # tensor `x` is [3, 4, 0, 2, 1]
// invert_permutation(x) ==> [2, 4, 3, 0, 1]
// ```
//
// Arguments:
//	x: 1-D.
//
// Returns 1-D.
func InvertPermutation(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InvertPermutation",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PreventGradientAttr is an optional argument to PreventGradient.
type PreventGradientAttr func(optionalAttr)

// PreventGradientMessage sets the optional message attribute to value.
//
// value: Will be printed in the error when anyone tries to differentiate
// this operation.
// If not specified, defaults to ""
func PreventGradientMessage(value string) PreventGradientAttr {
	return func(m optionalAttr) {
		m["message"] = value
	}
}

// An identity op that triggers an error if a gradient is requested.
//
// When executed in a graph, this op outputs its input tensor as-is.
//
// When building ops to compute gradients, the TensorFlow gradient system
// will return an error when trying to lookup the gradient of this op,
// because no gradient must ever be registered for this function.  This
// op exists to prevent subtle bugs from silently returning unimplemented
// gradients in some corner cases.
//
// Arguments:
//	input: any tensor.
//
// Returns the same input tensor.
func PreventGradient(scope *Scope, input tf.Output, optional ...PreventGradientAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PreventGradient",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Stops gradient computation.
//
// When executed in a graph, this op outputs its input tensor as-is.
//
// When building ops to compute gradients, this op prevents the contribution of
// its inputs to be taken into account.  Normally, the gradient generator adds ops
// to a graph to compute the derivatives of a specified 'loss' by recursively
// finding out inputs that contributed to its computation.  If you insert this op
// in the graph it inputs are masked from the gradient generator.  They are not
// taken into account for computing gradients.
//
// This is useful any time you want to compute a value with TensorFlow but need
// to pretend that the value was a constant. For example, the softmax function
// for a vector x can be written as
//
// ```python
//
//   def softmax(x):
//     numerator = tf.exp(x)
//     denominator = tf.reduce_sum(numerator)
//     return numerator / denominator
// ```
//
// This however is susceptible to overflow if the values in x are large. An
// alternative more stable way is to subtract the maximum of x from each of the
// values.
//
// ```python
//
//   def stable_softmax(x):
//     z = x - tf.reduce_max(x)
//     numerator = tf.exp(z)
//     denominator = tf.reduce_sum(numerator)
//     return numerator / denominator
// ```
//
// However, when we backprop through the softmax to x, we dont want to backprop
// through the `tf.reduce_max(x)` (if the max values are not unique then the
// gradient could flow to the wrong input) calculation and treat that as a
// constant. Therefore, we should write this out as
//
// ```python
//
//   def stable_softmax(x):
//     z = x - tf.stop_gradient(tf.reduce_max(x))
//     numerator = tf.exp(z)
//     denominator = tf.reduce_sum(numerator)
//     return numerator / denominator
// ```
//
// Some other examples include:
//
// *  The *EM* algorithm where the *M-step* should not involve backpropagation
//    through the output of the *E-step*.
// *  Contrastive divergence training of Boltzmann machines where, when
//    differentiating the energy function, the training must not backpropagate
//    through the graph that generated the samples from the model.
// *  Adversarial training, where no backprop should happen through the adversarial
//    example generation process.
func StopGradient(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StopGradient",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Identity op for gradient debugging.
//
// This op is hidden from public in Python. It is used by TensorFlow Debugger to
// register gradient tensors for gradient debugging.
// This op operates on non-reference-type tensors.
func DebugGradientIdentity(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DebugGradientIdentity",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gather slices from `params` into a Tensor with shape specified by `indices`.
//
// `indices` is a K-dimensional integer tensor, best thought of as a
// (K-1)-dimensional tensor of indices into `params`, where each element defines a
// slice of `params`:
//
//     output[\\(i_0, ..., i_{K-2}\\)] = params[indices[\\(i_0, ..., i_{K-2}\\)]]
//
// Whereas in `tf.gather` `indices` defines slices into the `axis`
// dimension of `params`, in `tf.gather_nd`, `indices` defines slices into the
// first `N` dimensions of `params`, where `N = indices.shape[-1]`.
//
// The last dimension of `indices` can be at most the rank of
// `params`:
//
//     indices.shape[-1] <= params.rank
//
// The last dimension of `indices` corresponds to elements
// (if `indices.shape[-1] == params.rank`) or slices
// (if `indices.shape[-1] < params.rank`) along dimension `indices.shape[-1]`
// of `params`.  The output tensor has shape
//
//     indices.shape[:-1] + params.shape[indices.shape[-1]:]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, a 0 is stored in the
// corresponding output value.
//
// Some examples below.
//
// Simple indexing into a matrix:
//
// ```python
//     indices = [[0, 0], [1, 1]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = ['a', 'd']
// ```
//
// Slice indexing into a matrix:
//
// ```python
//     indices = [[1], [0]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = [['c', 'd'], ['a', 'b']]
// ```
//
// Indexing into a 3-tensor:
//
// ```python
//     indices = [[1]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [[['a1', 'b1'], ['c1', 'd1']]]
//
//
//     indices = [[0, 1], [1, 0]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [['c0', 'd0'], ['a1', 'b1']]
//
//
//     indices = [[0, 0, 1], [1, 0, 1]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = ['b0', 'b1']
// ```
//
// Batched indexing into a matrix:
//
// ```python
//     indices = [[[0, 0]], [[0, 1]]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = [['a'], ['b']]
// ```
//
// Batched slice indexing into a matrix:
//
// ```python
//     indices = [[[1]], [[0]]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = [[['c', 'd']], [['a', 'b']]]
// ```
//
// Batched indexing into a 3-tensor:
//
// ```python
//     indices = [[[1]], [[0]]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [[[['a1', 'b1'], ['c1', 'd1']]],
//               [[['a0', 'b0'], ['c0', 'd0']]]]
//
//     indices = [[[0, 1], [1, 0]], [[0, 0], [1, 1]]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [[['c0', 'd0'], ['a1', 'b1']],
//               [['a0', 'b0'], ['c1', 'd1']]]
//
//
//     indices = [[[0, 0, 1], [1, 0, 1]], [[0, 1, 1], [1, 1, 0]]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [['b0', 'b1'], ['d0', 'c1']]
// ```
//
// See also `tf.gather` and `tf.batch_gather`.
//
// Arguments:
//	params: The tensor from which to gather values.
//	indices: Index tensor.
//
// Returns Values from `params` gathered from indices given by `indices`, with
// shape `indices.shape[:-1] + params.shape[indices.shape[-1]:]`.
func GatherNd(scope *Scope, params tf.Output, indices tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GatherNd",
		Input: []tf.Input{
			params, indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GatherV2Attr is an optional argument to GatherV2.
type GatherV2Attr func(optionalAttr)

// GatherV2BatchDims sets the optional batch_dims attribute to value.
// If not specified, defaults to 0
func GatherV2BatchDims(value int64) GatherV2Attr {
	return func(m optionalAttr) {
		m["batch_dims"] = value
	}
}

// Gather slices from `params` axis `axis` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `params.shape[:axis] +
// indices.shape[batch_dims:] + params.shape[axis + 1:]` where:
//
// ```python
//     # Scalar indices (output is rank(params) - 1).
//     output[a_0, ..., a_n, b_0, ..., b_n] =
//       params[a_0, ..., a_n, indices, b_0, ..., b_n]
//
//     # Vector indices (output is rank(params)).
//     output[a_0, ..., a_n, i, b_0, ..., b_n] =
//       params[a_0, ..., a_n, indices[i], b_0, ..., b_n]
//
//     # Higher rank indices (output is rank(params) + rank(indices) - 1).
//     output[a_0, ..., a_n, i, ..., j, b_0, ... b_n] =
//       params[a_0, ..., a_n, indices[i, ..., j], b_0, ..., b_n]
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
// </div>
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, a 0 is stored in the
// corresponding output value.
//
// See also `tf.batch_gather` and `tf.gather_nd`.
//
// Arguments:
//	params: The tensor from which to gather values. Must be at least rank
// `axis + 1`.
//	indices: Index tensor. Must be in range `[0, params.shape[axis])`.
//	axis: The axis in `params` to gather `indices` from. Defaults to the first
// dimension. Supports negative indexes.
//
// Returns Values from `params` gathered from indices given by `indices`, with
// shape `params.shape[:axis] + indices.shape + params.shape[axis + 1:]`.
func GatherV2(scope *Scope, params tf.Output, indices tf.Output, axis tf.Output, optional ...GatherV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GatherV2",
		Input: []tf.Input{
			params, indices, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reverses specific dimensions of a tensor.
//
// Given a `tensor`, and a `int32` tensor `axis` representing the set of
// dimensions of `tensor` to reverse. This operation reverses each dimension
// `i` for which there exists `j` s.t. `axis[j] == i`.
//
// `tensor` can have up to 8 dimensions. The number of dimensions specified
// in `axis` may be 0 or more entries. If an index is specified more than
// once, a InvalidArgument error is raised.
//
// For example:
//
// ```
// # tensor 't' is [[[[ 0,  1,  2,  3],
// #                  [ 4,  5,  6,  7],
// #                  [ 8,  9, 10, 11]],
// #                 [[12, 13, 14, 15],
// #                  [16, 17, 18, 19],
// #                  [20, 21, 22, 23]]]]
// # tensor 't' shape is [1, 2, 3, 4]
//
// # 'dims' is [3] or 'dims' is [-1]
// reverse(t, dims) ==> [[[[ 3,  2,  1,  0],
//                         [ 7,  6,  5,  4],
//                         [ 11, 10, 9, 8]],
//                        [[15, 14, 13, 12],
//                         [19, 18, 17, 16],
//                         [23, 22, 21, 20]]]]
//
// # 'dims' is '[1]' (or 'dims' is '[-3]')
// reverse(t, dims) ==> [[[[12, 13, 14, 15],
//                         [16, 17, 18, 19],
//                         [20, 21, 22, 23]
//                        [[ 0,  1,  2,  3],
//                         [ 4,  5,  6,  7],
//                         [ 8,  9, 10, 11]]]]
//
// # 'dims' is '[2]' (or 'dims' is '[-2]')
// reverse(t, dims) ==> [[[[8, 9, 10, 11],
//                         [4, 5, 6, 7],
//                         [0, 1, 2, 3]]
//                        [[20, 21, 22, 23],
//                         [16, 17, 18, 19],
//                         [12, 13, 14, 15]]]]
// ```
//
// Arguments:
//	tensor: Up to 8-D.
//	axis: 1-D. The indices of the dimensions to reverse. Must be in the range
// `[-rank(tensor), rank(tensor))`.
//
// Returns The same shape as `tensor`.
func ReverseV2(scope *Scope, tensor tf.Output, axis tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReverseV2",
		Input: []tf.Input{
			tensor, axis,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the batched diagonal part of a batched tensor.
//
// This operation returns a tensor with the `diagonal` part
// of the batched `input`. The `diagonal` part is computed as follows:
//
// Assume `input` has `k` dimensions `[I, J, K, ..., M, N]`, then the output is a
// tensor of rank `k - 1` with dimensions `[I, J, K, ..., min(M, N)]` where:
//
// `diagonal[i, j, k, ..., n] = input[i, j, k, ..., n, n]`.
//
// The input must be at least a matrix.
//
// For example:
//
// ```
// # 'input' is [[[1, 0, 0, 0]
//                [0, 2, 0, 0]
//                [0, 0, 3, 0]
//                [0, 0, 0, 4]],
//               [[5, 0, 0, 0]
//                [0, 6, 0, 0]
//                [0, 0, 7, 0]
//                [0, 0, 0, 8]]]
//
// and input.shape = (2, 4, 4)
//
// tf.matrix_diag_part(input) ==> [[1, 2, 3, 4], [5, 6, 7, 8]]
//
// which has shape (2, 4)
// ```
//
// Arguments:
//	input: Rank `k` tensor where `k >= 2`.
//
// Returns The extracted diagonal(s) having shape
// `diagonal.shape = input.shape[:-2] + [min(input.shape[-2:])]`.
func MatrixDiagPart(scope *Scope, input tf.Output) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagPart",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixSetDiagV3Attr is an optional argument to MatrixSetDiagV3.
type MatrixSetDiagV3Attr func(optionalAttr)

// MatrixSetDiagV3Align sets the optional align attribute to value.
//
// value: Some diagonals are shorter than `max_diag_len` and need to be padded. `align` is
// a string specifying how superdiagonals and subdiagonals should be aligned,
// respectively. There are four possible alignments: "RIGHT_LEFT" (default),
// "LEFT_RIGHT", "LEFT_LEFT", and "RIGHT_RIGHT". "RIGHT_LEFT" aligns superdiagonals
// to the right (left-pads the row) and subdiagonals to the left (right-pads the
// row). It is the packing format LAPACK uses. cuSPARSE uses "LEFT_RIGHT", which is
// the opposite alignment.
// If not specified, defaults to "RIGHT_LEFT"
func MatrixSetDiagV3Align(value string) MatrixSetDiagV3Attr {
	return func(m optionalAttr) {
		m["align"] = value
	}
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the specified diagonals of the
// innermost matrices. These will be overwritten by the values in `diagonal`.
//
// `input` has `r+1` dimensions `[I, J, ..., L, M, N]`. When `k` is scalar or
// `k[0] == k[1]`, `diagonal` has `r` dimensions `[I, J, ..., L, max_diag_len]`.
// Otherwise, it has `r+1` dimensions `[I, J, ..., L, num_diags, max_diag_len]`.
// `num_diags` is the number of diagonals, `num_diags = k[1] - k[0] + 1`.
// `max_diag_len` is the longest diagonal in the range `[k[0], k[1]]`,
// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
//
// The output is a tensor of rank `k+1` with dimensions `[I, J, ..., L, M, N]`.
// If `k` is scalar or `k[0] == k[1]`:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, n-max(k[1], 0)] ; if n - m == k[1]
//     input[i, j, ..., l, m, n]              ; otherwise
// ```
//
// Otherwise,
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//     input[i, j, ..., l, m, n]                         ; otherwise
// ```
// where `d = n - m`, `diag_index = k[1] - d`, and
// `index_in_diag = n - max(d, 0) + offset`.
//
// `offset` is zero except when the alignment of the diagonal is to the right.
// ```
// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
//                                            and `d >= 0`) or
//                                          (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
//                                            and `d <= 0`)
//          0                          ; otherwise
// ```
// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
//
// For example:
//
// ```
// # The main diagonal.
// input = np.array([[[7, 7, 7, 7],              # Input shape: (2, 3, 4)
//                    [7, 7, 7, 7],
//                    [7, 7, 7, 7]],
//                   [[7, 7, 7, 7],
//                    [7, 7, 7, 7],
//                    [7, 7, 7, 7]]])
// diagonal = np.array([[1, 2, 3],               # Diagonal shape: (2, 3)
//                      [4, 5, 6]])
// tf.matrix_set_diag(input, diagonal)
//   ==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
//         [7, 2, 7, 7],
//         [7, 7, 3, 7]],
//        [[4, 7, 7, 7],
//         [7, 5, 7, 7],
//         [7, 7, 6, 7]]]
//
// # A superdiagonal (per batch).
// tf.matrix_set_diag(input, diagonal, k = 1)
//   ==> [[[7, 1, 7, 7],  # Output shape: (2, 3, 4)
//         [7, 7, 2, 7],
//         [7, 7, 7, 3]],
//        [[7, 4, 7, 7],
//         [7, 7, 5, 7],
//         [7, 7, 7, 6]]]
//
// # A band of diagonals.
// diagonals = np.array([[[0, 9, 1],  # Diagonal shape: (2, 4, 3)
//                        [6, 5, 8],
//                        [1, 2, 3],
//                        [4, 5, 0]],
//                       [[0, 1, 2],
//                        [5, 6, 4],
//                        [6, 1, 2],
//                        [3, 4, 0]]])
// tf.matrix_set_diag(input, diagonals, k = (-1, 2))
//   ==> [[[1, 6, 9, 7],  # Output shape: (2, 3, 4)
//         [4, 2, 5, 1],
//         [7, 5, 3, 8]],
//        [[6, 5, 1, 7],
//         [3, 1, 6, 2],
//         [7, 4, 2, 4]]]
//
// # LEFT_RIGHT alignment.
// diagonals = np.array([[[9, 1, 0],  # Diagonal shape: (2, 4, 3)
//                        [6, 5, 8],
//                        [1, 2, 3],
//                        [0, 4, 5]],
//                       [[1, 2, 0],
//                        [5, 6, 4],
//                        [6, 1, 2],
//                        [0, 3, 4]]])
// tf.matrix_set_diag(input, diagonals, k = (-1, 2), align="LEFT_RIGHT")
//   ==> [[[1, 6, 9, 7],  # Output shape: (2, 3, 4)
//         [4, 2, 5, 1],
//         [7, 5, 3, 8]],
//        [[6, 5, 1, 7],
//         [3, 1, 6, 2],
//         [7, 4, 2, 4]]]
//
// ```
//
// Arguments:
//	input: Rank `r+1`, where `r >= 1`.
//	diagonal: Rank `r` when `k` is an integer or `k[0] == k[1]`. Otherwise, it has rank `r+1`.
// `k >= 1`.
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
// Returns Rank `r+1`, with `output.shape = input.shape`.
func MatrixSetDiagV3(scope *Scope, input tf.Output, diagonal tf.Output, k tf.Output, optional ...MatrixSetDiagV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiagV3",
		Input: []tf.Input{
			input, diagonal, k,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the specified diagonals of the
// innermost matrices. These will be overwritten by the values in `diagonal`.
//
// `input` has `r+1` dimensions `[I, J, ..., L, M, N]`. When `k` is scalar or
// `k[0] == k[1]`, `diagonal` has `r` dimensions `[I, J, ..., L, max_diag_len]`.
// Otherwise, it has `r+1` dimensions `[I, J, ..., L, num_diags, max_diag_len]`.
// `num_diags` is the number of diagonals, `num_diags = k[1] - k[0] + 1`.
// `max_diag_len` is the longest diagonal in the range `[k[0], k[1]]`,
// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
//
// The output is a tensor of rank `k+1` with dimensions `[I, J, ..., L, M, N]`.
// If `k` is scalar or `k[0] == k[1]`:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, n-max(k[1], 0)] ; if n - m == k[1]
//     input[i, j, ..., l, m, n]              ; otherwise
// ```
//
// Otherwise,
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//     input[i, j, ..., l, m, n]                         ; otherwise
// ```
// where `d = n - m`, `diag_index = k[1] - d`, and `index_in_diag = n - max(d, 0)`.
//
// For example:
//
// ```
// # The main diagonal.
// input = np.array([[[7, 7, 7, 7],              # Input shape: (2, 3, 4)
//                    [7, 7, 7, 7],
//                    [7, 7, 7, 7]],
//                   [[7, 7, 7, 7],
//                    [7, 7, 7, 7],
//                    [7, 7, 7, 7]]])
// diagonal = np.array([[1, 2, 3],               # Diagonal shape: (2, 3)
//                      [4, 5, 6]])
// tf.matrix_set_diag(diagonal) ==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
//                                    [7, 2, 7, 7],
//                                    [7, 7, 3, 7]],
//                                   [[4, 7, 7, 7],
//                                    [7, 5, 7, 7],
//                                    [7, 7, 6, 7]]]
//
// # A superdiagonal (per batch).
// tf.matrix_set_diag(diagonal, k = 1)
//   ==> [[[7, 1, 7, 7],  # Output shape: (2, 3, 4)
//         [7, 7, 2, 7],
//         [7, 7, 7, 3]],
//        [[7, 4, 7, 7],
//         [7, 7, 5, 7],
//         [7, 7, 7, 6]]]
//
// # A band of diagonals.
// diagonals = np.array([[[1, 2, 3],  # Diagonal shape: (2, 2, 3)
//                        [4, 5, 0]],
//                       [[6, 1, 2],
//                        [3, 4, 0]]])
// tf.matrix_set_diag(diagonals, k = (-1, 0))
//   ==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
//         [4, 2, 7, 7],
//         [0, 5, 3, 7]],
//        [[6, 7, 7, 7],
//         [3, 1, 7, 7],
//         [7, 4, 2, 7]]]
//
// ```
//
// Arguments:
//	input: Rank `r+1`, where `r >= 1`.
//	diagonal: Rank `r` when `k` is an integer or `k[0] == k[1]`. Otherwise, it has rank `r+1`.
// `k >= 1`.
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
// Returns Rank `r+1`, with `output.shape = input.shape`.
func MatrixSetDiagV2(scope *Scope, input tf.Output, diagonal tf.Output, k tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiagV2",
		Input: []tf.Input{
			input, diagonal, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a diagonal tensor with a given diagonal values.
//
// Given a `diagonal`, this operation returns a tensor with the `diagonal` and
// everything else padded with zeros. The diagonal is computed as follows:
//
// Assume `diagonal` has dimensions [D1,..., Dk], then the output is a tensor of
// rank 2k with dimensions [D1,..., Dk, D1,..., Dk] where:
//
// `output[i1,..., ik, i1,..., ik] = diagonal[i1, ..., ik]` and 0 everywhere else.
//
// For example:
//
// ```
// # 'diagonal' is [1, 2, 3, 4]
// tf.diag(diagonal) ==> [[1, 0, 0, 0]
//                        [0, 2, 0, 0]
//                        [0, 0, 3, 0]
//                        [0, 0, 0, 4]]
// ```
//
// Arguments:
//	diagonal: Rank k tensor where k is at most 1.
func Diag(scope *Scope, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Diag",
		Input: []tf.Input{
			diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a tensor of ones with the same shape and type as x.
//
// Arguments:
//	x: a tensor of type T.
//
// Returns a tensor of the same shape and type as x but filled with ones.
func OnesLike(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OnesLike",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a constant tensor on the host. Only for writing C++ tests.
//
// Arguments:
//	value: Attr `value` is the tensor to return.
//
func HostConst(scope *Scope, value tf.Tensor, dtype tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value": value, "dtype": dtype}
	opspec := tf.OpSpec{
		Type: "HostConst",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Splits a tensor into `num_split` tensors along one dimension.
//
// Arguments:
//	axis: 0-D.  The dimension along which to split.  Must be in the range
// `[-rank(value), rank(value))`.
//	value: The tensor to split.
//	num_split: The number of ways to split.  Must evenly divide
// `value.shape[split_dim]`.
//
// Returns They are identically shaped tensors, whose shape matches that of `value`
// except along `axis`, where their sizes are
// `values.shape[split_dim] / num_split`.
func Split(scope *Scope, axis tf.Output, value tf.Output, num_split int64) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_split": num_split}
	opspec := tf.OpSpec{
		Type: "Split",
		Input: []tf.Input{
			axis, value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("Split", err)
		return
	}
	return output
}

// Computes offsets of concat inputs within its output.
//
// For example:
//
// ```
// # 'x' is [2, 2, 7]
// # 'y' is [2, 3, 7]
// # 'z' is [2, 5, 7]
// concat_offset(2, [x, y, z]) => [0, 0, 0], [0, 2, 0], [0, 5, 0]
// ```
//
// This is typically used by gradient computations for a concat operation.
//
// Arguments:
//	concat_dim: The dimension along which to concatenate.
//	shape: The `N` int32 vectors representing shape of tensors being concatenated.
//
// Returns The `N` int32 vectors representing the starting offset
// of input tensors within the concatenated output.
func ConcatOffset(scope *Scope, concat_dim tf.Output, shape []tf.Output) (offset []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConcatOffset",
		Input: []tf.Input{
			concat_dim, tf.OutputList(shape),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if offset, idx, err = makeOutputList(op, idx, "offset"); err != nil {
		scope.UpdateErr("ConcatOffset", err)
		return
	}
	return offset
}

// Converts an array of flat indices into a tuple of coordinate arrays.
//
//
// Example:
//
// ```
// y = tf.unravel_index(indices=[2, 5, 7], dims=[3, 3])
// # 'dims' represent a hypothetical (3, 3) tensor of indices:
// # [[0, 1, *2*],
// #  [3, 4, *5*],
// #  [6, *7*, 8]]
// # For each entry from 'indices', this operation returns
// # its coordinates (marked with '*'), such as
// # 2 ==> (0, 2)
// # 5 ==> (1, 2)
// # 7 ==> (2, 1)
// y ==> [[0, 1, 2], [2, 2, 1]]
// ```
//
// @compatibility(numpy)
// Equivalent to np.unravel_index
// @end_compatibility
//
// Arguments:
//	indices: An 0-D or 1-D `int` Tensor whose elements are indices into the
// flattened version of an array of dimensions dims.
//	dims: An 1-D `int` Tensor. The shape of the array to use for unraveling
// indices.
//
// Returns An 2-D (or 1-D if indices is 0-D) tensor where each row has the
// same shape as the indices array.
func UnravelIndex(scope *Scope, indices tf.Output, dims tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnravelIndex",
		Input: []tf.Input{
			indices, dims,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EmptyAttr is an optional argument to Empty.
type EmptyAttr func(optionalAttr)

// EmptyInit sets the optional init attribute to value.
//
// value: If True, initialize the returned tensor with the default value of dtype.  Otherwise, the implementation is free not to initializethe tensor's content.
// If not specified, defaults to false
func EmptyInit(value bool) EmptyAttr {
	return func(m optionalAttr) {
		m["init"] = value
	}
}

// Creates a tensor with the given shape.
//
// This operation creates a tensor of `shape` and `dtype`.
//
// Arguments:
//	shape: 1-D. Represents the shape of the output tensor.
//
//
// Returns A `Tensor` of type `T`.
func Empty(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...EmptyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Empty",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

//     Subtracts `v` into specified rows of `x`.
//
//     Computes y = x; y[i, :] -= v; return y.
//
// Arguments:
//	x: A `Tensor` of type T.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceSub(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceSub",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PackAttr is an optional argument to Pack.
type PackAttr func(optionalAttr)

// PackAxis sets the optional axis attribute to value.
//
// value: Dimension along which to pack.  Negative values wrap around, so the
// valid range is `[-(R+1), R+1)`.
// If not specified, defaults to 0
func PackAxis(value int64) PackAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Packs a list of `N` rank-`R` tensors into one rank-`(R+1)` tensor.
//
// Packs the `N` tensors in `values` into a tensor with rank one higher than each
// tensor in `values`, by packing them along the `axis` dimension.
// Given a list of tensors of shape `(A, B, C)`;
//
// if `axis == 0` then the `output` tensor will have the shape `(N, A, B, C)`.
// if `axis == 1` then the `output` tensor will have the shape `(A, N, B, C)`.
// Etc.
//
// For example:
//
// ```
// # 'x' is [1, 4]
// # 'y' is [2, 5]
// # 'z' is [3, 6]
// pack([x, y, z]) => [[1, 4], [2, 5], [3, 6]]  # Pack along first dim.
// pack([x, y, z], axis=1) => [[1, 2, 3], [4, 5, 6]]
// ```
//
// This is the opposite of `unpack`.
//
// Arguments:
//	values: Must be of same shape and type.
//
// Returns The packed tensor.
func Pack(scope *Scope, values []tf.Output, optional ...PackAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Pack",
		Input: []tf.Input{
			tf.OutputList(values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MfccAttr is an optional argument to Mfcc.
type MfccAttr func(optionalAttr)

// MfccUpperFrequencyLimit sets the optional upper_frequency_limit attribute to value.
//
// value: The highest frequency to use when calculating the
// ceptstrum.
// If not specified, defaults to 4000
func MfccUpperFrequencyLimit(value float32) MfccAttr {
	return func(m optionalAttr) {
		m["upper_frequency_limit"] = value
	}
}

// MfccLowerFrequencyLimit sets the optional lower_frequency_limit attribute to value.
//
// value: The lowest frequency to use when calculating the
// ceptstrum.
// If not specified, defaults to 20
func MfccLowerFrequencyLimit(value float32) MfccAttr {
	return func(m optionalAttr) {
		m["lower_frequency_limit"] = value
	}
}

// MfccFilterbankChannelCount sets the optional filterbank_channel_count attribute to value.
//
// value: Resolution of the Mel bank used internally.
// If not specified, defaults to 40
func MfccFilterbankChannelCount(value int64) MfccAttr {
	return func(m optionalAttr) {
		m["filterbank_channel_count"] = value
	}
}

// MfccDctCoefficientCount sets the optional dct_coefficient_count attribute to value.
//
// value: How many output channels to produce per time slice.
// If not specified, defaults to 13
func MfccDctCoefficientCount(value int64) MfccAttr {
	return func(m optionalAttr) {
		m["dct_coefficient_count"] = value
	}
}

// Transforms a spectrogram into a form that's useful for speech recognition.
//
// Mel Frequency Cepstral Coefficients are a way of representing audio data that's
// been effective as an input feature for machine learning. They are created by
// taking the spectrum of a spectrogram (a 'cepstrum'), and discarding some of the
// higher frequencies that are less significant to the human ear. They have a long
// history in the speech recognition world, and https://en.wikipedia.org/wiki/Mel-frequency_cepstrum
// is a good resource to learn more.
//
// Arguments:
//	spectrogram: Typically produced by the Spectrogram op, with magnitude_squared
// set to true.
//	sample_rate: How many samples per second the source audio used.
func Mfcc(scope *Scope, spectrogram tf.Output, sample_rate tf.Output, optional ...MfccAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Mfcc",
		Input: []tf.Input{
			spectrogram, sample_rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AudioSpectrogramAttr is an optional argument to AudioSpectrogram.
type AudioSpectrogramAttr func(optionalAttr)

// AudioSpectrogramMagnitudeSquared sets the optional magnitude_squared attribute to value.
//
// value: Whether to return the squared magnitude or just the
// magnitude. Using squared magnitude can avoid extra calculations.
// If not specified, defaults to false
func AudioSpectrogramMagnitudeSquared(value bool) AudioSpectrogramAttr {
	return func(m optionalAttr) {
		m["magnitude_squared"] = value
	}
}

// Produces a visualization of audio data over time.
//
// Spectrograms are a standard way of representing audio information as a series of
// slices of frequency information, one slice for each window of time. By joining
// these together into a sequence, they form a distinctive fingerprint of the sound
// over time.
//
// This op expects to receive audio data as an input, stored as floats in the range
// -1 to 1, together with a window width in samples, and a stride specifying how
// far to move the window between slices. From this it generates a three
// dimensional output. The first dimension is for the channels in the input, so a
// stereo audio input would have two here for example. The second dimension is time,
// with successive frequency slices. The third dimension has an amplitude value for
// each frequency during that time slice.
//
// This means the layout when converted and saved as an image is rotated 90 degrees
// clockwise from a typical spectrogram. Time is descending down the Y axis, and
// the frequency decreases from left to right.
//
// Each value in the result represents the square root of the sum of the real and
// imaginary parts of an FFT on the current window of samples. In this way, the
// lowest dimension represents the power of each frequency in the current window,
// and adjacent windows are concatenated in the next dimension.
//
// To get a more intuitive and visual look at what this operation does, you can run
// tensorflow/examples/wav_to_spectrogram to read in an audio file and save out the
// resulting spectrogram as a PNG image.
//
// Arguments:
//	input: Float representation of audio data.
//	window_size: How wide the input window is in samples. For the highest efficiency
// this should be a power of two, but other values are accepted.
//	stride: How widely apart the center of adjacent sample windows should be.
//
// Returns 3D representation of the audio frequencies as an image.
func AudioSpectrogram(scope *Scope, input tf.Output, window_size int64, stride int64, optional ...AudioSpectrogramAttr) (spectrogram tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"window_size": window_size, "stride": stride}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AudioSpectrogram",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeWavAttr is an optional argument to DecodeWav.
type DecodeWavAttr func(optionalAttr)

// DecodeWavDesiredChannels sets the optional desired_channels attribute to value.
//
// value: Number of sample channels wanted.
// If not specified, defaults to -1
func DecodeWavDesiredChannels(value int64) DecodeWavAttr {
	return func(m optionalAttr) {
		m["desired_channels"] = value
	}
}

// DecodeWavDesiredSamples sets the optional desired_samples attribute to value.
//
// value: Length of audio requested.
// If not specified, defaults to -1
func DecodeWavDesiredSamples(value int64) DecodeWavAttr {
	return func(m optionalAttr) {
		m["desired_samples"] = value
	}
}

// Decode a 16-bit PCM WAV file to a float tensor.
//
// The -32768 to 32767 signed 16-bit values will be scaled to -1.0 to 1.0 in float.
//
// When desired_channels is set, if the input contains fewer channels than this
// then the last channel will be duplicated to give the requested number, else if
// the input has more channels than requested then the additional channels will be
// ignored.
//
// If desired_samples is set, then the audio will be cropped or padded with zeroes
// to the requested length.
//
// The first output contains a Tensor with the content of the audio samples. The
// lowest dimension will be the number of channels, and the second will be the
// number of samples. For example, a ten-sample-long stereo WAV file should give an
// output shape of [10, 2].
//
// Arguments:
//	contents: The WAV-encoded audio, usually from a file.
//
// Returns:
//	audio: 2-D with shape `[length, channels]`.
//	sample_rate: Scalar holding the sample rate found in the WAV header.
func DecodeWav(scope *Scope, contents tf.Output, optional ...DecodeWavAttr) (audio tf.Output, sample_rate tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeWav",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// UnbatchGradAttr is an optional argument to UnbatchGrad.
type UnbatchGradAttr func(optionalAttr)

// UnbatchGradContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func UnbatchGradContainer(value string) UnbatchGradAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// UnbatchGradSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func UnbatchGradSharedName(value string) UnbatchGradAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Gradient of Unbatch.
//
// Acts like Batch but using the given batch_index index of batching things as they
// become available. This ensures that the gradients are propagated back in the
// same session which did the forward pass.
//
// original_input: The input to the Unbatch operation this is the gradient of.
// batch_index: The batch_index given to the Unbatch operation this is the gradient
// of.
// grad: The downstream gradient.
// id: The id scalar emitted by Batch.
// batched_grad: The return value, either an empty tensor or the batched gradient.
// container: Container to control resource sharing.
// shared_name: Instances of UnbatchGrad with the same container and shared_name
//  are assumed to possibly belong to the same batch. If left empty, the op name
//  will be used as the shared name.
func UnbatchGrad(scope *Scope, original_input tf.Output, batch_index tf.Output, grad tf.Output, id tf.Output, optional ...UnbatchGradAttr) (batched_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnbatchGrad",
		Input: []tf.Input{
			original_input, batch_index, grad, id,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes element-wise population count (a.k.a. popcount, bitsum, bitcount).
//
// For each entry in `x`, calculates the number of `1` (on) bits in the binary
// representation of that entry.
//
// **NOTE**: It is more efficient to first `tf.bitcast` your tensors into
// `int32` or `int64` and perform the bitcount on the result, than to feed in
// 8- or 16-bit inputs and then aggregate the resulting counts.
func PopulationCount(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "PopulationCount",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Bucketize each feature based on bucket boundaries.
//
// An op that returns a list of float tensors, where each tensor represents the
// bucketized values for a single feature.
//
// Arguments:
//	float_values: float; List of Rank 1 Tensor each containing float values for a single feature.
//	bucket_boundaries: float; List of Rank 1 Tensors each containing the bucket boundaries for a single
// feature.
//
// Returns int; List of Rank 1 Tensors each containing the bucketized values for a single feature.
func BoostedTreesBucketize(scope *Scope, float_values []tf.Output, bucket_boundaries []tf.Output) (buckets []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesBucketize",
		Input: []tf.Input{
			tf.OutputList(float_values), tf.OutputList(bucket_boundaries),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if buckets, idx, err = makeOutputList(op, idx, "buckets"); err != nil {
		scope.UpdateErr("BoostedTreesBucketize", err)
		return
	}
	return buckets
}

// BoostedTreesCreateQuantileStreamResourceAttr is an optional argument to BoostedTreesCreateQuantileStreamResource.
type BoostedTreesCreateQuantileStreamResourceAttr func(optionalAttr)

// BoostedTreesCreateQuantileStreamResourceMaxElements sets the optional max_elements attribute to value.
//
// value: int; The maximum number of data points that can be fed to the stream.
// If not specified, defaults to 1099511627776
func BoostedTreesCreateQuantileStreamResourceMaxElements(value int64) BoostedTreesCreateQuantileStreamResourceAttr {
	return func(m optionalAttr) {
		m["max_elements"] = value
	}
}

// Create the Resource for Quantile Streams.
//
// Arguments:
//	quantile_stream_resource_handle: resource; Handle to quantile stream resource.
//	epsilon: float; The required approximation error of the stream resource.
//	num_streams: int; The number of streams managed by the resource that shares the same epsilon.
//
// Returns the created operation.
func BoostedTreesCreateQuantileStreamResource(scope *Scope, quantile_stream_resource_handle tf.Output, epsilon tf.Output, num_streams tf.Output, optional ...BoostedTreesCreateQuantileStreamResourceAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCreateQuantileStreamResource",
		Input: []tf.Input{
			quantile_stream_resource_handle, epsilon, num_streams,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Updates the tree ensemble by either adding a layer to the last tree being grown
//
// or by starting a new tree.
//
// Arguments:
//	tree_ensemble_handle: Handle to the ensemble variable.
//	feature_ids: Rank 1 tensor with ids for each feature. This is the real id of
// the feature that will be used in the split.
//	node_ids: List of rank 1 tensors representing the nodes for which this feature
// has a split.
//	gains: List of rank 1 tensors representing the gains for each of the feature's
// split.
//	thresholds: List of rank 1 tensors representing the thesholds for each of the
// feature's split.
//	left_node_contribs: List of rank 2 tensors with left leaf contribs for each of
// the feature's splits. Will be added to the previous node values to constitute
// the values of the left nodes.
//	right_node_contribs: List of rank 2 tensors with right leaf contribs for each
// of the feature's splits. Will be added to the previous node values to constitute
// the values of the right nodes.
//	max_depth: Max depth of the tree to build.
//	learning_rate: shrinkage const for each new tree.
//	pruning_mode: 0-No pruning, 1-Pre-pruning, 2-Post-pruning.
//
// Returns the created operation.
func BoostedTreesUpdateEnsemble(scope *Scope, tree_ensemble_handle tf.Output, feature_ids tf.Output, node_ids []tf.Output, gains []tf.Output, thresholds []tf.Output, left_node_contribs []tf.Output, right_node_contribs []tf.Output, max_depth tf.Output, learning_rate tf.Output, pruning_mode int64) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pruning_mode": pruning_mode}
	opspec := tf.OpSpec{
		Type: "BoostedTreesUpdateEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, feature_ids, tf.OutputList(node_ids), tf.OutputList(gains), tf.OutputList(thresholds), tf.OutputList(left_node_contribs), tf.OutputList(right_node_contribs), max_depth, learning_rate,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Runs multiple additive regression ensemble predictors on input instances and
//
// computes the update to cached logits. It is designed to be used during training.
// It traverses the trees starting from cached tree id and cached node id and
// calculates the updates to be pushed to the cache.
//
// Arguments:
//
//	cached_tree_ids: Rank 1 Tensor containing cached tree ids which is the starting
// tree of prediction.
//	cached_node_ids: Rank 1 Tensor containing cached node id which is the starting
// node of prediction.
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
// feature.
//	logits_dimension: scalar, dimension of the logits, to be used for partial logits
// shape.
//
// Returns:
//	partial_logits: Rank 2 Tensor containing logits update (with respect to cached
// values stored) for each example.
//	tree_ids: Rank 1 Tensor containing new tree ids for each example.
//	node_ids: Rank 1 Tensor containing new node ids in the new tree_ids.
func BoostedTreesTrainingPredict(scope *Scope, tree_ensemble_handle tf.Output, cached_tree_ids tf.Output, cached_node_ids tf.Output, bucketized_features []tf.Output, logits_dimension int64) (partial_logits tf.Output, tree_ids tf.Output, node_ids tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesTrainingPredict",
		Input: []tf.Input{
			tree_ensemble_handle, cached_tree_ids, cached_node_ids, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Aggregates the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated for each node, feature dimension id and bucket.
//
// Arguments:
//	node_ids: int32; Rank 1 Tensor containing node ids for each example, shape [batch_size].
//	gradients: float32; Rank 2 Tensor (shape=[batch_size, logits_dimension]) with gradients for each example.
//	hessians: float32; Rank 2 Tensor (shape=[batch_size, hessian_dimension]) with hessians for each example.
//	feature: int32; Rank 2 feature Tensors (shape=[batch_size, feature_dimension]).
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature.
//
// Returns output Rank 4 Tensor (shape=[splits, feature_dimension, buckets, logits_dimension + hessian_dimension])
// containing accumulated stats for each node, feature dimension and bucket.
func BoostedTreesAggregateStats(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, feature tf.Output, max_splits int64, num_buckets int64) (stats_summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesAggregateStats",
		Input: []tf.Input{
			node_ids, gradients, hessians, feature,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Makes the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated into the corresponding node and bucket for each example.
//
// Arguments:
//	node_ids: int32 Rank 1 Tensor containing node ids, which each example falls into for the requested layer.
//	gradients: float32; Rank 2 Tensor (shape=[#examples, 1]) for gradients.
//	hessians: float32; Rank 2 Tensor (shape=[#examples, 1]) for hessians.
//	bucketized_features_list: int32 list of Rank 1 Tensors, each containing the bucketized feature (for each feature column).
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature.
//
// Returns output Rank 4 Tensor (shape=[#features, #splits, #buckets, 2]) containing accumulated stats put into the corresponding node and bucket. The first index of 4th dimension refers to gradients, and the second to hessians.
func BoostedTreesMakeStatsSummary(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, bucketized_features_list []tf.Output, max_splits int64, num_buckets int64) (stats_summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesMakeStatsSummary",
		Input: []tf.Input{
			node_ids, gradients, hessians, tf.OutputList(bucketized_features_list),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deserializes a serialized tree ensemble config and replaces current tree
//
// ensemble.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble.
//	stamp_token: Token to use as the new value of the resource stamp.
//	tree_ensemble_serialized: Serialized proto of the ensemble.
//
// Returns the created operation.
func BoostedTreesDeserializeEnsemble(scope *Scope, tree_ensemble_handle tf.Output, stamp_token tf.Output, tree_ensemble_serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesDeserializeEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, stamp_token, tree_ensemble_serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// Flush the quantile summaries from each quantile stream resource.
//
// An op that outputs a list of quantile summaries of a quantile stream resource.
// Each summary Tensor is rank 2, containing summaries (value, weight, min_rank,
// max_rank) for a single feature.
//
// Arguments:
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//
func BoostedTreesFlushQuantileSummaries(scope *Scope, quantile_stream_resource_handle tf.Output, num_features int64) (summaries []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_features": num_features}
	opspec := tf.OpSpec{
		Type: "BoostedTreesFlushQuantileSummaries",
		Input: []tf.Input{
			quantile_stream_resource_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if summaries, idx, err = makeOutputList(op, idx, "summaries"); err != nil {
		scope.UpdateErr("BoostedTreesFlushQuantileSummaries", err)
		return
	}
	return summaries
}

// BoostedTreesSparseCalculateBestFeatureSplitAttr is an optional argument to BoostedTreesSparseCalculateBestFeatureSplit.
type BoostedTreesSparseCalculateBestFeatureSplitAttr func(optionalAttr)

// BoostedTreesSparseCalculateBestFeatureSplitSplitType sets the optional split_type attribute to value.
//
// value: A string indicating if this Op should perform inequality split or equality split.
// If not specified, defaults to "inequality"
func BoostedTreesSparseCalculateBestFeatureSplitSplitType(value string) BoostedTreesSparseCalculateBestFeatureSplitAttr {
	return func(m optionalAttr) {
		m["split_type"] = value
	}
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary_indices: A Rank 2 int64 tensor of dense shape [N, 4] (N specifies the number of non-zero values) for accumulated stats summary (gradient/hessian) per node per bucket for each feature. The second dimension contains node id, feature dimension, bucket id, and stats dim.
// stats dim is the sum of logits dimension and hessian dimension, hessian dimension can either be logits dimension if diagonal hessian is used, or logits dimension^2 if full hessian is used.
//	stats_summary_values: A Rank 1 float tensor of dense shape [N] (N specifies the number of non-zero values), which supplies the values for each element in summary_indices.
//	stats_summary_shape: A Rank 1 float tensor of dense shape [4], which specifies the dense shape of the sparse tensor, which is [num tree nodes, feature dimensions, num buckets, stats dim].
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns:
//	node_ids: A Rank 1 tensor indicating possible node ids that can be split.
//	gains: A Rank 1 tensor indicating the best gains to split each node.
//	feature_dimensions: A Rank 1 tensor indicating the best feature dimension for each feature to split for each node.
//	thresholds: A Rank 1 tensor indicating the bucket id to compare with (as a threshold) for split in each node.
//	left_node_contribs: A Rank 2 tensor indicating the contribution of the left nodes when branching from parent nodes to the left direction by the given threshold for each feature.
// This value will be used to make the left node value by adding to the parent node value. Second dimension size is logits dimension.
//	right_node_contribs: A Rank 2 tensor, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
//	split_with_default_directions: A Rank 1 tensor indicating which direction to go if data is missing.
// Inequality with default left returns 0, inequality with default right returns 1, equality with default right returns 2.
func BoostedTreesSparseCalculateBestFeatureSplit(scope *Scope, node_id_range tf.Output, stats_summary_indices tf.Output, stats_summary_values tf.Output, stats_summary_shape tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64, optional ...BoostedTreesSparseCalculateBestFeatureSplitAttr) (node_ids tf.Output, gains tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSparseCalculateBestFeatureSplit",
		Input: []tf.Input{
			node_id_range, stats_summary_indices, stats_summary_values, stats_summary_shape, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Calculates gains for each feature and returns the best possible split information for each node. However, if no split is found, then no split information is returned for that node.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summaries_list: A list of Rank 4 tensor (#shape=[max_splits, feature_dims, bucket, stats_dims]) for accumulated stats summary (gradient/hessian) per node, per dimension, per buckets for each feature.
// The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//	split_types: A Rank 1 tensor indicating if this Op should perform inequality split or equality split per feature.
//	candidate_feature_ids: Rank 1 tensor with ids for each feature. This is the real id of the feature.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns:
//	node_ids: A Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.
//	gains: A Rank 1 tensor indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.
//	feature_ids: A Rank 1 tensors indicating the best feature id for each node. See above for details like shapes and sizes.
//	feature_dimensions: A Rank 1 tensors indicating the best feature dimension for each feature to split for certain nodes if the feature is multi-dimension. See above for details like shapes and sizes.
//	thresholds: A Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.
//	left_node_contribs: A Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.
//	right_node_contribs: A Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
//	split_with_default_directions: A Rank 1 tensors indicating the which direction to go if data is missing. See above for details like shapes and sizes.
// Inequality with default left returns 0, inequality with default right returns 1, equality with default right returns 2.
func BoostedTreesCalculateBestFeatureSplitV2(scope *Scope, node_id_range tf.Output, stats_summaries_list []tf.Output, split_types tf.Output, candidate_feature_ids tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64) (node_ids tf.Output, gains tf.Output, feature_ids tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestFeatureSplitV2",
		Input: []tf.Input{
			node_id_range, tf.OutputList(stats_summaries_list), split_types, candidate_feature_ids, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6), op.Output(7)
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The length of output lists are all of the same length, `num_features`.
// The output shapes are compatible in a way that the first dimension of all tensors of all lists are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary_list: A list of Rank 3 tensor (#shape=[max_splits, bucket, 2]) for accumulated stats summary (gradient/hessian) per node per buckets for each feature. The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	max_splits: the number of nodes that can be split in the whole tree. Used as a dimension of output tensors.
//
// Returns:
//	node_ids_list: An output list of Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.
//	gains_list: An output list of Rank 1 tensors indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.
//	thresholds_list: An output list of Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.
//	left_node_contribs_list: A list of Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.
//	right_node_contribs_list: A list of Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
func BoostedTreesCalculateBestGainsPerFeature(scope *Scope, node_id_range tf.Output, stats_summary_list []tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, max_splits int64) (node_ids_list []tf.Output, gains_list []tf.Output, thresholds_list []tf.Output, left_node_contribs_list []tf.Output, right_node_contribs_list []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestGainsPerFeature",
		Input: []tf.Input{
			node_id_range, tf.OutputList(stats_summary_list), l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if node_ids_list, idx, err = makeOutputList(op, idx, "node_ids_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if gains_list, idx, err = makeOutputList(op, idx, "gains_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if thresholds_list, idx, err = makeOutputList(op, idx, "thresholds_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if left_node_contribs_list, idx, err = makeOutputList(op, idx, "left_node_contribs_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if right_node_contribs_list, idx, err = makeOutputList(op, idx, "right_node_contribs_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	return node_ids_list, gains_list, thresholds_list, left_node_contribs_list, right_node_contribs_list
}

// Checks whether a tree ensemble has been initialized.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble resource.
//
// Returns output boolean on whether it is initialized or not.
func IsBoostedTreesEnsembleInitialized(scope *Scope, tree_ensemble_handle tf.Output) (is_initialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsBoostedTreesEnsembleInitialized",
		Input: []tf.Input{
			tree_ensemble_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BoostedTreesEnsembleResourceHandleOpAttr is an optional argument to BoostedTreesEnsembleResourceHandleOp.
type BoostedTreesEnsembleResourceHandleOpAttr func(optionalAttr)

// BoostedTreesEnsembleResourceHandleOpContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func BoostedTreesEnsembleResourceHandleOpContainer(value string) BoostedTreesEnsembleResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// BoostedTreesEnsembleResourceHandleOpSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func BoostedTreesEnsembleResourceHandleOpSharedName(value string) BoostedTreesEnsembleResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a handle to a BoostedTreesEnsembleResource
func BoostedTreesEnsembleResourceHandleOp(scope *Scope, optional ...BoostedTreesEnsembleResourceHandleOpAttr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesEnsembleResourceHandleOp",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AllCandidateSamplerAttr is an optional argument to AllCandidateSampler.
type AllCandidateSamplerAttr func(optionalAttr)

// AllCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func AllCandidateSamplerSeed(value int64) AllCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// AllCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func AllCandidateSamplerSeed2(value int64) AllCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to produce.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//
// Returns:
//	sampled_candidates: A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.
//	true_expected_count: A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//	sampled_expected_count: A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func AllCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, optional ...AllCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AllCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// FixedUnigramCandidateSamplerAttr is an optional argument to FixedUnigramCandidateSampler.
type FixedUnigramCandidateSamplerAttr func(optionalAttr)

// FixedUnigramCandidateSamplerVocabFile sets the optional vocab_file attribute to value.
//
// value: Each valid line in this file (which should have a CSV-like format)
// corresponds to a valid word ID. IDs are in sequential order, starting from
// num_reserved_ids. The last entry in each line is expected to be a value
// corresponding to the count or relative probability. Exactly one of vocab_file
// and unigrams needs to be passed to this op.
// If not specified, defaults to ""
func FixedUnigramCandidateSamplerVocabFile(value string) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["vocab_file"] = value
	}
}

// FixedUnigramCandidateSamplerDistortion sets the optional distortion attribute to value.
//
// value: The distortion is used to skew the unigram probability distribution.
// Each weight is first raised to the distortion's power before adding to the
// internal unigram distribution. As a result, distortion = 1.0 gives regular
// unigram sampling (as defined by the vocab file), and distortion = 0.0 gives
// a uniform distribution.
// If not specified, defaults to 1
func FixedUnigramCandidateSamplerDistortion(value float32) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["distortion"] = value
	}
}

// FixedUnigramCandidateSamplerNumReservedIds sets the optional num_reserved_ids attribute to value.
//
// value: Optionally some reserved IDs can be added in the range [0,
// ..., num_reserved_ids) by the users. One use case is that a special unknown
// word token is used as ID 0. These IDs will have a sampling probability of 0.
// If not specified, defaults to 0
func FixedUnigramCandidateSamplerNumReservedIds(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["num_reserved_ids"] = value
	}
}

// FixedUnigramCandidateSamplerNumShards sets the optional num_shards attribute to value.
//
// value: A sampler can be used to sample from a subset of the original range
// in order to speed up the whole computation through parallelism. This parameter
// (together with 'shard') indicates the number of partitions that are being
// used in the overall computation.
// If not specified, defaults to 1
//
// REQUIRES: value >= 1
func FixedUnigramCandidateSamplerNumShards(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["num_shards"] = value
	}
}

// FixedUnigramCandidateSamplerShard sets the optional shard attribute to value.
//
// value: A sampler can be used to sample from a subset of the original range
// in order to speed up the whole computation through parallelism. This parameter
// (together with 'num_shards') indicates the particular partition number of a
// sampler op, when partitioning is being used.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func FixedUnigramCandidateSamplerShard(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["shard"] = value
	}
}

// FixedUnigramCandidateSamplerUnigrams sets the optional unigrams attribute to value.
//
// value: A list of unigram counts or probabilities, one per ID in sequential
// order. Exactly one of vocab_file and unigrams should be passed to this op.
// If not specified, defaults to {}
func FixedUnigramCandidateSamplerUnigrams(value []float32) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["unigrams"] = value
	}
}

// FixedUnigramCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FixedUnigramCandidateSamplerSeed(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FixedUnigramCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FixedUnigramCandidateSamplerSeed2(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// A unigram sampler could use a fixed unigram distribution read from a
// file or passed in as an in-memory array instead of building up the distribution
// from data on the fly. There is also an option to skew the distribution by
// applying a distortion power to the weights.
//
// The vocabulary file should be in CSV-like format, with the last field
// being the weight associated with the word.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//	sampled_candidates: A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.
//	true_expected_count: A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//	sampled_expected_count: A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func FixedUnigramCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...FixedUnigramCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FixedUnigramCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ThreadUnsafeUnigramCandidateSamplerAttr is an optional argument to ThreadUnsafeUnigramCandidateSampler.
type ThreadUnsafeUnigramCandidateSamplerAttr func(optionalAttr)

// ThreadUnsafeUnigramCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func ThreadUnsafeUnigramCandidateSamplerSeed(value int64) ThreadUnsafeUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// ThreadUnsafeUnigramCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func ThreadUnsafeUnigramCandidateSamplerSeed2(value int64) ThreadUnsafeUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//	sampled_candidates: A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.
//	true_expected_count: A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//	sampled_expected_count: A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func ThreadUnsafeUnigramCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...ThreadUnsafeUnigramCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ThreadUnsafeUnigramCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// MatrixDiagPartV3Attr is an optional argument to MatrixDiagPartV3.
type MatrixDiagPartV3Attr func(optionalAttr)

// MatrixDiagPartV3Align sets the optional align attribute to value.
//
// value: Some diagonals are shorter than `max_diag_len` and need to be padded. `align` is
// a string specifying how superdiagonals and subdiagonals should be aligned,
// respectively. There are four possible alignments: "RIGHT_LEFT" (default),
// "LEFT_RIGHT", "LEFT_LEFT", and "RIGHT_RIGHT". "RIGHT_LEFT" aligns superdiagonals
// to the right (left-pads the row) and subdiagonals to the left (right-pads the
// row). It is the packing format LAPACK uses. cuSPARSE uses "LEFT_RIGHT", which is
// the opposite alignment.
// If not specified, defaults to "RIGHT_LEFT"
func MatrixDiagPartV3Align(value string) MatrixDiagPartV3Attr {
	return func(m optionalAttr) {
		m["align"] = value
	}
}

// Returns the batched diagonal part of a batched tensor.
//
// Returns a tensor with the `k[0]`-th to `k[1]`-th diagonals of the batched
// `input`.
//
// Assume `input` has `r` dimensions `[I, J, ..., L, M, N]`.
// Let `max_diag_len` be the maximum length among all diagonals to be extracted,
// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
// Let `num_diags` be the number of diagonals to extract,
// `num_diags = k[1] - k[0] + 1`.
//
// If `num_diags == 1`, the output tensor is of rank `r - 1` with shape
// `[I, J, ..., L, max_diag_len]` and values:
//
// ```
// diagonal[i, j, ..., l, n]
//   = input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
//     padding_value                 ; otherwise.
// ```
// where `y = max(-k[1], 0)`, `x = max(k[1], 0)`.
//
// Otherwise, the output tensor has rank `r` with dimensions
// `[I, J, ..., L, num_diags, max_diag_len]` with values:
//
// ```
// diagonal[i, j, ..., l, m, n]
//   = input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
//     padding_value                 ; otherwise.
// ```
// where `d = k[1] - m`, `y = max(-d, 0) - offset`, and `x = max(d, 0) - offset`.
//
// `offset` is zero except when the alignment of the diagonal is to the right.
// ```
// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
//                                            and `d >= 0`) or
//                                          (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
//                                            and `d <= 0`)
//          0                          ; otherwise
// ```
// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
//
// The input must be at least a matrix.
//
// For example:
//
// ```
// input = np.array([[[1, 2, 3, 4],  # Input shape: (2, 3, 4)
//                    [5, 6, 7, 8],
//                    [9, 8, 7, 6]],
//                   [[5, 4, 3, 2],
//                    [1, 2, 3, 4],
//                    [5, 6, 7, 8]]])
//
// # A main diagonal from each batch.
// tf.matrix_diag_part(input) ==> [[1, 6, 7],  # Output shape: (2, 3)
//                                 [5, 2, 7]]
//
// # A superdiagonal from each batch.
// tf.matrix_diag_part(input, k = 1)
//   ==> [[2, 7, 6],  # Output shape: (2, 3)
//        [4, 3, 8]]
//
// # A band from each batch.
// tf.matrix_diag_part(input, k = (-1, 2))
//   ==> [[[0, 3, 8],  # Output shape: (2, 4, 3)
//         [2, 7, 6],
//         [1, 6, 7],
//         [5, 8, 0]],
//        [[0, 3, 4],
//         [4, 3, 8],
//         [5, 2, 7],
//         [1, 6, 0]]]
//
// # LEFT_RIGHT alignment.
// tf.matrix_diag_part(input, k = (-1, 2), align="LEFT_RIGHT")
//   ==> [[[3, 8, 0],  # Output shape: (2, 4, 3)
//         [2, 7, 6],
//         [1, 6, 7],
//         [0, 5, 8]],
//        [[3, 4, 0],
//         [4, 3, 8],
//         [5, 2, 7],
//         [0, 1, 6]]]
//
// # max_diag_len can be shorter than the main diagonal.
// tf.matrix_diag_part(input, k = (-2, -1))
//   ==> [[[5, 8],
//         [9, 0]],
//        [[1, 6],
//         [5, 0]]]
//
// # padding_value = 9
// tf.matrix_diag_part(input, k = (1, 3), padding_value = 9)
//   ==> [[[9, 9, 4],  # Output shape: (2, 3, 3)
//         [9, 3, 8],
//         [2, 7, 6]],
//        [[9, 9, 2],
//         [9, 3, 4],
//         [4, 3, 8]]]
//
// ```
//
// Arguments:
//	input: Rank `r` tensor where `r >= 2`.
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//	padding_value: The value to fill the area outside the specified diagonal band with.
// Default is 0.
//
// Returns The extracted diagonal(s).
func MatrixDiagPartV3(scope *Scope, input tf.Output, k tf.Output, padding_value tf.Output, optional ...MatrixDiagPartV3Attr) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagPartV3",
		Input: []tf.Input{
			input, k, padding_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LearnedUnigramCandidateSamplerAttr is an optional argument to LearnedUnigramCandidateSampler.
type LearnedUnigramCandidateSamplerAttr func(optionalAttr)

// LearnedUnigramCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func LearnedUnigramCandidateSamplerSeed(value int64) LearnedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// LearnedUnigramCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func LearnedUnigramCandidateSamplerSeed2(value int64) LearnedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//	sampled_candidates: A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.
//	true_expected_count: A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//	sampled_expected_count: A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func LearnedUnigramCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...LearnedUnigramCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LearnedUnigramCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// LogUniformCandidateSamplerAttr is an optional argument to LogUniformCandidateSampler.
type LogUniformCandidateSamplerAttr func(optionalAttr)

// LogUniformCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func LogUniformCandidateSamplerSeed(value int64) LogUniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// LogUniformCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func LogUniformCandidateSamplerSeed2(value int64) LogUniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a log-uniform distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//	sampled_candidates: A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.
//	true_expected_count: A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//	sampled_expected_count: A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func LogUniformCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...LogUniformCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LogUniformCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Selects the k nearest centers for each point.
//
// Rows of points are assumed to be input points. Rows of centers are assumed to be
// the list of candidate centers. For each point, the k centers that have least L2
// distance to it are computed.
//
// Arguments:
//	points: Matrix of shape (n, d). Rows are assumed to be input points.
//	centers: Matrix of shape (m, d). Rows are assumed to be centers.
//	k: Number of nearest centers to return for each point. If k is larger than m, then
// only m centers are returned.
//
// Returns:
//	nearest_center_indices: Matrix of shape (n, min(m, k)). Each row contains the indices of the centers
// closest to the corresponding point, ordered by increasing distance.
//	nearest_center_distances: Matrix of shape (n, min(m, k)). Each row contains the squared L2 distance to the
// corresponding center in nearest_center_indices.
func NearestNeighbors(scope *Scope, points tf.Output, centers tf.Output, k tf.Output) (nearest_center_indices tf.Output, nearest_center_distances tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NearestNeighbors",
		Input: []tf.Input{
			points, centers, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Selects num_to_sample rows of input using the KMeans++ criterion.
//
// Rows of points are assumed to be input points. One row is selected at random.
// Subsequent rows are sampled with probability proportional to the squared L2
// distance from the nearest row selected thus far till num_to_sample rows have
// been sampled.
//
// Arguments:
//	points: Matrix of shape (n, d). Rows are assumed to be input points.
//	num_to_sample: Scalar. The number of rows to sample. This value must not be larger than n.
//	seed: Scalar. Seed for initializing the random number generator.
//	num_retries_per_sample: Scalar. For each row that is sampled, this parameter
// specifies the number of additional points to draw from the current
// distribution before selecting the best. If a negative value is specified, a
// heuristic is used to sample O(log(num_to_sample)) additional points.
//
// Returns Matrix of shape (num_to_sample, d). The sampled rows.
func KmeansPlusPlusInitialization(scope *Scope, points tf.Output, num_to_sample tf.Output, seed tf.Output, num_retries_per_sample tf.Output) (samples tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "KmeansPlusPlusInitialization",
		Input: []tf.Input{
			points, num_to_sample, seed, num_retries_per_sample,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveAllToAllV3Attr is an optional argument to CollectiveAllToAllV3.
type CollectiveAllToAllV3Attr func(optionalAttr)

// CollectiveAllToAllV3TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveAllToAllV3TimeoutSeconds(value float32) CollectiveAllToAllV3Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Mutually exchanges multiple tensors of identical type and shape.
func CollectiveAllToAllV3(scope *Scope, input tf.Output, communicator tf.Output, group_assignment tf.Output, optional ...CollectiveAllToAllV3Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveAllToAllV3",
		Input: []tf.Input{
			input, communicator, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveReduceV3Attr is an optional argument to CollectiveReduceV3.
type CollectiveReduceV3Attr func(optionalAttr)

// CollectiveReduceV3TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveReduceV3TimeoutSeconds(value float32) CollectiveReduceV3Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Mutually reduces multiple tensors of identical type and shape.
func CollectiveReduceV3(scope *Scope, input tf.Output, communicator tf.Output, group_assignment tf.Output, reduction string, optional ...CollectiveReduceV3Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveReduceV3",
		Input: []tf.Input{
			input, communicator, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveBcastRecvV2Attr is an optional argument to CollectiveBcastRecvV2.
type CollectiveBcastRecvV2Attr func(optionalAttr)

// CollectiveBcastRecvV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastRecvV2CommunicationHint(value string) CollectiveBcastRecvV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastRecvV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastRecvV2TimeoutSeconds(value float32) CollectiveBcastRecvV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Receives a tensor value broadcast from another device.
func CollectiveBcastRecvV2(scope *Scope, group_size tf.Output, group_key tf.Output, instance_key tf.Output, shape tf.Output, T tf.DataType, optional ...CollectiveBcastRecvV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastRecvV2",
		Input: []tf.Input{
			group_size, group_key, instance_key, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveGatherV2Attr is an optional argument to CollectiveGatherV2.
type CollectiveGatherV2Attr func(optionalAttr)

// CollectiveGatherV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveGatherV2CommunicationHint(value string) CollectiveGatherV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveGatherV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveGatherV2TimeoutSeconds(value float32) CollectiveGatherV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Mutually accumulates multiple tensors of identical type and shape.
func CollectiveGatherV2(scope *Scope, input tf.Output, group_size tf.Output, group_key tf.Output, instance_key tf.Output, ordering_token []tf.Output, optional ...CollectiveGatherV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveGatherV2",
		Input: []tf.Input{
			input, group_size, group_key, instance_key, tf.OutputList(ordering_token),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AbortAttr is an optional argument to Abort.
type AbortAttr func(optionalAttr)

// AbortErrorMsg sets the optional error_msg attribute to value.
//
// value: A string which is the message associated with the exception.
// If not specified, defaults to ""
func AbortErrorMsg(value string) AbortAttr {
	return func(m optionalAttr) {
		m["error_msg"] = value
	}
}

// AbortExitWithoutError sets the optional exit_without_error attribute to value.
// If not specified, defaults to false
func AbortExitWithoutError(value bool) AbortAttr {
	return func(m optionalAttr) {
		m["exit_without_error"] = value
	}
}

// Raise a exception to abort the process when called.
//
// If exit_without_error is true, the process will exit normally,
// otherwise it will exit with a SIGABORT signal.
//
// Returns nothing but an exception.
//
// Returns the created operation.
func Abort(scope *Scope, optional ...AbortAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Abort",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Makes its input available to the next iteration.
//
// Arguments:
//	data: The tensor to be made available to the next iteration.
//
// Returns The same tensor as `data`.
func NextIteration(scope *Scope, data tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NextIteration",
		Input: []tf.Input{
			data,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Exits the current frame to its parent frame.
//
// Exit makes its input `data` available to the parent frame.
//
// Arguments:
//	data: The tensor to be made available to the parent frame.
//
// Returns The same tensor as `data`.
func Exit(scope *Scope, data tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Exit",
		Input: []tf.Input{
			data,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EnterAttr is an optional argument to Enter.
type EnterAttr func(optionalAttr)

// EnterIsConstant sets the optional is_constant attribute to value.
//
// value: If true, the output is constant within the child frame.
// If not specified, defaults to false
func EnterIsConstant(value bool) EnterAttr {
	return func(m optionalAttr) {
		m["is_constant"] = value
	}
}

// EnterParallelIterations sets the optional parallel_iterations attribute to value.
//
// value: The number of iterations allowed to run in parallel.
// If not specified, defaults to 10
func EnterParallelIterations(value int64) EnterAttr {
	return func(m optionalAttr) {
		m["parallel_iterations"] = value
	}
}

// Creates or finds a child frame, and makes `data` available to the child frame.
//
// This op is used together with `Exit` to create loops in the graph.
// The unique `frame_name` is used by the `Executor` to identify frames. If
// `is_constant` is true, `output` is a constant in the child frame; otherwise
// it may be changed in the child frame. At most `parallel_iterations` iterations
// are run in parallel in the child frame.
//
// Arguments:
//	data: The tensor to be made available to the child frame.
//	frame_name: The name of the child frame.
//
// Returns The same tensor as `data`.
func Enter(scope *Scope, data tf.Output, frame_name string, optional ...EnterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"frame_name": frame_name}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Enter",
		Input: []tf.Input{
			data,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DenseCountSparseOutputAttr is an optional argument to DenseCountSparseOutput.
type DenseCountSparseOutputAttr func(optionalAttr)

// DenseCountSparseOutputMinlength sets the optional minlength attribute to value.
//
// value: Minimum value to count. Can be set to -1 for no minimum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func DenseCountSparseOutputMinlength(value int64) DenseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["minlength"] = value
	}
}

// DenseCountSparseOutputMaxlength sets the optional maxlength attribute to value.
//
// value: Maximum value to count. Can be set to -1 for no maximum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func DenseCountSparseOutputMaxlength(value int64) DenseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["maxlength"] = value
	}
}

// Performs sparse-output bin counting for a tf.tensor input.
//
//   Counts the number of times each value occurs in the input.
//
// Arguments:
//	values: Tensor containing data to count.
//	weights: A Tensor of the same shape as indices containing per-index weight values. May
// also be the empty tensor if no weights are used.
//	binary_output: Whether to output the number of occurrences of each value or 1.
//
// Returns:
//	output_indices: Indices tensor for the resulting sparse tensor object.
//	output_values: Values tensor for the resulting sparse tensor object.
//	output_dense_shape: Shape tensor for the resulting sparse tensor object.
func DenseCountSparseOutput(scope *Scope, values tf.Output, weights tf.Output, binary_output bool, optional ...DenseCountSparseOutputAttr) (output_indices tf.Output, output_values tf.Output, output_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"binary_output": binary_output}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseCountSparseOutput",
		Input: []tf.Input{
			values, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// CTCBeamSearchDecoderAttr is an optional argument to CTCBeamSearchDecoder.
type CTCBeamSearchDecoderAttr func(optionalAttr)

// CTCBeamSearchDecoderMergeRepeated sets the optional merge_repeated attribute to value.
//
// value: If true, merge repeated classes in output.
// If not specified, defaults to true
func CTCBeamSearchDecoderMergeRepeated(value bool) CTCBeamSearchDecoderAttr {
	return func(m optionalAttr) {
		m["merge_repeated"] = value
	}
}

// Performs beam search decoding on the logits given in input.
//
// A note about the attribute merge_repeated: For the beam search decoder,
// this means that if consecutive entries in a beam are the same, only
// the first of these is emitted.  That is, when the top path is "A B B B B",
// "A B" is returned if merge_repeated = True but "A B B B B" is
// returned if merge_repeated = False.
//
// Arguments:
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	sequence_length: A vector containing sequence lengths, size `(batch)`.
//	beam_width: A scalar >= 0 (beam search beam width).
//	top_paths: A scalar >= 0, <= beam_width (controls output size).
//
// Returns:
//	decoded_indices: A list (length: top_paths) of indices matrices.  Matrix j,
// size `(total_decoded_outputs[j] x 2)`, has indices of a
// `SparseTensor<int64, 2>`.  The rows store: [batch, time].
//	decoded_values: A list (length: top_paths) of values vectors.  Vector j,
// size `(length total_decoded_outputs[j])`, has the values of a
// `SparseTensor<int64, 2>`.  The vector stores the decoded classes for beam j.
//	decoded_shape: A list (length: top_paths) of shape vector.  Vector j,
// size `(2)`, stores the shape of the decoded `SparseTensor[j]`.
// Its values are: `[batch_size, max_decoded_length[j]]`.
//	log_probability: A matrix, shaped: `(batch_size x top_paths)`.  The
// sequence log-probabilities.
func CTCBeamSearchDecoder(scope *Scope, inputs tf.Output, sequence_length tf.Output, beam_width int64, top_paths int64, optional ...CTCBeamSearchDecoderAttr) (decoded_indices []tf.Output, decoded_values []tf.Output, decoded_shape []tf.Output, log_probability tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"beam_width": beam_width, "top_paths": top_paths}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCBeamSearchDecoder",
		Input: []tf.Input{
			inputs, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if decoded_indices, idx, err = makeOutputList(op, idx, "decoded_indices"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	if decoded_values, idx, err = makeOutputList(op, idx, "decoded_values"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	if decoded_shape, idx, err = makeOutputList(op, idx, "decoded_shape"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	log_probability = op.Output(idx)
	return decoded_indices, decoded_values, decoded_shape, log_probability
}

// CTCGreedyDecoderAttr is an optional argument to CTCGreedyDecoder.
type CTCGreedyDecoderAttr func(optionalAttr)

// CTCGreedyDecoderMergeRepeated sets the optional merge_repeated attribute to value.
//
// value: If True, merge repeated classes in output.
// If not specified, defaults to false
func CTCGreedyDecoderMergeRepeated(value bool) CTCGreedyDecoderAttr {
	return func(m optionalAttr) {
		m["merge_repeated"] = value
	}
}

// CTCGreedyDecoderBlankIndex sets the optional blank_index attribute to value.
// If not specified, defaults to -1
func CTCGreedyDecoderBlankIndex(value int64) CTCGreedyDecoderAttr {
	return func(m optionalAttr) {
		m["blank_index"] = value
	}
}

// Performs greedy decoding on the logits given in inputs.
//
// A note about the attribute merge_repeated: if enabled, when
// consecutive logits' maximum indices are the same, only the first of
// these is emitted.  Labeling the blank '*', the sequence "A B B * B B"
// becomes "A B B" if merge_repeated = True and "A B B B B" if
// merge_repeated = False.
//
// Regardless of the value of merge_repeated, if the maximum index of a given
// time and batch corresponds to the blank, index `(num_classes - 1)`, no new
// element is emitted.
//
// Arguments:
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	sequence_length: A vector containing sequence lengths, size `(batch_size)`.
//
// Returns:
//	decoded_indices: Indices matrix, size `(total_decoded_outputs x 2)`,
// of a `SparseTensor<int64, 2>`.  The rows store: [batch, time].
//	decoded_values: Values vector, size: `(total_decoded_outputs)`,
// of a `SparseTensor<int64, 2>`.  The vector stores the decoded classes.
//	decoded_shape: Shape vector, size `(2)`, of the decoded SparseTensor.
// Values are: `[batch_size, max_decoded_length]`.
//	log_probability: Matrix, size `(batch_size x 1)`, containing sequence
// log-probabilities.
func CTCGreedyDecoder(scope *Scope, inputs tf.Output, sequence_length tf.Output, optional ...CTCGreedyDecoderAttr) (decoded_indices tf.Output, decoded_values tf.Output, decoded_shape tf.Output, log_probability tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCGreedyDecoder",
		Input: []tf.Input{
			inputs, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CTCLossAttr is an optional argument to CTCLoss.
type CTCLossAttr func(optionalAttr)

// CTCLossPreprocessCollapseRepeated sets the optional preprocess_collapse_repeated attribute to value.
//
// value: Scalar, if true then repeated labels are
// collapsed prior to the CTC calculation.
// If not specified, defaults to false
func CTCLossPreprocessCollapseRepeated(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["preprocess_collapse_repeated"] = value
	}
}

// CTCLossCtcMergeRepeated sets the optional ctc_merge_repeated attribute to value.
//
// value: Scalar.  If set to false, *during* CTC calculation
// repeated non-blank labels will not be merged and are interpreted as
// individual labels.  This is a simplified version of CTC.
// If not specified, defaults to true
func CTCLossCtcMergeRepeated(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["ctc_merge_repeated"] = value
	}
}

// CTCLossIgnoreLongerOutputsThanInputs sets the optional ignore_longer_outputs_than_inputs attribute to value.
//
// value: Scalar. If set to true, during CTC
// calculation, items that have longer output sequences than input sequences
// are skipped: they don't contribute to the loss term and have zero-gradient.
// If not specified, defaults to false
func CTCLossIgnoreLongerOutputsThanInputs(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["ignore_longer_outputs_than_inputs"] = value
	}
}

// Calculates the CTC Loss (log probability) for each batch entry.  Also calculates
//
// the gradient.  This class performs the softmax operation for you, so inputs
// should be e.g. linear projections of outputs by an LSTM.
//
// Arguments:
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	labels_indices: The indices of a `SparseTensor<int32, 2>`.
// `labels_indices(i, :) == [b, t]` means `labels_values(i)` stores the id for
// `(batch b, time t)`.
//	labels_values: The values (labels) associated with the given batch and time.
//	sequence_length: A vector containing sequence lengths (batch).
//
// Returns:
//	loss: A vector (batch) containing log-probabilities.
//	gradient: The gradient of `loss`.  3-D, shape:
// `(max_time x batch_size x num_classes)`.
func CTCLoss(scope *Scope, inputs tf.Output, labels_indices tf.Output, labels_values tf.Output, sequence_length tf.Output, optional ...CTCLossAttr) (loss tf.Output, gradient tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCLoss",
		Input: []tf.Input{
			inputs, labels_indices, labels_values, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// CudnnRNNCanonicalToParamsAttr is an optional argument to CudnnRNNCanonicalToParams.
type CudnnRNNCanonicalToParamsAttr func(optionalAttr)

// CudnnRNNCanonicalToParamsRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNCanonicalToParamsRnnMode(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNCanonicalToParamsInputMode(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNCanonicalToParamsDirection(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNCanonicalToParamsDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsDropout(value float32) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNCanonicalToParamsSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsSeed(value int64) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNCanonicalToParamsSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsSeed2(value int64) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Converts CudnnRNN params from canonical form to usable form.
//
// Writes a set of weights into the opaque params buffer so they can be used in
// upcoming training or inferences.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// weights: the canonical form of weights that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// biases: the canonical form of biases that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// num_params: number of parameter sets for all layers.
//     Each layer may contain multiple parameter sets, with each set consisting of
//     a weight matrix and a bias vector.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     The actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//     dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
func CudnnRNNCanonicalToParams(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, weights []tf.Output, biases []tf.Output, optional ...CudnnRNNCanonicalToParamsAttr) (params tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNCanonicalToParams",
		Input: []tf.Input{
			num_layers, num_units, input_size, tf.OutputList(weights), tf.OutputList(biases),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNParamsToCanonicalV2Attr is an optional argument to CudnnRNNParamsToCanonicalV2.
type CudnnRNNParamsToCanonicalV2Attr func(optionalAttr)

// CudnnRNNParamsToCanonicalV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsToCanonicalV2RnnMode(value string) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsToCanonicalV2InputMode(value string) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsToCanonicalV2Direction(value string) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2Dropout(value float32) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2Seed(value int64) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2Seed2(value int64) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNParamsToCanonicalV2NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2NumProj(value int64) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// Retrieves CudnnRNN params in canonical form. It supports the projection in LSTM.
//
// Retrieves a set of weights from the opaque params buffer that can be saved and
// restored in a way compatible with future runs.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// num_params_weights: number of weight parameter matrix for all layers.
// num_params_biases: number of bias parameter vector for all layers.
// weights: the canonical form of weights that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// biases: the canonical form of biases that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     The actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//     dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
// num_proj: The output dimensionality for the projection matrices. If None or 0,
//     no projection is performed.
func CudnnRNNParamsToCanonicalV2(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, params tf.Output, num_params_weights int64, num_params_biases int64, optional ...CudnnRNNParamsToCanonicalV2Attr) (weights []tf.Output, biases []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_params_weights": num_params_weights, "num_params_biases": num_params_biases}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsToCanonicalV2",
		Input: []tf.Input{
			num_layers, num_units, input_size, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if weights, idx, err = makeOutputList(op, idx, "weights"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonicalV2", err)
		return
	}
	if biases, idx, err = makeOutputList(op, idx, "biases"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonicalV2", err)
		return
	}
	return weights, biases
}

// Returns the diagonal part of the tensor.
//
// This operation returns a tensor with the `diagonal` part
// of the `input`. The `diagonal` part is computed as follows:
//
// Assume `input` has dimensions `[D1,..., Dk, D1,..., Dk]`, then the output is a
// tensor of rank `k` with dimensions `[D1,..., Dk]` where:
//
// `diagonal[i1,..., ik] = input[i1, ..., ik, i1,..., ik]`.
//
// For example:
//
// ```
// # 'input' is [[1, 0, 0, 0]
//               [0, 2, 0, 0]
//               [0, 0, 3, 0]
//               [0, 0, 0, 4]]
//
// tf.diag_part(input) ==> [1, 2, 3, 4]
// ```
//
// Arguments:
//	input: Rank k tensor where k is even and not zero.
//
// Returns The extracted diagonal.
func DiagPart(scope *Scope, input tf.Output) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DiagPart",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNParamsToCanonicalAttr is an optional argument to CudnnRNNParamsToCanonical.
type CudnnRNNParamsToCanonicalAttr func(optionalAttr)

// CudnnRNNParamsToCanonicalRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsToCanonicalRnnMode(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsToCanonicalInputMode(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsToCanonicalDirection(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsToCanonicalDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalDropout(value float32) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsToCanonicalSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalSeed(value int64) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsToCanonicalSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalSeed2(value int64) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Retrieves CudnnRNN params in canonical form.
//
// Retrieves a set of weights from the opaque params buffer that can be saved and
// restored in a way compatible with future runs.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// num_params: number of parameter sets for all layers.
//     Each layer may contain multiple parameter sets, with each set consisting of
//     a weight matrix and a bias vector.
// weights: the canonical form of weights that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// biases: the canonical form of biases that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     The actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//     dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
func CudnnRNNParamsToCanonical(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, params tf.Output, num_params int64, optional ...CudnnRNNParamsToCanonicalAttr) (weights []tf.Output, biases []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_params": num_params}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsToCanonical",
		Input: []tf.Input{
			num_layers, num_units, input_size, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if weights, idx, err = makeOutputList(op, idx, "weights"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonical", err)
		return
	}
	if biases, idx, err = makeOutputList(op, idx, "biases"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonical", err)
		return
	}
	return weights, biases
}

// CudnnRNNBackpropV3Attr is an optional argument to CudnnRNNBackpropV3.
type CudnnRNNBackpropV3Attr func(optionalAttr)

// CudnnRNNBackpropV3RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropV3RnnMode(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropV3InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropV3InputMode(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropV3Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropV3Direction(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropV3Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Dropout(value float32) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropV3Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Seed(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropV3Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Seed2(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNBackpropV3NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3NumProj(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// CudnnRNNBackpropV3TimeMajor sets the optional time_major attribute to value.
// If not specified, defaults to true
func CudnnRNNBackpropV3TimeMajor(value bool) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["time_major"] = value
	}
}

// Backprop step of CudnnRNNV3.
//
// Compute the backprop of both data and weights in a RNN. Takes an extra
//     "sequence_lengths" input than CudnnRNNBackprop.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//     the actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: If time_major is true, this is a 3-D tensor with the shape of
//     [seq_length, batch_size, input_size]. If time_major is false, the shape is
//     [batch_size, seq_length, input_size].
// input_h: If time_major is true, this is a 3-D tensor with the shape of
//     [num_layer * dir, batch_size, num_units]. If time_major is false, the shape
//     is [batch_size, num_layer * dir, num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// sequence_lengths: a vector of lengths of each input sequence.
// output: If time_major is true, this is a 3-D tensor with the shape of
//     [seq_length, batch_size, dir * num_units]. If time_major is false, the
//     shape is [batch_size, seq_length, dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//     pass.
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//     pass.
// time_major: Indicates whether the input/output format is time major or batch
//     major.
// reserve_space: The same reserve_space produced in the forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//     as input.
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//     shape as input_h.
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//     shape as input_c.
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//     same shape as params.
func CudnnRNNBackpropV3(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, sequence_lengths tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, host_reserved tf.Output, optional ...CudnnRNNBackpropV3Attr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackpropV3",
		Input: []tf.Input{
			input, input_h, input_c, params, sequence_lengths, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, host_reserved,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNBackpropAttr is an optional argument to CudnnRNNBackprop.
type CudnnRNNBackpropAttr func(optionalAttr)

// CudnnRNNBackpropRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropRnnMode(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropInputMode(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropDirection(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropDropout(value float32) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropSeed(value int64) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropSeed2(value int64) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Backprop step of CudnnRNN.
//
// Compute the backprop of both data and weights in a RNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     the actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//     num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//     dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//     pass.
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//     pass.
// reserve_space: The same reserve_space produced in for forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//     as input.
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//     shape as input_h.
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//     shape as input_c.
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//     same shape as params.
func CudnnRNNBackprop(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, optional ...CudnnRNNBackpropAttr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackprop",
		Input: []tf.Input{
			input, input_h, input_c, params, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNV3Attr is an optional argument to CudnnRNNV3.
type CudnnRNNV3Attr func(optionalAttr)

// CudnnRNNV3RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNV3RnnMode(value string) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNV3InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNV3InputMode(value string) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNV3Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNV3Direction(value string) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNV3Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3Dropout(value float32) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNV3Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3Seed(value int64) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNV3Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3Seed2(value int64) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNV3NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3NumProj(value int64) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// CudnnRNNV3IsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNV3IsTraining(value bool) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// CudnnRNNV3TimeMajor sets the optional time_major attribute to value.
// If not specified, defaults to true
func CudnnRNNV3TimeMajor(value bool) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["time_major"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer. Accepts one extra input "sequence_lengths" than CudnnRNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//   the actual computation before the first layer. 'skip_input' is only allowed
//   when input_size == num_units; 'auto_select' implies 'skip_input' when
//   input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: If time_major is true, this is a 3-D tensor with the shape of
//     [seq_length, batch_size, input_size]. If time_major is false, the shape is
//     [batch_size, seq_length, input_size].
// input_h: If time_major is true, this is a 3-D tensor with the shape of
//     [num_layer * dir, batch_size, num_units]. If time_major is false, the shape
//     is [batch_size, num_layer * dir, num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// sequence_lengths: a vector of lengths of each input sequence.
// output: If time_major is true, this is a 3-D tensor with the shape of
//     [seq_length, batch_size, dir * num_units]. If time_major is false, the
//     shape is [batch_size, seq_length, dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inference or
//   training.
// time_major: Indicates whether the input/output format is time major or batch
//     major.
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//   is only produced if is_training is true.
func CudnnRNNV3(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, sequence_lengths tf.Output, optional ...CudnnRNNV3Attr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output, host_reserved tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNV3",
		Input: []tf.Input{
			input, input_h, input_c, params, sequence_lengths,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Pads a tensor with zeros.
//
// This operation pads a `input` with zeros according to the `paddings` you
// specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is the
// rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many zeros to add before the contents of `input` in that dimension, and
// `paddings[D, 1]` indicates how many zeros to add after the contents of `input`
// in that dimension.
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 1], [2, 2]]
// # 'paddings' is [[1, 1], [2, 2]]
// # rank of 't' is 2
// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
//                       [0, 0, 1, 1, 0, 0]
//                       [0, 0, 2, 2, 0, 0]
//                       [0, 0, 0, 0, 0, 0]]
// ```
//
func Pad(scope *Scope, input tf.Output, paddings tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Pad",
		Input: []tf.Input{
			input, paddings,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNV2Attr is an optional argument to CudnnRNNV2.
type CudnnRNNV2Attr func(optionalAttr)

// CudnnRNNV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNV2RnnMode(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNV2InputMode(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNV2Direction(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Dropout(value float32) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Seed(value int64) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Seed2(value int64) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNV2IsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNV2IsTraining(value bool) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer. Produces one extra output "host_reserved" than CudnnRNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//   the actual computation before the first layer. 'skip_input' is only allowed
//   when input_size == num_units; 'auto_select' implies 'skip_input' when
//   input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//     num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//     dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inference or
//   training.
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//   is only produced if is_training is true.
// host_reserved: An opaque tensor that can be used in backprop calculation. It is
//   only produced if is_training is true. It is output on host memory rather than
//   device memory.
func CudnnRNNV2(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, optional ...CudnnRNNV2Attr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output, host_reserved tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNV2",
		Input: []tf.Input{
			input, input_h, input_c, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// CudnnRNNParamsSizeAttr is an optional argument to CudnnRNNParamsSize.
type CudnnRNNParamsSizeAttr func(optionalAttr)

// CudnnRNNParamsSizeRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsSizeRnnMode(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsSizeInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsSizeInputMode(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsSizeDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsSizeDirection(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsSizeDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeDropout(value float32) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsSizeSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeSeed(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsSizeSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeSeed2(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNParamsSizeNumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeNumProj(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// Computes size of weights that can be used by a Cudnn RNN model.
//
// Return the params size that can be used by the Cudnn RNN model. Subsequent
// weight allocation and initialization should use this size.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//   The actual computation before the first layer. 'skip_input' is only allowed
//   when input_size == num_units; 'auto_select' implies 'skip_input' when
//   input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//   dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
// params_size: The size of the params buffer that should be allocated and
//   initialized for this RNN model. Note that this params buffer may not be
//   compatible across GPUs. Please use CudnnRNNParamsWeights and
//   CudnnRNNParamsBiases to save and restore them in a way that is compatible
//   across different runs.
func CudnnRNNParamsSize(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, T tf.DataType, S tf.DataType, optional ...CudnnRNNParamsSizeAttr) (params_size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T, "S": S}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsSize",
		Input: []tf.Input{
			num_layers, num_units, input_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RecordInputAttr is an optional argument to RecordInput.
type RecordInputAttr func(optionalAttr)

// RecordInputFileRandomSeed sets the optional file_random_seed attribute to value.
//
// value: Random seeds used to produce randomized records.
// If not specified, defaults to 301
func RecordInputFileRandomSeed(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_random_seed"] = value
	}
}

// RecordInputFileShuffleShiftRatio sets the optional file_shuffle_shift_ratio attribute to value.
//
// value: Shifts the list of files after the list is randomly
// shuffled.
// If not specified, defaults to 0
func RecordInputFileShuffleShiftRatio(value float32) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_shuffle_shift_ratio"] = value
	}
}

// RecordInputFileBufferSize sets the optional file_buffer_size attribute to value.
//
// value: The randomization shuffling buffer.
// If not specified, defaults to 10000
func RecordInputFileBufferSize(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_buffer_size"] = value
	}
}

// RecordInputFileParallelism sets the optional file_parallelism attribute to value.
//
// value: How many sstables are opened and concurrently iterated over.
// If not specified, defaults to 16
func RecordInputFileParallelism(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_parallelism"] = value
	}
}

// RecordInputBatchSize sets the optional batch_size attribute to value.
//
// value: The batch size.
// If not specified, defaults to 32
func RecordInputBatchSize(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["batch_size"] = value
	}
}

// RecordInputCompressionType sets the optional compression_type attribute to value.
//
// value: The type of compression for the file. Currently ZLIB and
// GZIP are supported. Defaults to none.
// If not specified, defaults to ""
func RecordInputCompressionType(value string) RecordInputAttr {
	return func(m optionalAttr) {
		m["compression_type"] = value
	}
}

// Emits randomized records.
//
// Arguments:
//	file_pattern: Glob pattern for the data files.
//
// Returns A tensor of shape [batch_size].
func RecordInput(scope *Scope, file_pattern string, optional ...RecordInputAttr) (records tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"file_pattern": file_pattern}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RecordInput",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapIncompleteSizeAttr is an optional argument to OrderedMapIncompleteSize.
type OrderedMapIncompleteSizeAttr func(optionalAttr)

// OrderedMapIncompleteSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapIncompleteSizeCapacity(value int64) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapIncompleteSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapIncompleteSizeMemoryLimit(value int64) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapIncompleteSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapIncompleteSizeContainer(value string) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapIncompleteSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapIncompleteSizeSharedName(value string) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of incomplete elements in the underlying container.
func OrderedMapIncompleteSize(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapIncompleteSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapIncompleteSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapSizeAttr is an optional argument to OrderedMapSize.
type OrderedMapSizeAttr func(optionalAttr)

// OrderedMapSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapSizeCapacity(value int64) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapSizeMemoryLimit(value int64) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapSizeContainer(value string) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapSizeSharedName(value string) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func OrderedMapSize(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapUnstageNoKeyAttr is an optional argument to OrderedMapUnstageNoKey.
type OrderedMapUnstageNoKeyAttr func(optionalAttr)

// OrderedMapUnstageNoKeyCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageNoKeyCapacity(value int64) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapUnstageNoKeyMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageNoKeyMemoryLimit(value int64) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapUnstageNoKeyContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageNoKeyContainer(value string) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapUnstageNoKeySharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageNoKeySharedName(value string) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the (key, value) element with the smallest
//
// key from the underlying container.   If the underlying container
// does not contain elements, the op will block until it does.
func OrderedMapUnstageNoKey(scope *Scope, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapUnstageNoKeyAttr) (key tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapUnstageNoKey",
		Input: []tf.Input{
			indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	key = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapUnstageNoKey", err)
		return
	}
	return key, values
}

// OrderedMapPeekAttr is an optional argument to OrderedMapPeek.
type OrderedMapPeekAttr func(optionalAttr)

// OrderedMapPeekCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapPeekCapacity(value int64) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapPeekMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapPeekMemoryLimit(value int64) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapPeekContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapPeekContainer(value string) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapPeekSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapPeekSharedName(value string) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op peeks at the values at the specified key.  If the
//
// underlying container does not contain this key
// this op will block until it does.   This Op is optimized for
// performance.
func OrderedMapPeek(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapPeekAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapPeek",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapPeek", err)
		return
	}
	return values
}

// MapIncompleteSizeAttr is an optional argument to MapIncompleteSize.
type MapIncompleteSizeAttr func(optionalAttr)

// MapIncompleteSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapIncompleteSizeCapacity(value int64) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapIncompleteSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapIncompleteSizeMemoryLimit(value int64) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapIncompleteSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapIncompleteSizeContainer(value string) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapIncompleteSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapIncompleteSizeSharedName(value string) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of incomplete elements in the underlying container.
func MapIncompleteSize(scope *Scope, dtypes []tf.DataType, optional ...MapIncompleteSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapIncompleteSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapSizeAttr is an optional argument to MapSize.
type MapSizeAttr func(optionalAttr)

// MapSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapSizeCapacity(value int64) MapSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapSizeMemoryLimit(value int64) MapSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapSizeContainer(value string) MapSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapSizeSharedName(value string) MapSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func MapSize(scope *Scope, dtypes []tf.DataType, optional ...MapSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapUnstageNoKeyAttr is an optional argument to MapUnstageNoKey.
type MapUnstageNoKeyAttr func(optionalAttr)

// MapUnstageNoKeyCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageNoKeyCapacity(value int64) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapUnstageNoKeyMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageNoKeyMemoryLimit(value int64) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapUnstageNoKeyContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapUnstageNoKeyContainer(value string) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapUnstageNoKeySharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapUnstageNoKeySharedName(value string) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns a random (key, value)
//
// from the underlying container.   If the underlying container
// does not contain elements, the op will block until it does.
func MapUnstageNoKey(scope *Scope, indices tf.Output, dtypes []tf.DataType, optional ...MapUnstageNoKeyAttr) (key tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapUnstageNoKey",
		Input: []tf.Input{
			indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	key = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapUnstageNoKey", err)
		return
	}
	return key, values
}

// UnbatchAttr is an optional argument to Unbatch.
type UnbatchAttr func(optionalAttr)

// UnbatchContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func UnbatchContainer(value string) UnbatchAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// UnbatchSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func UnbatchSharedName(value string) UnbatchAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Reverses the operation of Batch for a single output Tensor.
//
// An instance of Unbatch either receives an empty batched_tensor, in which case it
// asynchronously waits until the values become available from a concurrently
// running instance of Unbatch with the same container and shared_name, or receives
// a non-empty batched_tensor in which case it finalizes all other concurrently
// running instances and outputs its own element from the batch.
//
// batched_tensor: The possibly transformed output of Batch. The size of the first
//  dimension should remain unchanged by the transformations for the operation to
//  work.
// batch_index: The matching batch_index obtained from Batch.
// id: The id scalar emitted by Batch.
// unbatched_tensor: The Tensor corresponding to this execution.
// timeout_micros: Maximum amount of time (in microseconds) to wait to receive the
//  batched input tensor associated with a given invocation of the op.
// container: Container to control resource sharing.
// shared_name: Instances of Unbatch with the same container and shared_name are
//  assumed to possibly belong to the same batch. If left empty, the op name will
//  be used as the shared name.
func Unbatch(scope *Scope, batched_tensor tf.Output, batch_index tf.Output, id tf.Output, timeout_micros int64, optional ...UnbatchAttr) (unbatched_tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"timeout_micros": timeout_micros}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unbatch",
		Input: []tf.Input{
			batched_tensor, batch_index, id,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapUnstageAttr is an optional argument to MapUnstage.
type MapUnstageAttr func(optionalAttr)

// MapUnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageCapacity(value int64) MapUnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapUnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageMemoryLimit(value int64) MapUnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapUnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapUnstageContainer(value string) MapUnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapUnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapUnstageSharedName(value string) MapUnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the values associated with the key
//
// from the underlying container.   If the underlying container
// does not contain this key, the op will block until it does.
func MapUnstage(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...MapUnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapUnstage",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapUnstage", err)
		return
	}
	return values
}

// StageSizeAttr is an optional argument to StageSize.
type StageSizeAttr func(optionalAttr)

// StageSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageSizeCapacity(value int64) StageSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StageSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageSizeMemoryLimit(value int64) StageSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StageSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func StageSizeContainer(value string) StageSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StageSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func StageSizeSharedName(value string) StageSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func StageSize(scope *Scope, dtypes []tf.DataType, optional ...StageSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StageSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StagePeekAttr is an optional argument to StagePeek.
type StagePeekAttr func(optionalAttr)

// StagePeekCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StagePeekCapacity(value int64) StagePeekAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StagePeekMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StagePeekMemoryLimit(value int64) StagePeekAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StagePeekContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func StagePeekContainer(value string) StagePeekAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StagePeekSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func StagePeekSharedName(value string) StagePeekAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op peeks at the values at the specified index.  If the
//
// underlying container does not contain sufficient elements
// this op will block until it does.   This Op is optimized for
// performance.
func StagePeek(scope *Scope, index tf.Output, dtypes []tf.DataType, optional ...StagePeekAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StagePeek",
		Input: []tf.Input{
			index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("StagePeek", err)
		return
	}
	return values
}

// UnstageAttr is an optional argument to Unstage.
type UnstageAttr func(optionalAttr)

// UnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func UnstageCapacity(value int64) UnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// UnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func UnstageMemoryLimit(value int64) UnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// UnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func UnstageContainer(value string) UnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// UnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func UnstageSharedName(value string) UnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op is similar to a lightweight Dequeue.
//
// The basic functionality is similar to dequeue with many fewer
// capabilities and options.  This Op is optimized for performance.
func Unstage(scope *Scope, dtypes []tf.DataType, optional ...UnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unstage",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("Unstage", err)
		return
	}
	return values
}

// StageAttr is an optional argument to Stage.
type StageAttr func(optionalAttr)

// StageCapacity sets the optional capacity attribute to value.
//
// value: Maximum number of elements in the Staging Area. If > 0, inserts
// on the container will block when the capacity is reached.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageCapacity(value int64) StageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StageMemoryLimit sets the optional memory_limit attribute to value.
//
// value: The maximum number of bytes allowed for Tensors in the Staging Area.
// If > 0, inserts will block until sufficient space is available.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageMemoryLimit(value int64) StageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StageContainer sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container. Otherwise,
// a default container is used.
// If not specified, defaults to ""
func StageContainer(value string) StageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StageSharedName sets the optional shared_name attribute to value.
//
// value: It is necessary to match this name to the matching Unstage Op.
// If not specified, defaults to ""
func StageSharedName(value string) StageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Stage values similar to a lightweight Enqueue.
//
// The basic functionality of this Op is similar to a queue with many
// fewer capabilities and options.  This Op is optimized for performance.
//
// Arguments:
//	values: a list of tensors
// dtypes A list of data types that inserted values should adhere to.
//
// Returns the created operation.
func Stage(scope *Scope, values []tf.Output, optional ...StageAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Stage",
		Input: []tf.Input{
			tf.OutputList(values),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Store the input tensor in the state of the current session.
//
// Arguments:
//	value: The tensor to be stored.
//
// Returns The handle for the tensor stored in the session state, represented
// as a ResourceHandle object.
func GetSessionHandleV2(scope *Scope, value tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetSessionHandleV2",
		Input: []tf.Input{
			value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Store the input tensor in the state of the current session.
//
// Arguments:
//	value: The tensor to be stored.
//
// Returns The handle for the tensor stored in the session state, represented
// as a string.
func GetSessionHandle(scope *Scope, value tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetSessionHandle",
		Input: []tf.Input{
			value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Copy a tensor setting everything outside a central band in each innermost matrix to zero.
//
// The `band` part is computed as follows:
// Assume `input` has `k` dimensions `[I, J, K, ..., M, N]`, then the output is a
// tensor with the same shape where
//
// `band[i, j, k, ..., m, n] = in_band(m, n) * input[i, j, k, ..., m, n]`.
//
// The indicator function
//
// `in_band(m, n) = (num_lower < 0 || (m-n) <= num_lower)) &&
//                  (num_upper < 0 || (n-m) <= num_upper)`.
//
// For example:
//
// ```
// # if 'input' is [[ 0,  1,  2, 3]
// #                [-1,  0,  1, 2]
// #                [-2, -1,  0, 1]
// #                [-3, -2, -1, 0]],
//
// tf.linalg.band_part(input, 1, -1) ==> [[ 0,  1,  2, 3]
//                                        [-1,  0,  1, 2]
//                                        [ 0, -1,  0, 1]
//                                        [ 0,  0, -1, 0]],
//
// tf.linalg.band_part(input, 2, 1) ==> [[ 0,  1,  0, 0]
//                                       [-1,  0,  1, 0]
//                                       [-2, -1,  0, 1]
//                                       [ 0, -2, -1, 0]]
// ```
//
// Useful special cases:
//
// ```
//  tf.linalg.band_part(input, 0, -1) ==> Upper triangular part.
//  tf.linalg.band_part(input, -1, 0) ==> Lower triangular part.
//  tf.linalg.band_part(input, 0, 0) ==> Diagonal.
// ```
//
// Arguments:
//	input: Rank `k` tensor.
//	num_lower: 0-D tensor. Number of subdiagonals to keep. If negative, keep entire
// lower triangle.
//	num_upper: 0-D tensor. Number of superdiagonals to keep. If negative, keep
// entire upper triangle.
//
// Returns Rank `k` tensor of the same shape as input. The extracted banded tensor.
func MatrixBandPart(scope *Scope, input tf.Output, num_lower tf.Output, num_upper tf.Output) (band tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixBandPart",
		Input: []tf.Input{
			input, num_lower, num_upper,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ListDiffAttr is an optional argument to ListDiff.
type ListDiffAttr func(optionalAttr)

// ListDiffOutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func ListDiffOutIdx(value tf.DataType) ListDiffAttr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Computes the difference between two lists of numbers or strings.
//
// Given a list `x` and a list `y`, this operation returns a list `out` that
// represents all values that are in `x` but not in `y`. The returned list `out`
// is sorted in the same order that the numbers appear in `x` (duplicates are
// preserved). This operation also returns a list `idx` that represents the
// position of each `out` element in `x`. In other words:
//
// `out[i] = x[idx[i]] for i in [0, 1, ..., len(out) - 1]`
//
// For example, given this input:
//
// ```
// x = [1, 2, 3, 4, 5, 6]
// y = [1, 3, 5]
// ```
//
// This operation would return:
//
// ```
// out ==> [2, 4, 6]
// idx ==> [1, 3, 5]
// ```
//
// Arguments:
//	x: 1-D. Values to keep.
//	y: 1-D. Values to remove.
//
// Returns:
//	out: 1-D. Values present in `x` but not in `y`.
//	idx: 1-D. Positions of `x` values preserved in `out`.
func ListDiff(scope *Scope, x tf.Output, y tf.Output, optional ...ListDiffAttr) (out tf.Output, idx tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ListDiff",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Deprecated. Use TensorArrayScatterV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayScatterV3
func TensorArrayScatterV2(scope *Scope, handle tf.Output, indices tf.Output, value tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayScatterV2",
		Input: []tf.Input{
			handle, indices, value, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArrayReadV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayReadV3
func TensorArrayReadV2(scope *Scope, handle tf.Output, index tf.Output, flow_in tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "TensorArrayReadV2",
		Input: []tf.Input{
			handle, index, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArrayGradV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayGradV3
func TensorArrayGradV2(scope *Scope, handle tf.Output, flow_in tf.Output, source string) (grad_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"source": source}
	opspec := tf.OpSpec{
		Type: "TensorArrayGradV2",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Get the current size of the TensorArray.
//
// Arguments:
//	handle: The handle to a TensorArray (output of TensorArray or TensorArrayGrad).
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns The current size of the TensorArray.
func TensorArraySizeV3(scope *Scope, handle tf.Output, flow_in tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySizeV3",
		Input: []tf.Input{
			handle, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Split the data from the input value into TensorArray elements.
//
// Assuming that `lengths` takes on values
//
//   ```(n0, n1, ..., n(T-1))```
//
// and that `value` has shape
//
//   ```(n0 + n1 + ... + n(T-1) x d0 x d1 x ...)```,
//
// this splits values into a TensorArray with T tensors.
//
// TensorArray index t will be the subtensor of values with starting position
//
//   ```(n0 + n1 + ... + n(t-1), 0, 0, ...)```
//
// and having size
//
//   ```nt x d0 x d1 x ...```
//
// Arguments:
//	handle: The handle to a TensorArray.
//	value: The concatenated tensor to write to the TensorArray.
//	lengths: The vector of lengths, how to split the rows of value into the
// TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns A float scalar that enforces proper chaining of operations.
func TensorArraySplitV3(scope *Scope, handle tf.Output, value tf.Output, lengths tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySplitV3",
		Input: []tf.Input{
			handle, value, lengths, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorArrayConcatV3Attr is an optional argument to TensorArrayConcatV3.
type TensorArrayConcatV3Attr func(optionalAttr)

// TensorArrayConcatV3ElementShapeExcept0 sets the optional element_shape_except0 attribute to value.
//
// value: The expected shape of an element, if known,
// excluding the first dimension. Used to validate the shapes of
// TensorArray elements. If this shape is not fully specified, concatenating
// zero-size TensorArrays is an error.
// If not specified, defaults to {unknown_rank:true}
func TensorArrayConcatV3ElementShapeExcept0(value tf.Shape) TensorArrayConcatV3Attr {
	return func(m optionalAttr) {
		m["element_shape_except0"] = value
	}
}

// Concat the elements from the TensorArray into value `value`.
//
// Takes `T` elements of shapes
//
//   ```
//   (n0 x d0 x d1 x ...), (n1 x d0 x d1 x ...), ..., (n(T-1) x d0 x d1 x ...)
//   ```
//
// and concatenates them into a Tensor of shape:
//
//   ```(n0 + n1 + ... + n(T-1) x d0 x d1 x ...)```
//
// All elements must have the same shape (excepting the first dimension).
//
// Arguments:
//	handle: The handle to a TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	dtype: The type of the elem that is returned.
//
// Returns:
//	value: All of the elements in the TensorArray, concatenated along the first
// axis.
//	lengths: A vector of the row sizes of the original T elements in the
// value output.  In the example above, this would be the values:
// `(n1, n2, ..., n(T-1))`.
func TensorArrayConcatV3(scope *Scope, handle tf.Output, flow_in tf.Output, dtype tf.DataType, optional ...TensorArrayConcatV3Attr) (value tf.Output, lengths tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayConcatV3",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// TensorArrayGatherV3Attr is an optional argument to TensorArrayGatherV3.
type TensorArrayGatherV3Attr func(optionalAttr)

// TensorArrayGatherV3ElementShape sets the optional element_shape attribute to value.
//
// value: The expected shape of an element, if known. Used to
// validate the shapes of TensorArray elements. If this shape is not
// fully specified, gathering zero-size TensorArrays is an error.
// If not specified, defaults to {unknown_rank:true}
func TensorArrayGatherV3ElementShape(value tf.Shape) TensorArrayGatherV3Attr {
	return func(m optionalAttr) {
		m["element_shape"] = value
	}
}

// Gather specific elements from the TensorArray into output `value`.
//
// All elements selected by `indices` must have the same shape.
//
// Arguments:
//	handle: The handle to a TensorArray.
//	indices: The locations in the TensorArray from which to read tensor elements.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	dtype: The type of the elem that is returned.
//
// Returns All of the elements in the TensorArray, concatenated along a new
// axis (the new dimension 0).
func TensorArrayGatherV3(scope *Scope, handle tf.Output, indices tf.Output, flow_in tf.Output, dtype tf.DataType, optional ...TensorArrayGatherV3Attr) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayGatherV3",
		Input: []tf.Input{
			handle, indices, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GatherAttr is an optional argument to Gather.
type GatherAttr func(optionalAttr)

// GatherValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func GatherValidateIndices(value bool) GatherAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Gather slices from `params` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
//
// ```python
//     # Scalar indices
//     output[:, ..., :] = params[indices, :, ... :]
//
//     # Vector indices
//     output[i, :, ..., :] = params[indices[i], :, ... :]
//
//     # Higher rank indices
//     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
// ```
//
// If `indices` is a permutation and `len(indices) == params.shape[0]` then
// this operation will permute `params` accordingly.
//
// `validate_indices`: DEPRECATED. If this operation is assigned to CPU, values in
// `indices` are always validated to be within range. If assigned to GPU,
// out-of-bound indices result in safe but unspecified behavior, which may include
// raising an error.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
// </div>
func Gather(scope *Scope, params tf.Output, indices tf.Output, optional ...GatherAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Gather",
		Input: []tf.Input{
			params, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Read an element from the TensorArray into output `value`.
//
// Arguments:
//	handle: The handle to a TensorArray.
//
//	flow_in: A float scalar that enforces proper chaining of operations.
//	dtype: The type of the elem that is returned.
//
// Returns The tensor that is read from the TensorArray.
func TensorArrayReadV3(scope *Scope, handle tf.Output, index tf.Output, flow_in tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "TensorArrayReadV3",
		Input: []tf.Input{
			handle, index, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Push an element onto the tensor_array.
//
// Arguments:
//	handle: The handle to a TensorArray.
//	index: The position to write to inside the TensorArray.
//	value: The tensor to write to the TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns A float scalar that enforces proper chaining of operations.
func TensorArrayWriteV3(scope *Scope, handle tf.Output, index tf.Output, value tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayWriteV3",
		Input: []tf.Input{
			handle, index, value, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorArray for storing multiple gradients of values in the given handle.
//
// Similar to TensorArrayGradV3. However it creates an accumulator with an
// expanded shape compared to the input TensorArray whose gradient is being
// computed. This enables multiple gradients for the same TensorArray to be
// calculated using the same accumulator.
//
// Arguments:
//	handle: The handle to the forward TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	shape_to_prepend: An int32 vector representing a shape. Elements in the gradient accumulator will
// have shape which is this shape_to_prepend value concatenated with shape of the
// elements in the TensorArray corresponding to the input handle.
//	source: The gradient source string, used to decide which gradient TensorArray
// to return.
func TensorArrayGradWithShape(scope *Scope, handle tf.Output, flow_in tf.Output, shape_to_prepend tf.Output, source string) (grad_handle tf.Output, flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"source": source}
	opspec := tf.OpSpec{
		Type: "TensorArrayGradWithShape",
		Input: []tf.Input{
			handle, flow_in, shape_to_prepend,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Delete the stack from its resource container.
//
// Arguments:
//	handle: The handle to a stack.
//
// Returns the created operation.
func StackCloseV2(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StackCloseV2",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Pop the element at the top of the stack.
//
// Arguments:
//	handle: The handle to a stack.
//	elem_type: The type of the elem that is popped.
//
// Returns The tensor that is popped from the top of the stack.
func StackPopV2(scope *Scope, handle tf.Output, elem_type tf.DataType) (elem tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"elem_type": elem_type}
	opspec := tf.OpSpec{
		Type: "StackPopV2",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StackPushV2Attr is an optional argument to StackPushV2.
type StackPushV2Attr func(optionalAttr)

// StackPushV2SwapMemory sets the optional swap_memory attribute to value.
//
// value: Swap `elem` to CPU. Default to false.
// If not specified, defaults to false
func StackPushV2SwapMemory(value bool) StackPushV2Attr {
	return func(m optionalAttr) {
		m["swap_memory"] = value
	}
}

// Push an element onto the stack.
//
// Arguments:
//	handle: The handle to a stack.
//	elem: The tensor to be pushed onto the stack.
//
// Returns The same tensor as the input 'elem'.
func StackPushV2(scope *Scope, handle tf.Output, elem tf.Output, optional ...StackPushV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StackPushV2",
		Input: []tf.Input{
			handle, elem,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StackV2Attr is an optional argument to StackV2.
type StackV2Attr func(optionalAttr)

// StackV2StackName sets the optional stack_name attribute to value.
//
// value: Overrides the name used for the temporary stack resource. Default
// value is the name of the 'Stack' op (which is guaranteed unique).
// If not specified, defaults to ""
func StackV2StackName(value string) StackV2Attr {
	return func(m optionalAttr) {
		m["stack_name"] = value
	}
}

// A stack that produces elements in first-in last-out order.
//
// Arguments:
//	max_size: The maximum size of the stack if non-negative. If negative, the stack
// size is unlimited.
//	elem_type: The type of the elements on the stack.
//
// Returns The handle to the stack.
func StackV2(scope *Scope, max_size tf.Output, elem_type tf.DataType, optional ...StackV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"elem_type": elem_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StackV2",
		Input: []tf.Input{
			max_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Checks a tensor for NaN, -Inf and +Inf values.
//
// When run, reports an `InvalidArgument` error if `tensor` has any values
// that are not a number (NaN) or infinity (Inf). Otherwise, returns the input
// tensor. Unlike CheckNumerics (V1), CheckNumericsV2 distinguishes -Inf and +Inf
// in the errors it throws.
//
// Arguments:
//
//	message: Prefix of the error message.
func CheckNumericsV2(scope *Scope, tensor tf.Output, message string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"message": message}
	opspec := tf.OpSpec{
		Type: "CheckNumericsV2",
		Input: []tf.Input{
			tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Applies a gradient to a given accumulator.
//
// Does not add if local_step is lesser than the accumulator's global_step.
//
// Arguments:
//	handle: The handle to a accumulator.
//	local_step: The local_step value at which the gradient was computed.
//	gradient: A tensor of the gradient to be accumulated.
//
// Returns the created operation.
func ResourceAccumulatorApplyGradient(scope *Scope, handle tf.Output, local_step tf.Output, gradient tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceAccumulatorApplyGradient",
		Input: []tf.Input{
			handle, local_step, gradient,
		},
	}
	return scope.AddOperation(opspec)
}

// Wraps the XLA Pad operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#pad
// .
//
// Arguments:
//	input: A `Tensor` of type T.
//	padding_value: A scalar `Tensor` of type T.
//	padding_low: the padding to apply at the start of each input dimensions. Must
// be a compile-time constant 1D tensor of length equal to rank of input.
//	padding_high: the padding to apply at the end of each input dimension. Must
// be a compile-time constant 1D tensor of length equal to rank of input.
//	padding_interior: the padding to apply between each input element. Must
// be a compile-time constant 1D tensor of length equal to rank of input,
// containing only non-negative values.
//
// Returns A `Tensor` of type T.
func XlaPad(scope *Scope, input tf.Output, padding_value tf.Output, padding_low tf.Output, padding_high tf.Output, padding_interior tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaPad",
		Input: []tf.Input{
			input, padding_value, padding_low, padding_high, padding_interior,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Updates the accumulator with a new value for global_step.
//
// Logs warning if the accumulator's value is already higher than
// new_global_step.
//
// Arguments:
//	handle: The handle to an accumulator.
//	new_global_step: The new global_step value to set.
//
// Returns the created operation.
func ResourceAccumulatorSetGlobalStep(scope *Scope, handle tf.Output, new_global_step tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceAccumulatorSetGlobalStep",
		Input: []tf.Input{
			handle, new_global_step,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the number of elements in the given queue.
//
// Arguments:
//	handle: The handle to a queue.
//
// Returns The number of elements in the given queue.
func QueueSizeV2(scope *Scope, handle tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "QueueSizeV2",
		Input: []tf.Input{
			handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QueueEnqueueManyV2Attr is an optional argument to QueueEnqueueManyV2.
type QueueEnqueueManyV2Attr func(optionalAttr)

// QueueEnqueueManyV2TimeoutMs sets the optional timeout_ms attribute to value.
//
// value: If the queue is too full, this operation will block for up
// to timeout_ms milliseconds.
// Note: This option is not supported yet.
// If not specified, defaults to -1
func QueueEnqueueManyV2TimeoutMs(value int64) QueueEnqueueManyV2Attr {
	return func(m optionalAttr) {
		m["timeout_ms"] = value
	}
}

// Enqueues zero or more tuples of one or more tensors in the given queue.
//
// This operation slices each component tensor along the 0th dimension to
// make multiple queue elements. All of the tuple components must have the
// same size in the 0th dimension.
//
// The components input has k elements, which correspond to the components of
// tuples stored in the given queue.
//
// N.B. If the queue is full, this operation will block until the given
// elements have been enqueued (or 'timeout_ms' elapses, if specified).
//
// Arguments:
//	handle: The handle to a queue.
//	components: One or more tensors from which the enqueued tensors should
// be taken.
//
// Returns the created operation.
func QueueEnqueueManyV2(scope *Scope, handle tf.Output, components []tf.Output, optional ...QueueEnqueueManyV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueEnqueueManyV2",
		Input: []tf.Input{
			handle, tf.OutputList(components),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// QueueEnqueueV2Attr is an optional argument to QueueEnqueueV2.
type QueueEnqueueV2Attr func(optionalAttr)

// QueueEnqueueV2TimeoutMs sets the optional timeout_ms attribute to value.
//
// value: If the queue is full, this operation will block for up to
// timeout_ms milliseconds.
// Note: This option is not supported yet.
// If not specified, defaults to -1
func QueueEnqueueV2TimeoutMs(value int64) QueueEnqueueV2Attr {
	return func(m optionalAttr) {
		m["timeout_ms"] = value
	}
}

// Enqueues a tuple of one or more tensors in the given queue.
//
// The components input has k elements, which correspond to the components of
// tuples stored in the given queue.
//
// N.B. If the queue is full, this operation will block until the given
// element has been enqueued (or 'timeout_ms' elapses, if specified).
//
// Arguments:
//	handle: The handle to a queue.
//	components: One or more tensors from which the enqueued tensors should be taken.
//
// Returns the created operation.
func QueueEnqueueV2(scope *Scope, handle tf.Output, components []tf.Output, optional ...QueueEnqueueV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueEnqueueV2",
		Input: []tf.Input{
			handle, tf.OutputList(components),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// PriorityQueueV2Attr is an optional argument to PriorityQueueV2.
type PriorityQueueV2Attr func(optionalAttr)

// PriorityQueueV2ComponentTypes sets the optional component_types attribute to value.
//
// value: The type of each component in a value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func PriorityQueueV2ComponentTypes(value []tf.DataType) PriorityQueueV2Attr {
	return func(m optionalAttr) {
		m["component_types"] = value
	}
}

// PriorityQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func PriorityQueueV2Capacity(value int64) PriorityQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// PriorityQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func PriorityQueueV2Container(value string) PriorityQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// PriorityQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func PriorityQueueV2SharedName(value string) PriorityQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that produces elements sorted by the first component value.
//
// Note that the PriorityQueue requires the first component of any element
// to be a scalar int64, in addition to the other elements declared by
// component_types.  Therefore calls to Enqueue and EnqueueMany (resp. Dequeue
// and DequeueMany) on a PriorityQueue will all require (resp. output) one extra
// entry in their input (resp. output) lists.
//
// Arguments:
//	shapes: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types. If the length of
// this attr is 0, the shapes of queue elements are not constrained, and
// only one element may be dequeued at a time.
//
// Returns The handle to the queue.
func PriorityQueueV2(scope *Scope, shapes []tf.Shape, optional ...PriorityQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PriorityQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Partitions `data` into `num_partitions` tensors using indices from `partitions`.
//
// For each index tuple `js` of size `partitions.ndim`, the slice `data[js, ...]`
// becomes part of `outputs[partitions[js]]`.  The slices with `partitions[js] = i`
// are placed in `outputs[i]` in lexicographic order of `js`, and the first
// dimension of `outputs[i]` is the number of entries in `partitions` equal to `i`.
// In detail,
//
// ```python
//     outputs[i].shape = [sum(partitions == i)] + data.shape[partitions.ndim:]
//
//     outputs[i] = pack([data[js, ...] for js if partitions[js] == i])
// ```
//
// `data.shape` must start with `partitions.shape`.
//
// For example:
//
// ```python
//     # Scalar partitions.
//     partitions = 1
//     num_partitions = 2
//     data = [10, 20]
//     outputs[0] = []  # Empty with shape [0, 2]
//     outputs[1] = [[10, 20]]
//
//     # Vector partitions.
//     partitions = [0, 0, 1, 1, 0]
//     num_partitions = 2
//     data = [10, 20, 30, 40, 50]
//     outputs[0] = [10, 20, 50]
//     outputs[1] = [30, 40]
// ```
//
// See `dynamic_stitch` for an example on how to merge partitions back.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicPartition.png" alt>
// </div>
//
// Arguments:
//
//	partitions: Any shape.  Indices in the range `[0, num_partitions)`.
//	num_partitions: The number of partitions to output.
func DynamicPartition(scope *Scope, data tf.Output, partitions tf.Output, num_partitions int64) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_partitions": num_partitions}
	opspec := tf.OpSpec{
		Type: "DynamicPartition",
		Input: []tf.Input{
			data, partitions,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("DynamicPartition", err)
		return
	}
	return outputs
}

// ResourceConditionalAccumulatorAttr is an optional argument to ResourceConditionalAccumulator.
type ResourceConditionalAccumulatorAttr func(optionalAttr)

// ResourceConditionalAccumulatorContainer sets the optional container attribute to value.
//
// value: If non-empty, this accumulator is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func ResourceConditionalAccumulatorContainer(value string) ResourceConditionalAccumulatorAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ResourceConditionalAccumulatorSharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this accumulator will be shared under the
// given name across multiple sessions.
// If not specified, defaults to ""
func ResourceConditionalAccumulatorSharedName(value string) ResourceConditionalAccumulatorAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// ResourceConditionalAccumulatorReductionType sets the optional reduction_type attribute to value.
// If not specified, defaults to "MEAN"
func ResourceConditionalAccumulatorReductionType(value string) ResourceConditionalAccumulatorAttr {
	return func(m optionalAttr) {
		m["reduction_type"] = value
	}
}

// A conditional accumulator for aggregating gradients.
//
// The accumulator accepts gradients marked with local_step greater or
// equal to the most recent global_step known to the accumulator. The
// average can be extracted from the accumulator, provided sufficient
// gradients have been accumulated. Extracting the average automatically
// resets the aggregate to 0, and increments the global_step recorded by
// the accumulator.
// This is a resource version of ConditionalAccumulator that will work in TF2.0
// with tf.cond version 2.
//
// Arguments:
//	dtype: The type of the value being accumulated.
//	shape: The shape of the values, can be [], in which case shape is unknown.
//
// Returns The handle to the accumulator.
func ResourceConditionalAccumulator(scope *Scope, dtype tf.DataType, shape tf.Shape, optional ...ResourceConditionalAccumulatorAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceConditionalAccumulator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MultiDeviceIteratorFromStringHandleAttr is an optional argument to MultiDeviceIteratorFromStringHandle.
type MultiDeviceIteratorFromStringHandleAttr func(optionalAttr)

// MultiDeviceIteratorFromStringHandleOutputTypes sets the optional output_types attribute to value.
//
// value: The type list for the return values.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func MultiDeviceIteratorFromStringHandleOutputTypes(value []tf.DataType) MultiDeviceIteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_types"] = value
	}
}

// MultiDeviceIteratorFromStringHandleOutputShapes sets the optional output_shapes attribute to value.
//
// value: The list of shapes being produced.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func MultiDeviceIteratorFromStringHandleOutputShapes(value []tf.Shape) MultiDeviceIteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_shapes"] = value
	}
}

// Generates a MultiDeviceIterator resource from its provided string handle.
//
// Arguments:
//	string_handle: String representing the resource.
//
// Returns A MultiDeviceIterator resource.
func MultiDeviceIteratorFromStringHandle(scope *Scope, string_handle tf.Output, optional ...MultiDeviceIteratorFromStringHandleAttr) (multi_device_iterator tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorFromStringHandle",
		Input: []tf.Input{
			string_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorArray for storing the gradients of values in the given handle.
//
// If the given TensorArray gradient already exists, returns a reference to it.
//
// Locks the size of the original TensorArray by disabling its dynamic size flag.
//
// **A note about the input flow_in:**
//
// The handle flow_in forces the execution of the gradient lookup to occur
// only after certain other operations have occurred.  For example, when
// the forward TensorArray is dynamically sized, writes to this TensorArray
// may resize the object.  The gradient TensorArray is statically sized based
// on the size of the forward TensorArray when this operation executes.
// Furthermore, the size of the forward TensorArray is frozen by this call.
// As a result, the flow is used to ensure that the call to generate the gradient
// TensorArray only happens after all writes are executed.
//
// In the case of dynamically sized TensorArrays, gradient computation should
// only be performed on read operations that have themselves been chained via
// flow to occur only after all writes have executed. That way the final size
// of the forward TensorArray is known when this operation is called.
//
// **A note about the source attribute:**
//
// TensorArray gradient calls use an accumulator TensorArray object.  If
// multiple gradients are calculated and run in the same session, the multiple
// gradient nodes may accidentally flow through the same accumulator TensorArray.
// This double counts and generally breaks the TensorArray gradient flow.
//
// The solution is to identify which gradient call this particular
// TensorArray gradient is being called in.  This is performed by identifying
// a unique string (e.g. "gradients", "gradients_1", ...) from the input
// gradient Tensor's name.  This string is used as a suffix when creating
// the TensorArray gradient object here (the attribute `source`).
//
// The attribute `source` is added as a suffix to the forward TensorArray's
// name when performing the creation / lookup, so that each separate gradient
// calculation gets its own TensorArray accumulator.
//
// Arguments:
//	handle: The handle to the forward TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	source: The gradient source string, used to decide which gradient TensorArray
// to return.
func TensorArrayGradV3(scope *Scope, handle tf.Output, flow_in tf.Output, source string) (grad_handle tf.Output, flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"source": source}
	opspec := tf.OpSpec{
		Type: "TensorArrayGradV3",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Produces a string handle for the given MultiDeviceIterator.
//
// Arguments:
//	multi_device_iterator: A MultiDeviceIterator resource.
//
// Returns A string representing the resource.
func MultiDeviceIteratorToStringHandle(scope *Scope, multi_device_iterator tf.Output) (string_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorToStringHandle",
		Input: []tf.Input{
			multi_device_iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizeAndDequantizeV4Attr is an optional argument to QuantizeAndDequantizeV4.
type QuantizeAndDequantizeV4Attr func(optionalAttr)

// QuantizeAndDequantizeV4SignedInput sets the optional signed_input attribute to value.
//
// value: Whether the quantization is signed or unsigned. (actually this parameter should
// have been called <b>`signed_output`</b>)
// If not specified, defaults to true
func QuantizeAndDequantizeV4SignedInput(value bool) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["signed_input"] = value
	}
}

// QuantizeAndDequantizeV4NumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization.
// If not specified, defaults to 8
func QuantizeAndDequantizeV4NumBits(value int64) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// QuantizeAndDequantizeV4RangeGiven sets the optional range_given attribute to value.
//
// value: Whether the range is given or should be determined from the `input` tensor.
// If not specified, defaults to false
func QuantizeAndDequantizeV4RangeGiven(value bool) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["range_given"] = value
	}
}

// QuantizeAndDequantizeV4RoundMode sets the optional round_mode attribute to value.
//
// value: The 'round_mode' attribute controls which rounding tie-breaking algorithm is
// used when rounding float values to their quantized equivalents. The following
// rounding modes are currently supported:
//
// *   HALF_TO_EVEN: this is the default round_mode.
// *   HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
//     rounds up to -7.
//
// If not specified, defaults to "HALF_TO_EVEN"
func QuantizeAndDequantizeV4RoundMode(value string) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["round_mode"] = value
	}
}

// QuantizeAndDequantizeV4NarrowRange sets the optional narrow_range attribute to value.
//
// value: If True, then the absolute value of the quantized minimum value is the same as
// the quantized maximum value, instead of 1 greater.
// i.e. for 8 bit quantization, the minimum value is -127 instead of -128.
// If not specified, defaults to false
func QuantizeAndDequantizeV4NarrowRange(value bool) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// QuantizeAndDequantizeV4Axis sets the optional axis attribute to value.
//
// value: If specified, this axis is treated as a channel or slice axis, and a separate
// quantization range is used for each channel or slice along this axis.
// If not specified, defaults to -1
func QuantizeAndDequantizeV4Axis(value int64) QuantizeAndDequantizeV4Attr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Quantizes then dequantizes a tensor.
//
// This is almost identical to QuantizeAndDequantizeV2, except that it returns a
// gradient of 1 for inputs that are within the quantization range, or 0 otherwise.
//
// Arguments:
//	input: Tensor to quantize and then dequantize.
//	input_min: If `range_given == True`, this specifies the minimum input value that needs to
// be represented, otherwise it is determined from the min value of the `input`
// tensor.
//	input_max: If `range_given == True`, this specifies the maximum input value that needs to
// be represented, otherwise it is determined from the max value of the `input`
// tensor.
func QuantizeAndDequantizeV4(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, optional ...QuantizeAndDequantizeV4Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeAndDequantizeV4",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets next element for the provided shard number.
//
// Arguments:
//	multi_device_iterator: A MultiDeviceIterator resource.
//	shard_num: Integer representing which shard to fetch data for.
//	incarnation_id: Which incarnation of the MultiDeviceIterator is running.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
//
// Returns Result of the get_next on the dataset.
func MultiDeviceIteratorGetNextFromShard(scope *Scope, multi_device_iterator tf.Output, shard_num tf.Output, incarnation_id tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorGetNextFromShard",
		Input: []tf.Input{
			multi_device_iterator, shard_num, incarnation_id,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("MultiDeviceIteratorGetNextFromShard", err)
		return
	}
	return components
}

// Creates a MultiDeviceIterator resource.
//
// Arguments:
//	devices: A list of devices the iterator works across.
//	shared_name: If non-empty, this resource will be shared under the given name
// across multiple sessions.
//	container: If non-empty, this resource is placed in the given container.
// Otherwise, a default container is used.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
//
// Returns Handle to the resource created.
func MultiDeviceIterator(scope *Scope, devices []string, shared_name string, container string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"devices": devices, "shared_name": shared_name, "container": container, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BoostedTreesCalculateBestFeatureSplitAttr is an optional argument to BoostedTreesCalculateBestFeatureSplit.
type BoostedTreesCalculateBestFeatureSplitAttr func(optionalAttr)

// BoostedTreesCalculateBestFeatureSplitSplitType sets the optional split_type attribute to value.
//
// value: A string indicating if this Op should perform inequality split or equality split.
// If not specified, defaults to "inequality"
func BoostedTreesCalculateBestFeatureSplitSplitType(value string) BoostedTreesCalculateBestFeatureSplitAttr {
	return func(m optionalAttr) {
		m["split_type"] = value
	}
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary: A Rank 4 tensor (#shape=[max_splits, feature_dims, bucket, stats_dims]) for accumulated stats summary (gradient/hessian) per node, per dimension, per buckets for each feature.
// The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns:
//	node_ids: A Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.
//	gains: A Rank 1 tensors indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.
//	feature_dimensions: A Rank 1 tensors indicating the best feature dimension for each feature to split for certain nodes if the feature is multi-dimension. See above for details like shapes and sizes.
//	thresholds: A Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.
//	left_node_contribs: A Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.
//	right_node_contribs: A Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
//	split_with_default_directions: A Rank 1 tensors indicating the which direction to go if data is missing. See above for details like shapes and sizes.
// Inequality with default left returns 0, inequality with default right returns 1, equality with default right returns 2.
func BoostedTreesCalculateBestFeatureSplit(scope *Scope, node_id_range tf.Output, stats_summary tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64, optional ...BoostedTreesCalculateBestFeatureSplitAttr) (node_ids tf.Output, gains tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestFeatureSplit",
		Input: []tf.Input{
			node_id_range, stats_summary, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Wraps the XLA DynamicUpdateSlice operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#dynamicupdateslice
// .
//
// XlaDynamicUpdateSlice generates a result which is the value of the `input`
// operand, with a slice update overwritten at `indices`. The shape of `update`
// determines the shape of the sub-array of the result which is updated. The shape
// of indices must be rank == 1, with dimension size equal to the rank of `input`.
//
// Handling of out-of-bounds slice indices is implementation-defined.
//
// Arguments:
//	input: A `Tensor` of type T.
//	update: A `Tensor` of type T. Same rank as `input`.
//	indices: A vector of indices into `input`. Must have length equal to the rank of
// `input`.
//
// Returns A `Tensor` of type T.
func XlaDynamicUpdateSlice(scope *Scope, input tf.Output, update tf.Output, indices tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaDynamicUpdateSlice",
		Input: []tf.Input{
			input, update, indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ModelDatasetAttr is an optional argument to ModelDataset.
type ModelDatasetAttr func(optionalAttr)

// ModelDatasetAlgorithm sets the optional algorithm attribute to value.
// If not specified, defaults to 0
func ModelDatasetAlgorithm(value int64) ModelDatasetAttr {
	return func(m optionalAttr) {
		m["algorithm"] = value
	}
}

// ModelDatasetCpuBudget sets the optional cpu_budget attribute to value.
// If not specified, defaults to 0
func ModelDatasetCpuBudget(value int64) ModelDatasetAttr {
	return func(m optionalAttr) {
		m["cpu_budget"] = value
	}
}

// ModelDatasetRamBudget sets the optional ram_budget attribute to value.
// If not specified, defaults to 0
func ModelDatasetRamBudget(value int64) ModelDatasetAttr {
	return func(m optionalAttr) {
		m["ram_budget"] = value
	}
}

// Identity transformation that models performance.
//
// Identity transformation that models performance.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//
//
func ModelDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ModelDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ModelDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a list of tensors with the same shapes and contents as the input
//
// tensors.
//
// This op can be used to override the gradient for complicated functions. For
// example, suppose y = f(x) and we wish to apply a custom function g for backprop
// such that dx = g(dy). In Python,
//
// ```python
// with tf.get_default_graph().gradient_override_map(
//     {'IdentityN': 'OverrideGradientWithG'}):
//   y, _ = identity_n([f(x), x])
//
// @tf.RegisterGradient('OverrideGradientWithG')
// def ApplyG(op, dy, _):
//   return [None, g(dy)]  # Do not backprop to f(x).
// ```
func IdentityN(scope *Scope, input []tf.Output) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IdentityN",
		Input: []tf.Input{
			tf.OutputList(input),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("IdentityN", err)
		return
	}
	return output
}

// Returns true if and only if the given Optional variant has a value.
func OptionalHasValue(scope *Scope, optional tf.Output) (has_value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalHasValue",
		Input: []tf.Input{
			optional,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Constructs an Optional variant from a tuple of tensors.
func OptionalFromValue(scope *Scope, components []tf.Output) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalFromValue",
		Input: []tf.Input{
			tf.OutputList(components),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptimizeDatasetV2Attr is an optional argument to OptimizeDatasetV2.
type OptimizeDatasetV2Attr func(optionalAttr)

// OptimizeDatasetV2OptimizationConfigs sets the optional optimization_configs attribute to value.
// If not specified, defaults to {}
func OptimizeDatasetV2OptimizationConfigs(value []string) OptimizeDatasetV2Attr {
	return func(m optionalAttr) {
		m["optimization_configs"] = value
	}
}

// Creates a dataset by applying related optimizations to `input_dataset`.
//
// Creates a dataset by applying related optimizations to `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	optimizations_enabled: A `tf.string` vector `tf.Tensor` identifying user enabled optimizations.
//	optimizations_disabled: A `tf.string` vector `tf.Tensor` identifying user disabled optimizations.
//	optimizations_default: A `tf.string` vector `tf.Tensor` identifying optimizations by default.
//
//
func OptimizeDatasetV2(scope *Scope, input_dataset tf.Output, optimizations_enabled tf.Output, optimizations_disabled tf.Output, optimizations_default tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptimizeDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptimizeDatasetV2",
		Input: []tf.Input{
			input_dataset, optimizations_enabled, optimizations_disabled, optimizations_default,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptimizeDatasetAttr is an optional argument to OptimizeDataset.
type OptimizeDatasetAttr func(optionalAttr)

// OptimizeDatasetOptimizationConfigs sets the optional optimization_configs attribute to value.
// If not specified, defaults to {}
func OptimizeDatasetOptimizationConfigs(value []string) OptimizeDatasetAttr {
	return func(m optionalAttr) {
		m["optimization_configs"] = value
	}
}

// Creates a dataset by applying optimizations to `input_dataset`.
//
// Creates a dataset by applying optimizations to `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	optimizations: A `tf.string` vector `tf.Tensor` identifying optimizations to use.
//
//
func OptimizeDataset(scope *Scope, input_dataset tf.Output, optimizations tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptimizeDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptimizeDataset",
		Input: []tf.Input{
			input_dataset, optimizations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DatasetToGraphAttr is an optional argument to DatasetToGraph.
type DatasetToGraphAttr func(optionalAttr)

// DatasetToGraphStatefulWhitelist sets the optional stateful_whitelist attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func DatasetToGraphStatefulWhitelist(value []string) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["stateful_whitelist"] = value
	}
}

// DatasetToGraphAllowStateful sets the optional allow_stateful attribute to value.
// If not specified, defaults to false
func DatasetToGraphAllowStateful(value bool) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["allow_stateful"] = value
	}
}

// DatasetToGraphStripDeviceAssignment sets the optional strip_device_assignment attribute to value.
// If not specified, defaults to false
func DatasetToGraphStripDeviceAssignment(value bool) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["strip_device_assignment"] = value
	}
}

// Returns a serialized GraphDef representing `input_dataset`.
//
// Returns a graph representation for `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return the graph representation for.
//
// Returns The graph representation of the dataset (as serialized GraphDef).
func DatasetToGraph(scope *Scope, input_dataset tf.Output, optional ...DatasetToGraphAttr) (graph tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToGraph",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts the given `resource_handle` representing an iterator to a string.
//
// Arguments:
//	resource_handle: A handle to an iterator resource.
//
// Returns A string representation of the given handle.
func IteratorToStringHandle(scope *Scope, resource_handle tf.Output) (string_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IteratorToStringHandle",
		Input: []tf.Input{
			resource_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptionsDatasetAttr is an optional argument to OptionsDataset.
type OptionsDatasetAttr func(optionalAttr)

// OptionsDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func OptionsDatasetMetadata(value string) OptionsDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset by attaching tf.data.Options to `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	serialized_options: A `tf.string` scalar `tf.Tensor` of serialized `tf.data.Options` protocol buffer.
//
//
func OptionsDataset(scope *Scope, input_dataset tf.Output, serialized_options string, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptionsDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"serialized_options": serialized_options, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptionsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator.
//
// This operation is a synchronous version IteratorGetNext. It should only be used
// in situations where the iterator does not block the calling thread, or where
// the calling thread is not a member of the thread pool used to execute parallel
// operations (e.g. in eager mode).
func IteratorGetNextSync(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextSync",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNextSync", err)
		return
	}
	return components
}

// Makes a new iterator from the given `dataset` and stores it in `iterator`.
//
// This operation may be executed multiple times. Each execution will reset the
// iterator in `iterator` to the first element of `dataset`.
//
// Returns the created operation.
func MakeIterator(scope *Scope, dataset tf.Output, iterator tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MakeIterator",
		Input: []tf.Input{
			dataset, iterator,
		},
	}
	return scope.AddOperation(opspec)
}

// A container for an iterator resource.
//
// Arguments:
//	handle: A handle to the iterator to delete.
//	deleter: A variant deleter.
//
// Returns the created operation.
func DeleteIterator(scope *Scope, handle tf.Output, deleter tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteIterator",
		Input: []tf.Input{
			handle, deleter,
		},
	}
	return scope.AddOperation(opspec)
}

// Splits a tensor into `num_split` tensors along one dimension.
//
// Arguments:
//	value: The tensor to split.
//	size_splits: list containing the sizes of each output tensor along the split
// dimension. Must sum to the dimension of value along split_dim.
// Can contain one -1 indicating that dimension is to be inferred.
//	axis: 0-D.  The dimension along which to split.  Must be in the range
// `[-rank(value), rank(value))`.
//
//
// Returns Tensors whose shape matches that of `value`
// except along `axis`, where their sizes are
// `size_splits[i]`.
func SplitV(scope *Scope, value tf.Output, size_splits tf.Output, axis tf.Output, num_split int64) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_split": num_split}
	opspec := tf.OpSpec{
		Type: "SplitV",
		Input: []tf.Input{
			value, size_splits, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("SplitV", err)
		return
	}
	return output
}

// A container for an iterator resource.
//
// Returns:
//	handle: A handle to the iterator that can be passed to a "MakeIterator" or
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.
//	deleter: A variant deleter that should be passed into the op that deletes the iterator.
func AnonymousIteratorV2(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output, deleter tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIteratorV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator" or
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.
func AnonymousIterator(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator"
// or "IteratorGetNext" op.
func Iterator(scope *Scope, shared_name string, container string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shared_name": shared_name, "container": container, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "Iterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TFRecordDatasetAttr is an optional argument to TFRecordDataset.
type TFRecordDatasetAttr func(optionalAttr)

// TFRecordDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func TFRecordDatasetMetadata(value string) TFRecordDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that emits the records from one or more TFRecord files.
//
// Arguments:
//	filenames: A scalar or vector containing the name(s) of the file(s) to be
// read.
//	compression_type: A scalar containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
//	buffer_size: A scalar representing the number of bytes to buffer. A value of
// 0 means no buffering will be performed.
func TFRecordDataset(scope *Scope, filenames tf.Output, compression_type tf.Output, buffer_size tf.Output, optional ...TFRecordDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TFRecordDataset",
		Input: []tf.Input{
			filenames, compression_type, buffer_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FixedLengthRecordDatasetAttr is an optional argument to FixedLengthRecordDataset.
type FixedLengthRecordDatasetAttr func(optionalAttr)

// FixedLengthRecordDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func FixedLengthRecordDatasetMetadata(value string) FixedLengthRecordDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that emits the records from one or more binary files.
//
// Arguments:
//	filenames: A scalar or a vector containing the name(s) of the file(s) to be
// read.
//	header_bytes: A scalar representing the number of bytes to skip at the
// beginning of a file.
//	record_bytes: A scalar representing the number of bytes in each record.
//	footer_bytes: A scalar representing the number of bytes to skip at the end
// of a file.
//	buffer_size: A scalar representing the number of bytes to buffer. Must be > 0.
func FixedLengthRecordDataset(scope *Scope, filenames tf.Output, header_bytes tf.Output, record_bytes tf.Output, footer_bytes tf.Output, buffer_size tf.Output, optional ...FixedLengthRecordDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FixedLengthRecordDataset",
		Input: []tf.Input{
			filenames, header_bytes, record_bytes, footer_bytes, buffer_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TextLineDatasetAttr is an optional argument to TextLineDataset.
type TextLineDatasetAttr func(optionalAttr)

// TextLineDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func TextLineDatasetMetadata(value string) TextLineDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that emits the lines of one or more text files.
//
// Arguments:
//	filenames: A scalar or a vector containing the name(s) of the file(s) to be
// read.
//	compression_type: A scalar containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
//	buffer_size: A scalar containing the number of bytes to buffer.
func TextLineDataset(scope *Scope, filenames tf.Output, compression_type tf.Output, buffer_size tf.Output, optional ...TextLineDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TextLineDataset",
		Input: []tf.Input{
			filenames, compression_type, buffer_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for an iterator resource.
//
// Arguments:
//	multi_device_iterator: A handle to the multi device iterator to delete.
//	iterators: A list of iterator handles (unused). This is added so that automatic control dependencies get added during function tracing that ensure this op runs after all the dependent iterators are deleted.
//	deleter: A variant deleter.
//
// Returns the created operation.
func DeleteMultiDeviceIterator(scope *Scope, multi_device_iterator tf.Output, iterators []tf.Output, deleter tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteMultiDeviceIterator",
		Input: []tf.Input{
			multi_device_iterator, tf.OutputList(iterators), deleter,
		},
	}
	return scope.AddOperation(opspec)
}

// RangeDatasetAttr is an optional argument to RangeDataset.
type RangeDatasetAttr func(optionalAttr)

// RangeDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func RangeDatasetMetadata(value string) RangeDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset with a range of values. Corresponds to python's xrange.
//
// Arguments:
//	start: corresponds to start in python's xrange().
//	stop: corresponds to stop in python's xrange().
//	step: corresponds to step in python's xrange().
//
//
func RangeDataset(scope *Scope, start tf.Output, stop tf.Output, step tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...RangeDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RangeDataset",
		Input: []tf.Input{
			start, stop, step,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PaddedBatchDatasetAttr is an optional argument to PaddedBatchDataset.
type PaddedBatchDatasetAttr func(optionalAttr)

// PaddedBatchDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func PaddedBatchDatasetMetadata(value string) PaddedBatchDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that batches and pads `batch_size` elements from the input.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//	padded_shapes: A list of int64 tensors representing the desired padded shapes
// of the corresponding output components. These shapes may be partially
// specified, using `-1` to indicate that a particular dimension should be
// padded to the maximum size of all batch elements.
//	padding_values: A list of scalars containing the padding value to use for
// each of the outputs.
//
func PaddedBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, padded_shapes []tf.Output, padding_values []tf.Output, output_shapes []tf.Shape, optional ...PaddedBatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PaddedBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, tf.OutputList(padded_shapes), tf.OutputList(padding_values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchDatasetV2Attr is an optional argument to BatchDatasetV2.
type BatchDatasetV2Attr func(optionalAttr)

// BatchDatasetV2ParallelCopy sets the optional parallel_copy attribute to value.
// If not specified, defaults to false
func BatchDatasetV2ParallelCopy(value bool) BatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["parallel_copy"] = value
	}
}

// BatchDatasetV2Metadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func BatchDatasetV2Metadata(value string) BatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that batches `batch_size` elements from `input_dataset`.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a batch.
//	drop_remainder: A scalar representing whether the last batch should be dropped in case its size
// is smaller than desired.
//
//
func BatchDatasetV2(scope *Scope, input_dataset tf.Output, batch_size tf.Output, drop_remainder tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...BatchDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchDatasetV2",
		Input: []tf.Input{
			input_dataset, batch_size, drop_remainder,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShuffleDatasetAttr is an optional argument to ShuffleDataset.
type ShuffleDatasetAttr func(optionalAttr)

// ShuffleDatasetReshuffleEachIteration sets the optional reshuffle_each_iteration attribute to value.
//
// value: If true, each iterator over this dataset will be given
// a different pseudorandomly generated seed, based on a sequence seeded by the
// `seed` and `seed2` inputs. If false, each iterator will be given the same
// seed, and repeated iteration over this dataset will yield the exact same
// sequence of results.
// If not specified, defaults to true
func ShuffleDatasetReshuffleEachIteration(value bool) ShuffleDatasetAttr {
	return func(m optionalAttr) {
		m["reshuffle_each_iteration"] = value
	}
}

// ShuffleDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func ShuffleDatasetMetadata(value string) ShuffleDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that shuffles elements from `input_dataset` pseudorandomly.
//
// Arguments:
//
//	buffer_size: The number of output elements to buffer in an iterator over
// this dataset. Compare with the `min_after_dequeue` attr when creating a
// `RandomShuffleQueue`.
//	seed: A scalar seed for the random number generator. If either `seed` or
// `seed2` is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//
//
func ShuffleDataset(scope *Scope, input_dataset tf.Output, buffer_size tf.Output, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ShuffleDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShuffleDataset",
		Input: []tf.Input{
			input_dataset, buffer_size, seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset containing elements of first component of `input_dataset` having true in the last component.
func FilterByLastComponentDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "FilterByLastComponentDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Make a static dimension into a xla bounded dynamic dimension.
//
//         The current static dimension size will become the bound and the second
//         operand becomes the dynamic size of the dimension.
func XlaSetDynamicDimensionSize(scope *Scope, input tf.Output, dim_index tf.Output, size tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "XlaSetDynamicDimensionSize",
		Input: []tf.Input{
			input, dim_index, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PrefetchDatasetAttr is an optional argument to PrefetchDataset.
type PrefetchDatasetAttr func(optionalAttr)

// PrefetchDatasetSlackPeriod sets the optional slack_period attribute to value.
// If not specified, defaults to 0
func PrefetchDatasetSlackPeriod(value int64) PrefetchDatasetAttr {
	return func(m optionalAttr) {
		m["slack_period"] = value
	}
}

// PrefetchDatasetLegacyAutotune sets the optional legacy_autotune attribute to value.
// If not specified, defaults to true
func PrefetchDatasetLegacyAutotune(value bool) PrefetchDatasetAttr {
	return func(m optionalAttr) {
		m["legacy_autotune"] = value
	}
}

// PrefetchDatasetBufferSizeMin sets the optional buffer_size_min attribute to value.
// If not specified, defaults to 0
func PrefetchDatasetBufferSizeMin(value int64) PrefetchDatasetAttr {
	return func(m optionalAttr) {
		m["buffer_size_min"] = value
	}
}

// PrefetchDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func PrefetchDatasetMetadata(value string) PrefetchDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that asynchronously prefetches elements from `input_dataset`.
//
// Arguments:
//
//	buffer_size: The maximum number of elements to buffer in an iterator over
// this dataset.
//
//
func PrefetchDataset(scope *Scope, input_dataset tf.Output, buffer_size tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...PrefetchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PrefetchDataset",
		Input: []tf.Input{
			input_dataset, buffer_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Forwards the input to the output.
//
// This operator represents the loop termination condition used by the
// "pivot" switches of a loop.
//
// Arguments:
//	input: A boolean scalar, representing the branch predicate of the Switch op.
//
// Returns The same tensor as `input`.
func LoopCond(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LoopCond",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SkipDatasetAttr is an optional argument to SkipDataset.
type SkipDatasetAttr func(optionalAttr)

// SkipDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func SkipDatasetMetadata(value string) SkipDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that skips `count` elements from the `input_dataset`.
//
// Arguments:
//
//	count: A scalar representing the number of elements from the `input_dataset`
// that should be skipped.  If count is -1, skips everything.
//
//
func SkipDataset(scope *Scope, input_dataset tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...SkipDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SkipDataset",
		Input: []tf.Input{
			input_dataset, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RepeatDatasetAttr is an optional argument to RepeatDataset.
type RepeatDatasetAttr func(optionalAttr)

// RepeatDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func RepeatDatasetMetadata(value string) RepeatDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that emits the outputs of `input_dataset` `count` times.
//
// Arguments:
//
//	count: A scalar representing the number of times that `input_dataset` should
// be repeated. A value of `-1` indicates that it should be repeated infinitely.
//
//
func RepeatDataset(scope *Scope, input_dataset tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...RepeatDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RepeatDataset",
		Input: []tf.Input{
			input_dataset, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UnpackAttr is an optional argument to Unpack.
type UnpackAttr func(optionalAttr)

// UnpackAxis sets the optional axis attribute to value.
//
// value: Dimension along which to unpack.  Negative values wrap around, so the
// valid range is `[-R, R)`.
// If not specified, defaults to 0
func UnpackAxis(value int64) UnpackAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Unpacks a given dimension of a rank-`R` tensor into `num` rank-`(R-1)` tensors.
//
// Unpacks `num` tensors from `value` by chipping it along the `axis` dimension.
// For example, given a tensor of shape `(A, B, C, D)`;
//
// If `axis == 0` then the i'th tensor in `output` is the slice `value[i, :, :, :]`
//   and each tensor in `output` will have shape `(B, C, D)`. (Note that the
//   dimension unpacked along is gone, unlike `split`).
//
// If `axis == 1` then the i'th tensor in `output` is the slice `value[:, i, :, :]`
//   and each tensor in `output` will have shape `(A, C, D)`.
// Etc.
//
// This is the opposite of `pack`.
//
// Arguments:
//	value: 1-D or higher, with `axis` dimension size equal to `num`.
//
//
// Returns The list of tensors unpacked from `value`.
func Unpack(scope *Scope, value tf.Output, num int64, optional ...UnpackAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num": num}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unpack",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("Unpack", err)
		return
	}
	return output
}

// ConcatenateDatasetAttr is an optional argument to ConcatenateDataset.
type ConcatenateDatasetAttr func(optionalAttr)

// ConcatenateDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func ConcatenateDatasetMetadata(value string) ConcatenateDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that concatenates `input_dataset` with `another_dataset`.
func ConcatenateDataset(scope *Scope, input_dataset tf.Output, another_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ConcatenateDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ConcatenateDataset",
		Input: []tf.Input{
			input_dataset, another_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A placeholder op for a value that will be fed into the computation.
//
// DEPRECATED at GraphDef version 23: Placeholder now behaves the same as PlaceholderV2.
//
// N.B. This operation will fail with an error if it is executed. It is
// intended as a way to represent a value that will always be fed, and to
// provide attrs that enable the fed value to be checked at runtime.
//
// Arguments:
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor. The shape can be any partially-specified
// shape.  To be unconstrained, pass in a shape with unknown rank.
//
// Returns A placeholder tensor that must be replaced using the feed mechanism.
func PlaceholderV2(scope *Scope, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "PlaceholderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomShuffleQueueV2Attr is an optional argument to RandomShuffleQueueV2.
type RandomShuffleQueueV2Attr func(optionalAttr)

// RandomShuffleQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types. If the length of
// this attr is 0, the shapes of queue elements are not constrained, and
// only one element may be dequeued at a time.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func RandomShuffleQueueV2Shapes(value []tf.Shape) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// RandomShuffleQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func RandomShuffleQueueV2Capacity(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// RandomShuffleQueueV2MinAfterDequeue sets the optional min_after_dequeue attribute to value.
//
// value: Dequeue will block unless there would be this
// many elements after the dequeue or the queue is closed. This
// ensures a minimum level of mixing of elements.
// If not specified, defaults to 0
func RandomShuffleQueueV2MinAfterDequeue(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["min_after_dequeue"] = value
	}
}

// RandomShuffleQueueV2Seed sets the optional seed attribute to value.
//
// value: If either seed or seed2 is set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, a random seed is used.
// If not specified, defaults to 0
func RandomShuffleQueueV2Seed(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomShuffleQueueV2Seed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomShuffleQueueV2Seed2(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// RandomShuffleQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func RandomShuffleQueueV2Container(value string) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// RandomShuffleQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func RandomShuffleQueueV2SharedName(value string) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that randomizes the order of elements.
//
// Arguments:
//	component_types: The type of each component in a value.
//
// Returns The handle to the queue.
func RandomShuffleQueueV2(scope *Scope, component_types []tf.DataType, optional ...RandomShuffleQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomShuffleQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that splits a SparseTensor into elements row-wise.
func SparseTensorSliceDataset(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseTensorSliceDataset",
		Input: []tf.Input{
			indices, values, dense_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorDatasetAttr is an optional argument to TensorDataset.
type TensorDatasetAttr func(optionalAttr)

// TensorDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func TensorDatasetMetadata(value string) TensorDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that emits `components` as a tuple of tensors once.
func TensorDataset(scope *Scope, components []tf.Output, output_shapes []tf.Shape, optional ...TensorDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorDataset",
		Input: []tf.Input{
			tf.OutputList(components),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QueueCloseV2Attr is an optional argument to QueueCloseV2.
type QueueCloseV2Attr func(optionalAttr)

// QueueCloseV2CancelPendingEnqueues sets the optional cancel_pending_enqueues attribute to value.
//
// value: If true, all pending enqueue requests that are
// blocked on the given queue will be canceled.
// If not specified, defaults to false
func QueueCloseV2CancelPendingEnqueues(value bool) QueueCloseV2Attr {
	return func(m optionalAttr) {
		m["cancel_pending_enqueues"] = value
	}
}

// Closes the given queue.
//
// This operation signals that no more elements will be enqueued in the
// given queue. Subsequent Enqueue(Many) operations will fail.
// Subsequent Dequeue(Many) operations will continue to succeed if
// sufficient elements remain in the queue. Subsequent Dequeue(Many)
// operations that would block will fail immediately.
//
// Arguments:
//	handle: The handle to a queue.
//
// Returns the created operation.
func QueueCloseV2(scope *Scope, handle tf.Output, optional ...QueueCloseV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueCloseV2",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// DebugIdentityV2Attr is an optional argument to DebugIdentityV2.
type DebugIdentityV2Attr func(optionalAttr)

// DebugIdentityV2TfdbgContextId sets the optional tfdbg_context_id attribute to value.
//
// value: A tfdbg-generated ID for the context that the op belongs to,
//   e.g., a concrete compiled tf.function.
// If not specified, defaults to ""
func DebugIdentityV2TfdbgContextId(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tfdbg_context_id"] = value
	}
}

// DebugIdentityV2OpName sets the optional op_name attribute to value.
//
// value: Optional. Name of the op that the debug op is concerned with.
//   Used only for single-tensor trace.
// If not specified, defaults to ""
func DebugIdentityV2OpName(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["op_name"] = value
	}
}

// DebugIdentityV2OutputSlot sets the optional output_slot attribute to value.
//
// value: Optional. Output slot index of the tensor that the debug op
//   is concerned with. Used only for single-tensor trace.
// If not specified, defaults to -1
func DebugIdentityV2OutputSlot(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["output_slot"] = value
	}
}

// DebugIdentityV2TensorDebugMode sets the optional tensor_debug_mode attribute to value.
//
// value: TensorDebugMode enum value. See debug_event.proto for details.
// If not specified, defaults to -1
func DebugIdentityV2TensorDebugMode(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tensor_debug_mode"] = value
	}
}

// DebugIdentityV2DebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g., file:///foo/tfdbg_dump.
// If not specified, defaults to {}
func DebugIdentityV2DebugUrls(value []string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugIdentityV2CircularBufferSize sets the optional circular_buffer_size attribute to value.
// If not specified, defaults to 1000
func DebugIdentityV2CircularBufferSize(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["circular_buffer_size"] = value
	}
}

// DebugIdentityV2TfdbgRunId sets the optional tfdbg_run_id attribute to value.
// If not specified, defaults to ""
func DebugIdentityV2TfdbgRunId(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tfdbg_run_id"] = value
	}
}

// Debug Identity V2 Op.
//
// Provides an identity mapping from input to output, while writing the content of
// the input tensor by calling DebugEventsWriter.
//
// The semantics of the input tensor depends on tensor_debug_mode. In typical
// usage, the input tensor comes directly from the user computation only when
// graph_debug_mode is FULL_TENSOR (see protobuf/debug_event.proto for a
// list of all the possible values of graph_debug_mode). For the other debug modes,
// the input tensor should be produced by an additional op or subgraph that
// computes summary information about one or more tensors.
//
// Arguments:
//	input: Input tensor, non-Reference type
func DebugIdentityV2(scope *Scope, input tf.Output, optional ...DebugIdentityV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugIdentityV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugNanCountAttr is an optional argument to DebugNanCount.
type DebugNanCountAttr func(optionalAttr)

// DebugNanCountDeviceName sets the optional device_name attribute to value.
// If not specified, defaults to ""
func DebugNanCountDeviceName(value string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugNanCountTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugNanCountTensorName(value string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugNanCountDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//   file:///foo/tfdbg_dump, grpc:://localhost:11011.
// If not specified, defaults to {}
func DebugNanCountDebugUrls(value []string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugNanCountGatedGrpc sets the optional gated_grpc attribute to value.
//
// value:  Whether this op will be gated. If any of the debug_urls of this
//   debug node is of the grpc:// scheme, when the value of this attribute is set
//   to True, the data will not actually be sent via the grpc stream unless this
//   debug op has been enabled at the debug_url. If all of the debug_urls of this
//   debug node are of the grpc:// scheme and the debug op is enabled at none of
//   them, the output will be an empty Tensor.
// If not specified, defaults to false
func DebugNanCountGatedGrpc(value bool) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Debug NaN Value Counter Op.
//
// Counts number of NaNs in the input tensor, for debugging.
//
// Arguments:
//	input: Input tensor, non-Reference type.
func DebugNanCount(scope *Scope, input tf.Output, optional ...DebugNanCountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNanCount",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugIdentityAttr is an optional argument to DebugIdentity.
type DebugIdentityAttr func(optionalAttr)

// DebugIdentityDeviceName sets the optional device_name attribute to value.
//
// value: Name of the device on which the tensor resides.
// If not specified, defaults to ""
func DebugIdentityDeviceName(value string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugIdentityTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugIdentityTensorName(value string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugIdentityDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//   file:///foo/tfdbg_dump, grpc:://localhost:11011
// If not specified, defaults to {}
func DebugIdentityDebugUrls(value []string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugIdentityGatedGrpc sets the optional gated_grpc attribute to value.
//
// value: Whether this op will be gated. If any of the debug_urls of this
//   debug node is of the grpc:// scheme, when the value of this attribute is set
//   to True, the data will not actually be sent via the grpc stream unless this
//   debug op has been enabled at the debug_url. If all of the debug_urls of this
//   debug node are of the grpc:// scheme and the debug op is enabled at none of
//   them, the output will be an empty Tensor.
// If not specified, defaults to false
func DebugIdentityGatedGrpc(value bool) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Arguments:
//	input: Input tensor, non-Reference type
func DebugIdentity(scope *Scope, input tf.Output, optional ...DebugIdentityAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugIdentity",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Aggregates the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated for each node, bucket and dimension id.
//
// Arguments:
//	node_ids: int32; Rank 1 Tensor containing node ids for each example, shape [batch_size].
//	gradients: float32; Rank 2 Tensor (shape=[batch_size, logits_dimension]) with gradients for each example.
//	hessians: float32; Rank 2 Tensor (shape=[batch_size, hessian_dimension]) with hessians for each example.
//	feature_indices: int32; Rank 2 indices of feature sparse Tensors (shape=[number of sparse entries, 2]).
// Number of sparse entries across all instances from the batch. The first value is
// the index of the instance, the second is dimension of the feature. The second axis
// can only have 2 values, i.e., the input dense version of Tensor can only be matrix.
//	feature_values: int32; Rank 1 values of feature sparse Tensors (shape=[number of sparse entries]).
// Number of sparse entries across all instances from the batch. The first value is
// the index of the instance, the second is dimension of the feature.
//	feature_shape: int32; Rank 1 dense shape of feature sparse Tensors (shape=[2]).
// The first axis can only have 2 values, [batch_size, feature_dimension].
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature + 1.
//
// Returns:
//	stats_summary_indices: int32; Rank 2 indices of summary sparse Tensors (shape=[number of non zero statistics, 4])
// The second axis can only be 4 including node id, feature dimension, bucket id, and statistics_dimension.
// statistics_dimension = logits_dimension + hessian_dimension.
//	stats_summary_values: output Rank 1 Tensor (shape=[number of non zero statistics])
//	stats_summary_shape: output Rank 1 Tensor (shape=[4])
// The tensor has following 4 values: [max_splits, feature_dimension, num_buckets, statistics_dimension],
// where statistics_dimension = gradient_dimension + hessian_dimension. gradient_dimension
// is the same as label_dimension, i.e., the output space. hessian_dimension can be the same
// as logits dimension when diagonal hessian is used, or label_dimension^2 when full
// hessian is used.
func BoostedTreesSparseAggregateStats(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, feature_indices tf.Output, feature_values tf.Output, feature_shape tf.Output, max_splits int64, num_buckets int64) (stats_summary_indices tf.Output, stats_summary_values tf.Output, stats_summary_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSparseAggregateStats",
		Input: []tf.Input{
			node_ids, gradients, hessians, feature_indices, feature_values, feature_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DecodeProtoV2Attr is an optional argument to DecodeProtoV2.
type DecodeProtoV2Attr func(optionalAttr)

// DecodeProtoV2DescriptorSource sets the optional descriptor_source attribute to value.
//
// value: Either the special value `local://` or a path to a file containing
// a serialized `FileDescriptorSet`.
// If not specified, defaults to "local://"
func DecodeProtoV2DescriptorSource(value string) DecodeProtoV2Attr {
	return func(m optionalAttr) {
		m["descriptor_source"] = value
	}
}

// DecodeProtoV2MessageFormat sets the optional message_format attribute to value.
//
// value: Either `binary` or `text`.
// If not specified, defaults to "binary"
func DecodeProtoV2MessageFormat(value string) DecodeProtoV2Attr {
	return func(m optionalAttr) {
		m["message_format"] = value
	}
}

// DecodeProtoV2Sanitize sets the optional sanitize attribute to value.
//
// value: Whether to sanitize the result or not.
// If not specified, defaults to false
func DecodeProtoV2Sanitize(value bool) DecodeProtoV2Attr {
	return func(m optionalAttr) {
		m["sanitize"] = value
	}
}

// The op extracts fields from a serialized protocol buffers message into tensors.
//
// The `decode_proto` op extracts fields from a serialized protocol buffers
// message into tensors.  The fields in `field_names` are decoded and converted
// to the corresponding `output_types` if possible.
//
// A `message_type` name must be provided to give context for the field names.
// The actual message descriptor can be looked up either in the linked-in
// descriptor pool or a filename provided by the caller using the
// `descriptor_source` attribute.
//
// Each output tensor is a dense tensor. This means that it is padded to hold
// the largest number of repeated elements seen in the input minibatch. (The
// shape is also padded by one to prevent zero-sized dimensions). The actual
// repeat counts for each example in the minibatch can be found in the `sizes`
// output. In many cases the output of `decode_proto` is fed immediately into
// tf.squeeze if missing values are not a concern. When using tf.squeeze, always
// pass the squeeze dimension explicitly to avoid surprises.
//
// For the most part, the mapping between Proto field types and TensorFlow dtypes
// is straightforward. However, there are a few special cases:
//
// - A proto field that contains a submessage or group can only be converted
// to `DT_STRING` (the serialized submessage). This is to reduce the complexity
// of the API. The resulting string can be used as input to another instance of
// the decode_proto op.
//
// - TensorFlow lacks support for unsigned integers. The ops represent uint64
// types as a `DT_INT64` with the same twos-complement bit pattern (the obvious
// way). Unsigned int32 values can be represented exactly by specifying type
// `DT_INT64`, or using twos-complement if the caller specifies `DT_INT32` in
// the `output_types` attribute.
//
// Both binary and text proto serializations are supported, and can be
// chosen using the `format` attribute.
//
// The `descriptor_source` attribute selects the source of protocol
// descriptors to consult when looking up `message_type`. This may be:
//
// - An empty string  or "local://", in which case protocol descriptors are
// created for C++ (not Python) proto definitions linked to the binary.
//
// - A file, in which case protocol descriptors are created from the file,
// which is expected to contain a `FileDescriptorSet` serialized as a string.
// NOTE: You can build a `descriptor_source` file using the `--descriptor_set_out`
// and `--include_imports` options to the protocol compiler `protoc`.
//
// - A "bytes://<bytes>", in which protocol descriptors are created from `<bytes>`,
// which is expected to be a `FileDescriptorSet` serialized as a string.
//
// Arguments:
//	bytes: Tensor of serialized protos with shape `batch_shape`.
//	message_type: Name of the proto message type to decode.
//	field_names: List of strings containing proto field names. An extension field can be decoded
// by using its full name, e.g. EXT_PACKAGE.EXT_FIELD_NAME.
//	output_types: List of TF types to use for the respective field in field_names.
//
// Returns:
//	sizes: Tensor of int32 with shape `[batch_shape, len(field_names)]`.
// Each entry is the number of values found for the corresponding field.
// Optional fields may have 0 or 1 values.
//	values: List of tensors containing values for the corresponding field.
// `values[i]` has datatype `output_types[i]`
// and shape `[batch_shape, max(sizes[...,i])]`.
func DecodeProtoV2(scope *Scope, bytes tf.Output, message_type string, field_names []string, output_types []tf.DataType, optional ...DecodeProtoV2Attr) (sizes tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"message_type": message_type, "field_names": field_names, "output_types": output_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeProtoV2",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	sizes = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("DecodeProtoV2", err)
		return
	}
	return sizes, values
}

// EncodeProtoAttr is an optional argument to EncodeProto.
type EncodeProtoAttr func(optionalAttr)

// EncodeProtoDescriptorSource sets the optional descriptor_source attribute to value.
// If not specified, defaults to "local://"
func EncodeProtoDescriptorSource(value string) EncodeProtoAttr {
	return func(m optionalAttr) {
		m["descriptor_source"] = value
	}
}

// The op serializes protobuf messages provided in the input tensors.
//
// The types of the tensors in `values` must match the schema for the fields
// specified in `field_names`. All the tensors in `values` must have a common
// shape prefix, *batch_shape*.
//
// The `sizes` tensor specifies repeat counts for each field.  The repeat count
// (last dimension) of a each tensor in `values` must be greater than or equal
// to corresponding repeat count in `sizes`.
//
// A `message_type` name must be provided to give context for the field names.
// The actual message descriptor can be looked up either in the linked-in
// descriptor pool or a filename provided by the caller using the
// `descriptor_source` attribute.
//
// For the most part, the mapping between Proto field types and TensorFlow dtypes
// is straightforward. However, there are a few special cases:
//
// - A proto field that contains a submessage or group can only be converted
// to `DT_STRING` (the serialized submessage). This is to reduce the complexity
// of the API. The resulting string can be used as input to another instance of
// the decode_proto op.
//
// - TensorFlow lacks support for unsigned integers. The ops represent uint64
// types as a `DT_INT64` with the same twos-complement bit pattern (the obvious
// way). Unsigned int32 values can be represented exactly by specifying type
// `DT_INT64`, or using twos-complement if the caller specifies `DT_INT32` in
// the `output_types` attribute.
//
// The `descriptor_source` attribute selects the source of protocol
// descriptors to consult when looking up `message_type`. This may be:
//
// - An empty string  or "local://", in which case protocol descriptors are
// created for C++ (not Python) proto definitions linked to the binary.
//
// - A file, in which case protocol descriptors are created from the file,
// which is expected to contain a `FileDescriptorSet` serialized as a string.
// NOTE: You can build a `descriptor_source` file using the `--descriptor_set_out`
// and `--include_imports` options to the protocol compiler `protoc`.
//
// - A "bytes://<bytes>", in which protocol descriptors are created from `<bytes>`,
// which is expected to be a `FileDescriptorSet` serialized as a string.
//
// Arguments:
//	sizes: Tensor of int32 with shape `[batch_shape, len(field_names)]`.
//	values: List of tensors containing values for the corresponding field.
//	field_names: List of strings containing proto field names.
//	message_type: Name of the proto message type to decode.
//
// Returns Tensor of serialized protos with shape `batch_shape`.
func EncodeProto(scope *Scope, sizes tf.Output, values []tf.Output, field_names []string, message_type string, optional ...EncodeProtoAttr) (bytes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"field_names": field_names, "message_type": message_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeProto",
		Input: []tf.Input{
			sizes, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RegisterDatasetAttr is an optional argument to RegisterDataset.
type RegisterDatasetAttr func(optionalAttr)

// RegisterDatasetElementSpec sets the optional element_spec attribute to value.
// If not specified, defaults to ""
func RegisterDatasetElementSpec(value string) RegisterDatasetAttr {
	return func(m optionalAttr) {
		m["element_spec"] = value
	}
}

// Registers a dataset with the tf.data service.
func RegisterDataset(scope *Scope, dataset tf.Output, address tf.Output, protocol tf.Output, external_state_policy int64, optional ...RegisterDatasetAttr) (dataset_id tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"external_state_policy": external_state_policy}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RegisterDataset",
		Input: []tf.Input{
			dataset, address, protocol,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DataServiceDatasetAttr is an optional argument to DataServiceDataset.
type DataServiceDatasetAttr func(optionalAttr)

// DataServiceDatasetTaskRefreshIntervalHintMs sets the optional task_refresh_interval_hint_ms attribute to value.
// If not specified, defaults to -1
func DataServiceDatasetTaskRefreshIntervalHintMs(value int64) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["task_refresh_interval_hint_ms"] = value
	}
}

// DataServiceDatasetDataTransferProtocol sets the optional data_transfer_protocol attribute to value.
// If not specified, defaults to ""
func DataServiceDatasetDataTransferProtocol(value string) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["data_transfer_protocol"] = value
	}
}

// DataServiceDatasetTargetWorkers sets the optional target_workers attribute to value.
// If not specified, defaults to "AUTO"
func DataServiceDatasetTargetWorkers(value string) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["target_workers"] = value
	}
}

// Creates a dataset that reads data from the tf.data service.
func DataServiceDataset(scope *Scope, dataset_id tf.Output, processing_mode tf.Output, address tf.Output, protocol tf.Output, job_name tf.Output, max_outstanding_requests tf.Output, iteration_counter tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DataServiceDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataServiceDataset",
		Input: []tf.Input{
			dataset_id, processing_mode, address, protocol, job_name, max_outstanding_requests, iteration_counter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UniqueDatasetAttr is an optional argument to UniqueDataset.
type UniqueDatasetAttr func(optionalAttr)

// UniqueDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func UniqueDatasetMetadata(value string) UniqueDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that contains the unique elements of `input_dataset`.
func UniqueDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...UniqueDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniqueDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A dataset that splits the elements of its input into multiple elements.
func ExperimentalUnbatchDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalUnbatchDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UnbatchDatasetAttr is an optional argument to UnbatchDataset.
type UnbatchDatasetAttr func(optionalAttr)

// UnbatchDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func UnbatchDatasetMetadata(value string) UnbatchDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// A dataset that splits the elements of its input into multiple elements.
func UnbatchDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...UnbatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnbatchDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	thread_pool: A resource produced by the ThreadPoolHandle op.
//
//
func ExperimentalThreadPoolDataset(scope *Scope, input_dataset tf.Output, thread_pool tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, thread_pool,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator as an Optional variant.
func IteratorGetNextAsOptional(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextAsOptional",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Produces a summary of any statistics recorded by the given statistics manager.
func StatsAggregatorSummary(scope *Scope, iterator tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatsAggregatorSummary",
		Input: []tf.Input{
			iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalStatsAggregatorHandleAttr is an optional argument to ExperimentalStatsAggregatorHandle.
type ExperimentalStatsAggregatorHandleAttr func(optionalAttr)

// ExperimentalStatsAggregatorHandleContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func ExperimentalStatsAggregatorHandleContainer(value string) ExperimentalStatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ExperimentalStatsAggregatorHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func ExperimentalStatsAggregatorHandleSharedName(value string) ExperimentalStatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a statistics manager resource.
func ExperimentalStatsAggregatorHandle(scope *Scope, optional ...ExperimentalStatsAggregatorHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalStatsAggregatorHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatsAggregatorHandleAttr is an optional argument to StatsAggregatorHandle.
type StatsAggregatorHandleAttr func(optionalAttr)

// StatsAggregatorHandleContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func StatsAggregatorHandleContainer(value string) StatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StatsAggregatorHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func StatsAggregatorHandleSharedName(value string) StatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a statistics manager resource.
func StatsAggregatorHandle(scope *Scope, optional ...StatsAggregatorHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatsAggregatorHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that executes a SQL query and emits rows of the result set.
//
// Arguments:
//	driver_name: The database type. Currently, the only supported type is 'sqlite'.
//	data_source_name: A connection string to connect to the database.
//	query: A SQL query to execute.
//
//
func ExperimentalSqlDataset(scope *Scope, driver_name tf.Output, data_source_name tf.Output, query tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalSqlDataset",
		Input: []tf.Input{
			driver_name, data_source_name, query,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generate the bucket boundaries for each feature based on accumulated summaries.
//
// An op that returns a list of float tensors for a quantile stream resource. Each
// tensor is Rank 1 containing bucket boundaries for a single feature.
//
// Arguments:
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	num_features: inferred int; number of features to get bucket boundaries for.
//
// Returns float; List of Rank 1 Tensors each containing the bucket boundaries for a feature.
func BoostedTreesQuantileStreamResourceGetBucketBoundaries(scope *Scope, quantile_stream_resource_handle tf.Output, num_features int64) (bucket_boundaries []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_features": num_features}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceGetBucketBoundaries",
		Input: []tf.Input{
			quantile_stream_resource_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if bucket_boundaries, idx, err = makeOutputList(op, idx, "bucket_boundaries"); err != nil {
		scope.UpdateErr("BoostedTreesQuantileStreamResourceGetBucketBoundaries", err)
		return
	}
	return bucket_boundaries
}

// Creates a dataset that passes a sliding window over `input_dataset`.
//
// Arguments:
//
//	window_size: A scalar representing the number of elements in the
// sliding window.
//	window_shift: A scalar representing the steps moving the sliding window
// forward in one iteration. It must be positive.
//	window_stride: A scalar representing the stride of the input elements of the sliding window.
// It must be positive.
//
//
func ExperimentalSlidingWindowDataset(scope *Scope, input_dataset tf.Output, window_size tf.Output, window_shift tf.Output, window_stride tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalSlidingWindowDataset",
		Input: []tf.Input{
			input_dataset, window_size, window_shift, window_stride,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArraySizeV3
//
// DEPRECATED at GraphDef version 26: Use TensorArraySizeV3
func TensorArraySizeV2(scope *Scope, handle tf.Output, flow_in tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySizeV2",
		Input: []tf.Input{
			handle, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that changes the batch size.
//
// Creates a dataset that rebatches elements from `input_dataset` into new batch
// sizes.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	batch_sizes: A vector of integers representing the size of batches to produce. These values
// are cycled through in order.
//
//
//
func RebatchDatasetV2(scope *Scope, input_dataset tf.Output, batch_sizes tf.Output, drop_remainder tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "RebatchDatasetV2",
		Input: []tf.Input{
			input_dataset, batch_sizes, drop_remainder,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RebatchDatasetAttr is an optional argument to RebatchDataset.
type RebatchDatasetAttr func(optionalAttr)

// RebatchDatasetUseFallback sets the optional use_fallback attribute to value.
// If not specified, defaults to true
func RebatchDatasetUseFallback(value bool) RebatchDatasetAttr {
	return func(m optionalAttr) {
		m["use_fallback"] = value
	}
}

// Creates a dataset that changes the batch size.
//
// Creates a dataset that changes the batch size of the dataset to current batch
// size // num_workers.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	num_replicas: A scalar representing the number of replicas to distribute this batch across. As
// a result of this transformation the current batch size would end up being
// divided  by this parameter.
//
//
func RebatchDataset(scope *Scope, input_dataset tf.Output, num_replicas tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...RebatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RebatchDataset",
		Input: []tf.Input{
			input_dataset, num_replicas,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	num_threads: Identifies the number of threads to use for the private threadpool.
//
//
func ExperimentalPrivateThreadPoolDataset(scope *Scope, input_dataset tf.Output, num_threads tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalPrivateThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, num_threads,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	num_threads: Identifies the number of threads to use for the private threadpool.
//
//
func PrivateThreadPoolDataset(scope *Scope, input_dataset tf.Output, num_threads tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "PrivateThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, num_threads,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalParseExampleDatasetAttr is an optional argument to ExperimentalParseExampleDataset.
type ExperimentalParseExampleDatasetAttr func(optionalAttr)

// ExperimentalParseExampleDatasetSloppy sets the optional sloppy attribute to value.
// If not specified, defaults to false
func ExperimentalParseExampleDatasetSloppy(value bool) ExperimentalParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["sloppy"] = value
	}
}

// Transforms `input_dataset` containing `Example` protos as vectors of DT_STRING into a dataset of `Tensor` or `SparseTensor` objects representing the parsed features.
//
// Arguments:
//
//
//	dense_defaults: A dict mapping string keys to `Tensor`s.
// The keys of the dict must match the dense_keys of the feature.
//	sparse_keys: A list of string keys in the examples features.
// The results for these keys will be returned as `SparseTensor` objects.
//	dense_keys: A list of Ndense string Tensors (scalars).
// The keys expected in the Examples features associated with dense values.
//	sparse_types: A list of `DTypes` of the same length as `sparse_keys`.
// Only `tf.float32` (`FloatList`), `tf.int64` (`Int64List`),
// and `tf.string` (`BytesList`) are supported.
//	dense_shapes: List of tuples with the same length as `dense_keys`.
// The shape of the data for each dense feature referenced by `dense_keys`.
// Required for any input tensors identified by `dense_keys`.  Must be
// either fully defined, or may contain an unknown first dimension.
// An unknown first dimension means the feature is treated as having
// a variable number of blocks, and the output shape along this dimension
// is considered unknown at graph build time.  Padding is applied for
// minibatch elements smaller than the maximum number of blocks for the
// given feature along this dimension.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
func ExperimentalParseExampleDataset(scope *Scope, input_dataset tf.Output, num_parallel_calls tf.Output, dense_defaults []tf.Output, sparse_keys []string, dense_keys []string, sparse_types []tf.DataType, dense_shapes []tf.Shape, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalParseExampleDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_keys": sparse_keys, "dense_keys": dense_keys, "sparse_types": sparse_types, "dense_shapes": dense_shapes, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalParseExampleDataset",
		Input: []tf.Input{
			input_dataset, num_parallel_calls, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the main diagonal of the
// innermost matrices.  These will be overwritten by the values in `diagonal`.
//
// The output is computed as follows:
//
// Assume `input` has `k+1` dimensions `[I, J, K, ..., M, N]` and `diagonal` has
// `k` dimensions `[I, J, K, ..., min(M, N)]`.  Then the output is a
// tensor of rank `k+1` with dimensions `[I, J, K, ..., M, N]` where:
//
//   * `output[i, j, k, ..., m, n] = diagonal[i, j, k, ..., n]` for `m == n`.
//   * `output[i, j, k, ..., m, n] = input[i, j, k, ..., m, n]` for `m != n`.
//
// Arguments:
//	input: Rank `k+1`, where `k >= 1`.
//	diagonal: Rank `k`, where `k >= 1`.
//
// Returns Rank `k+1`, with `output.shape = input.shape`.
func MatrixSetDiag(scope *Scope, input tf.Output, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiag",
		Input: []tf.Input{
			input, diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseExampleDatasetV2Attr is an optional argument to ParseExampleDatasetV2.
type ParseExampleDatasetV2Attr func(optionalAttr)

// ParseExampleDatasetV2Deterministic sets the optional deterministic attribute to value.
//
// value: A string indicating the op-level determinism to use. Deterministic controls
// whether the dataset is allowed to return elements out of order if the next
// element to be returned isn't available, but a later element is. Options are
// "true", "false", and "default". "default" indicates that determinism should be
// decided by the `experimental_deterministic` parameter of `tf.data.Options`.
// If not specified, defaults to "default"
func ParseExampleDatasetV2Deterministic(value string) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// ParseExampleDatasetV2RaggedKeys sets the optional ragged_keys attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetV2RaggedKeys(value []string) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["ragged_keys"] = value
	}
}

// ParseExampleDatasetV2RaggedValueTypes sets the optional ragged_value_types attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetV2RaggedValueTypes(value []tf.DataType) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["ragged_value_types"] = value
	}
}

// ParseExampleDatasetV2RaggedSplitTypes sets the optional ragged_split_types attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetV2RaggedSplitTypes(value []tf.DataType) ParseExampleDatasetV2Attr {
	return func(m optionalAttr) {
		m["ragged_split_types"] = value
	}
}

// Transforms `input_dataset` containing `Example` protos as vectors of DT_STRING into a dataset of `Tensor` or `SparseTensor` objects representing the parsed features.
//
// Arguments:
//
//
//	dense_defaults: A dict mapping string keys to `Tensor`s.
// The keys of the dict must match the dense_keys of the feature.
//	sparse_keys: A list of string keys in the examples features.
// The results for these keys will be returned as `SparseTensor` objects.
//	dense_keys: A list of Ndense string Tensors (scalars).
// The keys expected in the Examples features associated with dense values.
//	sparse_types: A list of `DTypes` of the same length as `sparse_keys`.
// Only `tf.float32` (`FloatList`), `tf.int64` (`Int64List`),
// and `tf.string` (`BytesList`) are supported.
//	dense_shapes: List of tuples with the same length as `dense_keys`.
// The shape of the data for each dense feature referenced by `dense_keys`.
// Required for any input tensors identified by `dense_keys`.  Must be
// either fully defined, or may contain an unknown first dimension.
// An unknown first dimension means the feature is treated as having
// a variable number of blocks, and the output shape along this dimension
// is considered unknown at graph build time.  Padding is applied for
// minibatch elements smaller than the maximum number of blocks for the
// given feature along this dimension.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
func ParseExampleDatasetV2(scope *Scope, input_dataset tf.Output, num_parallel_calls tf.Output, dense_defaults []tf.Output, sparse_keys []string, dense_keys []string, sparse_types []tf.DataType, dense_shapes []tf.Shape, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ParseExampleDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_keys": sparse_keys, "dense_keys": dense_keys, "sparse_types": sparse_types, "dense_shapes": dense_shapes, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseExampleDatasetV2",
		Input: []tf.Input{
			input_dataset, num_parallel_calls, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GenerateVocabRemappingAttr is an optional argument to GenerateVocabRemapping.
type GenerateVocabRemappingAttr func(optionalAttr)

// GenerateVocabRemappingOldVocabSize sets the optional old_vocab_size attribute to value.
//
// value: Number of entries in the old vocab file to consider.  If -1,
// use the entire old vocabulary.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func GenerateVocabRemappingOldVocabSize(value int64) GenerateVocabRemappingAttr {
	return func(m optionalAttr) {
		m["old_vocab_size"] = value
	}
}

// Given a path to new and old vocabulary files, returns a remapping Tensor of
//
// length `num_new_vocab`, where `remapping[i]` contains the row number in the old
// vocabulary that corresponds to row `i` in the new vocabulary (starting at line
// `new_vocab_offset` and up to `num_new_vocab` entities), or `-1` if entry `i`
// in the new vocabulary is not in the old vocabulary.  The old vocabulary is
// constrained to the first `old_vocab_size` entries if `old_vocab_size` is not the
// default value of -1.
//
// `num_vocab_offset` enables
// use in the partitioned variable case, and should generally be set through
// examining partitioning info.  The format of the files should be a text file,
// with each line containing a single entity within the vocabulary.
//
// For example, with `new_vocab_file` a text file containing each of the following
// elements on a single line: `[f0, f1, f2, f3]`, old_vocab_file = [f1, f0, f3],
// `num_new_vocab = 3, new_vocab_offset = 1`, the returned remapping would be
// `[0, -1, 2]`.
//
// The op also returns a count of how many entries in the new vocabulary
// were present in the old vocabulary, which is used to calculate the number of
// values to initialize in a weight matrix remapping
//
// This functionality can be used to remap both row vocabularies (typically,
// features) and column vocabularies (typically, classes) from TensorFlow
// checkpoints.  Note that the partitioning logic relies on contiguous vocabularies
// corresponding to div-partitioned variables.  Moreover, the underlying remapping
// uses an IndexTable (as opposed to an inexact CuckooTable), so client code should
// use the corresponding index_table_from_file() as the FeatureColumn framework
// does (as opposed to tf.feature_to_id(), which uses a CuckooTable).
//
// Arguments:
//	new_vocab_file: Path to the new vocab file.
//	old_vocab_file: Path to the old vocab file.
//	new_vocab_offset: How many entries into the new vocab file to start reading.
//	num_new_vocab: Number of entries in the new vocab file to remap.
//
// Returns:
//	remapping: A Tensor of length num_new_vocab where the element at index i
// is equal to the old ID that maps to the new ID i.  This element is -1 for any
// new ID that is not found in the old vocabulary.
//	num_present: Number of new vocab entries found in old vocab.
func GenerateVocabRemapping(scope *Scope, new_vocab_file tf.Output, old_vocab_file tf.Output, new_vocab_offset int64, num_new_vocab int64, optional ...GenerateVocabRemappingAttr) (remapping tf.Output, num_present tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"new_vocab_offset": new_vocab_offset, "num_new_vocab": num_new_vocab}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GenerateVocabRemapping",
		Input: []tf.Input{
			new_vocab_file, old_vocab_file,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Creates a dataset that overrides the maximum intra-op parallelism.
//
// Arguments:
//
//	max_intra_op_parallelism: Identifies the maximum intra-op parallelism to use.
//
//
func ExperimentalMaxIntraOpParallelismDataset(scope *Scope, input_dataset tf.Output, max_intra_op_parallelism tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalMaxIntraOpParallelismDataset",
		Input: []tf.Input{
			input_dataset, max_intra_op_parallelism,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StageClearAttr is an optional argument to StageClear.
type StageClearAttr func(optionalAttr)

// StageClearCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageClearCapacity(value int64) StageClearAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StageClearMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageClearMemoryLimit(value int64) StageClearAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StageClearContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func StageClearContainer(value string) StageClearAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StageClearSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func StageClearSharedName(value string) StageClearAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes all elements in the underlying container.
//
// Returns the created operation.
func StageClear(scope *Scope, dtypes []tf.DataType, optional ...StageClearAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StageClear",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Records the latency of producing `input_dataset` elements in a StatsAggregator.
func ExperimentalLatencyStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalLatencyStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the name of the device on which `resource` has been placed.
func IteratorGetDevice(scope *Scope, resource tf.Output) (device tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IteratorGetDevice",
		Input: []tf.Input{
			resource,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a Dataset that returns pseudorandom numbers.
//
// Arguments:
//	seed: A scalar seed for the random number generator. If either seed or
// seed2 is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//
//
func ExperimentalRandomDataset(scope *Scope, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalRandomDataset",
		Input: []tf.Input{
			seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalIgnoreErrorsDatasetAttr is an optional argument to ExperimentalIgnoreErrorsDataset.
type ExperimentalIgnoreErrorsDatasetAttr func(optionalAttr)

// ExperimentalIgnoreErrorsDatasetLogWarning sets the optional log_warning attribute to value.
// If not specified, defaults to false
func ExperimentalIgnoreErrorsDatasetLogWarning(value bool) ExperimentalIgnoreErrorsDatasetAttr {
	return func(m optionalAttr) {
		m["log_warning"] = value
	}
}

// Creates a dataset that contains the elements of `input_dataset` ignoring errors.
func ExperimentalIgnoreErrorsDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalIgnoreErrorsDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalIgnoreErrorsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SpaceToBatch for N-D tensors of type T.
//
// This operation divides "spatial" dimensions `[1, ..., M]` of the input into a
// grid of blocks of shape `block_shape`, and interleaves these blocks with the
// "batch" dimension (0) such that in the output, the spatial dimensions
// `[1, ..., M]` correspond to the position within the grid, and the batch
// dimension combines both the position within a spatial block and the original
// batch position.  Prior to division into blocks, the spatial dimensions of the
// input are optionally zero padded according to `paddings`. See below for a
// precise description.
//
// This operation is equivalent to the following steps:
//
// 1. Zero-pad the start and end of dimensions `[1, ..., M]` of the
//    input according to `paddings` to produce `padded` of shape `padded_shape`.
//
// 2. Reshape `padded` to `reshaped_padded` of shape:
//
//      [batch] +
//      [padded_shape[1] / block_shape[0],
//        block_shape[0],
//       ...,
//       padded_shape[M] / block_shape[M-1],
//       block_shape[M-1]] +
//      remaining_shape
//
// 3. Permute dimensions of `reshaped_padded` to produce
//    `permuted_reshaped_padded` of shape:
//
//      block_shape +
//      [batch] +
//      [padded_shape[1] / block_shape[0],
//       ...,
//       padded_shape[M] / block_shape[M-1]] +
//      remaining_shape
//
// 4. Reshape `permuted_reshaped_padded` to flatten `block_shape` into the batch
//    dimension, producing an output tensor of shape:
//
//      [batch * prod(block_shape)] +
//      [padded_shape[1] / block_shape[0],
//       ...,
//       padded_shape[M] / block_shape[M-1]] +
//      remaining_shape
//
// Some examples:
//
// (1) For the following input of shape `[1, 2, 2, 1]`, `block_shape = [2, 2]`, and
//     `paddings = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 1]` and value:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// (2) For the following input of shape `[1, 2, 2, 3]`, `block_shape = [2, 2]`, and
//     `paddings = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 3]` and value:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[1, 4, 4, 1]`, `block_shape = [2, 2]`, and
//     `paddings = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]],
//       [[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[4, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// (4) For the following input of shape `[2, 2, 4, 1]`, block_shape = `[2, 2]`, and
//     paddings = `[[0, 0], [2, 0]]`:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]]],
//      [[[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[8, 1, 3, 1]` and value:
//
// ```
// x = [[[[0], [1], [3]]], [[[0], [9], [11]]],
//      [[[0], [2], [4]]], [[[0], [10], [12]]],
//      [[[0], [5], [7]]], [[[0], [13], [15]]],
//      [[[0], [6], [8]]], [[[0], [14], [16]]]]
// ```
//
// Among others, this operation is useful for reducing atrous convolution into
// regular convolution.
//
// Arguments:
//	input: N-D with shape `input_shape = [batch] + spatial_shape + remaining_shape`,
// where spatial_shape has `M` dimensions.
//	block_shape: 1-D with shape `[M]`, all values must be >= 1.
//	paddings: 2-D with shape `[M, 2]`, all values must be >= 0.
//   `paddings[i] = [pad_start, pad_end]` specifies the padding for input dimension
//   `i + 1`, which corresponds to spatial dimension `i`.  It is required that
//   `block_shape[i]` divides `input_shape[i + 1] + pad_start + pad_end`.
func SpaceToBatchND(scope *Scope, input tf.Output, block_shape tf.Output, paddings tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SpaceToBatchND",
		Input: []tf.Input{
			input, block_shape, paddings,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched diagonal tensor with given batched diagonal values.
//
// Returns a tensor with the contents in `diagonal` as `k[0]`-th to `k[1]`-th
// diagonals of a matrix, with everything else padded with `padding`. `num_rows`
// and `num_cols` specify the dimension of the innermost matrix of the output. If
// both are not specified, the op assumes the innermost matrix is square and infers
// its size from `k` and the innermost dimension of `diagonal`. If only one of them
// is specified, the op assumes the unspecified value is the smallest possible
// based on other criteria.
//
// Let `diagonal` have `r` dimensions `[I, J, ..., L, M, N]`. The output tensor has
// rank `r+1` with shape `[I, J, ..., L, M, num_rows, num_cols]` when only one
// diagonal is given (`k` is an integer or `k[0] == k[1]`). Otherwise, it has rank
// `r` with shape `[I, J, ..., L, num_rows, num_cols]`.
//
// The second innermost dimension of `diagonal` has double meaning.
// When `k` is scalar or `k[0] == k[1]`, `M` is part of the batch size
// [I, J, ..., M], and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
//     padding_value                             ; otherwise
// ```
//
// Otherwise, `M` is treated as the number of diagonals for the matrix in the
// same batch (`M = k[1]-k[0]+1`), and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//     padding_value                                     ; otherwise
// ```
// where `d = n - m`, `diag_index = k[1] - d`, and `index_in_diag = n - max(d, 0)`.
//
// For example:
//
// ```
// # The main diagonal.
// diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
//                      [5, 6, 7, 8]])
// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
//                                [0, 2, 0, 0],
//                                [0, 0, 3, 0],
//                                [0, 0, 0, 4]],
//                               [[5, 0, 0, 0],
//                                [0, 6, 0, 0],
//                                [0, 0, 7, 0],
//                                [0, 0, 0, 8]]]
//
// # A superdiagonal (per batch).
// diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
//                      [4, 5, 6]])
// tf.matrix_diag(diagonal, k = 1)
//   ==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
//         [0, 0, 2, 0],
//         [0, 0, 0, 3],
//         [0, 0, 0, 0]],
//        [[0, 4, 0, 0],
//         [0, 0, 5, 0],
//         [0, 0, 0, 6],
//         [0, 0, 0, 0]]]
//
// # A band of diagonals.
// diagonals = np.array([[[1, 2, 3],  # Input shape: (2, 2, 3)
//                        [4, 5, 0]],
//                       [[6, 7, 9],
//                        [9, 1, 0]]])
// tf.matrix_diag(diagonals, k = (-1, 0))
//   ==> [[[1, 0, 0],  # Output shape: (2, 3, 3)
//         [4, 2, 0],
//         [0, 5, 3]],
//        [[6, 0, 0],
//         [9, 7, 0],
//         [0, 1, 9]]]
//
// # Rectangular matrix.
// diagonal = np.array([1, 2])  # Input shape: (2)
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
//   ==> [[0, 0, 0, 0],  # Output shape: (3, 4)
//        [1, 0, 0, 0],
//        [0, 2, 0, 0]]
//
// # Rectangular matrix with inferred num_cols and padding_value = 9.
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding_value = 9)
//   ==> [[9, 9],  # Output shape: (3, 2)
//        [1, 9],
//        [9, 2]]
// ```
//
// Arguments:
//	diagonal: Rank `r`, where `r >= 1`
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//	num_rows: The number of rows of the output matrix. If it is not provided, the op assumes
// the output matrix is a square matrix and infers the matrix size from k and the
// innermost dimension of `diagonal`.
//	num_cols: The number of columns of the output matrix. If it is not provided, the op
// assumes the output matrix is a square matrix and infers the matrix size from
// k and the innermost dimension of `diagonal`.
//	padding_value: The number to fill the area outside the specified diagonal band with.
// Default is 0.
//
// Returns Has rank `r+1` when `k` is an integer or `k[0] == k[1]`, rank `r` otherwise.
func MatrixDiagV2(scope *Scope, diagonal tf.Output, k tf.Output, num_rows tf.Output, num_cols tf.Output, padding_value tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagV2",
		Input: []tf.Input{
			diagonal, k, num_rows, num_cols, padding_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that overrides the maximum intra-op parallelism.
//
// Arguments:
//
//	max_intra_op_parallelism: Identifies the maximum intra-op parallelism to use.
//
//
func MaxIntraOpParallelismDataset(scope *Scope, input_dataset tf.Output, max_intra_op_parallelism tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MaxIntraOpParallelismDataset",
		Input: []tf.Input{
			input_dataset, max_intra_op_parallelism,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the element at the specified index in a dataset.
func GetElementAtIndex(scope *Scope, dataset tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "GetElementAtIndex",
		Input: []tf.Input{
			dataset, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("GetElementAtIndex", err)
		return
	}
	return components
}

// CudnnRNNBackpropV2Attr is an optional argument to CudnnRNNBackpropV2.
type CudnnRNNBackpropV2Attr func(optionalAttr)

// CudnnRNNBackpropV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropV2RnnMode(value string) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropV2InputMode(value string) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropV2Direction(value string) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV2Dropout(value float32) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV2Seed(value int64) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV2Seed2(value int64) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Backprop step of CudnnRNN.
//
// Compute the backprop of both data and weights in a RNN. Takes an extra
//     "host_reserved" inupt than CudnnRNNBackprop, which is used to determine RNN
//     cudnnRNNAlgo_t and cudnnMathType_t.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//     the actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//     num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//     dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//     pass.
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//     pass.
// reserve_space: The same reserve_space produced in the forward operation.
// host_reserved: The same host_reserved produced in the forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//     as input.
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//     shape as input_h.
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//     shape as input_c.
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//     same shape as params.
func CudnnRNNBackpropV2(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, host_reserved tf.Output, optional ...CudnnRNNBackpropV2Attr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackpropV2",
		Input: []tf.Input{
			input, input_h, input_c, params, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, host_reserved,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// DirectedInterleaveDatasetAttr is an optional argument to DirectedInterleaveDataset.
type DirectedInterleaveDatasetAttr func(optionalAttr)

// DirectedInterleaveDatasetStopOnEmptyDataset sets the optional stop_on_empty_dataset attribute to value.
// If not specified, defaults to false
func DirectedInterleaveDatasetStopOnEmptyDataset(value bool) DirectedInterleaveDatasetAttr {
	return func(m optionalAttr) {
		m["stop_on_empty_dataset"] = value
	}
}

// A substitute for `InterleaveDataset` on a fixed list of `N` datasets.
//
// Arguments:
//	selector_input_dataset: A dataset of scalar `DT_INT64` elements that determines which of the
// `N` data inputs should produce the next output element.
//	data_input_datasets: `N` datasets with the same type that will be interleaved according to
// the values of `selector_input_dataset`.
//
//
func DirectedInterleaveDataset(scope *Scope, selector_input_dataset tf.Output, data_input_datasets []tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DirectedInterleaveDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DirectedInterleaveDataset",
		Input: []tf.Input{
			selector_input_dataset, tf.OutputList(data_input_datasets),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that batches input elements into a SparseTensor.
//
// Arguments:
//	input_dataset: A handle to an input dataset. Must have a single component.
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//	row_shape: A vector representing the dense shape of each row in the produced
// SparseTensor. The shape may be partially specified, using `-1` to indicate
// that a particular dimension should use the maximum size of all batch elements.
//
//
func ExperimentalDenseToSparseBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, row_shape tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalDenseToSparseBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, row_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that batches input elements into a SparseTensor.
//
// Arguments:
//	input_dataset: A handle to an input dataset. Must have a single component.
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//	row_shape: A vector representing the dense shape of each row in the produced
// SparseTensor. The shape may be partially specified, using `-1` to indicate
// that a particular dimension should use the maximum size of all batch elements.
//
//
func DenseToSparseBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, row_shape tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "DenseToSparseBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, row_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes the given dataset to the given file using the TFRecord format.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to write.
//	filename: A scalar string tensor representing the filename to use.
//	compression_type: A scalar string tensor containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
//
// Returns the created operation.
func ExperimentalDatasetToTFRecord(scope *Scope, input_dataset tf.Output, filename tf.Output, compression_type tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalDatasetToTFRecord",
		Input: []tf.Input{
			input_dataset, filename, compression_type,
		},
	}
	return scope.AddOperation(opspec)
}

// Creates a dataset from the given `graph_def`.
//
// Creates a dataset from the provided `graph_def`.
//
// Arguments:
//	graph_def: The graph representation of the dataset (as serialized GraphDef).
//
// Returns A variant tensor representing the dataset.
func DatasetFromGraph(scope *Scope, graph_def tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetFromGraph",
		Input: []tf.Input{
			graph_def,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the cardinality of `input_dataset`.
//
// Returns the cardinality of `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return cardinality for.
//
// Returns The cardinality of `input_dataset`. Named constants are used to represent
// infinite and unknown cardinality.
func ExperimentalDatasetCardinality(scope *Scope, input_dataset tf.Output) (cardinality tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalDatasetCardinality",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Interleave the values from the `data` tensors into a single tensor.
//
// Builds a merged tensor such that
//
// ```python
//     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
// ```
//
// For example, if each `indices[m]` is scalar or vector, we have
//
// ```python
//     # Scalar indices:
//     merged[indices[m], ...] = data[m][...]
//
//     # Vector indices:
//     merged[indices[m][i], ...] = data[m][i, ...]
// ```
//
// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
// `constant`, the output shape is
//
//     merged.shape = [max(indices)] + constant
//
// Values are merged in order, so if an index appears in both `indices[m][i]` and
// `indices[n][j]` for `(m,i) < (n,j)` the slice `data[n][j]` will appear in the
// merged result. If you do not need this guarantee, ParallelDynamicStitch might
// perform better on some devices.
//
// For example:
//
// ```python
//     indices[0] = 6
//     indices[1] = [4, 1]
//     indices[2] = [[5, 2], [0, 3]]
//     data[0] = [61, 62]
//     data[1] = [[41, 42], [11, 12]]
//     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
//     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
//               [51, 52], [61, 62]]
// ```
//
// This method can be used to merge partitions created by `dynamic_partition`
// as illustrated on the following example:
//
// ```python
//     # Apply function (increments x_i) on elements for which a certain condition
//     # apply (x_i != -1 in this example).
//     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
//     condition_mask=tf.not_equal(x,tf.constant(-1.))
//     partitioned_data = tf.dynamic_partition(
//         x, tf.cast(condition_mask, tf.int32) , 2)
//     partitioned_data[1] = partitioned_data[1] + 1.0
//     condition_indices = tf.dynamic_partition(
//         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
//     x = tf.dynamic_stitch(condition_indices, partitioned_data)
//     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
//     # unchanged.
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
// </div>
func DynamicStitch(scope *Scope, indices []tf.Output, data []tf.Output) (merged tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DynamicStitch",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(data),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RaggedCountSparseOutputAttr is an optional argument to RaggedCountSparseOutput.
type RaggedCountSparseOutputAttr func(optionalAttr)

// RaggedCountSparseOutputMinlength sets the optional minlength attribute to value.
//
// value: Minimum value to count. Can be set to -1 for no minimum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RaggedCountSparseOutputMinlength(value int64) RaggedCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["minlength"] = value
	}
}

// RaggedCountSparseOutputMaxlength sets the optional maxlength attribute to value.
//
// value: Maximum value to count. Can be set to -1 for no maximum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RaggedCountSparseOutputMaxlength(value int64) RaggedCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["maxlength"] = value
	}
}

// Performs sparse-output bin counting for a ragged tensor input.
//
//   Counts the number of times each value occurs in the input.
//
// Arguments:
//	splits: Tensor containing the row splits of the ragged tensor to count.
//	values: Tensor containing values of the sparse tensor to count.
//	weights: A Tensor of the same shape as indices containing per-index weight values.
// May also be the empty tensor if no weights are used.
//	binary_output: Whether to output the number of occurrences of each value or 1.
//
// Returns:
//	output_indices: Indices tensor for the resulting sparse tensor object.
//	output_values: Values tensor for the resulting sparse tensor object.
//	output_dense_shape: Shape tensor for the resulting sparse tensor object.
//   END
//   }
//   attr {
//     name: "T"
//     description: <<END
// Dtype of the input values tensor.
func RaggedCountSparseOutput(scope *Scope, splits tf.Output, values tf.Output, weights tf.Output, binary_output bool, optional ...RaggedCountSparseOutputAttr) (output_indices tf.Output, output_values tf.Output, output_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"binary_output": binary_output}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RaggedCountSparseOutput",
		Input: []tf.Input{
			splits, values, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Gets the next output from the given iterator .
func IteratorGetNext(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNext",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNext", err)
		return
	}
	return components
}

// Computes the static batch size of a dataset sans partial batches.
func ComputeBatchSize(scope *Scope, input_dataset tf.Output) (batch_size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ComputeBatchSize",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Uncompresses a compressed dataset element.
func UncompressElement(scope *Scope, compressed tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "UncompressElement",
		Input: []tf.Input{
			compressed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("UncompressElement", err)
		return
	}
	return components
}

// Records the bytes size of each element of `input_dataset` in a StatsAggregator.
func BytesProducedStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "BytesProducedStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalAutoShardDatasetAttr is an optional argument to ExperimentalAutoShardDataset.
type ExperimentalAutoShardDatasetAttr func(optionalAttr)

// ExperimentalAutoShardDatasetAutoShardPolicy sets the optional auto_shard_policy attribute to value.
// If not specified, defaults to 0
func ExperimentalAutoShardDatasetAutoShardPolicy(value int64) ExperimentalAutoShardDatasetAttr {
	return func(m optionalAttr) {
		m["auto_shard_policy"] = value
	}
}

// Creates a dataset that shards the input dataset.
//
// Creates a dataset that shards the input dataset by num_workers, returning a
// sharded dataset for the index-th worker. This attempts to automatically shard
// a dataset by examining the Dataset graph and inserting a shard op before the
// inputs to a reader Dataset (e.g. CSVDataset, TFRecordDataset).
//
// This dataset will throw a NotFound error if we cannot shard the dataset
// automatically.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	num_workers: A scalar representing the number of workers to distribute this dataset across.
//	index: A scalar representing the index of the current worker out of num_workers.
//
//
func ExperimentalAutoShardDataset(scope *Scope, input_dataset tf.Output, num_workers tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalAutoShardDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalAutoShardDataset",
		Input: []tf.Input{
			input_dataset, num_workers, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A transformation that asserts which transformations happen next.
//
// This transformation checks whether the camel-case names (i.e. "FlatMap", not
// "flat_map") of the transformations following this transformation match the list
// of names in the `transformations` argument. If there is a mismatch, the
// transformation raises an exception.
//
// The check occurs when iterating over the contents of the dataset, which
// means that the check happens *after* any static optimizations are applied
// to the dataset graph.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
// `AssertNextDataset` passes through the outputs of its input dataset.
//	transformations: A `tf.string` vector `tf.Tensor` identifying the transformations that are
// expected to happen next.
//
//
func AssertNextDataset(scope *Scope, input_dataset tf.Output, transformations tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AssertNextDataset",
		Input: []tf.Input{
			input_dataset, transformations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return the index of device the op runs.
//
// Given a list of device names, this operation returns the index of the device
// this op runs. The length of the list is returned in two cases:
// (1) Device does not exist in the given device list.
// (2) It is in XLA compilation.
func DeviceIndex(scope *Scope, device_names []string) (index tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"device_names": device_names}
	opspec := tf.OpSpec{
		Type: "DeviceIndex",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShardDatasetAttr is an optional argument to ShardDataset.
type ShardDatasetAttr func(optionalAttr)

// ShardDatasetRequireNonEmpty sets the optional require_non_empty attribute to value.
// If not specified, defaults to false
func ShardDatasetRequireNonEmpty(value bool) ShardDatasetAttr {
	return func(m optionalAttr) {
		m["require_non_empty"] = value
	}
}

// ShardDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func ShardDatasetMetadata(value string) ShardDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a `Dataset` that includes only 1/`num_shards` of this dataset.
//
// Arguments:
//
//	num_shards: An integer representing the number of shards operating in parallel.
//	index: An integer representing the current worker index.
//
//
func ShardDataset(scope *Scope, input_dataset tf.Output, num_shards tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ShardDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShardDataset",
		Input: []tf.Input{
			input_dataset, num_shards, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NonMaxSuppressionV5Attr is an optional argument to NonMaxSuppressionV5.
type NonMaxSuppressionV5Attr func(optionalAttr)

// NonMaxSuppressionV5PadToMaxOutputSize sets the optional pad_to_max_output_size attribute to value.
//
// value: If true, the output `selected_indices` is padded to be of length
// `max_output_size`. Defaults to false.
// If not specified, defaults to false
func NonMaxSuppressionV5PadToMaxOutputSize(value bool) NonMaxSuppressionV5Attr {
	return func(m optionalAttr) {
		m["pad_to_max_output_size"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system and more
// generally is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//   selected_indices = tf.image.non_max_suppression_v2(
//       boxes, scores, max_output_size, iou_threshold, score_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
// This op also supports a Soft-NMS (with Gaussian weighting) mode (c.f.
// Bodla et al, https://arxiv.org/abs/1704.04503) where boxes reduce the score
// of other overlapping boxes instead of directly causing them to be pruned.
// To enable this Soft-NMS mode, set the `soft_nms_sigma` parameter to be
// larger than 0.
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//	soft_nms_sigma: A 0-D float tensor representing the sigma parameter for Soft NMS; see Bodla et
// al (c.f. https://arxiv.org/abs/1704.04503).  When `soft_nms_sigma=0.0` (which
// is default), we fall back to standard (hard) NMS.
//
// Returns:
//	selected_indices: A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
//	selected_scores: A 1-D float tensor of shape `[M]` representing the corresponding
// scores for each selected box, where `M <= max_output_size`.  Scores only differ
// from corresponding input scores when using Soft NMS (i.e. when
// `soft_nms_sigma>0`)
//	valid_outputs: A 0-D integer tensor representing the number of valid elements in
// `selected_indices`, with the valid elements appearing first.
func NonMaxSuppressionV5(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output, soft_nms_sigma tf.Output, optional ...NonMaxSuppressionV5Attr) (selected_indices tf.Output, selected_scores tf.Output, valid_outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV5",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold, score_threshold, soft_nms_sigma,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// NonMaxSuppressionV4Attr is an optional argument to NonMaxSuppressionV4.
type NonMaxSuppressionV4Attr func(optionalAttr)

// NonMaxSuppressionV4PadToMaxOutputSize sets the optional pad_to_max_output_size attribute to value.
//
// value: If true, the output `selected_indices` is padded to be of length
// `max_output_size`. Defaults to false.
// If not specified, defaults to false
func NonMaxSuppressionV4PadToMaxOutputSize(value bool) NonMaxSuppressionV4Attr {
	return func(m optionalAttr) {
		m["pad_to_max_output_size"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system and more
// generally is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//   selected_indices = tf.image.non_max_suppression_v2(
//       boxes, scores, max_output_size, iou_threshold, score_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//
// Returns:
//	selected_indices: A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
//	valid_outputs: A 0-D integer tensor representing the number of valid elements in
// `selected_indices`, with the valid elements appearing first.
func NonMaxSuppressionV4(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output, optional ...NonMaxSuppressionV4Attr) (selected_indices tf.Output, valid_outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV4",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold, score_threshold,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system and more
// generally is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//   selected_indices = tf.image.non_max_suppression_v2(
//       boxes, scores, max_output_size, iou_threshold, score_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionV3(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV3",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold, score_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system.  Note that this
// algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//   selected_indices = tf.image.non_max_suppression_v2(
//       boxes, scores, max_output_size, iou_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionV2(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV2",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NonMaxSuppressionAttr is an optional argument to NonMaxSuppression.
type NonMaxSuppressionAttr func(optionalAttr)

// NonMaxSuppressionIouThreshold sets the optional iou_threshold attribute to value.
//
// value: A float representing the threshold for deciding whether boxes
// overlap too much with respect to IOU.
// If not specified, defaults to 0.5
func NonMaxSuppressionIouThreshold(value float32) NonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["iou_threshold"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system.  Note that this
// algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//   selected_indices = tf.image.non_max_suppression(
//       boxes, scores, max_output_size, iou_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppression(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, optional ...NonMaxSuppressionAttr) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppression",
		Input: []tf.Input{
			boxes, scores, max_output_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CropAndResizeGradBoxesAttr is an optional argument to CropAndResizeGradBoxes.
type CropAndResizeGradBoxesAttr func(optionalAttr)

// CropAndResizeGradBoxesMethod sets the optional method attribute to value.
//
// value: A string specifying the interpolation method. Only 'bilinear' is
// supported for now.
// If not specified, defaults to "bilinear"
func CropAndResizeGradBoxesMethod(value string) CropAndResizeGradBoxesAttr {
	return func(m optionalAttr) {
		m["method"] = value
	}
}

// Computes the gradient of the crop_and_resize op wrt the input boxes tensor.
//
// Arguments:
//	grads: A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
//	image: A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
// Both `image_height` and `image_width` need to be positive.
//	boxes: A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
// specifies the coordinates of a box in the `box_ind[i]` image and is specified
// in normalized coordinates `[y1, x1, y2, x2]`. A normalized coordinate value of
// `y` is mapped to the image coordinate at `y * (image_height - 1)`, so as the
// `[0, 1]` interval of normalized image height is mapped to
// `[0, image_height - 1] in image height coordinates. We do allow y1 > y2, in
// which case the sampled crop is an up-down flipped version of the original
// image. The width dimension is treated similarly. Normalized coordinates
// outside the `[0, 1]` range are allowed, in which case we use
// `extrapolation_value` to extrapolate the input image values.
//	box_ind: A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
// The value of `box_ind[i]` specifies the image that the `i`-th box refers to.
//
// Returns A 2-D tensor of shape `[num_boxes, 4]`.
func CropAndResizeGradBoxes(scope *Scope, grads tf.Output, image tf.Output, boxes tf.Output, box_ind tf.Output, optional ...CropAndResizeGradBoxesAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CropAndResizeGradBoxes",
		Input: []tf.Input{
			grads, image, boxes, box_ind,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractGlimpseV2Attr is an optional argument to ExtractGlimpseV2.
type ExtractGlimpseV2Attr func(optionalAttr)

// ExtractGlimpseV2Centered sets the optional centered attribute to value.
//
// value: indicates if the offset coordinates are centered relative to
// the image, in which case the (0, 0) offset is relative to the center
// of the input images. If false, the (0,0) offset corresponds to the
// upper left corner of the input images.
// If not specified, defaults to true
func ExtractGlimpseV2Centered(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["centered"] = value
	}
}

// ExtractGlimpseV2Normalized sets the optional normalized attribute to value.
//
// value: indicates if the offset coordinates are normalized.
// If not specified, defaults to true
func ExtractGlimpseV2Normalized(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["normalized"] = value
	}
}

// ExtractGlimpseV2UniformNoise sets the optional uniform_noise attribute to value.
//
// value: indicates if the noise should be generated using a
// uniform distribution or a Gaussian distribution.
// If not specified, defaults to true
func ExtractGlimpseV2UniformNoise(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["uniform_noise"] = value
	}
}

// ExtractGlimpseV2Noise sets the optional noise attribute to value.
//
// value: indicates if the noise should `uniform`, `gaussian`, or
// `zero`. The default is `uniform` which means the noise type
// will be decided by `uniform_noise`.
// If not specified, defaults to "uniform"
func ExtractGlimpseV2Noise(value string) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["noise"] = value
	}
}

// Extracts a glimpse from the input tensor.
//
// Returns a set of windows called glimpses extracted at location
// `offsets` from the input tensor. If the windows only partially
// overlaps the inputs, the non overlapping areas will be filled with
// random noise.
//
// The result is a 4-D tensor of shape `[batch_size, glimpse_height,
// glimpse_width, channels]`. The channels and batch dimensions are the
// same as that of the input tensor. The height and width of the output
// windows are specified in the `size` parameter.
//
// The argument `normalized` and `centered` controls how the windows are built:
//
// * If the coordinates are normalized but not centered, 0.0 and 1.0
//   correspond to the minimum and maximum of each height and width
//   dimension.
// * If the coordinates are both normalized and centered, they range from
//   -1.0 to 1.0. The coordinates (-1.0, -1.0) correspond to the upper
//   left corner, the lower right corner is located at (1.0, 1.0) and the
//   center is at (0, 0).
// * If the coordinates are not normalized they are interpreted as
//   numbers of pixels.
//
// Arguments:
//	input: A 4-D float tensor of shape `[batch_size, height, width, channels]`.
//	size: A 1-D tensor of 2 elements containing the size of the glimpses
// to extract.  The glimpse height must be specified first, following
// by the glimpse width.
//	offsets: A 2-D integer tensor of shape `[batch_size, 2]` containing
// the y, x locations of the center of each window.
//
// Returns A tensor representing the glimpses `[batch_size,
// glimpse_height, glimpse_width, channels]`.
func ExtractGlimpseV2(scope *Scope, input tf.Output, size tf.Output, offsets tf.Output, optional ...ExtractGlimpseV2Attr) (glimpse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractGlimpseV2",
		Input: []tf.Input{
			input, size, offsets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractGlimpseAttr is an optional argument to ExtractGlimpse.
type ExtractGlimpseAttr func(optionalAttr)

// ExtractGlimpseCentered sets the optional centered attribute to value.
//
// value: indicates if the offset coordinates are centered relative to
// the image, in which case the (0, 0) offset is relative to the center
// of the input images. If false, the (0,0) offset corresponds to the
// upper left corner of the input images.
// If not specified, defaults to true
func ExtractGlimpseCentered(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["centered"] = value
	}
}

// ExtractGlimpseNormalized sets the optional normalized attribute to value.
//
// value: indicates if the offset coordinates are normalized.
// If not specified, defaults to true
func ExtractGlimpseNormalized(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["normalized"] = value
	}
}

// ExtractGlimpseUniformNoise sets the optional uniform_noise attribute to value.
//
// value: indicates if the noise should be generated using a
// uniform distribution or a Gaussian distribution.
// If not specified, defaults to true
func ExtractGlimpseUniformNoise(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["uniform_noise"] = value
	}
}

// ExtractGlimpseNoise sets the optional noise attribute to value.
//
// value: indicates if the noise should `uniform`, `gaussian`, or
// `zero`. The default is `uniform` which means the noise type
// will be decided by `uniform_noise`.
// If not specified, defaults to "uniform"
func ExtractGlimpseNoise(value string) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["noise"] = value
	}
}

// Extracts a glimpse from the input tensor.
//
// Returns a set of windows called glimpses extracted at location
// `offsets` from the input tensor. If the windows only partially
// overlaps the inputs, the non overlapping areas will be filled with
// random noise.
//
// The result is a 4-D tensor of shape `[batch_size, glimpse_height,
// glimpse_width, channels]`. The channels and batch dimensions are the
// same as that of the input tensor. The height and width of the output
// windows are specified in the `size` parameter.
//
// The argument `normalized` and `centered` controls how the windows are built:
//
// * If the coordinates are normalized but not centered, 0.0 and 1.0
//   correspond to the minimum and maximum of each height and width
//   dimension.
// * If the coordinates are both normalized and centered, they range from
//   -1.0 to 1.0. The coordinates (-1.0, -1.0) correspond to the upper
//   left corner, the lower right corner is located at (1.0, 1.0) and the
//   center is at (0, 0).
// * If the coordinates are not normalized they are interpreted as
//   numbers of pixels.
//
// Arguments:
//	input: A 4-D float tensor of shape `[batch_size, height, width, channels]`.
//	size: A 1-D tensor of 2 elements containing the size of the glimpses
// to extract.  The glimpse height must be specified first, following
// by the glimpse width.
//	offsets: A 2-D integer tensor of shape `[batch_size, 2]` containing
// the y, x locations of the center of each window.
//
// Returns A tensor representing the glimpses `[batch_size,
// glimpse_height, glimpse_width, channels]`.
func ExtractGlimpse(scope *Scope, input tf.Output, size tf.Output, offsets tf.Output, optional ...ExtractGlimpseAttr) (glimpse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractGlimpse",
		Input: []tf.Input{
			input, size, offsets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessSampleDistortedBoundingBoxAttr is an optional argument to StatelessSampleDistortedBoundingBox.
type StatelessSampleDistortedBoundingBoxAttr func(optionalAttr)

// StatelessSampleDistortedBoundingBoxAspectRatioRange sets the optional aspect_ratio_range attribute to value.
//
// value: The cropped area of the image must have an aspect ratio =
// width / height within this range.
// If not specified, defaults to {f:0.75 f:1.33}
func StatelessSampleDistortedBoundingBoxAspectRatioRange(value []float32) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["aspect_ratio_range"] = value
	}
}

// StatelessSampleDistortedBoundingBoxAreaRange sets the optional area_range attribute to value.
//
// value: The cropped area of the image must contain a fraction of the
// supplied image within this range.
// If not specified, defaults to {f:0.05 f:1}
func StatelessSampleDistortedBoundingBoxAreaRange(value []float32) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["area_range"] = value
	}
}

// StatelessSampleDistortedBoundingBoxMaxAttempts sets the optional max_attempts attribute to value.
//
// value: Number of attempts at generating a cropped region of the image
// of the specified constraints. After `max_attempts` failures, return the entire
// image.
// If not specified, defaults to 100
func StatelessSampleDistortedBoundingBoxMaxAttempts(value int64) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["max_attempts"] = value
	}
}

// StatelessSampleDistortedBoundingBoxUseImageIfNoBoundingBoxes sets the optional use_image_if_no_bounding_boxes attribute to value.
//
// value: Controls behavior if no bounding boxes supplied.
// If true, assume an implicit bounding box covering the whole input. If false,
// raise an error.
// If not specified, defaults to false
func StatelessSampleDistortedBoundingBoxUseImageIfNoBoundingBoxes(value bool) StatelessSampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["use_image_if_no_bounding_boxes"] = value
	}
}

// Generate a randomly distorted bounding box for an image deterministically.
//
// Bounding box annotations are often supplied in addition to ground-truth labels
// in image recognition or object localization tasks. A common technique for
// training such a system is to randomly distort an image while preserving its
// content, i.e. *data augmentation*. This Op, given the same `seed`,
// deterministically outputs a randomly distorted localization of an object, i.e.
// bounding box, given an `image_size`, `bounding_boxes` and a series of
// constraints.
//
// The output of this Op is a single bounding box that may be used to crop the
// original image. The output is returned as 3 tensors: `begin`, `size` and
// `bboxes`. The first 2 tensors can be fed directly into `tf.slice` to crop the
// image. The latter may be supplied to `tf.image.draw_bounding_boxes` to visualize
// what the bounding box looks like.
//
// Bounding boxes are supplied and returned as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// the height of the underlying image.
//
// The output of this Op is guaranteed to be the same given the same `seed` and is
// independent of how many times the function is called, and independent of global
// seed settings (e.g. `tf.random.set_seed`).
//
// Example usage:
//
// >>> image = np.array([[[1], [2], [3]], [[4], [5], [6]], [[7], [8], [9]]])
// >>> bbox = tf.constant(
// ...   [0.0, 0.0, 1.0, 1.0], dtype=tf.float32, shape=[1, 1, 4])
// >>> seed = (1, 2)
// >>> # Generate a single distorted bounding box.
// >>> bbox_begin, bbox_size, bbox_draw = (
// ...   tf.image.stateless_sample_distorted_bounding_box(
// ...     tf.shape(image), bounding_boxes=bbox, seed=seed))
// >>> # Employ the bounding box to distort the image.
// >>> tf.slice(image, bbox_begin, bbox_size)
// <tf.Tensor: shape=(2, 2, 1), dtype=int64, numpy=
// array([[[1],
//         [2]],
//        [[4],
//         [5]]])>
// >>> # Draw the bounding box in an image summary.
// >>> colors = np.array([[1.0, 0.0, 0.0], [0.0, 0.0, 1.0]])
// >>> tf.image.draw_bounding_boxes(
// ...   tf.expand_dims(tf.cast(image, tf.float32),0), bbox_draw, colors)
// <tf.Tensor: shape=(1, 3, 3, 1), dtype=float32, numpy=
// array([[[[1.],
//          [1.],
//          [3.]],
//         [[1.],
//          [1.],
//          [6.]],
//         [[7.],
//          [8.],
//          [9.]]]], dtype=float32)>
//
// Note that if no bounding box information is available, setting
// `use_image_if_no_bounding_boxes = true` will assume there is a single implicit
// bounding box covering the whole image. If `use_image_if_no_bounding_boxes` is
// false and no bounding boxes are supplied, an error is raised.
//
// Arguments:
//	image_size: 1-D, containing `[height, width, channels]`.
//	bounding_boxes: 3-D with shape `[batch, N, 4]` describing the N bounding boxes
// associated with the image.
//	min_object_covered: The cropped area of the image must contain at least this
// fraction of any bounding box supplied. The value of this parameter should be
// non-negative. In the case of 0, the cropped area does not need to overlap
// any of the bounding boxes supplied.
//	seed: 1-D with shape `[2]`. The seed to the random number generator. Must have dtype
// `int32` or `int64`. (When using XLA, only `int32` is allowed.)
//
// Returns:
//	begin: 1-D, containing `[offset_height, offset_width, 0]`. Provide as input to
// `tf.slice`.
//	size: 1-D, containing `[target_height, target_width, -1]`. Provide as input to
// `tf.slice`.
//	bboxes: 3-D with shape `[1, 1, 4]` containing the distorted bounding box.
// Provide as input to `tf.image.draw_bounding_boxes`.
func StatelessSampleDistortedBoundingBox(scope *Scope, image_size tf.Output, bounding_boxes tf.Output, min_object_covered tf.Output, seed tf.Output, optional ...StatelessSampleDistortedBoundingBoxAttr) (begin tf.Output, size tf.Output, bboxes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessSampleDistortedBoundingBox",
		Input: []tf.Input{
			image_size, bounding_boxes, min_object_covered, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// SampleDistortedBoundingBoxAttr is an optional argument to SampleDistortedBoundingBox.
type SampleDistortedBoundingBoxAttr func(optionalAttr)

// SampleDistortedBoundingBoxSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to non-zero, the random number
// generator is seeded by the given `seed`.  Otherwise, it is seeded by a random
// seed.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxSeed(value int64) SampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// SampleDistortedBoundingBoxSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxSeed2(value int64) SampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// SampleDistortedBoundingBoxMinObjectCovered sets the optional min_object_covered attribute to value.
//
// value: The cropped area of the image must contain at least this
// fraction of any bounding box supplied. The value of this parameter should be
// non-negative. In the case of 0, the cropped area does not need to overlap
// any of the bounding boxes supplied.
// If not specified, defaults to 0.1
func SampleDistortedBoundingBoxMinObjectCovered(value float32) SampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["min_object_covered"] = value
	}
}

// SampleDistortedBoundingBoxAspectRatioRange sets the optional aspect_ratio_range attribute to value.
//
// value: The cropped area of the image must have an aspect ratio =
// width / height within this range.
// If not specified, defaults to {f:0.75 f:1.33}
func SampleDistortedBoundingBoxAspectRatioRange(value []float32) SampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["aspect_ratio_range"] = value
	}
}

// SampleDistortedBoundingBoxAreaRange sets the optional area_range attribute to value.
//
// value: The cropped area of the image must contain a fraction of the
// supplied image within this range.
// If not specified, defaults to {f:0.05 f:1}
func SampleDistortedBoundingBoxAreaRange(value []float32) SampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["area_range"] = value
	}
}

// SampleDistortedBoundingBoxMaxAttempts sets the optional max_attempts attribute to value.
//
// value: Number of attempts at generating a cropped region of the image
// of the specified constraints. After `max_attempts` failures, return the entire
// image.
// If not specified, defaults to 100
func SampleDistortedBoundingBoxMaxAttempts(value int64) SampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["max_attempts"] = value
	}
}

// SampleDistortedBoundingBoxUseImageIfNoBoundingBoxes sets the optional use_image_if_no_bounding_boxes attribute to value.
//
// value: Controls behavior if no bounding boxes supplied.
// If true, assume an implicit bounding box covering the whole input. If false,
// raise an error.
// If not specified, defaults to false
func SampleDistortedBoundingBoxUseImageIfNoBoundingBoxes(value bool) SampleDistortedBoundingBoxAttr {
	return func(m optionalAttr) {
		m["use_image_if_no_bounding_boxes"] = value
	}
}

// Generate a single randomly distorted bounding box for an image.
//
// Bounding box annotations are often supplied in addition to ground-truth labels
// in image recognition or object localization tasks. A common technique for
// training such a system is to randomly distort an image while preserving
// its content, i.e. *data augmentation*. This Op outputs a randomly distorted
// localization of an object, i.e. bounding box, given an `image_size`,
// `bounding_boxes` and a series of constraints.
//
// The output of this Op is a single bounding box that may be used to crop the
// original image. The output is returned as 3 tensors: `begin`, `size` and
// `bboxes`. The first 2 tensors can be fed directly into `tf.slice` to crop the
// image. The latter may be supplied to `tf.image.draw_bounding_boxes` to visualize
// what the bounding box looks like.
//
// Bounding boxes are supplied and returned as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example,
//
// ```python
//     # Generate a single distorted bounding box.
//     begin, size, bbox_for_draw = tf.image.sample_distorted_bounding_box(
//         tf.shape(image),
//         bounding_boxes=bounding_boxes)
//
//     # Draw the bounding box in an image summary.
//     image_with_box = tf.image.draw_bounding_boxes(tf.expand_dims(image, 0),
//                                                   bbox_for_draw)
//     tf.summary.image('images_with_box', image_with_box)
//
//     # Employ the bounding box to distort the image.
//     distorted_image = tf.slice(image, begin, size)
// ```
//
// Note that if no bounding box information is available, setting
// `use_image_if_no_bounding_boxes = true` will assume there is a single implicit
// bounding box covering the whole image. If `use_image_if_no_bounding_boxes` is
// false and no bounding boxes are supplied, an error is raised.
//
// Arguments:
//	image_size: 1-D, containing `[height, width, channels]`.
//	bounding_boxes: 3-D with shape `[batch, N, 4]` describing the N bounding boxes
// associated with the image.
//
// Returns:
//	begin: 1-D, containing `[offset_height, offset_width, 0]`. Provide as input to
// `tf.slice`.
//	size: 1-D, containing `[target_height, target_width, -1]`. Provide as input to
// `tf.slice`.
//	bboxes: 3-D with shape `[1, 1, 4]` containing the distorted bounding box.
// Provide as input to `tf.image.draw_bounding_boxes`.
func SampleDistortedBoundingBox(scope *Scope, image_size tf.Output, bounding_boxes tf.Output, optional ...SampleDistortedBoundingBoxAttr) (begin tf.Output, size tf.Output, bboxes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SampleDistortedBoundingBox",
		Input: []tf.Input{
			image_size, bounding_boxes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Draw bounding boxes on a batch of images.
//
// Outputs a copy of `images` but draws on top of the pixels zero or more bounding
// boxes specified by the locations in `boxes`. The coordinates of the each
// bounding box in `boxes` are encoded as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example, if an image is 100 x 200 pixels (height x width) and the bounding
// box is `[0.1, 0.2, 0.5, 0.9]`, the upper-left and bottom-right coordinates of
// the bounding box will be `(40, 10)` to `(100, 50)` (in (x,y) coordinates).
//
// Parts of the bounding box may fall outside the image.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, depth]`. A batch of images.
//	boxes: 3-D with shape `[batch, num_bounding_boxes, 4]` containing bounding
// boxes.
//	colors: 2-D. A list of RGBA colors to cycle through for the boxes.
//
// Returns 4-D with the same shape as `images`. The batch of input images with
// bounding boxes drawn on the images.
func DrawBoundingBoxesV2(scope *Scope, images tf.Output, boxes tf.Output, colors tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DrawBoundingBoxesV2",
		Input: []tf.Input{
			images, boxes, colors,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Draw bounding boxes on a batch of images.
//
// Outputs a copy of `images` but draws on top of the pixels zero or more bounding
// boxes specified by the locations in `boxes`. The coordinates of the each
// bounding box in `boxes` are encoded as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example, if an image is 100 x 200 pixels (height x width) and the bounding
// box is `[0.1, 0.2, 0.5, 0.9]`, the upper-left and bottom-right coordinates of
// the bounding box will be `(40, 10)` to `(180, 50)` (in (x,y) coordinates).
//
// Parts of the bounding box may fall outside the image.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, depth]`. A batch of images.
//	boxes: 3-D with shape `[batch, num_bounding_boxes, 4]` containing bounding
// boxes.
//
// Returns 4-D with the same shape as `images`. The batch of input images with
// bounding boxes drawn on the images.
func DrawBoundingBoxes(scope *Scope, images tf.Output, boxes tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DrawBoundingBoxes",
		Input: []tf.Input{
			images, boxes,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Convert one or more images from HSV to RGB.
//
// Outputs a tensor of the same shape as the `images` tensor, containing the RGB
// value of the pixels. The output is only well defined if the value in `images`
// are in `[0,1]`.
//
// See `rgb_to_hsv` for a description of the HSV encoding.
//
// Arguments:
//	images: 1-D or higher rank. HSV data to convert. Last dimension must be size 3.
//
// Returns `images` converted to RGB.
func HSVToRGB(scope *Scope, images tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "HSVToRGB",
		Input: []tf.Input{
			images,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts one or more images from RGB to HSV.
//
// Outputs a tensor of the same shape as the `images` tensor, containing the HSV
// value of the pixels. The output is only well defined if the value in `images`
// are in `[0,1]`.
//
// `output[..., 0]` contains hue, `output[..., 1]` contains saturation, and
// `output[..., 2]` contains value. All HSV values are in `[0,1]`. A hue of 0
// corresponds to pure red, hue 1/3 is pure green, and 2/3 is pure blue.
//
// Usage Example:
//
// >>> blue_image = tf.stack([
// ...    tf.zeros([5,5]),
// ...    tf.zeros([5,5]),
// ...    tf.ones([5,5])],
// ...    axis=-1)
// >>> blue_hsv_image = tf.image.rgb_to_hsv(blue_image)
// >>> blue_hsv_image[0,0].numpy()
// array([0.6666667, 1. , 1. ], dtype=float32)
//
//
// Arguments:
//	images: 1-D or higher rank. RGB data to convert. Last dimension must be size 3.
//
// Returns `images` converted to HSV.
func RGBToHSV(scope *Scope, images tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RGBToHSV",
		Input: []tf.Input{
			images,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Decode the frame(s) of a GIF-encoded image to a uint8 tensor.
//
// GIF images with frame or transparency compression are not supported.
// On Linux and MacOS systems, convert animated GIFs from compressed to
// uncompressed by running:
//
//     convert $src.gif -coalesce $dst.gif
//
// This op also supports decoding JPEGs and PNGs, though it is cleaner to use
// `tf.io.decode_image`.
//
// Arguments:
//	contents: 0-D.  The GIF-encoded image.
//
// Returns 4-D with shape `[num_frames, height, width, 3]`. RGB channel order.
func DecodeGif(scope *Scope, contents tf.Output) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeGif",
		Input: []tf.Input{
			contents,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeBmpAttr is an optional argument to DecodeBmp.
type DecodeBmpAttr func(optionalAttr)

// DecodeBmpChannels sets the optional channels attribute to value.
// If not specified, defaults to 0
func DecodeBmpChannels(value int64) DecodeBmpAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// Decode the first frame of a BMP-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the BMP-encoded image.
// *   3: output an RGB image.
// *   4: output an RGBA image.
//
// Arguments:
//	contents: 0-D.  The BMP-encoded image.
//
// Returns 3-D with shape `[height, width, channels]`. RGB order
func DecodeBmp(scope *Scope, contents tf.Output, optional ...DecodeBmpAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeBmp",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodePngAttr is an optional argument to EncodePng.
type EncodePngAttr func(optionalAttr)

// EncodePngCompression sets the optional compression attribute to value.
//
// value: Compression level.
// If not specified, defaults to -1
func EncodePngCompression(value int64) EncodePngAttr {
	return func(m optionalAttr) {
		m["compression"] = value
	}
}

// PNG-encode an image.
//
// `image` is a 3-D uint8 or uint16 Tensor of shape `[height, width, channels]`
// where `channels` is:
//
// *   1: for grayscale.
// *   2: for grayscale + alpha.
// *   3: for RGB.
// *   4: for RGBA.
//
// The ZLIB compression level, `compression`, can be -1 for the PNG-encoder
// default or a value from 0 to 9.  9 is the highest compression level, generating
// the smallest output, but is slower.
//
// Arguments:
//	image: 3-D with shape `[height, width, channels]`.
//
// Returns 0-D. PNG-encoded image.
func EncodePng(scope *Scope, image tf.Output, optional ...EncodePngAttr) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodePng",
		Input: []tf.Input{
			image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Invert (flip) each bit of supported types; for example, type `uint8` value 01010101 becomes 10101010.
//
// Flip each bit of supported types.  For example, type `int8` (decimal 2) binary 00000010 becomes (decimal -3) binary 11111101.
// This operation is performed on each element of the tensor argument `x`.
//
// Example:
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
//
// # flip 2 (00000010) to -3 (11111101)
// tf.assert_equal(-3, bitwise_ops.invert(2))
//
// dtype_list = [dtypes.int8, dtypes.int16, dtypes.int32, dtypes.int64,
//               dtypes.uint8, dtypes.uint16, dtypes.uint32, dtypes.uint64]
//
// inputs = [0, 5, 3, 14]
// for dtype in dtype_list:
//   # Because of issues with negative numbers, let's test this indirectly.
//   # 1. invert(a) and a = 0
//   # 2. invert(a) or a = invert(0)
//   input_tensor = tf.constant([0, 5, 3, 14], dtype=dtype)
//   not_a_and_a, not_a_or_a, not_0 = [bitwise_ops.bitwise_and(
//                                       input_tensor, bitwise_ops.invert(input_tensor)),
//                                     bitwise_ops.bitwise_or(
//                                       input_tensor, bitwise_ops.invert(input_tensor)),
//                                     bitwise_ops.invert(
//                                       tf.constant(0, dtype=dtype))]
//
//   expected = tf.constant([0, 0, 0, 0], dtype=tf.float32)
//   tf.assert_equal(tf.cast(not_a_and_a, tf.float32), expected)
//
//   expected = tf.cast([not_0] * 4, tf.float32)
//   tf.assert_equal(tf.cast(not_a_or_a, tf.float32), expected)
//
//   # For unsigned dtypes let's also check the result directly.
//   if dtype.is_unsigned:
//     inverted = bitwise_ops.invert(input_tensor)
//     expected = tf.constant([dtype.max - x for x in inputs], dtype=tf.float32)
//     tf.assert_equal(tf.cast(inverted, tf.float32), tf.cast(expected, tf.float32))
// ```
func Invert(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Invert",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodePngAttr is an optional argument to DecodePng.
type DecodePngAttr func(optionalAttr)

// DecodePngChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodePngChannels(value int64) DecodePngAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodePngDtype sets the optional dtype attribute to value.
// If not specified, defaults to DT_UINT8
func DecodePngDtype(value tf.DataType) DecodePngAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Decode a PNG-encoded image to a uint8 or uint16 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the PNG-encoded image.
// *   1: output a grayscale image.
// *   3: output an RGB image.
// *   4: output an RGBA image.
//
// If needed, the PNG-encoded image is transformed to match the requested number
// of color channels.
//
// This op also supports decoding JPEGs and non-animated GIFs since the interface
// is the same, though it is cleaner to use `tf.io.decode_image`.
//
// Arguments:
//	contents: 0-D.  The PNG-encoded image.
//
// Returns 3-D with shape `[height, width, channels]`.
func DecodePng(scope *Scope, contents tf.Output, optional ...DecodePngAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodePng",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adjust the saturation of one or more images.
//
// `images` is a tensor of at least 3 dimensions.  The last dimension is
// interpreted as channels, and must be three.
//
// The input image is considered in the RGB colorspace. Conceptually, the RGB
// colors are first mapped into HSV. A scale is then applied all the saturation
// values, and then remapped back to RGB colorspace.
//
// Arguments:
//	images: Images to adjust.  At least 3-D.
//	scale: A float scale to add to the saturation.
//
// Returns The hue-adjusted image or images.
func AdjustSaturation(scope *Scope, images tf.Output, scale tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustSaturation",
		Input: []tf.Input{
			images, scale,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adjust the contrast of one or more images.
//
// `images` is a tensor of at least 3 dimensions.  The last 3 dimensions are
// interpreted as `[height, width, channels]`.  The other dimensions only
// represent a collection of images, such as `[batch, height, width, channels].`
//
// Contrast is adjusted independently for each channel of each image.
//
// For each channel, the Op first computes the mean of the image pixels in the
// channel and then adjusts each component of each pixel to
// `(x - mean) * contrast_factor + mean`.
//
// Arguments:
//	images: Images to adjust.  At least 3-D.
//	contrast_factor: A float multiplier for adjusting contrast.
//
// Returns The contrast-adjusted image or images.
func AdjustContrastv2(scope *Scope, images tf.Output, contrast_factor tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustContrastv2",
		Input: []tf.Input{
			images, contrast_factor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Initializes the multi device iterator with the given dataset.
//
// Arguments:
//	dataset: Dataset to be iterated upon.
//	multi_device_iterator: A MultiDeviceIteratorResource.
//	max_buffer_size: The maximum size of the host side per device buffer to keep.
//
// Returns An int64 indicating which incarnation of the MultiDeviceIterator
// is running.
func MultiDeviceIteratorInit(scope *Scope, dataset tf.Output, multi_device_iterator tf.Output, max_buffer_size tf.Output) (incarnation_id tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorInit",
		Input: []tf.Input{
			dataset, multi_device_iterator, max_buffer_size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Disallowed in GraphDef version >= 2.
//
// DEPRECATED at GraphDef version 2: Use AdjustContrastv2 instead
func AdjustContrast(scope *Scope, images tf.Output, contrast_factor tf.Output, min_value tf.Output, max_value tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustContrast",
		Input: []tf.Input{
			images, contrast_factor, min_value, max_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractJpegShapeAttr is an optional argument to ExtractJpegShape.
type ExtractJpegShapeAttr func(optionalAttr)

// ExtractJpegShapeOutputType sets the optional output_type attribute to value.
//
// value: (Optional) The output type of the operation (int32 or int64).
// Defaults to int32.
// If not specified, defaults to DT_INT32
func ExtractJpegShapeOutputType(value tf.DataType) ExtractJpegShapeAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Extract the shape information of a JPEG-encoded image.
//
// This op only parses the image header, so it is much faster than DecodeJpeg.
//
// Arguments:
//	contents: 0-D. The JPEG-encoded image.
//
// Returns 1-D. The image shape with format [height, width, channels].
func ExtractJpegShape(scope *Scope, contents tf.Output, optional ...ExtractJpegShapeAttr) (image_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractJpegShape",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// JPEG encode input image with provided compression quality.
//
// `image` is a 3-D uint8 Tensor of shape `[height, width, channels]`.
// `quality` is an int32 jpeg compression quality value between 0 and 100.
//
//
// Arguments:
//	images: Images to adjust.  At least 3-D.
//	quality: An int quality to encode to.
//
// Returns 0-D. JPEG-encoded image.
func EncodeJpegVariableQuality(scope *Scope, images tf.Output, quality tf.Output) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "EncodeJpegVariableQuality",
		Input: []tf.Input{
			images, quality,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the rank of a tensor.
//
// This operation returns an integer representing the rank of `input`.
//
// For example:
//
// ```
// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
// # shape of tensor 't' is [2, 2, 3]
// rank(t) ==> 3
// ```
//
// **Note**: The rank of a tensor is not the same as the rank of a matrix. The rank
// of a tensor is the number of indices required to uniquely select each element
// of the tensor. Rank is also known as "order", "degree", or "ndims."
func Rank(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Rank",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeJpegAttr is an optional argument to EncodeJpeg.
type EncodeJpegAttr func(optionalAttr)

// EncodeJpegFormat sets the optional format attribute to value.
//
// value: Per pixel image format.
// If not specified, defaults to ""
func EncodeJpegFormat(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["format"] = value
	}
}

// EncodeJpegQuality sets the optional quality attribute to value.
//
// value: Quality of the compression from 0 to 100 (higher is better and slower).
// If not specified, defaults to 95
func EncodeJpegQuality(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["quality"] = value
	}
}

// EncodeJpegProgressive sets the optional progressive attribute to value.
//
// value: If True, create a JPEG that loads progressively (coarse to fine).
// If not specified, defaults to false
func EncodeJpegProgressive(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["progressive"] = value
	}
}

// EncodeJpegOptimizeSize sets the optional optimize_size attribute to value.
//
// value: If True, spend CPU/RAM to reduce size with no quality change.
// If not specified, defaults to false
func EncodeJpegOptimizeSize(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["optimize_size"] = value
	}
}

// EncodeJpegChromaDownsampling sets the optional chroma_downsampling attribute to value.
//
// value: See http://en.wikipedia.org/wiki/Chroma_subsampling.
// If not specified, defaults to true
func EncodeJpegChromaDownsampling(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["chroma_downsampling"] = value
	}
}

// EncodeJpegDensityUnit sets the optional density_unit attribute to value.
//
// value: Unit used to specify `x_density` and `y_density`:
// pixels per inch (`'in'`) or centimeter (`'cm'`).
// If not specified, defaults to "in"
func EncodeJpegDensityUnit(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["density_unit"] = value
	}
}

// EncodeJpegXDensity sets the optional x_density attribute to value.
//
// value: Horizontal pixels per density unit.
// If not specified, defaults to 300
func EncodeJpegXDensity(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["x_density"] = value
	}
}

// EncodeJpegYDensity sets the optional y_density attribute to value.
//
// value: Vertical pixels per density unit.
// If not specified, defaults to 300
func EncodeJpegYDensity(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["y_density"] = value
	}
}

// EncodeJpegXmpMetadata sets the optional xmp_metadata attribute to value.
//
// value: If not empty, embed this XMP metadata in the image header.
// If not specified, defaults to ""
func EncodeJpegXmpMetadata(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["xmp_metadata"] = value
	}
}

// JPEG-encode an image.
//
// `image` is a 3-D uint8 Tensor of shape `[height, width, channels]`.
//
// The attr `format` can be used to override the color format of the encoded
// output.  Values can be:
//
// *   `''`: Use a default format based on the number of channels in the image.
// *   `grayscale`: Output a grayscale JPEG image.  The `channels` dimension
//     of `image` must be 1.
// *   `rgb`: Output an RGB JPEG image. The `channels` dimension
//     of `image` must be 3.
//
// If `format` is not specified or is the empty string, a default format is picked
// in function of the number of channels in `image`:
//
// *   1: Output a grayscale image.
// *   3: Output an RGB image.
//
// Arguments:
//	image: 3-D with shape `[height, width, channels]`.
//
// Returns 0-D. JPEG-encoded image.
func EncodeJpeg(scope *Scope, image tf.Output, optional ...EncodeJpegAttr) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeJpeg",
		Input: []tf.Input{
			image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeAndCropJpegAttr is an optional argument to DecodeAndCropJpeg.
type DecodeAndCropJpegAttr func(optionalAttr)

// DecodeAndCropJpegChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeAndCropJpegChannels(value int64) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeAndCropJpegRatio sets the optional ratio attribute to value.
//
// value: Downscaling ratio.
// If not specified, defaults to 1
func DecodeAndCropJpegRatio(value int64) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["ratio"] = value
	}
}

// DecodeAndCropJpegFancyUpscaling sets the optional fancy_upscaling attribute to value.
//
// value: If true use a slower but nicer upscaling of the
// chroma planes (yuv420/422 only).
// If not specified, defaults to true
func DecodeAndCropJpegFancyUpscaling(value bool) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["fancy_upscaling"] = value
	}
}

// DecodeAndCropJpegTryRecoverTruncated sets the optional try_recover_truncated attribute to value.
//
// value: If true try to recover an image from truncated input.
// If not specified, defaults to false
func DecodeAndCropJpegTryRecoverTruncated(value bool) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["try_recover_truncated"] = value
	}
}

// DecodeAndCropJpegAcceptableFraction sets the optional acceptable_fraction attribute to value.
//
// value: The minimum required fraction of lines before a truncated
// input is accepted.
// If not specified, defaults to 1
func DecodeAndCropJpegAcceptableFraction(value float32) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["acceptable_fraction"] = value
	}
}

// DecodeAndCropJpegDctMethod sets the optional dct_method attribute to value.
//
// value: string specifying a hint about the algorithm used for
// decompression.  Defaults to "" which maps to a system-specific
// default.  Currently valid values are ["INTEGER_FAST",
// "INTEGER_ACCURATE"].  The hint may be ignored (e.g., the internal
// jpeg library changes to a version that does not have that specific
// option.)
// If not specified, defaults to ""
func DecodeAndCropJpegDctMethod(value string) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["dct_method"] = value
	}
}

// Decode and Crop a JPEG-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the JPEG-encoded image.
// *   1: output a grayscale image.
// *   3: output an RGB image.
//
// If needed, the JPEG-encoded image is transformed to match the requested number
// of color channels.
//
// The attr `ratio` allows downscaling the image by an integer factor during
// decoding.  Allowed values are: 1, 2, 4, and 8.  This is much faster than
// downscaling the image later.
//
//
// It is equivalent to a combination of decode and crop, but much faster by only
// decoding partial jpeg image.
//
// Arguments:
//	contents: 0-D.  The JPEG-encoded image.
//	crop_window: 1-D.  The crop window: [crop_y, crop_x, crop_height, crop_width].
//
// Returns 3-D with shape `[height, width, channels]`..
func DecodeAndCropJpeg(scope *Scope, contents tf.Output, crop_window tf.Output, optional ...DecodeAndCropJpegAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeAndCropJpeg",
		Input: []tf.Input{
			contents, crop_window,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomCropAttr is an optional argument to RandomCrop.
type RandomCropAttr func(optionalAttr)

// RandomCropSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomCropSeed(value int64) RandomCropAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomCropSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomCropSeed2(value int64) RandomCropAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Randomly crop `image`.
//
// DEPRECATED at GraphDef version 8: Random crop is now pure Python
//
// `size` is a 1-D int64 tensor with 2 elements representing the crop height and
// width.  The values must be non negative.
//
// This Op picks a random location in `image` and crops a `height` by `width`
// rectangle from that location.  The random location is picked so the cropped
// area will fit inside the original image.
//
// Arguments:
//	image: 3-D of shape `[height, width, channels]`.
//	size: 1-D of length 2 containing: `crop_height`, `crop_width`..
//
// Returns 3-D of shape `[crop_height, crop_width, channels].`
func RandomCrop(scope *Scope, image tf.Output, size tf.Output, optional ...RandomCropAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomCrop",
		Input: []tf.Input{
			image, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeNearestNeighborGradAttr is an optional argument to ResizeNearestNeighborGrad.
type ResizeNearestNeighborGradAttr func(optionalAttr)

// ResizeNearestNeighborGradAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and grad tensors are
// aligned. Defaults to false.
// If not specified, defaults to false
func ResizeNearestNeighborGradAlignCorners(value bool) ResizeNearestNeighborGradAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeNearestNeighborGradHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeNearestNeighborGradHalfPixelCenters(value bool) ResizeNearestNeighborGradAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Computes the gradient of nearest neighbor interpolation.
//
// Arguments:
//	grads: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `orig_height, orig_width`. The
// original input size.
//
// Returns 4-D with shape `[batch, orig_height, orig_width, channels]`. Gradients
// with respect to the input image.
func ResizeNearestNeighborGrad(scope *Scope, grads tf.Output, size tf.Output, optional ...ResizeNearestNeighborGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeNearestNeighborGrad",
		Input: []tf.Input{
			grads, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Runs multiple additive regression ensemble predictors on input instances and
//
// computes the logits. It is designed to be used during prediction.
// It traverses all the trees and calculates the final score for each instance.
//
// Arguments:
//
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
// feature.
//	logits_dimension: scalar, dimension of the logits, to be used for partial logits
// shape.
//
// Returns Output rank 2 Tensor containing logits for each example.
func BoostedTreesPredict(scope *Scope, tree_ensemble_handle tf.Output, bucketized_features []tf.Output, logits_dimension int64) (logits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesPredict",
		Input: []tf.Input{
			tree_ensemble_handle, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeBilinearAttr is an optional argument to ResizeBilinear.
type ResizeBilinearAttr func(optionalAttr)

// ResizeBilinearAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func ResizeBilinearAlignCorners(value bool) ResizeBilinearAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeBilinearHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeBilinearHalfPixelCenters(value bool) ResizeBilinearAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Resize `images` to `size` using bilinear interpolation.
//
// Input images can be of different types but output images are always float.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ResizeBilinear(scope *Scope, images tf.Output, size tf.Output, optional ...ResizeBilinearAttr) (resized_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeBilinear",
		Input: []tf.Input{
			images, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the set of files matching one or more glob patterns.
//
// Note that this routine only supports wildcard characters in the
// basename portion of the pattern, not in the directory portion.
// Note also that the order of filenames returned is deterministic.
//
// Arguments:
//	pattern: Shell wildcard pattern(s). Scalar or vector of type string.
//
// Returns A vector of matching filenames.
func MatchingFiles(scope *Scope, pattern tf.Output) (filenames tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatchingFiles",
		Input: []tf.Input{
			pattern,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Restore a Reader to its initial clean state.
//
// Arguments:
//	reader_handle: Handle to a Reader.
//
// Returns the created operation.
func ReaderResetV2(scope *Scope, reader_handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderResetV2",
		Input: []tf.Input{
			reader_handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Restore a reader to a previously saved state.
//
// Not all Readers support being restored, so this can produce an
// Unimplemented error.
//
// Arguments:
//	reader_handle: Handle to a Reader.
//	state: Result of a ReaderSerializeState of a Reader with type
// matching reader_handle.
//
// Returns the created operation.
func ReaderRestoreStateV2(scope *Scope, reader_handle tf.Output, state tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderRestoreStateV2",
		Input: []tf.Input{
			reader_handle, state,
		},
	}
	return scope.AddOperation(opspec)
}

// ResizeAreaAttr is an optional argument to ResizeArea.
type ResizeAreaAttr func(optionalAttr)

// ResizeAreaAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func ResizeAreaAlignCorners(value bool) ResizeAreaAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// Resize `images` to `size` using area interpolation.
//
// Input images can be of different types but output images are always float.
//
// The range of pixel values for the output image might be slightly different
// from the range for the input image because of limited numerical precision.
// To guarantee an output range, for example `[0.0, 1.0]`, apply
// `tf.clip_by_value` to the output.
//
// Each output pixel is computed by first transforming the pixel's footprint into
// the input tensor and then averaging the pixels that intersect the footprint. An
// input pixel's contribution to the average is weighted by the fraction of its
// area that intersects the footprint.  This is the same as OpenCV's INTER_AREA.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ResizeArea(scope *Scope, images tf.Output, size tf.Output, optional ...ResizeAreaAttr) (resized_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeArea",
		Input: []tf.Input{
			images, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the number of work units this Reader has finished processing.
//
// Arguments:
//	reader_handle: Handle to a Reader.
func ReaderNumWorkUnitsCompletedV2(scope *Scope, reader_handle tf.Output) (units_completed tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderNumWorkUnitsCompletedV2",
		Input: []tf.Input{
			reader_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns up to `num_records` (key, value) pairs produced by a Reader.
//
// Will dequeue from the input queue if necessary (e.g. when the
// Reader needs to start reading from a new file since it has finished
// with the previous file).
// It may return less than `num_records` even before the last batch.
//
// Arguments:
//	reader_handle: Handle to a `Reader`.
//	queue_handle: Handle to a `Queue`, with string work items.
//	num_records: number of records to read from `Reader`.
//
// Returns:
//	keys: A 1-D tensor.
//	values: A 1-D tensor.
func ReaderReadUpToV2(scope *Scope, reader_handle tf.Output, queue_handle tf.Output, num_records tf.Output) (keys tf.Output, values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderReadUpToV2",
		Input: []tf.Input{
			reader_handle, queue_handle, num_records,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// QueueDequeueV2Attr is an optional argument to QueueDequeueV2.
type QueueDequeueV2Attr func(optionalAttr)

// QueueDequeueV2TimeoutMs sets the optional timeout_ms attribute to value.
//
// value: If the queue is empty, this operation will block for up to
// timeout_ms milliseconds.
// Note: This option is not supported yet.
// If not specified, defaults to -1
func QueueDequeueV2TimeoutMs(value int64) QueueDequeueV2Attr {
	return func(m optionalAttr) {
		m["timeout_ms"] = value
	}
}

// Dequeues a tuple of one or more tensors from the given queue.
//
// This operation has k outputs, where k is the number of components
// in the tuples stored in the given queue, and output i is the ith
// component of the dequeued tuple.
//
// N.B. If the queue is empty, this operation will block until an element
// has been dequeued (or 'timeout_ms' elapses, if specified).
//
// Arguments:
//	handle: The handle to a queue.
//	component_types: The type of each component in a tuple.
//
// Returns One or more tensors that were dequeued as a tuple.
func QueueDequeueV2(scope *Scope, handle tf.Output, component_types []tf.DataType, optional ...QueueDequeueV2Attr) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueDequeueV2",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("QueueDequeueV2", err)
		return
	}
	return components
}

// Returns the next record (key, value pair) produced by a Reader.
//
// Will dequeue from the input queue if necessary (e.g. when the
// Reader needs to start reading from a new file since it has finished
// with the previous file).
//
// Arguments:
//	reader_handle: Handle to a Reader.
//	queue_handle: Handle to a Queue, with string work items.
//
// Returns:
//	key: A scalar.
//	value: A scalar.
func ReaderReadV2(scope *Scope, reader_handle tf.Output, queue_handle tf.Output) (key tf.Output, value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderReadV2",
		Input: []tf.Input{
			reader_handle, queue_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Return a slice from 'input'.
//
// The output tensor is a tensor with dimensions described by 'size'
// whose values are extracted from 'input' starting at the offsets in
// 'begin'.
//
// *Requirements*:
//   0 <= begin[i] <= begin[i] + size[i] <= Di  for i in [0, n)
//
// Arguments:
//
//	begin: begin[i] specifies the offset into the 'i'th dimension of
// 'input' to slice from.
//	size: size[i] specifies the number of elements of the 'i'th dimension
// of 'input' to slice. If size[i] is -1, all remaining elements in dimension
// i are included in the slice (i.e. this is equivalent to setting
// size[i] = input.dim_size(i) - begin[i]).
func Slice(scope *Scope, input tf.Output, begin tf.Output, size tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Slice",
		Input: []tf.Input{
			input, begin, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TFRecordReaderV2Attr is an optional argument to TFRecordReaderV2.
type TFRecordReaderV2Attr func(optionalAttr)

// TFRecordReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func TFRecordReaderV2Container(value string) TFRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// TFRecordReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func TFRecordReaderV2SharedName(value string) TFRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// TFRecordReaderV2CompressionType sets the optional compression_type attribute to value.
// If not specified, defaults to ""
func TFRecordReaderV2CompressionType(value string) TFRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["compression_type"] = value
	}
}

// A Reader that outputs the records from a TensorFlow Records file.
//
// Returns The handle to reference the Reader.
func TFRecordReaderV2(scope *Scope, optional ...TFRecordReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TFRecordReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseExampleDatasetAttr is an optional argument to ParseExampleDataset.
type ParseExampleDatasetAttr func(optionalAttr)

// ParseExampleDatasetSloppy sets the optional sloppy attribute to value.
// If not specified, defaults to false
func ParseExampleDatasetSloppy(value bool) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["sloppy"] = value
	}
}

// ParseExampleDatasetRaggedKeys sets the optional ragged_keys attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetRaggedKeys(value []string) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["ragged_keys"] = value
	}
}

// ParseExampleDatasetRaggedValueTypes sets the optional ragged_value_types attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetRaggedValueTypes(value []tf.DataType) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["ragged_value_types"] = value
	}
}

// ParseExampleDatasetRaggedSplitTypes sets the optional ragged_split_types attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseExampleDatasetRaggedSplitTypes(value []tf.DataType) ParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["ragged_split_types"] = value
	}
}

// Transforms `input_dataset` containing `Example` protos as vectors of DT_STRING into a dataset of `Tensor` or `SparseTensor` objects representing the parsed features.
//
// Arguments:
//
//
//	dense_defaults: A dict mapping string keys to `Tensor`s.
// The keys of the dict must match the dense_keys of the feature.
//	sparse_keys: A list of string keys in the examples features.
// The results for these keys will be returned as `SparseTensor` objects.
//	dense_keys: A list of Ndense string Tensors (scalars).
// The keys expected in the Examples features associated with dense values.
//	sparse_types: A list of `DTypes` of the same length as `sparse_keys`.
// Only `tf.float32` (`FloatList`), `tf.int64` (`Int64List`),
// and `tf.string` (`BytesList`) are supported.
//	dense_shapes: List of tuples with the same length as `dense_keys`.
// The shape of the data for each dense feature referenced by `dense_keys`.
// Required for any input tensors identified by `dense_keys`.  Must be
// either fully defined, or may contain an unknown first dimension.
// An unknown first dimension means the feature is treated as having
// a variable number of blocks, and the output shape along this dimension
// is considered unknown at graph build time.  Padding is applied for
// minibatch elements smaller than the maximum number of blocks for the
// given feature along this dimension.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
func ParseExampleDataset(scope *Scope, input_dataset tf.Output, num_parallel_calls tf.Output, dense_defaults []tf.Output, sparse_keys []string, dense_keys []string, sparse_types []tf.DataType, dense_shapes []tf.Shape, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ParseExampleDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_keys": sparse_keys, "dense_keys": dense_keys, "sparse_types": sparse_types, "dense_shapes": dense_shapes, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseExampleDataset",
		Input: []tf.Input{
			input_dataset, num_parallel_calls, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IdentityReaderV2Attr is an optional argument to IdentityReaderV2.
type IdentityReaderV2Attr func(optionalAttr)

// IdentityReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func IdentityReaderV2Container(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// IdentityReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func IdentityReaderV2SharedName(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A Reader that outputs the queued work as both the key and value.
//
// To use, enqueue strings in a Queue.  ReaderRead will take the front
// work string and output (work, work).
//
// Returns The handle to reference the Reader.
func IdentityReaderV2(scope *Scope, optional ...IdentityReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IdentityReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FixedLengthRecordReaderV2Attr is an optional argument to FixedLengthRecordReaderV2.
type FixedLengthRecordReaderV2Attr func(optionalAttr)

// FixedLengthRecordReaderV2HeaderBytes sets the optional header_bytes attribute to value.
//
// value: Number of bytes in the header, defaults to 0.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2HeaderBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["header_bytes"] = value
	}
}

// FixedLengthRecordReaderV2FooterBytes sets the optional footer_bytes attribute to value.
//
// value: Number of bytes in the footer, defaults to 0.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2FooterBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["footer_bytes"] = value
	}
}

// FixedLengthRecordReaderV2HopBytes sets the optional hop_bytes attribute to value.
//
// value: Number of bytes to hop before each read. Default of 0 means using
// record_bytes.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2HopBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["hop_bytes"] = value
	}
}

// FixedLengthRecordReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2Container(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// FixedLengthRecordReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2SharedName(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// FixedLengthRecordReaderV2Encoding sets the optional encoding attribute to value.
//
// value: The type of encoding for the file. Currently ZLIB and GZIP
// are supported. Defaults to none.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2Encoding(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["encoding"] = value
	}
}

// A Reader that outputs fixed-length records from a file.
//
// Arguments:
//	record_bytes: Number of bytes in the record.
//
// Returns The handle to reference the Reader.
func FixedLengthRecordReaderV2(scope *Scope, record_bytes int64, optional ...FixedLengthRecordReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"record_bytes": record_bytes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FixedLengthRecordReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalRebatchDatasetAttr is an optional argument to ExperimentalRebatchDataset.
type ExperimentalRebatchDatasetAttr func(optionalAttr)

// ExperimentalRebatchDatasetUseFallback sets the optional use_fallback attribute to value.
// If not specified, defaults to true
func ExperimentalRebatchDatasetUseFallback(value bool) ExperimentalRebatchDatasetAttr {
	return func(m optionalAttr) {
		m["use_fallback"] = value
	}
}

// Creates a dataset that changes the batch size.
//
// Creates a dataset that changes the batch size of the dataset to current batch
// size // num_replicas.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	num_replicas: A scalar representing the number of replicas to distribute this batch across. As
// a result of this transformation the current batch size would end up being
// divided  by this parameter.
//
//
func ExperimentalRebatchDataset(scope *Scope, input_dataset tf.Output, num_replicas tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalRebatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalRebatchDataset",
		Input: []tf.Input{
			input_dataset, num_replicas,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TextLineReaderV2Attr is an optional argument to TextLineReaderV2.
type TextLineReaderV2Attr func(optionalAttr)

// TextLineReaderV2SkipHeaderLines sets the optional skip_header_lines attribute to value.
//
// value: Number of lines to skip from the beginning of every file.
// If not specified, defaults to 0
func TextLineReaderV2SkipHeaderLines(value int64) TextLineReaderV2Attr {
	return func(m optionalAttr) {
		m["skip_header_lines"] = value
	}
}

// TextLineReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func TextLineReaderV2Container(value string) TextLineReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// TextLineReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func TextLineReaderV2SharedName(value string) TextLineReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A Reader that outputs the lines of a file delimited by '\n'.
//
// Returns The handle to reference the Reader.
func TextLineReaderV2(scope *Scope, optional ...TextLineReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TextLineReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BoostedTreesQuantileStreamResourceFlushAttr is an optional argument to BoostedTreesQuantileStreamResourceFlush.
type BoostedTreesQuantileStreamResourceFlushAttr func(optionalAttr)

// BoostedTreesQuantileStreamResourceFlushGenerateQuantiles sets the optional generate_quantiles attribute to value.
//
// value: bool; If True, the output will be the num_quantiles for each stream where the ith
// entry is the ith quantile of the input with an approximation error of epsilon.
// Duplicate values may be present.
// If False, the output will be the points in the histogram that we got which roughly
// translates to 1/epsilon boundaries and without any duplicates.
// Default to False.
// If not specified, defaults to false
func BoostedTreesQuantileStreamResourceFlushGenerateQuantiles(value bool) BoostedTreesQuantileStreamResourceFlushAttr {
	return func(m optionalAttr) {
		m["generate_quantiles"] = value
	}
}

// Flush the summaries for a quantile stream resource.
//
// An op that flushes the summaries for a quantile stream resource.
//
// Arguments:
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	num_buckets: int; approximate number of buckets unless using generate_quantiles.
//
// Returns the created operation.
func BoostedTreesQuantileStreamResourceFlush(scope *Scope, quantile_stream_resource_handle tf.Output, num_buckets tf.Output, optional ...BoostedTreesQuantileStreamResourceFlushAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceFlush",
		Input: []tf.Input{
			quantile_stream_resource_handle, num_buckets,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// WholeFileReaderV2Attr is an optional argument to WholeFileReaderV2.
type WholeFileReaderV2Attr func(optionalAttr)

// WholeFileReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func WholeFileReaderV2Container(value string) WholeFileReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// WholeFileReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func WholeFileReaderV2SharedName(value string) WholeFileReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A Reader that outputs the entire contents of a file as a value.
//
// To use, enqueue filenames in a Queue.  The output of ReaderRead will
// be a filename (key) and the contents of that file (value).
//
// Returns The handle to reference the Reader.
func WholeFileReaderV2(scope *Scope, optional ...WholeFileReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "WholeFileReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// XlaRngBitGeneratorAttr is an optional argument to XlaRngBitGenerator.
type XlaRngBitGeneratorAttr func(optionalAttr)

// XlaRngBitGeneratorDtype sets the optional dtype attribute to value.
//
// value: The type of the tensor.
// If not specified, defaults to DT_UINT64
func XlaRngBitGeneratorDtype(value tf.DataType) XlaRngBitGeneratorAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Stateless PRNG bit generator.
//
// Wraps the XLA RngBitGenerator operator, documented at
//  https://www.tensorflow.org/performance/xla/operation_semantics#rngbitgenerator.
//
// Arguments:
//	algorithm: The PRNG algorithm to use, one of
// tf.random.Algorithm.{PHILOX, THREEFRY, AUTO_SELECT}.
//	initial_state: Initial state for the PRNG algorithm. For THREEFRY, it should be
// a u64[2] and for PHILOX a u64[3].
//	shape: The output shape of the generated data.
func XlaRngBitGenerator(scope *Scope, algorithm tf.Output, initial_state tf.Output, shape tf.Output, optional ...XlaRngBitGeneratorAttr) (output_key tf.Output, output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "XlaRngBitGenerator",
		Input: []tf.Input{
			algorithm, initial_state, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Generate a glob pattern matching all sharded file names.
func ShardedFilespec(scope *Scope, basename tf.Output, num_shards tf.Output) (filename tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ShardedFilespec",
		Input: []tf.Input{
			basename, num_shards,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generate a sharded filename. The filename is printf formatted as
//
//    %s-%05d-of-%05d, basename, shard, num_shards.
func ShardedFilename(scope *Scope, basename tf.Output, shard tf.Output, num_shards tf.Output) (filename tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ShardedFilename",
		Input: []tf.Input{
			basename, shard, num_shards,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RestoreSliceAttr is an optional argument to RestoreSlice.
type RestoreSliceAttr func(optionalAttr)

// RestoreSlicePreferredShard sets the optional preferred_shard attribute to value.
//
// value: Index of file to open first if multiple files match
// `file_pattern`. See the documentation for `Restore`.
// If not specified, defaults to -1
func RestoreSlicePreferredShard(value int64) RestoreSliceAttr {
	return func(m optionalAttr) {
		m["preferred_shard"] = value
	}
}

// Restores a tensor from checkpoint files.
//
// This is like `Restore` except that restored tensor can be listed as filling
// only a slice of a larger tensor.  `shape_and_slice` specifies the shape of the
// larger tensor and the slice that the restored tensor covers.
//
// The `shape_and_slice` input has the same format as the
// elements of the `shapes_and_slices` input of the `SaveSlices` op.
//
// Arguments:
//	file_pattern: Must have a single element. The pattern of the files from
// which we read the tensor.
//	tensor_name: Must have a single element. The name of the tensor to be
// restored.
//	shape_and_slice: Scalar. The shapes and slice specifications to use when
// restoring a tensors.
//	dt: The type of the tensor to be restored.
//
// Returns The restored tensor.
func RestoreSlice(scope *Scope, file_pattern tf.Output, tensor_name tf.Output, shape_and_slice tf.Output, dt tf.DataType, optional ...RestoreSliceAttr) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dt": dt}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RestoreSlice",
		Input: []tf.Input{
			file_pattern, tensor_name, shape_and_slice,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RestoreAttr is an optional argument to Restore.
type RestoreAttr func(optionalAttr)

// RestorePreferredShard sets the optional preferred_shard attribute to value.
//
// value: Index of file to open first if multiple files match
// `file_pattern`.
// If not specified, defaults to -1
func RestorePreferredShard(value int64) RestoreAttr {
	return func(m optionalAttr) {
		m["preferred_shard"] = value
	}
}

// Restores a tensor from checkpoint files.
//
// Reads a tensor stored in one or several files. If there are several files (for
// instance because a tensor was saved as slices), `file_pattern` may contain
// wildcard symbols (`*` and `?`) in the filename portion only, not in the
// directory portion.
//
// If a `file_pattern` matches several files, `preferred_shard` can be used to hint
// in which file the requested tensor is likely to be found. This op will first
// open the file at index `preferred_shard` in the list of matching files and try
// to restore tensors from that file.  Only if some tensors or tensor slices are
// not found in that first file, then the Op opens all the files. Setting
// `preferred_shard` to match the value passed as the `shard` input
// of a matching `Save` Op may speed up Restore.  This attribute only affects
// performance, not correctness.  The default value -1 means files are processed in
// order.
//
// See also `RestoreSlice`.
//
// Arguments:
//	file_pattern: Must have a single element. The pattern of the files from
// which we read the tensor.
//	tensor_name: Must have a single element. The name of the tensor to be
// restored.
//	dt: The type of the tensor to be restored.
//
// Returns The restored tensor.
func Restore(scope *Scope, file_pattern tf.Output, tensor_name tf.Output, dt tf.DataType, optional ...RestoreAttr) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dt": dt}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Restore",
		Input: []tf.Input{
			file_pattern, tensor_name,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Saves input tensors slices to disk.
//
// This is like `Save` except that tensors can be listed in the saved file as being
// a slice of a larger tensor.  `shapes_and_slices` specifies the shape of the
// larger tensor and the slice that this tensor covers. `shapes_and_slices` must
// have as many elements as `tensor_names`.
//
// Elements of the `shapes_and_slices` input must either be:
//
// *  The empty string, in which case the corresponding tensor is
//    saved normally.
// *  A string of the form `dim0 dim1 ... dimN-1 slice-spec` where the
//    `dimI` are the dimensions of the larger tensor and `slice-spec`
//    specifies what part is covered by the tensor to save.
//
// `slice-spec` itself is a `:`-separated list: `slice0:slice1:...:sliceN-1`
// where each `sliceI` is either:
//
// *  The string `-` meaning that the slice covers all indices of this dimension
// *  `start,length` where `start` and `length` are integers.  In that
//    case the slice covers `length` indices starting at `start`.
//
// See also `Save`.
//
// Arguments:
//	filename: Must have a single element. The name of the file to which we write the
// tensor.
//	tensor_names: Shape `[N]`. The names of the tensors to be saved.
//	shapes_and_slices: Shape `[N]`.  The shapes and slice specifications to use when
// saving the tensors.
//	data: `N` tensors to save.
//
// Returns the created operation.
func SaveSlices(scope *Scope, filename tf.Output, tensor_names tf.Output, shapes_and_slices tf.Output, data []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SaveSlices",
		Input: []tf.Input{
			filename, tensor_names, shapes_and_slices, tf.OutputList(data),
		},
	}
	return scope.AddOperation(opspec)
}

// Saves the input tensors to disk.
//
// The size of `tensor_names` must match the number of tensors in `data`. `data[i]`
// is written to `filename` with name `tensor_names[i]`.
//
// See also `SaveSlices`.
//
// Arguments:
//	filename: Must have a single element. The name of the file to which we write
// the tensor.
//	tensor_names: Shape `[N]`. The names of the tensors to be saved.
//	data: `N` tensors to save.
//
// Returns the created operation.
func Save(scope *Scope, filename tf.Output, tensor_names tf.Output, data []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Save",
		Input: []tf.Input{
			filename, tensor_names, tf.OutputList(data),
		},
	}
	return scope.AddOperation(opspec)
}

// MergeV2CheckpointsAttr is an optional argument to MergeV2Checkpoints.
type MergeV2CheckpointsAttr func(optionalAttr)

// MergeV2CheckpointsDeleteOldDirs sets the optional delete_old_dirs attribute to value.
//
// value: see above.
// If not specified, defaults to true
func MergeV2CheckpointsDeleteOldDirs(value bool) MergeV2CheckpointsAttr {
	return func(m optionalAttr) {
		m["delete_old_dirs"] = value
	}
}

// V2 format specific: merges the metadata files of sharded checkpoints.  The
//
// result is one logical checkpoint, with one physical metadata file and renamed
// data files.
//
// Intended for "grouping" multiple checkpoints in a sharded checkpoint setup.
//
// If delete_old_dirs is true, attempts to delete recursively the dirname of each
// path in the input checkpoint_prefixes.  This is useful when those paths are non
// user-facing temporary locations.
//
// Arguments:
//	checkpoint_prefixes: prefixes of V2 checkpoints to merge.
//	destination_prefix: scalar.  The desired final prefix.  Allowed to be the same
// as one of the checkpoint_prefixes.
//
// Returns the created operation.
func MergeV2Checkpoints(scope *Scope, checkpoint_prefixes tf.Output, destination_prefix tf.Output, optional ...MergeV2CheckpointsAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MergeV2Checkpoints",
		Input: []tf.Input{
			checkpoint_prefixes, destination_prefix,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// DatasetToGraphV2Attr is an optional argument to DatasetToGraphV2.
type DatasetToGraphV2Attr func(optionalAttr)

// DatasetToGraphV2ExternalStatePolicy sets the optional external_state_policy attribute to value.
// If not specified, defaults to 0
func DatasetToGraphV2ExternalStatePolicy(value int64) DatasetToGraphV2Attr {
	return func(m optionalAttr) {
		m["external_state_policy"] = value
	}
}

// DatasetToGraphV2StripDeviceAssignment sets the optional strip_device_assignment attribute to value.
// If not specified, defaults to false
func DatasetToGraphV2StripDeviceAssignment(value bool) DatasetToGraphV2Attr {
	return func(m optionalAttr) {
		m["strip_device_assignment"] = value
	}
}

// Returns a serialized GraphDef representing `input_dataset`.
//
// Returns a graph representation for `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return the graph representation for.
//
// Returns The graph representation of the dataset (as serialized GraphDef).
func DatasetToGraphV2(scope *Scope, input_dataset tf.Output, optional ...DatasetToGraphV2Attr) (graph tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToGraphV2",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Restores tensors from a V2 checkpoint.
//
// For backward compatibility with the V1 format, this Op currently allows
// restoring from a V1 checkpoint as well:
//   - This Op first attempts to find the V2 index file pointed to by "prefix", and
//     if found proceed to read it as a V2 checkpoint;
//   - Otherwise the V1 read path is invoked.
// Relying on this behavior is not recommended, as the ability to fall back to read
// V1 might be deprecated and eventually removed.
//
// By default, restores the named tensors in full.  If the caller wishes to restore
// specific slices of stored tensors, "shape_and_slices" should be non-empty
// strings and correspondingly well-formed.
//
// Callers must ensure all the named tensors are indeed stored in the checkpoint.
//
// Arguments:
//	prefix: Must have a single element.  The prefix of a V2 checkpoint.
//	tensor_names: shape {N}.  The names of the tensors to be restored.
//	shape_and_slices: shape {N}.  The slice specs of the tensors to be restored.
// Empty strings indicate that they are non-partitioned tensors.
//	dtypes: shape {N}.  The list of expected dtype for the tensors.  Must match
// those stored in the checkpoint.
//
// Returns shape {N}.  The restored tensors, whose shapes are read from the
// checkpoint directly.
func RestoreV2(scope *Scope, prefix tf.Output, tensor_names tf.Output, shape_and_slices tf.Output, dtypes []tf.DataType) (tensors []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	opspec := tf.OpSpec{
		Type: "RestoreV2",
		Input: []tf.Input{
			prefix, tensor_names, shape_and_slices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if tensors, idx, err = makeOutputList(op, idx, "tensors"); err != nil {
		scope.UpdateErr("RestoreV2", err)
		return
	}
	return tensors
}

// Delete the TensorArray from its resource container.
//
// This enables the user to close and release the resource in the middle
// of a step/run.
//
// Arguments:
//	handle: The handle to a TensorArray (output of TensorArray or TensorArrayGrad).
//
// Returns the created operation.
func TensorArrayCloseV3(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayCloseV3",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Saves tensors in V2 checkpoint format.
//
// By default, saves the named tensors in full.  If the caller wishes to save
// specific slices of full tensors, "shape_and_slices" should be non-empty strings
// and correspondingly well-formed.
//
// Arguments:
//	prefix: Must have a single element. The prefix of the V2 checkpoint to which we
// write the tensors.
//	tensor_names: shape {N}. The names of the tensors to be saved.
//	shape_and_slices: shape {N}.  The slice specs of the tensors to be saved.
// Empty strings indicate that they are non-partitioned tensors.
//	tensors: `N` tensors to save.
//
// Returns the created operation.
func SaveV2(scope *Scope, prefix tf.Output, tensor_names tf.Output, shape_and_slices tf.Output, tensors []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SaveV2",
		Input: []tf.Input{
			prefix, tensor_names, shape_and_slices, tf.OutputList(tensors),
		},
	}
	return scope.AddOperation(opspec)
}

// SparseCountSparseOutputAttr is an optional argument to SparseCountSparseOutput.
type SparseCountSparseOutputAttr func(optionalAttr)

// SparseCountSparseOutputMinlength sets the optional minlength attribute to value.
//
// value: Minimum value to count. Can be set to -1 for no minimum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func SparseCountSparseOutputMinlength(value int64) SparseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["minlength"] = value
	}
}

// SparseCountSparseOutputMaxlength sets the optional maxlength attribute to value.
//
// value: Maximum value to count. Can be set to -1 for no maximum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func SparseCountSparseOutputMaxlength(value int64) SparseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["maxlength"] = value
	}
}

// Performs sparse-output bin counting for a sparse tensor input.
//
//   Counts the number of times each value occurs in the input.
//
// Arguments:
//	indices: Tensor containing the indices of the sparse tensor to count.
//	values: Tensor containing values of the sparse tensor to count.
//	dense_shape: Tensor containing the dense shape of the sparse tensor to count.
//	weights: A Tensor of the same shape as indices containing per-index weight values.
// May also be the empty tensor if no weights are used.
//	binary_output: Whether to output the number of occurrences of each value or 1.
//
// Returns:
//	output_indices: Indices tensor for the resulting sparse tensor object.
//	output_values: Values tensor for the resulting sparse tensor object.
//	output_dense_shape: Shape tensor for the resulting sparse tensor object.
func SparseCountSparseOutput(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output, weights tf.Output, binary_output bool, optional ...SparseCountSparseOutputAttr) (output_indices tf.Output, output_values tf.Output, output_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"binary_output": binary_output}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseCountSparseOutput",
		Input: []tf.Input{
			indices, values, dense_shape, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DebugNumericSummaryV2Attr is an optional argument to DebugNumericSummaryV2.
type DebugNumericSummaryV2Attr func(optionalAttr)

// DebugNumericSummaryV2OutputDtype sets the optional output_dtype attribute to value.
//
// value: Optional. The type of the output. Can be float32 or float64 (default: float32).
// If not specified, defaults to DT_FLOAT
func DebugNumericSummaryV2OutputDtype(value tf.DataType) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// DebugNumericSummaryV2TensorDebugMode sets the optional tensor_debug_mode attribute to value.
//
// value: Tensor debug mode: the mode in which the input tensor is summarized
//   by the op. See the TensorDebugMode enum in
//   tensorflow/core/protobuf/debug_event.proto for details.
//
// Supported values:
//   2 (CURT_HEALTH): Output a float32/64 tensor of shape [2]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element is a bit which is set to 1 if the input tensor has an
//   infinity or nan value, or zero otherwise.
//
//   3 (CONCISE_HEALTH): Output a float32/64 tensor of shape [5]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The
//   remaining four slots are the total number of elements, -infs,
//   +infs, and nans in the input tensor respectively.
//
//   4 (FULL_HEALTH): Output a float32/64 tensor of shape [11]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element is the device_id, if provided, and -1 otherwise. The 3rd
//   element holds the datatype value of the input tensor as according
//   to the enumerated type in tensorflow/core/framework/types.proto.
//   The remaining elements hold the total number of elements, -infs,
//   +infs, nans, negative finite numbers, zeros, and positive finite
//   numbers in the input tensor respectively.
//
//   5 (SHAPE): Output a float32/64 tensor of shape [10]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element holds the datatype value of the input tensor as according
//   to the enumerated type in tensorflow/core/framework/types.proto.
//   The 3rd element holds the rank of the tensor. The 4th element holds
//   the number of elements within the tensor. Finally the remaining 6
//   elements hold the shape of the tensor. If the rank of the tensor
//   is lower than 6, the shape is right padded with zeros. If the rank
//   is greater than 6, the head of the shape is truncated.
//
//   6 (FULL_NUMERICS): Output a float32/64 tensor of shape [22]. The 1st
//   element is the tensor_id, if provided, and -1 otherwise. The 2nd
//   element is the device_id, if provided, and -1 otherwise. The 3rd
//   element holds the datatype value of the input tensor as according
//   to the enumerated type in tensorflow/core/framework/types.proto.
//   The 4th element holds the rank of the tensor. The 5th to 11th
//   elements hold the shape of the tensor. If the rank of the tensor
//   is lower than 6, the shape is right padded with zeros. If the rank
//   is greater than 6, the head of the shape is truncated. The 12th to
//   18th elements hold the number of elements, -infs, +infs, nans,
//   denormal floats, negative finite numbers, zeros, and positive
//   finite numbers in the input tensor respectively. The final four
//   elements hold the min value, max value, mean, and variance of the
//   input tensor.
//
//   8 (REDUCE_INF_NAN_THREE_SLOTS): Output a float32/64 tensor of shape
//   [3]. The 1st element is -inf if any elements of the input tensor
//   is -inf, or zero otherwise. The 2nd element is +inf if any elements
//   of the input tensor is +inf, or zero otherwise.  The 3rd element is
//   nan if any element of the input tensor is nan, or zero otherwise.
// If not specified, defaults to -1
func DebugNumericSummaryV2TensorDebugMode(value int64) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["tensor_debug_mode"] = value
	}
}

// DebugNumericSummaryV2TensorId sets the optional tensor_id attribute to value.
//
// value: Optional. An integer identifier for the tensor being summarized by this op.
// If not specified, defaults to -1
func DebugNumericSummaryV2TensorId(value int64) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["tensor_id"] = value
	}
}

// Debug Numeric Summary V2 Op.
//
// Computes a numeric summary of the input tensor. The shape of the output
// depends on the tensor_debug_mode attribute.
// This op is used internally by TensorFlow Debugger (tfdbg) v2.
//
// Arguments:
//	input: Input tensor, to be summarized by the op.
func DebugNumericSummaryV2(scope *Scope, input tf.Output, optional ...DebugNumericSummaryV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNumericSummaryV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps the XLA ConvGeneralDilated operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#conv_convolution
// .
//
// Arguments:
//	lhs: the input tensor
//	rhs: the kernel tensor
//	window_strides: the inter-window strides
//	padding: the padding to apply at the start and end of each input dimensions
//	lhs_dilation: dilation to apply between input elements
//	rhs_dilation: dilation to apply between kernel elements
//	feature_group_count: number of feature groups for grouped convolution.
//	dimension_numbers: a serialized xla::ConvolutionDimensionNumbers proto.
//	precision_config: a serialized xla::PrecisionConfig proto.
//	preferred_element_type: The type of the tensor.
func XlaConvV2(scope *Scope, lhs tf.Output, rhs tf.Output, window_strides tf.Output, padding tf.Output, lhs_dilation tf.Output, rhs_dilation tf.Output, feature_group_count tf.Output, dimension_numbers string, precision_config string, preferred_element_type tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dimension_numbers": dimension_numbers, "precision_config": precision_config, "preferred_element_type": preferred_element_type}
	opspec := tf.OpSpec{
		Type: "XlaConvV2",
		Input: []tf.Input{
			lhs, rhs, window_strides, padding, lhs_dilation, rhs_dilation, feature_group_count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Calculate product with tridiagonal matrix.
//
// Calculates product of two matrices, where left matrix is a tridiagonal matrix.
//
// Arguments:
//	superdiag: Tensor of shape `[..., 1, M]`, representing superdiagonals of
// tri-diagonal matrices to the left of multiplication. Last element is ignored.
//	maindiag: Tensor of shape `[..., 1, M]`, representing main diagonals of tri-diagonal
// matrices to the left of multiplication.
//	subdiag: Tensor of shape `[..., 1, M]`, representing subdiagonals of tri-diagonal
// matrices to the left of multiplication. First element is ignored.
//	rhs: Tensor of shape `[..., M, N]`, representing MxN matrices to the right of
// multiplication.
//
// Returns Tensor of shape `[..., M, N]` containing the product.
func TridiagonalMatMul(scope *Scope, superdiag tf.Output, maindiag tf.Output, subdiag tf.Output, rhs tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TridiagonalMatMul",
		Input: []tf.Input{
			superdiag, maindiag, subdiag, rhs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveBcastRecvAttr is an optional argument to CollectiveBcastRecv.
type CollectiveBcastRecvAttr func(optionalAttr)

// CollectiveBcastRecvCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastRecvCommunicationHint(value string) CollectiveBcastRecvAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastRecvTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastRecvTimeoutSeconds(value float32) CollectiveBcastRecvAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Receives a tensor value broadcast from another device.
func CollectiveBcastRecv(scope *Scope, T tf.DataType, group_size int64, group_key int64, instance_key int64, shape tf.Shape, optional ...CollectiveBcastRecvAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T, "group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastRecv",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Scatter the data from the input value into specific TensorArray elements.
//
// `indices` must be a vector, its length must match the first dim of `value`.
//
// Arguments:
//	handle: The handle to a TensorArray.
//	indices: The locations at which to write the tensor elements.
//	value: The concatenated tensor to write to the TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns A float scalar that enforces proper chaining of operations.
func TensorArrayScatterV3(scope *Scope, handle tf.Output, indices tf.Output, value tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayScatterV3",
		Input: []tf.Input{
			handle, indices, value, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the matrix square root of one or more square matrices:
//
// matmul(sqrtm(A), sqrtm(A)) = A
//
// The input matrix should be invertible. If the input matrix is real, it should
// have no eigenvalues which are real and negative (pairs of complex conjugate
// eigenvalues are allowed).
//
// The matrix square root is computed by first reducing the matrix to
// quasi-triangular form with the real Schur decomposition. The square root
// of the quasi-triangular matrix is then computed directly. Details of
// the algorithm can be found in: Nicholas J. Higham, "Computing real
// square roots of a real matrix", Linear Algebra Appl., 1987.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor of the same shape as the input
// containing the matrix square root for all input submatrices `[..., :, :]`.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
//
// @compatibility(scipy)
// Equivalent to scipy.linalg.sqrtm
// @end_compatibility
func MatrixSquareRoot(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSquareRoot",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor with mirrored values.
//
// This operation pads a `input` with mirrored values according to the `paddings`
// you specify. `paddings` is an integer tensor with shape `[n, 2]`, where n is
// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many values to add before the contents of `input` in that dimension, and
// `paddings[D, 1]` indicates how many values to add after the contents of `input`
// in that dimension. Both `paddings[D, 0]` and `paddings[D, 1]` must be no greater
// than `input.dim_size(D)` (or `input.dim_size(D) - 1`) if `copy_border` is true
// (if false, respectively).
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 2, 3], [4, 5, 6]].
// # 'paddings' is [[1, 1]], [2, 2]].
// # 'mode' is SYMMETRIC.
// # rank of 't' is 2.
// pad(t, paddings) ==> [[2, 1, 1, 2, 3, 3, 2]
//                       [2, 1, 1, 2, 3, 3, 2]
//                       [5, 4, 4, 5, 6, 6, 5]
//                       [5, 4, 4, 5, 6, 6, 5]]
// ```
//
// Arguments:
//	input: The input tensor to be padded.
//	paddings: A two-column matrix specifying the padding sizes. The number of
// rows must be the same as the rank of `input`.
//	mode: Either `REFLECT` or `SYMMETRIC`. In reflect mode the padded regions
// do not include the borders, while in symmetric mode the padded regions
// do include the borders. For example, if `input` is `[1, 2, 3]` and `paddings`
// is `[0, 2]`, then the output is `[1, 2, 3, 2, 1]` in reflect mode, and
// it is `[1, 2, 3, 3, 2]` in symmetric mode.
//
// Returns The padded tensor.
func MirrorPad(scope *Scope, input tf.Output, paddings tf.Output, mode string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode}
	opspec := tf.OpSpec{
		Type: "MirrorPad",
		Input: []tf.Input{
			input, paddings,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorArrayV3Attr is an optional argument to TensorArrayV3.
type TensorArrayV3Attr func(optionalAttr)

// TensorArrayV3ElementShape sets the optional element_shape attribute to value.
//
// value: The expected shape of an element, if known. Used to
// validate the shapes of TensorArray elements. If this shape is not
// fully specified, gathering zero-size TensorArrays is an error.
// If not specified, defaults to {unknown_rank:true}
func TensorArrayV3ElementShape(value tf.Shape) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["element_shape"] = value
	}
}

// TensorArrayV3DynamicSize sets the optional dynamic_size attribute to value.
//
// value: A boolean that determines whether writes to the TensorArray
// are allowed to grow the size.  By default, this is not allowed.
// If not specified, defaults to false
func TensorArrayV3DynamicSize(value bool) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["dynamic_size"] = value
	}
}

// TensorArrayV3ClearAfterRead sets the optional clear_after_read attribute to value.
//
// value: If true (default), Tensors in the TensorArray are cleared
// after being read.  This disables multiple read semantics but allows early
// release of memory.
// If not specified, defaults to true
func TensorArrayV3ClearAfterRead(value bool) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["clear_after_read"] = value
	}
}

// TensorArrayV3IdenticalElementShapes sets the optional identical_element_shapes attribute to value.
//
// value: If true (default is false), then all
// elements in the TensorArray will be expected to have identical shapes.
// This allows certain behaviors, like dynamically checking for
// consistent shapes on write, and being able to fill in properly
// shaped zero tensors on stack -- even if the element_shape attribute
// is not fully defined.
// If not specified, defaults to false
func TensorArrayV3IdenticalElementShapes(value bool) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["identical_element_shapes"] = value
	}
}

// TensorArrayV3TensorArrayName sets the optional tensor_array_name attribute to value.
//
// value: Overrides the name used for the temporary tensor_array
// resource. Default value is the name of the 'TensorArray' op (which
// is guaranteed unique).
// If not specified, defaults to ""
func TensorArrayV3TensorArrayName(value string) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["tensor_array_name"] = value
	}
}

// An array of Tensors of given size.
//
// Write data via Write and read via Read or Pack.
//
// Arguments:
//	size: The size of the array.
//	dtype: The type of the elements on the tensor_array.
//
// Returns:
//	handle: The handle to the TensorArray.
//	flow: A scalar used to control gradient flow.
func TensorArrayV3(scope *Scope, size tf.Output, dtype tf.DataType, optional ...TensorArrayV3Attr) (handle tf.Output, flow tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayV3",
		Input: []tf.Input{
			size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// MatrixSolveLsAttr is an optional argument to MatrixSolveLs.
type MatrixSolveLsAttr func(optionalAttr)

// MatrixSolveLsFast sets the optional fast attribute to value.
// If not specified, defaults to true
func MatrixSolveLsFast(value bool) MatrixSolveLsAttr {
	return func(m optionalAttr) {
		m["fast"] = value
	}
}

// Solves one or more linear least-squares problems.
//
// `matrix` is a tensor of shape `[..., M, N]` whose inner-most 2 dimensions
// form real or complex matrices of size `[M, N]`. `Rhs` is a tensor of the same
// type as `matrix` and shape `[..., M, K]`.
// The output is a tensor shape `[..., N, K]` where each output matrix solves
// each of the equations
// `matrix[..., :, :]` * `output[..., :, :]` = `rhs[..., :, :]`
// in the least squares sense.
//
// We use the following notation for (complex) matrix and right-hand sides
// in the batch:
//
// `matrix`=\\(A \in \mathbb{C}^{m \times n}\\),
// `rhs`=\\(B  \in \mathbb{C}^{m \times k}\\),
// `output`=\\(X  \in \mathbb{C}^{n \times k}\\),
// `l2_regularizer`=\\(\lambda \in \mathbb{R}\\).
//
// If `fast` is `True`, then the solution is computed by solving the normal
// equations using Cholesky decomposition. Specifically, if \\(m \ge n\\) then
// \\(X = (A^H A + \lambda I)^{-1} A^H B\\), which solves the least-squares
// problem \\(X = \mathrm{argmin}_{Z \in \Re^{n \times k} } ||A Z - B||_F^2 + \lambda ||Z||_F^2\\).
// If \\(m \lt n\\) then `output` is computed as
// \\(X = A^H (A A^H + \lambda I)^{-1} B\\), which (for \\(\lambda = 0\\)) is the
// minimum-norm solution to the under-determined linear system, i.e.
// \\(X = \mathrm{argmin}_{Z \in \mathbb{C}^{n \times k} } ||Z||_F^2 \\),
// subject to \\(A Z = B\\). Notice that the fast path is only numerically stable
// when \\(A\\) is numerically full rank and has a condition number
// \\(\mathrm{cond}(A) \lt \frac{1}{\sqrt{\epsilon_{mach} } }\\) or \\(\lambda\\) is
// sufficiently large.
//
// If `fast` is `False` an algorithm based on the numerically robust complete
// orthogonal decomposition is used. This computes the minimum-norm
// least-squares solution, even when \\(A\\) is rank deficient. This path is
// typically 6-7 times slower than the fast path. If `fast` is `False` then
// `l2_regularizer` is ignored.
//
// Arguments:
//	matrix: Shape is `[..., M, N]`.
//	rhs: Shape is `[..., M, K]`.
//	l2_regularizer: Scalar tensor.
//
// @compatibility(numpy)
// Equivalent to np.linalg.lstsq
// @end_compatibility
//
// Returns Shape is `[..., N, K]`.
func MatrixSolveLs(scope *Scope, matrix tf.Output, rhs tf.Output, l2_regularizer tf.Output, optional ...MatrixSolveLsAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixSolveLs",
		Input: []tf.Input{
			matrix, rhs, l2_regularizer,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixTriangularSolveAttr is an optional argument to MatrixTriangularSolve.
type MatrixTriangularSolveAttr func(optionalAttr)

// MatrixTriangularSolveLower sets the optional lower attribute to value.
//
// value: Boolean indicating whether the innermost matrices in `matrix` are
// lower or upper triangular.
// If not specified, defaults to true
func MatrixTriangularSolveLower(value bool) MatrixTriangularSolveAttr {
	return func(m optionalAttr) {
		m["lower"] = value
	}
}

// MatrixTriangularSolveAdjoint sets the optional adjoint attribute to value.
//
// value: Boolean indicating whether to solve with `matrix` or its (block-wise)
//          adjoint.
//
// @compatibility(numpy)
// Equivalent to scipy.linalg.solve_triangular
// @end_compatibility
// If not specified, defaults to false
func MatrixTriangularSolveAdjoint(value bool) MatrixTriangularSolveAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Solves systems of linear equations with upper or lower triangular matrices by backsubstitution.
//
//
// `matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions form
// square matrices. If `lower` is `True` then the strictly upper triangular part
// of each inner-most matrix is assumed to be zero and not accessed.
// If `lower` is False then the strictly lower triangular part of each inner-most
// matrix is assumed to be zero and not accessed.
// `rhs` is a tensor of shape `[..., M, N]`.
//
// The output is a tensor of shape `[..., M, N]`. If `adjoint` is
// `True` then the innermost matrices in `output` satisfy matrix equations
// `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
// If `adjoint` is `False` then the strictly then the  innermost matrices in
// `output` satisfy matrix equations
// `adjoint(matrix[..., i, k]) * output[..., k, j] = rhs[..., i, j]`.
//
// Note, the batch shapes for the inputs only need to broadcast.
//
// Example:
// ```python
//
// a = tf.constant([[3,  0,  0,  0],
//                  [2,  1,  0,  0],
//                  [1,  0,  1,  0],
//                  [1,  1,  1,  1]], dtype=tf.float32)
//
// b = tf.constant([[4],
//                  [2],
//                  [4],
//                  [2]], dtype=tf.float32)
//
// x = tf.linalg.triangular_solve(a, b, lower=True)
// x
// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
// # array([[ 1.3333334 ],
// #        [-0.66666675],
// #        [ 2.6666665 ],
// #        [-1.3333331 ]], dtype=float32)>
//
// # in python3 one can use `a@x`
// tf.matmul(a, x)
// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
// # array([[4.       ],
// #        [2.       ],
// #        [4.       ],
// #        [1.9999999]], dtype=float32)>
// ```
//
// Arguments:
//	matrix: Shape is `[..., M, M]`.
//	rhs: Shape is `[..., M, K]`.
//
// Returns Shape is `[..., M, K]`.
func MatrixTriangularSolve(scope *Scope, matrix tf.Output, rhs tf.Output, optional ...MatrixTriangularSolveAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixTriangularSolve",
		Input: []tf.Input{
			matrix, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Applies sparse addition to `input` using individual values or slices
//
// from `updates` according to indices `indices`.  The updates are non-aliasing:
// `input` is only modified in-place if no other operations will use it.
// Otherwise, a copy of `input` is made.  This operation has a gradient with
// respect to both `input` and `updates`.
//
// `input` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `input`.
// It must be shape \\([d_0, ..., d_{Q-2}, K]\\) where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or `(P-K)`-dimensional slices
// (if `K < P`) along the `K`th dimension of `input`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// $$[d_0, ..., d_{Q-2}, input.shape[K], ..., input.shape[P-1]].$$
//
// For example, say we want to add 4 scattered elements to a rank-1 tensor to 8
// elements. In Python, that addition would look like this:
//
//     input = tf.constant([1, 2, 3, 4, 5, 6, 7, 8])
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     output = tf.scatter_nd_non_aliasing_add(input, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(output))
//
// The resulting value `output` would look like this:
//
//     [1, 13, 3, 14, 14, 6, 7, 20]
//
// See `tf.scatter_nd` for more details about how to make updates to slices.
//
// Arguments:
//	input: A Tensor.
//	indices: A Tensor. Must be one of the following types: `int32`, `int64`.
// A tensor of indices into `input`.
//	updates: A Tensor. Must have the same type as ref. A tensor of updated values
// to add to `input`.
//
// Returns A `Tensor` with the same shape as `input`, containing values of `input`
// updated with `updates`.
func ScatterNdNonAliasingAdd(scope *Scope, input tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ScatterNdNonAliasingAdd",
		Input: []tf.Input{
			input, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LuAttr is an optional argument to Lu.
type LuAttr func(optionalAttr)

// LuOutputIdxType sets the optional output_idx_type attribute to value.
// If not specified, defaults to DT_INT32
func LuOutputIdxType(value tf.DataType) LuAttr {
	return func(m optionalAttr) {
		m["output_idx_type"] = value
	}
}

// Computes the LU decomposition of one or more square matrices.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices.
//
// The input has to be invertible.
//
// The output consists of two tensors LU and P containing the LU decomposition
// of all input submatrices `[..., :, :]`. LU encodes the lower triangular and
// upper triangular factors.
//
// For each input submatrix of shape `[M, M]`, L is a lower triangular matrix of
// shape `[M, M]` with unit diagonal whose entries correspond to the strictly lower
// triangular part of LU. U is a upper triangular matrix of shape `[M, M]` whose
// entries correspond to the upper triangular part, including the diagonal, of LU.
//
// P represents a permutation matrix encoded as a list of indices each between `0`
// and `M-1`, inclusive. If P_mat denotes the permutation matrix corresponding to
// P, then the L, U and P satisfies P_mat * input = L * U.
//
// Arguments:
//	input: A tensor of shape `[..., M, M]` whose inner-most 2 dimensions form matrices of
// size `[M, M]`.
//
// Returns:
//	lu: A tensor of shape `[..., M, M]` whose strictly lower triangular part denotes the
// lower triangular factor `L` with unit diagonal, and whose upper triangular part
// denotes the upper triangular factor `U`.
//	p: Permutation of the rows encoded as a list of indices in `0..M-1`. Shape is
// `[..., M]`.
// @compatibility(scipy)
// Similar to `scipy.linalg.lu`, except the triangular factors `L` and `U` are
// packed into a single tensor, the permutation is applied to `input` instead of
// the right hand side and the permutation `P` is returned as a list of indices
// instead of a permutation matrix.
// @end_compatibility
func Lu(scope *Scope, input tf.Output, optional ...LuAttr) (lu tf.Output, p tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Lu",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// SelfAdjointEigV2Attr is an optional argument to SelfAdjointEigV2.
type SelfAdjointEigV2Attr func(optionalAttr)

// SelfAdjointEigV2ComputeV sets the optional compute_v attribute to value.
//
// value: If `True` then eigenvectors will be computed and returned in `v`.
// Otherwise, only the eigenvalues will be computed.
// If not specified, defaults to true
func SelfAdjointEigV2ComputeV(value bool) SelfAdjointEigV2Attr {
	return func(m optionalAttr) {
		m["compute_v"] = value
	}
}

// Computes the eigen decomposition of one or more square self-adjoint matrices.
//
// Computes the eigenvalues and (optionally) eigenvectors of each inner matrix in
// `input` such that `input[..., :, :] = v[..., :, :] * diag(e[..., :])`. The eigenvalues
// are sorted in non-decreasing order.
//
// ```python
// # a is a tensor.
// # e is a tensor of eigenvalues.
// # v is a tensor of eigenvectors.
// e, v = self_adjoint_eig(a)
// e = self_adjoint_eig(a, compute_v=False)
// ```
//
// Arguments:
//	input: `Tensor` input of shape `[N, N]`.
//
// Returns:
//	e: Eigenvalues. Shape is `[N]`.
//	v: Eigenvectors. Shape is `[N, N]`.
func SelfAdjointEigV2(scope *Scope, input tf.Output, optional ...SelfAdjointEigV2Attr) (e tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SelfAdjointEigV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes the Eigen Decomposition of a batch of square self-adjoint matrices.
//
// DEPRECATED at GraphDef version 11: Use SelfAdjointEigV2 instead.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices, with the same constraints as the single matrix
// SelfAdjointEig.
//
// The result is a [..., M+1, M] matrix with [..., 0,:] containing the
// eigenvalues, and subsequent [...,1:, :] containing the eigenvectors. The eigenvalues
// are sorted in non-decreasing order.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M+1, M]`.
func SelfAdjointEig(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SelfAdjointEig",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the reverse mode backpropagated gradient of the Cholesky algorithm.
//
// For an explanation see "Differentiation of the Cholesky algorithm" by
// Iain Murray http://arxiv.org/abs/1602.07527.
//
// Arguments:
//	l: Output of batch Cholesky algorithm l = cholesky(A). Shape is `[..., M, M]`.
// Algorithm depends only on lower triangular part of the innermost matrices of
// this tensor.
//	grad: df/dl where f is some scalar function. Shape is `[..., M, M]`.
// Algorithm depends only on lower triangular part of the innermost matrices of
// this tensor.
//
// Returns Symmetrized version of df/dA . Shape is `[..., M, M]`
func CholeskyGrad(scope *Scope, l tf.Output, grad tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CholeskyGrad",
		Input: []tf.Input{
			l, grad,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated, use python implementation tf.linalg.matrix_exponential.
//
// DEPRECATED at GraphDef version 27: Use Python implementation tf.linalg.matrix_exponential instead.
func MatrixExponential(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixExponential",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that emits the key-value pairs in one or more LMDB files.
//
// The Lightning Memory-Mapped Database Manager, or LMDB, is an embedded binary
// key-value database. This dataset can read the contents of LMDB database files,
// the names of which generally have the `.mdb` suffix.
//
// Each output element consists of a key-value pair represented as a pair of
// scalar string `Tensor`s, where the first `Tensor` contains the key and the
// second `Tensor` contains the value.
//
// LMDB uses different file formats on big- and little-endian machines.
// `LMDBDataset` can only read files in the format of the host machine.
//
// Arguments:
//	filenames: A scalar or a vector containing the name(s) of the binary file(s) to be
// read.
//
//
func LMDBDataset(scope *Scope, filenames tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "LMDBDataset",
		Input: []tf.Input{
			filenames,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixInverseAttr is an optional argument to MatrixInverse.
type MatrixInverseAttr func(optionalAttr)

// MatrixInverseAdjoint sets the optional adjoint attribute to value.
// If not specified, defaults to false
func MatrixInverseAdjoint(value bool) MatrixInverseAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Computes the inverse of one or more square invertible matrices or their adjoints (conjugate transposes).
//
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor of the same shape as the input
// containing the inverse for all input submatrices `[..., :, :]`.
//
// The op uses LU decomposition with partial pivoting to compute the inverses.
//
// If a matrix is not invertible there is no guarantee what the op does. It
// may detect the condition and raise an exception or it may simply return a
// garbage result.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
//
// @compatibility(numpy)
// Equivalent to np.linalg.inv
// @end_compatibility
func MatrixInverse(scope *Scope, input tf.Output, optional ...MatrixInverseAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixInverse",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the sign and the log of the absolute value of the determinant of
//
// one or more square matrices.
//
// The input is a tensor of shape `[N, M, M]` whose inner-most 2 dimensions
// form square matrices. The outputs are two tensors containing the signs and
// absolute values of the log determinants for all N input submatrices
// `[..., :, :]` such that `determinant = sign*exp(log_abs_determinant)`.
// The `log_abs_determinant` is computed as `det(P)*sum(log(diag(LU)))` where `LU`
// is the `LU` decomposition of the input and `P` is the corresponding
// permutation matrix.
//
// Arguments:
//	input: Shape is `[N, M, M]`.
//
// Returns:
//	sign: The signs of the log determinants of the inputs. Shape is `[N]`.
//	log_abs_determinant: The logs of the absolute values of the determinants
// of the N input matrices.  Shape is `[N]`.
func LogMatrixDeterminant(scope *Scope, input tf.Output) (sign tf.Output, log_abs_determinant tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogMatrixDeterminant",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes the determinant of one or more square matrices.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor containing the determinants
// for all input submatrices `[..., :, :]`.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[...]`.
func MatrixDeterminant(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDeterminant",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorList by indexing into a Tensor.
//
// Each member of the TensorList corresponds to one row of the input tensor,
// specified by the given index (see `tf.gather`).
//
// tensor: The input tensor.
// indices: The indices used to index into the list.
// element_shape: The shape of the elements in the list (can be less specified than
//   the shape of the tensor).
// num_elements: The size of the output list. Must be large enough to accommodate
//   the largest index in indices. If -1, the list is just large enough to include
//   the largest index in indices.
// output_handle: The TensorList.
func TensorListScatterV2(scope *Scope, tensor tf.Output, indices tf.Output, element_shape tf.Output, num_elements tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListScatterV2",
		Input: []tf.Input{
			tensor, indices, element_shape, num_elements,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorList by indexing into a Tensor.
//
// Each member of the TensorList corresponds to one row of the input tensor,
// specified by the given index (see `tf.gather`).
//
// tensor: The input tensor.
// indices: The indices used to index into the list.
// element_shape: The shape of the elements in the list (can be less specified than
//   the shape of the tensor).
// output_handle: The TensorList.
func TensorListScatter(scope *Scope, tensor tf.Output, indices tf.Output, element_shape tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListScatter",
		Input: []tf.Input{
			tensor, indices, element_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of the sigmoid of `x` wrt its input.
//
// Specifically, `grad = dy * y * (1 - y)`, where `y = sigmoid(x)`, and
// `dy` is the corresponding input gradient.
func SigmoidGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SigmoidGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a Tensor by indexing into the TensorList.
//
// Each row in the produced Tensor corresponds to the element in the TensorList
// specified by the given index (see `tf.gather`).
//
// input_handle: The input tensor list.
// indices: The indices used to index into the list.
// values: The tensor.
func TensorListGather(scope *Scope, input_handle tf.Output, indices tf.Output, element_shape tf.Output, element_dtype tf.DataType) (values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "TensorListGather",
		Input: []tf.Input{
			input_handle, indices, element_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// The shape of the elements of the given list, as a tensor.
//
//   input_handle: the list
//   element_shape: the shape of elements of the list
func TensorListElementShape(scope *Scope, input_handle tf.Output, shape_type tf.DataType) (element_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape_type": shape_type}
	opspec := tf.OpSpec{
		Type: "TensorListElementShape",
		Input: []tf.Input{
			input_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalThreadPoolHandleAttr is an optional argument to ExperimentalThreadPoolHandle.
type ExperimentalThreadPoolHandleAttr func(optionalAttr)

// ExperimentalThreadPoolHandleMaxIntraOpParallelism sets the optional max_intra_op_parallelism attribute to value.
//
// value: The maximum degree of parallelism to use within operations that execute on this
// threadpool.
// If not specified, defaults to 1
func ExperimentalThreadPoolHandleMaxIntraOpParallelism(value int64) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["max_intra_op_parallelism"] = value
	}
}

// ExperimentalThreadPoolHandleContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func ExperimentalThreadPoolHandleContainer(value string) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ExperimentalThreadPoolHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func ExperimentalThreadPoolHandleSharedName(value string) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//	num_threads: The number of threads in the thread pool.
//	display_name: A human-readable name for the threads that may be visible in some
// visualizations.
// threadpool.
//
// Returns A resource that can be consumed by one or more ExperimentalThreadPoolDataset
// ops.
func ExperimentalThreadPoolHandle(scope *Scope, num_threads int64, display_name string, optional ...ExperimentalThreadPoolHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_threads": num_threads, "display_name": display_name}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalThreadPoolHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorList which, when stacked, has the value of `tensor`.
//
// Each tensor in the result list corresponds to one row of the input tensor.
//
// tensor: The input tensor.
// output_handle: The list.
func TensorListFromTensor(scope *Scope, tensor tf.Output, element_shape tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListFromTensor",
		Input: []tf.Input{
			tensor, element_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorListStackAttr is an optional argument to TensorListStack.
type TensorListStackAttr func(optionalAttr)

// TensorListStackNumElements sets the optional num_elements attribute to value.
// If not specified, defaults to -1
func TensorListStackNumElements(value int64) TensorListStackAttr {
	return func(m optionalAttr) {
		m["num_elements"] = value
	}
}

// Stacks all tensors in the list.
//
// Requires that all tensors have the same shape.
//
// input_handle: the input list
// tensor: the gathered result
// num_elements: optional. If not -1, the number of elements in the list.
//
func TensorListStack(scope *Scope, input_handle tf.Output, element_shape tf.Output, element_dtype tf.DataType, optional ...TensorListStackAttr) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorListStack",
		Input: []tf.Input{
			input_handle, element_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the number of tensors in the input tensor list.
//
// input_handle: the input list
// length: the number of tensors in the list
func TensorListLength(scope *Scope, input_handle tf.Output) (length tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListLength",
		Input: []tf.Input{
			input_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Does nothing. Serves as a control trigger for scheduling.
//
// Only useful as a placeholder for control edges.
//
// Returns the created operation.
func ControlTrigger(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ControlTrigger",
	}
	return scope.AddOperation(opspec)
}

// Interleave the values from the `data` tensors into a single tensor.
//
// Builds a merged tensor such that
//
// ```python
//     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
// ```
//
// For example, if each `indices[m]` is scalar or vector, we have
//
// ```python
//     # Scalar indices:
//     merged[indices[m], ...] = data[m][...]
//
//     # Vector indices:
//     merged[indices[m][i], ...] = data[m][i, ...]
// ```
//
// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
// `constant`, the output shape is
//
//     merged.shape = [max(indices)] + constant
//
// Values may be merged in parallel, so if an index appears in both `indices[m][i]`
// and `indices[n][j]`, the result may be invalid. This differs from the normal
// DynamicStitch operator that defines the behavior in that case.
//
// For example:
//
// ```python
//     indices[0] = 6
//     indices[1] = [4, 1]
//     indices[2] = [[5, 2], [0, 3]]
//     data[0] = [61, 62]
//     data[1] = [[41, 42], [11, 12]]
//     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
//     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
//               [51, 52], [61, 62]]
// ```
//
// This method can be used to merge partitions created by `dynamic_partition`
// as illustrated on the following example:
//
// ```python
//     # Apply function (increments x_i) on elements for which a certain condition
//     # apply (x_i != -1 in this example).
//     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
//     condition_mask=tf.not_equal(x,tf.constant(-1.))
//     partitioned_data = tf.dynamic_partition(
//         x, tf.cast(condition_mask, tf.int32) , 2)
//     partitioned_data[1] = partitioned_data[1] + 1.0
//     condition_indices = tf.dynamic_partition(
//         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
//     x = tf.dynamic_stitch(condition_indices, partitioned_data)
//     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
//     # unchanged.
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
// </div>
func ParallelDynamicStitch(scope *Scope, indices []tf.Output, data []tf.Output) (merged tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ParallelDynamicStitch",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(data),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a Tensor stack of all keys in a tensor map.
//
// input_handle: the input map
// keys: the returned Tensor of all keys in the map
func TensorMapStackKeys(scope *Scope, input_handle tf.Output, key_dtype tf.DataType) (keys tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype}
	opspec := tf.OpSpec{
		Type: "TensorMapStackKeys",
		Input: []tf.Input{
			input_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns whether the given key exists in the map.
//
// input_handle: the input map
// key: the key to check
// has_key: whether the key is already in the map or not
func TensorMapHasKey(scope *Scope, input_handle tf.Output, key tf.Output) (has_key tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorMapHasKey",
		Input: []tf.Input{
			input_handle, key,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 3D fast Fourier transform.
//
// Computes the inverse 3-dimensional discrete Fourier transform over the
// inner-most 3 dimensions of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 3
//   dimensions of `input` are replaced with their inverse 3D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifftn with 3 dimensions.
// @end_compatibility
func IFFT3D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT3D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a map that is the 'input_handle' with the given key-value pair inserted.
//
// input_handle: the original map
// output_handle: the map with key and value inserted
// key: the key to be inserted
// value: the value to be inserted
func TensorMapInsert(scope *Scope, input_handle tf.Output, key tf.Output, value tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorMapInsert",
		Input: []tf.Input{
			input_handle, key, value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the value from a given key in a tensor map.
//
// input_handle: the input map
// key: the key to be looked up
// value: the value found from the given key
func TensorMapLookup(scope *Scope, input_handle tf.Output, key tf.Output, value_dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value_dtype": value_dtype}
	opspec := tf.OpSpec{
		Type: "TensorMapLookup",
		Input: []tf.Input{
			input_handle, key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeImageAttr is an optional argument to DecodeImage.
type DecodeImageAttr func(optionalAttr)

// DecodeImageChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeImageChannels(value int64) DecodeImageAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeImageDtype sets the optional dtype attribute to value.
//
// value: The desired DType of the returned Tensor.
// If not specified, defaults to DT_UINT8
func DecodeImageDtype(value tf.DataType) DecodeImageAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// DecodeImageExpandAnimations sets the optional expand_animations attribute to value.
//
// value: Controls the output shape of the returned op. If True, the returned op will
// produce a 3-D tensor for PNG, JPEG, and BMP files; and a 4-D tensor for all
// GIFs, whether animated or not. If, False, the returned op will produce a 3-D
// tensor for all file types and will truncate animated GIFs to the first frame.
// If not specified, defaults to true
func DecodeImageExpandAnimations(value bool) DecodeImageAttr {
	return func(m optionalAttr) {
		m["expand_animations"] = value
	}
}

// Function for decode_bmp, decode_gif, decode_jpeg, and decode_png.
//
// Detects whether an image is a BMP, GIF, JPEG, or PNG, and performs the
// appropriate operation to convert the input bytes string into a Tensor of type
// dtype.
//
// *NOTE*: decode_gif returns a 4-D array [num_frames, height, width, 3], as
// opposed to decode_bmp, decode_jpeg and decode_png, which return 3-D arrays
// [height, width, num_channels]. Make sure to take this into account when
// constructing your graph if you are intermixing GIF files with BMP, JPEG, and/or
// PNG files. Alternately, set the expand_animations argument of this function to
// False, in which case the op will return 3-dimensional tensors and will truncate
// animated GIF files to the first frame.
//
// *NOTE*: If the first frame of an animated GIF does not occupy the entire
// canvas (maximum frame width x maximum frame height), then it fills the
// unoccupied areas (in the first frame) with zeros (black). For frames after the
// first frame that does not occupy the entire canvas, it uses the previous
// frame to fill the unoccupied areas.
//
// Arguments:
//	contents: 0-D. The encoded image bytes.
//
// Returns 3-D with shape `[height, width, channels]` or 4-D with shape
// `[frame, height, width, channels]`..
func DecodeImage(scope *Scope, contents tf.Output, optional ...DecodeImageAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeImage",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPoolAttr is an optional argument to AvgPool.
type AvgPoolAttr func(optionalAttr)

// AvgPoolDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func AvgPoolDataFormat(value string) AvgPoolAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs average pooling on the input.
//
// Each entry in `output` is the mean of the corresponding size `ksize`
// window in `value`.
//
// Arguments:
//	value: 4-D with shape `[batch, height, width, channels]`.
//	ksize: The size of the sliding window for each dimension of `value`.
//	strides: The stride of the sliding window for each dimension of `value`.
//	padding: The type of padding algorithm to use.
//
// Returns The average pooled output tensor.
func AvgPool(scope *Scope, value tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPoolAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AudioSummaryV2Attr is an optional argument to AudioSummaryV2.
type AudioSummaryV2Attr func(optionalAttr)

// AudioSummaryV2MaxOutputs sets the optional max_outputs attribute to value.
//
// value: Max number of batch elements to generate audio for.
// If not specified, defaults to 3
//
// REQUIRES: value >= 1
func AudioSummaryV2MaxOutputs(value int64) AudioSummaryV2Attr {
	return func(m optionalAttr) {
		m["max_outputs"] = value
	}
}

// Outputs a `Summary` protocol buffer with audio.
//
// The summary has up to `max_outputs` summary values containing audio. The
// audio is built from `tensor` which must be 3-D with shape `[batch_size,
// frames, channels]` or 2-D with shape `[batch_size, frames]`. The values are
// assumed to be in the range of `[-1.0, 1.0]` with a sample rate of `sample_rate`.
//
// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
// build the `tag` of the summary values:
//
// *  If `max_outputs` is 1, the summary value tag is '*tag*/audio'.
// *  If `max_outputs` is greater than 1, the summary value tags are
//    generated sequentially as '*tag*/audio/0', '*tag*/audio/1', etc.
//
// Arguments:
//	tag: Scalar. Used to build the `tag` attribute of the summary values.
//	tensor: 2-D of shape `[batch_size, frames]`.
//	sample_rate: The sample rate of the signal in hertz.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func AudioSummaryV2(scope *Scope, tag tf.Output, tensor tf.Output, sample_rate tf.Output, optional ...AudioSummaryV2Attr) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AudioSummaryV2",
		Input: []tf.Input{
			tag, tensor, sample_rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringLengthAttr is an optional argument to StringLength.
type StringLengthAttr func(optionalAttr)

// StringLengthUnit sets the optional unit attribute to value.
//
// value: The unit that is counted to compute string length.  One of: `"BYTE"` (for
// the number of bytes in each string) or `"UTF8_CHAR"` (for the number of UTF-8
// encoded Unicode code points in each string).  Results are undefined
// if `unit=UTF8_CHAR` and the `input` strings do not contain structurally
// valid UTF-8.
// If not specified, defaults to "BYTE"
func StringLengthUnit(value string) StringLengthAttr {
	return func(m optionalAttr) {
		m["unit"] = value
	}
}

// String lengths of `input`.
//
// Computes the length of each string given in the input tensor.
//
// >>> strings = tf.constant(['Hello','TensorFlow', '\U0001F642'])
// >>> tf.strings.length(strings).numpy() # default counts bytes
// array([ 5, 10, 4], dtype=int32)
// >>> tf.strings.length(strings, unit="UTF8_CHAR").numpy()
// array([ 5, 10, 1], dtype=int32)
//
//
// Arguments:
//	input: The strings for which to compute the length for each element.
//
// Returns Integer tensor that has the same shape as `input`. The output contains the
// element-wise string lengths of `input`.
func StringLength(scope *Scope, input tf.Output, optional ...StringLengthAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringLength",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorSummaryAttr is an optional argument to TensorSummary.
type TensorSummaryAttr func(optionalAttr)

// TensorSummaryDescription sets the optional description attribute to value.
//
// value: A json-encoded SummaryDescription proto.
// If not specified, defaults to ""
func TensorSummaryDescription(value string) TensorSummaryAttr {
	return func(m optionalAttr) {
		m["description"] = value
	}
}

// TensorSummaryLabels sets the optional labels attribute to value.
//
// value: An unused list of strings.
// If not specified, defaults to {}
func TensorSummaryLabels(value []string) TensorSummaryAttr {
	return func(m optionalAttr) {
		m["labels"] = value
	}
}

// TensorSummaryDisplayName sets the optional display_name attribute to value.
//
// value: An unused string.
// If not specified, defaults to ""
func TensorSummaryDisplayName(value string) TensorSummaryAttr {
	return func(m optionalAttr) {
		m["display_name"] = value
	}
}

// Outputs a `Summary` protocol buffer with a tensor.
//
// This op is being phased out in favor of TensorSummaryV2, which lets callers pass
// a tag as well as a serialized SummaryMetadata proto string that contains
// plugin-specific data. We will keep this op to maintain backwards compatibility.
//
// Arguments:
//	tensor: A tensor to serialize.
func TensorSummary(scope *Scope, tensor tf.Output, optional ...TensorSummaryAttr) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorSummary",
		Input: []tf.Input{
			tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs a `Summary` protocol buffer with a histogram.
//
// The generated
// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
// has one summary value containing a histogram for `values`.
//
// This op reports an `InvalidArgument` error if any value is not finite.
//
// Arguments:
//	tag: Scalar.  Tag to use for the `Summary.Value`.
//	values: Any shape. Values to use to build the histogram.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func HistogramSummary(scope *Scope, tag tf.Output, values tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "HistogramSummary",
		Input: []tf.Input{
			tag, values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Merges summaries.
//
// This op creates a
// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
// protocol buffer that contains the union of all the values in the input
// summaries.
//
// When the Op is run, it reports an `InvalidArgument` error if multiple values
// in the summaries to merge use the same tag.
//
// Arguments:
//	inputs: Can be of any shape.  Each must contain serialized `Summary` protocol
// buffers.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func MergeSummary(scope *Scope, inputs []tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MergeSummary",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the sqrt of `x` wrt its input.
//
// Specifically, `grad = dy * 0.5 / y`, where `y = sqrt(x)`, and `dy`
// is the corresponding input gradient.
func SqrtGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SqrtGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MutableHashTableOfTensorsV2Attr is an optional argument to MutableHashTableOfTensorsV2.
type MutableHashTableOfTensorsV2Attr func(optionalAttr)

// MutableHashTableOfTensorsV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableHashTableOfTensorsV2Container(value string) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableHashTableOfTensorsV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableHashTableOfTensorsV2SharedName(value string) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableHashTableOfTensorsV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
// If not specified, defaults to false
func MutableHashTableOfTensorsV2UseNodeNameSharing(value bool) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// MutableHashTableOfTensorsV2ValueShape sets the optional value_shape attribute to value.
// If not specified, defaults to {}
func MutableHashTableOfTensorsV2ValueShape(value tf.Shape) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["value_shape"] = value
	}
}

// Creates an empty hash table.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a vector. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableHashTableOfTensorsV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...MutableHashTableOfTensorsV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableHashTableOfTensorsV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the grayscale dilation of 4-D `input` and 3-D `filter` tensors.
//
// The `input` tensor has shape `[batch, in_height, in_width, depth]` and the
// `filter` tensor has shape `[filter_height, filter_width, depth]`, i.e., each
// input channel is processed independently of the others with its own structuring
// function. The `output` tensor has shape
// `[batch, out_height, out_width, depth]`. The spatial dimensions of the output
// tensor depend on the `padding` algorithm. We currently only support the default
// "NHWC" `data_format`.
//
// In detail, the grayscale morphological 2-D dilation is the max-sum correlation
// (for consistency with `conv2d`, we use unmirrored filters):
//
//     output[b, y, x, c] =
//        max_{dy, dx} input[b,
//                           strides[1] * y + rates[1] * dy,
//                           strides[2] * x + rates[2] * dx,
//                           c] +
//                     filter[dy, dx, c]
//
// Max-pooling is a special case when the filter has size equal to the pooling
// kernel size and contains all zeros.
//
// Note on duality: The dilation of `input` by the `filter` is equal to the
// negation of the erosion of `-input` by the reflected `filter`.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	strides: The stride of the sliding window for each dimension of the input
// tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: The input stride for atrous morphological dilation. Must be:
// `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, out_height, out_width, depth]`.
func Dilation2D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, rates []int64, padding string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IsotonicRegressionAttr is an optional argument to IsotonicRegression.
type IsotonicRegressionAttr func(optionalAttr)

// IsotonicRegressionOutputDtype sets the optional output_dtype attribute to value.
//
// value: Dtype of output.
// If not specified, defaults to DT_FLOAT
func IsotonicRegressionOutputDtype(value tf.DataType) IsotonicRegressionAttr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// Solves a batch of isotonic regression problems.
//
// Arguments:
//	input: A (batch_size, dim)-tensor holding a batch of inputs.
//
// Returns:
//	output: A (batch_size, dim)-tensor holding the per-batch element solutions.
//	segments: An int32 (batch_size, dim)-tensor with the segments.
func IsotonicRegression(scope *Scope, input tf.Output, optional ...IsotonicRegressionAttr) (output tf.Output, segments tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IsotonicRegression",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// MutableHashTableV2Attr is an optional argument to MutableHashTableV2.
type MutableHashTableV2Attr func(optionalAttr)

// MutableHashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableHashTableV2Container(value string) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableHashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableHashTableV2SharedName(value string) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableHashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
//
// value: If true and shared_name is empty, the table is shared
// using the node name.
// If not specified, defaults to false
func MutableHashTableV2UseNodeNameSharing(value bool) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// Creates an empty hash table.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a scalar. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableHashTableV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...MutableHashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableHashTableV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Delete the tensor specified by its handle in the session.
//
// Arguments:
//	handle: The handle for a tensor stored in the session state.
//
// Returns the created operation.
func DeleteSessionTensor(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteSessionTensor",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Creates a uninitialized anonymous hash table.
//
// This op creates a new anonymous hash table (as a resource) everytime
// it is executed, with the specified dtype of its keys and values,
// returning the resource handle.  Before using the table you will have
// to initialize it.  After initialization the table will be
// immutable. The table is anonymous in the sense that it can only be
// accessed by the returned resource handle (e.g. it cannot be looked up
// by a name in a resource manager). The table will be automatically
// deleted when all resource handles pointing to it are gone.
//
// Arguments:
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns The resource handle to the newly created hash-table resource.
func AnonymousHashTable(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	opspec := tf.OpSpec{
		Type: "AnonymousHashTable",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Calculates the prior from the training data (the bias) and fills in the first node with the logits' prior. Returns a boolean indicating whether to continue centering.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble.
//	mean_gradients: A tensor with shape=[logits_dimension] with mean of gradients for a first node.
//	mean_hessians: A tensor with shape=[logits_dimension] mean of hessians for a first node.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//
// Returns Bool, whether to continue bias centering.
func BoostedTreesCenterBias(scope *Scope, tree_ensemble_handle tf.Output, mean_gradients tf.Output, mean_hessians tf.Output, l1 tf.Output, l2 tf.Output) (continue_centering tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCenterBias",
		Input: []tf.Input{
			tree_ensemble_handle, mean_gradients, mean_hessians, l1, l2,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// HashTableV2Attr is an optional argument to HashTableV2.
type HashTableV2Attr func(optionalAttr)

// HashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func HashTableV2Container(value string) HashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// HashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func HashTableV2SharedName(value string) HashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// HashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
//
// value: If true and shared_name is empty, the table is shared
// using the node name.
// If not specified, defaults to false
func HashTableV2UseNodeNameSharing(value bool) HashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// Creates a non-initialized hash table.
//
// This op creates a hash table, specifying the type of its keys and values.
// Before using the table you will have to initialize it.  After initialization the
// table will be immutable.
//
// Arguments:
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func HashTableV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...HashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "HashTableV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixDiagV3Attr is an optional argument to MatrixDiagV3.
type MatrixDiagV3Attr func(optionalAttr)

// MatrixDiagV3Align sets the optional align attribute to value.
//
// value: Some diagonals are shorter than `max_diag_len` and need to be padded. `align` is
// a string specifying how superdiagonals and subdiagonals should be aligned,
// respectively. There are four possible alignments: "RIGHT_LEFT" (default),
// "LEFT_RIGHT", "LEFT_LEFT", and "RIGHT_RIGHT". "RIGHT_LEFT" aligns superdiagonals
// to the right (left-pads the row) and subdiagonals to the left (right-pads the
// row). It is the packing format LAPACK uses. cuSPARSE uses "LEFT_RIGHT", which is
// the opposite alignment.
// If not specified, defaults to "RIGHT_LEFT"
func MatrixDiagV3Align(value string) MatrixDiagV3Attr {
	return func(m optionalAttr) {
		m["align"] = value
	}
}

// Returns a batched diagonal tensor with given batched diagonal values.
//
// Returns a tensor with the contents in `diagonal` as `k[0]`-th to `k[1]`-th
// diagonals of a matrix, with everything else padded with `padding`. `num_rows`
// and `num_cols` specify the dimension of the innermost matrix of the output. If
// both are not specified, the op assumes the innermost matrix is square and infers
// its size from `k` and the innermost dimension of `diagonal`. If only one of them
// is specified, the op assumes the unspecified value is the smallest possible
// based on other criteria.
//
// Let `diagonal` have `r` dimensions `[I, J, ..., L, M, N]`. The output tensor has
// rank `r+1` with shape `[I, J, ..., L, M, num_rows, num_cols]` when only one
// diagonal is given (`k` is an integer or `k[0] == k[1]`). Otherwise, it has rank
// `r` with shape `[I, J, ..., L, num_rows, num_cols]`.
//
// The second innermost dimension of `diagonal` has double meaning.
// When `k` is scalar or `k[0] == k[1]`, `M` is part of the batch size
// [I, J, ..., M], and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
//     padding_value                             ; otherwise
// ```
//
// Otherwise, `M` is treated as the number of diagonals for the matrix in the
// same batch (`M = k[1]-k[0]+1`), and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//   = diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//     padding_value                                     ; otherwise
// ```
// where `d = n - m`, `diag_index = [k] - d`, and
// `index_in_diag = n - max(d, 0) + offset`.
//
// `offset` is zero except when the alignment of the diagonal is to the right.
// ```
// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
//                                            and `d >= 0`) or
//                                          (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
//                                            and `d <= 0`)
//          0                          ; otherwise
// ```
// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
//
// For example:
//
// ```
// # The main diagonal.
// diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
//                      [5, 6, 7, 8]])
// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
//                                [0, 2, 0, 0],
//                                [0, 0, 3, 0],
//                                [0, 0, 0, 4]],
//                               [[5, 0, 0, 0],
//                                [0, 6, 0, 0],
//                                [0, 0, 7, 0],
//                                [0, 0, 0, 8]]]
//
// # A superdiagonal (per batch).
// diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
//                      [4, 5, 6]])
// tf.matrix_diag(diagonal, k = 1)
//   ==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
//         [0, 0, 2, 0],
//         [0, 0, 0, 3],
//         [0, 0, 0, 0]],
//        [[0, 4, 0, 0],
//         [0, 0, 5, 0],
//         [0, 0, 0, 6],
//         [0, 0, 0, 0]]]
//
// # A tridiagonal band (per batch).
// diagonals = np.array([[[0, 8, 9],  # Input shape: (2, 2, 3)
//                        [1, 2, 3],
//                        [4, 5, 0]],
//                       [[0, 2, 3],
//                        [6, 7, 9],
//                        [9, 1, 0]]])
// tf.matrix_diag(diagonals, k = (-1, 1))
//   ==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
//         [4, 2, 9],
//         [0, 5, 3]],
//        [[6, 2, 0],
//         [9, 7, 3],
//         [0, 1, 9]]]
//
// # LEFT_RIGHT alignment.
// diagonals = np.array([[[8, 9, 0],  # Input shape: (2, 2, 3)
//                        [1, 2, 3],
//                        [0, 4, 5]],
//                       [[2, 3, 0],
//                        [6, 7, 9],
//                        [0, 9, 1]]])
// tf.matrix_diag(diagonals, k = (-1, 1), align="LEFT_RIGHT")
//   ==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
//         [4, 2, 9],
//         [0, 5, 3]],
//        [[6, 2, 0],
//         [9, 7, 3],
//         [0, 1, 9]]]
//
// # Rectangular matrix.
// diagonal = np.array([1, 2])  # Input shape: (2)
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
//   ==> [[0, 0, 0, 0],  # Output shape: (3, 4)
//        [1, 0, 0, 0],
//        [0, 2, 0, 0]]
//
// # Rectangular matrix with inferred num_cols and padding_value = 9.
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding_value = 9)
//   ==> [[9, 9],  # Output shape: (3, 2)
//        [1, 9],
//        [9, 2]]
//
// ```
//
// Arguments:
//	diagonal: Rank `r`, where `r >= 1`
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//	num_rows: The number of rows of the output matrix. If it is not provided, the op assumes
// the output matrix is a square matrix and infers the matrix size from k and the
// innermost dimension of `diagonal`.
//	num_cols: The number of columns of the output matrix. If it is not provided, the op
// assumes the output matrix is a square matrix and infers the matrix size from
// k and the innermost dimension of `diagonal`.
//	padding_value: The number to fill the area outside the specified diagonal band with.
// Default is 0.
//
// Returns Has rank `r+1` when `k` is an integer or `k[0] == k[1]`, rank `r` otherwise.
func MatrixDiagV3(scope *Scope, diagonal tf.Output, k tf.Output, num_rows tf.Output, num_cols tf.Output, padding_value tf.Output, optional ...MatrixDiagV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagV3",
		Input: []tf.Input{
			diagonal, k, num_rows, num_cols, padding_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high overlaps
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed. N-by-n overlap values are supplied as square matrix,
// which allows for defining a custom overlap criterium (eg. intersection over union,
// intersection over area, etc.).
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//   selected_indices = tf.image.non_max_suppression_with_overlaps(
//       overlaps, scores, max_output_size, overlap_threshold, score_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	overlaps: A 2-D float tensor of shape `[num_boxes, num_boxes]` representing
// the n-by-n box overlap values.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	overlap_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionWithOverlaps(scope *Scope, overlaps tf.Output, scores tf.Output, max_output_size tf.Output, overlap_threshold tf.Output, score_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionWithOverlaps",
		Input: []tf.Input{
			overlaps, scores, max_output_size, overlap_threshold, score_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs all keys and values in the table.
//
// Arguments:
//	table_handle: Handle to the table.
//
//
//
// Returns:
//	keys: Vector of all keys present in the table.
//	values: Tensor of all values in the table. Indexed in parallel with `keys`.
func LookupTableExportV2(scope *Scope, table_handle tf.Output, Tkeys tf.DataType, Tvalues tf.DataType) (keys tf.Output, values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tkeys": Tkeys, "Tvalues": Tvalues}
	opspec := tf.OpSpec{
		Type: "LookupTableExportV2",
		Input: []tf.Input{
			table_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Splits a tensor into a list.
//
// list[i] corresponds to lengths[i] tensors from the input tensor.
// The tensor must have rank at least 1 and contain exactly sum(lengths) elements.
//
// tensor: The input tensor.
// element_shape: A shape compatible with that of elements in the tensor.
// lengths: Vector of sizes of the 0th dimension of tensors in the list.
// output_handle: The list.
func TensorListSplit(scope *Scope, tensor tf.Output, element_shape tf.Output, lengths tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListSplit",
		Input: []tf.Input{
			tensor, element_shape, lengths,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseSingleSequenceExampleAttr is an optional argument to ParseSingleSequenceExample.
type ParseSingleSequenceExampleAttr func(optionalAttr)

// ParseSingleSequenceExampleContextSparseTypes sets the optional context_sparse_types attribute to value.
//
// value: A list of Ncontext_sparse types; the data types of data in
// each context Feature given in context_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleContextSparseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_sparse_types"] = value
	}
}

// ParseSingleSequenceExampleFeatureListDenseTypes sets the optional feature_list_dense_types attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListDenseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_types"] = value
	}
}

// ParseSingleSequenceExampleContextDenseShapes sets the optional context_dense_shapes attribute to value.
//
// value: A list of Ncontext_dense shapes; the shapes of data in
// each context Feature given in context_dense_keys.
// The number of elements in the Feature corresponding to context_dense_key[j]
// must always equal context_dense_shapes[j].NumEntries().
// The shape of context_dense_values[j] will match context_dense_shapes[j].
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleContextDenseShapes(value []tf.Shape) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_dense_shapes"] = value
	}
}

// ParseSingleSequenceExampleFeatureListSparseTypes sets the optional feature_list_sparse_types attribute to value.
//
// value: A list of Nfeature_list_sparse types; the data types
// of data in each FeatureList given in feature_list_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListSparseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_sparse_types"] = value
	}
}

// ParseSingleSequenceExampleFeatureListDenseShapes sets the optional feature_list_dense_shapes attribute to value.
//
// value: A list of Nfeature_list_dense shapes; the shapes of
// data in each FeatureList given in feature_list_dense_keys.
// The shape of each Feature in the FeatureList corresponding to
// feature_list_dense_key[j] must always equal
// feature_list_dense_shapes[j].NumEntries().
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListDenseShapes(value []tf.Shape) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_shapes"] = value
	}
}

// Transforms a scalar brain.SequenceExample proto (as strings) into typed tensors.
//
// Arguments:
//	serialized: A scalar containing a binary serialized SequenceExample proto.
//	feature_list_dense_missing_assumed_empty: A vector listing the
// FeatureList keys which may be missing from the SequenceExample.  If the
// associated FeatureList is missing, it is treated as empty.  By default,
// any FeatureList not listed in this vector must exist in the SequenceExample.
//	context_sparse_keys: A list of Ncontext_sparse string Tensors (scalars).
// The keys expected in the Examples' features associated with context_sparse
// values.
//	context_dense_keys: A list of Ncontext_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' context features associated with
// dense values.
//	feature_list_sparse_keys: A list of Nfeature_list_sparse string Tensors
// (scalars).  The keys expected in the FeatureLists associated with sparse
// values.
//	feature_list_dense_keys: A list of Nfeature_list_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' feature_lists associated
// with lists of dense values.
//	context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
// context_dense_defaults[j] provides default values
// when the SequenceExample's context map lacks context_dense_key[j].
// If an empty Tensor is provided for context_dense_defaults[j],
// then the Feature context_dense_keys[j] is required.
// The input type is inferred from context_dense_defaults[j], even when it's
// empty.  If context_dense_defaults[j] is not empty, its shape must match
// context_dense_shapes[j].
//	debug_name: A scalar containing the name of the serialized proto.
// May contain, for example, table key (descriptive) name for the
// corresponding serialized proto.  This is purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty scalar if no name is available.
func ParseSingleSequenceExample(scope *Scope, serialized tf.Output, feature_list_dense_missing_assumed_empty tf.Output, context_sparse_keys []tf.Output, context_dense_keys []tf.Output, feature_list_sparse_keys []tf.Output, feature_list_dense_keys []tf.Output, context_dense_defaults []tf.Output, debug_name tf.Output, optional ...ParseSingleSequenceExampleAttr) (context_sparse_indices []tf.Output, context_sparse_values []tf.Output, context_sparse_shapes []tf.Output, context_dense_values []tf.Output, feature_list_sparse_indices []tf.Output, feature_list_sparse_values []tf.Output, feature_list_sparse_shapes []tf.Output, feature_list_dense_values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseSingleSequenceExample",
		Input: []tf.Input{
			serialized, feature_list_dense_missing_assumed_empty, tf.OutputList(context_sparse_keys), tf.OutputList(context_dense_keys), tf.OutputList(feature_list_sparse_keys), tf.OutputList(feature_list_dense_keys), tf.OutputList(context_dense_defaults), debug_name,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if context_sparse_indices, idx, err = makeOutputList(op, idx, "context_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_sparse_values, idx, err = makeOutputList(op, idx, "context_sparse_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_sparse_shapes, idx, err = makeOutputList(op, idx, "context_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_dense_values, idx, err = makeOutputList(op, idx, "context_dense_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_indices, idx, err = makeOutputList(op, idx, "feature_list_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_values, idx, err = makeOutputList(op, idx, "feature_list_sparse_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_shapes, idx, err = makeOutputList(op, idx, "feature_list_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_dense_values, idx, err = makeOutputList(op, idx, "feature_list_dense_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	return context_sparse_indices, context_sparse_values, context_sparse_shapes, context_dense_values, feature_list_sparse_indices, feature_list_sparse_values, feature_list_sparse_shapes, feature_list_dense_values
}

// Check if the input matches the regex pattern.
//
// The input is a string tensor of any shape. The pattern is the
// regular expression to be matched with every element of the input tensor.
// The boolean values (True or False) of the output tensor indicate
// if the input matches the regex pattern provided.
//
// The pattern follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: A string tensor of the text to be processed.
//	pattern: The regular expression to match the input.
//
// Returns A bool tensor with the same shape as `input`.
func StaticRegexFullMatch(scope *Scope, input tf.Output, pattern string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pattern": pattern}
	opspec := tf.OpSpec{
		Type: "StaticRegexFullMatch",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the number of elements in the given table.
//
// Arguments:
//	table_handle: Handle to the table.
//
// Returns Scalar that contains number of elements in the table.
func LookupTableSizeV2(scope *Scope, table_handle tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableSizeV2",
		Input: []tf.Input{
			table_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op which supports basic einsum op with 2 inputs and 1 output.
//
// This op has better TPU performance since it doesn't have explicitly reshape and
// transpose operations as tf.einsum does.
func XlaEinsum(scope *Scope, a tf.Output, b tf.Output, equation string) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"equation": equation}
	opspec := tf.OpSpec{
		Type: "XlaEinsum",
		Input: []tf.Input{
			a, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Extracts the average gradient in the given ConditionalAccumulator.
//
// The op blocks until sufficient (i.e., more than num_required)
// gradients have been accumulated.  If the accumulator has already
// aggregated more than num_required gradients, it returns the average of
// the accumulated gradients.  Also automatically increments the recorded
// global_step in the accumulator by 1, and resets the aggregate to 0.
//
// Arguments:
//	handle: The handle to an accumulator.
//	num_required: Number of gradients required before we return an aggregate.
//	dtype: The data type of accumulated gradients. Needs to correspond to the type
// of the accumulator.
//
// Returns The average of the accumulated gradients.
func ResourceAccumulatorTakeGradient(scope *Scope, handle tf.Output, num_required tf.Output, dtype tf.DataType) (average tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "ResourceAccumulatorTakeGradient",
		Input: []tf.Input{
			handle, num_required,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// InfeedEnqueueAttr is an optional argument to InfeedEnqueue.
type InfeedEnqueueAttr func(optionalAttr)

// InfeedEnqueueShape sets the optional shape attribute to value.
//
// value: The shape of the tensor.
// If not specified, defaults to {}
func InfeedEnqueueShape(value tf.Shape) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["shape"] = value
	}
}

// InfeedEnqueueLayout sets the optional layout attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence.
// If a layout attribute is passed, but its values are all -1, the layout will
// be computed by the infeed operation.
// If not specified, defaults to {}
func InfeedEnqueueLayout(value []int64) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["layout"] = value
	}
}

// InfeedEnqueueDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func InfeedEnqueueDeviceOrdinal(value int64) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op which feeds a single Tensor value into the computation.
//
// Arguments:
//	input: A tensor that will be provided using the infeed mechanism.
//
// Returns the created operation.
func InfeedEnqueue(scope *Scope, input tf.Output, optional ...InfeedEnqueueAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueue",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes inverse hyperbolic sine of x element-wise.
//
//   Given an input tensor, this function computes inverse hyperbolic sine
//   for every element in the tensor. Both input and output has a range of
//   `[-inf, inf]`.
//
//   ```python
//   x = tf.constant([-float("inf"), -2, -0.5, 1, 1.2, 200, 10000, float("inf")])
//   tf.math.asinh(x) ==> [-inf -1.4436355 -0.4812118 0.8813736 1.0159732 5.991471 9.903487 inf]
//   ```
func Asinh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Asinh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Looks up keys in a table, outputs the corresponding values.
//
// The tensor `keys` must of the same type as the keys of the table.
// The output `values` is of the type of the table values.
//
// The scalar `default_value` is the value output for keys not present in the
// table. It must also be of the same type as the table values.
//
// Arguments:
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//
//
// Returns Same shape as `keys`.  Values found in the table, or `default_values`
// for missing keys.
func LookupTableFindV2(scope *Scope, table_handle tf.Output, keys tf.Output, default_value tf.Output) (values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableFindV2",
		Input: []tf.Input{
			table_handle, keys, default_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradAttr is an optional argument to MaxPoolGrad.
type MaxPoolGradAttr func(optionalAttr)

// MaxPoolGradExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to {}
func MaxPoolGradExplicitPaddings(value []int64) MaxPoolGradAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// MaxPoolGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradDataFormat(value string) MaxPoolGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients w.r.t. the output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input to `max_pool`.
func MaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Rolls the elements of a tensor along an axis.
//
// The elements are shifted positively (towards larger indices) by the offset of
// `shift` along the dimension of `axis`. Negative `shift` values will shift
// elements in the opposite direction. Elements that roll passed the last position
// will wrap around to the first and vice versa. Multiple shifts along multiple
// axes may be specified.
//
// For example:
//
// ```
// # 't' is [0, 1, 2, 3, 4]
// roll(t, shift=2, axis=0) ==> [3, 4, 0, 1, 2]
//
// # shifting along multiple dimensions
// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
// roll(t, shift=[1, -2], axis=[0, 1]) ==> [[7, 8, 9, 5, 6], [2, 3, 4, 0, 1]]
//
// # shifting along the same axis multiple times
// # 't' is [[0, 1, 2, 3, 4], [5, 6, 7, 8, 9]]
// roll(t, shift=[2, -3], axis=[1, 1]) ==> [[1, 2, 3, 4, 0], [6, 7, 8, 9, 5]]
// ```
//
// Arguments:
//
//	shift: Dimension must be 0-D or 1-D. `shift[i]` specifies the number of places by which
// elements are shifted positively (towards larger indices) along the dimension
// specified by `axis[i]`. Negative shifts will roll the elements in the opposite
// direction.
//	axis: Dimension must be 0-D or 1-D. `axis[i]` specifies the dimension that the shift
// `shift[i]` should occur. If the same axis is referenced more than once, the
// total shift for that axis will be the sum of all the shifts that belong to that
// axis.
//
// Returns Has the same shape and size as the input. The elements are shifted
// positively (towards larger indices) by the offsets of `shift` along the
// dimensions of `axis`.
func Roll(scope *Scope, input tf.Output, shift tf.Output, axis tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Roll",
		Input: []tf.Input{
			input, shift, axis,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapUnstageAttr is an optional argument to OrderedMapUnstage.
type OrderedMapUnstageAttr func(optionalAttr)

// OrderedMapUnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageCapacity(value int64) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapUnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageMemoryLimit(value int64) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapUnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageContainer(value string) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapUnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageSharedName(value string) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the values associated with the key
//
// from the underlying container.   If the underlying container
// does not contain this key, the op will block until it does.
func OrderedMapUnstage(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapUnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapUnstage",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapUnstage", err)
		return
	}
	return values
}

// SobolSampleAttr is an optional argument to SobolSample.
type SobolSampleAttr func(optionalAttr)

// SobolSampleDtype sets the optional dtype attribute to value.
//
// value: The type of the sample. One of: `float32` or `float64`.
// If not specified, defaults to DT_FLOAT
func SobolSampleDtype(value tf.DataType) SobolSampleAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Generates points from the Sobol sequence.
//
// Creates a Sobol sequence with `num_results` samples. Each sample has dimension
// `dim`. Skips the first `skip` samples.
//
// Arguments:
//	dim: Positive scalar `Tensor` representing each sample's dimension.
//	num_results: Positive scalar `Tensor` of dtype int32. The number of Sobol points to return
// in the output.
//	skip: Positive scalar `Tensor` of dtype int32. The number of initial points of the
// Sobol sequence to skip.
//
// Returns `Tensor` of samples from Sobol sequence with `shape` [num_results, dim].
func SobolSample(scope *Scope, dim tf.Output, num_results tf.Output, skip tf.Output, optional ...SobolSampleAttr) (samples tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SobolSample",
		Input: []tf.Input{
			dim, num_results, skip,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedReluAttr is an optional argument to QuantizedRelu.
type QuantizedReluAttr func(optionalAttr)

// QuantizedReluOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedReluOutType(value tf.DataType) QuantizedReluAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Computes Quantized Rectified Linear: `max(features, 0)`
//
// Arguments:
//
//	min_features: The float value that the lowest quantized value represents.
//	max_features: The float value that the highest quantized value represents.
//
// Returns:
//	activations: Has the same output shape as "features".
//	min_activations: The float value that the lowest quantized value represents.
//	max_activations: The float value that the highest quantized value represents.
func QuantizedRelu(scope *Scope, features tf.Output, min_features tf.Output, max_features tf.Output, optional ...QuantizedReluAttr) (activations tf.Output, min_activations tf.Output, max_activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedRelu",
		Input: []tf.Input{
			features, min_features, max_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Returns the next representable value of `x1` in the direction of `x2`, element-wise.
//
// This operation returns the same result as the C++ std::nextafter function.
//
// It can also return a subnormal number.
//
// @compatibility(cpp)
// Equivalent to C++ std::nextafter function.
// @end_compatibility
func NextAfter(scope *Scope, x1 tf.Output, x2 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NextAfter",
		Input: []tf.Input{
			x1, x2,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Bucketizes 'input' based on 'boundaries'.
//
// For example, if the inputs are
//     boundaries = [0, 10, 100]
//     input = [[-5, 10000]
//              [150,   10]
//              [5,    100]]
//
// then the output will be
//     output = [[0, 3]
//               [3, 2]
//               [1, 3]]
//
// Arguments:
//	input: Any shape of Tensor contains with int or float type.
//	boundaries: A sorted list of floats gives the boundary of the buckets.
//
// Returns Same shape with 'input', each value of input replaced with bucket index.
//
// @compatibility(numpy)
// Equivalent to np.digitize.
// @end_compatibility
func Bucketize(scope *Scope, input tf.Output, boundaries []float32) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"boundaries": boundaries}
	opspec := tf.OpSpec{
		Type: "Bucketize",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the log of the absolute value of `Gamma(x)` element-wise.
//
//   For positive numbers, this function computes log((input - 1)!) for every element in the tensor.
//   `lgamma(5) = log((5-1)!) = log(4!) = log(24) = 3.1780539`
//
// Example:
//
// ```python
// x = tf.constant([0, 0.5, 1, 4.5, -4, -5.6])
// tf.math.lgamma(x) ==> [inf, 0.5723649, 0., 2.4537368, inf, -4.6477685]
// ```
func Lgamma(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Lgamma",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reads the value of a variable.
//
// The tensor returned by this operation is immutable.
//
// The value returned by this operation is guaranteed to be influenced by all the
// writes on which this operation depends directly or indirectly, and to not be
// influenced by any of the writes which depend directly or indirectly on this
// operation.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	dtype: the dtype of the value.
func ReadVariableOp(scope *Scope, resource tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "ReadVariableOp",
		Input: []tf.Input{
			resource,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes a range that covers the actual values present in a quantized tensor.
//
// Given a quantized tensor described by `(input, input_min, input_max)`, outputs a
// range that covers the actual values present in that tensor. This op is typically
// used to produce the `requested_output_min` and `requested_output_max` for
// `Requantize`.
//
// Arguments:
//
//	input_min: The float value that the minimum quantized input value represents.
//	input_max: The float value that the maximum quantized input value represents.
//
// Returns:
//	output_min: The computed min output.
//	output_max: the computed max output.
func RequantizationRange(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output) (output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RequantizationRange",
		Input: []tf.Input{
			input, input_min, input_max,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Tensor contraction according to Einstein summation convention.
//
// Implements generalized Tensor contraction and reduction. Each input Tensor must
// have a corresponding input subscript appearing in the comma-separated left-hand
// side of the equation. The right-hand side of the equation consists of the
// output subscript. The input subscripts and the output subscript should consist
// of zero or more named axis labels and at most one ellipsis (`...`).
//
// The named axis labels may be any single character other than those having
// special meaning, namely `,.->`. The behavior of this Op is undefined if it
// receives an ill-formatted equation; since the validation is done at
// graph-building time, we omit format validation checks at runtime.
//
// Note: This Op is *not* intended to be called by the user; instead users should
// call `tf.einsum` directly. It is a hidden Op used by `tf.einsum`.
//
// Operations are applied to the input(s) according to the following rules:
//
//  (a) Generalized Diagonals: For input dimensions corresponding to axis labels
//      appearing more than once in the same input subscript, we take the
//      generalized (`k`-dimensional) diagonal.
//      For example, in the equation `iii->i` with input shape `[3, 3, 3]`, the
//      generalized diagonal would consist of `3` elements at indices `(0, 0, 0)`,
//      `(1, 1, 1)` and `(2, 2, 2)` to create a Tensor of shape `[3]`.
//
//  (b) Reduction: Axes corresponding to labels appearing only in one input
//      subscript but not in the output subscript are summed over prior to Tensor
//      contraction.
//      For example, in the equation `ab,bc->b`, the axis labels `a` and `c` are
//      the reduction axis labels.
//
//  (c) Batch Dimensions: Axes corresponding to labels appearing in each of the
//      input subscripts and also in the output subscript make up the batch
//      dimensions in Tensor contraction. Unnamed axis labels corresponding to
//      ellipsis (`...`) also correspond to batch dimensions.
//      For example, for the equation denoting batch matrix multiplication,
//      `bij,bjk->bik`, the axis label `b` corresponds to a batch dimension.
//
//  (d) Contraction: In case of binary einsum, axes corresponding to labels
//      appearing in two different inputs (and not in the output) are contracted
//      against each other.
//      Considering the batch matrix multiplication equation again
//      (`bij,bjk->bik`), the contracted axis label is `j`.
//
//  (e) Expand Diagonal: If the output subscripts contain repeated (explicit) axis
//      labels, the opposite operation of (a) is applied. For example, in the
//      equation `i->iii`, and input shape `[3]`, the output of shape `[3, 3, 3]`
//      are all zeros, except for the (generalized) diagonal which is populated
//      with values from the input.
//      Note: This operation is not supported by `np.einsum` or `tf.einsum`; it is
//      provided to enable computing the symbolic gradient of `tf.einsum`.
//
// The output subscripts must contain only labels appearing in at least one of the
// input subscripts. Furthermore, all dimensions mapping to the same axis label
// must be equal.
//
// Any of the input and output subscripts may contain at most a single ellipsis
// (`...`). These ellipsis are mapped against dimensions not corresponding to any
// named axis label. If two inputs contain ellipsis, then they are broadcasted
// according to standard NumPy broadcasting
// [rules](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
// The broadcasted dimensions are placed in the corresponding location of the
// ellipsis in the output subscript. If the broadcasted dimensions are non-empty
// and the output subscripts do not contain ellipsis, then an InvalidArgument error
// is raised.
//
// @compatibility(numpy)
// Similar to [`numpy.einsum`](https://docs.scipy.org/doc/numpy/reference/generated/numpy.einsum.html).
//
// Comparison with `numpy.einsum`:
//
//  * This Op only supports unary and binary forms of `numpy.einsum`.
//  * This Op does not support implicit form. (i.e. equations without `->`).
//  * This Op also supports repeated indices in the output subscript, which is not
//    supported by `numpy.einsum`.
// @end_compatibility
//
//
// Arguments:
//	inputs: List of 1 or 2 Tensors.
//	equation: String describing the Einstein Summation operation; in the format of np.einsum.
//
// Returns Output Tensor with shape depending upon `equation`.
func Einsum(scope *Scope, inputs []tf.Output, equation string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"equation": equation}
	opspec := tf.OpSpec{
		Type: "Einsum",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Convert the quantized 'input' tensor into a lower-precision 'output', using the
//
// actual distribution of the values to maximize the usage of the lower bit depth
// and adjusting the output min and max ranges accordingly.
//
// [input_min, input_max] are scalar floats that specify the range for the float
// interpretation of the 'input' data. For example, if input_min is -1.0f and
// input_max is 1.0f, and we are dealing with quint16 quantized data, then a 0
// value in the 16-bit data should be interpreted as -1.0f, and a 65535 means 1.0f.
//
// This operator tries to squeeze as much precision as possible into an output with
// a lower bit depth by calculating the actual min and max values found in the
// data. For example, maybe that quint16 input has no values lower than 16,384 and
// none higher than 49,152. That means only half the range is actually needed, all
// the float interpretations are between -0.5f and 0.5f, so if we want to compress
// the data into a quint8 output, we can use that range rather than the theoretical
// -1.0f to 1.0f that is suggested by the input min and max.
//
// In practice, this is most useful for taking output from operations like
// QuantizedMatMul that can produce higher bit-depth outputs than their inputs and
// may have large potential output ranges, but in practice have a distribution of
// input values that only uses a small fraction of the possible range. By feeding
// that output into this operator, we can reduce it from 32 bits down to 8 with
// minimal loss of accuracy.
//
// Arguments:
//
//	input_min: The float value that the minimum quantized input value represents.
//	input_max: The float value that the maximum quantized input value represents.
//	out_type: The type of the output. Should be a lower bit depth than Tinput.
//
// Returns:
//	output
//	output_min: The float value that the minimum quantized output value represents.
//	output_max: The float value that the maximum quantized output value represents.
func QuantizeDownAndShrinkRange(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, out_type tf.DataType) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "QuantizeDownAndShrinkRange",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Converts each string in the input Tensor to its hash mod by a number of buckets.
//
// The hash function is deterministic on the content of the string within the
// process.
//
// Note that the hash function may change from time to time.
// This functionality will be deprecated and it's recommended to use
// `tf.string_to_hash_bucket_fast()` or `tf.string_to_hash_bucket_strong()`.
//
// Arguments:
//
//	num_buckets: The number of buckets.
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToHashBucket(scope *Scope, string_tensor tf.Output, num_buckets int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "StringToHashBucket",
		Input: []tf.Input{
			string_tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softsign: `features / (abs(features) + 1)`.
func Softsign(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Softsign",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedAddAttr is an optional argument to QuantizedAdd.
type QuantizedAddAttr func(optionalAttr)

// QuantizedAddToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedAddToutput(value tf.DataType) QuantizedAddAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// Returns x + y element-wise, working on quantized buffers.
//
// Arguments:
//
//
//	min_x: The float value that the lowest quantized `x` value represents.
//	max_x: The float value that the highest quantized `x` value represents.
//	min_y: The float value that the lowest quantized `y` value represents.
//	max_y: The float value that the highest quantized `y` value represents.
//
// Returns:
//	z
//	min_z: The float value that the lowest quantized output value represents.
//	max_z: The float value that the highest quantized output value represents.
//
// *NOTE*: `QuantizedAdd` supports limited forms of broadcasting. More about
// broadcasting [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func QuantizedAdd(scope *Scope, x tf.Output, y tf.Output, min_x tf.Output, max_x tf.Output, min_y tf.Output, max_y tf.Output, optional ...QuantizedAddAttr) (z tf.Output, min_z tf.Output, max_z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedAdd",
		Input: []tf.Input{
			x, y, min_x, max_x, min_y, max_y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ShuffleAndRepeatDatasetAttr is an optional argument to ShuffleAndRepeatDataset.
type ShuffleAndRepeatDatasetAttr func(optionalAttr)

// ShuffleAndRepeatDatasetReshuffleEachIteration sets the optional reshuffle_each_iteration attribute to value.
// If not specified, defaults to true
func ShuffleAndRepeatDatasetReshuffleEachIteration(value bool) ShuffleAndRepeatDatasetAttr {
	return func(m optionalAttr) {
		m["reshuffle_each_iteration"] = value
	}
}

// ShuffleAndRepeatDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func ShuffleAndRepeatDatasetMetadata(value string) ShuffleAndRepeatDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that shuffles and repeats elements from `input_dataset`
//
// pseudorandomly.
//
// Arguments:
//
//	buffer_size: The number of output elements to buffer in an iterator over
// this dataset. Compare with the `min_after_dequeue` attr when creating a
// `RandomShuffleQueue`.
//	seed: A scalar seed for the random number generator. If either `seed` or
// `seed2` is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//	count: A scalar representing the number of times the underlying dataset
// should be repeated. The default is `-1`, which results in infinite repetition.
//
//
func ShuffleAndRepeatDataset(scope *Scope, input_dataset tf.Output, buffer_size tf.Output, seed tf.Output, seed2 tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ShuffleAndRepeatDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShuffleAndRepeatDataset",
		Input: []tf.Input{
			input_dataset, buffer_size, seed, seed2, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMulAttr is an optional argument to QuantizedMul.
type QuantizedMulAttr func(optionalAttr)

// QuantizedMulToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMulToutput(value tf.DataType) QuantizedMulAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// Returns x * y element-wise, working on quantized buffers.
//
// Arguments:
//
//
//	min_x: The float value that the lowest quantized `x` value represents.
//	max_x: The float value that the highest quantized `x` value represents.
//	min_y: The float value that the lowest quantized `y` value represents.
//	max_y: The float value that the highest quantized `y` value represents.
//
// Returns:
//	z
//	min_z: The float value that the lowest quantized output value represents.
//	max_z: The float value that the highest quantized output value represents.
//
// *NOTE*: `QuantizedMul` supports limited forms of broadcasting. More about
// broadcasting [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func QuantizedMul(scope *Scope, x tf.Output, y tf.Output, min_x tf.Output, max_x tf.Output, min_y tf.Output, max_y tf.Output, optional ...QuantizedMulAttr) (z tf.Output, min_z tf.Output, max_z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMul",
		Input: []tf.Input{
			x, y, min_x, max_x, min_y, max_y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// CumulativeLogsumexpAttr is an optional argument to CumulativeLogsumexp.
type CumulativeLogsumexpAttr func(optionalAttr)

// CumulativeLogsumexpExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumulative log-sum-exp.
// If not specified, defaults to false
func CumulativeLogsumexpExclusive(value bool) CumulativeLogsumexpAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumulativeLogsumexpReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumulativeLogsumexpReverse(value bool) CumulativeLogsumexpAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative product of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumulative log-sum-exp,
// which means that the first
// element of the input is identical to the first element of the output:
// ```python
// tf.math.cumulative_logsumexp([a, b, c])  # => [a, log(exp(a) + exp(b)), log(exp(a) + exp(b) + exp(c))]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumulative log-sum-exp is
// performed instead:
// ```python
// tf.cumulative_logsumexp([a, b, c], exclusive=True)  # => [-inf, a, log(exp(a) * exp(b))]
// ```
// Note that the neutral element of the log-sum-exp operation is `-inf`,
// however, for performance reasons, the minimal value representable by the
// floating point type is used instead.
//
// By setting the `reverse` kwarg to `True`, the cumulative log-sum-exp is performed in the
// opposite direction.
//
// Arguments:
//	x: A `Tensor`. Must be one of the following types: `float16`, `float32`, `float64`.
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
// `[-rank(x), rank(x))`.
func CumulativeLogsumexp(scope *Scope, x tf.Output, axis tf.Output, optional ...CumulativeLogsumexpAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CumulativeLogsumexp",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseBincountAttr is an optional argument to SparseBincount.
type SparseBincountAttr func(optionalAttr)

// SparseBincountBinaryOutput sets the optional binary_output attribute to value.
//
// value: bool; Whether the kernel should count the appearance or number of occurrences.
// If not specified, defaults to false
func SparseBincountBinaryOutput(value bool) SparseBincountAttr {
	return func(m optionalAttr) {
		m["binary_output"] = value
	}
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	indices: 2D int64 `Tensor`.
//	values: 1D int `Tensor`.
//	dense_shape: 1D int64 `Tensor`.
//	size: non-negative int scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `input`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size` or 2D `Tensor` with [batch_size, `size`].
// The counts or summed weights for each value in the range [0, size).
func SparseBincount(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output, size tf.Output, weights tf.Output, optional ...SparseBincountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseBincount",
		Input: []tf.Input{
			indices, values, dense_shape, size, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes scaled exponential linear: `scale * alpha * (exp(features) - 1)`
//
// if < 0, `scale * features` otherwise.
//
// To be used together with
// `initializer = tf.variance_scaling_initializer(factor=1.0, mode='FAN_IN')`.
// For correct dropout, use `tf.contrib.nn.alpha_dropout`.
//
// See [Self-Normalizing Neural Networks](https://arxiv.org/abs/1706.02515)
func Selu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Selu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DenseBincountAttr is an optional argument to DenseBincount.
type DenseBincountAttr func(optionalAttr)

// DenseBincountBinaryOutput sets the optional binary_output attribute to value.
//
// value: bool; Whether the kernel should count the appearance or number of occurrences.
// If not specified, defaults to false
func DenseBincountBinaryOutput(value bool) DenseBincountAttr {
	return func(m optionalAttr) {
		m["binary_output"] = value
	}
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	input: 1D or 2D int `Tensor`.
//	size: non-negative int scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `arr`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size` or 2D `Tensor` with [batch_size, `size`].
// The counts or summed weights for each value in the range [0, size).
func DenseBincount(scope *Scope, input tf.Output, size tf.Output, weights tf.Output, optional ...DenseBincountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseBincount",
		Input: []tf.Input{
			input, size, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the complex conjugate of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// complex numbers that are the complex conjugate of each element in `input`. The
// complex numbers in `input` must be of the form \\(a + bj\\), where *a* is the
// real part and *b* is the imaginary part.
//
// The complex conjugate returned by this operation is of the form \\(a - bj\\).
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.conj(input) ==> [-2.25 - 4.75j, 3.25 - 5.75j]
// ```
func Conj(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Conj",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ImagAttr is an optional argument to Imag.
type ImagAttr func(optionalAttr)

// ImagTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func ImagTout(value tf.DataType) ImagAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the imaginary part of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the imaginary part of each element in `input`. All
// elements in `input` must be complex numbers of the form \\(a + bj\\), where *a*
// is the real part and *b* is the imaginary part returned by this operation.
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.imag(input) ==> [4.75, 5.75]
// ```
func Imag(scope *Scope, input tf.Output, optional ...ImagAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Imag",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RealAttr is an optional argument to Real.
type RealAttr func(optionalAttr)

// RealTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func RealTout(value tf.DataType) RealAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the real part of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the real part of each element in `input`. All elements in
// `input` must be complex numbers of the form \\(a + bj\\), where *a* is the real
//  part returned by this operation and *b* is the imaginary part.
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.real(input) ==> [-2.25, 3.25]
// ```
func Real(scope *Scope, input tf.Output, optional ...RealAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Real",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DequantizeAttr is an optional argument to Dequantize.
type DequantizeAttr func(optionalAttr)

// DequantizeMode sets the optional mode attribute to value.
// If not specified, defaults to "MIN_COMBINED"
func DequantizeMode(value string) DequantizeAttr {
	return func(m optionalAttr) {
		m["mode"] = value
	}
}

// DequantizeNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func DequantizeNarrowRange(value bool) DequantizeAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// DequantizeAxis sets the optional axis attribute to value.
// If not specified, defaults to -1
func DequantizeAxis(value int64) DequantizeAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// DequantizeDtype sets the optional dtype attribute to value.
//
// value: Type of the output tensor. Currently Dequantize supports float and bfloat16.
// If 'dtype' is 'bfloat16', it only supports 'MIN_COMBINED' mode.
// If not specified, defaults to DT_FLOAT
func DequantizeDtype(value tf.DataType) DequantizeAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Dequantize the 'input' tensor into a float or bfloat16 Tensor.
//
// [min_range, max_range] are scalar floats that specify the range for
// the output. The 'mode' attribute controls exactly which calculations are
// used to convert the float values to their quantized equivalents.
//
// In 'MIN_COMBINED' mode, each value of the tensor will undergo the following:
//
// ```
// if T == qint8: in[i] += (range(T) + 1)/ 2.0
// out[i] = min_range + (in[i]* (max_range - min_range) / range(T))
// ```
// here `range(T) = numeric_limits<T>::max() - numeric_limits<T>::min()`
//
// *MIN_COMBINED Mode Example*
//
// If the input comes from a QuantizedRelu6, the output type is
// quint8 (range of 0-255) but the possible range of QuantizedRelu6 is
// 0-6.  The min_range and max_range values are therefore 0.0 and 6.0.
// Dequantize on quint8 will take each value, cast to float, and multiply
// by 6 / 255.
// Note that if quantizedtype is qint8, the operation will additionally add
// each value by 128 prior to casting.
//
// If the mode is 'MIN_FIRST', then this approach is used:
//
// ```c++
// num_discrete_values = 1 << (# of bits in T)
// range_adjust = num_discrete_values / (num_discrete_values - 1)
// range = (range_max - range_min) * range_adjust
// range_scale = range / num_discrete_values
// const double offset_input = static_cast<double>(input) - lowest_quantized;
// result = range_min + ((input - numeric_limits<T>::min()) * range_scale)
// ```
//
// If the mode is `SCALED`, dequantization is performed by multiplying each
// input value by a scaling_factor. (Thus an input of 0 always maps to 0.0).
//
// The scaling_factor is determined from `min_range`, `max_range`, and
// `narrow_range` in a way that is compatible with `QuantizeAndDequantize{V2|V3}`
// and `QuantizeV2`, using the following algorithm:
//
// ```c++
//
//   const int min_expected_T = std::numeric_limits<T>::min() +
//     (narrow_range ? 1 : 0);
//   const int max_expected_T = std::numeric_limits<T>::max();
//   const float max_expected_T = std::numeric_limits<float>::max();
//
//   const float scale_factor =
//     (std::numeric_limits<T>::min() == 0) ? (max_range / max_expected_T)
//                                          : std::max(min_range / min_expected_T,
//                                                     max_range / max_expected_T);
// ```
//
// Arguments:
//
//	min_range: The minimum scalar value possibly produced for the input.
//	max_range: The maximum scalar value possibly produced for the input.
func Dequantize(scope *Scope, input tf.Output, min_range tf.Output, max_range tf.Output, optional ...DequantizeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Dequantize",
		Input: []tf.Input{
			input, min_range, max_range,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ComplexAttr is an optional argument to Complex.
type ComplexAttr func(optionalAttr)

// ComplexTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_COMPLEX64
func ComplexTout(value tf.DataType) ComplexAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Converts two real numbers to a complex number.
//
// Given a tensor `real` representing the real part of a complex number, and a
// tensor `imag` representing the imaginary part of a complex number, this
// operation returns complex numbers elementwise of the form \\(a + bj\\), where
// *a* represents the `real` part and *b* represents the `imag` part.
//
// The input tensors `real` and `imag` must have the same shape.
//
// For example:
//
// ```
// # tensor 'real' is [2.25, 3.25]
// # tensor `imag` is [4.75, 5.75]
// tf.complex(real, imag) ==> [[2.25 + 4.75j], [3.25 + 5.75j]]
// ```
func Complex(scope *Scope, real tf.Output, imag tf.Output, optional ...ComplexAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Complex",
		Input: []tf.Input{
			real, imag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNCanonicalToParamsV2Attr is an optional argument to CudnnRNNCanonicalToParamsV2.
type CudnnRNNCanonicalToParamsV2Attr func(optionalAttr)

// CudnnRNNCanonicalToParamsV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNCanonicalToParamsV2RnnMode(value string) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNCanonicalToParamsV2InputMode(value string) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNCanonicalToParamsV2Direction(value string) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2Dropout(value float32) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2Seed(value int64) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2Seed2(value int64) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNCanonicalToParamsV2NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2NumProj(value int64) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// Converts CudnnRNN params from canonical form to usable form. It supports the projection in LSTM.
//
// Writes a set of weights into the opaque params buffer so they can be used in
// upcoming training or inferences.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// weights: the canonical form of weights that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// biases: the canonical form of biases that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// num_params_weights: number of weight parameter matrix for all layers.
// num_params_biases: number of bias parameter vector for all layers.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     The actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//     dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
// num_proj: The output dimensionality for the projection matrices. If None or 0,
//     no projection is performed.
func CudnnRNNCanonicalToParamsV2(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, weights []tf.Output, biases []tf.Output, optional ...CudnnRNNCanonicalToParamsV2Attr) (params tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNCanonicalToParamsV2",
		Input: []tf.Input{
			num_layers, num_units, input_size, tf.OutputList(weights), tf.OutputList(biases),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a sequence of numbers.
//
// This operation creates a sequence of numbers that begins at `start` and
// extends by increments of `delta` up to but not including `limit`.
//
// For example:
//
// ```
// # 'start' is 3
// # 'limit' is 18
// # 'delta' is 3
// tf.range(start, limit, delta) ==> [3, 6, 9, 12, 15]
// ```
//
// Arguments:
//	start: 0-D (scalar). First entry in the sequence.
//	limit: 0-D (scalar). Upper limit of sequence, exclusive.
//	delta: 0-D (scalar). Optional. Default is 1. Number that increments `start`.
//
// Returns 1-D.
func Range(scope *Scope, start tf.Output, limit tf.Output, delta tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Range",
		Input: []tf.Input{
			start, limit, delta,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AnyAttr is an optional argument to Any.
type AnyAttr func(optionalAttr)

// AnyKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func AnyKeepDims(value bool) AnyAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the "logical or" of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Any(scope *Scope, input tf.Output, axis tf.Output, optional ...AnyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Any",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of morphological 2-D dilation with respect to the input.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
// Must be: `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, in_height, in_width, depth]`.
func Dilation2DBackpropInput(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (in_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropInput",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AllAttr is an optional argument to All.
type AllAttr func(optionalAttr)

// AllKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func AllKeepDims(value bool) AllAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the "logical and" of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func All(scope *Scope, input tf.Output, axis tf.Output, optional ...AllAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "All",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes gradients for SparseSegmentSqrtN.
//
// Returns tensor "output" with same shape as grad, except for dimension 0 whose
// value is output_dim0.
//
// Arguments:
//	grad: gradient propagated to the SparseSegmentSqrtN op.
//	indices: indices passed to the corresponding SparseSegmentSqrtN op.
//	segment_ids: segment_ids passed to the corresponding SparseSegmentSqrtN op.
//	output_dim0: dimension 0 of "data" passed to SparseSegmentSqrtN op.
func SparseSegmentSqrtNGrad(scope *Scope, grad tf.Output, indices tf.Output, segment_ids tf.Output, output_dim0 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSqrtNGrad",
		Input: []tf.Input{
			grad, indices, segment_ids, output_dim0,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the sum along sparse segments of a tensor.
//
// Like `SparseSegmentSum`, but allows missing ids in `segment_ids`. If an id is
// missing, the `output` tensor at that position will be zeroed.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/sparse#Segmentation)
// for an explanation of segments.
//
// For example:
//
// ```python
// c = tf.constant([[1,2,3,4], [-1,-2,-3,-4], [5,6,7,8]])
//
// tf.sparse_segment_sum_with_num_segments(
//     c, tf.constant([0, 1]), tf.constant([0, 0]), num_segments=3)
// # => [[0 0 0 0]
// #     [0 0 0 0]
// #     [0 0 0 0]]
//
// tf.sparse_segment_sum_with_num_segments(c,
//                                         tf.constant([0, 1]),
//                                         tf.constant([0, 2],
//                                         num_segments=4))
// # => [[ 1  2  3  4]
// #     [ 0  0  0  0]
// #     [-1 -2 -3 -4]
// #     [ 0  0  0  0]]
// ```
//
// Arguments:
//
//	indices: A 1-D tensor. Has same rank as `segment_ids`.
//	segment_ids: A 1-D tensor. Values should be sorted and can be repeated.
//	num_segments: Should equal the number of distinct segment IDs.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `num_segments`.
func SparseSegmentSumWithNumSegments(scope *Scope, data tf.Output, indices tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSumWithNumSegments",
		Input: []tf.Input{
			data, indices, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveReduceV2Attr is an optional argument to CollectiveReduceV2.
type CollectiveReduceV2Attr func(optionalAttr)

// CollectiveReduceV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveReduceV2CommunicationHint(value string) CollectiveReduceV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveReduceV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveReduceV2TimeoutSeconds(value float32) CollectiveReduceV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// CollectiveReduceV2MaxSubdivsPerDevice sets the optional max_subdivs_per_device attribute to value.
// If not specified, defaults to -1
func CollectiveReduceV2MaxSubdivsPerDevice(value int64) CollectiveReduceV2Attr {
	return func(m optionalAttr) {
		m["max_subdivs_per_device"] = value
	}
}

// Mutually reduces multiple tensors of identical type and shape.
func CollectiveReduceV2(scope *Scope, input tf.Output, group_size tf.Output, group_key tf.Output, instance_key tf.Output, ordering_token []tf.Output, merge_op string, final_op string, optional ...CollectiveReduceV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"merge_op": merge_op, "final_op": final_op}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveReduceV2",
		Input: []tf.Input{
			input, group_size, group_key, instance_key, tf.OutputList(ordering_token),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the sum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output[i] = \sum_{j...} data[j...]\\) where the sum is over tuples `j...` such
// that `segment_ids[j...] == i`.  Unlike `SegmentSum`, `segment_ids`
// need not be sorted and need not cover all values in the full
// range of valid values.
//
// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
// If the given segment ID `i` is negative, the value is dropped and will not be
// added to the sum of the segment.
//
// `num_segments` should equal the number of distinct segment IDs.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentSum.png" alt>
// </div>
//
// ``` python
// c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
// tf.math.unsorted_segment_sum(c, tf.constant([0, 1, 0]), num_segments=2)
// # ==> [[ 5, 5, 5, 5],
// #       [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A tensor whose shape is a prefix of `data.shape`.
//
//
// Returns Has same shape as data, except for the first `segment_ids.rank`
// dimensions, which are replaced with a single dimension which has size
// `num_segments`.
func UnsortedSegmentSum(scope *Scope, data tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnsortedSegmentSum",
		Input: []tf.Input{
			data, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceScatterNdSubAttr is an optional argument to ResourceScatterNdSub.
type ResourceScatterNdSubAttr func(optionalAttr)

// ResourceScatterNdSubUseLocking sets the optional use_locking attribute to value.
//
// value: An optional bool. Defaults to True. If True, the assignment will
// be protected by a lock; otherwise the behavior is undefined,
// but may exhibit less contention.
// If not specified, defaults to true
func ResourceScatterNdSubUseLocking(value bool) ResourceScatterNdSubAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Applies sparse subtraction to individual values or slices in a Variable.
//
// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `ref`.
// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
// dimension of `ref`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// ```
// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]]
// ```
//
// For example, say we want to subtract 4 scattered elements from a rank-1 tensor
// with 8 elements. In Python, that subtraction would look like this:
//
// ```python
// ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8], use_resource=True)
// indices = tf.constant([[4], [3], [1], [7]])
// updates = tf.constant([9, 10, 11, 12])
// sub = tf.scatter_nd_sub(ref, indices, updates)
// with tf.Session() as sess:
//   print sess.run(sub)
// ```
//
// The resulting update to ref would look like this:
//
//     [1, -9, 3, -6, -4, 6, 7, -4]
//
// See `tf.scatter_nd` for more details about how to make updates to
// slices.
//
// Arguments:
//	ref: A resource handle. Must be from a VarHandleOp.
//	indices: A Tensor. Must be one of the following types: int32, int64.
// A tensor of indices into ref.
//	updates: A Tensor. Must have the same type as ref. A tensor of
// values to add to ref.
//
// Returns the created operation.
func ResourceScatterNdSub(scope *Scope, ref tf.Output, indices tf.Output, updates tf.Output, optional ...ResourceScatterNdSubAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterNdSub",
		Input: []tf.Input{
			ref, indices, updates,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the minimum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// This operator is similar to the unsorted segment sum operator found
// [(here)](../../../api_docs/python/math_ops.md#UnsortedSegmentSum).
// Instead of computing the sum over segments, it computes the minimum such that:
//
// \\(output_i = \min_{j...} data_[j...]\\) where min is over tuples `j...` such
// that `segment_ids[j...] == i`.
//
// If the minimum is empty for a given segment ID `i`, it outputs the largest
// possible value for the specific numeric type,
// `output[i] = numeric_limits<T>::max()`.
//
// For example:
//
// ``` python
// c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
// tf.unsorted_segment_min(c, tf.constant([0, 1, 0]), num_segments=2)
// # ==> [[ 1,  2, 2, 1],
// #       [5,  6, 7, 8]]
// ```
//
// If the given segment ID `i` is negative, then the corresponding value is
// dropped, and will not be included in the result.
//
// Arguments:
//
//	segment_ids: A tensor whose shape is a prefix of `data.shape`.
//
//
// Returns Has same shape as data, except for the first `segment_ids.rank`
// dimensions, which are replaced with a single dimension which has size
// `num_segments`.
func UnsortedSegmentMin(scope *Scope, data tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnsortedSegmentMin",
		Input: []tf.Input{
			data, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the minimum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \min_j(data_j)\\) where `min` is over `j` such
// that `segment_ids[j] == i`.
//
// If the min is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMin.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_min(c, tf.constant([0, 0, 1]))
// # ==> [[1, 2, 2, 1],
// #      [5, 6, 7, 8]]
// ```
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentMin(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentMin",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes arctangent of `y/x` element-wise, respecting signs of the arguments.
//
// This is the angle \\( \theta \in [-\pi, \pi] \\) such that
// \\[ x = r \cos(\theta) \\]
// and
// \\[ y = r \sin(\theta) \\]
// where \\(r = \sqrt{x^2 + y^2} \\).
//
// For example:
//
// >>> x = [1., 1.]
// >>> y = [1., -1.]
// >>> print((tf.math.atan2(y,x) * (180 / np.pi)).numpy())
// [ 45. -45.]
//
//
func Atan2(scope *Scope, y tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atan2",
		Input: []tf.Input{
			y, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the product along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \prod_j data_j\\) where the product is over `j` such
// that `segment_ids[j] == i`.
//
// If the product is empty for a given segment ID `i`, `output[i] = 1`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentProd.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_prod(c, tf.constant([0, 0, 1]))
// # ==> [[4, 6, 6, 4],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentProd(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentProd",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ArgMinAttr is an optional argument to ArgMin.
type ArgMinAttr func(optionalAttr)

// ArgMinOutputType sets the optional output_type attribute to value.
// If not specified, defaults to DT_INT64
func ArgMinOutputType(value tf.DataType) ArgMinAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Returns the index with the smallest value across dimensions of a tensor.
//
// Note that in case of ties the identity of the return value is not guaranteed.
//
// Usage:
//   ```python
//   import tensorflow as tf
//   a = [1, 10, 26.9, 2.8, 166.32, 62.3]
//   b = tf.math.argmin(input = a)
//   c = tf.keras.backend.eval(b)
//   # c = 0
//   # here a[0] = 1 which is the smallest element of a across axis 0
//   ```
//
// Arguments:
//
//	dimension: int32 or int64, must be in the range `[-rank(input), rank(input))`.
// Describes which dimension of the input Tensor to reduce across. For vectors,
// use dimension = 0.
func ArgMin(scope *Scope, input tf.Output, dimension tf.Output, optional ...ArgMinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ArgMin",
		Input: []tf.Input{
			input, dimension,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeBilinearGradAttr is an optional argument to ResizeBilinearGrad.
type ResizeBilinearGradAttr func(optionalAttr)

// ResizeBilinearGradAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and grad tensors are
// aligned. Defaults to false.
// If not specified, defaults to false
func ResizeBilinearGradAlignCorners(value bool) ResizeBilinearGradAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeBilinearGradHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeBilinearGradHalfPixelCenters(value bool) ResizeBilinearGradAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Computes the gradient of bilinear interpolation.
//
// Arguments:
//	grads: 4-D with shape `[batch, height, width, channels]`.
//	original_image: 4-D with shape `[batch, orig_height, orig_width, channels]`,
// The image tensor that was resized.
//
// Returns 4-D with shape `[batch, orig_height, orig_width, channels]`.
// Gradients with respect to the input image. Input image must have been
// float or double.
func ResizeBilinearGrad(scope *Scope, grads tf.Output, original_image tf.Output, optional ...ResizeBilinearGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeBilinearGrad",
		Input: []tf.Input{
			grads, original_image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxAttr is an optional argument to Max.
type MaxAttr func(optionalAttr)

// MaxKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MaxKeepDims(value bool) MaxAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the maximum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Max(scope *Scope, input tf.Output, axis tf.Output, optional ...MaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Max",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SampleDistortedBoundingBoxV2Attr is an optional argument to SampleDistortedBoundingBoxV2.
type SampleDistortedBoundingBoxV2Attr func(optionalAttr)

// SampleDistortedBoundingBoxV2Seed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to non-zero, the random number
// generator is seeded by the given `seed`.  Otherwise, it is seeded by a random
// seed.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxV2Seed(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// SampleDistortedBoundingBoxV2Seed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxV2Seed2(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// SampleDistortedBoundingBoxV2AspectRatioRange sets the optional aspect_ratio_range attribute to value.
//
// value: The cropped area of the image must have an aspect ratio =
// width / height within this range.
// If not specified, defaults to {f:0.75 f:1.33}
func SampleDistortedBoundingBoxV2AspectRatioRange(value []float32) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["aspect_ratio_range"] = value
	}
}

// SampleDistortedBoundingBoxV2AreaRange sets the optional area_range attribute to value.
//
// value: The cropped area of the image must contain a fraction of the
// supplied image within this range.
// If not specified, defaults to {f:0.05 f:1}
func SampleDistortedBoundingBoxV2AreaRange(value []float32) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["area_range"] = value
	}
}

// SampleDistortedBoundingBoxV2MaxAttempts sets the optional max_attempts attribute to value.
//
// value: Number of attempts at generating a cropped region of the image
// of the specified constraints. After `max_attempts` failures, return the entire
// image.
// If not specified, defaults to 100
func SampleDistortedBoundingBoxV2MaxAttempts(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["max_attempts"] = value
	}
}

// SampleDistortedBoundingBoxV2UseImageIfNoBoundingBoxes sets the optional use_image_if_no_bounding_boxes attribute to value.
//
// value: Controls behavior if no bounding boxes supplied.
// If true, assume an implicit bounding box covering the whole input. If false,
// raise an error.
// If not specified, defaults to false
func SampleDistortedBoundingBoxV2UseImageIfNoBoundingBoxes(value bool) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["use_image_if_no_bounding_boxes"] = value
	}
}

// Generate a single randomly distorted bounding box for an image.
//
// Bounding box annotations are often supplied in addition to ground-truth labels
// in image recognition or object localization tasks. A common technique for
// training such a system is to randomly distort an image while preserving
// its content, i.e. *data augmentation*. This Op outputs a randomly distorted
// localization of an object, i.e. bounding box, given an `image_size`,
// `bounding_boxes` and a series of constraints.
//
// The output of this Op is a single bounding box that may be used to crop the
// original image. The output is returned as 3 tensors: `begin`, `size` and
// `bboxes`. The first 2 tensors can be fed directly into `tf.slice` to crop the
// image. The latter may be supplied to `tf.image.draw_bounding_boxes` to visualize
// what the bounding box looks like.
//
// Bounding boxes are supplied and returned as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example,
//
// ```python
//     # Generate a single distorted bounding box.
//     begin, size, bbox_for_draw = tf.image.sample_distorted_bounding_box(
//         tf.shape(image),
//         bounding_boxes=bounding_boxes)
//
//     # Draw the bounding box in an image summary.
//     image_with_box = tf.image.draw_bounding_boxes(tf.expand_dims(image, 0),
//                                                   bbox_for_draw)
//     tf.summary.image('images_with_box', image_with_box)
//
//     # Employ the bounding box to distort the image.
//     distorted_image = tf.slice(image, begin, size)
// ```
//
// Note that if no bounding box information is available, setting
// `use_image_if_no_bounding_boxes = true` will assume there is a single implicit
// bounding box covering the whole image. If `use_image_if_no_bounding_boxes` is
// false and no bounding boxes are supplied, an error is raised.
//
// Arguments:
//	image_size: 1-D, containing `[height, width, channels]`.
//	bounding_boxes: 3-D with shape `[batch, N, 4]` describing the N bounding boxes
// associated with the image.
//	min_object_covered: The cropped area of the image must contain at least this
// fraction of any bounding box supplied. The value of this parameter should be
// non-negative. In the case of 0, the cropped area does not need to overlap
// any of the bounding boxes supplied.
//
// Returns:
//	begin: 1-D, containing `[offset_height, offset_width, 0]`. Provide as input to
// `tf.slice`.
//	size: 1-D, containing `[target_height, target_width, -1]`. Provide as input to
// `tf.slice`.
//	bboxes: 3-D with shape `[1, 1, 4]` containing the distorted bounding box.
// Provide as input to `tf.image.draw_bounding_boxes`.
func SampleDistortedBoundingBoxV2(scope *Scope, image_size tf.Output, bounding_boxes tf.Output, min_object_covered tf.Output, optional ...SampleDistortedBoundingBoxV2Attr) (begin tf.Output, size tf.Output, bboxes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SampleDistortedBoundingBoxV2",
		Input: []tf.Input{
			image_size, bounding_boxes, min_object_covered,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// EigAttr is an optional argument to Eig.
type EigAttr func(optionalAttr)

// EigComputeV sets the optional compute_v attribute to value.
//
// value: If `True` then eigenvectors will be computed and returned in `v`.
// Otherwise, only the eigenvalues will be computed.
// If not specified, defaults to true
func EigComputeV(value bool) EigAttr {
	return func(m optionalAttr) {
		m["compute_v"] = value
	}
}

// Computes the eigen decomposition of one or more square matrices.
//
// Computes the eigenvalues and (optionally) right eigenvectors of each inner matrix in
// `input` such that `input[..., :, :] = v[..., :, :] * diag(e[..., :])`. The eigenvalues
// are sorted in non-decreasing order.
//
// ```python
// # a is a tensor.
// # e is a tensor of eigenvalues.
// # v is a tensor of eigenvectors.
// e, v = eig(a)
// e = eig(a, compute_v=False)
// ```
//
// Arguments:
//	input: `Tensor` input of shape `[N, N]`.
//
//
// Returns:
//	e: Eigenvalues. Shape is `[N]`.
//	v: Eigenvectors. Shape is `[N, N]`.
func Eig(scope *Scope, input tf.Output, Tout tf.DataType, optional ...EigAttr) (e tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tout": Tout}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Eig",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// ProdAttr is an optional argument to Prod.
type ProdAttr func(optionalAttr)

// ProdKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func ProdKeepDims(value bool) ProdAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the product of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Prod(scope *Scope, input tf.Output, axis tf.Output, optional ...ProdAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Prod",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SumAttr is an optional argument to Sum.
type SumAttr func(optionalAttr)

// SumKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SumKeepDims(value bool) SumAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the sum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Sum(scope *Scope, input tf.Output, axis tf.Output, optional ...SumAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Sum",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShapeNAttr is an optional argument to ShapeN.
type ShapeNAttr func(optionalAttr)

// ShapeNOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_INT32
func ShapeNOutType(value tf.DataType) ShapeNAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Returns shape of tensors.
//
// This operation returns N 1-D integer tensors representing shape of `input[i]s`.
func ShapeN(scope *Scope, input []tf.Output, optional ...ShapeNAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShapeN",
		Input: []tf.Input{
			tf.OutputList(input),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("ShapeN", err)
		return
	}
	return output
}

// Returns the TopK values in the array in sorted order.
//
// This is a combination of MakeUnique and TopKUnique. The returned top-K will
// have its lower bits replaced by iota, thus it will be close to the original
// value but not exactly the same. The running time is proportional to the product
// of K and the input size. NaNs are never returned. Subnormal numbers are flushed
// to zero.
func TopKWithUnique(scope *Scope, input tf.Output, k int64) (topk tf.Output, topk_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	opspec := tf.OpSpec{
		Type: "TopKWithUnique",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// ImageSummaryAttr is an optional argument to ImageSummary.
type ImageSummaryAttr func(optionalAttr)

// ImageSummaryMaxImages sets the optional max_images attribute to value.
//
// value: Max number of batch elements to generate images for.
// If not specified, defaults to 3
//
// REQUIRES: value >= 1
func ImageSummaryMaxImages(value int64) ImageSummaryAttr {
	return func(m optionalAttr) {
		m["max_images"] = value
	}
}

// ImageSummaryBadColor sets the optional bad_color attribute to value.
//
// value: Color to use for pixels with non-finite values.
// If not specified, defaults to {dtype:DT_UINT8 tensor_shape:{dim:{size:4}} int_val:255 int_val:0 int_val:0 int_val:255}
func ImageSummaryBadColor(value tf.Tensor) ImageSummaryAttr {
	return func(m optionalAttr) {
		m["bad_color"] = value
	}
}

// Outputs a `Summary` protocol buffer with images.
//
// The summary has up to `max_images` summary values containing images. The
// images are built from `tensor` which must be 4-D with shape `[batch_size,
// height, width, channels]` and where `channels` can be:
//
// *  1: `tensor` is interpreted as Grayscale.
// *  3: `tensor` is interpreted as RGB.
// *  4: `tensor` is interpreted as RGBA.
//
// The images have the same number of channels as the input tensor. For float
// input, the values are normalized one image at a time to fit in the range
// `[0, 255]`.  `uint8` values are unchanged.  The op uses two different
// normalization algorithms:
//
// *  If the input values are all positive, they are rescaled so the largest one
//    is 255.
//
// *  If any input value is negative, the values are shifted so input value 0.0
//    is at 127.  They are then rescaled so that either the smallest value is 0,
//    or the largest one is 255.
//
// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
// build the `tag` of the summary values:
//
// *  If `max_images` is 1, the summary value tag is '*tag*/image'.
// *  If `max_images` is greater than 1, the summary value tags are
//    generated sequentially as '*tag*/image/0', '*tag*/image/1', etc.
//
// The `bad_color` argument is the color to use in the generated images for
// non-finite input values.  It is a `uint8` 1-D tensor of length `channels`.
// Each element must be in the range `[0, 255]` (It represents the value of a
// pixel in the output image).  Non-finite values in the input tensor are
// replaced by this tensor in the output image.  The default value is the color
// red.
//
// Arguments:
//	tag: Scalar. Used to build the `tag` attribute of the summary values.
//	tensor: 4-D of shape `[batch_size, height, width, channels]` where
// `channels` is 1, 3, or 4.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func ImageSummary(scope *Scope, tag tf.Output, tensor tf.Output, optional ...ImageSummaryAttr) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ImageSummary",
		Input: []tf.Input{
			tag, tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveBcastSendAttr is an optional argument to CollectiveBcastSend.
type CollectiveBcastSendAttr func(optionalAttr)

// CollectiveBcastSendCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastSendCommunicationHint(value string) CollectiveBcastSendAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastSendTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastSendTimeoutSeconds(value float32) CollectiveBcastSendAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Broadcasts a tensor value to one or more other devices.
func CollectiveBcastSend(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, shape tf.Shape, optional ...CollectiveBcastSendAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastSend",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CombinedNonMaxSuppressionAttr is an optional argument to CombinedNonMaxSuppression.
type CombinedNonMaxSuppressionAttr func(optionalAttr)

// CombinedNonMaxSuppressionPadPerClass sets the optional pad_per_class attribute to value.
//
// value: If false, the output nmsed boxes, scores and classes
// are padded/clipped to `max_total_size`. If true, the
// output nmsed boxes, scores and classes are padded to be of length
// `max_size_per_class`*`num_classes`, unless it exceeds `max_total_size` in
// which case it is clipped to `max_total_size`. Defaults to false.
// If not specified, defaults to false
func CombinedNonMaxSuppressionPadPerClass(value bool) CombinedNonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["pad_per_class"] = value
	}
}

// CombinedNonMaxSuppressionClipBoxes sets the optional clip_boxes attribute to value.
//
// value: If true, assume the box coordinates are between [0, 1] and clip the output boxes
// if they fall beyond [0, 1]. If false, do not do clipping and output the box
// coordinates as it is.
// If not specified, defaults to true
func CombinedNonMaxSuppressionClipBoxes(value bool) CombinedNonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["clip_boxes"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// This operation performs non_max_suppression on the inputs per batch, across
// all classes.
// Prunes away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system. Also note that
// this algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is the final boxes, scores and classes tensor
// returned after performing non_max_suppression.
//
// Arguments:
//	boxes: A 4-D float tensor of shape `[batch_size, num_boxes, q, 4]`. If `q` is 1 then
// same boxes are used for all classes otherwise, if `q` is equal to number of
// classes, class-specific boxes are used.
//	scores: A 3-D float tensor of shape `[batch_size, num_boxes, num_classes]`
// representing a single score corresponding to each box (each row of boxes).
//	max_output_size_per_class: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression per class
//	max_total_size: An int32 scalar representing the maximum number of boxes retained over all
// classes. Note that setting this value to a large number may result in OOM error
// depending on the system workload.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//
// Returns:
//	nmsed_boxes: A [batch_size, max_detections, 4] float32 tensor
// containing the non-max suppressed boxes.
//	nmsed_scores: A [batch_size, max_detections] float32 tensor
// containing the scores for the boxes.
//	nmsed_classes: A [batch_size, max_detections] float32 tensor
// containing the classes for the boxes.
//	valid_detections: A [batch_size] int32 tensor indicating the number of
// valid detections per batch item. Only the top num_detections[i] entries in
// nms_boxes[i], nms_scores[i] and nms_class[i] are valid. The rest of the
// entries are zero paddings.
func CombinedNonMaxSuppression(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size_per_class tf.Output, max_total_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output, optional ...CombinedNonMaxSuppressionAttr) (nmsed_boxes tf.Output, nmsed_scores tf.Output, nmsed_classes tf.Output, valid_detections tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CombinedNonMaxSuppression",
		Input: []tf.Input{
			boxes, scores, max_output_size_per_class, max_total_size, iou_threshold, score_threshold,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Returns the truth value of x AND y element-wise.
//
// *NOTE*: `LogicalAnd` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalAnd(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalAnd",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes a graph summary.
//
// Writes TensorFlow graph `tensor` at `step` using summary `writer`.
//
// Returns the created operation.
func WriteGraphSummary(scope *Scope, writer tf.Output, step tf.Output, tensor tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteGraphSummary",
		Input: []tf.Input{
			writer, step, tensor,
		},
	}
	return scope.AddOperation(opspec)
}

// ApproximateEqualAttr is an optional argument to ApproximateEqual.
type ApproximateEqualAttr func(optionalAttr)

// ApproximateEqualTolerance sets the optional tolerance attribute to value.
// If not specified, defaults to 1e-05
func ApproximateEqualTolerance(value float32) ApproximateEqualAttr {
	return func(m optionalAttr) {
		m["tolerance"] = value
	}
}

// Returns the truth value of abs(x-y) < tolerance element-wise.
func ApproximateEqual(scope *Scope, x tf.Output, y tf.Output, optional ...ApproximateEqualAttr) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ApproximateEqual",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the polygamma function \\(\psi^{(n)}(x)\\).
//
// The polygamma function is defined as:
//
//
// \\(\psi^{(a)}(x) = \frac{d^a}{dx^a} \psi(x)\\)
//
// where \\(\psi(x)\\) is the digamma function.
// The polygamma function is defined only for non-negative integer orders \\a\\.
func Polygamma(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Polygamma",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a tensor map with item from given key erased.
//
// input_handle: the original map
// output_handle: the map with value from given key removed
// key: the key of the value to be erased
func TensorMapErase(scope *Scope, input_handle tf.Output, key tf.Output, value_dtype tf.DataType) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value_dtype": value_dtype}
	opspec := tf.OpSpec{
		Type: "TensorMapErase",
		Input: []tf.Input{
			input_handle, key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Shuffle dimensions of x according to a permutation.
//
// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
//   `y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
func Transpose(scope *Scope, x tf.Output, perm tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Transpose",
		Input: []tf.Input{
			x, perm,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AssertAttr is an optional argument to Assert.
type AssertAttr func(optionalAttr)

// AssertSummarize sets the optional summarize attribute to value.
//
// value: Print this many entries of each tensor.
// If not specified, defaults to 3
func AssertSummarize(value int64) AssertAttr {
	return func(m optionalAttr) {
		m["summarize"] = value
	}
}

// Asserts that the given condition is true.
//
// If `condition` evaluates to false, print the list of tensors in `data`.
// `summarize` determines how many entries of the tensors to print.
//
// Arguments:
//	condition: The condition to evaluate.
//	data: The tensors to print out when condition is false.
//
// Returns the created operation.
func Assert(scope *Scope, condition tf.Output, data []tf.Output, optional ...AssertAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Assert",
		Input: []tf.Input{
			condition, tf.OutputList(data),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the gradient of `igamma(a, x)` wrt `a`.
func IgammaGradA(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IgammaGradA",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the upper regularized incomplete Gamma function `Q(a, x)`.
//
// The upper regularized incomplete Gamma function is defined as:
//
// \\(Q(a, x) = Gamma(a, x) / Gamma(a) = 1 - P(a, x)\\)
//
// where
//
// \\(Gamma(a, x) = \int_{x}^{\infty} t^{a-1} exp(-t) dt\\)
//
// is the upper incomplete Gamma function.
//
// Note, above `P(a, x)` (`Igamma`) is the lower regularized complete
// Gamma function.
func Igammac(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Igammac",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise remainder of division. This emulates C semantics in that
//
// the result here is consistent with a truncating divide. E.g.
// `tf.truncatediv(x, y) * y + truncate_mod(x, y) = x`.
//
// *NOTE*: `Mod` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Mod(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Mod",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A substitute for `InterleaveDataset` on a fixed list of `N` datasets.
//
// Arguments:
//	selector_input_dataset: A dataset of scalar `DT_INT64` elements that determines which of the
// `N` data inputs should produce the next output element.
//	data_input_datasets: `N` datasets with the same type that will be interleaved according to
// the values of `selector_input_dataset`.
//
//
func ExperimentalDirectedInterleaveDataset(scope *Scope, selector_input_dataset tf.Output, data_input_datasets []tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalDirectedInterleaveDataset",
		Input: []tf.Input{
			selector_input_dataset, tf.OutputList(data_input_datasets),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the min of x and y (i.e. x < y ? x : y) element-wise.
//
// *NOTE*: `Minimum` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Minimum(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Minimum",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the max of x and y (i.e. x > y ? x : y) element-wise.
//
// *NOTE*: `Maximum` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Maximum(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Maximum",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedResizeBilinearAttr is an optional argument to QuantizedResizeBilinear.
type QuantizedResizeBilinearAttr func(optionalAttr)

// QuantizedResizeBilinearAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func QuantizedResizeBilinearAlignCorners(value bool) QuantizedResizeBilinearAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// QuantizedResizeBilinearHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func QuantizedResizeBilinearHalfPixelCenters(value bool) QuantizedResizeBilinearAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Resize quantized `images` to `size` using quantized bilinear interpolation.
//
// Input images and output images must be quantized types.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//
//
//
// Returns:
//	resized_images: 4-D with shape
// `[batch, new_height, new_width, channels]`.
//	out_min
//	out_max
func QuantizedResizeBilinear(scope *Scope, images tf.Output, size tf.Output, min tf.Output, max tf.Output, optional ...QuantizedResizeBilinearAttr) (resized_images tf.Output, out_min tf.Output, out_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedResizeBilinear",
		Input: []tf.Input{
			images, size, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RandomGammaAttr is an optional argument to RandomGamma.
type RandomGammaAttr func(optionalAttr)

// RandomGammaSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomGammaSeed(value int64) RandomGammaAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomGammaSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomGammaSeed2(value int64) RandomGammaAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from the Gamma distribution(s) described by alpha.
//
// This op uses the algorithm by Marsaglia et al. to acquire samples via
// transformation-rejection from pairs of uniform and normal random variables.
// See http://dl.acm.org/citation.cfm?id=358414
//
// Arguments:
//	shape: 1-D integer tensor. Shape of independent samples to draw from each
// distribution described by the shape parameters given in alpha.
//	alpha: A tensor in which each scalar is a "shape" parameter describing the
// associated gamma distribution.
//
// Returns A tensor with shape `shape + shape(alpha)`. Each slice
// `[:, ..., :, i0, i1, ...iN]` contains the samples drawn for
// `alpha[i0, i1, ...iN]`. The dtype of the output matches the dtype of alpha.
func RandomGamma(scope *Scope, shape tf.Output, alpha tf.Output, optional ...RandomGammaAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomGamma",
		Input: []tf.Input{
			shape, alpha,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns 0 if x == 0, and x * log1p(y) otherwise, elementwise.
func Xlog1py(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Xlog1py",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns 0 if x == 0, and x * log(y) otherwise, elementwise.
func Xlogy(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Xlogy",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Increments variable pointed to by 'resource' until it reaches 'limit'.
//
// Arguments:
//	resource: Should be from a scalar `Variable` node.
//	limit: If incrementing ref would bring it above limit, instead generates an
// 'OutOfRange' error.
//
//
// Returns A copy of the input before increment. If nothing else modifies the
// input, the values produced will all be distinct.
func ResourceCountUpTo(scope *Scope, resource tf.Output, limit int64, T tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"limit": limit, "T": T}
	opspec := tf.OpSpec{
		Type: "ResourceCountUpTo",
		Input: []tf.Input{
			resource,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatefulStandardNormalAttr is an optional argument to StatefulStandardNormal.
type StatefulStandardNormalAttr func(optionalAttr)

// StatefulStandardNormalDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatefulStandardNormalDtype(value tf.DataType) StatefulStandardNormalAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from a normal distribution. This op is deprecated in favor of op 'StatefulStandardNormalV2'
//
// DEPRECATED at GraphDef version 29: Use StatefulStandardNormalV2 instead
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	shape: The shape of the output tensor.
//
// Returns A tensor of the specified shape filled with random normal values.
func StatefulStandardNormal(scope *Scope, resource tf.Output, shape tf.Output, optional ...StatefulStandardNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulStandardNormal",
		Input: []tf.Input{
			resource, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x / y element-wise for real types.
//
// If `x` and `y` are reals, this will return the floating-point division.
//
// *NOTE*: `Div` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func RealDiv(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RealDiv",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x / y element-wise for integer types.
//
// Truncation designates that negative numbers will round fractional quantities
// toward zero. I.e. -7 / 5 = -1. This matches C semantics but it is different
// than Python semantics. See `FloorDiv` for a division function that matches
// Python Semantics.
//
// *NOTE*: `TruncateDiv` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func TruncateDiv(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TruncateDiv",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes a serialized proto summary.
//
// Writes `tensor`, a serialized proto at `step` using summary `writer`.
//
// Returns the created operation.
func WriteRawProtoSummary(scope *Scope, writer tf.Output, step tf.Output, tensor tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteRawProtoSummary",
		Input: []tf.Input{
			writer, step, tensor,
		},
	}
	return scope.AddOperation(opspec)
}

// Returns 0 if the denominator is zero.
//
//
// *NOTE*: `DivNoNan` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func DivNoNan(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DivNoNan",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Scatter `updates` into an existing tensor according to `indices`.
//
// This operation creates a new tensor by applying sparse `updates` to the passed
// in `tensor`.
// This operation is very similar to `tf.scatter_nd`, except that the updates are
// scattered onto an existing tensor (as opposed to a zero-tensor). If the memory
// for the existing tensor cannot be re-used, a copy is made and updated.
//
// If `indices` contains duplicates, then we pick the last update for the index.
//
// If an out of bound index is found on CPU, an error is returned.
//
// **WARNING**: There are some GPU specific semantics for this operation.
// - If an out of bound index is found, the index is ignored.
// - The order in which updates are applied is nondeterministic, so the output
// will be nondeterministic if `indices` contains duplicates.
//
// `indices` is an integer tensor containing indices into a new tensor of shape
// `shape`.
//
// * `indices` must have at least 2 axes: `(num_updates, index_depth)`.
// * The last axis of `indices` is how deep to index into `tensor` so  this index
//   depth must be less than the rank of `tensor`: `indices.shape[-1] <= tensor.ndim`
//
// if `indices.shape[-1] = tensor.rank` this Op indexes and updates scalar elements.
// if `indices.shape[-1] < tensor.rank` it indexes and updates slices of the input
// `tensor`.
//
// Each `update` has a rank of `tensor.rank - indices.shape[-1]`.
// The overall shape of `updates` is:
//
// ```
// indices.shape[:-1] + tensor.shape[indices.shape[-1]:]
// ```
//
// For usage examples see the python [tf.tensor_scatter_nd_update](
// https://www.tensorflow.org/api_docs/python/tf/tensor_scatter_nd_update) function
//
//
// Arguments:
//	tensor: Tensor to copy/update.
//	indices: Index tensor.
//	updates: Updates to scatter into output.
//
// Returns A new tensor with the given shape and updates applied according
// to the indices.
func TensorScatterUpdate(scope *Scope, tensor tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorScatterUpdate",
		Input: []tf.Input{
			tensor, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TakeDatasetAttr is an optional argument to TakeDataset.
type TakeDatasetAttr func(optionalAttr)

// TakeDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func TakeDatasetMetadata(value string) TakeDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that contains `count` elements from the `input_dataset`.
//
// Arguments:
//
//	count: A scalar representing the number of elements from the `input_dataset`
// that should be taken. A value of `-1` indicates that all of `input_dataset`
// is taken.
//
//
func TakeDataset(scope *Scope, input_dataset tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...TakeDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TakeDataset",
		Input: []tf.Input{
			input_dataset, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the last element of the input list as well as a list with all but that element.
//
// Fails if the list is empty.
//
// input_handle: the input list
// tensor: the withdrawn last element of the list
// element_dtype: the type of elements in the list
// element_shape: the shape of the output tensor
func TensorListPopBack(scope *Scope, input_handle tf.Output, element_shape tf.Output, element_dtype tf.DataType) (output_handle tf.Output, tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "TensorListPopBack",
		Input: []tf.Input{
			input_handle, element_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// UniformCandidateSamplerAttr is an optional argument to UniformCandidateSampler.
type UniformCandidateSamplerAttr func(optionalAttr)

// UniformCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func UniformCandidateSamplerSeed(value int64) UniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// UniformCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func UniformCandidateSamplerSeed2(value int64) UniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a uniform distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//	sampled_candidates: A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.
//	true_expected_count: A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//	sampled_expected_count: A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func UniformCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...UniformCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniformCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceGatherAttr is an optional argument to ResourceGather.
type ResourceGatherAttr func(optionalAttr)

// ResourceGatherBatchDims sets the optional batch_dims attribute to value.
// If not specified, defaults to 0
func ResourceGatherBatchDims(value int64) ResourceGatherAttr {
	return func(m optionalAttr) {
		m["batch_dims"] = value
	}
}

// ResourceGatherValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func ResourceGatherValidateIndices(value bool) ResourceGatherAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Gather slices from the variable pointed to by `resource` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
//
// ```python
//     # Scalar indices
//     output[:, ..., :] = params[indices, :, ... :]
//
//     # Vector indices
//     output[i, :, ..., :] = params[indices[i], :, ... :]
//
//     # Higher rank indices
//     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
// ```
func ResourceGather(scope *Scope, resource tf.Output, indices tf.Output, dtype tf.DataType, optional ...ResourceGatherAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceGather",
		Input: []tf.Input{
			resource, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x + y element-wise.
//
// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Given two input tensors, the `tf.add` operation computes the sum for every element in the tensor.
//
// Both input and output have a range `(-inf, inf)`.
//
func Add(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Add",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise smallest integer not less than x.
func Ceil(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Ceil",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise largest integer not greater than x.
func Floor(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Floor",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the trignometric inverse tangent of x element-wise.
//
// The `tf.math.atan` operation returns the inverse of `tf.math.tan`, such that
// if `y = tf.math.tan(x)` then, `x = tf.math.atan(y)`.
//
// **Note**: The output of `tf.math.atan` will lie within the invertible range
// of tan, i.e (-pi/2, pi/2).
//
// For example:
//
// ```python
// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
// x = tf.constant([1.047, 0.785])
// y = tf.math.tan(x) # [1.731261, 0.99920404]
//
// tf.math.atan(y) # [1.047, 0.785] = x
// ```
//
func Atan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes acos of x element-wise.
//
//
//   Provided an input tensor, the `tf.math.acos` operation returns the inverse cosine of each element of the tensor. If `y = tf.math.cos(x)` then, `x = tf.math.acos(y)`.
//
//   Input range is `[-1, 1]` and the output has a range of `[0, pi]`.
//
func Acos(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Acos",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceSparseApplyAdadeltaAttr is an optional argument to ResourceSparseApplyAdadelta.
type ResourceSparseApplyAdadeltaAttr func(optionalAttr)

// ResourceSparseApplyAdadeltaUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceSparseApplyAdadeltaUseLocking(value bool) ResourceSparseApplyAdadeltaAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// var: Should be from a Variable().
//
// Arguments:
//
//	accum: Should be from a Variable().
//	accum_update: : Should be from a Variable().
//	lr: Learning rate. Must be a scalar.
//	rho: Decay factor. Must be a scalar.
//	epsilon: Constant factor. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//
// Returns the created operation.
func ResourceSparseApplyAdadelta(scope *Scope, var_ tf.Output, accum tf.Output, accum_update tf.Output, lr tf.Output, rho tf.Output, epsilon tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyAdadeltaAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyAdadelta",
		Input: []tf.Input{
			var_, accum, accum_update, lr, rho, epsilon, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyAdamAttr is an optional argument to ResourceApplyAdam.
type ResourceApplyAdamAttr func(optionalAttr)

// ResourceApplyAdamUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdamUseLocking(value bool) ResourceApplyAdamAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyAdamUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, uses the nesterov update.
// If not specified, defaults to false
func ResourceApplyAdamUseNesterov(value bool) ResourceApplyAdamAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update '*var' according to the Adam algorithm.
//
// $$\text{lr}_t := \mathrm{lr} \cdot \frac{\sqrt{1 - \beta_2^t}}{1 - \beta_1^t}$$
// $$m_t := \beta_1 \cdot m_{t-1} + (1 - \beta_1) \cdot g$$
// $$v_t := \beta_2 \cdot v_{t-1} + (1 - \beta_2) \cdot g^2$$
// $$\text{var} := \begin{cases} \text{var} - (m_t \beta_1 + g \cdot (1 - \beta_1))\cdot\text{lr}_t/(\sqrt{v_t} + \epsilon), &\text{if use_nesterov}\\\\  \text{var} - m_t \cdot \text{lr}_t /(\sqrt{v_t} + \epsilon), &\text{otherwise} \end{cases}$$
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	beta2_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdam(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, beta1_power tf.Output, beta2_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdamAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdam",
		Input: []tf.Input{
			var_, m, v, beta1_power, beta2_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes sigmoid of `x` element-wise.
//
// Specifically, `y = 1 / (1 + exp(-x))`.
func Sigmoid(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sigmoid",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes Psi, the derivative of Lgamma (the log of the absolute value of
//
// `Gamma(x)`), element-wise.
func Digamma(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Digamma",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the tanh of `x` wrt its input.
//
// Specifically, `grad = dy * (1 - y*y)`, where `y = tanh(x)`, and `dy`
// is the corresponding input gradient.
func TanhGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TanhGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic tangent of `x` element-wise.
//
//   Given an input tensor, this function computes hyperbolic tangent of every
//   element in the tensor. Input range is `[-inf, inf]` and
//   output range is `[-1,1]`.
//
//   >>> x = tf.constant([-float("inf"), -5, -0.5, 1, 1.2, 2, 3, float("inf")])
//   >>> tf.math.tanh(x)
//   <tf.Tensor: shape=(8,), dtype=float32, numpy=
//   array([-1.        , -0.99990916, -0.46211717,  0.7615942 ,  0.8336547 ,
//           0.9640276 ,  0.9950547 ,  1.        ], dtype=float32)>
//
func Tanh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Tanh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic sine of x element-wise.
//
//   Given an input tensor, this function computes hyperbolic sine of every
//   element in the tensor. Input range is `[-inf,inf]` and output range
//   is `[-inf,inf]`.
//
//   ```python
//   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 2, 10, float("inf")])
//   tf.math.sinh(x) ==> [-inf -4.0515420e+03 -5.2109528e-01 1.1752012e+00 1.5094614e+00 3.6268604e+00 1.1013232e+04 inf]
//   ```
func Sinh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sinh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyProximalAdagradAttr is an optional argument to ResourceApplyProximalAdagrad.
type ResourceApplyProximalAdagradAttr func(optionalAttr)

// ResourceApplyProximalAdagradUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceApplyProximalAdagradUseLocking(value bool) ResourceApplyProximalAdagradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' and '*accum' according to FOBOS with Adagrad learning rate.
//
// accum += grad * grad
// prox_v = var - lr * grad * (1 / sqrt(accum))
// var = sign(prox_v)/(1+lr*l2) * max{|prox_v|-lr*l1,0}
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyProximalAdagrad(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, grad tf.Output, optional ...ResourceApplyProximalAdagradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyProximalAdagrad",
		Input: []tf.Input{
			var_, accum, lr, l1, l2, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Divides sparse updates into the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] /= updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] /= updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] /= updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions multiply.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterDiv(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterDiv",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the trignometric inverse sine of x element-wise.
//
// The `tf.math.asin` operation returns the inverse of `tf.math.sin`, such that
// if `y = tf.math.sin(x)` then, `x = tf.math.asin(y)`.
//
// **Note**: The output of `tf.math.asin` will lie within the invertible range
// of sine, i.e [-pi/2, pi/2].
//
// For example:
//
// ```python
// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
// x = tf.constant([1.047, 0.785])
// y = tf.math.sin(x) # [0.8659266, 0.7068252]
//
// tf.math.asin(y) # [1.047, 0.785] = x
// ```
//
func Asin(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Asin",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes natural logarithm of (1 + x) element-wise.
//
// I.e., \\(y = \log_e (1 + x)\\).
//
// Example:
//
// ```python
// x = tf.constant([0, 0.5, 1, 5])
// tf.math.log1p(x) ==> [0., 0.4054651, 0.6931472, 1.7917595]
// ```
func Log1p(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Log1p",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes exponential of x element-wise.  \\(y = e^x\\).
//
//   This function computes the exponential of every element in the input tensor.
//   i.e. `exp(x)` or `e^(x)`, where `x` is the input tensor.
//   `e` denotes Euler's number and is approximately equal to 2.718281.
//   Output is positive for any real input.
//
//   ```python
//   x = tf.constant(2.0)
//   tf.math.exp(x) ==> 7.389056
//
//   x = tf.constant([2.0, 8.0])
//   tf.math.exp(x) ==> array([7.389056, 2980.958], dtype=float32)
//   ```
//
//   For complex numbers, the exponential value is calculated as follows:
//
//   ```
//   e^(x+iy) = e^x * e^iy = e^x * (cos y + i sin y)
//   ```
//
//   Let's consider complex number 1+1j as an example.
//   e^1 * (cos 1 + i sin 1) = 2.7182818284590 * (0.54030230586+0.8414709848j)
//
//   ```python
//   x = tf.constant(1 + 1j)
//   tf.math.exp(x) ==> 1.4686939399158851+2.2873552871788423j
//   ```
func Exp(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Exp",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes square of x element-wise.
//
// I.e., \\(y = x * x = x^2\\).
func Square(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Square",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the inverse of `x` wrt its input.
//
// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
// is the corresponding input gradient.
func ReciprocalGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReciprocalGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the reciprocal of x element-wise.
//
// I.e., \\(y = 1 / x\\).
func Inv(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Inv",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ComplexAbsAttr is an optional argument to ComplexAbs.
type ComplexAbsAttr func(optionalAttr)

// ComplexAbsTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func ComplexAbsTout(value tf.DataType) ComplexAbsAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Computes the complex absolute value of a tensor.
//
// Given a tensor `x` of complex numbers, this operation returns a tensor of type
// `float` or `double` that is the absolute value of each element in `x`. All
// elements in `x` must be complex numbers of the form \\(a + bj\\). The absolute
// value is computed as \\( \sqrt{a^2 + b^2}\\).
//
// For example:
//
// >>> x = tf.complex(3.0, 4.0)
// >>> print((tf.raw_ops.ComplexAbs(x=x, Tout=tf.dtypes.float32, name=None)).numpy())
// 5.0
//
func ComplexAbs(scope *Scope, x tf.Output, optional ...ComplexAbsAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ComplexAbs",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps the XLA DotGeneral operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#dotgeneral
// .
//
// Arguments:
//	lhs: the LHS tensor
//	rhs: the RHS tensor
//	dimension_numbers: a serialized xla::DotDimensionNumbers proto.
//	precision_config: a serialized xla::PrecisionConfig proto.
//	preferred_element_type: The type of the tensor.
func XlaDotV2(scope *Scope, lhs tf.Output, rhs tf.Output, dimension_numbers string, precision_config string, preferred_element_type tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dimension_numbers": dimension_numbers, "precision_config": precision_config, "preferred_element_type": preferred_element_type}
	opspec := tf.OpSpec{
		Type: "XlaDotV2",
		Input: []tf.Input{
			lhs, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the absolute value of a tensor.
//
// Given a tensor `x`, this operation returns a tensor containing the absolute
// value of each element in `x`. For example, if x is an input element and y is
// an output element, this operation computes \\(y = |x|\\).
func Abs(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Abs",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Produces a summary of any statistics recorded by the given statistics manager.
func ExperimentalStatsAggregatorSummary(scope *Scope, iterator tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalStatsAggregatorSummary",
		Input: []tf.Input{
			iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomStandardNormalAttr is an optional argument to RandomStandardNormal.
type RandomStandardNormalAttr func(optionalAttr)

// RandomStandardNormalSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomStandardNormalSeed(value int64) RandomStandardNormalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomStandardNormalSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomStandardNormalSeed2(value int64) RandomStandardNormalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	shape: The shape of the output tensor.
//	dtype: The type of the output.
//
// Returns A tensor of the specified shape filled with random normal values.
func RandomStandardNormal(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...RandomStandardNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomStandardNormal",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the [Gauss error function](https://en.wikipedia.org/wiki/Error_function) of `x` element-wise. In statistics, for non-negative values of $x$, the error function has the following interpretation: for a random variable $Y$ that is normally distributed with mean 0 and variance $1/\sqrt{2}$, $erf(x)$ is the probability that $Y$ falls in the range $[−x, x]$.
func Erf(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Erf",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the maximum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \max_j(data_j)\\) where `max` is over `j` such
// that `segment_ids[j] == i`.
//
// If the max is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMax.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_max(c, tf.constant([0, 0, 1]))
// # ==> [[4, 3, 3, 4],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentMax(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentMax",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CastAttr is an optional argument to Cast.
type CastAttr func(optionalAttr)

// CastTruncate sets the optional Truncate attribute to value.
// If not specified, defaults to false
func CastTruncate(value bool) CastAttr {
	return func(m optionalAttr) {
		m["Truncate"] = value
	}
}

// Cast x of type SrcT to y of DstT.
func Cast(scope *Scope, x tf.Output, DstT tf.DataType, optional ...CastAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"DstT": DstT}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cast",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the mean along sparse segments of a tensor.
//
// See `tf.sparse.segment_sum` for usage examples.
//
// Like `SegmentMean`, but `segment_ids` can have rank less than `data`'s first
// dimension, selecting a subset of dimension 0, specified by `indices`.
//
// Arguments:
//
//	indices: A 1-D tensor. Has same rank as `segment_ids`.
//	segment_ids: A 1-D tensor. Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SparseSegmentMean(scope *Scope, data tf.Output, indices tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentMean",
		Input: []tf.Input{
			data, indices, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchMatMulV3Attr is an optional argument to BatchMatMulV3.
type BatchMatMulV3Attr func(optionalAttr)

// BatchMatMulV3AdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV3AdjX(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulV3AdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV3AdjY(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//     r_o = c_x if adj_x else r_x
//     c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// *NOTE*: `BatchMatMulV3` supports broadcasting in the batch dimensions. More
// about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
//
// Arguments:
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//	Tout: If not spcified, Tout is the same type to input type.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMulV3(scope *Scope, x tf.Output, y tf.Output, Tout tf.DataType, optional ...BatchMatMulV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tout": Tout}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMulV3",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Elementwise computes the bitwise OR of `x` and `y`.
//
// The result will have those bits set, that are set in `x`, `y` or both. The
// computation is performed on the underlying representations of `x` and `y`.
//
// For example:
//
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
//               tf.uint8, tf.uint16, tf.uint32, tf.uint64]
//
// for dtype in dtype_list:
//   lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
//   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
//   exp = tf.constant([5, 5, 7, 15], dtype=tf.float32)
//
//   res = bitwise_ops.bitwise_or(lhs, rhs)
//   tf.assert_equal(tf.cast(res,  tf.float32), exp)  # TRUE
// ```
//
func BitwiseOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BitwiseOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SendAttr is an optional argument to Send.
type SendAttr func(optionalAttr)

// SendClientTerminated sets the optional client_terminated attribute to value.
//
// value: If set to true, this indicates that the node was added
// to the graph as a result of a client-side feed or fetch of Tensor data,
// in which case the corresponding send or recv is expected to be managed
// locally by the caller.
// If not specified, defaults to false
func SendClientTerminated(value bool) SendAttr {
	return func(m optionalAttr) {
		m["client_terminated"] = value
	}
}

// Sends the named tensor from send_device to recv_device.
//
// Arguments:
//	tensor: The tensor to send.
//	tensor_name: The name of the tensor to send.
//	send_device: The name of the device sending the tensor.
//	send_device_incarnation: The current incarnation of send_device.
//	recv_device: The name of the device receiving the tensor.
//
// Returns the created operation.
func Send(scope *Scope, tensor tf.Output, tensor_name string, send_device string, send_device_incarnation int64, recv_device string, optional ...SendAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"tensor_name": tensor_name, "send_device": send_device, "send_device_incarnation": send_device_incarnation, "recv_device": recv_device}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Send",
		Input: []tf.Input{
			tensor,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// BatchMatMulV2Attr is an optional argument to BatchMatMulV2.
type BatchMatMulV2Attr func(optionalAttr)

// BatchMatMulV2AdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV2AdjX(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulV2AdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV2AdjY(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//     r_o = c_x if adj_x else r_x
//     c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// *NOTE*: `BatchMatMulV2` supports broadcasting in the batch dimensions. More
// about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
//
// Arguments:
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMulV2(scope *Scope, x tf.Output, y tf.Output, optional ...BatchMatMulV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMulV2",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns 0 if x == 0, and x / y otherwise, elementwise.
func Xdivy(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Xdivy",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyAdamWithAmsgradAttr is an optional argument to ResourceApplyAdamWithAmsgrad.
type ResourceApplyAdamWithAmsgradAttr func(optionalAttr)

// ResourceApplyAdamWithAmsgradUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdamWithAmsgradUseLocking(value bool) ResourceApplyAdamWithAmsgradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the Adam algorithm.
//
// $$\text{lr}_t := \mathrm{learning_rate} * \sqrt{1 - \beta_2^t} / (1 - \beta_1^t)$$
// $$m_t := \beta_1 * m_{t-1} + (1 - \beta_1) * g$$
// $$v_t := \beta_2 * v_{t-1} + (1 - \beta_2) * g * g$$
// $$\hat{v}_t := max{\hat{v}_{t-1}, v_t}$$
// $$\text{variable} := \text{variable} - \text{lr}_t * m_t / (\sqrt{\hat{v}_t} + \epsilon)$$
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	vhat: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	beta2_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdamWithAmsgrad(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, vhat tf.Output, beta1_power tf.Output, beta2_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdamWithAmsgradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdamWithAmsgrad",
		Input: []tf.Input{
			var_, m, v, vhat, beta1_power, beta2_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the sum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \sum_j data_j\\) where sum is over `j` such
// that `segment_ids[j] == i`.
//
// If the sum is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentSum.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_sum(c, tf.constant([0, 0, 1]))
// # ==> [[5, 5, 5, 5],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentSum(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentSum",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the pairwise cross product.
//
// `a` and `b` must be the same shape; they can either be simple 3-element vectors,
// or any shape where the innermost dimension is 3. In the latter case, each pair
// of corresponding 3-element vectors is cross-multiplied independently.
//
// Arguments:
//	a: A tensor containing 3-element vectors.
//	b: Another tensor, of same type and shape as `a`.
//
// Returns Pairwise cross product of the vectors in `a` and `b`.
func Cross(scope *Scope, a tf.Output, b tf.Output) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cross",
		Input: []tf.Input{
			a, b,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Sends `input` to all devices that are connected to the output.
//
// Sends `input` to all devices that are connected to the output.
//
// The graph should be constructed so that all ops connected to the output have a
// valid device assignment, and the op itself is assigned one of these devices.
//
// input: The input to the broadcast.
// output: The same as input.
// shape: The shape of the input tensor.
//
func NcclBroadcast(scope *Scope, input tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "NcclBroadcast",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DAttr is an optional argument to Conv2D.
type Conv2DAttr func(optionalAttr)

// Conv2DUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DUseCudnnOnGpu(value bool) Conv2DAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func Conv2DExplicitPaddings(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func Conv2DDataFormat(value string) Conv2DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func Conv2DDilations(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2-D convolution given 4-D `input` and `filter` tensors.
//
// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
// and a filter / kernel tensor of shape
// `[filter_height, filter_width, in_channels, out_channels]`, this op
// performs the following:
//
// 1. Flattens the filter to a 2-D matrix with shape
//    `[filter_height * filter_width * in_channels, output_channels]`.
// 2. Extracts image patches from the input tensor to form a *virtual*
//    tensor of shape `[batch, out_height, out_width,
//    filter_height * filter_width * in_channels]`.
// 3. For each patch, right-multiplies the filter matrix and the image patch
//    vector.
//
// In detail, with the default NHWC format,
//
//     output[b, i, j, k] =
//         sum_{di, dj, q} input[b, strides[1] * i + di, strides[2] * j + dj, q] *
//                         filter[di, dj, q, k]
//
// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
//
// Arguments:
//	input: A 4-D tensor. The dimension order is interpreted according to the value
// of `data_format`, see below for details.
//	filter: A 4-D tensor of shape
// `[filter_height, filter_width, in_channels, out_channels]`
//	strides: 1-D tensor of length 4.  The stride of the sliding window for each
// dimension of `input`. The dimension order is determined by the value of
// `data_format`, see below for details.
//	padding: The type of padding algorithm to use.
//
// Returns A 4-D tensor. The dimension order is determined by the value of
// `data_format`, see below for details.
func Conv2D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns locations of nonzero / true values in a tensor.
//
// This operation returns the coordinates of true elements in `condition`. The
// coordinates are returned in a 2-D tensor where the first dimension (rows)
// represents the number of true elements, and the second dimension (columns)
// represents the coordinates of the true elements. Keep in mind, the shape of
// the output tensor can vary depending on how many true values there are in
// `condition`. Indices are output in row-major order.
//
// For example:
//
// ```
// # 'input' tensor is [[True, False]
// #                    [True, False]]
// # 'input' has two true values, so output has two coordinates.
// # 'input' has rank of 2, so coordinates have two indices.
// where(input) ==> [[0, 0],
//                   [1, 0]]
//
// # `condition` tensor is [[[True, False]
// #                     [True, False]]
// #                    [[False, True]
// #                     [False, True]]
// #                    [[False, False]
// #                     [False, True]]]
// # 'input' has 5 true values, so output has 5 coordinates.
// # 'input' has rank of 3, so coordinates have three indices.
// where(input) ==> [[0, 0, 0],
//                   [0, 1, 0],
//                   [1, 0, 1],
//                   [1, 1, 1],
//                   [2, 1, 1]]
//
// # `condition` tensor is [[[1.5,  0.0]
// #                     [-0.5, 0.0]]
// #                    [[0.0,  0.25]
// #                     [0.0,  0.75]]
// #                    [[0.0,  0.0]
// #                     [0.0,  0.01]]]
// # 'input' has 5 nonzero values, so output has 5 coordinates.
// # 'input' has rank of 3, so coordinates have three indices.
// where(input) ==> [[0, 0, 0],
//                   [0, 1, 0],
//                   [1, 0, 1],
//                   [1, 1, 1],
//                   [2, 1, 1]]
//
// # `condition` tensor is [[[1.5 + 0.0j, 0.0  + 0.0j]
// #                     [0.0 + 0.5j, 0.0  + 0.0j]]
// #                    [[0.0 + 0.0j, 0.25 + 1.5j]
// #                     [0.0 + 0.0j, 0.75 + 0.0j]]
// #                    [[0.0 + 0.0j, 0.0  + 0.0j]
// #                     [0.0 + 0.0j, 0.01 + 0.0j]]]
// # 'input' has 5 nonzero magnitude values, so output has 5 coordinates.
// # 'input' has rank of 3, so coordinates have three indices.
// where(input) ==> [[0, 0, 0],
//                   [0, 1, 0],
//                   [1, 0, 1],
//                   [1, 1, 1],
//                   [2, 1, 1]]
// ```
func Where(scope *Scope, condition tf.Output) (index tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Where",
		Input: []tf.Input{
			condition,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SvdAttr is an optional argument to Svd.
type SvdAttr func(optionalAttr)

// SvdComputeUv sets the optional compute_uv attribute to value.
//
// value: If true, left and right singular vectors will be
// computed and returned in `u` and `v`, respectively.
// If false, `u` and `v` are not set and should never referenced.
// If not specified, defaults to true
func SvdComputeUv(value bool) SvdAttr {
	return func(m optionalAttr) {
		m["compute_uv"] = value
	}
}

// SvdFullMatrices sets the optional full_matrices attribute to value.
//
// value: If true, compute full-sized `u` and `v`. If false
// (the default), compute only the leading `P` singular vectors.
// Ignored if `compute_uv` is `False`.
// If not specified, defaults to false
func SvdFullMatrices(value bool) SvdAttr {
	return func(m optionalAttr) {
		m["full_matrices"] = value
	}
}

// Computes the singular value decompositions of one or more matrices.
//
// Computes the SVD of each inner matrix in `input` such that
// `input[..., :, :] = u[..., :, :] * diag(s[..., :, :]) * transpose(v[..., :, :])`
//
// ```python
// # a is a tensor containing a batch of matrices.
// # s is a tensor of singular values for each matrix.
// # u is the tensor containing the left singular vectors for each matrix.
// # v is the tensor containing the right singular vectors for each matrix.
// s, u, v = svd(a)
// s, _, _ = svd(a, compute_uv=False)
// ```
//
// Arguments:
//	input: A tensor of shape `[..., M, N]` whose inner-most 2 dimensions
// form matrices of size `[M, N]`. Let `P` be the minimum of `M` and `N`.
//
// Returns:
//	s: Singular values. Shape is `[..., P]`.
//	u: Left singular vectors. If `full_matrices` is `False` then shape is
// `[..., M, P]`; if `full_matrices` is `True` then shape is
// `[..., M, M]`. Undefined if `compute_uv` is `False`.
//	v: Left singular vectors. If `full_matrices` is `False` then shape is
// `[..., N, P]`. If `full_matrices` is `True` then shape is `[..., N, N]`.
// Undefined if `compute_uv` is false.
func Svd(scope *Scope, input tf.Output, optional ...SvdAttr) (s tf.Output, u tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Svd",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes gradients for SparseSegmentMean.
//
// Returns tensor "output" with same shape as grad, except for dimension 0 whose
// value is output_dim0.
//
// Arguments:
//	grad: gradient propagated to the SparseSegmentMean op.
//	indices: indices passed to the corresponding SparseSegmentMean op.
//	segment_ids: segment_ids passed to the corresponding SparseSegmentMean op.
//	output_dim0: dimension 0 of "data" passed to SparseSegmentMean op.
func SparseSegmentMeanGrad(scope *Scope, grad tf.Output, indices tf.Output, segment_ids tf.Output, output_dim0 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentMeanGrad",
		Input: []tf.Input{
			grad, indices, segment_ids, output_dim0,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// The graph should be constructed so that all inputs have a valid device
// assignment, and the op itself is assigned one of these devices.
//
// input: The input to the reduction.
// data: the value of the reduction across all `num_devices` devices.
// reduction: the reduction operation to perform.
func NcclReduce(scope *Scope, input []tf.Output, reduction string) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction}
	opspec := tf.OpSpec{
		Type: "NcclReduce",
		Input: []tf.Input{
			tf.OutputList(input),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op to receive a tensor from the host.
//
// output: the tensor that will be received from the host.
// Toutput: element type for output.
// shape: shape for output.
// key: A unique identifier for this region used to match up host transfers.
func XlaRecvFromHost(scope *Scope, Toutput tf.DataType, shape tf.Shape, key string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Toutput": Toutput, "shape": shape, "key": key}
	opspec := tf.OpSpec{
		Type: "XlaRecvFromHost",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedDepthwiseConv2DWithBiasAndReluAttr is an optional argument to QuantizedDepthwiseConv2DWithBiasAndRelu.
type QuantizedDepthwiseConv2DWithBiasAndReluAttr func(optionalAttr)

// QuantizedDepthwiseConv2DWithBiasAndReluOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QINT32
func QuantizedDepthwiseConv2DWithBiasAndReluOutType(value tf.DataType) QuantizedDepthwiseConv2DWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DWithBiasAndReluDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func QuantizedDepthwiseConv2DWithBiasAndReluDilations(value []int64) QuantizedDepthwiseConv2DWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// QuantizedDepthwiseConv2DWithBiasAndReluPaddingList sets the optional padding_list attribute to value.
// If not specified, defaults to {}
func QuantizedDepthwiseConv2DWithBiasAndReluPaddingList(value []int64) QuantizedDepthwiseConv2DWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["padding_list"] = value
	}
}

// Computes quantized depthwise Conv2D with Bias and Relu.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	bias: The original bias tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	strides: List of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The float value that the minimum quantized output value represents.
//	max_output: The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2DWithBiasAndRelu(scope *Scope, input tf.Output, filter tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DWithBiasAndReluAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2DWithBiasAndRelu",
		Input: []tf.Input{
			input, filter, bias, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedDepthwiseConv2DWithBiasAttr is an optional argument to QuantizedDepthwiseConv2DWithBias.
type QuantizedDepthwiseConv2DWithBiasAttr func(optionalAttr)

// QuantizedDepthwiseConv2DWithBiasOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QINT32
func QuantizedDepthwiseConv2DWithBiasOutType(value tf.DataType) QuantizedDepthwiseConv2DWithBiasAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DWithBiasDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func QuantizedDepthwiseConv2DWithBiasDilations(value []int64) QuantizedDepthwiseConv2DWithBiasAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes quantized depthwise Conv2D with Bias.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	bias: The original bias tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	strides: List of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The float value that the minimum quantized output value represents.
//	max_output: The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2DWithBias(scope *Scope, input tf.Output, filter tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DWithBiasAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2DWithBias",
		Input: []tf.Input{
			input, filter, bias, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedDepthwiseConv2DAttr is an optional argument to QuantizedDepthwiseConv2D.
type QuantizedDepthwiseConv2DAttr func(optionalAttr)

// QuantizedDepthwiseConv2DOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QINT32
func QuantizedDepthwiseConv2DOutType(value tf.DataType) QuantizedDepthwiseConv2DAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func QuantizedDepthwiseConv2DDilations(value []int64) QuantizedDepthwiseConv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes quantized depthwise Conv2D.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	strides: List of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The float value that the minimum quantized output value represents.
//	max_output: The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2D(scope *Scope, input tf.Output, filter tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2D",
		Input: []tf.Input{
			input, filter, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedConv2DPerChannelAttr is an optional argument to QuantizedConv2DPerChannel.
type QuantizedConv2DPerChannelAttr func(optionalAttr)

// QuantizedConv2DPerChannelOutType sets the optional out_type attribute to value.
//
// value: The quantized type of output tensor that needs to be converted.
// If not specified, defaults to DT_QINT32
func QuantizedConv2DPerChannelOutType(value tf.DataType) QuantizedConv2DPerChannelAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedConv2DPerChannelDilations sets the optional dilations attribute to value.
//
// value: list of dilation values.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func QuantizedConv2DPerChannelDilations(value []int64) QuantizedConv2DPerChannelAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes QuantizedConv2D per channel.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	min_input: The minimum value of the input tensor
//	max_input: The maximum value of the input tensor.
//	min_filter: The minimum value of the filter tensor.
//	max_filter: The maximum value of the filter tensor.
//	strides: list of stride values.
//
//
// Returns:
//	output: The output tensor.
//	min_output: The minimum value of the final output tensor.
//	max_output: The maximum value of the final output tensor.
func QuantizedConv2DPerChannel(scope *Scope, input tf.Output, filter tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedConv2DPerChannelAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedConv2DPerChannel",
		Input: []tf.Input{
			input, filter, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Wraps the XLA AllReduce operator
//
//   documented at https://www.tensorflow.org/xla/operation_semantics#allreduce.
//
// Arguments:
//	input: Array or a non-empty tuple of arrays to reduce across replicas.
//	group_assignment: Groups between which the reductions are performed.
//	reduce_op: Reduction computation.
func XlaAllReduce(scope *Scope, input tf.Output, group_assignment tf.Output, reduce_op string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduce_op": reduce_op}
	opspec := tf.OpSpec{
		Type: "XlaAllReduce",
		Input: []tf.Input{
			input, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for a multi device iterator resource.
//
// Returns:
//	handle: A handle to a multi device iterator that can be passed to a
// "MultiDeviceIteratorGetNextFromShard" op. In contrast to MultiDeviceIterator,
// AnonymousIterator prevents resource sharing by name, and does not keep a
// reference to the resource container.
//	deleter: A variant deleter that should be passed into the op that deletes the iterator.
func AnonymousMultiDeviceIterator(scope *Scope, devices []string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output, deleter tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"devices": devices, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousMultiDeviceIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Provides the time since epoch in seconds.
//
// Returns the timestamp as a `float64` for seconds since the Unix epoch.
//
// Note: the timestamp is computed when the op is executed, not when it is added
// to the graph.
func Timestamp(scope *Scope) (ts tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Timestamp",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x <= y) element-wise.
//
// *NOTE*: `LessEqual` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Example:
//
// ```python
// x = tf.constant([5, 4, 6])
// y = tf.constant([5])
// tf.math.less_equal(x, y) ==> [True, True, False]
//
// x = tf.constant([5, 4, 6])
// y = tf.constant([5, 6, 6])
// tf.math.less_equal(x, y) ==> [True, True, True]
// ```
func LessEqual(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LessEqual",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingRMSPropParametersAttr is an optional argument to RetrieveTPUEmbeddingRMSPropParameters.
type RetrieveTPUEmbeddingRMSPropParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingRMSPropParametersTableId(value int64) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingRMSPropParametersTableName(value string) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingRMSPropParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingRMSPropParametersConfig(value string) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve RMSProp embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the RMSProp optimization algorithm.
//	ms: Parameter ms updated by the RMSProp optimization algorithm.
//	mom: Parameter mom updated by the RMSProp optimization algorithm.
func RetrieveTPUEmbeddingRMSPropParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingRMSPropParametersAttr) (parameters tf.Output, ms tf.Output, mom tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingRMSPropParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizedMatMulWithBiasAttr is an optional argument to QuantizedMatMulWithBias.
type QuantizedMatMulWithBiasAttr func(optionalAttr)

// QuantizedMatMulWithBiasToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMatMulWithBiasToutput(value tf.DataType) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasTransposeA(value bool) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasTransposeB(value bool) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasInputQuantMode(value string) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Performs a quantized matrix multiplication of `a` by the matrix `b` with bias
// add.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// multiplication result. The bias size must match inner dimension of `b`.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//
// Returns:
//	out
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedMatMulWithBias(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, optional ...QuantizedMatMulWithBiasAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBias",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// TensorArrayGatherV2Attr is an optional argument to TensorArrayGatherV2.
type TensorArrayGatherV2Attr func(optionalAttr)

// TensorArrayGatherV2ElementShape sets the optional element_shape attribute to value.
// If not specified, defaults to {unknown_rank:true}
func TensorArrayGatherV2ElementShape(value tf.Shape) TensorArrayGatherV2Attr {
	return func(m optionalAttr) {
		m["element_shape"] = value
	}
}

// Deprecated. Use TensorArrayGatherV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayGatherV3
func TensorArrayGatherV2(scope *Scope, handle tf.Output, indices tf.Output, flow_in tf.Output, dtype tf.DataType, optional ...TensorArrayGatherV2Attr) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayGatherV2",
		Input: []tf.Input{
			handle, indices, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RFFT3DAttr is an optional argument to RFFT3D.
type RFFT3DAttr func(optionalAttr)

// RFFT3DTcomplex sets the optional Tcomplex attribute to value.
// If not specified, defaults to DT_COMPLEX64
func RFFT3DTcomplex(value tf.DataType) RFFT3DAttr {
	return func(m optionalAttr) {
		m["Tcomplex"] = value
	}
}

// 3D real-valued fast Fourier transform.
//
// Computes the 3-dimensional discrete Fourier transform of a real-valued signal
// over the inner-most 3 dimensions of `input`.
//
// Since the DFT of a real signal is Hermitian-symmetric, `RFFT3D` only returns the
// `fft_length / 2 + 1` unique components of the FFT for the inner-most dimension
// of `output`: the zero-frequency term, followed by the `fft_length / 2`
// positive-frequency terms.
//
// Along each axis `RFFT3D` is computed on, if `fft_length` is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A float32 tensor.
//	fft_length: An int32 tensor of shape [3]. The FFT length for each dimension.
//
// Returns A complex64 tensor of the same rank as `input`. The inner-most 3
//   dimensions of `input` are replaced with the their 3D Fourier transform. The
//   inner-most dimension contains `fft_length / 2 + 1` unique frequency
//   components.
//
// @compatibility(numpy)
// Equivalent to np.fft.rfftn with 3 dimensions.
// @end_compatibility
func RFFT3D(scope *Scope, input tf.Output, fft_length tf.Output, optional ...RFFT3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RFFT3D",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reorders a SparseTensor into the canonical, row-major ordering.
//
// Note that by convention, all sparse ops preserve the canonical ordering along
// increasing dimension number. The only time ordering can be violated is during
// manual manipulation of the indices and values vectors to add entries.
//
// Reordering does not affect the shape of the SparseTensor.
//
// If the tensor has rank `R` and `N` non-empty values, `input_indices` has
// shape `[N, R]`, input_values has length `N`, and input_shape has length `R`.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//
// Returns:
//	output_indices: 2-D.  `N x R` matrix with the same indices as input_indices, but
// in canonical row-major ordering.
//	output_values: 1-D.  `N` non-empty values corresponding to `output_indices`.
func SparseReorder(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output) (output_indices tf.Output, output_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseReorder",
		Input: []tf.Input{
			input_indices, input_values, input_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Generates fingerprint values.
//
// Generates fingerprint values of `data`.
//
// Fingerprint op considers the first dimension of `data` as the batch dimension,
// and `output[i]` contains the fingerprint value generated from contents in
// `data[i, ...]` for all `i`.
//
// Fingerprint op writes fingerprint values as byte arrays. For example, the
// default method `farmhash64` generates a 64-bit fingerprint value at a time.
// This 8-byte value is written out as an `uint8` array of size 8, in little-endian
// order.
//
// For example, suppose that `data` has data type `DT_INT32` and shape (2, 3, 4),
// and that the fingerprint method is `farmhash64`. In this case, the output shape
// is (2, 8), where 2 is the batch dimension size of `data`, and 8 is the size of
// each fingerprint value in bytes. `output[0, :]` is generated from 12 integers in
// `data[0, :, :]` and similarly `output[1, :]` is generated from other 12 integers
// in `data[1, :, :]`.
//
// Note that this op fingerprints the raw underlying buffer, and it does not
// fingerprint Tensor's metadata such as data type and/or shape. For example, the
// fingerprint values are invariant under reshapes and bitcasts as long as the
// batch dimension remain the same:
//
// ```
// Fingerprint(data) == Fingerprint(Reshape(data, ...))
// Fingerprint(data) == Fingerprint(Bitcast(data, ...))
// ```
//
// For string data, one should expect `Fingerprint(data) !=
// Fingerprint(ReduceJoin(data))` in general.
//
// Arguments:
//	data: Must have rank 1 or higher.
//	method: Fingerprint method used by this op. Currently available method is
// `farmhash::fingerprint64`.
//
// Returns A two-dimensional `Tensor` of type `tf.uint8`. The first dimension equals to
// `data`'s first dimension, and the second dimension size depends on the
// fingerprint algorithm.
func Fingerprint(scope *Scope, data tf.Output, method tf.Output) (fingerprint tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fingerprint",
		Input: []tf.Input{
			data, method,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CopyAttr is an optional argument to Copy.
type CopyAttr func(optionalAttr)

// CopyTensorName sets the optional tensor_name attribute to value.
//
// value: The name of the input tensor.
// If not specified, defaults to ""
func CopyTensorName(value string) CopyAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// CopyDebugOpsSpec sets the optional debug_ops_spec attribute to value.
//
// value: A list of debug op spec (op, url, gated_grpc) for attached debug
// ops. Each element of the list has the format
// <debug_op>;<grpc_url>;<gated_grpc>, wherein gated_grpc is boolean represented
// as 0/1. E.g., "DebugIdentity;grpc://foo:3333;1",
// "DebugIdentity;file:///tmp/tfdbg_1;0".
// If not specified, defaults to {}
func CopyDebugOpsSpec(value []string) CopyAttr {
	return func(m optionalAttr) {
		m["debug_ops_spec"] = value
	}
}

// Copy a tensor from CPU-to-CPU or GPU-to-GPU.
//
// Performs CPU-to-CPU or GPU-to-GPU deep-copying of tensor, depending on the
// device on which the tensor is allocated.
// N.B.: If the all downstream attached debug ops are disabled given the current
// gRPC gating status, the output will simply forward the input tensor without
// deep-copying. See the documentation of Debug* ops for more details.
//
// Unlike the CopyHost Op, this op does not have HostMemory constraint on its
// input or output.
//
// Arguments:
//	input: Input tensor.
func Copy(scope *Scope, input tf.Output, optional ...CopyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Copy",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Updates specified rows 'i' with values 'v'.
//
// Computes `x[i, :] = v; return x`.
//
// Originally this function is mutative however for compilation we make this
// operation create / operate on a copy of `x`.
//
// Arguments:
//	x: A tensor of type `T`.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceUpdate(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceUpdate",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Table initializer that takes two tensors for keys and values respectively.
//
// Arguments:
//	table_handle: Handle to a table which will be initialized.
//	keys: Keys of type Tkey.
//	values: Values of type Tval.
//
// Returns the created operation.
func InitializeTableV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InitializeTableV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// BatchToSpace for N-D tensors of type T.
//
// This operation reshapes the "batch" dimension 0 into `M + 1` dimensions of shape
// `block_shape + [batch]`, interleaves these blocks back into the grid defined by
// the spatial dimensions `[1, ..., M]`, to obtain a result with the same rank as
// the input.  The spatial dimensions of this intermediate result are then
// optionally cropped according to `crops` to produce the output.  This is the
// reverse of SpaceToBatch.  See below for a precise description.
//
// Arguments:
//	input: N-D with shape `input_shape = [batch] + spatial_shape + remaining_shape`,
// where spatial_shape has M dimensions.
//	block_shape: 1-D with shape `[M]`, all values must be >= 1.
//	crops: 2-D with shape `[M, 2]`, all values must be >= 0.
//   `crops[i] = [crop_start, crop_end]` specifies the amount to crop from input
//   dimension `i + 1`, which corresponds to spatial dimension `i`.  It is
//   required that
//   `crop_start[i] + crop_end[i] <= block_shape[i] * input_shape[i + 1]`.
//
// This operation is equivalent to the following steps:
//
// 1. Reshape `input` to `reshaped` of shape:
//      [block_shape[0], ..., block_shape[M-1],
//       batch / prod(block_shape),
//       input_shape[1], ..., input_shape[N-1]]
//
// 2. Permute dimensions of `reshaped` to produce `permuted` of shape
//      [batch / prod(block_shape),
//
//       input_shape[1], block_shape[0],
//       ...,
//       input_shape[M], block_shape[M-1],
//
//       input_shape[M+1], ..., input_shape[N-1]]
//
// 3. Reshape `permuted` to produce `reshaped_permuted` of shape
//      [batch / prod(block_shape),
//
//       input_shape[1] * block_shape[0],
//       ...,
//       input_shape[M] * block_shape[M-1],
//
//       input_shape[M+1],
//       ...,
//       input_shape[N-1]]
//
// 4. Crop the start and end of dimensions `[1, ..., M]` of
//    `reshaped_permuted` according to `crops` to produce the output of shape:
//      [batch / prod(block_shape),
//
//       input_shape[1] * block_shape[0] - crops[0,0] - crops[0,1],
//       ...,
//       input_shape[M] * block_shape[M-1] - crops[M-1,0] - crops[M-1,1],
//
//       input_shape[M+1], ..., input_shape[N-1]]
//
// Some examples:
//
// (1) For the following input of shape `[4, 1, 1, 1]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [0, 0]]`:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// (2) For the following input of shape `[4, 1, 1, 3]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [0, 0]]`:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 3]` and value:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[4, 2, 2, 1]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// The output tensor has shape `[1, 4, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//      [[5],   [6],  [7],  [8]],
//      [[9],  [10], [11],  [12]],
//      [[13], [14], [15],  [16]]]]
// ```
//
// (4) For the following input of shape `[8, 1, 3, 1]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [2, 0]]`:
//
// ```
// x = [[[[0], [1], [3]]], [[[0], [9], [11]]],
//      [[[0], [2], [4]]], [[[0], [10], [12]]],
//      [[[0], [5], [7]]], [[[0], [13], [15]]],
//      [[[0], [6], [8]]], [[[0], [14], [16]]]]
// ```
//
// The output tensor has shape `[2, 2, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]]],
//      [[[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
func BatchToSpaceND(scope *Scope, input tf.Output, block_shape tf.Output, crops tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BatchToSpaceND",
		Input: []tf.Input{
			input, block_shape, crops,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FIFOQueueV2Attr is an optional argument to FIFOQueueV2.
type FIFOQueueV2Attr func(optionalAttr)

// FIFOQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types. If the length of
// this attr is 0, the shapes of queue elements are not constrained, and
// only one element may be dequeued at a time.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func FIFOQueueV2Shapes(value []tf.Shape) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// FIFOQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func FIFOQueueV2Capacity(value int64) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// FIFOQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func FIFOQueueV2Container(value string) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// FIFOQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func FIFOQueueV2SharedName(value string) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that produces elements in first-in first-out order.
//
// Arguments:
//	component_types: The type of each component in a value.
//
// Returns The handle to the queue.
func FIFOQueueV2(scope *Scope, component_types []tf.DataType, optional ...FIFOQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FIFOQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Quantized Batch normalization.
//
// This op is deprecated and will be removed in the future. Prefer
// `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	t_min: The value represented by the lowest quantized input.
//	t_max: The value represented by the highest quantized input.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	m_min: The value represented by the lowest quantized mean.
//	m_max: The value represented by the highest quantized mean.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	v_min: The value represented by the lowest quantized variance.
//	v_max: The value represented by the highest quantized variance.
//	beta: A 1D beta Tensor with size matching the last dimension of t.
// An offset to be added to the normalized tensor.
//	beta_min: The value represented by the lowest quantized offset.
//	beta_max: The value represented by the highest quantized offset.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this tensor will be multiplied
// with the normalized tensor.
//	gamma_min: The value represented by the lowest quantized gamma.
//	gamma_max: The value represented by the highest quantized gamma.
//
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
func QuantizedBatchNormWithGlobalNormalization(scope *Scope, t tf.Output, t_min tf.Output, t_max tf.Output, m tf.Output, m_min tf.Output, m_max tf.Output, v tf.Output, v_min tf.Output, v_max tf.Output, beta tf.Output, beta_min tf.Output, beta_max tf.Output, gamma tf.Output, gamma_min tf.Output, gamma_max tf.Output, out_type tf.DataType, variance_epsilon float32, scale_after_normalization bool) (result tf.Output, result_min tf.Output, result_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type, "variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "QuantizedBatchNormWithGlobalNormalization",
		Input: []tf.Input{
			t, t_min, t_max, m, m_min, m_max, v, v_min, v_max, beta, beta_min, beta_max, gamma, gamma_min, gamma_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceStridedSliceAssignAttr is an optional argument to ResourceStridedSliceAssign.
type ResourceStridedSliceAssignAttr func(optionalAttr)

// ResourceStridedSliceAssignBeginMask sets the optional begin_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignBeginMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["begin_mask"] = value
	}
}

// ResourceStridedSliceAssignEndMask sets the optional end_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignEndMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["end_mask"] = value
	}
}

// ResourceStridedSliceAssignEllipsisMask sets the optional ellipsis_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignEllipsisMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["ellipsis_mask"] = value
	}
}

// ResourceStridedSliceAssignNewAxisMask sets the optional new_axis_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignNewAxisMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["new_axis_mask"] = value
	}
}

// ResourceStridedSliceAssignShrinkAxisMask sets the optional shrink_axis_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignShrinkAxisMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["shrink_axis_mask"] = value
	}
}

// Assign `value` to the sliced l-value reference of `ref`.
//
// The values of `value` are assigned to the positions in the variable
// `ref` that are selected by the slice parameters. The slice parameters
// `begin, `end`, `strides`, etc. work exactly as in `StridedSlice`.
//
// NOTE this op currently does not support broadcasting and so `value`'s
// shape must be exactly the shape produced by the slice of `ref`.
//
// Returns the created operation.
func ResourceStridedSliceAssign(scope *Scope, ref tf.Output, begin tf.Output, end tf.Output, strides tf.Output, value tf.Output, optional ...ResourceStridedSliceAssignAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceStridedSliceAssign",
		Input: []tf.Input{
			ref, begin, end, strides, value,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// QuantizedRelu6Attr is an optional argument to QuantizedRelu6.
type QuantizedRelu6Attr func(optionalAttr)

// QuantizedRelu6OutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedRelu6OutType(value tf.DataType) QuantizedRelu6Attr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Computes Quantized Rectified Linear 6: `min(max(features, 0), 6)`
//
// Arguments:
//
//	min_features: The float value that the lowest quantized value represents.
//	max_features: The float value that the highest quantized value represents.
//
// Returns:
//	activations: Has the same output shape as "features".
//	min_activations: The float value that the lowest quantized value represents.
//	max_activations: The float value that the highest quantized value represents.
func QuantizedRelu6(scope *Scope, features tf.Output, min_features tf.Output, max_features tf.Output, optional ...QuantizedRelu6Attr) (activations tf.Output, min_activations tf.Output, max_activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedRelu6",
		Input: []tf.Input{
			features, min_features, max_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DataFormatVecPermuteAttr is an optional argument to DataFormatVecPermute.
type DataFormatVecPermuteAttr func(optionalAttr)

// DataFormatVecPermuteSrcFormat sets the optional src_format attribute to value.
//
// value: source data format.
// If not specified, defaults to "NHWC"
func DataFormatVecPermuteSrcFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["src_format"] = value
	}
}

// DataFormatVecPermuteDstFormat sets the optional dst_format attribute to value.
//
// value: destination data format.
// If not specified, defaults to "NCHW"
func DataFormatVecPermuteDstFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["dst_format"] = value
	}
}

// Permute input tensor from `src_format` to `dst_format`.
//
// Input tensor must be a vector of size 4, or a 4x2 tensor.
//
// For example, with `src_format` of `NHWC`, `dst_format` of `NCHW`, and inputs:
// ```
// [1, 2, 3, 4]
// ```
// and
// ```
// [[1, 2, 3, 4],
//  [5, 6, 7, 8]]
// ```
// , the outputs will be (respectively):
// ```
// [1, 4, 2, 3]
// ```
// and
// ```
// [[1, 4, 2, 3],
//  [5, 8, 6, 7]]
// ```
//
// Arguments:
//	x: Vector of size 4 or Tensor of shape (4, 2) in source data format.
//
// Returns Vector of size 4 or Tensor of shape (4, 2) in destination data format.
func DataFormatVecPermute(scope *Scope, x tf.Output, optional ...DataFormatVecPermuteAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataFormatVecPermute",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds Tensor 'bias' to Tensor 'input' for Quantized types.
//
// Broadcasts the values of bias on dimensions 0..N-2 of 'input'.
//
// Arguments:
//
//	bias: A 1D bias Tensor with size matching the last dimension of 'input'.
//	min_input: The float value that the lowest quantized input value represents.
//	max_input: The float value that the highest quantized input value represents.
//	min_bias: The float value that the lowest quantized bias value represents.
//	max_bias: The float value that the highest quantized bias value represents.
//
//
// Returns:
//	output
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedBiasAdd(scope *Scope, input tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_bias tf.Output, max_bias tf.Output, out_type tf.DataType) (output tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "QuantizedBiasAdd",
		Input: []tf.Input{
			input, bias, min_input, max_input, min_bias, max_bias,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// MutableDenseHashTableV2Attr is an optional argument to MutableDenseHashTableV2.
type MutableDenseHashTableV2Attr func(optionalAttr)

// MutableDenseHashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableDenseHashTableV2Container(value string) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableDenseHashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableDenseHashTableV2SharedName(value string) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableDenseHashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
// If not specified, defaults to false
func MutableDenseHashTableV2UseNodeNameSharing(value bool) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// MutableDenseHashTableV2ValueShape sets the optional value_shape attribute to value.
//
// value: The shape of each value.
// If not specified, defaults to {}
func MutableDenseHashTableV2ValueShape(value tf.Shape) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["value_shape"] = value
	}
}

// MutableDenseHashTableV2InitialNumBuckets sets the optional initial_num_buckets attribute to value.
//
// value: The initial number of hash table buckets. Must be a power
// to 2.
// If not specified, defaults to 131072
func MutableDenseHashTableV2InitialNumBuckets(value int64) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["initial_num_buckets"] = value
	}
}

// MutableDenseHashTableV2MaxLoadFactor sets the optional max_load_factor attribute to value.
//
// value: The maximum ratio between number of entries and number of
// buckets before growing the table. Must be between 0 and 1.
// If not specified, defaults to 0.8
func MutableDenseHashTableV2MaxLoadFactor(value float32) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["max_load_factor"] = value
	}
}

// Creates an empty hash table that uses tensors as the backing store.
//
// It uses "open addressing" with quadratic reprobing to resolve
// collisions.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a scalar. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//	empty_key: The key used to represent empty key buckets internally. Must not
// be used in insert or lookup operations.
//
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableDenseHashTableV2(scope *Scope, empty_key tf.Output, deleted_key tf.Output, value_dtype tf.DataType, optional ...MutableDenseHashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableDenseHashTableV2",
		Input: []tf.Input{
			empty_key, deleted_key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalAvgPoolGradAttr is an optional argument to FractionalAvgPoolGrad.
type FractionalAvgPoolGradAttr func(optionalAttr)

// FractionalAvgPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolGradOverlapping(value bool) FractionalAvgPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalAvgPool function.
//
// Unlike FractionalMaxPoolGrad, we don't need to find arg_max for
// FractionalAvgPoolGrad, we just need to evenly back-propagate each element of
// out_backprop to those indices that form the same pooling cell. Therefore, we
// just need to know the shape of original input tensor, instead of the whole
// tensor.
//
// Arguments:
//	orig_input_tensor_shape: Original input tensor shape for `fractional_avg_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
// w.r.t. the output of `fractional_avg_pool`.
//	row_pooling_sequence: row pooling sequence, form pooling region with
// col_pooling_sequence.
//	col_pooling_sequence: column pooling sequence, form pooling region with
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_avg_pool`.
func FractionalAvgPoolGrad(scope *Scope, orig_input_tensor_shape tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalAvgPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPoolGrad",
		Input: []tf.Input{
			orig_input_tensor_shape, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalMaxPoolGradAttr is an optional argument to FractionalMaxPoolGrad.
type FractionalMaxPoolGradAttr func(optionalAttr)

// FractionalMaxPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [20, 16] for fractional max pooling.
// If not specified, defaults to false
func FractionalMaxPoolGradOverlapping(value bool) FractionalMaxPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalMaxPool function.
//
// Arguments:
//	orig_input: Original input for `fractional_max_pool`
//	orig_output: Original output for `fractional_max_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
// w.r.t. the output of `fractional_max_pool`.
//	row_pooling_sequence: row pooling sequence, form pooling region with
// col_pooling_sequence.
//	col_pooling_sequence: column pooling sequence, form pooling region with
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_max_pool`.
func FractionalMaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalMaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalMaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps the XLA ConvGeneralDilated operator, documented at
//
//  https://www.tensorflow.org/performance/xla/operation_semantics#conv_convolution
// .
//
// Arguments:
//	lhs: the input tensor
//	rhs: the kernel tensor
//	window_strides: the inter-window strides
//	padding: the padding to apply at the start and end of each input dimensions
//	lhs_dilation: dilation to apply between input elements
//	rhs_dilation: dilation to apply between kernel elements
//	feature_group_count: number of feature groups for grouped convolution.
//	dimension_numbers: a serialized xla::ConvolutionDimensionNumbers proto.
//	precision_config: a serialized xla::PrecisionConfig proto.
func XlaConv(scope *Scope, lhs tf.Output, rhs tf.Output, window_strides tf.Output, padding tf.Output, lhs_dilation tf.Output, rhs_dilation tf.Output, feature_group_count tf.Output, dimension_numbers string, precision_config string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dimension_numbers": dimension_numbers, "precision_config": precision_config}
	opspec := tf.OpSpec{
		Type: "XlaConv",
		Input: []tf.Input{
			lhs, rhs, window_strides, padding, lhs_dilation, rhs_dilation, feature_group_count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NthElementAttr is an optional argument to NthElement.
type NthElementAttr func(optionalAttr)

// NthElementReverse sets the optional reverse attribute to value.
//
// value: When set to True, find the nth-largest value in the vector and vice
// versa.
// If not specified, defaults to false
func NthElementReverse(value bool) NthElementAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Finds values of the `n`-th order statistic for the last dimension.
//
// If the input is a vector (rank-1), finds the entries which is the nth-smallest
// value in the vector and outputs their values as scalar tensor.
//
// For matrices (resp. higher rank input), computes the entries which is the
// nth-smallest value in each row (resp. vector along the last dimension). Thus,
//
//     values.shape = input.shape[:-1]
//
// Arguments:
//	input: 1-D or higher with last dimension at least `n+1`.
//	n: 0-D. Position of sorted vector to select along the last dimension (along
// each row for matrices). Valid range of n is `[0, input.shape[:-1])`
//
// Returns The `n`-th order statistic along each last dimensional slice.
func NthElement(scope *Scope, input tf.Output, n tf.Output, optional ...NthElementAttr) (values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NthElement",
		Input: []tf.Input{
			input, n,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor.
//
// This operation pads `input` according to the `paddings` and `constant_values`
// you specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is
// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many padding values to add before the contents of `input` in that dimension,
// and `paddings[D, 1]` indicates how many padding values to add after the contents
// of `input` in that dimension. `constant_values` is a scalar tensor of the same
// type as `input` that indicates the value to use for padding `input`.
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 1], [2, 2]]
// # 'paddings' is [[1, 1], [2, 2]]
// # 'constant_values' is 0
// # rank of 't' is 2
// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
//                       [0, 0, 1, 1, 0, 0]
//                       [0, 0, 2, 2, 0, 0]
//                       [0, 0, 0, 0, 0, 0]]
// ```
func PadV2(scope *Scope, input tf.Output, paddings tf.Output, constant_values tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "PadV2",
		Input: []tf.Input{
			input, paddings, constant_values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes cos of x element-wise.
//
//   Given an input tensor, this function computes cosine of every
//   element in the tensor. Input range is `(-inf, inf)` and
//   output range is `[-1,1]`. If input lies outside the boundary, `nan`
//   is returned.
//
//   ```python
//   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10000, float("inf")])
//   tf.math.cos(x) ==> [nan -0.91113025 0.87758255 0.5403023 0.36235774 0.48718765 -0.95215535 nan]
//   ```
func Cos(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cos",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TopKV2Attr is an optional argument to TopKV2.
type TopKV2Attr func(optionalAttr)

// TopKV2Sorted sets the optional sorted attribute to value.
//
// value: If true the resulting `k` elements will be sorted by the values in
// descending order.
// If not specified, defaults to true
func TopKV2Sorted(value bool) TopKV2Attr {
	return func(m optionalAttr) {
		m["sorted"] = value
	}
}

// Finds values and indices of the `k` largest elements for the last dimension.
//
// If the input is a vector (rank-1), finds the `k` largest entries in the vector
// and outputs their values and indices as vectors.  Thus `values[j]` is the
// `j`-th largest entry in `input`, and its index is `indices[j]`.
//
// For matrices (resp. higher rank input), computes the top `k` entries in each
// row (resp. vector along the last dimension).  Thus,
//
//     values.shape = indices.shape = input.shape[:-1] + [k]
//
// If two elements are equal, the lower-index element appears first.
//
// Arguments:
//	input: 1-D or higher with last dimension at least `k`.
//	k: 0-D.  Number of top elements to look for along the last dimension (along each
// row for matrices).
//
// Returns:
//	values: The `k` largest elements along each last dimensional slice.
//	indices: The indices of `values` within the last dimension of `input`.
func TopKV2(scope *Scope, input tf.Output, k tf.Output, optional ...TopKV2Attr) (values tf.Output, indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TopKV2",
		Input: []tf.Input{
			input, k,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// TopKAttr is an optional argument to TopK.
type TopKAttr func(optionalAttr)

// TopKSorted sets the optional sorted attribute to value.
//
// value: If true the resulting `k` elements will be sorted by the values in
// descending order.
// If not specified, defaults to true
func TopKSorted(value bool) TopKAttr {
	return func(m optionalAttr) {
		m["sorted"] = value
	}
}

// Finds values and indices of the `k` largest elements for the last dimension.
//
// DEPRECATED at GraphDef version 7: Use TopKV2 instead
//
// If the input is a vector (rank-1), finds the `k` largest entries in the vector
// and outputs their values and indices as vectors.  Thus `values[j]` is the
// `j`-th largest entry in `input`, and its index is `indices[j]`.
//
// For matrices (resp. higher rank input), computes the top `k` entries in each
// row (resp. vector along the last dimension).  Thus,
//
//     values.shape = indices.shape = input.shape[:-1] + [k]
//
// If two elements are equal, the lower-index element appears first.
//
// If `k` varies dynamically, use `TopKV2` below.
//
// Arguments:
//	input: 1-D or higher with last dimension at least `k`.
//	k: Number of top elements to look for along the last dimension (along each
// row for matrices).
//
// Returns:
//	values: The `k` largest elements along each last dimensional slice.
//	indices: The indices of `values` within the last dimension of `input`.
func TopK(scope *Scope, input tf.Output, k int64, optional ...TopKAttr) (values tf.Output, indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TopK",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// DatasetToSingleElementAttr is an optional argument to DatasetToSingleElement.
type DatasetToSingleElementAttr func(optionalAttr)

// DatasetToSingleElementMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func DatasetToSingleElementMetadata(value string) DatasetToSingleElementAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Outputs the single element from the given dataset.
//
// Arguments:
//	dataset: A handle to a dataset that contains a single element.
//
//
//
// Returns The components of the single element of `input`.
func DatasetToSingleElement(scope *Scope, dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DatasetToSingleElementAttr) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToSingleElement",
		Input: []tf.Input{
			dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("DatasetToSingleElement", err)
		return
	}
	return components
}

// Computes softmax cross entropy cost and gradients to backpropagate.
//
// Inputs are the logits, not probabilities.
//
// Arguments:
//	features: batch_size x num_classes matrix
//	labels: batch_size x num_classes matrix
// The caller must ensure that each batch of labels represents a valid
// probability distribution.
//
// Returns:
//	loss: Per example loss (batch_size vector).
//	backprop: backpropagated gradients (batch_size x num_classes matrix).
func SoftmaxCrossEntropyWithLogits(scope *Scope, features tf.Output, labels tf.Output) (loss tf.Output, backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SoftmaxCrossEntropyWithLogits",
		Input: []tf.Input{
			features, labels,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes log softmax activations.
//
// For each batch `i` and class `j` we have
//
//     logsoftmax[i, j] = logits[i, j] - log(sum(exp(logits[i])))
//
// Arguments:
//	logits: 2-D with shape `[batch_size, num_classes]`.
//
// Returns Same shape as `logits`.
func LogSoftmax(scope *Scope, logits tf.Output) (logsoftmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogSoftmax",
		Input: []tf.Input{
			logits,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softmax activations.
//
// For each batch `i` and class `j` we have
//
//     $$softmax[i, j] = exp(logits[i, j]) / sum_j(exp(logits[i, j]))$$
//
// Arguments:
//	logits: 2-D with shape `[batch_size, num_classes]`.
//
// Returns Same shape as `logits`.
func Softmax(scope *Scope, logits tf.Output) (softmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Softmax",
		Input: []tf.Input{
			logits,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softsign gradients for a softsign operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding softsign operation.
//	features: The features passed as input to the corresponding softsign operation.
//
// Returns The gradients: `gradients / (1 + abs(features)) ** 2`.
func SoftsignGrad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SoftsignGrad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Resizes the list.
//
//
// input_handle: the input list
// size: size of the output list
//
func TensorListResize(scope *Scope, input_handle tf.Output, size tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListResize",
		Input: []tf.Input{
			input_handle, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormAttr is an optional argument to FusedBatchNorm.
type FusedBatchNormAttr func(optionalAttr)

// FusedBatchNormEpsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormEpsilon(value float32) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormExponentialAvgFactor(value float32) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormDataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormDataFormat(value string) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormIsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormIsTraining(value bool) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
// must be empty for training.
//	variance: A 1D Tensor for population variance. Used for inference only;
// must be empty for training.
//
// Returns:
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
// to compute the running mean.
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
// TensorFlow to compute the running variance.
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
// in the gradient computation.
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
// in the cuDNN case), to be reused in the gradient computation.
func FusedBatchNorm(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormAttr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNorm",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// SparseMatMulAttr is an optional argument to SparseMatMul.
type SparseMatMulAttr func(optionalAttr)

// SparseMatMulTransposeA sets the optional transpose_a attribute to value.
// If not specified, defaults to false
func SparseMatMulTransposeA(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// SparseMatMulTransposeB sets the optional transpose_b attribute to value.
// If not specified, defaults to false
func SparseMatMulTransposeB(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// SparseMatMulAIsSparse sets the optional a_is_sparse attribute to value.
// If not specified, defaults to false
func SparseMatMulAIsSparse(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["a_is_sparse"] = value
	}
}

// SparseMatMulBIsSparse sets the optional b_is_sparse attribute to value.
// If not specified, defaults to false
func SparseMatMulBIsSparse(value bool) SparseMatMulAttr {
	return func(m optionalAttr) {
		m["b_is_sparse"] = value
	}
}

// Multiply matrix "a" by matrix "b".
//
// The inputs must be two-dimensional matrices and the inner dimension of "a" must
// match the outer dimension of "b". Both "a" and "b" must be `Tensor`s not
// `SparseTensor`s.  This op is optimized for the case where at least one of "a" or
// "b" is sparse, in the sense that they have a large proportion of zero values.
// The breakeven for using this versus a dense matrix multiply on one platform was
// 30% zero values in the sparse matrix.
//
// The gradient computation of this operation will only take advantage of sparsity
// in the input gradient when that gradient comes from a Relu.
func SparseMatMul(scope *Scope, a tf.Output, b tf.Output, optional ...SparseMatMulAttr) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseMatMul",
		Input: []tf.Input{
			a, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the LSTM cell backward propagation for 1 timestep.
//
// This implementation is to be used in conjunction of LSTMBlockCell.
//
// Arguments:
//	x: The input to the LSTM cell, shape (batch_size, num_inputs).
//	cs_prev: The previous cell state.
//	h_prev: The previous h state.
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//	i: The input gate.
//	cs: The cell state before the tanh.
//	f: The forget gate.
//	o: The output gate.
//	ci: The cell input.
//	co: The cell after the tanh.
//	cs_grad: The current gradient of cs.
//	h_grad: The gradient of h vector.
//	use_peephole: Whether the cell uses peephole connections.
//
// Returns:
//	cs_prev_grad: The gradient of cs to be back-propped.
//	dicfo: The derivative wrt to [i, cs, f, o].
//	wci_grad: The gradient for wci to be back-propped.
//	wcf_grad: The gradient for wcf to be back-propped.
//	wco_grad: The gradient for wco to be back-propped.
func LSTMBlockCellGrad(scope *Scope, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, cs_grad tf.Output, h_grad tf.Output, use_peephole bool) (cs_prev_grad tf.Output, dicfo tf.Output, wci_grad tf.Output, wcf_grad tf.Output, wco_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"use_peephole": use_peephole}
	opspec := tf.OpSpec{
		Type: "LSTMBlockCellGrad",
		Input: []tf.Input{
			x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, cs_grad, h_grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Computes gradients for the scaled exponential linear (Selu) operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Selu operation.
//	outputs: The outputs of the corresponding Selu operation.
//
// Returns The gradients: `gradients * (outputs + scale * alpha)`
// if outputs < 0, `scale * gradients` otherwise.
func SeluGrad(scope *Scope, gradients tf.Output, outputs tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SeluGrad",
		Input: []tf.Input{
			gradients, outputs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LeakyReluGradAttr is an optional argument to LeakyReluGrad.
type LeakyReluGradAttr func(optionalAttr)

// LeakyReluGradAlpha sets the optional alpha attribute to value.
// If not specified, defaults to 0.2
func LeakyReluGradAlpha(value float32) LeakyReluGradAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// Computes rectified linear gradients for a LeakyRelu operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding LeakyRelu operation.
//	features: The features passed as input to the corresponding LeakyRelu operation,
// OR the outputs of that operation (both work equivalently).
//
// Returns `gradients * (features > 0) + alpha * gradients * (features <= 0)`.
func LeakyReluGrad(scope *Scope, gradients tf.Output, features tf.Output, optional ...LeakyReluGradAttr) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LeakyReluGrad",
		Input: []tf.Input{
			gradients, features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of morphological 2-D dilation with respect to the filter.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
// Must be: `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 3-D with shape `[filter_height, filter_width, depth]`.
func Dilation2DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (filter_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts the given variant tensor to an iterator and stores it in the given resource.
//
// Arguments:
//	resource_handle: A handle to an iterator resource.
//	serialized: A variant tensor storing the state of the iterator contained in the
// resource.
//
// Returns the created operation.
func DeserializeIterator(scope *Scope, resource_handle tf.Output, serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeserializeIterator",
		Input: []tf.Input{
			resource_handle, serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the gradient for the rsqrt of `x` wrt its input.
//
// Specifically, `grad = dy * -0.5 * y^3`, where `y = rsqrt(x)`, and `dy`
// is the corresponding input gradient.
func RsqrtGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RsqrtGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolWithArgmaxAttr is an optional argument to MaxPoolWithArgmax.
type MaxPoolWithArgmaxAttr func(optionalAttr)

// MaxPoolWithArgmaxTargmax sets the optional Targmax attribute to value.
// If not specified, defaults to DT_INT64
func MaxPoolWithArgmaxTargmax(value tf.DataType) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["Targmax"] = value
	}
}

// MaxPoolWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolWithArgmaxIncludeBatchInIndex(value bool) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Performs max pooling on the input and outputs both max values and indices.
//
// The indices in `argmax` are flattened, so that a maximum value at position
// `[b, y, x, c]` becomes flattened index:
// `(y * width + x) * channels + c` if `include_batch_in_index` is False;
// `((b * height + y) * width + x) * channels + c` if `include_batch_in_index` is True.
//
// The indices returned are always in `[0, height) x [0, width)` before flattening,
// even if padding is involved and the mathematically correct answer is outside
// (either negative or too large).  This is a bug, but fixing it is difficult to do
// in a safe backwards compatible way, especially due to flattening.
//
// Arguments:
//	input: 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns:
//	output: The max pooled output tensor.
//	argmax: 4-D.  The flattened indices of the max values chosen for each output.
func MaxPoolWithArgmax(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolWithArgmaxAttr) (output tf.Output, argmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolWithArgmax",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Returns the number of tensors in the input tensor map.
//
// input_handle: the input map
// size: the number of tensors in the map
func TensorMapSize(scope *Scope, input_handle tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorMapSize",
		Input: []tf.Input{
			input_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradAttr is an optional argument to MaxPoolGradGrad.
type MaxPoolGradGradAttr func(optionalAttr)

// MaxPoolGradGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradGradDataFormat(value string) MaxPoolGradGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPoolGradGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Takes the packed uint32 input and unpacks the input to uint8 to do
//
// Dequantization on device.
//
// Arguments:
//	input: Input tensors whose types is uint32, shape is [d0, ..., dn].
//	min_range: The minimum scalar value possibly produced for the input.
//	max_range: The maximum scalar value possibly produced for the input.
//	mode: String to determine the dequantize mode in {"MIN_COMBINED", "MIN_FIRST", "SCALED"}.
//	transpose_output: Boolean to determine if output is transposed. transpose_output
// is faster when input is large and rank of input is higher than 1.
//
// Returns Output tensors whose types is bloat16. If transpose_output is true,
// output shape is [dn * 4, dn-1, ..., d1, d0]. If transpose_output
// is false, output shape is [d0,..., dn * 4].
func XlaDequantize(scope *Scope, input tf.Output, min_range float32, max_range float32, mode string, transpose_output bool) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"min_range": min_range, "max_range": max_range, "mode": mode, "transpose_output": transpose_output}
	opspec := tf.OpSpec{
		Type: "XlaDequantize",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradV2Attr is an optional argument to MaxPoolGradV2.
type MaxPoolGradV2Attr func(optionalAttr)

// MaxPoolGradV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradV2DataFormat(value string) MaxPoolGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients w.r.t. the output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input to `max_pool`.
func MaxPoolGradV2(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolGradV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradV2",
		Input: []tf.Input{
			orig_input, orig_output, grad, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Concats all tensors in the list along the 0th dimension.
//
// Requires that all tensors have the same shape except the first dimension.
//
// input_handle: The input list.
// element_shape: The shape of the uninitialized elements in the list. If the first
//   dimension is not -1, it is assumed that all list elements have the same
//   leading dim.
// leading_dims: The list of leading dims of uninitialized list elements. Used if
//   the leading dim of input_handle.element_shape or the element_shape input arg
//   is not already set.
// tensor: The concated result.
// lengths: Output tensor containing sizes of the 0th dimension of tensors in the list, used for computing the gradient.
//
func TensorListConcatV2(scope *Scope, input_handle tf.Output, element_shape tf.Output, leading_dims tf.Output, element_dtype tf.DataType) (tensor tf.Output, lengths tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "TensorListConcatV2",
		Input: []tf.Input{
			input_handle, element_shape, leading_dims,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// MaxPoolV2Attr is an optional argument to MaxPoolV2.
type MaxPoolV2Attr func(optionalAttr)

// MaxPoolV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolV2DataFormat(value string) MaxPoolV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs max pooling on the input.
//
// Arguments:
//	input: 4-D input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPoolV2(scope *Scope, input tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolV2",
		Input: []tf.Input{
			input, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseReduceSumAttr is an optional argument to SparseReduceSum.
type SparseReduceSumAttr func(optionalAttr)

// SparseReduceSumKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SparseReduceSumKeepDims(value bool) SparseReduceSumAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the sum of elements across dimensions of a SparseTensor.
//
// This Op takes a SparseTensor and is the sparse counterpart to
// `tf.reduce_sum()`.  In particular, this Op also returns a dense `Tensor`
// instead of a sparse one.
//
// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
// with length 1.
//
// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
// with a single element is returned.  Additionally, the axes can be negative,
// which are interpreted according to the indexing rules in Python.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//	reduction_axes: 1-D.  Length-`K` vector containing the reduction axes.
//
// Returns `R-K`-D.  The reduced Tensor.
func SparseReduceSum(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output, reduction_axes tf.Output, optional ...SparseReduceSumAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseReduceSum",
		Input: []tf.Input{
			input_indices, input_values, input_shape, reduction_axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the Hurwitz zeta function \\(\zeta(x, q)\\).
//
// The Hurwitz zeta function is defined as:
//
//
// \\(\zeta(x, q) = \sum_{n=0}^{\infty} (q + n)^{-x}\\)
func Zeta(scope *Scope, x tf.Output, q tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Zeta",
		Input: []tf.Input{
			x, q,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMatMulWithBiasAndReluAndRequantizeAttr is an optional argument to QuantizedMatMulWithBiasAndReluAndRequantize.
type QuantizedMatMulWithBiasAndReluAndRequantizeAttr func(optionalAttr)

// QuantizedMatMulWithBiasAndReluAndRequantizeToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedMatMulWithBiasAndReluAndRequantizeToutput(value tf.DataType) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluAndRequantizeTransposeA(value bool) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluAndRequantizeTransposeB(value bool) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasAndReluAndRequantizeInputQuantMode(value string) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Perform a quantized matrix multiplication of  `a` by the matrix `b` with bias
// add and relu and requantize fusion.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// multiplication result. The bias size must match inner dimension of `b`.  Then do
// relu activation to get non-negative result. Then do requantize operation to get
// final uint8 result.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching with inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//	min_freezed_output: The float value that the highest quantized output value after requantize.
//
//
// Returns:
//	out
//	min_out: The float value that the lowest quantized output value represents.
//	max_out: The float value that the highest quantized output value represents.
func QuantizedMatMulWithBiasAndReluAndRequantize(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, min_freezed_output tf.Output, max_freezed_output tf.Output, optional ...QuantizedMatMulWithBiasAndReluAndRequantizeAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBiasAndReluAndRequantize",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b, min_freezed_output, max_freezed_output,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Conv3DBackpropInputV2Attr is an optional argument to Conv3DBackpropInputV2.
type Conv3DBackpropInputV2Attr func(optionalAttr)

// Conv3DBackpropInputV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DBackpropInputV2DataFormat(value string) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropInputV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DBackpropInputV2Dilations(value []int64) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the input.
//
// Arguments:
//	input_sizes: An integer vector representing the tensor shape of `input`,
// where `input` is a 5-D
// `[batch, depth, rows, cols, in_channels]` tensor.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
// `in_channels` must match between `input` and `filter`.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropInputV2(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropInputV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropInputV2",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LRNAttr is an optional argument to LRN.
type LRNAttr func(optionalAttr)

// LRNDepthRadius sets the optional depth_radius attribute to value.
//
// value: 0-D.  Half-width of the 1-D normalization window.
// If not specified, defaults to 5
func LRNDepthRadius(value int64) LRNAttr {
	return func(m optionalAttr) {
		m["depth_radius"] = value
	}
}

// LRNBias sets the optional bias attribute to value.
//
// value: An offset (usually positive to avoid dividing by 0).
// If not specified, defaults to 1
func LRNBias(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["bias"] = value
	}
}

// LRNAlpha sets the optional alpha attribute to value.
//
// value: A scale factor, usually positive.
// If not specified, defaults to 1
func LRNAlpha(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// LRNBeta sets the optional beta attribute to value.
//
// value: An exponent.
// If not specified, defaults to 0.5
func LRNBeta(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["beta"] = value
	}
}

// Local Response Normalization.
//
// The 4-D `input` tensor is treated as a 3-D array of 1-D vectors (along the last
// dimension), and each vector is normalized independently.  Within a given vector,
// each component is divided by the weighted, squared sum of inputs within
// `depth_radius`.  In detail,
//
//     sqr_sum[a, b, c, d] =
//         sum(input[a, b, c, d - depth_radius : d + depth_radius + 1] ** 2)
//     output = input / (bias + alpha * sqr_sum) ** beta
//
// For details, see [Krizhevsky et al., ImageNet classification with deep
// convolutional neural networks (NIPS 2012)](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks).
//
// Arguments:
//	input: 4-D.
func LRN(scope *Scope, input tf.Output, optional ...LRNAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LRN",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are Inf.
//
// @compatibility(numpy)
// Equivalent to np.isinf
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, np.inf, 6.8, np.inf])
// tf.math.is_inf(x) ==> [False, True, False, True]
// ```
func IsInf(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsInf",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DAttr is an optional argument to MaxPool3D.
type MaxPool3DAttr func(optionalAttr)

// MaxPool3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func MaxPool3DDataFormat(value string) MaxPool3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs 3D max pooling on the input.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPool3D(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3D",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArrayCloseV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayCloseV3
//
// Returns the created operation.
func TensorArrayCloseV2(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayCloseV2",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the Kth order statistic of a data set. The current
//
// implementation uses a binary search requiring exactly 32 passes over
// the input data. The running time is linear with respect to input
// size. The median-of-medians algorithm is probably faster, but is
// difficult to implement efficiently in XLA. The implementation imposes
// a total ordering on floats. The ordering is consistent with the usual
// partial order.  Positive NaNs are greater than positive
// infinity. Negative NaNs are less than negative infinity. NaNs with
// distinct payloads are treated as distinct. Subnormal numbers are
// preserved (not flushed to zero). Positive infinity is greater than all
// numbers. Negative infinity is less than all numbers. Positive is
// greater than negative zero. There are less than k values greater than
// the kth order statistic. There are at least k values greater than or
// equal to the Kth order statistic. The semantics are not the same as
// top_k_unique.
func KthOrderStatistic(scope *Scope, input tf.Output, k int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	opspec := tf.OpSpec{
		Type: "KthOrderStatistic",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPool3DGradAttr is an optional argument to AvgPool3DGrad.
type AvgPool3DGradAttr func(optionalAttr)

// AvgPool3DGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func AvgPool3DGradDataFormat(value string) AvgPool3DGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of average pooling function.
//
// Arguments:
//	orig_input_shape: The original input dimensions.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns The backprop for input.
func AvgPool3DGrad(scope *Scope, orig_input_shape tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPool3DGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool3DGrad",
		Input: []tf.Input{
			orig_input_shape, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x + y element-wise.
//
// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func AddV2(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AddV2",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AsStringAttr is an optional argument to AsString.
type AsStringAttr func(optionalAttr)

// AsStringPrecision sets the optional precision attribute to value.
//
// value: The post-decimal precision to use for floating point numbers.
// Only used if precision > -1.
// If not specified, defaults to -1
func AsStringPrecision(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["precision"] = value
	}
}

// AsStringScientific sets the optional scientific attribute to value.
//
// value: Use scientific notation for floating point numbers.
// If not specified, defaults to false
func AsStringScientific(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["scientific"] = value
	}
}

// AsStringShortest sets the optional shortest attribute to value.
//
// value: Use shortest representation (either scientific or standard) for
// floating point numbers.
// If not specified, defaults to false
func AsStringShortest(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["shortest"] = value
	}
}

// AsStringWidth sets the optional width attribute to value.
//
// value: Pad pre-decimal numbers to this width.
// Applies to both floating point and integer numbers.
// Only used if width > -1.
// If not specified, defaults to -1
func AsStringWidth(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["width"] = value
	}
}

// AsStringFill sets the optional fill attribute to value.
//
// value: The value to pad if width > -1.  If empty, pads with spaces.
// Another typical value is '0'.  String cannot be longer than 1 character.
// If not specified, defaults to ""
func AsStringFill(value string) AsStringAttr {
	return func(m optionalAttr) {
		m["fill"] = value
	}
}

// Converts each entry in the given tensor to strings.
//
// Supports many numeric types and boolean.
//
// For Unicode, see the
// [https://www.tensorflow.org/tutorials/representation/unicode](Working with Unicode text)
// tutorial.
//
// Examples:
//
// >>> tf.strings.as_string([3, 2])
// <tf.Tensor: shape=(2,), dtype=string, numpy=array([b'3', b'2'], dtype=object)>
// >>> tf.strings.as_string([3.1415926, 2.71828], precision=2).numpy()
// array([b'3.14', b'2.72'], dtype=object)
func AsString(scope *Scope, input tf.Output, optional ...AsStringAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AsString",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterV2Attr is an optional argument to Conv3DBackpropFilterV2.
type Conv3DBackpropFilterV2Attr func(optionalAttr)

// Conv3DBackpropFilterV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DBackpropFilterV2DataFormat(value string) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropFilterV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DBackpropFilterV2Dilations(value []int64) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 5-D
// `[filter_depth, filter_height, filter_width, in_channels, out_channels]`
// tensor.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilterV2(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilterV2",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterAttr is an optional argument to Conv3DBackpropFilter.
type Conv3DBackpropFilterAttr func(optionalAttr)

// Conv3DBackpropFilterDilations sets the optional dilations attribute to value.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DBackpropFilterDilations(value []int64) Conv3DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// DEPRECATED at GraphDef version 10: Use Conv3DBackpropFilterV2
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
// `in_channels` must match between `input` and `filter`.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DAttr is an optional argument to Conv3D.
type Conv3DAttr func(optionalAttr)

// Conv3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DDataFormat(value string) Conv3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DDilations(value []int64) Conv3DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 3-D convolution given 5-D `input` and `filter` tensors.
//
// In signal processing, cross-correlation is a measure of similarity of
// two waveforms as a function of a time-lag applied to one of them. This
// is also known as a sliding dot product or sliding inner-product.
//
// Our Conv3D implements a form of cross-correlation.
//
// Arguments:
//	input: Shape `[batch, in_depth, in_height, in_width, in_channels]`.
//	filter: Shape `[filter_depth, filter_height, filter_width, in_channels,
// out_channels]`. `in_channels` must match between `input` and `filter`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a list which has the passed-in `Tensor` as last element and the other elements of the given list in `input_handle`.
//
// tensor: The tensor to put on the list.
// input_handle: The old list.
// output_handle: A list with the elements of the old list followed by tensor.
// element_dtype: the type of elements in the list.
// element_shape: a shape compatible with that of elements in the list.
func TensorListPushBack(scope *Scope, input_handle tf.Output, tensor tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListPushBack",
		Input: []tf.Input{
			input_handle, tensor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are NaN.
//
// @compatibility(numpy)
// Equivalent to np.isnan
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, np.nan, 6.8, np.nan, np.inf])
// tf.math.is_nan(x) ==> [False, True, False, True, False]
// ```
func IsNan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsNan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds a value to the current value of a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to
// see the incremented value or a subsequent newer one.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	value: the value by which the variable will be incremented.
//
// Returns the created operation.
func AssignAddVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignAddVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// DepthwiseConv2dNativeBackpropInputAttr is an optional argument to DepthwiseConv2dNativeBackpropInput.
type DepthwiseConv2dNativeBackpropInputAttr func(optionalAttr)

// DepthwiseConv2dNativeBackpropInputExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to {}
func DepthwiseConv2dNativeBackpropInputExplicitPaddings(value []int64) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// DepthwiseConv2dNativeBackpropInputDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeBackpropInputDataFormat(value string) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeBackpropInputDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func DepthwiseConv2dNativeBackpropInputDilations(value []int64) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of depthwise convolution with respect to the input.
//
// Arguments:
//	input_sizes: An integer vector representing the shape of `input`, based
// on `data_format`.  For example, if `data_format` is 'NHWC' then
//  `input` is a 4-D `[batch, height, width, channels]` tensor.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, depthwise_multiplier]`.
//	out_backprop: 4-D with shape  based on `data_format`.
// For example, if `data_format` is 'NHWC' then
// out_backprop shape is `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape according to `data_format`.  For example, if
// `data_format` is 'NHWC', output shape is `[batch, in_height,
// in_width, in_channels]`.  Gradient w.r.t. the input of the
// convolution.
func DepthwiseConv2dNativeBackpropInput(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNativeBackpropInput",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Updates the table to associates keys with values.
//
// The tensor `keys` must be of the same type as the keys of the table.
// The tensor `values` must be of the type of the table values.
//
// Arguments:
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//	values: Values to associate with keys.
//
// Returns the created operation.
func LookupTableInsertV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableInsertV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Component-wise multiplies a SparseTensor by a dense Tensor.
//
// The output locations corresponding to the implicitly zero elements in the sparse
// tensor will be zero (i.e., will not take up storage space), regardless of the
// contents of the dense tensor (even if it's +/-INF and that INF*0 == NaN).
//
// *Limitation*: this Op only broadcasts the dense side to the sparse side, but not
// the other direction.
//
// Arguments:
//	sp_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	sp_values: 1-D.  `N` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//	dense: `R`-D.  The dense Tensor operand.
//
// Returns 1-D.  The `N` values that are operated on.
func SparseDenseCwiseMul(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output, dense tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseDenseCwiseMul",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape, dense,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Performs a padding as a preprocess during a convolution.
//
// Similar to FusedResizeAndPadConv2d, this op allows for an optimized
// implementation where the spatial padding transformation stage is fused with the
// im2col lookup, but in this case without the bilinear filtering required for
// resizing. Fusing the padding prevents the need to write out the intermediate
// results as whole tensors, reducing memory pressure, and we can get some latency
// gains by merging the transformation calculations.
// The data_format attribute for Conv2D isn't supported by this op, and 'NHWC'
// order is used instead.
// Internally this op uses a single per-graph scratch buffer, which means that it
// will block if multiple versions are being run in parallel. This is because this
// operator is primarily an optimization to minimize memory usage.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	paddings: A two-column matrix specifying the padding sizes. The number of
// rows must be the same as the rank of `input`.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
// of `input`. Must be in the same order as the dimension specified with format.
//	padding: The type of padding algorithm to use.
func FusedPadConv2D(scope *Scope, input tf.Output, paddings tf.Output, filter tf.Output, mode string, strides []int64, padding string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "FusedPadConv2D",
		Input: []tf.Input{
			input, paddings, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// List of the given size with empty elements.
//
// element_shape: the shape of the future elements of the list
// num_elements: the number of elements to reserve
// handle: the output list
// element_dtype: the desired type of elements in the list.
func TensorListReserve(scope *Scope, element_shape tf.Output, num_elements tf.Output, element_dtype tf.DataType) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "TensorListReserve",
		Input: []tf.Input{
			element_shape, num_elements,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Clips tensor values to a specified min and max.
//
// Given a tensor `t`, this operation returns a tensor of the same type and
// shape as `t` with its values clipped to `clip_value_min` and `clip_value_max`.
// Any values less than `clip_value_min` are set to `clip_value_min`. Any values
// greater than `clip_value_max` are set to `clip_value_max`.
//
// Arguments:
//	t: A `Tensor`.
//	clip_value_min: A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
// as `t`. The minimum value to clip by.
//	clip_value_max: A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
// as `t`. The maximum value to clip by.
//
// Returns A clipped `Tensor` with the same shape as input 't'.
func ClipByValue(scope *Scope, t tf.Output, clip_value_min tf.Output, clip_value_max tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ClipByValue",
		Input: []tf.Input{
			t, clip_value_min, clip_value_max,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropFilterAttr is an optional argument to Conv2DBackpropFilter.
type Conv2DBackpropFilterAttr func(optionalAttr)

// Conv2DBackpropFilterUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropFilterUseCudnnOnGpu(value bool) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropFilterExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func Conv2DBackpropFilterExplicitPaddings(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropFilterDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func Conv2DBackpropFilterDataFormat(value string) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropFilterDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func Conv2DBackpropFilterDilations(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the filter.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 4-D
// `[filter_height, filter_width, in_channels, out_channels]` tensor.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution. Must be in the same order as the dimension specified with
// format.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func Conv2DBackpropFilter(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropFilter",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of x OR y element-wise.
//
// *NOTE*: `LogicalOr` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds `bias` to `value`.
//
// This is a deprecated version of BiasAdd and will be soon removed.
//
// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
// Broadcasting is supported, so `value` may have any number of dimensions.
//
// Arguments:
//	value: Any number of dimensions.
//	bias: 1-D with size the last dimension of `value`.
//
// Returns Broadcasted sum of `value` and `bias`.
func BiasAddV1(scope *Scope, value tf.Output, bias tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BiasAddV1",
		Input: []tf.Input{
			value, bias,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Assigns sparse updates to the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] = updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] = updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] = updates[i, ..., j, ...]
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterUpdate(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterUpdate",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// RandomDatasetAttr is an optional argument to RandomDataset.
type RandomDatasetAttr func(optionalAttr)

// RandomDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func RandomDatasetMetadata(value string) RandomDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a Dataset that returns pseudorandom numbers.
//
// Creates a Dataset that returns a stream of uniformly distributed
// pseudorandom 64-bit signed integers.
//
// In the TensorFlow Python API, you can instantiate this dataset via the
// class `tf.data.experimental.RandomDataset`.
//
// Instances of this dataset are also created as a result of the
// `hoist_random_uniform` static optimization. Whether this optimization is
// performed is determined by the `experimental_optimization.hoist_random_uniform`
// option of `tf.data.Options`.
//
// Arguments:
//	seed: A scalar seed for the random number generator. If either seed or
// seed2 is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//
//
func RandomDataset(scope *Scope, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...RandomDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomDataset",
		Input: []tf.Input{
			seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalAvgPoolAttr is an optional argument to FractionalAvgPool.
type FractionalAvgPoolAttr func(optionalAttr)

// FractionalAvgPoolPseudoRandom sets the optional pseudo_random attribute to value.
//
// value: When set to True, generates the pooling sequence in a
// pseudorandom fashion, otherwise, in a random fashion. Check paper [Benjamin
// Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071) for
// difference between pseudorandom and random.
// If not specified, defaults to false
func FractionalAvgPoolPseudoRandom(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["pseudo_random"] = value
	}
}

// FractionalAvgPoolOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolOverlapping(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// FractionalAvgPoolDeterministic sets the optional deterministic attribute to value.
//
// value: When set to True, a fixed pooling region will be used when
// iterating over a FractionalAvgPool node in the computation graph. Mainly used
// in unit test to make FractionalAvgPool deterministic.
// If not specified, defaults to false
func FractionalAvgPoolDeterministic(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// FractionalAvgPoolSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FractionalAvgPoolSeed(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FractionalAvgPoolSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FractionalAvgPoolSeed2(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Performs fractional average pooling on the input.
//
// Fractional average pooling is similar to Fractional max pooling in the pooling
// region generation step. The only difference is that after pooling regions are
// generated, a mean operation is performed instead of a max operation in each
// pooling region.
//
// Arguments:
//	value: 4-D with shape `[batch, height, width, channels]`.
//	pooling_ratio: Pooling ratio for each dimension of `value`, currently only
// supports row and col dimension and should be >= 1.0. For example, a valid
// pooling ratio looks like [1.0, 1.44, 1.73, 1.0]. The first and last elements
// must be 1.0 because we don't allow pooling on batch and channels
// dimensions. 1.44 and 1.73 are pooling ratio on height and width dimensions
// respectively.
//
// Returns:
//	output: output tensor after fractional avg pooling.
//	row_pooling_sequence: row pooling sequence, needed to calculate gradient.
//	col_pooling_sequence: column pooling sequence, needed to calculate gradient.
func FractionalAvgPool(scope *Scope, value tf.Output, pooling_ratio []float32, optional ...FractionalAvgPoolAttr) (output tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pooling_ratio": pooling_ratio}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// MapStageAttr is an optional argument to MapStage.
type MapStageAttr func(optionalAttr)

// MapStageCapacity sets the optional capacity attribute to value.
//
// value: Maximum number of elements in the Staging Area. If > 0, inserts
// on the container will block when the capacity is reached.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapStageCapacity(value int64) MapStageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapStageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapStageMemoryLimit(value int64) MapStageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapStageContainer sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container. Otherwise,
// a default container is used.
// If not specified, defaults to ""
func MapStageContainer(value string) MapStageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapStageSharedName sets the optional shared_name attribute to value.
//
// value: It is necessary to match this name to the matching Unstage Op.
// If not specified, defaults to ""
func MapStageSharedName(value string) MapStageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Stage (key, values) in the underlying container which behaves like a hashtable.
//
// Arguments:
//	key: int64
//
//	values: a list of tensors
// dtypes A list of data types that inserted values should adhere to.
//
//
// Returns the created operation.
func MapStage(scope *Scope, key tf.Output, indices tf.Output, values []tf.Output, dtypes []tf.DataType, optional ...MapStageAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapStage",
		Input: []tf.Input{
			key, indices, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// SparseTensorDenseMatMulAttr is an optional argument to SparseTensorDenseMatMul.
type SparseTensorDenseMatMulAttr func(optionalAttr)

// SparseTensorDenseMatMulAdjointA sets the optional adjoint_a attribute to value.
//
// value: Use the adjoint of A in the matrix multiply.  If A is complex, this
// is transpose(conj(A)).  Otherwise it's transpose(A).
// If not specified, defaults to false
func SparseTensorDenseMatMulAdjointA(value bool) SparseTensorDenseMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_a"] = value
	}
}

// SparseTensorDenseMatMulAdjointB sets the optional adjoint_b attribute to value.
//
// value: Use the adjoint of B in the matrix multiply.  If B is complex, this
// is transpose(conj(B)).  Otherwise it's transpose(B).
// If not specified, defaults to false
func SparseTensorDenseMatMulAdjointB(value bool) SparseTensorDenseMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_b"] = value
	}
}

// Multiply SparseTensor (of rank 2) "A" by dense matrix "B".
//
// No validity checking is performed on the indices of A.  However, the following
// input format is recommended for optimal behavior:
//
// if adjoint_a == false:
//   A should be sorted in lexicographically increasing order.  Use SparseReorder
//   if you're not sure.
// if adjoint_a == true:
//   A should be sorted in order of increasing dimension 1 (i.e., "column major"
//   order instead of "row major" order).
//
// Arguments:
//	a_indices: 2-D.  The `indices` of the `SparseTensor`, size `[nnz, 2]` Matrix.
//	a_values: 1-D.  The `values` of the `SparseTensor`, size `[nnz]` Vector.
//	a_shape: 1-D.  The `shape` of the `SparseTensor`, size `[2]` Vector.
//	b: 2-D.  A dense Matrix.
func SparseTensorDenseMatMul(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b tf.Output, optional ...SparseTensorDenseMatMulAttr) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseTensorDenseMatMul",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormGradV2Attr is an optional argument to FusedBatchNormGradV2.
type FusedBatchNormGradV2Attr func(optionalAttr)

// FusedBatchNormGradV2Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradV2Epsilon(value float32) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradV2DataFormat(value string) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradV2IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradV2IsTraining(value bool) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//
// Returns:
//	x_backprop: A 4D Tensor for the gradient with respect to x.
//	scale_backprop: A 1D Tensor for the gradient with respect to scale.
//	offset_backprop: A 1D Tensor for the gradient with respect to offset.
//	reserve_space_3: Unused placeholder to match the mean input in FusedBatchNorm.
//	reserve_space_4: Unused placeholder to match the variance input
// in FusedBatchNorm.
func FusedBatchNormGradV2(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, optional ...FusedBatchNormGradV2Attr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_3 tf.Output, reserve_space_4 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGradV2",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Computes the gradient for the inverse of `x` wrt its input.
//
// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
// is the corresponding input gradient.
func InvGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InvGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds up a SparseTensor and a dense Tensor, using these special rules:
//
// (1) Broadcasts the dense side to have the same shape as the sparse side, if
//     eligible;
// (2) Then, only the dense values pointed to by the indices of the SparseTensor
//     participate in the cwise addition.
//
// By these rules, the result is a logical SparseTensor with exactly the same
// indices and shape, but possibly with different non-zero values.  The output of
// this Op is the resultant non-zero values.
//
// Arguments:
//	sp_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	sp_values: 1-D.  `N` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//	dense: `R`-D.  The dense Tensor operand.
//
// Returns 1-D.  The `N` values that are operated on.
func SparseDenseCwiseAdd(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output, dense tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseDenseCwiseAdd",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape, dense,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes sine of x element-wise.
//
//   Given an input tensor, this function computes sine of every
//   element in the tensor. Input range is `(-inf, inf)` and
//   output range is `[-1,1]`.
//
//   ```python
//   x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10, float("inf")])
//   tf.math.sin(x) ==> [nan -0.4121185 -0.47942555 0.84147096 0.9320391 -0.87329733 -0.54402107 nan]
//   ```
func Sin(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sin",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormV2Attr is an optional argument to FusedBatchNormV2.
type FusedBatchNormV2Attr func(optionalAttr)

// FusedBatchNormV2Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormV2Epsilon(value float32) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormV2ExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormV2ExponentialAvgFactor(value float32) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormV2DataFormat(value string) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormV2IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormV2IsTraining(value bool) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
// must be empty for training.
//	variance: A 1D Tensor for population variance. Used for inference only;
// must be empty for training.
//
// Returns:
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
// to compute the running mean.
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
// TensorFlow to compute the running variance.
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
// in the gradient computation.
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
// in the cuDNN case), to be reused in the gradient computation.
func FusedBatchNormV2(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormV2Attr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormV2",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	arr: int32 `Tensor`.
//	size: non-negative int32 scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `arr`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size`. The counts or summed weights for
// each value in the range [0, size).
func Bincount(scope *Scope, arr tf.Output, size tf.Output, weights tf.Output) (bins tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Bincount",
		Input: []tf.Input{
			arr, size, weights,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gradients for batch normalization.
//
// DEPRECATED at GraphDef version 9: Use tf.nn.batch_normalization()
//
// This op is deprecated. See `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this Tensor will be multiplied
// with the normalized Tensor.
//	backprop: 4D backprop Tensor.
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
//
// Returns:
//	dx: 4D backprop tensor for input.
//	dm: 1D backprop tensor for mean.
//	dv: 1D backprop tensor for variance.
//	db: 1D backprop tensor for beta.
//	dg: 1D backprop tensor for gamma.
func BatchNormWithGlobalNormalizationGrad(scope *Scope, t tf.Output, m tf.Output, v tf.Output, gamma tf.Output, backprop tf.Output, variance_epsilon float32, scale_after_normalization bool) (dx tf.Output, dm tf.Output, dv tf.Output, db tf.Output, dg tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "BatchNormWithGlobalNormalizationGrad",
		Input: []tf.Input{
			t, m, v, gamma, backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// LoadAndRemapMatrixAttr is an optional argument to LoadAndRemapMatrix.
type LoadAndRemapMatrixAttr func(optionalAttr)

// LoadAndRemapMatrixMaxRowsInMemory sets the optional max_rows_in_memory attribute to value.
//
// value: The maximum number of rows to load from the checkpoint at
// once. If less than or equal to 0, the entire matrix will be loaded into
// memory. Setting this arg trades increased disk reads for lower memory usage.
// If not specified, defaults to -1
func LoadAndRemapMatrixMaxRowsInMemory(value int64) LoadAndRemapMatrixAttr {
	return func(m optionalAttr) {
		m["max_rows_in_memory"] = value
	}
}

// Loads a 2-D (matrix) `Tensor` with name `old_tensor_name` from the checkpoint
//
// at `ckpt_path` and potentially reorders its rows and columns using the
// specified remappings.
//
// Most users should use one of the wrapper initializers (such as
// `tf.contrib.framework.load_and_remap_matrix_initializer`) instead of this
// function directly.
//
// The remappings are 1-D tensors with the following properties:
//
// * `row_remapping` must have exactly `num_rows` entries. Row `i` of the output
//   matrix will be initialized from the row corresponding to index
//   `row_remapping[i]` in the old `Tensor` from the checkpoint.
// * `col_remapping` must have either 0 entries (indicating that no column
//   reordering is needed) or `num_cols` entries. If specified, column `j` of the
//   output matrix will be initialized from the column corresponding to index
//   `col_remapping[j]` in the old `Tensor` from the checkpoint.
// * A value of -1 in either of the remappings signifies a "missing" entry. In that
//   case, values from the `initializing_values` tensor will be used to fill that
//   missing row or column. If `row_remapping` has `r` missing entries and
//   `col_remapping` has `c` missing entries, then the following condition must be
//   true:
//
// `(r * num_cols) + (c * num_rows) - (r * c) == len(initializing_values)`
//
// The remapping tensors can be generated using the GenerateVocabRemapping op.
//
// As an example, with row_remapping = [1, 0, -1], col_remapping = [0, 2, -1],
// initializing_values = [0.5, -0.5, 0.25, -0.25, 42], and w(i, j) representing
// the value from row i, column j of the old tensor in the checkpoint, the output
// matrix will look like the following:
//
// [[w(1, 0),  w(1, 2),  0.5],
//  [w(0, 0),  w(0, 2), -0.5],
//  [0.25,    -0.25,      42]]
//
// Arguments:
//	ckpt_path: Path to the TensorFlow checkpoint (version 2, `TensorBundle`) from
// which the old matrix `Tensor` will be loaded.
//	old_tensor_name: Name of the 2-D `Tensor` to load from checkpoint.
//	row_remapping: An int `Tensor` of row remappings (generally created by
// `generate_vocab_remapping`).  Even if no row remapping is needed, this must
// still be an index-valued Tensor (e.g. [0, 1, 2, ...]), or a shifted
// index-valued `Tensor` (e.g. [8, 9, 10, ...], for partitioned `Variables`).
//	col_remapping: An int `Tensor` of column remappings (generally created by
// `generate_vocab_remapping`).  May be a size-0 `Tensor` if only row remapping
// is to be done (e.g. column ordering is the same).
//	initializing_values: A float `Tensor` containing  values to fill in for cells
// in the output matrix that are not loaded from the checkpoint. Length must be
// exactly the same as the number of missing / new cells.
//	num_rows: Number of rows (length of the 1st dimension) in the output matrix.
//	num_cols: Number of columns (length of the 2nd dimension) in the output matrix.
//
// Returns Output matrix containing existing values loaded from the
// checkpoint, and with any missing values filled in from initializing_values.
func LoadAndRemapMatrix(scope *Scope, ckpt_path tf.Output, old_tensor_name tf.Output, row_remapping tf.Output, col_remapping tf.Output, initializing_values tf.Output, num_rows int64, num_cols int64, optional ...LoadAndRemapMatrixAttr) (output_matrix tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_rows": num_rows, "num_cols": num_cols}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadAndRemapMatrix",
		Input: []tf.Input{
			ckpt_path, old_tensor_name, row_remapping, col_remapping, initializing_values,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Does nothing. Only useful as a placeholder for control edges.
//
// Returns the created operation.
func NoOp(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NoOp",
	}
	return scope.AddOperation(opspec)
}

// Set a summary_writer_interface to record statistics using given stats_aggregator.
//
// Returns the created operation.
func StatsAggregatorSetSummaryWriter(scope *Scope, stats_aggregator tf.Output, summary tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatsAggregatorSetSummaryWriter",
		Input: []tf.Input{
			stats_aggregator, summary,
		},
	}
	return scope.AddOperation(opspec)
}

// Subtracts a value from the current value of a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to
// see the decremented value or a subsequent newer one.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	value: the value by which the variable will be incremented.
//
// Returns the created operation.
func AssignSubVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignSubVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// FusedBatchNormGradAttr is an optional argument to FusedBatchNormGrad.
type FusedBatchNormGradAttr func(optionalAttr)

// FusedBatchNormGradEpsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradEpsilon(value float32) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradDataFormat(value string) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradIsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradIsTraining(value bool) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//
// Returns:
//	x_backprop: A 4D Tensor for the gradient with respect to x.
//	scale_backprop: A 1D Tensor for the gradient with respect to scale.
//	offset_backprop: A 1D Tensor for the gradient with respect to offset.
//	reserve_space_3: Unused placeholder to match the mean input in FusedBatchNorm.
//	reserve_space_4: Unused placeholder to match the variance input
// in FusedBatchNorm.
func FusedBatchNormGrad(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, optional ...FusedBatchNormGradAttr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_3 tf.Output, reserve_space_4 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGrad",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// XlaSpmdFullToShardShapeAttr is an optional argument to XlaSpmdFullToShardShape.
type XlaSpmdFullToShardShapeAttr func(optionalAttr)

// XlaSpmdFullToShardShapeDim sets the optional dim attribute to value.
// If not specified, defaults to -1
func XlaSpmdFullToShardShapeDim(value int64) XlaSpmdFullToShardShapeAttr {
	return func(m optionalAttr) {
		m["dim"] = value
	}
}

// XlaSpmdFullToShardShapeUnspecifiedDims sets the optional unspecified_dims attribute to value.
// If not specified, defaults to {}
func XlaSpmdFullToShardShapeUnspecifiedDims(value []int64) XlaSpmdFullToShardShapeAttr {
	return func(m optionalAttr) {
		m["unspecified_dims"] = value
	}
}

// An op used by XLA SPMD partitioner to switch from automatic partitioning to
//
// manual partitioning. It annotates the input (full-shape, to be automatically
// partitioned) with the same sharding used by manual partitioning, and outputs a
// shard-shaped tensor to be consumed by later manually-partitioned ops. If the
// shape is not evenly partitionable, the padding region will be masked with 0s.
// The conversion can happen partially in subgroups, by specifying the dim
// attribute, where only that dim will be converted.
func XlaSpmdFullToShardShape(scope *Scope, input tf.Output, manual_sharding string, optional ...XlaSpmdFullToShardShapeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"manual_sharding": manual_sharding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "XlaSpmdFullToShardShape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeCSVAttr is an optional argument to DecodeCSV.
type DecodeCSVAttr func(optionalAttr)

// DecodeCSVFieldDelim sets the optional field_delim attribute to value.
//
// value: char delimiter to separate fields in a record.
// If not specified, defaults to ","
func DecodeCSVFieldDelim(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["field_delim"] = value
	}
}

// DecodeCSVUseQuoteDelim sets the optional use_quote_delim attribute to value.
//
// value: If false, treats double quotation marks as regular
// characters inside of the string fields (ignoring RFC 4180, Section 2,
// Bullet 5).
// If not specified, defaults to true
func DecodeCSVUseQuoteDelim(value bool) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["use_quote_delim"] = value
	}
}

// DecodeCSVNaValue sets the optional na_value attribute to value.
//
// value: Additional string to recognize as NA/NaN.
// If not specified, defaults to ""
func DecodeCSVNaValue(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["na_value"] = value
	}
}

// DecodeCSVSelectCols sets the optional select_cols attribute to value.
// If not specified, defaults to {}
func DecodeCSVSelectCols(value []int64) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["select_cols"] = value
	}
}

// Convert CSV records to tensors. Each column maps to one tensor.
//
// RFC 4180 format is expected for the CSV records.
// (https://tools.ietf.org/html/rfc4180)
// Note that we allow leading and trailing spaces with int or float field.
//
// Arguments:
//	records: Each string is a record/row in the csv and all records should have
// the same format.
//	record_defaults: One tensor per column of the input record, with either a
// scalar default value for that column or an empty vector if the column is
// required.
//
// Returns Each tensor will have the same shape as records.
func DecodeCSV(scope *Scope, records tf.Output, record_defaults []tf.Output, optional ...DecodeCSVAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeCSV",
		Input: []tf.Input{
			records, tf.OutputList(record_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("DecodeCSV", err)
		return
	}
	return output
}

// Convert JSON-encoded Example records to binary protocol buffer strings.
//
//
// Note: This is **not** a general purpose JSON parsing op.
//
// This op converts JSON-serialized
// `tf.train.Example` (created with `json_format.MessageToJson`, following the
// [standard JSON mapping](https://developers.google.com/protocol-buffers/docs/proto3#json))
// to a binary-serialized `tf.train.Example` (equivalent to
// `Example.SerializeToString()`) suitable for conversion to tensors with
// `tf.io.parse_example`.
//
// Arguments:
//	json_examples: Each string is a JSON object serialized according to the JSON
// mapping of the Example proto.
//
// Returns Each string is a binary Example protocol buffer corresponding
// to the respective element of `json_examples`.
func DecodeJSONExample(scope *Scope, json_examples tf.Output) (binary_examples tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeJSONExample",
		Input: []tf.Input{
			json_examples,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ParseSequenceExampleAttr is an optional argument to ParseSequenceExample.
type ParseSequenceExampleAttr func(optionalAttr)

// ParseSequenceExampleNcontextSparse sets the optional Ncontext_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNcontextSparse(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Ncontext_sparse"] = value
	}
}

// ParseSequenceExampleNcontextDense sets the optional Ncontext_dense attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNcontextDense(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Ncontext_dense"] = value
	}
}

// ParseSequenceExampleNfeatureListSparse sets the optional Nfeature_list_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNfeatureListSparse(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Nfeature_list_sparse"] = value
	}
}

// ParseSequenceExampleNfeatureListDense sets the optional Nfeature_list_dense attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNfeatureListDense(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Nfeature_list_dense"] = value
	}
}

// ParseSequenceExampleContextSparseTypes sets the optional context_sparse_types attribute to value.
//
// value: A list of Ncontext_sparse types; the data types of data in
// each context Feature given in context_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleContextSparseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_sparse_types"] = value
	}
}

// ParseSequenceExampleFeatureListDenseTypes sets the optional feature_list_dense_types attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListDenseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_types"] = value
	}
}

// ParseSequenceExampleContextDenseShapes sets the optional context_dense_shapes attribute to value.
//
// value: A list of Ncontext_dense shapes; the shapes of data in
// each context Feature given in context_dense_keys.
// The number of elements in the Feature corresponding to context_dense_key[j]
// must always equal context_dense_shapes[j].NumEntries().
// The shape of context_dense_values[j] will match context_dense_shapes[j].
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleContextDenseShapes(value []tf.Shape) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_dense_shapes"] = value
	}
}

// ParseSequenceExampleFeatureListSparseTypes sets the optional feature_list_sparse_types attribute to value.
//
// value: A list of Nfeature_list_sparse types; the data types
// of data in each FeatureList given in feature_list_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListSparseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_sparse_types"] = value
	}
}

// ParseSequenceExampleFeatureListDenseShapes sets the optional feature_list_dense_shapes attribute to value.
//
// value: A list of Nfeature_list_dense shapes; the shapes of
// data in each FeatureList given in feature_list_dense_keys.
// The shape of each Feature in the FeatureList corresponding to
// feature_list_dense_key[j] must always equal
// feature_list_dense_shapes[j].NumEntries().
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListDenseShapes(value []tf.Shape) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_shapes"] = value
	}
}

// Transforms a vector of brain.SequenceExample protos (as strings) into typed tensors.
//
// Arguments:
//	serialized: A vector containing binary serialized SequenceExample protos.
//	debug_name: A vector containing the names of the serialized protos.
// May contain, for example, table key (descriptive) name for the
// corresponding serialized proto.  This is purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no name is available.
//	context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
// context_dense_defaults[j] provides default values
// when the SequenceExample's context map lacks context_dense_key[j].
// If an empty Tensor is provided for context_dense_defaults[j],
// then the Feature context_dense_keys[j] is required.
// The input type is inferred from context_dense_defaults[j], even when it's
// empty.  If context_dense_defaults[j] is not empty, its shape must match
// context_dense_shapes[j].
//	feature_list_dense_missing_assumed_empty: A vector listing the
// FeatureList keys which may be missing from the SequenceExamples.  If the
// associated FeatureList is missing, it is treated as empty.  By default,
// any FeatureList not listed in this vector must exist in the SequenceExamples.
//	context_sparse_keys: A list of Ncontext_sparse string Tensors (scalars).
// The keys expected in the Examples' features associated with context_sparse
// values.
//	context_dense_keys: A list of Ncontext_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' context features associated with
// dense values.
//	feature_list_sparse_keys: A list of Nfeature_list_sparse string Tensors
// (scalars).  The keys expected in the FeatureLists associated with sparse
// values.
//	feature_list_dense_keys: A list of Nfeature_list_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' feature_lists associated
// with lists of dense values.
func ParseSequenceExample(scope *Scope, serialized tf.Output, debug_name tf.Output, context_dense_defaults []tf.Output, feature_list_dense_missing_assumed_empty []string, context_sparse_keys []string, context_dense_keys []string, feature_list_sparse_keys []string, feature_list_dense_keys []string, optional ...ParseSequenceExampleAttr) (context_sparse_indices []tf.Output, context_sparse_values []tf.Output, context_sparse_shapes []tf.Output, context_dense_values []tf.Output, feature_list_sparse_indices []tf.Output, feature_list_sparse_values []tf.Output, feature_list_sparse_shapes []tf.Output, feature_list_dense_values []tf.Output, feature_list_dense_lengths []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"feature_list_dense_missing_assumed_empty": feature_list_dense_missing_assumed_empty, "context_sparse_keys": context_sparse_keys, "context_dense_keys": context_dense_keys, "feature_list_sparse_keys": feature_list_sparse_keys, "feature_list_dense_keys": feature_list_dense_keys}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseSequenceExample",
		Input: []tf.Input{
			serialized, debug_name, tf.OutputList(context_dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if context_sparse_indices, idx, err = makeOutputList(op, idx, "context_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_sparse_values, idx, err = makeOutputList(op, idx, "context_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_sparse_shapes, idx, err = makeOutputList(op, idx, "context_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_dense_values, idx, err = makeOutputList(op, idx, "context_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_indices, idx, err = makeOutputList(op, idx, "feature_list_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_values, idx, err = makeOutputList(op, idx, "feature_list_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_shapes, idx, err = makeOutputList(op, idx, "feature_list_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_dense_values, idx, err = makeOutputList(op, idx, "feature_list_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_dense_lengths, idx, err = makeOutputList(op, idx, "feature_list_dense_lengths"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	return context_sparse_indices, context_sparse_values, context_sparse_shapes, context_dense_values, feature_list_sparse_indices, feature_list_sparse_values, feature_list_sparse_shapes, feature_list_dense_values, feature_list_dense_lengths
}

// UniqueV2Attr is an optional argument to UniqueV2.
type UniqueV2Attr func(optionalAttr)

// UniqueV2OutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueV2OutIdx(value tf.DataType) UniqueV2Attr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements along an axis of a tensor.
//
// This operation either returns a tensor `y` containing unique elements
// along the `axis` of a tensor. The returned unique elements is sorted
// in the same order as they occur along `axis` in `x`.
// This operation also returns a tensor `idx` that is the same size as
// the number of the elements in `x` along the `axis` dimension. It
// contains the index in the unique output `y`.
// In other words, for an `1-D` tensor `x` with `axis = None:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// For example:
//
// ```
// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
// y, idx = unique(x)
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// ```
//
// For an `2-D` tensor `x` with `axis = 0`:
//
// ```
// # tensor 'x' is [[1, 0, 0],
// #                [1, 0, 0],
// #                [2, 0, 0]]
// y, idx = unique(x, axis=0)
// y ==> [[1, 0, 0],
//        [2, 0, 0]]
// idx ==> [0, 0, 1]
// ```
//
// For an `2-D` tensor `x` with `axis = 1`:
//
// ```
// # tensor 'x' is [[1, 0, 0],
// #                [1, 0, 0],
// #                [2, 0, 0]]
// y, idx = unique(x, axis=1)
// y ==> [[1, 0],
//        [1, 0],
//        [2, 0]]
// idx ==> [0, 1, 1]
// ```
//
// Arguments:
//	x: A `Tensor`.
//	axis: A `Tensor` of type `int32` (default: None). The axis of the Tensor to
// find the unique elements.
//
// Returns:
//	y: A `Tensor`. Unique elements along the `axis` of `Tensor` x.
//	idx: A 1-D Tensor. Has the same type as x that contains the index of each
// value of x in the output y.
func UniqueV2(scope *Scope, x tf.Output, axis tf.Output, optional ...UniqueV2Attr) (y tf.Output, idx tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniqueV2",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// StatelessRandomBinomialAttr is an optional argument to StatelessRandomBinomial.
type StatelessRandomBinomialAttr func(optionalAttr)

// StatelessRandomBinomialDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_INT64
func StatelessRandomBinomialDtype(value tf.DataType) StatelessRandomBinomialAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom random numbers from a binomial distribution.
//
// Outputs random values from a binomial distribution.
//
// The outputs are a deterministic function of `shape`, `seed`, `counts`, and `probs`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//	counts: The counts of the binomial distribution. Must be broadcastable with `probs`,
// and broadcastable with the rightmost dimensions of `shape`.
//	probs: The probability of success for the binomial distribution. Must be broadcastable
// with `counts` and broadcastable with the rightmost dimensions of `shape`.
//
// Returns Random values with specified shape.
func StatelessRandomBinomial(scope *Scope, shape tf.Output, seed tf.Output, counts tf.Output, probs tf.Output, optional ...StatelessRandomBinomialAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomBinomial",
		Input: []tf.Input{
			shape, seed, counts, probs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingADAMParametersAttr is an optional argument to RetrieveTPUEmbeddingADAMParameters.
type RetrieveTPUEmbeddingADAMParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingADAMParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func RetrieveTPUEmbeddingADAMParametersTableId(value int64) RetrieveTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingADAMParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingADAMParametersTableName(value string) RetrieveTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// RetrieveTPUEmbeddingADAMParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingADAMParametersConfig(value string) RetrieveTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Retrieve ADAM embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns:
//	parameters: Parameter parameters updated by the ADAM optimization algorithm.
//	momenta: Parameter momenta updated by the ADAM optimization algorithm.
//	velocities: Parameter velocities updated by the ADAM optimization algorithm.
func RetrieveTPUEmbeddingADAMParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingADAMParametersAttr) (parameters tf.Output, momenta tf.Output, velocities tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingADAMParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DecodePaddedRawAttr is an optional argument to DecodePaddedRaw.
type DecodePaddedRawAttr func(optionalAttr)

// DecodePaddedRawLittleEndian sets the optional little_endian attribute to value.
//
// value: Whether the input `input_bytes` is in little-endian order. Ignored for
// `out_type` values that are stored in a single byte, like `uint8`
// If not specified, defaults to true
func DecodePaddedRawLittleEndian(value bool) DecodePaddedRawAttr {
	return func(m optionalAttr) {
		m["little_endian"] = value
	}
}

// Reinterpret the bytes of a string as a vector of numbers.
//
// Arguments:
//	input_bytes: Tensor of string to be decoded.
//	fixed_length: Length in bytes for each element of the decoded output. Must be a multiple
// of the size of the output type.
//
//
// Returns A Tensor with one more dimension than the input `bytes`. The added dimension
// will have size equal to the length of the elements of `bytes` divided by the
// number of bytes to represent `out_type`.
func DecodePaddedRaw(scope *Scope, input_bytes tf.Output, fixed_length tf.Output, out_type tf.DataType, optional ...DecodePaddedRawAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodePaddedRaw",
		Input: []tf.Input{
			input_bytes, fixed_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Elementwise computes the bitwise left-shift of `x` and `y`.
//
// If `y` is negative, or greater than or equal to the width of `x` in bits the
// result is implementation defined.
//
// Example:
//
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
// import numpy as np
// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64]
//
// for dtype in dtype_list:
//   lhs = tf.constant([-1, -5, -3, -14], dtype=dtype)
//   rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
//
//   left_shift_result = bitwise_ops.left_shift(lhs, rhs)
//
//   print(left_shift_result)
//
// # This will print:
// # tf.Tensor([ -32   -5 -128    0], shape=(4,), dtype=int8)
// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int16)
// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int32)
// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int64)
//
// lhs = np.array([-2, 64, 101, 32], dtype=np.int8)
// rhs = np.array([-1, -5, -3, -14], dtype=np.int8)
// bitwise_ops.left_shift(lhs, rhs)
// # <tf.Tensor: shape=(4,), dtype=int8, numpy=array([ -2,  64, 101,  32], dtype=int8)>
// ```
//
func LeftShift(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LeftShift",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates a feature cross from a list of tensors, and returns it as a
// RaggedTensor.  See `tf.ragged.cross` for more details.
//
// Arguments:
//	ragged_values: The values tensor for each RaggedTensor input.
//	ragged_row_splits: The row_splits tensor for each RaggedTensor input.
//	sparse_indices: The indices tensor for each SparseTensor input.
//	sparse_values: The values tensor for each SparseTensor input.
//	sparse_shape: The dense_shape tensor for each SparseTensor input.
//	dense_inputs: The tf.Tensor inputs.
//	input_order: String specifying the tensor type for each input.  The `i`th character in
// this string specifies the type of the `i`th input, and is one of: 'R' (ragged),
// 'D' (dense), or 'S' (sparse).  This attr is used to ensure that the crossed
// values are combined in the order of the inputs from the call to tf.ragged.cross.
//
//
//
//
//
//
// Returns:
//	output_values: The `values` for the returned `RaggedTensor`.
//	output_row_splits: The `row_splits` for the returned `RaggedTensor`.
func RaggedCross(scope *Scope, ragged_values []tf.Output, ragged_row_splits []tf.Output, sparse_indices []tf.Output, sparse_values []tf.Output, sparse_shape []tf.Output, dense_inputs []tf.Output, input_order string, hashed_output bool, num_buckets int64, hash_key int64, out_values_type tf.DataType, out_row_splits_type tf.DataType) (output_values tf.Output, output_row_splits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_order": input_order, "hashed_output": hashed_output, "num_buckets": num_buckets, "hash_key": hash_key, "out_values_type": out_values_type, "out_row_splits_type": out_row_splits_type}
	opspec := tf.OpSpec{
		Type: "RaggedCross",
		Input: []tf.Input{
			tf.OutputList(ragged_values), tf.OutputList(ragged_row_splits), tf.OutputList(sparse_indices), tf.OutputList(sparse_values), tf.OutputList(sparse_shape), tf.OutputList(dense_inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// BatchMatMulAttr is an optional argument to BatchMatMul.
type BatchMatMulAttr func(optionalAttr)

// BatchMatMulAdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjX(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulAdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjY(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//     r_o = c_x if adj_x else r_x
//     c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// Arguments:
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMul(scope *Scope, x tf.Output, y tf.Output, optional ...BatchMatMulAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMul",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RaggedTensorFromVariantAttr is an optional argument to RaggedTensorFromVariant.
type RaggedTensorFromVariantAttr func(optionalAttr)

// RaggedTensorFromVariantTsplits sets the optional Tsplits attribute to value.
// If not specified, defaults to DT_INT64
func RaggedTensorFromVariantTsplits(value tf.DataType) RaggedTensorFromVariantAttr {
	return func(m optionalAttr) {
		m["Tsplits"] = value
	}
}

// Decodes a `variant` Tensor into a `RaggedTensor`.
//
// Decodes the given `variant` Tensor and returns a `RaggedTensor`. The input
// could be a scalar, meaning it encodes a single `RaggedTensor` with ragged_rank
// `output_ragged_rank`. It could also have an arbitrary rank, in which case each
// element is decoded into a `RaggedTensor` with ragged_rank `input_ragged_rank`
// and these are then stacked according to the input shape to output a single
// `RaggedTensor` with ragged_rank `output_ragged_rank`. Each `variant` element in
// the input Tensor is decoded by retrieving from the element a 1-D `variant`
// Tensor with `input_ragged_rank + 1` Tensors, corresponding to the splits and
// values of the decoded `RaggedTensor`. If `input_ragged_rank` is -1, then it is
// inferred as `output_ragged_rank` - `rank(encoded_ragged)`. See
// `RaggedTensorToVariant` for the corresponding encoding logic.
//
//
// Arguments:
//	encoded_ragged: A `variant` Tensor containing encoded `RaggedTensor`s.
//	input_ragged_rank: The ragged rank of each encoded `RaggedTensor` component in the input. If set to
// -1, this is inferred as `output_ragged_rank` - `rank(encoded_ragged)`
//	output_ragged_rank: The expected ragged rank of the output `RaggedTensor`. The following must hold:
// `output_ragged_rank = rank(encoded_ragged) + input_ragged_rank`.
//
//
// Returns:
//	output_nested_splits: A list of one or more Tensors representing the splits of the output
// `RaggedTensor`.
//	output_dense_values: A Tensor representing the values of the output `RaggedTensor`.
func RaggedTensorFromVariant(scope *Scope, encoded_ragged tf.Output, input_ragged_rank int64, output_ragged_rank int64, Tvalues tf.DataType, optional ...RaggedTensorFromVariantAttr) (output_nested_splits []tf.Output, output_dense_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_ragged_rank": input_ragged_rank, "output_ragged_rank": output_ragged_rank, "Tvalues": Tvalues}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RaggedTensorFromVariant",
		Input: []tf.Input{
			encoded_ragged,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output_nested_splits, idx, err = makeOutputList(op, idx, "output_nested_splits"); err != nil {
		scope.UpdateErr("RaggedTensorFromVariant", err)
		return
	}
	output_dense_values = op.Output(idx)
	return output_nested_splits, output_dense_values
}

// Returns the name of the device on which `resource` has been placed.
func ExperimentalIteratorGetDevice(scope *Scope, resource tf.Output) (device tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalIteratorGetDevice",
		Input: []tf.Input{
			resource,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Records the bytes size of each element of `input_dataset` in a StatsAggregator.
func ExperimentalBytesProducedStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalBytesProducedStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the exponential linear function.
//
// The ELU function is defined as:
//
//  * $ e ^ x - 1 $ if $ x < 0 $
//  * $ x $ if $ x >= 0 $
//
// Examples:
//
// >>> tf.nn.elu(1.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=1.0>
// >>> tf.nn.elu(0.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=0.0>
// >>> tf.nn.elu(-1000.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=-1.0>
//
// See [Fast and Accurate Deep Network Learning by Exponential Linear Units (ELUs)
// ](http://arxiv.org/abs/1511.07289)
func Elu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Elu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AddSparseToTensorsMapAttr is an optional argument to AddSparseToTensorsMap.
type AddSparseToTensorsMapAttr func(optionalAttr)

// AddSparseToTensorsMapContainer sets the optional container attribute to value.
//
// value: The container name for the `SparseTensorsMap` created by this op.
// If not specified, defaults to ""
func AddSparseToTensorsMapContainer(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// AddSparseToTensorsMapSharedName sets the optional shared_name attribute to value.
//
// value: The shared name for the `SparseTensorsMap` created by this op.
// If blank, the new Operation's unique name is used.
// If not specified, defaults to ""
func AddSparseToTensorsMapSharedName(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Add a `SparseTensor` to a `SparseTensorsMap` return its handle.
//
// A `SparseTensor` is represented by three tensors: `sparse_indices`,
// `sparse_values`, and `sparse_shape`.
//
// This operator takes the given `SparseTensor` and adds it to a container
// object (a `SparseTensorsMap`).  A unique key within this container is generated
// in the form of an `int64`, and this is the value that is returned.
//
// The `SparseTensor` can then be read out as part of a minibatch by passing
// the key as a vector element to `TakeManySparseFromTensorsMap`.  To ensure
// the correct `SparseTensorsMap` is accessed, ensure that the same
// `container` and `shared_name` are passed to that Op.  If no `shared_name`
// is provided here, instead use the *name* of the Operation created by calling
// `AddSparseToTensorsMap` as the `shared_name` passed to
// `TakeManySparseFromTensorsMap`.  Ensure the Operations are colocated.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the `SparseTensor`.
//	sparse_values: 1-D.  The `values` of the `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the `SparseTensor`.
//
// Returns 0-D.  The handle of the `SparseTensor` now stored in the
// `SparseTensorsMap`.
func AddSparseToTensorsMap(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...AddSparseToTensorsMapAttr) (sparse_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AddSparseToTensorsMap",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Transforms a vector of tf.Example protos (as strings) into typed tensors.
//
// Arguments:
//	serialized: A scalar or vector containing binary serialized Example protos.
//	names: A tensor containing the names of the serialized protos.
// Corresponds 1:1 with the `serialized` tensor.
// May contain, for example, table key (descriptive) names for the
// corresponding serialized protos.  These are purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no names are available.
// If non-empty, this tensor must have the same shape as "serialized".
//	sparse_keys: Vector of strings.
// The keys expected in the Examples' features associated with sparse values.
//	dense_keys: Vector of strings.
// The keys expected in the Examples' features associated with dense values.
//	ragged_keys: Vector of strings.
// The keys expected in the Examples' features associated with ragged values.
//	dense_defaults: A list of Tensors (some may be empty).  Corresponds 1:1 with `dense_keys`.
// dense_defaults[j] provides default values
// when the example's feature_map lacks dense_key[j].  If an empty Tensor is
// provided for dense_defaults[j], then the Feature dense_keys[j] is required.
// The input type is inferred from dense_defaults[j], even when it's empty.
// If dense_defaults[j] is not empty, and dense_shapes[j] is fully defined,
// then the shape of dense_defaults[j] must match that of dense_shapes[j].
// If dense_shapes[j] has an undefined major dimension (variable strides dense
// feature), dense_defaults[j] must contain a single element:
// the padding element.
//	num_sparse: The number of sparse keys.
//	sparse_types: A list of `num_sparse` types; the data types of data in each Feature
// given in sparse_keys.
// Currently the ParseExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
//	ragged_value_types: A list of `num_ragged` types; the data types of data in each Feature
// given in ragged_keys (where `num_ragged = sparse_keys.size()`).
// Currently the ParseExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
//	ragged_split_types: A list of `num_ragged` types; the data types of row_splits in each Feature
// given in ragged_keys (where `num_ragged = sparse_keys.size()`).
// May be DT_INT32 or DT_INT64.
//	dense_shapes: A list of `num_dense` shapes; the shapes of data in each Feature
// given in dense_keys (where `num_dense = dense_keys.size()`).
// The number of elements in the Feature corresponding to dense_key[j]
// must always equal dense_shapes[j].NumEntries().
// If dense_shapes[j] == (D0, D1, ..., DN) then the shape of output
// Tensor dense_values[j] will be (|serialized|, D0, D1, ..., DN):
// The dense outputs are just the inputs row-stacked by batch.
// This works for dense_shapes[j] = (-1, D1, ..., DN).  In this case
// the shape of the output Tensor dense_values[j] will be
// (|serialized|, M, D1, .., DN), where M is the maximum number of blocks
// of elements of length D1 * .... * DN, across all minibatch entries
// in the input.  Any minibatch entry with less than M blocks of elements of
// length D1 * ... * DN will be padded with the corresponding default_value
// scalar element along the second dimension.
func ParseExampleV2(scope *Scope, serialized tf.Output, names tf.Output, sparse_keys tf.Output, dense_keys tf.Output, ragged_keys tf.Output, dense_defaults []tf.Output, num_sparse int64, sparse_types []tf.DataType, ragged_value_types []tf.DataType, ragged_split_types []tf.DataType, dense_shapes []tf.Shape) (sparse_indices []tf.Output, sparse_values []tf.Output, sparse_shapes []tf.Output, dense_values []tf.Output, ragged_values []tf.Output, ragged_row_splits []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_sparse": num_sparse, "sparse_types": sparse_types, "ragged_value_types": ragged_value_types, "ragged_split_types": ragged_split_types, "dense_shapes": dense_shapes}
	opspec := tf.OpSpec{
		Type: "ParseExampleV2",
		Input: []tf.Input{
			serialized, names, sparse_keys, dense_keys, ragged_keys, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if sparse_indices, idx, err = makeOutputList(op, idx, "sparse_indices"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if sparse_values, idx, err = makeOutputList(op, idx, "sparse_values"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if sparse_shapes, idx, err = makeOutputList(op, idx, "sparse_shapes"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if dense_values, idx, err = makeOutputList(op, idx, "dense_values"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if ragged_values, idx, err = makeOutputList(op, idx, "ragged_values"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	if ragged_row_splits, idx, err = makeOutputList(op, idx, "ragged_row_splits"); err != nil {
		scope.UpdateErr("ParseExampleV2", err)
		return
	}
	return sparse_indices, sparse_values, sparse_shapes, dense_values, ragged_values, ragged_row_splits
}

// Scatters `updates` into a tensor of shape `shape` according to `indices`.
//
// Update the input tensor by scattering sparse `updates` according to individual values at the specified `indices`.
// This op returns an `output` tensor with the `shape` you specify. This op is the
// inverse of the `tf.gather_nd` operator which extracts values or slices from a
// given tensor.
//
// This operation is similar to `tf.tensor_scatter_add`, except that the tensor is
// zero-initialized. Calling `tf.scatter_nd(indices, values, shape)`
// is identical to calling
// `tf.tensor_scatter_add(tf.zeros(shape, values.dtype), indices, values)`.
//
// If `indices` contains duplicates, the duplicate `values` are accumulated
// (summed).
//
// **WARNING**: The order in which updates are applied is nondeterministic, so the
// output will be nondeterministic if `indices` contains duplicates;
// numbers summed in different order may yield different results because of some
// numerical approximation issues.
//
// `indices` is an integer tensor of shape `shape`. The last dimension
// of `indices` can be at most the rank of `shape`:
//
//     indices.shape[-1] <= shape.rank
//
// The last dimension of `indices` corresponds to indices of elements
// (if `indices.shape[-1] = shape.rank`) or slices
// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
// `shape`.
//
// `updates` is a tensor with shape:
//
//     indices.shape[:-1] + shape[indices.shape[-1]:]
//
// The simplest form of the scatter op is to insert individual elements in
// a tensor by index. Consider an example where you want to insert 4 scattered
// elements in a rank-1 tensor with 8 elements.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/ScatterNd1.png" alt>
// </div>
//
// In Python, this scatter operation would look like this:
//
// ```python
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     shape = tf.constant([8])
//     scatter = tf.scatter_nd(indices, updates, shape)
//     print(scatter)
// ```
//
// The resulting tensor would look like this:
//
//     [0, 11, 0, 10, 9, 0, 0, 12]
//
// You can also insert entire slices of a higher rank tensor all at once. For
// example, you can insert two slices in the first dimension of a rank-3 tensor
// with two matrices of new values.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/ScatterNd2.png" alt>
// </div>
//
// In Python, this scatter operation would look like this:
//
// ```python
//     indices = tf.constant([[0], [2]])
//     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]],
//                            [[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]]])
//     shape = tf.constant([4, 4, 4])
//     scatter = tf.scatter_nd(indices, updates, shape)
//     print(scatter)
// ```
//
// The resulting tensor would look like this:
//
//     [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
//      [[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]],
//      [[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
//      [[0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]]]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, the index is ignored.
//
// Arguments:
//	indices: Tensor of indices.
//	updates: Values to scatter into the output tensor.
//	shape: 1-D. The shape of the output tensor.
//
// Returns A new tensor with the given shape and updates applied according
// to the indices.
func ScatterNd(scope *Scope, indices tf.Output, updates tf.Output, shape tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ScatterNd",
		Input: []tf.Input{
			indices, updates, shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UniqueAttr is an optional argument to Unique.
type UniqueAttr func(optionalAttr)

// UniqueOutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueOutIdx(value tf.DataType) UniqueAttr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements in a 1-D tensor.
//
// This operation returns a tensor `y` containing all of the unique elements of `x`
// sorted in the same order that they occur in `x`; `x` does not need to be sorted.
// This operation also returns a tensor `idx` the same size as `x` that contains
// the index of each value of `x` in the unique output `y`. In other words:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// Examples:
//
// ```
// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
// y, idx = unique(x)
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// ```
//
// ```
// # tensor 'x' is [4, 5, 1, 2, 3, 3, 4, 5]
// y, idx = unique(x)
// y ==> [4, 5, 1, 2, 3]
// idx ==> [0, 1, 2, 3, 4, 4, 0, 1]
// ```
//
// Arguments:
//	x: 1-D.
//
// Returns:
//	y: 1-D.
//	idx: 1-D.
func Unique(scope *Scope, x tf.Output, optional ...UniqueAttr) (y tf.Output, idx tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unique",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Converts a `RaggedTensor` into a `SparseTensor` with the same values.
//
// input=ragged.from_nested_row_splits(rt_dense_values, rt_nested_splits)
// output=SparseTensor(indices=sparse_indices, values=sparse_values,
//                     dense_shape=sparse_dense_shape)
//
// Arguments:
//	rt_nested_splits: The `row_splits` for the `RaggedTensor`.
//	rt_dense_values: The `flat_values` for the `RaggedTensor`.
//
// Returns:
//	sparse_indices: The indices for the `SparseTensor`.
//	sparse_values: The values of the `SparseTensor`.
//	sparse_dense_shape: `sparse_dense_shape` is a tight bounding box of the input `RaggedTensor`.
func RaggedTensorToSparse(scope *Scope, rt_nested_splits []tf.Output, rt_dense_values tf.Output) (sparse_indices tf.Output, sparse_values tf.Output, sparse_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RaggedTensorToSparse",
		Input: []tf.Input{
			tf.OutputList(rt_nested_splits), rt_dense_values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0