/* Copyright 2019 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef TENSORFLOW_COMPILER_MLIR_LITE_FLATBUFFER_EXPORT_H_
#define TENSORFLOW_COMPILER_MLIR_LITE_FLATBUFFER_EXPORT_H_

#include <map>
#include <string>
#include <unordered_set>

#include "mlir/IR/BuiltinOps.h"  // from @llvm-project
#include "tensorflow/compiler/mlir/op_or_arg_name_mapper.h"

namespace tflite {
// Options for exporting to Flatbuffer.
struct FlatbufferExportOptions {
  bool emit_builtin_tflite_ops = false;
  bool emit_select_tf_ops = false;
  bool emit_custom_ops = false;
  // When exporting from SavedModel, this will have the requested tags.
  std::unordered_set<std::string> saved_model_tags;
  // TF custom op passed by the user.
  std::unordered_set<std::string> select_user_tf_ops;
  // Metadata key/value pairs to write to the flatbuffer.
  std::map<std::string, std::string> metadata;
  // OpOrArgNameMapper to convert location of the op to name in flatbuffer.
  // If not set, a default mapper will be used.
  tensorflow::OpOrArgNameMapper* op_or_arg_name_mapper = nullptr;
  // If set to true, then allow pass through of TF ops as select Tensorflow ops.
  bool allow_all_select_tf_ops = false;
};

// Translates the given MLIR `module` into a FlatBuffer and stores the
// serialized flatbuffer into the string.
// Returns true on successful exporting, false otherwise.
bool MlirToFlatBufferTranslateFunction(mlir::ModuleOp module,
                                       const FlatbufferExportOptions& options,
                                       std::string* serialized_flatbuffer);
}  // namespace tflite

#endif  // TENSORFLOW_COMPILER_MLIR_LITE_FLATBUFFER_EXPORT_H_
