// RUN: mlir-hlo-opt --mhlo-legalize-trigonometric-to-approximation --split-input-file %s | FileCheck %s

func @tanh_f64(%arg0 : f64) -> f64 {
  %res = tanh %arg0 : f64
  return %res : f64
}

// CHECK-LABEL: @tanh_f64
// CHECK: tanh

// -----

func @tanh_f32(%arg0 : f32) -> f32 {
  %res = tanh %arg0 : f32
  return %res : f32
}

// NOTE: Assertions have been autogenerated by utils/generate-test-checks.py

// CHECK-LABEL: func @tanh_f32
// CHECK-SAME: (%[[VAL_0:.*]]: f32) -> f32
// CHECK: %[[VAL_1:.*]] = constant 4.000000e-04 : f32
// CHECK: %[[VAL_2:.*]] = constant 7.90531111 : f32
// CHECK: %[[VAL_3:.*]] = constant -7.90531111 : f32
// CHECK: %[[VAL_4:.*]] = constant -2.76076837E-16 : f32
// CHECK: %[[VAL_5:.*]] = constant 2.00018794E-13 : f32
// CHECK: %[[VAL_6:.*]] = constant -8.60467184E-11 : f32
// CHECK: %[[VAL_7:.*]] = constant 5.12229725E-8 : f32
// CHECK: %[[VAL_8:.*]] = constant 1.48572235E-5 : f32
// CHECK: %[[VAL_9:.*]] = constant 6.37261954E-4 : f32
// CHECK: %[[VAL_10:.*]] = constant 0.00489352457 : f32
// CHECK: %[[VAL_11:.*]] = constant 1.19825836E-6 : f32
// CHECK: %[[VAL_12:.*]] = constant 1.18534706E-4 : f32
// CHECK: %[[VAL_13:.*]] = constant 0.00226843474 : f32
// CHECK: %[[VAL_14:.*]] = constant 0.00489352504 : f32
// CHECK: %[[VAL_15:.*]] = absf %[[VAL_0]] : f32
// CHECK: %[[VAL_16:.*]] = cmpf "olt", %[[VAL_15]], %[[VAL_1]] : f32
// CHECK: %[[VAL_17:.*]] = cmpf "ule", %[[VAL_0]], %[[VAL_2]] : f32
// CHECK: %[[VAL_18:.*]] = select %[[VAL_17]], %[[VAL_0]], %[[VAL_2]] : f32
// CHECK: %[[VAL_19:.*]] = cmpf "uge", %[[VAL_18]], %[[VAL_3]] : f32
// CHECK: %[[VAL_20:.*]] = select %[[VAL_19]], %[[VAL_18]], %[[VAL_3]] : f32
// CHECK: %[[VAL_21:.*]] = mulf %[[VAL_20]], %[[VAL_20]] : f32
// CHECK: %[[VAL_22:.*]] = mulf %[[VAL_21]], %[[VAL_4]] : f32
// CHECK: %[[VAL_23:.*]] = addf %[[VAL_22]], %[[VAL_5]] : f32
// CHECK: %[[VAL_24:.*]] = mulf %[[VAL_21]], %[[VAL_23]] : f32
// CHECK: %[[VAL_25:.*]] = addf %[[VAL_24]], %[[VAL_6]] : f32
// CHECK: %[[VAL_26:.*]] = mulf %[[VAL_21]], %[[VAL_25]] : f32
// CHECK: %[[VAL_27:.*]] = addf %[[VAL_26]], %[[VAL_7]] : f32
// CHECK: %[[VAL_28:.*]] = mulf %[[VAL_21]], %[[VAL_27]] : f32
// CHECK: %[[VAL_29:.*]] = addf %[[VAL_28]], %[[VAL_8]] : f32
// CHECK: %[[VAL_30:.*]] = mulf %[[VAL_21]], %[[VAL_29]] : f32
// CHECK: %[[VAL_31:.*]] = addf %[[VAL_30]], %[[VAL_9]] : f32
// CHECK: %[[VAL_32:.*]] = mulf %[[VAL_21]], %[[VAL_31]] : f32
// CHECK: %[[VAL_33:.*]] = addf %[[VAL_32]], %[[VAL_10]] : f32
// CHECK: %[[VAL_34:.*]] = mulf %[[VAL_20]], %[[VAL_33]] : f32
// CHECK: %[[VAL_35:.*]] = mulf %[[VAL_21]], %[[VAL_11]] : f32
// CHECK: %[[VAL_36:.*]] = addf %[[VAL_35]], %[[VAL_12]] : f32
// CHECK: %[[VAL_37:.*]] = mulf %[[VAL_21]], %[[VAL_36]] : f32
// CHECK: %[[VAL_38:.*]] = addf %[[VAL_37]], %[[VAL_13]] : f32
// CHECK: %[[VAL_39:.*]] = mulf %[[VAL_21]], %[[VAL_38]] : f32
// CHECK: %[[VAL_40:.*]] = addf %[[VAL_39]], %[[VAL_14]] : f32
// CHECK: %[[VAL_41:.*]] = divf %[[VAL_34]], %[[VAL_40]] : f32
// CHECK: %[[VAL_42:.*]] = select %[[VAL_16]], %[[VAL_0]], %[[VAL_41]] : f32
// CHECK: return %[[VAL_42]] : f32

// -----

func @tanh_f16(%arg0 : f16) -> f16 {
  %res = tanh %arg0 : f16
  return %res : f16
}

// NOTE: Assertions have been autogenerated by utils/generate-test-checks.py

// CHECK-LABEL: func @tanh_f16
// CHECK-SAME: (%[[VAL_0:.*]]: f16) -> f16
// CHECK: %[[VAL_1:.*]] = constant 4.000000e-04 : f32
// CHECK: %[[VAL_2:.*]] = constant 7.90531111 : f32
// CHECK: %[[VAL_3:.*]] = constant -7.90531111 : f32
// CHECK: %[[VAL_4:.*]] = constant -2.76076837E-16 : f32
// CHECK: %[[VAL_5:.*]] = constant 2.00018794E-13 : f32
// CHECK: %[[VAL_6:.*]] = constant -8.60467184E-11 : f32
// CHECK: %[[VAL_7:.*]] = constant 5.12229725E-8 : f32
// CHECK: %[[VAL_8:.*]] = constant 1.48572235E-5 : f32
// CHECK: %[[VAL_9:.*]] = constant 6.37261954E-4 : f32
// CHECK: %[[VAL_10:.*]] = constant 0.00489352457 : f32
// CHECK: %[[VAL_11:.*]] = constant 1.19825836E-6 : f32
// CHECK: %[[VAL_12:.*]] = constant 1.18534706E-4 : f32
// CHECK: %[[VAL_13:.*]] = constant 0.00226843474 : f32
// CHECK: %[[VAL_14:.*]] = constant 0.00489352504 : f32
// CHECK: %[[VAL_15:.*]] = fpext %[[VAL_0]] : f16 to f32
// CHECK: %[[VAL_16:.*]] = absf %[[VAL_15]] : f32
// CHECK: %[[VAL_17:.*]] = cmpf "olt", %[[VAL_16]], %[[VAL_1]] : f32
// CHECK: %[[VAL_18:.*]] = cmpf "ule", %[[VAL_15]], %[[VAL_2]] : f32
// CHECK: %[[VAL_19:.*]] = select %[[VAL_18]], %[[VAL_15]], %[[VAL_2]] : f32
// CHECK: %[[VAL_20:.*]] = cmpf "uge", %[[VAL_19]], %[[VAL_3]] : f32
// CHECK: %[[VAL_21:.*]] = select %[[VAL_20]], %[[VAL_19]], %[[VAL_3]] : f32
// CHECK: %[[VAL_22:.*]] = mulf %[[VAL_21]], %[[VAL_21]] : f32
// CHECK: %[[VAL_23:.*]] = mulf %[[VAL_22]], %[[VAL_4]] : f32
// CHECK: %[[VAL_24:.*]] = addf %[[VAL_23]], %[[VAL_5]] : f32
// CHECK: %[[VAL_25:.*]] = mulf %[[VAL_22]], %[[VAL_24]] : f32
// CHECK: %[[VAL_26:.*]] = addf %[[VAL_25]], %[[VAL_6]] : f32
// CHECK: %[[VAL_27:.*]] = mulf %[[VAL_22]], %[[VAL_26]] : f32
// CHECK: %[[VAL_28:.*]] = addf %[[VAL_27]], %[[VAL_7]] : f32
// CHECK: %[[VAL_29:.*]] = mulf %[[VAL_22]], %[[VAL_28]] : f32
// CHECK: %[[VAL_30:.*]] = addf %[[VAL_29]], %[[VAL_8]] : f32
// CHECK: %[[VAL_31:.*]] = mulf %[[VAL_22]], %[[VAL_30]] : f32
// CHECK: %[[VAL_32:.*]] = addf %[[VAL_31]], %[[VAL_9]] : f32
// CHECK: %[[VAL_33:.*]] = mulf %[[VAL_22]], %[[VAL_32]] : f32
// CHECK: %[[VAL_34:.*]] = addf %[[VAL_33]], %[[VAL_10]] : f32
// CHECK: %[[VAL_35:.*]] = mulf %[[VAL_21]], %[[VAL_34]] : f32
// CHECK: %[[VAL_36:.*]] = mulf %[[VAL_22]], %[[VAL_11]] : f32
// CHECK: %[[VAL_37:.*]] = addf %[[VAL_36]], %[[VAL_12]] : f32
// CHECK: %[[VAL_38:.*]] = mulf %[[VAL_22]], %[[VAL_37]] : f32
// CHECK: %[[VAL_39:.*]] = addf %[[VAL_38]], %[[VAL_13]] : f32
// CHECK: %[[VAL_40:.*]] = mulf %[[VAL_22]], %[[VAL_39]] : f32
// CHECK: %[[VAL_41:.*]] = addf %[[VAL_40]], %[[VAL_14]] : f32
// CHECK: %[[VAL_42:.*]] = divf %[[VAL_35]], %[[VAL_41]] : f32
// CHECK: %[[VAL_43:.*]] = select %[[VAL_17]], %[[VAL_15]], %[[VAL_42]] : f32
// CHECK: %[[VAL_44:.*]] = fptrunc %[[VAL_43]] : f32 to f16
// CHECK: return %[[VAL_44]] : f16

// -----

// CHECK-LABEL: @atan2_f64
func @atan2_f64(%arg0 : f64, %arg1 : f64) -> f64 {
  // CHECK: atan2
  %res = atan2 %arg0, %arg1 : f64
  return %res : f64
}

// -----

// CHECK-LABEL: func @atan2_f32
// CHECK-SAME: (%[[ARG0:.*]]: f32, %[[ARG1:.*]]: f32) -> f32
func @atan2_f32(%arg0 : f32, %arg1 : f32) -> f32 {
  // CHECK: %[[CST:.*]] = constant 0.0027856871 : f32
  // CHECK: %[[CST_0:.*]] = constant -1.586600e-02 : f32
  // CHECK: %[[CST_1:.*]] = constant 0.042472221 : f32
  // CHECK: %[[CST_2:.*]] = constant -0.0749753043 : f32
  // CHECK: %[[CST_3:.*]] = constant 0.106448799 : f32
  // CHECK: %[[CST_4:.*]] = constant -0.142070308 : f32
  // CHECK: %[[CST_5:.*]] = constant 0.199934542 : f32
  // CHECK: %[[CST_6:.*]] = constant -0.333331466 : f32
  // CHECK: %[[CST_7:.*]] = constant 1.57079637 : f32
  // CHECK: %[[CST_8:.*]] = constant 0.000000e+00 : f32
  // CHECK: %[[CST_9:.*]] = constant 3.14159274 : f32
  // CHECK: %[[CST_10:.*]] = constant 0x7FC00000 : f32
  // CHECK: %[[CST_11:.*]] = constant 2.3561945 : f32
  // CHECK: %[[CST_12:.*]] = constant 0.785398185 : f32
  // CHECK: %[[CST_13:.*]] = constant 0x7F800000 : f32
  // CHECK: %[[VAL_0:.*]] = absf %[[ARG1]] : f32
  // CHECK: %[[VAL_1:.*]] = absf %[[ARG0]] : f32
  // CHECK: %[[VAL_2:.*]] = cmpf "ole", %[[VAL_0]], %[[VAL_1]] : f32
  // CHECK: %[[VAL_3:.*]] = select %[[VAL_2]], %[[VAL_0]], %[[VAL_1]] : f32
  // CHECK: %[[VAL_4:.*]] = select %[[VAL_2]], %[[VAL_1]], %[[VAL_0]] : f32
  // CHECK: %[[VAL_5:.*]] = divf %[[VAL_3]], %[[VAL_4]] : f32
  // CHECK: %[[VAL_6:.*]] = mulf %[[VAL_5]], %[[VAL_5]] : f32
  // CHECK: %[[VAL_7:.*]] = mulf %[[CST]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_8:.*]] = addf %[[VAL_7]], %[[CST_0]] : f32
  // CHECK: %[[VAL_9:.*]] = mulf %[[VAL_8]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_10:.*]] = addf %[[VAL_9]], %[[CST_1]] : f32
  // CHECK: %[[VAL_11:.*]] = mulf %[[VAL_10]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_12:.*]] = addf %[[VAL_11]], %[[CST_2]] : f32
  // CHECK: %[[VAL_13:.*]] = mulf %[[VAL_12]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_14:.*]] = addf %[[VAL_13]], %[[CST_3]] : f32
  // CHECK: %[[VAL_15:.*]] = mulf %[[VAL_14]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_16:.*]] = addf %[[VAL_15]], %[[CST_4]] : f32
  // CHECK: %[[VAL_17:.*]] = mulf %[[VAL_16]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_18:.*]] = addf %[[VAL_17]], %[[CST_5]] : f32
  // CHECK: %[[VAL_19:.*]] = mulf %[[VAL_18]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_20:.*]] = addf %[[VAL_19]], %[[CST_6]] : f32
  // CHECK: %[[VAL_21:.*]] = mulf %[[VAL_20]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_22:.*]] = mulf %[[VAL_21]], %[[VAL_5]] : f32
  // CHECK: %[[VAL_23:.*]] = addf %[[VAL_22]], %[[VAL_5]] : f32
  // CHECK: %[[VAL_24:.*]] = subf %[[CST_7]], %[[VAL_23]] : f32
  // CHECK: %[[VAL_25:.*]] = select %[[VAL_2]], %[[VAL_24]], %[[VAL_23]] : f32
  // CHECK: %[[VAL_26:.*]] = cmpf "olt", %[[ARG1]], %[[CST_8]] : f32
  // CHECK: %[[VAL_27:.*]] = subf %[[CST_9]], %[[VAL_25]] : f32
  // CHECK: %[[VAL_28:.*]] = select %[[VAL_26]], %[[VAL_27]], %[[VAL_25]] : f32
  // CHECK: %[[VAL_29:.*]] = select %[[VAL_26]], %[[CST_9]], %[[CST_8]] : f32
  // CHECK: %[[VAL_30:.*]] = cmpf "oeq", %[[ARG0]], %[[CST_8]] : f32
  // CHECK: %[[VAL_31:.*]] = select %[[VAL_30]], %[[VAL_29]], %[[VAL_28]] : f32
  // CHECK: %[[VAL_32:.*]] = cmpf "uno", %[[ARG0]], %[[ARG1]] : f32
  // CHECK: %[[VAL_35:.*]] = select %[[VAL_32]], %[[CST_10]], %[[VAL_31]] : f32
  // CHECK: %[[VAL_36:.*]] = select %[[VAL_26]], %[[CST_11]], %[[CST_12]] : f32
  // CHECK: %[[VAL_37:.*]] = cmpf "oeq", %[[ARG1]], %[[CST_13]] : f32
  // CHECK: %[[VAL_38:.*]] = cmpf "oeq", %[[ARG0]], %[[CST_13]] : f32
  // CHECK: %[[VAL_39:.*]] = and %[[VAL_37]], %[[VAL_38]] : i1
  // CHECK: %[[VAL_40:.*]] = select %[[VAL_39]], %[[VAL_36]], %[[VAL_35]] : f32
  // CHECK: %[[VAL_41:.*]] = copysign %[[VAL_40]], %[[ARG0]] : f32
  // CHECK: return %[[VAL_41]] : f32
  %res = atan2 %arg0, %arg1 : f32
  return %res : f32
}

// -----

// CHECK-LABEL: @atan2_f16
// CHECK-SAME: (%[[ARG0:.*]]: f16, %[[ARG1:.*]]: f16) -> f16
func @atan2_f16(%arg0 : f16, %arg1 : f16) -> f16 {
  // CHECK: %[[CST:.*]] = constant 0.0027856871 : f32
  // CHECK: %[[CST_0:.*]] = constant -1.586600e-02 : f32
  // CHECK: %[[CST_1:.*]] = constant 0.042472221 : f32
  // CHECK: %[[CST_2:.*]] = constant -0.0749753043 : f32
  // CHECK: %[[CST_3:.*]] = constant 0.106448799 : f32
  // CHECK: %[[CST_4:.*]] = constant -0.142070308 : f32
  // CHECK: %[[CST_5:.*]] = constant 0.199934542 : f32
  // CHECK: %[[CST_6:.*]] = constant -0.333331466 : f32
  // CHECK: %[[CST_7:.*]] = constant 1.57079637 : f32
  // CHECK: %[[CST_8:.*]] = constant 0.000000e+00 : f32
  // CHECK: %[[CST_9:.*]] = constant 3.14159274 : f32
  // CHECK: %[[CST_10:.*]] = constant 0x7FC00000 : f32
  // CHECK: %[[CST_11:.*]] = constant 2.3561945 : f32
  // CHECK: %[[CST_12:.*]] = constant 0.785398185 : f32
  // CHECK: %[[CST_13:.*]] = constant 0x7F800000 : f32
  // CHECK: %[[VAL_0:.*]] = fpext %[[ARG0]] : f16 to f32
  // CHECK: %[[VAL_1:.*]] = fpext %[[ARG1]] : f16 to f32
  // CHECK: %[[VAL_2:.*]] = absf %[[VAL_1]] : f32
  // CHECK: %[[VAL_3:.*]] = absf %[[VAL_0]] : f32
  // CHECK: %[[VAL_4:.*]] = cmpf "ole", %[[VAL_2]], %[[VAL_3]] : f32
  // CHECK: %[[VAL_5:.*]] = select %[[VAL_4]], %[[VAL_2]], %[[VAL_3]] : f32
  // CHECK: %[[VAL_6:.*]] = select %[[VAL_4]], %[[VAL_3]], %[[VAL_2]] : f32
  // CHECK: %[[VAL_7:.*]] = divf %[[VAL_5]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_8:.*]] = mulf %[[VAL_7]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_9:.*]] = mulf %[[CST]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_10:.*]] = addf %[[VAL_9]], %[[CST_0]] : f32
  // CHECK: %[[VAL_11:.*]] = mulf %[[VAL_10]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_12:.*]] = addf %[[VAL_11]], %[[CST_1]] : f32
  // CHECK: %[[VAL_13:.*]] = mulf %[[VAL_12]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_14:.*]] = addf %[[VAL_13]], %[[CST_2]] : f32
  // CHECK: %[[VAL_15:.*]] = mulf %[[VAL_14]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_16:.*]] = addf %[[VAL_15]], %[[CST_3]] : f32
  // CHECK: %[[VAL_17:.*]] = mulf %[[VAL_16]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_18:.*]] = addf %[[VAL_17]], %[[CST_4]] : f32
  // CHECK: %[[VAL_19:.*]] = mulf %[[VAL_18]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_20:.*]] = addf %[[VAL_19]], %[[CST_5]] : f32
  // CHECK: %[[VAL_21:.*]] = mulf %[[VAL_20]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_22:.*]] = addf %[[VAL_21]], %[[CST_6]] : f32
  // CHECK: %[[VAL_23:.*]] = mulf %[[VAL_22]], %[[VAL_8]] : f32
  // CHECK: %[[VAL_24:.*]] = mulf %[[VAL_23]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_25:.*]] = addf %[[VAL_24]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_26:.*]] = subf %[[CST_7]], %[[VAL_25]] : f32
  // CHECK: %[[VAL_27:.*]] = select %[[VAL_4]], %[[VAL_26]], %[[VAL_25]] : f32
  // CHECK: %[[VAL_28:.*]] = cmpf "olt", %[[VAL_1]], %[[CST_8]] : f32
  // CHECK: %[[VAL_29:.*]] = subf %[[CST_9]], %[[VAL_27]] : f32
  // CHECK: %[[VAL_30:.*]] = select %[[VAL_28]], %[[VAL_29]], %[[VAL_27]] : f32
  // CHECK: %[[VAL_31:.*]] = select %[[VAL_28]], %[[CST_9]], %[[CST_8]] : f32
  // CHECK: %[[VAL_32:.*]] = cmpf "oeq", %[[VAL_0]], %[[CST_8]] : f32
  // CHECK: %[[VAL_33:.*]] = select %[[VAL_32]], %[[VAL_31]], %[[VAL_30]] : f32
  // CHECK: %[[VAL_34:.*]] = cmpf "uno", %[[VAL_0]], %[[VAL_1]] : f32
  // CHECK: %[[VAL_37:.*]] = select %[[VAL_34]], %[[CST_10]], %[[VAL_33]] : f32
  // CHECK: %[[VAL_38:.*]] = select %[[VAL_28]], %[[CST_11]], %[[CST_12]] : f32
  // CHECK: %[[VAL_39:.*]] = cmpf "oeq", %[[VAL_1]], %[[CST_13]] : f32
  // CHECK: %[[VAL_40:.*]] = cmpf "oeq", %[[VAL_0]], %[[CST_13]] : f32
  // CHECK: %[[VAL_41:.*]] = and %[[VAL_39]], %[[VAL_40]] : i1
  // CHECK: %[[VAL_42:.*]] = select %[[VAL_41]], %[[VAL_38]], %[[VAL_37]] : f32
  // CHECK: %[[VAL_43:.*]] = copysign %[[VAL_42]], %[[VAL_0]] : f32
  // CHECK: %[[VAL_44:.*]] = fptrunc %[[VAL_43]] : f32 to f16
  // CHECK: return %[[VAL_44]] : f16
  %res = atan2 %arg0, %arg1 : f16
  return %res : f16
}

// -----

// CHECK-LABEL: @atan_f64
func @atan_f64(%arg : f64) -> f64 {
  // CHECK: atan
  %res = atan %arg : f64
  return %res : f64
}

// -----

// CHECK-LABEL: func @atan_f32
// CHECK-SAME: (%[[ARG:.*]]: f32) -> f32
func @atan_f32(%arg : f32) -> f32 {
  // CHECK: %[[CST:.*]] = constant 1.000000e+00 : f32
  // CHECK: %[[CST_0:.*]] = constant 0.0027856871 : f32
  // CHECK: %[[CST_1:.*]] = constant -1.586600e-02 : f32
  // CHECK: %[[CST_2:.*]] = constant 0.042472221 : f32
  // CHECK: %[[CST_3:.*]] = constant -0.0749753043 : f32
  // CHECK: %[[CST_4:.*]] = constant 0.106448799 : f32
  // CHECK: %[[CST_5:.*]] = constant -0.142070308 : f32
  // CHECK: %[[CST_6:.*]] = constant 0.199934542 : f32
  // CHECK: %[[CST_7:.*]] = constant -0.333331466 : f32
  // CHECK: %[[CST_8:.*]] = constant 1.57079637 : f32
  // CHECK: %[[CST_9:.*]] = constant 0.000000e+00 : f32
  // CHECK: %[[CST_10:.*]] = constant 0x7FC00000 : f32
  // CHECK: %[[VAL_0:.*]] = absf %[[CST]] : f32
  // CHECK: %[[VAL_1:.*]] = absf %arg0 : f32
  // CHECK: %[[VAL_2:.*]] = cmpf "ole", %[[VAL_0]], %[[VAL_1]] : f32
  // CHECK: %[[VAL_3:.*]] = select %[[VAL_2]], %[[VAL_0]], %[[VAL_1]] : f32
  // CHECK: %[[VAL_4:.*]] = select %[[VAL_2]], %[[VAL_1]], %[[VAL_0]] : f32
  // CHECK: %[[VAL_5:.*]] = divf %[[VAL_3]], %[[VAL_4]] : f32
  // CHECK: %[[VAL_6:.*]] = mulf %[[VAL_5]], %[[VAL_5]] : f32
  // CHECK: %[[VAL_7:.*]] = mulf %[[CST_0]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_8:.*]] = addf %[[VAL_7]], %[[CST_1]] : f32
  // CHECK: %[[VAL_9:.*]] = mulf %[[VAL_8]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_10:.*]] = addf %[[VAL_9]], %[[CST_2]] : f32
  // CHECK: %[[VAL_11:.*]] = mulf %[[VAL_10]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_12:.*]] = addf %[[VAL_11]], %[[CST_3]] : f32
  // CHECK: %[[VAL_13:.*]] = mulf %[[VAL_12]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_14:.*]] = addf %[[VAL_13]], %[[CST_4]] : f32
  // CHECK: %[[VAL_15:.*]] = mulf %[[VAL_14]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_16:.*]] = addf %[[VAL_15]], %[[CST_5]] : f32
  // CHECK: %[[VAL_17:.*]] = mulf %[[VAL_16]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_18:.*]] = addf %[[VAL_17]], %[[CST_6]] : f32
  // CHECK: %[[VAL_19:.*]] = mulf %[[VAL_18]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_20:.*]] = addf %[[VAL_19]], %[[CST_7]] : f32
  // CHECK: %[[VAL_21:.*]] = mulf %[[VAL_20]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_22:.*]] = mulf %[[VAL_21]], %[[VAL_5]] : f32
  // CHECK: %[[VAL_23:.*]] = addf %[[VAL_22]], %[[VAL_5]] : f32
  // CHECK: %[[VAL_24:.*]] = subf %[[CST_8]], %[[VAL_23]] : f32
  // CHECK: %[[VAL_25:.*]] = select %[[VAL_2]], %[[VAL_24]], %[[VAL_23]] : f32
  // CHECK: %[[VAL_26:.*]] = cmpf "oeq", %arg0, %[[CST_9]] : f32
  // CHECK: %[[VAL_27:.*]] = select %[[VAL_26]], %[[CST_9]], %[[VAL_25]] : f32
  // CHECK: %[[VAL_28:.*]] = cmpf "uno", %arg0, %[[CST]] : f32
  // CHECK: %[[VAL_29:.*]] = select %[[VAL_28]], %[[CST_10]], %[[VAL_27]] : f32
  // CHECK: %[[VAL_30:.*]] = copysign %[[VAL_29]], %arg0 : f32
  // CHECK: return %[[VAL_30]] : f32
  %res = atan %arg : f32
  return %res : f32
}

// -----

// CHECK-LABEL: @atan_f16
// CHECK-SAME: (%[[ARG:.*]]: f16) -> f16
func @atan_f16(%arg : f16) -> f16 {
  // CHECK: %[[CST:.*]] = constant 1.000000e+00 : f32
  // CHECK: %[[CST_0:.*]] = constant 0.0027856871 : f32
  // CHECK: %[[CST_1:.*]] = constant -1.586600e-02 : f32
  // CHECK: %[[CST_2:.*]] = constant 0.042472221 : f32
  // CHECK: %[[CST_3:.*]] = constant -0.0749753043 : f32
  // CHECK: %[[CST_4:.*]] = constant 0.106448799 : f32
  // CHECK: %[[CST_5:.*]] = constant -0.142070308 : f32
  // CHECK: %[[CST_6:.*]] = constant 0.199934542 : f32
  // CHECK: %[[CST_7:.*]] = constant -0.333331466 : f32
  // CHECK: %[[CST_8:.*]] = constant 1.57079637 : f32
  // CHECK: %[[CST_9:.*]] = constant 0.000000e+00 : f32
  // CHECK: %[[CST_10:.*]] = constant 0x7FC00000 : f32
  // CHECK: %[[VAL_0:.*]] = fpext %arg0 : f16 to f32
  // CHECK: %[[VAL_1:.*]] = absf %[[CST]] : f32
  // CHECK: %[[VAL_2:.*]] = absf %[[VAL_0]] : f32
  // CHECK: %[[VAL_3:.*]] = cmpf "ole", %[[VAL_1]], %[[VAL_2]] : f32
  // CHECK: %[[VAL_4:.*]] = select %[[VAL_3]], %[[VAL_1]], %[[VAL_2]] : f32
  // CHECK: %[[VAL_5:.*]] = select %[[VAL_3]], %[[VAL_2]], %[[VAL_1]] : f32
  // CHECK: %[[VAL_6:.*]] = divf %[[VAL_4]], %[[VAL_5]] : f32
  // CHECK: %[[VAL_7:.*]] = mulf %[[VAL_6]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_8:.*]] = mulf %[[CST_0]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_9:.*]] = addf %[[VAL_8]], %[[CST_1]] : f32
  // CHECK: %[[VAL_10:.*]] = mulf %[[VAL_9]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_11:.*]] = addf %[[VAL_10]], %[[CST_2]] : f32
  // CHECK: %[[VAL_12:.*]] = mulf %[[VAL_11]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_13:.*]] = addf %[[VAL_12]], %[[CST_3]] : f32
  // CHECK: %[[VAL_14:.*]] = mulf %[[VAL_13]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_15:.*]] = addf %[[VAL_14]], %[[CST_4]] : f32
  // CHECK: %[[VAL_16:.*]] = mulf %[[VAL_15]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_17:.*]] = addf %[[VAL_16]], %[[CST_5]] : f32
  // CHECK: %[[VAL_18:.*]] = mulf %[[VAL_17]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_19:.*]] = addf %[[VAL_18]], %[[CST_6]] : f32
  // CHECK: %[[VAL_20:.*]] = mulf %[[VAL_19]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_21:.*]] = addf %[[VAL_20]], %[[CST_7]] : f32
  // CHECK: %[[VAL_22:.*]] = mulf %[[VAL_21]], %[[VAL_7]] : f32
  // CHECK: %[[VAL_23:.*]] = mulf %[[VAL_22]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_24:.*]] = addf %[[VAL_23]], %[[VAL_6]] : f32
  // CHECK: %[[VAL_25:.*]] = subf %[[CST_8]], %[[VAL_24]] : f32
  // CHECK: %[[VAL_26:.*]] = select %[[VAL_3]], %[[VAL_25]], %[[VAL_24]] : f32
  // CHECK: %[[VAL_27:.*]] = cmpf "oeq", %[[VAL_0]], %[[CST_9]] : f32
  // CHECK: %[[VAL_28:.*]] = select %[[VAL_27]], %[[CST_9]], %[[VAL_26]] : f32
  // CHECK: %[[VAL_29:.*]] = cmpf "uno", %[[VAL_0]], %[[CST]] : f32
  // CHECK: %[[VAL_30:.*]] = select %[[VAL_29]], %[[CST_10]], %[[VAL_28]] : f32
  // CHECK: %[[VAL_31:.*]] = copysign %[[VAL_30]], %[[VAL_0]] : f32
  // CHECK: %[[VAL_32:.*]] = fptrunc %[[VAL_31]] : f32 to f16
  // CHECK: return %[[VAL_32]] : f16
  %res = atan %arg : f16
  return %res : f16
}
