/*
 * Decompiled with CFR 0.152.
 */
package gong.xml.gasi;

import gong.Utility;
import gong.xml.gasi.Fault;
import gong.xml.gasi.Request;
import gong.xml.gasi.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Message {
    protected static final String NAMESPACE_URI = "http://gong.ust.hk/gasi10";
    protected Document document;

    protected Message() throws Exception {
        this.document = Utility.getNewDocument();
    }

    protected Message(Document document) {
        this.document = document;
    }

    public static Message parse(String string) throws Exception {
        Document document = Utility.parseXMLDocument(string);
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new Exception("Root element not found.");
        }
        if (element.getNamespaceURI() == null || !element.getNamespaceURI().equals(NAMESPACE_URI)) {
            throw new Exception("Namespace (http://gong.ust.hk/gasi10) is not correct.");
        }
        String string2 = element.getLocalName();
        if (Request.isRequest(string2)) {
            return new Request(document);
        }
        if (Response.isResponse(string2)) {
            return new Response(document);
        }
        if (Fault.isFault(string2)) {
            return new Fault(document);
        }
        return null;
    }

    public static Request newRequest(String string) throws Exception {
        return new Request(string);
    }

    public static Response newResponse(String string) throws Exception {
        return new Response(string);
    }

    public static Fault newFault(String string, String string2) throws Exception {
        return new Fault(string, string2);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setParameter(String string, String string2, boolean bl) throws Exception {
        Object object;
        Element element = this.document.getDocumentElement();
        if (element == null) {
            throw new Exception("Root element not found.");
        }
        Node node = null;
        if (bl) {
            object = element.getElementsByTagNameNS(NAMESPACE_URI, string);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node2 = object.item(i);
                if (!node2.getParentNode().equals(element)) continue;
                node = node2;
            }
        }
        object = this.document.createElementNS(NAMESPACE_URI, string);
        if (string2 != null && string2.length() > 0) {
            object.appendChild(this.document.createTextNode(string2));
        }
        if (node == null) {
            element.appendChild((Node)object);
        } else {
            element.replaceChild((Node)object, node);
        }
    }

    public void setParameter(String string, Element element, boolean bl) throws Exception {
        Object object;
        Element element2 = this.document.getDocumentElement();
        if (element2 == null) {
            throw new Exception("Root element not found.");
        }
        Node node = null;
        if (bl) {
            object = element2.getElementsByTagNameNS(NAMESPACE_URI, string);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node2 = object.item(i);
                if (!node2.getParentNode().equals(element2)) continue;
                node = node2;
            }
        }
        object = this.document.createElementNS(NAMESPACE_URI, string);
        if (element != null) {
            object.appendChild(element);
        }
        if (node == null) {
            element2.appendChild((Node)object);
        } else {
            element2.replaceChild((Node)object, node);
        }
    }

    public String getParameter(String string) throws Exception {
        Element element = this.document.getDocumentElement();
        if (element == null) {
            throw new Exception("Root element not found.");
        }
        NodeList nodeList = element.getElementsByTagNameNS(NAMESPACE_URI, string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getParentNode().equals(element)) continue;
            if (node.getFirstChild() == null || node.getFirstChild().getNodeType() != 3) {
                return null;
            }
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }

    public String getParameter(String string, String string2) throws Exception {
        Element element = this.document.getDocumentElement();
        if (element == null) {
            throw new Exception("Root element not found.");
        }
        NodeList nodeList = element.getElementsByTagNameNS(NAMESPACE_URI, string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagNameNS(NAMESPACE_URI, string2);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node = nodeList2.item(j);
                if (!node.getParentNode().equals(element2)) continue;
                if (node.getFirstChild() == null || node.getFirstChild().getNodeType() != 3) {
                    return null;
                }
                return node.getFirstChild().getNodeValue();
            }
        }
        return null;
    }

    public String toString() {
        try {
            return Utility.serializeXMLDocument(this.document, true);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

