/*
 * Decompiled with CFR 0.152.
 */
package gong.ui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class NanoTimeUI
extends BasicSliderUI {
    TimeListener listener;

    public NanoTimeUI(JSlider jSlider, TimeListener timeListener) {
        super(jSlider);
        this.listener = timeListener;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
        jComponent.setFocusable(false);
        jComponent.setEnabled(false);
    }

    public void paintTrack(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.slider.getBounds();
        float f = (float)(this.slider.getValue() - this.slider.getMinimum()) / (float)(this.slider.getMaximum() - this.slider.getMinimum());
        int n = (int)Math.ceil((float)(rectangle.width - 1) * f);
        graphics2D.setColor(new Color(64, 64, 255));
        graphics2D.fillRect(0, 0, n, rectangle.height);
        graphics2D.setColor(this.slider.getBackground().darker());
        graphics2D.fillRect(n, 0, rectangle.width - n, rectangle.height);
    }

    public void paintThumb(Graphics graphics) {
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new TimeTrackListener();
    }

    public static interface TimeListener {
        public void timeUpdate(int var1);
    }

    public class TimeTrackListener
    extends BasicSliderUI.TrackListener {
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        public TimeTrackListener() {
            super(NanoTimeUI.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!NanoTimeUI.this.slider.isEnabled()) {
                return;
            }
            NanoTimeUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!NanoTimeUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (NanoTimeUI.this.slider.isRequestFocusEnabled()) {
                NanoTimeUI.this.slider.requestFocus();
            }
            Dimension dimension = NanoTimeUI.this.slider.getSize();
            int n = (int)((float)this.currentMouseX / (float)dimension.width * (float)(NanoTimeUI.this.slider.getMaximum() - NanoTimeUI.this.slider.getMinimum())) + NanoTimeUI.this.slider.getMinimum();
            NanoTimeUI.this.slider.setValue(n);
            if (NanoTimeUI.this.listener != null) {
                NanoTimeUI.this.listener.timeUpdate(n);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

