/*
 * Decompiled with CFR 0.152.
 */
package gong.audio.data;

import gong.audio.AudioData;
import gong.audio.AudioDataException;
import gong.audio.data.BlockAudioData;
import gong.audio.data.OggSpeexWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sound.sampled.AudioFormat;
import org.xiph.speex.SpeexDecoder;
import org.xiph.speex.SpeexEncoder;

public class SpeexData
extends BlockAudioData {
    public static final String FILE_EXTENSION = ".spx";
    public static final int SPEEX_DEFAULT_QUALITY = 5;
    private int framesPerPacket;
    private SpeexEncoder encoder = new SpeexEncoder();
    private OggSpeexWriter writer;
    private SpeexDecoder decoder = new SpeexDecoder();
    private Hashtable decodedData = new Hashtable();
    protected long cacheSize = 0L;

    public SpeexData() {
    }

    public SpeexData(AudioFormat audioFormat, boolean bl, int n) {
        super(audioFormat);
        int n2 = 0;
        n2 = audioFormat.getSampleRate() <= 8000.0f ? 0 : (audioFormat.getSampleRate() <= 16000.0f ? 1 : 2);
        this.decoder.init(n2, (int)audioFormat.getSampleRate(), audioFormat.getChannels(), true);
        this.encoder.init(n2, n, (int)audioFormat.getSampleRate(), audioFormat.getChannels());
        this.encoder.getEncoder().setVbr(bl);
        this.encoder.getEncoder().setVbrQuality(n);
        this.framesPerPacket = 1;
        this.samplesPerBlock = this.encoder.getFrameSize();
        this.writer = new OggSpeexWriter(n2, (int)audioFormat.getSampleRate(), audioFormat.getChannels(), 1, bl);
    }

    public SpeexData(AudioFormat audioFormat) {
        this(audioFormat, true, 5);
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    protected BlockAudioData.Block createBlock() {
        return new SpeexBlock(this.samplesPerBlock);
    }

    public void close() throws IOException, AudioDataException {
        Enumeration enumeration = this.blockData.elements();
        while (enumeration.hasMoreElements()) {
            SpeexBlock speexBlock = (SpeexBlock)enumeration.nextElement();
            if (speexBlock.getData() != null) continue;
            speexBlock.encodeData();
        }
    }

    public boolean isSupported(String string) {
        if (string.equals("sent-progress")) {
            return true;
        }
        if (string.equals("received-progress")) {
            return false;
        }
        return false;
    }

    public synchronized long getMemoryUsage() {
        long l = 0L;
        Enumeration enumeration = this.blockData.elements();
        while (enumeration.hasMoreElements()) {
            SpeexBlock speexBlock = (SpeexBlock)enumeration.nextElement();
            if (speexBlock.getData() == null) continue;
            l += (long)speexBlock.getData().length;
        }
        return l;
    }

    public synchronized Object clone() {
        SpeexData speexData = new SpeexData(this.format);
        Enumeration enumeration = this.blockData.elements();
        while (enumeration.hasMoreElements()) {
            speexData.blockData.add(((SpeexBlock)enumeration.nextElement()).clone());
        }
        speexData.framesPerPacket = this.framesPerPacket;
        speexData.samplesPerBlock = this.samplesPerBlock;
        speexData.availableBlocks = this.availableBlocks;
        speexData.decoder = this.decoder;
        speexData.encoder = this.encoder;
        return speexData;
    }

    private void sendHeaderToOggWriter(OggSpeexWriter oggSpeexWriter) throws IOException, AudioDataException {
        oggSpeexWriter.writeHeader("Stream encoded in Gong");
    }

    private void sendDataToOggWriter(OggSpeexWriter oggSpeexWriter) throws IOException, AudioDataException {
        int n = 0;
        Enumeration enumeration = this.blockData.elements();
        while (enumeration.hasMoreElements()) {
            SpeexBlock speexBlock = (SpeexBlock)enumeration.nextElement();
            speexBlock.sendToOggWriter(oggSpeexWriter);
            ++n;
            if (this.listener == null) continue;
            this.listener.sent(this, this.getBlockTime(n));
        }
    }

    public synchronized void sendToStream(OutputStream outputStream) throws IOException, AudioDataException {
        this.writer.open("");
        this.sendHeaderToOggWriter(this.writer);
        this.sendDataToOggWriter(this.writer);
        this.writer.close();
        byte[] byArray = this.writer.getData();
        outputStream.write(this.writer.getData());
    }

    protected OggHeader receiveOggHeaderFromStream(InputStream inputStream) throws IOException, AudioDataException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[4];
        OggHeader oggHeader = new OggHeader();
        this.receiveByteArrayFromStream(dataInputStream, byArray, 0, 4);
        if (!new String(byArray, 0, 4).equals("OggS")) {
            throw new AudioDataException("Invalid Ogg id ('OggS').");
        }
        dataInputStream.read();
        oggHeader.headerType = dataInputStream.read();
        oggHeader.granulePos = SpeexData.swapLong(dataInputStream.readLong());
        oggHeader.serial = SpeexData.swapInt(dataInputStream.readInt());
        oggHeader.sequence = SpeexData.swapInt(dataInputStream.readInt());
        oggHeader.checksum = SpeexData.swapInt(dataInputStream.readInt());
        oggHeader.segments = dataInputStream.read();
        oggHeader.segmentSize = new byte[oggHeader.segments];
        this.receiveByteArrayFromStream(dataInputStream, oggHeader.segmentSize, 0, oggHeader.segments);
        return oggHeader;
    }

    private boolean checkSpeexMode(int n, int n2) {
        if (n <= 8000) {
            return n2 == 0;
        }
        if (n <= 16000) {
            return n2 == 1;
        }
        return n2 == 2;
    }

    private void receiveSpeexHeaderFromStream(InputStream inputStream) throws IOException, AudioDataException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[20];
        this.receiveByteArrayFromStream(dataInputStream, byArray, 0, 8);
        if (!new String(byArray, 0, 8).equals("Speex   ")) {
            throw new AudioDataException("Invalid Speex string ('Speex   ').");
        }
        this.receiveByteArrayFromStream(dataInputStream, byArray, 0, 20);
        int n = SpeexData.swapInt(dataInputStream.readInt());
        if (n != 1) {
            throw new AudioDataException("Invalid Speex version id.");
        }
        int n2 = SpeexData.swapInt(dataInputStream.readInt());
        if (n2 != 80) {
            throw new AudioDataException("Invalid Header size.");
        }
        int n3 = SpeexData.swapInt(dataInputStream.readInt());
        this.format = new AudioFormat(n3, 16, 1, true, true);
        int n4 = SpeexData.swapInt(dataInputStream.readInt());
        if (!this.checkSpeexMode(n3, n4)) {
            throw new AudioDataException("Invalid Speex mode.");
        }
        int n5 = SpeexData.swapInt(dataInputStream.readInt());
        if (n5 != 4) {
            throw new AudioDataException("Invalid Bitstream version.");
        }
        int n6 = SpeexData.swapInt(dataInputStream.readInt());
        if (n6 != 1) {
            throw new AudioDataException("Invalid Channels.");
        }
        int n7 = SpeexData.swapInt(dataInputStream.readInt());
        if (n7 != -1) {
            throw new AudioDataException("Invalid Bitrate.");
        }
        this.samplesPerBlock = SpeexData.swapInt(dataInputStream.readInt());
        if (n4 == 0 && this.samplesPerBlock != 160 || n4 == 1 && this.samplesPerBlock != 320 || n4 == 2 && this.samplesPerBlock != 640) {
            throw new AudioDataException("Invalid Frame size.");
        }
        int n8 = SpeexData.swapInt(dataInputStream.readInt());
        this.framesPerPacket = SpeexData.swapInt(dataInputStream.readInt());
        int n9 = SpeexData.swapInt(dataInputStream.readInt());
        if (n9 != 0) {
            throw new AudioDataException("Invalid Extra header value.");
        }
        int n10 = SpeexData.swapInt(dataInputStream.readInt());
        int n11 = SpeexData.swapInt(dataInputStream.readInt());
        this.decoder.init(n4, n3, n6, true);
    }

    public void receiveHeaderFromStream(InputStream inputStream) throws IOException, AudioDataException {
        OggHeader oggHeader = this.receiveOggHeaderFromStream(inputStream);
        if (oggHeader.headerType != 2) {
            throw new AudioDataException("Invalid header.");
        }
        if (oggHeader.segments != 1) {
            throw new AudioDataException("Invalid header.");
        }
        if (oggHeader.segmentSize[0] != 80) {
            throw new AudioDataException("Invalid header.");
        }
        this.receiveSpeexHeaderFromStream(inputStream);
        oggHeader = this.receiveOggHeaderFromStream(inputStream);
        if (oggHeader.headerType != 0) {
            throw new AudioDataException("Invalid header.");
        }
        if (oggHeader.segments != 1) {
            throw new AudioDataException("Invalid header.");
        }
        byte[] byArray = new byte[oggHeader.segmentSize[0]];
        this.receiveByteArrayFromStream(inputStream, byArray, 0, oggHeader.segmentSize[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveDataFromStream(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException, AudioDataException {
        OggHeader oggHeader = new OggHeader();
        if (bl) {
            try {
                while (oggHeader.headerType != 4) {
                    oggHeader = this.receiveOggHeaderFromStream(inputStream);
                    if (oggHeader.headerType != 0 && oggHeader.headerType != 4) {
                        throw new AudioDataException("Invalid header.");
                    }
                    int n = 0;
                    for (int i = 0; i < oggHeader.segments; ++i) {
                        n += oggHeader.segmentSize[i];
                    }
                    byte[] byArray = new byte[n];
                    this.receiveByteArrayFromStream(inputStream, byArray, 0, n);
                    int n2 = 0;
                    for (int i = 0; i < oggHeader.segments; ++i) {
                        SpeexBlock speexBlock = new SpeexBlock(this.samplesPerBlock);
                        if (outputStream == null) {
                            speexBlock.setEncodedData(byArray, n2, oggHeader.segmentSize[i]);
                        } else {
                            outputStream.write(byArray, n2, oggHeader.segmentSize[i]);
                            speexBlock.setCache(this.cacheSize, oggHeader.segmentSize[i]);
                            this.cacheSize += (long)oggHeader.segmentSize[i];
                        }
                        n2 += oggHeader.segmentSize[i];
                        this.blockData.add(speexBlock);
                        ++this.availableBlocks;
                        if (this.listener == null) continue;
                        this.listener.received(this, this.getAvailable());
                    }
                }
                return;
            }
            catch (EOFException eOFException) {
                if (this.availableBlocks != 0) return;
                throw new AudioDataException("Invalid audio data.");
            }
            catch (Exception exception) {
                throw new AudioDataException("Invalid audio data.");
            }
        } else {
            if (this.transferThread != null) return;
            this.transferThread = this.getTransferThread();
            this.transferThread.start(inputStream, outputStream);
        }
    }

    public synchronized void receiveFromStream(InputStream inputStream, boolean bl) throws IOException, AudioDataException {
        FileOutputStream fileOutputStream = null;
        if (this.cache != null) {
            fileOutputStream = new FileOutputStream(this.cache);
        }
        this.receiveHeaderFromStream(inputStream);
        this.receiveDataFromStream(inputStream, fileOutputStream, bl);
    }

    protected AudioData.TransferThread getTransferThread() {
        return new SpeexTransferThread();
    }

    public synchronized boolean isTransferBuffered(float f) {
        if (!this.isAvailable()) {
            return false;
        }
        if (!this.isTransferInProgress()) {
            return true;
        }
        return (float)(this.getAvailable() - this.getTime()) * f >= 30000.0f;
    }

    protected class SpeexBlock
    extends BlockAudioData.Block {
        protected long cacheOffset;
        protected int cacheLength;

        public SpeexBlock(int n) {
            super(n);
            this.cacheOffset = -1L;
            this.cacheLength = 0;
            this.reset();
        }

        public synchronized void setCache(long l, int n) {
            this.data = null;
            this.cacheOffset = l;
            this.cacheLength = n;
        }

        public synchronized void setEncodedData(byte[] byArray, int n, int n2) {
            this.data = new byte[n2];
            System.arraycopy(byArray, n, this.data, 0, n2);
            this.cacheOffset = -1L;
            this.cacheLength = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read() throws IOException, AudioDataException {
            if (this.eob()) {
                throw new AudioDataException("Invalid read request.");
            }
            byte[] byArray = null;
            if (!SpeexData.this.decodedData.containsKey(this)) {
                if (this.data == null && this.cacheOffset < 0L) {
                    throw new AudioDataException("Invalid read request.");
                }
                SpeexDecoder speexDecoder = SpeexData.this.decoder;
                synchronized (speexDecoder) {
                    if (this.data == null) {
                        byte[] byArray2 = new byte[this.cacheLength];
                        SpeexData.this.cacheInputStream.read(byArray2, this.cacheOffset);
                        SpeexData.this.decoder.processData(byArray2, 0, byArray2.length);
                    } else {
                        SpeexData.this.decoder.processData(this.data, 0, this.data.length);
                    }
                    byArray = new byte[SpeexData.this.decoder.getProcessedDataByteSize()];
                    SpeexData.this.decoder.getProcessedData(byArray, 0);
                    SpeexData.this.decodedData.clear();
                    SpeexData.this.decodedData.put(this, byArray);
                }
            } else {
                byArray = (byte[])SpeexData.this.decodedData.get(this);
            }
            int n = byArray[2 * this.position + 1] << 8 | byArray[2 * this.position] & 0xFF;
            ++this.position;
            return n;
        }

        private byte[] getDecodedBuffer() {
            byte[] byArray = null;
            if (!SpeexData.this.decodedData.containsKey(this)) {
                byArray = new byte[2 * this.size];
                Arrays.fill(byArray, (byte)0);
                SpeexData.this.decodedData.clear();
                SpeexData.this.decodedData.put(this, byArray);
            } else {
                byArray = (byte[])SpeexData.this.decodedData.get(this);
            }
            return byArray;
        }

        public synchronized void write(int n) throws AudioDataException {
            byte[] byArray = this.getDecodedBuffer();
            if (byArray == null) {
                throw new AudioDataException("Invalid write request.");
            }
            byArray[2 * this.position] = (byte)(n & 0xFF);
            byArray[2 * this.position + 1] = (byte)(n >> 8 & 0xFF);
            ++this.position;
            if (this.position >= this.size) {
                this.encodeData();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void encodeData() throws AudioDataException {
            byte[] byArray = this.getDecodedBuffer();
            if (byArray == null) {
                throw new AudioDataException("Invalid encoding request.");
            }
            byte[] byArray2 = new byte[byArray.length];
            SpeexEncoder speexEncoder = SpeexData.this.encoder;
            synchronized (speexEncoder) {
                SpeexData.this.encoder.processData(byArray, 0, 2 * this.size);
                int n = SpeexData.this.encoder.getProcessedData(byArray2, 0);
                this.setEncodedData(byArray2, 0, n);
            }
        }

        public Object clone() {
            SpeexBlock speexBlock = new SpeexBlock(this.size);
            if (this.data != null) {
                speexBlock.setEncodedData(this.data, 0, this.data.length);
            }
            speexBlock.cacheOffset = this.cacheOffset;
            speexBlock.cacheLength = this.cacheLength;
            return speexBlock;
        }

        public synchronized void sendToOggWriter(OggSpeexWriter oggSpeexWriter) throws IOException, AudioDataException {
            if (this.data == null && this.cacheOffset < 0L) {
                this.encodeData();
            }
            if (this.data == null && this.cacheOffset < 0L) {
                throw new AudioDataException("Invalid send request.");
            }
            if (this.data == null) {
                byte[] byArray = new byte[this.cacheLength];
                SpeexData.this.cacheInputStream.read(byArray, this.cacheOffset);
                oggSpeexWriter.writePacket(byArray, 0, byArray.length);
            } else {
                oggSpeexWriter.writePacket(this.data, 0, this.data.length);
            }
        }
    }

    protected class OggHeader {
        public static final int NONE = 0;
        public static final int CONTINUE = 1;
        public static final int BOS = 2;
        public static final int EOS = 4;
        public int headerType = 0;
        public long granulePos;
        public int serial;
        public int sequence;
        public int checksum;
        public int segments;
        public byte[] segmentSize;

        protected OggHeader() {
        }
    }

    protected class SpeexTransferThread
    extends AudioData.TransferThread {
        private long lastUpdatedTime = 0L;

        protected SpeexTransferThread() {
        }

        public void run() {
            super.run();
            try {
                while (this.inProgress) {
                    OggHeader oggHeader = SpeexData.this.receiveOggHeaderFromStream(this.in);
                    if (oggHeader.headerType == 0 || oggHeader.headerType == 4) {
                        int n = 0;
                        for (int i = 0; i < oggHeader.segments; ++i) {
                            n += oggHeader.segmentSize[i];
                        }
                        byte[] byArray = new byte[n];
                        SpeexData.this.receiveByteArrayFromStream(this.in, byArray, 0, n);
                        int n2 = 0;
                        for (int i = 0; i < oggHeader.segments; ++i) {
                            SpeexBlock speexBlock = new SpeexBlock(SpeexData.this.samplesPerBlock);
                            if (this.out == null) {
                                speexBlock.setEncodedData(byArray, n2, oggHeader.segmentSize[i]);
                            } else {
                                this.out.write(byArray, n2, oggHeader.segmentSize[i]);
                                speexBlock.setCache(SpeexData.this.cacheSize, oggHeader.segmentSize[i]);
                                SpeexData.this.cacheSize += (long)oggHeader.segmentSize[i];
                            }
                            n2 += oggHeader.segmentSize[i];
                            SpeexData.this.blockData.add(speexBlock);
                            ++SpeexData.this.availableBlocks;
                            if (SpeexData.this.listener == null) continue;
                            long l = new Date().getTime();
                            if (this.lastUpdatedTime != 0L && this.lastUpdatedTime + 500L >= l) continue;
                            SpeexData.this.listener.received(SpeexData.this, SpeexData.this.getAvailable());
                            this.lastUpdatedTime = l;
                        }
                        if (oggHeader.headerType != 4) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (SpeexData.this.listener != null) {
                SpeexData.this.listener.finish(SpeexData.this, SpeexData.this.getAvailable());
            }
            SpeexData.this.transferThread = null;
        }
    }
}

