/*
 * Decompiled with CFR 0.152.
 */
package gong.audio.data;

import gong.audio.AudioData;
import gong.audio.AudioDataException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;

public abstract class BlockAudioData
extends AudioData {
    protected Vector blockData = new Vector();
    protected int samplesPerBlock;
    protected int availableBlocks;

    public BlockAudioData() {
    }

    public BlockAudioData(AudioFormat audioFormat) {
        super(audioFormat);
    }

    public synchronized int read() throws IOException, AudioDataException {
        if (this.blockData.size() == 0) {
            throw new AudioDataException("Data not available.");
        }
        int n = this.position / this.samplesPerBlock;
        if (n >= this.blockData.size()) {
            throw new AudioDataException("Buffer overflow.");
        }
        if (n >= this.availableBlocks) {
            throw new AudioDataException("Data not available.");
        }
        Block block = (Block)this.blockData.get(n);
        block.seek(this.position % this.samplesPerBlock);
        ++this.position;
        return block.read();
    }

    public synchronized int read(int[] nArray, int n, int n2) throws IOException, AudioDataException {
        if (this.blockData.size() == 0) {
            throw new AudioDataException("Data not available.");
        }
        int n3 = this.position / this.samplesPerBlock;
        if (n3 >= this.blockData.size()) {
            throw new AudioDataException("Buffer overflow.");
        }
        if (n3 >= this.availableBlocks) {
            throw new AudioDataException("Data not available.");
        }
        Block block = (Block)this.blockData.get(n3);
        block.seek(this.position % this.samplesPerBlock);
        int n4 = this.position;
        for (int i = n; i < n + n2; ++i) {
            try {
                nArray[i] = block.read();
                ++this.position;
                if (!block.eob()) continue;
                if (++n3 >= this.blockData.size()) {
                    throw new AudioDataException("Buffer overflow.");
                }
                if (n3 >= this.availableBlocks) {
                    throw new AudioDataException("Data not available.");
                }
                block = (Block)this.blockData.get(n3);
                block.seek(0);
                continue;
            }
            catch (Throwable throwable) {
                break;
            }
        }
        return this.position - n4;
    }

    protected abstract Block createBlock();

    public synchronized void write(int n) throws IOException, AudioDataException {
        Block block;
        int n2 = this.position / this.samplesPerBlock;
        if (n2 >= this.blockData.size()) {
            block = this.createBlock();
            this.blockData.add(block);
            this.availableBlocks = this.blockData.size();
            if (this.listener != null) {
                this.listener.received(this, this.getAvailable());
            }
        } else {
            block = (Block)this.blockData.get(n2);
        }
        block.write(n);
        ++this.position;
    }

    public synchronized int seek(int n) throws IOException, AudioDataException {
        int n2 = n / this.samplesPerBlock;
        if (n2 < 0 || n2 >= this.blockData.size()) {
            throw new AudioDataException("Invalid seek position.");
        }
        Block block = (Block)this.blockData.get(n2);
        block.seek(n % this.samplesPerBlock);
        this.position = n;
        return this.position;
    }

    public synchronized boolean isAvailable() {
        if (this.blockData.size() == 0) {
            return false;
        }
        int n = this.position / this.samplesPerBlock;
        if (n >= this.blockData.size()) {
            return false;
        }
        return n < this.availableBlocks;
    }

    public synchronized long getAvailable() {
        return (long)((double)(this.availableBlocks * this.samplesPerBlock) / (double)this.format.getSampleRate() * 1000.0);
    }

    public synchronized int getLength() {
        return this.blockData.size() * this.samplesPerBlock;
    }

    public synchronized int getBlockIndex(long l) {
        int n = (int)((double)l / 1000.0 * (double)this.format.getSampleRate());
        int n2 = n / this.samplesPerBlock;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.blockData.size()) {
            n2 = this.blockData.size();
        }
        return n2;
    }

    public synchronized long getBlockTime(int n) {
        int n2 = n * this.samplesPerBlock;
        return (long)((double)n2 / (double)this.format.getSampleRate() * 1000.0);
    }

    public synchronized int getBlockSize() {
        return this.blockData.size();
    }

    public synchronized BlockAudioData delete(int n, int n2) {
        Vector vector = this.blockData;
        this.blockData = new Vector();
        this.availableBlocks = 0;
        BlockAudioData blockAudioData = (BlockAudioData)this.clone();
        blockAudioData.blockData = new Vector(vector.subList(n, n2));
        blockAudioData.availableBlocks = n2 - n;
        vector.subList(n, n2).clear();
        this.blockData = vector;
        this.availableBlocks = this.blockData.size();
        return blockAudioData;
    }

    public synchronized void insert(BlockAudioData blockAudioData, int n) {
        if (!this.getClass().isInstance(blockAudioData)) {
            return;
        }
        BlockAudioData blockAudioData2 = (BlockAudioData)blockAudioData.clone();
        this.blockData.addAll(n, blockAudioData2.blockData);
        this.availableBlocks = this.blockData.size();
    }

    protected class Block
    implements Cloneable {
        protected byte[] data = null;
        protected int size = 0;
        protected int position = 0;

        public Block(int n) {
            this.size = n;
        }

        public synchronized byte[] getData() {
            return this.data;
        }

        public synchronized int getSize() {
            return this.size;
        }

        public synchronized int getPosition() {
            return this.position;
        }

        public int read() throws IOException, AudioDataException {
            return 0;
        }

        public void write(int n) throws IOException, AudioDataException {
        }

        public synchronized int seek(int n) throws IOException, AudioDataException {
            if (n < 0 || n >= this.size) {
                throw new AudioDataException("Invalid seek position.");
            }
            this.position = n;
            return this.position;
        }

        public synchronized void clear() {
            if (this.data != null) {
                Arrays.fill(this.data, (byte)0);
            }
            this.reset();
        }

        public synchronized void reset() {
            this.position = 0;
        }

        public synchronized boolean eob() {
            return this.position >= this.size;
        }

        public Object clone() {
            Block block = new Block(this.size);
            if (this.data != null) {
                block.data = new byte[this.data.length];
                System.arraycopy(this.data, 0, block.data, 0, this.data.length);
            }
            block.size = this.size;
            block.position = this.position;
            return block;
        }
    }
}

