/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JLabel;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class Tree
extends DescendantManager
implements Accessible {
    protected Tree(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected void setActiveDescendant(Accessible accessible) {
        Accessible accessible2 = this.activeDescendant;
        this.activeDescendant = accessible;
        this.firePropertyChange("AccessibleActiveDescendant", accessible2, accessible);
    }

    protected void setActiveDescendant(Object object) {
        TreeItem treeItem = null;
        try {
            XAccessible xAccessible;
            if (AnyConverter.isObject((Object)object) && (xAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object)) != null) {
                treeItem = new TreeItem(this, xAccessible);
            }
            this.setActiveDescendant(treeItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void add(XAccessible xAccessible) {
        if (xAccessible != null) {
            this.firePropertyChange("AccessibleChild", null, new TreeItem(this, xAccessible));
        }
    }

    protected void remove(XAccessible xAccessible) {
        if (xAccessible != null) {
            this.firePropertyChange("AccessibleChild", new TreeItem(this, xAccessible), null);
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTreeListener(this);
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleTree(this);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TreeItem
    extends Component
    implements Accessible {
        private /* synthetic */ Tree this$0;
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext;

        private /* synthetic */ void finit$() {
            this.accessibleContext = null;
        }

        static Tree access$0(TreeItem treeItem) {
            return treeItem.this$0;
        }

        public TreeItem(Tree tree, XAccessible xAccessible) {
            this.this$0 = tree;
            this.finit$();
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] objectArray) {
            try {
                ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessible"), (Object)objectArray[i]);
                    if (xAccessible == null) continue;
                    arrayList.add(new TreeItem(this.this$0, xAccessible));
                }
                arrayList.trimToSize();
                return arrayList.toArray();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                try {
                    AccessibleTreeItem accessibleTreeItem;
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null && (accessibleTreeItem = new AccessibleTreeItem(this, xAccessibleContext)) != null) {
                        accessibleTreeItem.setAccessibleParent(this.this$0);
                        this.accessibleContext = accessibleTreeItem;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.accessibleContext;
        }

        protected class AccessibleTreeItem
        extends AccessibleContext
        implements AccessibleSelection {
            private /* synthetic */ TreeItem this$1;
            XAccessibleContext unoAccessibleContext;
            XAccessibleSelection unoAccessibleSelection;

            public AccessibleTreeItem(TreeItem treeItem, XAccessibleContext xAccessibleContext) {
                this.this$1 = treeItem;
                this.unoAccessibleContext = xAccessibleContext;
                this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessibleSelection"), (Object)xAccessibleContext);
            }

            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleName(String string) {
            }

            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleDescription(String string) {
            }

            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole accessibleRole = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    if (accessibleRole != null) {
                        return accessibleRole;
                    }
                    return AccessibleRole.LABEL;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale locale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(locale.Language, locale.Country);
                }
                catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                    throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    return TreeItem.access$0(this.this$1).getLocale();
                }
            }

            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException runtimeException) {
                    return -1;
                }
            }

            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            public Accessible getAccessibleChild(int n) {
                Accessible accessible = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    Accessible accessible2 = TreeItem.access$0((TreeItem)this.this$1).activeDescendant;
                    if (accessible2 instanceof TreeItem && ((TreeItem)accessible2).unoAccessible.equals(xAccessible)) {
                        accessible = accessible2;
                    } else if (xAccessible != null) {
                        accessible = new TreeItem(TreeItem.access$0(this.this$1), xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return accessible;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    return AccessibleStateAdapter.getAccessibleStateSet(this.this$1, this.unoAccessibleContext.getAccessibleStateSet());
                }
                catch (RuntimeException runtimeException) {
                    return AccessibleStateAdapter.getDefunctStateSet();
                }
            }

            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessibleComponent"), (Object)this.unoAccessibleContext);
                    if (xAccessibleComponent != null) {
                        return new AccessibleComponentImpl(xAccessibleComponent);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleSelection getAccessibleSelection() {
                if (this.unoAccessibleSelection != null) {
                    return this;
                }
                return null;
            }

            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessibleAction"), (Object)this.unoAccessibleContext);
                    if (xAccessibleAction != null) {
                        return new AccessibleActionImpl(xAccessibleAction);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleText getAccessibleText() {
                if (TreeItem.access$0((TreeItem)this.this$1).disposed) {
                    return null;
                }
                try {
                    XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessibleText"), (Object)this.unoAccessibleContext);
                    if (xAccessibleText != null) {
                        return new AccessibleTextImpl(xAccessibleText);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessibleValue"), (Object)this.unoAccessibleContext);
                    if (xAccessibleValue != null) {
                        return new AccessibleValueImpl(xAccessibleValue);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage xAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessibleImage"), (Object)this.unoAccessibleContext);
                    if (xAccessibleImage != null) {
                        AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{new AccessibleIconImpl(xAccessibleImage)};
                        return accessibleIconArray;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }

            public Accessible getAccessibleSelection(int n) {
                TreeItem treeItem = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    if (xAccessible != null) {
                        treeItem = new TreeItem(TreeItem.access$0(this.this$1), xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return treeItem;
            }

            public void addAccessibleSelection(int n) {
                try {
                    this.unoAccessibleSelection.selectAccessibleChild(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            public void clearAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.clearAccessibleSelection();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            public int getAccessibleSelectionCount() {
                try {
                    return this.unoAccessibleSelection.getSelectedAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            public boolean isAccessibleChildSelected(int n) {
                try {
                    return this.unoAccessibleSelection.isAccessibleChildSelected(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return false;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }

            public void removeAccessibleSelection(int n) {
                try {
                    this.unoAccessibleSelection.deselectAccessibleChild(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            public void selectAllAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.selectAllAccessibleChildren();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    protected class AccessibleTree
    extends DescendantManager.AccessibleDescendantManager
    implements AccessibleExtendedTable {
        private /* synthetic */ Tree this$0;
        protected XAccessibleTable unoAccessibleTable;

        public AccessibleTree(Tree tree) {
            this.this$0 = tree;
            super(tree);
            this.unoAccessibleTable = (XAccessibleTable)UnoRuntime.queryInterface((Class)Tree.class$("com.sun.star.accessibility.XAccessibleTable"), (Object)tree.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public AccessibleTable getAccessibleTable() {
            return this;
        }

        public Accessible getAccessibleChild(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.this$0.unoAccessibleContext.getAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(this.this$0, xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.this$0.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y));
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(this.this$0, xAccessible);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleSelection(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.this$0.unoAccessibleContext.getAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(this.this$0, xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleAt(int n, int n2) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.unoAccessibleTable.getAccessibleCellAt(n, n2);
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible) ? accessible2 : new TreeItem(this.this$0, xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleCaption() {
            return null;
        }

        public int getAccessibleColumnCount() {
            try {
                return this.unoAccessibleTable.getAccessibleColumnCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public Accessible getAccessibleColumnDescription(int n) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleColumnDescription(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public int getAccessibleColumnExtentAt(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleColumnExtentAt(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0;
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public AccessibleTable getAccessibleColumnHeader() {
            return null;
        }

        public int getAccessibleRowCount() {
            try {
                return this.unoAccessibleTable.getAccessibleRowCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public Accessible getAccessibleRowDescription(int n) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleRowDescription(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public int getAccessibleRowExtentAt(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleRowExtentAt(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0;
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public Accessible getAccessibleSummary() {
            return null;
        }

        public int[] getSelectedAccessibleColumns() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleColumns();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public int[] getSelectedAccessibleRows() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleRows();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public boolean isAccessibleColumnSelected(int n) {
            try {
                return this.unoAccessibleTable.isAccessibleColumnSelected(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public boolean isAccessibleRowSelected(int n) {
            try {
                return this.unoAccessibleTable.isAccessibleRowSelected(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public boolean isAccessibleSelected(int n, int n2) {
            try {
                return this.unoAccessibleTable.isAccessibleSelected(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public void setAccessibleCaption(Accessible accessible) {
        }

        public void setAccessibleColumnDescription(int n, Accessible accessible) {
        }

        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        public void setAccessibleRowDescription(int n, Accessible accessible) {
        }

        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        public void setAccessibleSummary(Accessible accessible) {
        }

        public int getAccessibleColumn(int n) {
            try {
                return this.unoAccessibleTable.getAccessibleColumn(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        public int getAccessibleIndex(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleIndex(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        public int getAccessibleRow(int n) {
            try {
                return this.unoAccessibleTable.getAccessibleRow(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }
    }

    protected class AccessibleTreeListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        private /* synthetic */ Tree this$0;

        protected AccessibleTreeListener(Tree tree) {
            this.this$0 = tree;
            super(tree);
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 5: {
                    this.this$0.setActiveDescendant(accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        this.this$0.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    this.this$0.add(accessibleEventObject.NewValue);
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

