/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.util.image.ImageFilter;
import com.flagstone.transform.video.ImageBlock;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;

public final class ImageBlocker {
    private static final int RGB_CHANNELS = 3;

    public void getImageAsBlocks(List<ImageBlock> blocks, int blockWidth, int blockHeight, int imageWidth, int imageHeight, byte[] image) {
        ImageFilter filter = new ImageFilter();
        byte[] img = filter.removeAlpha(image);
        img = filter.invertRGB(img, imageWidth, imageHeight);
        filter.reverseRGB(img);
        int columns = (imageWidth + blockWidth - 1) / blockWidth;
        int rows = (imageHeight + blockHeight - 1) / blockHeight;
        byte[] blockData = new byte[blockHeight * blockWidth * 3];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                int xOffset = j * blockWidth;
                int yOffset = i * blockHeight;
                int xSpan = imageWidth - xOffset > blockWidth ? blockWidth : imageWidth - xOffset;
                int ySpan = imageHeight - yOffset > blockHeight ? blockHeight : imageHeight - yOffset;
                int offset = 0;
                for (int k = 0; k < ySpan; ++k) {
                    int l = 0;
                    while (l < xSpan) {
                        int idx = (yOffset + k) * (imageWidth * 3) + (xOffset + l) * 3;
                        blockData[offset] = img[idx];
                        blockData[offset + 1] = img[idx + 1];
                        blockData[offset + 2] = img[idx + 2];
                        ++l;
                        offset += 3;
                    }
                }
                blocks.add(new ImageBlock(xSpan, ySpan, this.zip(blockData, offset)));
            }
        }
    }

    private byte[] zip(byte[] image, int length) {
        Deflater deflater = new Deflater();
        deflater.setInput(image, 0, length);
        deflater.finish();
        byte[] compressedData = new byte[image.length];
        int bytesCompressed = deflater.deflate(compressedData);
        byte[] newData = Arrays.copyOf(compressedData, bytesCompressed);
        return newData;
    }
}

