/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.text;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.text.GlyphIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class TextSpan
implements SWFEncodeable,
Copyable<TextSpan> {
    private static final String FORMAT = "TextSpan: { identifier=%d; color=%s; offsetX=%d; offsetY=%d; height=%d; characters=%s}";
    private Color color;
    private Integer offsetX;
    private Integer offsetY;
    private Integer identifier;
    private Integer height;
    private List<GlyphIndex> characters;
    private transient boolean hasStyle;
    private transient boolean hasFont;
    private transient boolean hasColor;
    private transient boolean hasX;
    private transient boolean hasY;

    public TextSpan(SWFDecoder coder, Context context) throws IOException {
        int bits = coder.readByte();
        this.hasFont = (bits & 8) != 0;
        this.hasColor = (bits & 4) != 0;
        this.hasY = (bits & 2) != 0;
        boolean bl = this.hasX = (bits & 1) != 0;
        if (this.hasFont) {
            this.identifier = coder.readUnsignedShort();
        }
        if (this.hasColor) {
            this.color = new Color(coder, context);
        }
        if (this.hasX) {
            this.offsetX = coder.readSignedShort();
        }
        if (this.hasY) {
            this.offsetY = coder.readSignedShort();
        }
        if (this.hasFont) {
            this.height = coder.readSignedShort();
        }
        int charCount = coder.readByte();
        this.characters = new ArrayList<GlyphIndex>(charCount);
        for (int i = 0; i < charCount; ++i) {
            this.characters.add(new GlyphIndex(coder, context));
        }
        coder.alignToByte();
    }

    public TextSpan(Integer uid, Integer aHeight, Color aColor, Integer xOffset, Integer yOffset, List<GlyphIndex> list) {
        this.setIdentifier(uid);
        this.setHeight(aHeight);
        this.setColor(aColor);
        this.setOffsetX(xOffset);
        this.setOffsetY(yOffset);
        this.setCharacters(list);
    }

    public TextSpan(TextSpan object) {
        this.identifier = object.identifier;
        this.color = object.color;
        this.offsetX = object.offsetX;
        this.offsetY = object.offsetY;
        this.height = object.height;
        this.characters = new ArrayList<GlyphIndex>(object.characters);
    }

    public Integer getIdentifier() {
        return this.identifier;
    }

    public Color getColor() {
        return this.color;
    }

    public Integer getOffsetX() {
        return this.offsetX;
    }

    public Integer getOffsetY() {
        return this.offsetY;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setIdentifier(Integer uid) {
        if (uid != null && (uid < 1 || uid > 65535)) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public void setColor(Color aColor) {
        this.color = aColor;
    }

    public void setOffsetX(Integer offset) {
        if (offset != null && (offset < Short.MIN_VALUE || offset > Short.MAX_VALUE)) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, offset);
        }
        this.offsetX = offset;
    }

    public void setOffsetY(Integer offset) {
        if (offset != null && (offset < Short.MIN_VALUE || offset > Short.MAX_VALUE)) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, offset);
        }
        this.offsetY = offset;
    }

    public void setHeight(Integer aHeight) {
        if (aHeight < 0 || aHeight > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aHeight);
        }
        this.height = aHeight;
    }

    public TextSpan add(GlyphIndex aCharacter) {
        this.characters.add(aCharacter);
        return this;
    }

    public List<GlyphIndex> getCharacters() {
        return this.characters;
    }

    public void setCharacters(List<GlyphIndex> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.characters = list;
    }

    @Override
    public TextSpan copy() {
        return new TextSpan(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.color, this.offsetX, this.offsetY, this.height, this.characters);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.hasFont = this.identifier != null && this.height != null;
        this.hasColor = this.color != null;
        this.hasX = this.offsetX != null;
        this.hasY = this.offsetY != null;
        this.hasStyle = this.hasFont || this.hasColor || this.hasX || this.hasY;
        int length = 1;
        if (this.hasStyle) {
            length += this.hasFont ? 2 : 0;
            length += this.hasColor ? (context.contains(3) ? 4 : 3) : 0;
            length += this.hasY ? 2 : 0;
            length += this.hasX ? 2 : 0;
            length += this.hasFont ? 2 : 0;
        }
        ++length;
        if (!this.characters.isEmpty()) {
            int advanceSize;
            int numberOfBits;
            int glyphSize = context.get(14);
            length += (numberOfBits += (numberOfBits = (glyphSize + (advanceSize = context.get(13).intValue())) * this.characters.size()) % 8 > 0 ? 8 - numberOfBits % 8 : 0) >> 3;
        }
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        int bits = 128;
        bits |= this.hasFont ? 8 : 0;
        bits |= this.hasColor ? 4 : 0;
        bits |= this.hasY ? 2 : 0;
        coder.writeByte(bits |= this.hasX ? 1 : 0);
        if (this.hasStyle) {
            if (this.hasFont) {
                coder.writeShort(this.identifier);
            }
            if (this.hasColor) {
                this.color.encode(coder, context);
            }
            if (this.hasX) {
                coder.writeShort(this.offsetX);
            }
            if (this.hasY) {
                coder.writeShort(this.offsetY);
            }
            if (this.hasFont) {
                coder.writeShort(this.height);
            }
        }
        coder.writeByte(this.characters.size());
        for (GlyphIndex index : this.characters) {
            index.encode(coder, context);
        }
        coder.alignToByte();
    }

    protected int glyphBits() {
        int numberOfBits = 0;
        for (GlyphIndex index : this.characters) {
            numberOfBits = Math.max(numberOfBits, Coder.unsignedSize(index.getGlyphIndex()));
        }
        return numberOfBits;
    }

    protected int advanceBits() {
        int numberOfBits = 0;
        for (GlyphIndex index : this.characters) {
            numberOfBits = Math.max(numberOfBits, Coder.size(index.getAdvance()));
        }
        return numberOfBits;
    }
}

