/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.fillstyle.Gradient;
import com.flagstone.transform.fillstyle.Interpolation;
import com.flagstone.transform.fillstyle.Spread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FocalGradientFill
implements FillStyle {
    private static final int SPREAD_MASK = 192;
    private static final int INTER_MASK = 48;
    private static final int GRADIENT_MASK = 15;
    private static final String FORMAT = "FocalGradientFill: { spread=%s; interpolation=%s; focalPoint=%f; transform=%s; gradients=%s}";
    private int spread;
    private int interpolation;
    private int focalPoint;
    private CoordTransform transform;
    private List<Gradient> gradients;
    private transient int count;

    public FocalGradientFill(SWFDecoder coder, Context context) throws IOException {
        this.transform = new CoordTransform(coder);
        this.count = coder.readByte();
        this.spread = this.count & 0xC0;
        this.interpolation = this.count & 0x30;
        this.count &= 0xF;
        this.gradients = new ArrayList<Gradient>(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.gradients.add(new Gradient(coder, context));
        }
        this.focalPoint = coder.readSignedShort();
    }

    public FocalGradientFill(CoordTransform matrix, Spread spreadType, Interpolation interpolationType, float point, List<Gradient> list) {
        this.setTransform(matrix);
        this.setSpread(spreadType);
        this.setInterpolation(interpolationType);
        this.setFocalPoint(point);
        this.setGradients(list);
    }

    public FocalGradientFill(FocalGradientFill object) {
        this.spread = object.spread;
        this.interpolation = object.interpolation;
        this.focalPoint = object.focalPoint;
        this.transform = object.transform;
        this.gradients = new ArrayList<Gradient>(object.gradients);
    }

    public Spread getSpread() {
        return Spread.fromInt(this.spread);
    }

    public void setSpread(Spread spreadType) {
        this.spread = spreadType.getValue();
    }

    public Interpolation getInterpolation() {
        return Interpolation.fromInt(this.interpolation);
    }

    public void setInterpolation(Interpolation interpolationType) {
        this.interpolation = interpolationType.getValue();
    }

    public float getFocalPoint() {
        return (float)this.focalPoint / 256.0f;
    }

    public void setFocalPoint(float point) {
        this.focalPoint = (int)(point * 256.0f);
    }

    public FocalGradientFill add(Gradient gradient) {
        if (gradient == null) {
            throw new IllegalArgumentException();
        }
        if (this.gradients.size() == 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients.add(gradient);
        return this;
    }

    public List<Gradient> getGradients() {
        return this.gradients;
    }

    public void setGradients(List<Gradient> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (this.gradients.size() > 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients = list;
    }

    public CoordTransform getTransform() {
        return this.transform;
    }

    public void setTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.transform = matrix;
    }

    @Override
    public FocalGradientFill copy() {
        return new FocalGradientFill(this);
    }

    public String toString() {
        return String.format(FORMAT, new Object[]{this.getSpread(), this.getInterpolation(), Float.valueOf(this.getFocalPoint()), this.transform.toString(), this.gradients.toString()});
    }

    @Override
    public int prepareToEncode(Context context) {
        this.count = this.gradients.size();
        int length = 4 + this.transform.prepareToEncode(context);
        for (Gradient gradient : this.gradients) {
            length += gradient.prepareToEncode(context);
        }
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(19);
        this.transform.encode(coder, context);
        coder.writeByte(this.count | this.spread | this.interpolation);
        for (Gradient gradient : this.gradients) {
            gradient.encode(coder, context);
        }
        coder.writeShort(this.focalPoint);
    }
}

