/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.coder;

import java.io.IOException;

public final class CoderException
extends IOException {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "CoderException: { location=%s; length=%d; delta=%d; message=%s}";
    private final transient int start;
    private final transient int length;
    private final transient int delta;

    public CoderException(int location, String message) {
        super(message);
        this.start = location;
        this.length = 0;
        this.delta = 0;
    }

    public CoderException(int location, int size, int difference) {
        this.start = location;
        this.length = size;
        this.delta = difference;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public int getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        return String.format(FORMAT, Integer.toHexString(this.start), this.length, this.delta, this.getMessage());
    }
}

