/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.button;

import java.util.LinkedHashMap;
import java.util.Map;

public enum ButtonKey {
    LEFT(1),
    RIGHT(2),
    HOME(3),
    END(4),
    INSERT(5),
    DELETE(6),
    BACKSPACE(8),
    ENTER(13),
    UP(14),
    DOWN(15),
    PAGE_UP(16),
    PAGE_DOWN(17),
    TAB(18),
    ESCAPE(19);

    private static final Map<Integer, ButtonKey> TABLE;
    private final int value;

    public static ButtonKey fromInt(int keyCode) {
        return TABLE.get(keyCode);
    }

    private ButtonKey(int keyCode) {
        this.value = keyCode;
    }

    public int getValue() {
        return this.value;
    }

    static {
        TABLE = new LinkedHashMap<Integer, ButtonKey>();
        for (ButtonKey type : ButtonKey.values()) {
            TABLE.put(type.value, type);
        }
    }
}

