/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Table
implements Action {
    private static final String FORMAT = "Table: { values=%s}";
    private List<String> values;
    private transient int length;
    private transient int tableSize;

    public Table(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort();
        this.tableSize = coder.readUnsignedShort();
        this.values = new ArrayList<String>(this.tableSize);
        if (this.tableSize > 0) {
            for (int i = 0; i < this.tableSize; ++i) {
                this.values.add(coder.readString());
            }
        } else {
            this.length = 2;
        }
    }

    public Table() {
        this.values = new ArrayList<String>();
    }

    public Table(List<String> list) {
        this.values = new ArrayList<String>();
        this.setValues(list);
    }

    public Table(Table object) {
        this.values = new ArrayList<String>(object.values);
    }

    public Table add(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.values.add(aString);
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.values = list;
    }

    @Override
    public Table copy() {
        return new Table(this);
    }

    public String toString() {
        return String.format(FORMAT, this.values);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2;
        for (String str : this.values) {
            this.length += context.strlen(str);
        }
        this.tableSize = this.values.size();
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(136);
        coder.writeShort(this.length);
        coder.writeShort(this.values.size());
        for (String str : this.values) {
            coder.writeString(str);
        }
    }
}

