/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class Free
implements MovieTag {
    private static final String FORMAT = "Free: { identifier=%d}";
    private int identifier;

    public Free(SWFDecoder coder) throws IOException {
        if ((coder.readUnsignedShort() & 0x3F) == 63) {
            coder.readInt();
        }
        this.identifier = coder.readUnsignedShort();
    }

    public Free(int uid) {
        this.setIdentifier(uid);
    }

    public Free(Free object) {
        this.identifier = object.identifier;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public Free copy() {
        return new Free(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 4;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(194);
        coder.writeShort(this.identifier);
    }
}

