/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.Adler32;
import javax.imageio.ImageIO;

public class MappedImage {
    private Reference<BufferedImage> imageRef;
    private Reference<byte[]> imageBytesRef;
    private MappedByteBuffer buffer;
    private int height;
    private int width;
    private String format;
    private long checksum;
    private int bytesLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedImage(final BufferedImage image, String format, FileChannel channel) throws IOException {
        if (format == null) {
            throw new NullPointerException("Format is null");
        }
        class HardReference
        extends SoftReference<BufferedImage> {
            HardReference(BufferedImage referent) {
                super(referent);
            }

            @Override
            public BufferedImage get() {
                return image;
            }
        }
        this.imageRef = channel == null ? new HardReference(image) : new SoftReference<BufferedImage>(image);
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.format = format;
        if (channel != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.imageRef.get(), format, baos);
            baos.close();
            byte[] imageBytes = baos.toByteArray();
            Adler32 adler = new Adler32();
            adler.update(imageBytes);
            this.checksum = adler.getValue();
            this.bytesLength = imageBytes.length;
            this.imageBytesRef = new SoftReference<byte[]>(imageBytes);
            FileChannel fileChannel = channel;
            synchronized (fileChannel) {
                long position = channel.position();
                channel.write(ByteBuffer.wrap(imageBytes));
                this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, position, imageBytes.length);
            }
        }
    }

    public byte[] getImageBytes() throws IOException {
        if (this.imageBytesRef == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.imageRef.get(), this.format, baos);
            return baos.toByteArray();
        }
        byte[] ret = this.imageBytesRef.get();
        if (ret == null) {
            this.buffer.load();
            this.buffer.rewind();
            ret = new byte[this.buffer.remaining()];
            this.buffer.get(ret);
            if (this.bytesLength != ret.length) {
                throw new IllegalStateException("Invalid image bytes length, expected " + this.bytesLength + ", got " + ret.length);
            }
            Adler32 adler = new Adler32();
            adler.update(ret);
            if (this.checksum != adler.getValue()) {
                throw new IllegalStateException("Invalid image bytes checksum");
            }
            this.imageBytesRef = new SoftReference<byte[]>(ret);
        }
        return ret;
    }

    public BufferedImage getImage() throws IOException {
        BufferedImage ret = this.imageRef.get();
        if (ret == null) {
            ret = ImageIO.read(new ByteArrayInputStream(this.getImageBytes()));
            this.imageRef = new SoftReference<BufferedImage>(ret);
        }
        return ret;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

