/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class WaitForFrame2
implements Action {
    private static final String FORMAT = "WaitForFrame2: { actionCount=%d}";
    private static final int MAX_COUNT = 255;
    private final transient int actionCount;

    public WaitForFrame2(SWFDecoder coder) throws IOException {
        coder.readUnsignedShort();
        this.actionCount = coder.readByte();
    }

    public WaitForFrame2(int count) {
        if (count < 0 || count > 255) {
            throw new IllegalArgumentRangeException(0, 255, count);
        }
        this.actionCount = count;
    }

    public WaitForFrame2(WaitForFrame2 object) {
        this.actionCount = object.actionCount;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    @Override
    public WaitForFrame2 copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.actionCount);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 4;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(141);
        coder.writeShort(1);
        coder.writeByte(this.actionCount);
    }
}

