/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.video;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.video.Deblocking;
import com.flagstone.transform.video.VideoFormat;
import java.io.IOException;

public final class DefineVideo
implements DefineTag {
    private static final String FORMAT = "DefineVideo: { identifier=%d; frameCount=%d; width=%d; height=%d; deblocking=%s; smoothing=%s; codec=%s}";
    private int identifier;
    private int frameCount;
    private int width;
    private int height;
    private int deblocking;
    private boolean smoothed;
    private int codec;
    private transient int length;

    public DefineVideo(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.frameCount = coder.readUnsignedShort();
        this.width = coder.readUnsignedShort();
        this.height = coder.readUnsignedShort();
        int info = coder.readByte();
        this.deblocking = (info & 6) >> 1;
        this.smoothed = (info & 1) == 1;
        this.codec = coder.readByte();
        coder.check(this.length);
        coder.unmark();
    }

    public DefineVideo(int uid, int count, int frameWidth, int frameHeight, Deblocking deblock, boolean smoothing, VideoFormat videoCodec) {
        this.setIdentifier(uid);
        this.setFrameCount(count);
        this.setWidth(frameWidth);
        this.setHeight(frameHeight);
        this.setDeblocking(deblock);
        this.setSmoothed(smoothing);
        this.setCodec(videoCodec);
    }

    public DefineVideo(DefineVideo object) {
        this.identifier = object.identifier;
        this.frameCount = object.frameCount;
        this.width = object.width;
        this.height = object.height;
        this.deblocking = object.deblocking;
        this.smoothed = object.smoothed;
        this.codec = object.codec;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int count) {
        if (count < 0 || count > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, count);
        }
        this.frameCount = count;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int size) {
        if (size < 0 || size > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, size);
        }
        this.width = size;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int size) {
        if (size < 0 || size > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, size);
        }
        this.height = size;
    }

    public Deblocking getDeblocking() {
        Deblocking value;
        switch (this.deblocking) {
            case 1: {
                value = Deblocking.OFF;
                break;
            }
            case 2: {
                value = Deblocking.ON;
                break;
            }
            case 3: {
                value = Deblocking.LEVEL2;
                break;
            }
            case 4: {
                value = Deblocking.LEVEL3;
                break;
            }
            case 5: {
                value = Deblocking.LEVEL4;
                break;
            }
            default: {
                value = Deblocking.VIDEO;
            }
        }
        return value;
    }

    public void setDeblocking(Deblocking value) {
        switch (value) {
            case VIDEO: {
                this.deblocking = 0;
                break;
            }
            case OFF: {
                this.deblocking = 1;
                break;
            }
            case ON: {
                this.deblocking = 2;
                break;
            }
            case LEVEL2: {
                this.deblocking = 3;
                break;
            }
            case LEVEL3: {
                this.deblocking = 4;
                break;
            }
            case LEVEL4: {
                this.deblocking = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isSmoothed() {
        return this.smoothed;
    }

    public void setSmoothed(boolean smoothing) {
        this.smoothed = smoothing;
    }

    public VideoFormat getCodec() {
        VideoFormat value;
        switch (this.codec) {
            case 5: {
                value = VideoFormat.VP6ALPHA;
                break;
            }
            case 4: {
                value = VideoFormat.VP6;
                break;
            }
            case 2: {
                value = VideoFormat.H263;
                break;
            }
            case 3: {
                value = VideoFormat.SCREEN;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return value;
    }

    public void setCodec(VideoFormat format) {
        switch (format) {
            case H263: {
                this.codec = 2;
                break;
            }
            case SCREEN: {
                this.codec = 3;
                break;
            }
            case VP6: {
                this.codec = 4;
                break;
            }
            case VP6ALPHA: {
                this.codec = 5;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public DefineVideo copy() {
        return new DefineVideo(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.frameCount, this.width, this.height, this.deblocking, this.smoothed, this.codec);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 10;
        return 2 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(3903);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xF00 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeShort(this.frameCount);
        coder.writeShort(this.width);
        coder.writeShort(this.height);
        int bits = this.deblocking << 1;
        coder.writeByte(bits |= this.smoothed ? 1 : 0);
        coder.writeByte(this.codec);
        coder.check(this.length);
        coder.unmark();
    }
}

