/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.text;

import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.font.DefineFont2;
import com.flagstone.transform.text.DefineText2;
import com.flagstone.transform.text.GlyphIndex;
import com.flagstone.transform.text.TextSpan;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TextTable {
    private static final float EMSQUARE = 1024.0f;
    private final transient int size;
    private final transient int ascent;
    private final transient int descent;
    private final transient int identifier;
    private final transient Map<Character, GlyphIndex> characters;

    public TextTable(DefineFont2 font, int fontSize) {
        this.identifier = font.getIdentifier();
        this.size = fontSize;
        this.characters = new LinkedHashMap<Character, GlyphIndex>();
        List<Integer> codes = font.getCodes();
        List<Integer> advances = font.getAdvances();
        float scale = (float)fontSize / 1024.0f;
        int count = codes.size();
        this.ascent = (int)((float)font.getAscent() * scale);
        this.descent = (int)((float)font.getDescent() * scale);
        for (int i = 0; i < count; ++i) {
            this.characters.put(Character.valueOf((char)codes.get(i).intValue()), new GlyphIndex(i, (int)((float)advances.get(i).intValue() * scale)));
        }
    }

    public Bounds boundsForText(String text) {
        int total = 0;
        for (int i = 0; i < text.length(); ++i) {
            total += this.characters.get(Character.valueOf(text.charAt(i))).getAdvance();
        }
        return new Bounds(0, -this.ascent, total, this.descent);
    }

    public List<GlyphIndex> charactersForText(String text) {
        ArrayList<GlyphIndex> list = new ArrayList<GlyphIndex>(text.length());
        for (int i = 0; i < text.length(); ++i) {
            list.add(this.characters.get(Character.valueOf(text.charAt(i))));
        }
        return list;
    }

    public TextSpan defineSpan(String text, Color color, int xCoord, int yCoord) {
        return new TextSpan(this.identifier, this.size, color, xCoord, yCoord, this.charactersForText(text));
    }

    public DefineText2 defineText(int uid, String text, Color color) {
        CoordTransform transform = CoordTransform.translate(0, 0);
        ArrayList<TextSpan> spans = new ArrayList<TextSpan>();
        spans.add(this.defineSpan(text, color, 0, 0));
        return new DefineText2(uid, this.boundsForText(text), transform, spans);
    }

    public DefineText2 defineTextBlock(int uid, List<String> lines, Color color, int lineSpacing) {
        CoordTransform transform = CoordTransform.translate(0, 0);
        int xMin = 0;
        int yMin = 0;
        int xMax = 0;
        int yMax = 0;
        int yOffset = this.ascent;
        ArrayList<TextSpan> spans = new ArrayList<TextSpan>();
        int lineNumber = 0;
        for (String text : lines) {
            spans.add(new TextSpan(this.identifier, this.size, color, 0, yOffset, this.charactersForText(text)));
            Bounds bounds = this.boundsForText(text);
            if (lineNumber == 0) {
                yMin = bounds.getMinY();
                yMax = bounds.getMaxY();
            } else {
                yMax += lineSpacing;
            }
            if (lineNumber == lines.size() - 1) {
                yMax += bounds.getHeight();
            }
            xMin = xMin < bounds.getMinX() ? xMin : bounds.getMinX();
            xMax = xMax > bounds.getMaxX() ? xMax : bounds.getMaxX();
            yOffset += lineSpacing;
            ++lineNumber;
        }
        return new DefineText2(uid, new Bounds(xMin, yMin, xMax, yMax), transform, spans);
    }
}

