/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.movieclip;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class QuicktimeMovie
implements MovieTag {
    private static final String FORMAT = "QuicktimeMovie: { name=%s}";
    private String path;
    private transient int length;

    public QuicktimeMovie(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.path = coder.readString(this.length);
        coder.check(this.length);
        coder.unmark();
    }

    public QuicktimeMovie(String aString) {
        this.setPath(aString);
    }

    public QuicktimeMovie(QuicktimeMovie object) {
        this.path = object.path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.path = aString;
    }

    @Override
    public QuicktimeMovie copy() {
        return new QuicktimeMovie(this);
    }

    public String toString() {
        return String.format(FORMAT, this.path);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = context.strlen(this.path);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2495);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x980 | this.length);
        }
        coder.mark();
        coder.writeString(this.path);
        coder.check(this.length);
        coder.unmark();
    }
}

