/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.coder;

import com.flagstone.transform.CharacterEncoding;
import com.flagstone.transform.coder.CoderException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public final class SWFEncoder {
    public static final int BUFFER_SIZE = 4096;
    private static final int BYTE_MASK = 255;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_BYTE = 8;
    private static final int ROUND_TO_BYTES = 7;
    private static final int BITS_TO_BYTES = 3;
    private static final int BYTES_TO_BITS = 3;
    private static final int TO_BYTE1 = 8;
    private static final int TO_BYTE2 = 16;
    private static final int TO_BYTE3 = 24;
    private final transient OutputStream stream;
    private final transient byte[] buffer;
    private transient int index;
    private transient int offset;
    private transient String encoding;
    private final transient Stack<Integer> locations;
    private transient int pos;
    private static final int HALF_EXP_SHIFT = 10;
    private static final int HALF_EXP_OFFSET = 15;
    private static final int HALF_EXP_MAX = 31;
    private static final int HALF_INF = 31744;
    private static final int EXP_SHIFT = 23;
    private static final int EXP_MAX = 127;
    private static final int MANT_SHIFT = 13;
    private static final int LOWEST23 = 0x7FFFFF;
    private static final int BIT23 = 0x800000;

    public SWFEncoder(OutputStream streamOut, int length) {
        this.stream = streamOut;
        this.buffer = new byte[length];
        this.encoding = CharacterEncoding.UTF8.getEncoding();
        this.locations = new Stack();
    }

    public SWFEncoder(OutputStream streamOut) {
        this.stream = streamOut;
        this.buffer = new byte[4096];
        this.encoding = CharacterEncoding.UTF8.getEncoding();
        this.locations = new Stack();
    }

    public void setEncoding(CharacterEncoding enc) {
        this.encoding = enc.getEncoding();
    }

    public int mark() {
        return this.locations.push(this.pos + this.index);
    }

    public void unmark() {
        this.locations.pop();
    }

    public void check(int expected) throws CoderException {
        int actual = this.pos + this.index - this.locations.peek();
        if (actual != expected) {
            throw new CoderException(this.locations.peek(), expected, actual - expected);
        }
    }

    public void alignToByte() {
        if (this.offset > 0) {
            ++this.index;
            this.offset = 0;
        }
    }

    public void flush() throws IOException {
        int diff;
        this.stream.write(this.buffer, 0, this.index);
        this.stream.flush();
        if (this.offset == 0) {
            diff = 0;
        } else {
            diff = 1;
            this.buffer[0] = this.buffer[this.index];
        }
        for (int i = diff; i < this.buffer.length; ++i) {
            this.buffer[i] = 0;
        }
        this.pos += this.index;
        this.index = 0;
    }

    public void writeBits(int value, int numberOfBits) throws IOException {
        int ptr = (this.index << 3) + this.offset + numberOfBits;
        if (ptr >= this.buffer.length << 3) {
            this.flush();
        }
        int val = value << 32 - numberOfBits >>> this.offset | this.buffer[this.index] << 24;
        int base = 32 - (this.offset + numberOfBits + 7 >>> 3 << 3);
        base = base < 0 ? 0 : base;
        int pointer = (this.index << 3) + this.offset;
        for (int i = 24; i >= base; i -= 8) {
            this.buffer[this.index++] = (byte)(val >>> i);
        }
        if (this.offset + numberOfBits > 32) {
            this.buffer[this.index] = (byte)(value << 8 - (this.offset + numberOfBits - 32));
        }
        this.index = (pointer += numberOfBits) >>> 3;
        this.offset = pointer & 7;
    }

    public void writeByte(int value) throws IOException {
        if (this.index == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.index++] = (byte)value;
    }

    public int writeBytes(byte[] bytes) throws IOException {
        if (this.index + bytes.length < this.buffer.length) {
            System.arraycopy(bytes, 0, this.buffer, this.index, bytes.length);
            this.index += bytes.length;
        } else {
            this.flush();
            this.stream.write(bytes, 0, bytes.length);
            this.pos += bytes.length;
        }
        return bytes.length;
    }

    public void writeString(String str) throws IOException {
        try {
            this.writeBytes(str.getBytes(this.encoding));
            this.buffer[this.index++] = 0;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void writeShort(int value) throws IOException {
        if (this.index + 2 > this.buffer.length) {
            this.flush();
        }
        this.buffer[this.index++] = (byte)value;
        this.buffer[this.index++] = (byte)(value >>> 8);
    }

    public void writeInt(int value) throws IOException {
        if (this.index + 4 > this.buffer.length) {
            this.flush();
        }
        this.buffer[this.index++] = (byte)value;
        this.buffer[this.index++] = (byte)(value >>> 8);
        this.buffer[this.index++] = (byte)(value >>> 16);
        this.buffer[this.index++] = (byte)(value >>> 24);
    }

    public void writeVarInt(int value) throws IOException {
        int val;
        if (this.index + 5 > this.buffer.length) {
            this.flush();
        }
        for (val = value; val > 127; val >>>= 7) {
            this.buffer[this.index++] = (byte)(val & 0x7F | 0x80);
        }
        this.buffer[this.index++] = (byte)(val & 0x7F);
    }

    public void writeHalf(float value) throws IOException {
        int intValue = Float.floatToIntBits(value);
        int sign = intValue >> 16 & 0x8000;
        int exponent = (intValue >> 23 & 0xFF) - 112;
        int mantissa = intValue & 0x7FFFFF;
        if (exponent <= 0) {
            if (exponent < -10) {
                this.writeShort(0);
            } else {
                mantissa = (mantissa | 0x800000) >> 1 - exponent;
                this.writeShort(sign | mantissa >> 13);
            }
        } else if (exponent == 143) {
            if (mantissa == 0) {
                this.writeShort(sign | 0x7C00);
            } else {
                this.writeShort(sign | 0x7C00 | mantissa | ((mantissa >>= 13) == 0 ? 1 : 0));
            }
        } else if (exponent >= 31) {
            this.writeShort(sign | 0x7C00);
        } else {
            this.writeShort(sign | exponent << 10 | mantissa >> 13);
        }
    }
}

