/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.button;

import com.flagstone.transform.Event;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.sound.SoundInfo;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ButtonSound
implements MovieTag {
    private static final String FORMAT = "ButtonSound: { identifier=%d; table=%s}";
    private static final EnumSet<Event> EVENTS = EnumSet.of(Event.ROLL_OUT, Event.ROLL_OVER, Event.PRESS, Event.RELEASE);
    private int identifier;
    private final transient Map<Event, SoundInfo> table;
    private transient int length;

    public ButtonSound(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.table = new LinkedHashMap<Event, SoundInfo>();
        this.decodeInfo(Event.ROLL_OUT, coder);
        this.decodeInfo(Event.ROLL_OVER, coder);
        this.decodeInfo(Event.PRESS, coder);
        this.decodeInfo(Event.RELEASE, coder);
        coder.check(this.length);
        coder.unmark();
    }

    private void decodeInfo(Event event, SWFDecoder coder) throws IOException {
        int uid;
        if (coder.bytesRead() < this.length && (uid = coder.readUnsignedShort()) != 0) {
            this.table.put(event, new SoundInfo(uid, coder));
        }
    }

    public ButtonSound(int uid, Event eventCode, SoundInfo aSound) {
        this.table = new LinkedHashMap<Event, SoundInfo>();
        this.setIdentifier(uid);
        this.setSoundInfo(eventCode, aSound);
    }

    public ButtonSound(ButtonSound object) {
        this.identifier = object.identifier;
        this.table = new LinkedHashMap<Event, SoundInfo>();
        for (Event event : object.table.keySet()) {
            this.table.put(event, object.table.get((Object)event).copy());
        }
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public SoundInfo getSoundInfo(Event event) {
        return this.table.get((Object)event);
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public void setSoundInfo(Event event, SoundInfo info) {
        this.table.put(event, info);
    }

    @Override
    public ButtonSound copy() {
        return new ButtonSound(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.table.toString());
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2;
        for (Event event : EVENTS) {
            if (this.table.containsKey((Object)event)) {
                this.length += this.table.get((Object)event).prepareToEncode(context);
                continue;
            }
            this.length += 2;
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1151);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x440 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        for (Event event : EVENTS) {
            if (this.table.containsKey((Object)event)) {
                this.table.get((Object)event).encode(coder, context);
                continue;
            }
            coder.writeShort(0);
        }
        coder.check(this.length);
        coder.unmark();
    }
}

