 {% if pageCount > 1 %}
    <ul class="pagination">
        {% if first is defined and current != first %}
            <li class="first">
                <a href="{{ current_url }}&{{ pageParameterName ~ '=' ~first }}">&lt;&lt;
                </a>
            </li>
        {% endif %}

        {% if previous is defined %}
            <li class="previous">
                <a class="hidden-xs" href="{{ current_url }}&{{ pageParameterName ~ '=' ~previous }}">
                    &lt;
                </a>
            </li>
        {% endif %}

        {% for page in pagesInRange %}
            {% if page != current %}
                <li class="page">
                    <a href="{{ current_url }}&{{ pageParameterName ~ '=' ~page }}">{{ page }}</a>
                </li>
            {% else %}
                <li class="current active">
                    <a>{{ page }} <span class="sr-only">(current)</span>
                    </a>
                </li>
            {% endif %}
        {% endfor %}

        {% if next is defined %}
            <li class="next">
                <a class="hidden-xs" href="{{ current_url }}&{{ pageParameterName ~ '=' ~next }}">&gt;</a>
            </li>
        {% endif %}

        {% if last is defined and current != last %}
            <li class="last">
                <a href="{{ current_url }}&{{ pageParameterName ~ '=' ~last }}">&gt;&gt;</a>
            </li>
        {% endif %}
    </ul>
{% endif %}