<?php
// Chamilo version {NEW_VERSION}
// File generated by /install/index.php script - {DATE_GENERATED}
/* For licensing terms, see /license.txt */
/**
 * This file contains a list of variables that can be modified by the campus site's server administrator.
 * Pay attention when changing these variables, some changes may cause Chamilo to stop working.
 * If you changed some settings and want to restore them, please have a look at
 * configuration.dist.php. That file is an exact copy of the config file at install time.
 * Besides the $_configuration, a $_settings array also exists, that
 * contains variables that can be changed and will not break the platform.
 * These optional settings are defined in the database, now
 * (table settings_current).
 */

// Database connection settings.
$_configuration['db_host'] = '{DATABASE_HOST}';
$_configuration['db_port'] = '{DATABASE_PORT}';
$_configuration['main_database'] = '{DATABASE_MAIN}';
$_configuration['db_user'] = '{DATABASE_USER}';
$_configuration['db_password'] = '{DATABASE_PASSWORD}';
// Enable access to database management for platform admins.
$_configuration['db_manager_enabled'] = false;

/**
 * Directory settings.
 */
// URL to the root of your Chamilo installation, e.g.: http://www.mychamilo.com/
$_configuration['root_web'] = '{ROOT_WEB}';
// Path to the webroot of system, example: /var/www/
$_configuration['root_sys'] = '{ROOT_SYS}';
// Path from your WWW-root to the root of your Chamilo installation,
// example: chamilo (this means chamilo is installed in /var/www/chamilo/
$_configuration['url_append'] = '{URL_APPEND_PATH}';

/**
 * Login modules settings.
 */
// CAS IMPLEMENTATION
// -> Go to your portal Chamilo > Administration > CAS to activate CAS
// You can leave these lines uncommented even if you don't use CAS authentification
//$extAuthSource["cas"]["login"] = $_configuration['root_sys']."main/auth/cas/login.php";
//$extAuthSource["cas"]["newUser"] = $_configuration['root_sys']."main/auth/cas/newUser.php";

// Map CAS attributes with user/user extrafields values BT#17620
/*$_configuration['cas_user_map'] = [
    'fields' => [
        'email' => 'mail',
        'firstname' => 'cn',
        'lastname' => 'sn',
        'active' => 'disabled',
        'status' => 'role',
    ],
    'extra' => [
        'isFromNewLogin',
        'authenticationDate',
        'successfulAuthenticationHandlers',
        'created_by',
        'credentialType',
        'uid',
        'authenticationMethod',
        'longTermAuthenticationRequestTokenUsed',
    ],
    'replace' => [
        'role' => [
            'STUDENT' => 5,
            'GUEST' => 5,
            'HEI_COORD' => 1,
            'SCHOOL_COORD' => 1,
            'HEI_TUTOR' => 1,
            'SCHOOL_TUTOR' => 1,
            'ADMIN' => 11,
        ],
    ],
];*/

// NEW LDAP IMPLEMENTATION BASED ON external_login info
// -> Uncomment the two lines bellow to activate LDAP AND edit main/auth/external_login/ldap.conf.php for configuration
// $extAuthSource["extldap"]["login"] = $_configuration['root_sys']."main/auth/external_login/login.ldap.php";
// $extAuthSource["extldap"]["newUser"] = $_configuration['root_sys']."main/auth/external_login/newUser.ldap.php";
//
// FACEBOOK IMPLEMENTATION BASED ON external_login info
// -> Uncomment the line bellow to activate Facebook Auth AND edit app/config/auth.conf.php for configuration
// $_configuration['facebook_auth'] = 1;
//
// OTHER EXTERNAL LOGIN INFORMATION
// To fetch external login information, uncomment those 2 lines and modify  files auth/external_login/newUser.php and auth/external_login/updateUser.php files
// $extAuthSource["external_login"]["newUser"] = $_configuration['root_sys']."main/auth/external_login/newUser.php";
// $extAuthSource["external_login"]["updateUser"] = $_configuration['root_sys']."main/auth/external_login/updateUser.php";

/**
 * Hosting settings - Allows you to set limits to the Chamilo portal when
 * hosting it for a third party. These settings can be overwritten by an
 * optionally-loaded extension file with only the settings (no comments).
 * The settings use an index at the first level to represent the ID of the
 * URL in case you use multi-url (otherwise it will always use 1, which is
 * the ID of the only URL inside the access_url table).
 */
// Set a maximum number of users. Default (0) = no limit
$_configuration[1]['hosting_limit_users'] = 0;
// Set a maximum number of teachers. Default (0) = no limit
$_configuration[1]['hosting_limit_teachers'] = 0;
// Set a maximum number of courses. Default (0) = no limit
$_configuration[1]['hosting_limit_courses'] = 0;
// Set a maximum number of sessions. Default (0) = no limit
$_configuration[1]['hosting_limit_sessions'] = 0;
// Set a maximum disk space used, in MB (set to 1024 for 1GB, 5120 for 5GB, etc)
// Default (0) = no limit
$_configuration[1]['hosting_limit_disk_space'] = 0;
// Set a maximum number of usable courses. Default (0) = no limit.
// Should always be lower than the hosting_limit_courses.
// If set, defining a course as "hidden" will free room for
// new courses (up to the hosting_limit_courses, if any value is set there).
// hosting_limit_enabled_courses is the maximum number of courses that are *not* hidden.
$_configuration[1]['hosting_limit_active_courses'] = 0;
// Email to warn if limit was reached.
//$_configuration[1]['hosting_contact_mail'] = 'example@example.org';
// Portal size limit in MB (set to 1024 for 1GB, 5120 for 5GB, etc).
// Check main/cron/hosting_total_size_limit.php for how to use this limit.
$_configuration['hosting_total_size_limit'] = 0;

/**
 * Content Delivery Network (CDN) settings. Only use if you need a separate
 * server to serve your static data. If you don't know what a CDN is, you
 * don't need it. These settings are for simple Origin Pull CDNs and are
 * experimental. Enable only if you really know what you're doing.
 * This might conflict with multiple-access urls.
 * Please note that recent browsers forbid the loading of resources from
 * a different portal URL then where they are, due to CORS rules.
 * To allow for CDN usage with different URLs, you need to specifically
 * allow CORS Access-Control-Allow-Origin for your main Chamilo URL.
 * This has to be done at the web server level, because Chamilo's PHP code
 * doesn't change HTTP headers of all files served from the Chamilo directory.
 * To do that on Apache, use
 *   Header set Access-Control-Allow-Origin "http(s)://main-chamilo-url"
 * in Nginx:
 *   add_header 'Access-Control-Allow-Origin' 'http(s)://main-chamilo-url';.
 */
// Set the following setting to true to start using the CDN
$_configuration['cdn_enable'] = false;
// The following setting will be ignored if the previous one is set to false
$_configuration['cdn'] = [
    // You can define several CDNs and split them by extensions
    // Replace the following by your full CDN URL, which should point to
    // your Chamilo's root directory. DO NOT INCLUDE a final slash! (won't work)
    'http://cdn.chamilo.org' => [
        '.css',
        '.js',
        '.jpg',
        '.jpeg',
        '.png',
        '.gif',
        '.avi',
        '.flv',
    ],
    // copy the line above and modify following your needs
];

/**
 * Misc. settings.
 */
// Security word for password recovery
$_configuration['security_key'] = '{SECURITY_KEY}';
// Hash function method
$_configuration['password_encryption'] = '{ENCRYPT_PASSWORD}';
// You may have to restart your web server if you change this
$_configuration['session_stored_in_db'] = false;
// Session lifetime
$_configuration['session_lifetime'] = SESSION_LIFETIME;
// Activation for multi-url access
// When enabling multi-url, settings can be configured by multi-url using a simple
// sub-element. E.g. $_configuration['session_lifetime'][1] = true; could be turned into
// something like $_configuration['session_lifetime'][2] = false; to affect only URL
// with ID 2. The ID can be found in the access_url table.
//$_configuration['multiple_access_urls'] = true;
$_configuration['software_name'] = 'Chamilo';
$_configuration['software_url'] = 'https://chamilo.org/';
// Deny the elimination of users
$_configuration['deny_delete_users'] = false;
// Version settings
$_configuration['system_version'] = '{NEW_VERSION}';
$_configuration['system_stable'] = NEW_VERSION_STABLE;

/**
 * Settings to be included as settings_current in future versions.
 */
// Uncomment the following to prevent all admins to use the "login as" feature
//$_configuration['login_as_forbidden_globally'] = true;
// If session_stored_in_db is false, an alternative session storage mechanism
// can be used, which allows for a volatile storage in Memcache, and a more
// permanent "backup" storage in the database, every once in a while (see
// frequency). This is generally used in HA clusters configurations
// This requires memcache or memcached and the php5-memcache module to be setup
//$_configuration['session_stored_in_db_as_backup'] = true;
// Define the different memcache servers available
//$_configuration['memcache_server'] = array(
//    0 => array(
//        'host' => 'chamilo8',
//        'port' => '11211',
//    ),
//    1 => array(
//        'host' => 'chamilo9',
//        'port' => '11211',
//    ),
//);
// Define the frequency to which the data must be stored in the database
//$_configuration['session_stored_after_n_times'] = 10;
// If the database is down this css style will be used to show the errors.
//$_configuration['theme_fallback'] = 'chamilo'; // (chamilo theme)
// The default template that will be use in the system.
//$_configuration['default_template'] = 'default'; // (main/template/default)
// Hide fields in the main/user/user.php page
//$_configuration['hide_user_field_from_list'] = ['fields' => ['username']];
// Aspell Settings
//$_configuration['aspell_bin'] = '/usr/bin/hunspell';
//$_configuration['aspell_opts'] = '-a -d en_GB -H -i utf-8';
//$_configuration['aspell_temp_dir'] = './';
// Custom name_order_conventions
//$_configuration['name_order_conventions'] = array(
// 'french' => array('format' => 'title last_name first_name', 'sort_by' => 'last_name')
//);
// Course log - Default columns to hide
//$_configuration['course_log_hide_columns'] = ['columns' => [1, 9]];
// Unoconv binary file
//$_configuration['unoconv.binaries'] = '/usr/bin/unoconv';
// Proxy settings for access external services
/*$_configuration['proxy_settings'] = [
    'stream_context_create' => [
        'http' => [
            'proxy' => 'tcp://example.com:8080',
            'request_fulluri' => true
        ]
    ],
    'curl_setopt_array' => [
        'CURLOPT_PROXY' => 'http://example.com',
        'CURLOPT_PROXYPORT' => '8080'
    ]
];*/

// E-mail accounts to send notifications to when executing cronjobs - works for main/cron/import_csv.php
//$_configuration['cron_notification_mails'] = array('email@example.com', 'email2@example.com');

// Help desk emails that will recieve email notifications in import_csv.php
//$_configuration['cron_notification_help_desk'] = array('email@example.com', 'email2@example.com');

// Only shows the fields in this list
/*$_configuration['allow_fields_inscription'] = [
    'fields' => [
        'official_code',
        'phone',
        'status',
        'language'
    ],
    'extra_fields' => [
        'birthday'
    ]
];*/
// Boost option to ignore encoding check for learning paths
//$_configuration['lp_fixed_encoding'] = 'false';
// Fix urls changing http with https in scorm packages.
//$_configuration['lp_replace_http_to_https'] = false;
// Fix embedded videos inside lps, adding an optional popup
//$_configuration['lp_fix_embed_content'] = false;
// Manage deleted files marked with "DELETED" (by course and only by allowed by admin)
//$_configuration['document_manage_deleted_files'] = false;
// Hide tabs in the main/session/index.php page
//$_configuration['session_hide_tab_list'] = array();
// Show invisible exercise in LP list
//$_configuration['show_invisible_exercise_in_lp_list'] = false;
// Chamilo is installed/downloaded. Packagers can change this
// to reflect their packaging method. The default value is 'chamilo'. This will
// be reflected on the https://version.chamilo.org/stats page in the future.
//$_configuration['packager'] = 'chamilo';
// If true exercises added in LP can be modified.
//$_configuration['force_edit_exercise_in_lp'] = false;
// List of driver to plugin in ckeditor
//$_configuration['editor_driver_list'] = ['PersonalDriver', 'CourseDriver'];
// Hide send to hrm users options in announcements
//$_configuration['announcements_hide_send_to_hrm_users'] = true;
// Hide certificate link in index/userportal pages
//$_configuration['hide_my_certificate_link'] = false;
// Hide header and footer in certificate pdf
//$_configuration['hide_header_footer_in_certificate'] = false;
// Security: block direct access from logged in users to contents in OPEN (but not public) courses. Set to true to block
//$_configuration['block_registered_users_access_to_open_course_contents'] = false;
// Allows syncing the database with the current entity schema
//$_configuration['sync_db_with_schema'] = false;
// When exporting a LP, all files and folders in the same path of an html will be exported too.
//$_configuration['add_all_files_in_lp_export'] = false;
// Send exercise student score to manager in email notification
//$_configuration['send_score_in_exam_notification_mail_to_manager'] = false;
// Show blocked LPs by prerequisite to students
//$_configuration['show_prerequisite_as_blocked'] = false;
// Mail header extra HTML attributes
//$_configuration['mail_header_style'] = '';
// Mail body extra HTML attributes
//$_configuration['mail_content_style'] = '';
// Show all agenda events in personal agenda from all session no matter the visibility.
//$_configuration['personal_agenda_show_all_session_events'] = false;
// Allows to redirect to the session after the inscription in session about
// $_configuration['allow_redirect_to_session_after_inscription_about'] = false;
// Allows to do a remove_XSS in course introduction with user status COURSEMANAGERLOWSECURITY
// in order to accept all embed type videos (like vimeo, wistia, etc)
// $_configuration['course_introduction_html_strict_filtering'] = true;
// Prevents the duplicate upload in assignments
// $_configuration['assignment_prevent_duplicate_upload'] = false;
//Show student progress in My courses page
//$_configuration['course_student_info']['score'] = false;
//$_configuration['course_student_info']['progress'] = false;
//$_configuration['course_student_info']['certificate'] = false;
// Set ConsideredWorkingTime work extra field variable to show in MyStudents page works report
// (with internal id 'work_time' as below) and enable the following line to show in MyStudents page works report
// $_configuration['considered_working_time'] = 'work_time';
// Allow add/remove working time in reporting page
// $_configuration['allow_working_time_edition'] = false;
// During CSV special imports update users emails to x@example.com
// $_configuration['update_users_email_to_dummy_except_admins'] = false;
// Certification pdf export orientation
// $_configuration['certificate_pdf_orientation'] = 'landscape'; // It can be 'portrait' or 'landscape'
// Hide main navigation menu (left column in userportal)
// $_configuration['hide_main_navigation_menu'] = false;
// PDF image dpi value. Default value 96
// $_configuration['pdf_img_dpi'] = 96;
// Hide LP time in reports.
// $_configuration['hide_lp_time'] = false;
// Hide rating elements in pages ("Courses catalog" & "Most Popular courses")
// $_configuration['hide_course_rating'] = false;
// Customize password generation and verification
/*$_configuration['password_requirements'] = [
    'min' => [
        'lowercase' => 2,
        'uppercase' => 2,
        'numeric' => 2,
        'length' => 8
    ]
];*/
// Customize course session tracking columns
/*
$_configuration['tracking_columns'] = [
    'course_session' => [
        'course_title' => true,
        'published_exercises' => true,
        'new_exercises' => true,
        'my_average' => true,
        'average_exercise_result' => true,
        'time_spent' => true,
        'lp_progress' => true,
        'score' => true,
        'best_score' => true,
        'last_connection' => true,
        'details' => true,
    ],
    'my_students_lp' => [
        'lp' => true,
        'time' => true,
        'best_score' => true,
        'latest_attempt_avg_score' => true,
        'progress' => true,
        'last_connection' => true,
    ],
    'my_progress_lp' => [
        'lp' => true,
        'time' => true,
        'progress' => true,
        'score' => true,
        'best_score' => true,
        'last_connection' => true,
    ],
    'my_progress_courses' => [
        'course_title' => true,
        'time_spent' => true,
        'progress' => true,
        'best_score_in_lp' => true,
        'best_score_not_in_lp' => true,
        'latest_login' => true,
        'details' => true
    ]
];
*/
// Hide session link of course_block on index/userportal
//$_configuration['remove_session_url']= false ;
// Allow foldable block for session list in session category on My courses tab
//$_configuration['user_portal_foldable_session_category'] = false;
//
//
// ------ AGENDA CONFIGURATION SETTINGS
// Shows a legend in the agenda tool
/*
$_configuration['agenda_legend'] = [
    'red' => 'red caption',
    '#f0f' => 'another caption'
];*/
// Set customs colors to agenda events
/*
$_configuration['agenda_colors'] = [
    'platform' => 'red',
    'course' => '#458B00',
    'group' => '#A0522D',
    'session' => '#00496D',
    'other_session' => '#999',
    'personal' => 'steel blue',
    'student_publication' => '#FF8C00'
];
*/
// ------
//
// Save some tool titles with HTML editor. Require DB changes:
/*
ALTER TABLE course_category CHANGE name name LONGTEXT NOT NULL;
ALTER TABLE c_course_description CHANGE title title LONGTEXT NOT NULL;
ALTER TABLE c_thematic CHANGE title title LONGTEXT NOT NULL;
ALTER TABLE c_quiz CHANGE title title LONGTEXT NOT NULL;
ALTER TABLE c_lp_category CHANGE name name LONGTEXT NOT NULL;
ALTER TABLE c_glossary CHANGE name name LONGTEXT NOT NULL;
ALTER TABLE c_tool CHANGE name name LONGTEXT NOT NULL;
-- Only with allow_portfolio_tool enabled
ALTER TABLE portfolio CHANGE title title LONGTEXT NOT NULL;
ALTER TABLE portfolio_category CHANGE title title LONGTEXT NOT NULL;

New changes:

ALTER TABLE c_lp CHANGE name name LONGTEXT NOT NULL;
ALTER TABLE c_lp_item CHANGE title title LONGTEXT NOT NULL;
--
*/
// $_configuration['save_titles_as_html'] = false;
// Show the full toolbar set to all CKEditor
//$_configuration['full_ckeditor_toolbar_set'] = false;
// Allow change the orientation when export a (course progress) thematic to pdf. Portrait or landscape
//$_configuration['thematic_pdf_orientation'] = 'landscape';
// Show number of users in session list
//$_configuration['session_list_show_count_users'] = false;
// Session admin access to all course content
//$_configuration['session_admins_access_all_content'] = false;
// Session admin allowed to edit all courses content
//$_configuration['session_admins_edit_courses_content'] = false;
// Adds roles to the system announcements (requires DB change BT#12476)
//$_configuration['system_announce_extra_roles'] = false;
// Limits that a session admin has access to list users
//$_configuration['limit_session_admin_list_users'] = false;
// Course tools visibility edition in sessions
//$_configuration['allow_edit_tool_visibility_in_session'] = false;
// Enable the support to ODF files
//$_configuration['enabled_support_odf'] = true;
// Pdf orientation when exporting documents
// $_configuration['document_pdf_orientation'] = 'landscape'; // It can be 'portrait' or 'landscape'
// Use alternative footer when exporting document to PDF
//$_configuration['use_alternative_document_pdf_footer'] = false;
// If the MySpace page takes too long to load, you might want to remove the
// processing of generic statistics for the user. In this case set the following to true.
//$_configuration['tracking_skip_generic_data'] = false;
// Show view accordion lp_category
//$_configuration['lp_category_accordion'] = false;
//
// Show view accordion lp_item_view
// $_configuration['lp_view_accordion'] = false;
//
// ------ HTTP headers security
// This section relates to options to increase the security of your Chamilo
// portal against attacks specifically focused on HTTP headers vulnerabilities
// These are all disabled by default, because some of these settings might
// affect some features of Chamilo, like the inclusion of iframes or the
// submission of forms by anonymous users. Please make sure you do the due
// tests before enabling in production. Learn more about how to form secure
// headers at https://securityheaders.io/
//
// HTTP Strict Transport Security is an excellent feature to support on your
// site and strengthens your implementation of TLS by getting the User Agent
// to enforce the use of HTTPS. Recommended value
// "strict-transport-security: max-age=31536000; includeSubDomains".
//$_configuration['security_strict_transport'] = 'strict-transport-security: max-age=31536000; includeSubDomains';
//
// Content Security Policy is an effective measure to protect your site from
// XSS attacks. By whitelisting sources of approved content, you can prevent
// the browser from loading malicious assets.
// The provided default is an *example*, please customize.
// This setting is particularly complicated to set with CKeditor, but if you
// add all domains that you want to authorize for iframes inclusion in the
// child-src statement, this example should work for you
//$_configuration['security_content_policy'] = 'default-src 'self'; script-src 'self' 'unsafe-eval' 'unsafe-inline'; style-src 'self' 'unsafe-inline'; child-src 'self' *.youtube.com yt.be *.vimeo.com *.slideshare.com;';
//$_configuration['security_content_policy_report_only'] = 'default-src \'self\'; script-src *://*.google.com:*';
//
// HTTP Public Key Pinning protects your site from MiTM attacks using rogue
// X.509 certificates. By whitelisting only the identities that the browser
// should trust, your users are protected in the event a certificate
// authority is compromised.
//$_configuration['security_public_key_pins'] = '';
//$_configuration['security_public_key_pins_report_only'] = '';
//
// X-Frame-Options tells the browser whether you want to allow your site to
// be framed or not. By preventing a browser from framing your site you can
// defend against attacks like clickjacking.
// If defining a URL here, it should define the URL(s) from which your content
// should be visible, not the URLs from which your site accepts content.
// For example, if your main URL (root_web above) is https://11.chamilo.org/,
// then this setting should be: 'ALLOW-FROM https://11.chamilo.org'.
// These headers only apply to pages where Chamilo is responsible of the HTTP
// headers generation (i.e. ".php" files). It does not apply to static files.
// If playing with this feature, make sure you also update your web server
// configuration to add the right headers for static files. See CDN
// configuration documentation above (search for "add_header") for more
// information.
// Recommended (strict) value for this setting, if enabled: "SAMEORIGIN".
//$_configuration['security_x_frame_options'] = 'SAMEORIGIN';
//
// X-XSS-Protection sets the configuration for the cross-site scripting
// filter built into most browsers.
// Recommended value "1; mode=block".
//$_configuration['security_xss_protection'] = '1; mode=block';
//
// X-Content-Type-Options stops a browser from trying to MIME-sniff the
// content type and forces it to stick with the declared content-type. The only
// valid value for this header is "nosniff".
//$_configuration['security_x_content_type_options'] = 'nosniff';
//
// Referrer Policy is a new header that allows a site to control how much
// information the browser includes with navigation away from a document
// and should be set by all sites.
//$_configuration['security_referrer_policy'] = 'origin-when-cross-origin';
// ------ HTTP headers security section ends here
//
// ------ Survey configuration settings
// Add answered_at field in table survey_invitation
// Requires DB change:
// ALTER TABLE c_survey_invitation ADD answered_at DATETIME DEFAULT NULL;
//$_configuration['survey_answered_at_field'] = false;
// Add support to mandatory surveys. The user will not be able to enter to the course until fill the mandatory surveys
// Requires DB change:
/*
INSERT INTO extra_field (extra_field_type, field_type, variable, display_text, visible_to_self, changeable, created_at)
VALUES (12, 13, 'is_mandatory', 'IsMandatory', 1, 1, NOW());
*/
//$_configuration['allow_mandatory_survey'] = false;
// Allow required survey questions. Applies to yesno/multiplechoice question type. Requires DB change:
/*
ALTER TABLE c_survey_question ADD is_required TINYINT(1) DEFAULT 0 NOT NULL;
*/
//$_configuration['allow_required_survey_questions'] = false;
// Hide Survey Reporting button
//$_configuration['hide_survey_reporting_button'] = false;
// Hide survey edition tools for all or some surveys.
//Set an asterisk to hide for all, otherwise set an array with the survey codes in which the options will be blocked
//$_configuration['hide_survey_edition'] = ['codes' => []];
// Allows to set the date and time of availability for surveys. Requires DB changes:
// ALTER TABLE c_survey CHANGE avail_from avail_from DATETIME DEFAULT NULL, CHANGE avail_till avail_till DATETIME DEFAULT NULL;
// Requires change the Doctrine type from date to datime in CSurvey::$availFrom and CSurvey::$availTill
//$_configuration['allow_survey_availability_datetime'] = false;
// Mark the "Required" field during question creation process when displaying the form.
//$_configuration['survey_mark_question_as_required'] = false;
// Allow add additional actions (as links) in survey list for teachers.
// e.g. ['myplugin' => ['MyPlugin', 'urlGeneratorCallback']]
//$_configuration['survey_additional_teacher_modify_actions'] = [];
// Allow show answers in anonymous surveys
//$_configuration['survey_anonymous_show_answered'] = false;
// ------

// Allow career diagram, requires a DB change:
//UPDATE extra_field_values SET created_at = NULL WHERE CAST(created_at AS CHAR(20)) = '0000-00-00 00:00:00';
//UPDATE extra_field_values SET updated_at = NULL WHERE CAST(updated_at AS CHAR(20)) = '0000-00-00 00:00:00';
//ALTER TABLE extra_field_values modify column value longtext null;
//$_configuration['allow_career_diagram'] = false;
// Allow scheduled emails to session users.
//CREATE TABLE scheduled_announcements (id INT AUTO_INCREMENT NOT NULL, subject VARCHAR(255) NOT NULL, message LONGTEXT NOT NULL, date DATETIME DEFAULT NULL, sent TINYINT(1) NOT NULL, session_id INT NOT NULL, c_id INT DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
// sudo mkdir app/upload/scheduled_announcement
// Uncomment and set the following setting to true before moving on
//$_configuration['allow_scheduled_announcements'] = false;
// Add "attachment" file upload extra field label in: main/admin/extra_fields.php?type=scheduled_announcement&action=add
// Add "send_to_coaches" checkbox options field label in: main/admin/extra_fields.php?type=scheduled_announcement&action=add
// Add the list of emails as a bcc when sending an email.
// Configure a cron task pointing at main/cron/scheduled_announcement.php
/*
$_configuration['send_all_emails_to'] = [
    'emails' => [
        'admin1@example.com',
        'admin2@example.com',
    ]
];*/
// Allow ticket projects to be access by specific chamilo roles
/*$_configuration['ticket_project_user_roles'] = [
    'permissions' => [
        1 => [17] // project_id = 1, STUDENT_BOSS = 17
    ]
];*/

// Allow additional data (exercise and learningpath) in the ticket
// - Required DB change
// ALTER TABLE ticket_ticket ADD exercise_id INT DEFAULT NULL AFTER course_id;
// ALTER TABLE ticket_ticket ADD CONSTRAINT FK_EB5B2A0D6285C987 FOREIGN KEY (exercise_id) REFERENCES c_quiz (iid);
// ALTER TABLE ticket_ticket ADD lp_id INT DEFAULT NULL AFTER exercise_id;
// ALTER TABLE ticket_ticket ADD CONSTRAINT FK_EB5B2A0D6285C231 FOREIGN KEY (lp_id) REFERENCES c_lp (iid);
// $_configuration['ticket_lp_quiz_info_add'] = false;

// Exercises configuration settings
// Send only quiz answer notifications to course coaches and not general coach
//$_configuration['block_quiz_mail_notification_general_coach'] = false;
// Show question feedback (requires DB change: "ALTER TABLE c_quiz_question ADD COLUMN feedback text;")
//$_configuration['allow_quiz_question_feedback'] = false;
// Add option in exercise to show or hide the "previous" button.
//ALTER TABLE c_quiz ADD show_previous_button TINYINT(1) DEFAULT 1;
//$_configuration['allow_quiz_show_previous_button_setting'] = false;
// Allow to teachers review exercises question with audio notes
//$_configuration["allow_teacher_comment_audio"] = false;
// Block copy/paste/save/print keys and right-clicks in exercises
//$_configuration['quiz_prevent_copy_paste'] = false;
// Always show the test description on the results page of the test
//$_configuration['quiz_show_description_on_results_page'] = false;
// Allow add additional actions (as links) in exercises list for teachers.
// Callback get the $exerciseId and $iconSize as parameters.
// e.g. ['myplugin' => ['MyPlugin', 'urlGeneratorCallback']]
//$_configuration['exercise_additional_teacher_modify_actions'] = []
// Generate certificate when ending a quiz.
// The quiz needs to be linked to a gradebook category and have set the pass percentage.
//$_configuration['quiz_generate_certificate_ending'] = false;
// Allow the teacher to rate the open, oral expression and annotation question types with a decimal score.
//$_configuration['quiz_open_question_decimal_score'] = false;
// Add answer-saving procedure check before starting the quiz
//$_configuration['quiz_check_button_enable'] = false;
// Add a checkbox to allow to user confirm the number of answers saved in quiz attempt
// - Requires to edit the src/Chamilo/CoreBundle/Entity/TrackEExerciseConfirmation.php file adding the "@" in the ORM phpdoc block
// - Requires DB changes:
// CREATE TABLE track_e_exercise_confirmation (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, course_id INT NOT NULL, attempt_id INT NOT NULL, quiz_id INT NOT NULL, session_id INT NOT NULL, confirmed TINYINT(1) DEFAULT '0' NOT NULL, questions_count INT NOT NULL, saved_answers_count INT NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB;
//$_configuration['quiz_confirm_saved_answers'] = false;

// Hide search form in session list
//$_configuration['hide_search_form_in_session_list'] = false;
// Allow exchange of messages from teachers/bosses about a user.
//$_configuration['private_messages_about_user'] = false;
// Allow the messages to be visible for the students
//$_configuration['private_messages_about_user_visible_to_user'] = false;
// Allow send email notification per exercise
//ALTER TABLE c_quiz ADD COLUMN notifications VARCHAR(255) NULL DEFAULT NULL;
//$_configuration['allow_notification_setting_per_exercise'] = false;
// Hide free/oral/annotation question result see BT#12613
//$_configuration['hide_free_question_score'] = false;
// Hide user information in the quiz result's page
//$_configuration['hide_user_info_in_quiz_result'] = false;
// Show the username field in exercise results report
//$_configuration['exercise_attempts_report_show_username'] = false;

// Score model
// Allow to convert a score into a text/color label
// using a model if score is inside those values. See BT#12898
/*
$_configuration['score_grade_model'] = [
    'models' => [
        [
            'id' => 1,
            'name' => 'ThisIsMyModel', // Value will be translated using get_lang
            'score_list' => [
                [
                    'name' => 'VeryBad', // Value will be translated using get_lang
                    'css_class' => 'btn-danger',
                    'min' => 0,
                    'max' => 20,
                    'score_to_qualify' => 0
                ],
                [
                    'name' => 'Bad',
                    'css_class' => 'btn-danger',
                    'min' => 21,
                    'max' => 50,
                    'score_to_qualify' => 25
                ],
                [
                    'name' => 'Good',
                    'css_class' => 'btn-warning',
                    'min' => 51,
                    'max' => 70,
                    'score_to_qualify' => 60
                ],
                [
                    'name' => 'VeryGood',
                    'css_class' => 'btn-success',
                    'min' => 71,
                    'max' => 100,
                    'score_to_qualify' => 100
                ]
            ]
        ]
    ]
];
*/

// Allow show link to request relation between HRM and user
//$_configuration['show_link_request_hrm_user'] = false;
// Allow CKEditor start up with ShowBlocks plugin active
//$_configuration['ckeditor_startup_outline_blocks'] = false;
// SETTINGS FOR USER COURSE LIST
// Manage the links to Session Index page
// 1 = Default. Works as it is now (default is to link to the special session page)
// 0 = No link (hide session title)
// 2 = Link to the course if there is only one course
// 3 = Session link will make course list foldable
// 4 = No link (only session title)
//$_configuration['courses_list_session_title_link'] = 1;
// New grid view the list of courses
//$_configuration['view_grid_courses'] = true;
// Show courses grouped by categories when $_configuration['view_grid_courses'] is enabled
//$_configuration['view_grid_courses_grouped_categories_in_sessions'] = true;
// Load course notifications in user_portal.php using ajax
//$_configuration['user_portal_load_notification_by_ajax'] = false;
// Hide the "what's new" icon notifications in course list
// $_configuration['hide_course_notification'] = true;
// Show less session information in course list
//$_configuration['show_simple_session_info'] = true;
// Show course category list on My Courses page before the courses. Requires a DB change
//ALTER TABLE course_category ADD image varchar(255) NULL;
//ALTER TABLE course_category ADD description LONGTEXT NULL;
//$_configuration['my_courses_list_as_category'] = false;
// ------

// Skills can only be visible for admins, teachers (related to a user via a course),
// and HRM users (if related to a user).
// $_configuration['allow_private_skills'] = false;
// Additional gradebook dependencies BT#13099
// ALTER TABLE gradebook_category ADD COLUMN depends TEXT DEFAULT NULL;
// ALTER TABLE gradebook_category ADD COLUMN minimum_to_validate INT DEFAULT NULL;
// ALTER TABLE gradebook_category ADD COLUMN gradebooks_to_validate_in_dependence INT DEFAULT NULL;
// $_configuration['gradebook_dependency'] = false;
// Courses id list to check in the gradebook sidebar see BT#13099
/*$_configuration['gradebook_dependency_mandatory_courses'] = [
    'courses' => [1, 2]
];*/
// Gradebook id list needed to build the gradebook sidebar see BT#13099
/*
$_configuration['gradebook_badge_sidebar'] = [
    'gradebooks' => [1, 2, 3]
];*/

// Show language selector in main menu an update the language in the user's
// profile.
//$_configuration['show_language_selector_in_menu'] = false;

// When using the my-courses list filter by category, set this option to true
// to only show courses in the user's configured language
// $_configuration['my_courses_show_courses_in_user_language_only'] = false;

// Hide base course announcements when entering a group.
//$_configuration['hide_base_course_announcements_in_group'] = false;

// Disable delete all announcements button
//$_configuration['disable_delete_all_announcements'] = false;

// Default glossary view "table" or "list"
//$_configuration['default_glossary_view'] = 'table';

// Allow or block user subscriptions to a lp/lp category
/*$_configuration['lp_subscription_settings'] = [
    'options' => [
        'allow_add_users_to_lp' => true,
        'allow_add_users_to_lp_category' => true,
    ]
];*/

// Allow public courses access with no terms and conditions validation.
//$_configuration['allow_public_course_with_no_terms_conditions'] = false;

// Allow delete user for session admin
//$_configuration['allow_delete_user_for_session_admin'] = false;
// Allow enable/disable user accounts for session admin
//$_configuration['allow_disable_user_for_session_admin'] = false;
// Allow edit/delete agenda events for HRM users
//$_configuration['allow_agenda_edit_for_hrm'] = false;
// Allow double validation in registration page
//$_configuration['allow_double_validation_in_registration'] = false;
// Allow multiple anon users see BT#13324
//$_configuration['max_anonymous_users'] = 0;

// Send email notification to admin when a user is created
//$_configuration['send_notification_when_user_added'] = ['admins' => [1] ];

// Send email notification to course members when document is added BT#13964
//$_configuration['send_notification_when_document_added'] = false;

// Hide email content forcing using to click in a link to visit the portal to check the message
//$_configuration['messages_hide_mail_content'] = false;
// If you install plugin redirection you need to change to true
//$_configuration['plugin_redirection_enabled'] = false;
// Customize on hover agenda view. Show agenda comment and/or description
/*$_configuration['agenda_on_hover_info'] = [
    'options' => [
        'comment' => true,
        'description' => true,
    ]
];*/
// Disable jquery, jquery-ui libs added in the learning path view
//$_configuration['disable_js_in_lp_view'] = true;
// Show all sessions (old, current, future) in my course page
//$_configuration['show_all_sessions_on_my_course_page'] = true;
// Redirect to home tool after uploading a student publication or a adding a comment
//$_configuration['allow_redirect_to_main_page_after_work_upload'] = false;
// Empty the session student list when subscribing multiple users
//$_configuration['session_multiple_subscription_students_list_avoid_emptying'] = false;
// Disable the option to set course coach in session when editing course
//$_configuration['disabled_edit_session_coaches_course_editing_course'] = false;
// Show sender's email when receiving email notifications.
//$_configuration['show_user_email_in_notification'] = false;
// Set skill levels name, then later it will be parsed using get_lang BT#13586
/*$_configuration['skill_levels_names'] = [
    'levels' => [
        1 => 'Skills',
        2 => 'Capability',
        3 => 'Dimension',
    ]
];*/

// Show popular sessions on homepage
//$_configuration['show_hot_sessions'] = false;

// Hide skill levels options
//$_configuration['hide_skill_levels'] = false;

// Hide the session list in Reporting tool. Useful when a course has too many sessions.
//$_configuration['hide_reporting_session_list'] = false;

// Allow session admin to read careers
//$_configuration['allow_session_admin_read_careers'] = true;

// Enable cloud links in document tool
// $_configuration['enable_add_file_link'] = false;

// Send score in percentage in the exam result notification
//$_configuration['send_notification_score_in_percentage'] = false;

// Google translate key (for the text2speech feature in the documents tool)
// To get it, go to https://console.cloud.google.com/apis/library, create or
// use your own project, then search for "speech" and follow the instructions
// This service has a cost above 60 minutes of use.
//$_configuration['translate_app_google_key'] = '';

// Block access to any user to "my progress" page
//$_configuration['block_my_progress_page'] = false;

// Add user extra fields in report: main/mySpace/exercise_category_report.php
//$_configuration['exercise_category_report_user_extra_fields'] = ['fields' => ['skype', 'rssfeeds']];

// Order sessions
// Requires DB change: ALTER TABLE session ADD COLUMN position INT DEFAULT 0;
// Requires edit Entity Session: src/Chamilo/CoreBundle/Entity/Session.php uncomment "position" variable.
// Requires uncomment the position get and set
//$_configuration['session_list_order'] = false;

// Show skills as a hierarchical table
//$_configuration['table_of_hierarchical_skill_presentation'] = false;

// Restrict course chat only for course coach in sessions
// Course coaches will can chat with students only. And students will can chat with all course coaches
//$_configuration['course_chat_restrict_to_coach'] = false;

// Allow teachers, drhs and admins to access blocked LP's because a prerequisite.
//$_configuration['allow_teachers_to_access_blocked_lp_by_prerequisite'] = false;

// Allow connect skills with course tools (exercises, forum threads, works, etc)
// 1. Add "@ORM\Entity" in these Entities:
//SkillRelItemRelUser/SkillRelItem
// 2. Add "@ORM\OneToMany" in the "Skill.items" variable definition
// 3. Run DB changes:
/*
CREATE TABLE skill_rel_item_rel_user (id INT AUTO_INCREMENT NOT NULL, skill_rel_item_id INT NOT NULL, user_id INT NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, created_by INT NOT NULL, updated_by INT NOT NULL, INDEX IDX_D1133E0DFD4B12DC (skill_rel_item_id), INDEX IDX_D1133E0DA76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE skill_rel_item (id INT AUTO_INCREMENT NOT NULL, skill_id INT DEFAULT NULL, item_type INT NOT NULL, item_id INT NOT NULL, obtain_conditions VARCHAR(255) DEFAULT NULL, requires_validation TINYINT(1) NOT NULL, is_real TINYINT(1) NOT NULL, c_id INT DEFAULT NULL, session_id INT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, created_by INT NOT NULL, updated_by INT NOT NULL, INDEX IDX_EB5B2A0D5585C142 (skill_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
ALTER TABLE skill_rel_item_rel_user ADD CONSTRAINT FK_D1133E0DFD4B12DC FOREIGN KEY (skill_rel_item_id) REFERENCES skill_rel_item (id);
ALTER TABLE skill_rel_item_rel_user ADD CONSTRAINT FK_D1133E0DA76ED395 FOREIGN KEY (user_id) REFERENCES user (id);
ALTER TABLE skill_rel_item ADD CONSTRAINT FK_EB5B2A0D5585C142 FOREIGN KEY (skill_id) REFERENCES skill (id);
ALTER TABLE skill_rel_item_rel_user ADD result_id INT DEFAULT NULL;

CREATE TABLE skill_rel_course (id INT AUTO_INCREMENT NOT NULL, skill_id INT DEFAULT NULL, c_id INT NOT NULL, session_id INT NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX IDX_E7CEC7FA5585C142 (skill_id), INDEX IDX_E7CEC7FA91D79BD3 (c_id), INDEX IDX_E7CEC7FA613FECDF (session_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
ALTER TABLE skill_rel_course ADD CONSTRAINT FK_E7CEC7FA5585C142 FOREIGN KEY (skill_id) REFERENCES skill (id);
ALTER TABLE skill_rel_course ADD CONSTRAINT FK_E7CEC7FA91D79BD3 FOREIGN KEY (c_id) REFERENCES course (id);
ALTER TABLE skill_rel_course ADD CONSTRAINT FK_E7CEC7FA613FECDF FOREIGN KEY (session_id) REFERENCES session (id);
*/
// 4. Set "allow_skill_rel_items" to true
//$_configuration['allow_skill_rel_items'] = false;

// Generate random login when importing users
//$_configuration['generate_random_login'] = false;

// Remove html tags when exporting glossary definitions in a CSV file
//$_configuration['allow_remove_tags_in_glossary_export'] = false;

// Show base course categories in portal children
//$_configuration['allow_base_course_category'] = false;

// Send two emails when creating a user. One with the username other with the password.
//$_configuration['send_two_inscription_confirmation_mail'] = false;

// LP view custom settings
/*$_configuration['lp_view_settings'] = [
    'display' => [
        'show_reporting_icon' => true,
        'hide_lp_arrow_navigation' => false,
        'show_toolbar_by_default' => false,
        'navigation_in_the_middle' => false,
    ],
];*/

// Force to hide the invisible course documents in sessions
//$_configuration['hide_invisible_course_documents_in_sessions'] = false;

// Show more expected choice and status in exercise results BT#13950
//$_configuration['show_exercise_expected_choice'] = false;

// Hide exercise question label (ribbon) BT#13950
//$_configuration['exercise_hide_label'] = false;

// Send welcome message by email and to the chamilo inbox BT#14034
//$_configuration['send_inscription_msg_to_inbox'] = false;

// Allow administrators to see personal messages between a teacher and a student.
// Please make sure you include a note in your terms and conditions as this might
// affect privacy protection.
//$_configuration['allow_user_message_tracking'] = false;

// Add a portfolio tool (duplicating the Notebook tool). Requires DB changes:
/*
CREATE TABLE portfolio (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, c_id INT DEFAULT NULL, session_id INT DEFAULT NULL, category_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, content LONGTEXT NOT NULL, creation_date DATETIME NOT NULL, update_date DATETIME NOT NULL, is_visible TINYINT(1) DEFAULT '1' NOT NULL, INDEX user (user_id), INDEX course (c_id), INDEX session (session_id), INDEX category (category_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
CREATE TABLE portfolio_category (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, title VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, is_visible TINYINT(1) DEFAULT '1' NOT NULL, INDEX user (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
ALTER TABLE portfolio ADD CONSTRAINT FK_A9ED1062A76ED395 FOREIGN KEY (user_id) REFERENCES user (id) ON DELETE CASCADE;
ALTER TABLE portfolio ADD CONSTRAINT FK_A9ED106291D79BD3 FOREIGN KEY (c_id) REFERENCES course (id) ON DELETE CASCADE;
ALTER TABLE portfolio ADD CONSTRAINT FK_A9ED1062613FECDF FOREIGN KEY (session_id) REFERENCES session (id) ON DELETE CASCADE;
ALTER TABLE portfolio ADD CONSTRAINT FK_A9ED106212469DE2 FOREIGN KEY (category_id) REFERENCES portfolio_category (id) ON DELETE SET NULL;
ALTER TABLE portfolio_category ADD CONSTRAINT FK_7AC64359A76ED395 FOREIGN KEY (user_id) REFERENCES user (id);
INSERT INTO settings_current(variable, subkey, type, category, selected_value, title, comment, scope, subkeytext, access_url_changeable) VALUES('course_create_active_tools','portfolio','checkbox','Tools','true','CourseCreateActiveToolsTitle','CourseCreateActiveToolsComment',NULL,'Portfolio', 0);
*/
// In 1.11.8, before enabling this feature, you also need to:
// - edit src/Chamilo/CoreBundle/Entity/Portfolio.php and PortfolioCategory.php
//   and follow the instructions about the @ORM\Entity() line
// - launch composer install to rebuild the autoload.php
//$_configuration['allow_portfolio_tool'] = false;

// Enable best score column in gradebook. Previously called disable_gradebook_stats
//$_configuration['gradebook_enable_best_score'] = false;

// Allow teachers to access student skills BT#14161 (skills setting must be enabled in the platform)
//$_configuration['allow_teacher_access_student_skills'] = false;

// Allow sharing options for the documents inside a group
//ALTER TABLE c_group_info ADD document_access INT DEFAULT 0 NOT NULL;
//$_configuration['group_document_access'] = false;

// Allow sharing options for the documents inside a group category
//ALTER TABLE c_group_category ADD document_access INT DEFAULT 0 NOT NULL;
//$_configuration['group_category_document_access'] = false;

// Allow LP export to chamilo format (CourseBackup)
//$_configuration['allow_lp_chamilo_export'] = false;

// Allow exercise auto launch
//$_configuration['allow_exercise_auto_launch'] = false;
// ALTER TABLE c_quiz ADD autolaunch TINYINT(1) DEFAULT 0;

// Enable speed controller in video player
// $_configuration['video_features'] = ['features' => ['speed']];

// Disable token verification when sending a message
// $_configuration['disable_token_in_new_message'] = false;

// My courses session order. Possible field values: "start_date", "end_date", "name" Order values: "asc" or "desc"
// $_configuration['my_courses_session_order'] = ['field' => 'end_date', 'order' => 'desc'];

// Allow set courses in session in read-only mode. Require DB changes:
/*
INSERT INTO extra_field (extra_field_type, field_type, variable, display_text, visible_to_self, changeable, filter, created_at)
VALUES (2, 13, 'session_courses_read_only_mode', 'Lock Course In Session', 1, 1, 1, NOW());
*/
// $_configuration['session_courses_read_only_mode'] = false;

// Allow SCORM packages when importing a course
// $_configuration['allow_import_scorm_package_in_course_builder'] = false;

// Hide announcement "sent to" label
// $_configuration['hide_announcement_sent_to_users_info'] = false;

// Hide gradebook graph
// $_configuration['gradebook_hide_graph'] = false;

// Hide gradebook "download report in PDF" button
// $_configuration['gradebook_hide_pdf_report_button'] = false;

// Show pending survey link in user menu
// $_configuration['show_pending_survey_in_menu'] = false;

// GDPR: European's General Data Protection Rules activation option
// Set to true to disable the new personal data page inside the social network
// menu
// $_configuration['disable_gdpr'] = true;

// GDPR requires users to be informed of the Data Protection Officer name and
// contact point. These can only be defined here for now, but will be moved to
// web settings in the future.
// Name of the person or organization that is responsible for the treatment of
// personal info
//$_configuration['data_protection_officer_name'] = '';
// A description of the role of the DP Officer in this context
//$_configuration['data_protection_officer_role'] = '';
// An e-mail address where to contact the data protection officer for queries
//$_configuration['data_protection_officer_email'] = '';

// Show multiple conditions to user during sign up process
// Example with a GDPR condition
/*$_configuration['show_conditions_to_user'] = [
    'conditions' => [
        [
            'variable' => 'gdpr', // internal extra field name
            'display_text' => 'GDPRTitle', // checkbox title will be translated with get_lang('GDPRTitle')
            'text_area' => 'GDPRTextArea', // this will be translated using get_lang('GDPRTextArea')
        ],
        [
            'variable' => 'my_terms',
            'display_text' => 'My test conditions',
            'text_area' => 'This is a long text area, with lot of terms and conditions ... ',
        ],
    ],
];*/

// Make GDPR terms public (useful when using the platform for anonymous survey
// invitations where users can leave personal info).
// $_configuration['gdpr_terms_public'] = false;

// Hide LP item prerequisite label in the LP view
//$_configuration['hide_accessibility_label_on_lp_item'] = true;

// Round score in exercise category export
//$_configuration['exercise_category_round_score_in_export'] = false;

// Redirect index to url for logged in users
// In this example the index.php will be redirected to user_portal.php for logged in users
//$_configuration['redirect_index_to_url_for_logged_users'] = 'user_portal.php';

// Teachers can CRUD classes
// ALTER TABLE usergroup ADD author_id INT DEFAULT NULL;
//$_configuration['allow_teachers_to_classes'] = false;

// Validate user login via a webservice, Chamilo will send a "login" and "password" parameters
// to the "myWebServiceFunctionToLogin" function, the result should be "1" if the user have access.
/*$_configuration['webservice_validation'] = [
    'options' => [
        'wsdl' => 'https://example.com/soap?wsdl',
        'check_login_function' => 'myWebServiceFunctionToLogin'
    ]
];*/

// Hide the username when showing the complete name for a user.
// Example: using api_get_user_info()['complete_name_with_username'] or $user->getCompleteNameWithUsername()
//$_configuration['hide_username_with_complete_name'] = false;

// Hide the username in course chat
//$_configuration['hide_username_in_course_chat'] = false;

// Allow multiple attempts in gradebook evaluations
// CREATE TABLE gradebook_result_attempt (id INT AUTO_INCREMENT NOT NULL, result_id INT NOT NULL, score DOUBLE, comment LONGTEXT DEFAULT NULL, created_at DATETIME, updated_at DATETIME, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
//$_configuration['gradebook_multiple_evaluation_attempts'] = false;

// Hide country flags in the language switcher
// $_configuration['hide_flag_language_switcher'] = false;

// Hide complete name in who is online page
// $_configuration['hide_complete_name_in_whoisonline'] = false;

// Block student publication edition BT#14985
// $_configuration['block_student_publication_edition'] = false;

// Block student publication add documents BT#14986
//$_configuration['block_student_publication_add_documents'] = false;

// Block teacher to modify a work score edition BT#14987
// $_configuration['block_student_publication_score_edition'] = false;

// Enable system to manage e-mail templates in users registration forms
/*CREATE TABLE mail_template(
  id int not null primary key auto_increment,
  name varchar(255) not null, -- a friendly name for the template, to remember what it is like
  template text, -- the template content (in Twig format)
  type varchar(255) not null, -- the type of the mail (we can use current template names to fill that)
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  author_id INT NOT NULL,
  url_id INT NOT NULL,
  default_template TINYINT not null,
  system int not null default 0 -- whether it can be deleted or not (system = 1 means it's initially from Chamilo, any other template can be created/deleted/edited, but the ones with system=1 cannot)
);*/
// $_configuration['mail_template_system'] = false;

// Students can only upload one publication
// $_configuration['allow_only_one_student_publication_per_user'] = false;

// Hide percentage in best/average gradebook results
//$_configuration['hide_gradebook_percentage_user_result'] = true;

// Use exercise platform score settings in the gradebook graph
// $_configuration['gradebook_use_exercise_score_settings_in_categories'] = true;

// Activate the view with ViewerJS for PDF files within the lessons for IPad and IPhone
// $_configuration['allow_pdf_viewerjs_in_lp'] = false;

// Allow DRH user to access all visible session course announcements
// $_configuration['allow_drh_access_announcement'] = false;

// Allow my personal files link in the homepage
// $_configuration['allow_my_files_link_in_homepage'] = false;

// This option sets default parameters in the main/session/session_import.php
/*$_configuration['session_import_settings'] = [
    'options' =>  [
        'session_exists_default_option' => '1',
        'send_mail_default_option' => '1',
    ]
];*/

/*
 * Fields visibility in the profile user page
$_configuration['profile_fields_visibility'] = [
    'options' => [
        'vcard' => false,
        'firstname' => false,
        'lastname' => false,
        'photo' => true,
        'email' => true,
        'chat' => true,
        'terms_ville' => false, // extra field value
    ]
];*/

// This option sets default parameters in the main/admin/user_import.php
/*$_configuration['user_import_settings'] = [
    'options' =>  [
        'send_mail_default_option' => '1',
    ]
];*/

// Disable all new exercise attempts in all the platform
// $_configuration['exercises_disable_new_attempts'] = false;

// Improve speed when rendering gradebook student reports using Doctrine APCU cache
// $_configuration['gradebook_use_apcu_cache'] = true;

/*
 Add a minimum time limit to be in the learning path
 in order to get the last item completed
 Requires a DB change:
    ALTER TABLE c_lp ADD accumulate_work_time INT NOT NULL;
    CREATE TABLE track_e_access_complete (id int(11) NOT NULL AUTO_INCREMENT, user_id int(11) NOT NULL, date_reg datetime NOT NULL, tool varchar(255) NOT NULL, tool_id int(11) NOT NULL,   tool_id_detail int(11) NOT NULL,  action varchar(255) NOT NULL,   action_details varchar(255) NOT NULL, current_id int(11) NOT NULL, ip_user varchar(255) NOT NULL, user_agent varchar(255) NOT NULL, session_id int(11) NOT NULL, c_id int(11) NOT NULL,   ch_sid varchar(255) NOT NULL, login_as int(11) NOT NULL, info longtext NOT NULL, url text NOT NULL, PRIMARY KEY (id) ) ENGINE=InnoDB AUTO_INCREMENT=13989 DEFAULT CHARSET=utf8;
    CREATE INDEX user_course_session ON track_e_access_complete (user_id, c_id, session_id);
 Add course checkbox extra field "new_tracking_system"
 Add session checkbox extra field "new_tracking_system"
 Only applied for courses/sessions with extra field "new_tracking_system" to "1"
*/
//$_configuration['lp_minimum_time'] = false;

// Track LP attempts using the new tracking system.
// Requires to add an LP extra field called "track_lp_item" (checkbox) in order to use this feature.
//$_configuration['use_new_tracking_in_lp_item'] = false;

// Add collapsable option for user course categories
// ALTER TABLE user_course_category ADD collapsed TINYINT(1) DEFAULT NULL;
// $_configuration['allow_user_course_category_collapsable'] = false;

// Add collapsable option when showing the course list inside a session in userportal.php
// ALTER TABLE session_rel_user ADD collapsed TINYINT(1) DEFAULT NULL;
// Create a new session extra field called "collapsed" (checkbox yes/no - option)
// $_configuration['allow_user_session_collapsable'] = false;

// Allow to session admins login as teachers
//$_configuration['allow_session_admin_login_as_teacher'] = false;

// Allow gradebook stats
// Requires to edit the GradebookLink.php And GradebookEvaluation.php files adding the "@" in the ORM phpdoc block
/* ALTER TABLE gradebook_link ADD score_weight DOUBLE PRECISION DEFAULT NULL, ADD average_score DOUBLE PRECISION DEFAULT NULL, ADD best_score DOUBLE PRECISION DEFAULT NULL, ADD user_score_list LONGTEXT DEFAULT NULL COMMENT '(DC2Type:array)' ;
ALTER TABLE gradebook_evaluation ADD score_weight DOUBLE PRECISION DEFAULT NULL, ADD average_score DOUBLE PRECISION DEFAULT NULL, ADD best_score DOUBLE PRECISION DEFAULT NULL, ADD user_score_list LONGTEXT DEFAULT NULL COMMENT '(DC2Type:array)' ;
*/

//$_configuration['allow_gradebook_stats'] = false;

// Hide social media links
//$_configuration['hide_social_media_links'] = false;

// Show chamilo unique question id in exercises
// $_configuration['show_question_id'] = false;

// Show pagination if question list is bigger than "x" value, if 0 pagination will not appear.
// Option only when building an exercise as a teacher
// $_configuration['show_question_pagination'] = 100;

// Number of questions to show in every page
// Option only when building an exercise as a teacher
// $_configuration['question_pagination_length'] = 20;

// Teachers cannot delete an exercise/questions, change exercise visibility, download to qti, clean results
// $_configuration['limit_exercise_teacher_access'] = false;

// Changes the row list when using jqgrid/sortable tables
//$_configuration['table_row_list'] = ['options' => [50, 100, 200, 500]];

// Default selected row in jqgrid/sortable tables
//$_configuration['table_default_row'] = 50;

// Disable Chamilo.org announcements at the top of the admin page
//$_configuration['admin_chamilo_announcements_disable'] = false;

// Disable course report graphs
//$_configuration['hide_course_report_graph'] = false;

// Visually "fold" forum categories by default
// $_configuration['forum_fold_categories'] = false;

// Set extra fields as required in the inscription.php page
/*$_configuration['required_extra_fields_in_inscription'] = [
    'options' => [
        'terms_ville',
        'terms_paysresidence',
    ],
];*/

/* Set extra fields as required in the profile.php page
$_configuration['required_extra_fields_in_profile'] = [
    'options' => [
        'terms_villedustage'
    ],
];
*/

// Community manager users
//$_configuration['community_managers_user_list'] = ['users' => [1]];

// Hide global chat video
//$_configuration['hide_chat_video'] = false;

// global forum in social network BT#15309
//$_configuration['global_forums_course_id'] = 0;

// Hide forum post revision checkbox
//$_configuration['hide_forum_post_revision_language'] = false;

// Allow forum post revisions
// Requires new forum_category and forum_post "language" extra fields (multiple select)
//$_configuration['allow_forum_post_revisions'] = false;

// Allow to show users in a map, users need to have a coordinates extra field BT#15176
//$_configuration['allow_social_map_fields'] = ['fields' => ['terms_villedustage', 'terms_ville']];

// Translate HTML based in the HTML "lang" attribute see BT#15166
//$_configuration['translate_html'] = false;

// Avoid add a reply-to header when a no-reply address is set.
//$_configuration['mail_no_reply_avoid_reply_to'] = false;

// Allows to user add feedback (likes or dislikes) to posts in social wall. Requires DB changes:
// CREATE TABLE message_feedback (id BIGINT AUTO_INCREMENT NOT NULL, message_id BIGINT NOT NULL, user_id INT NOT NULL, liked TINYINT(1) DEFAULT '0' NOT NULL, disliked TINYINT(1) DEFAULT '0' NOT NULL, updated_at DATETIME NOT NULL, INDEX IDX_DB0F8049537A1329 (message_id), INDEX IDX_DB0F8049A76ED395 (user_id), INDEX idx_message_feedback_uid_mid (message_id, user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
// ALTER TABLE message_feedback ADD CONSTRAINT FK_DB0F8049537A1329 FOREIGN KEY (message_id) REFERENCES message (id) ON DELETE CASCADE;
// ALTER TABLE message_feedback ADD CONSTRAINT FK_DB0F8049A76ED395 FOREIGN KEY (user_id) REFERENCES user (id) ON DELETE CASCADE;
// In 1.11.8, before enabling this feature, you also need to:
// - edit src/Chamilo/CoreBundle/Entity/MessageFeedback.php
//   and follow the instructions about the @ORM\Entity() line
// - edit src/Chamilo/CoreBundle/Entity/Message.php
//   and follow the instructions about the @ORM\OneToMany line for the $likes property
// - launch "composer install" to rebuild the autoload.php
//$_configuration['social_enable_messages_feedback'] = false;

// Disable dislike button in the social network.
//$_configuration['disable_dislike_option'] = false;

// Block student's access to the course documents when using the ckeditor "Browse server" button
//$_configuration['block_editor_file_manager_for_students'] = false;
// Show a language flag next to the user picture in the social network
//$_configuration['social_show_language_flag_in_profile'] = false;

// Add subject and body in the mailto: footer
//$_configuration['add_user_course_information_in_mailto'] = false;

// Add gradebook score style configuration in the flat view
// See api.lib.php in order to find the options: examples SCORE_DIV = 1, SCORE_PERCENT = 2, etc
//$_configuration['gradebook_report_score_style'] = 1; //  Means the score will be (X / Y) "SCORE_DIV"

// Allow show the score display custom (when it is enabled) in a standalone column in gradebook
//$_configuration['gradebook_score_display_custom_standalone'] = false;

// Blocks "my files" access to anon users
//$_configuration['block_my_files_access'] = false;

// Allow .htaccess files in SCORM packages
//$_configuration['allow_htaccess_import_from_scorm'] = false;

// Allow general certificate
//$_configuration['allow_general_certificate'] = false;

// Allow exercise categories
// CREATE TABLE c_exercise_category (id BIGINT AUTO_INCREMENT NOT NULL, c_id INT NOT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, position INT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
// ALTER TABLE c_quiz ADD exercise_category_id INT DEFAULT NULL;
// enable @ORM in CExerciseCategory adn CQuiz::exerciseCategoryId
//$_configuration['allow_exercise_categories'] = false;

// Send new user inscription notification only to general admins (table settings_current = emailAdministrator)
//$_configuration['send_inscription_notification_to_general_admin_only'] = false;

// Allow extra settings for the quiz results page
// ALTER TABLE c_quiz ADD page_result_configuration LONGTEXT DEFAULT NULL COMMENT '(DC2Type:array)';
//$_configuration['allow_quiz_results_page_config'] = false;

// Allow multiple options for the exercise "save answer" option
// ALTER TABLE c_quiz MODIFY COLUMN save_correct_answers INT NULL DEFAULT NULL;
//$_configuration['allow_quiz_save_correct_options'] = false;

// Show languages flags by country in the language switcher.
//$_configuration['language_flags_by_country'] = false;

// Allow compilatio plagiarism prevention tool
/*
CREATE TABLE c_plagiarism_compilatio_docs (
    id INT AUTO_INCREMENT NOT NULL,
    c_id int(11) NOT NULL,
    document_id int(11) NOT NULL,
    compilatio_id varchar(32) CHARACTER SET utf8 NOT NULL,
    PRIMARY KEY (id)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;

// If table exists already
ALTER TABLE c_plagiarism_compilatio_docs drop primary key;
ALTER TABLE c_plagiarism_compilatio_docs ADD COLUMN id INT AUTO_INCREMENT NOT NULL PRIMARY KEY;
ALTER TABLE c_plagiarism_compilatio_docs CHANGE COLUMN id_doc document_id INT NOT NULL;

requires extension "php-soap"  sudo apt-get install php-soap
*/
//$_configuration['allow_compilatio_tool'] = false;
/*$_configuration['compilatio_tool'] = [
    'settings' => [
        'key' => '',
        'soap_url' => '',
        'proxy_host' => '',
        'proxy_port' => '',
        'max_filesize' => '',
        'transport_mode' => '',
        'wget_uri' => '',
        'wget_login' => '',
        'wget_password' => '',
    ]
];*/

// Allow user to enter a LP item if it was validated in another session.
// $_configuration['validate_lp_prerequisite_from_other_session'] = false;

// 1 = SCORE_AVERAGE (5 / 10)
// 2 = SCORE_PERCENT (50%)
// 3 = SCORE_DIV_PERCENT (5 / 10 (50%))
// $_configuration['exercise_score_format'] = 0;

// Hide course sidebar
//$_configuration['hide_course_sidebar'] = true;

// Allow online users by user profile
// 1 = COURSEMANAGER (teacher)
// 5 = STUDENT
// 11 = PLATFORM_ADMIN
// Example: The online users will be available only for teachers and students.
//$_configuration['allow_online_users_by_status'] = ['status' =>  [1, 5]];

// Allow add one column by each user extra field indicated to the Gradebook Flatview for each user.
// $_configuration['gradebook_flatview_extrafields_columns'] = ['variables' => []];

// Show hidden exercises that were added to a LP in the exercise list
// $_configuration['show_hidden_exercise_added_to_lp'] = true;

// Show full lp item title
// $_configuration['show_full_lp_item_title_in_edition'] = false;

// Hide course catalog welcome message
//$_configuration['hide_course_catalog_welcome'] = true;

// Survey
// ALTER TABLE c_survey_question ADD parent_id INT(11) DEFAULT 0 NOT NULL;
// ALTER TABLE c_survey_question ADD parent_option_id INT(11) DEFAULT 0 NOT NULL;
//$_configuration['survey_question_dependency'] = true;

// Student publication: force to download document before upload an assignment.
// $_configuration['force_download_doc_before_upload_work' ] = true;

// Allow teachers to decide which skills are assigned through their courses
// $_configuration['skills_teachers_can_assign_skills'] = false;

// Changes the ck editor enter mode value. Default: CKEDITOR.ENTER_P
// $_configuration['ck_editor_enter_mode_value'] = 'CKEDITOR.ENTER_BR';
// Set CKEDITOR config for Vimeo Embed plugin
//$_configuration['ckeditor_vimeo_embed'] = [
//    'config' => [
//        'client_id' => '',
//        'client_secret' => '',
//        'access_token' => '',
//    ],
//];

// CREATE TABLE user_career (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, career_id INT NOT NULL, created_at DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB;
// ALTER TABLE user_career ADD COLUMN extra_data LONGTEXT;
// ALTER TABLE user_career ADD COLUMN updated_at DATETIME NOT NULL;
// $_configuration['allow_career_users'] = false;

// LP view menu location. Options: "left" or "right"
// $_configuration['lp_menu_location'] = 'left';

// Show notification events
/*CREATE TABLE IF NOT EXISTS notification_event (
id INT unsigned NOT NULL auto_increment PRIMARY KEY,
        title VARCHAR(255),
        content TEXT,
        link TEXT,
        persistent INT,
        day_diff INT,
        event_type VARCHAR(255)
    );
ALTER TABLE notification_event ADD COLUMN event_id INT NULL;
*/
// create new user text extra field called 'notification_event' to save the persistent settings.
// $_configuration['notification_event'] = false;

// Add help text to put 2 names in registration form
//$_configuration['registration_add_helptext_for_2_names'] = false;

// Allow career/promotions in global announcements
// ALTER TABLE sys_announcement ADD COLUMN career_id INT DEFAULT 0;
// ALTER TABLE sys_announcement ADD COLUMN promotion_id INT DEFAULT 0;
//$_configuration['allow_careers_in_global_announcements'] = false;

// Hide start/end dates in "My courses" page (user_portal.php)
//$_configuration['hide_session_dates_in_user_portal'] = false;

// Catalog search settings visibility
/*$_configuration['catalog_settings'] = [
    'sessions' => [
        'by_title' => true,
        'by_date' => true,
        'by_tag' => true,
        'show_session_info' => true,
        'show_session_date' => true,
    ],
    'courses' => [
        'by_title' => true,
    ],
];*/

// Enable learning paths with only one SCO item to use the score returned by
// the SCO as an indicator of progress of the whole learning path
// Before enabling, make sure you added an LP extra field of type int, called use_score_as_progress
// $_configuration['lp_score_as_progress_enable'] = false;

// Use this link as the "Forgot password?" link instead of the default. This setting should be transformed into a hook for plugins at a later time
//$_configuration['pass_reminder_custom_link'] = '';

// In Scorm comunication use the username instead of the user_id
//$_configuration['scorm_api_username_as_student_id'] = false;

// Zoom in description images quiz
// $_configuration['quiz_image_zoom'] = [
//    'options' => [
//          'zoomWindowWidth' => 400,
//          'zoomWindowHeight' => 400,
//     ]
// ];

// In Scorm comunication use a specific extra field instead of the user_id
//$_configuration['scorm_api_extrafield_to_use_as_student_id'] = '';

// Show online user only to Administrators
//$_configuration['whoisonline_only_for_admin'] = false;

// Prevent going back to previous questions
// ALTER TABLE c_quiz ADD COLUMN prevent_backwards INT DEFAULT 0;
//$_configuration['quiz_prevent_backwards_move'] = false;

// Allow third party plugins to be uploaded through a form in the plugins section
//$_configuration['plugin_upload_enable'] = false;

// ALTER TABLE session ADD COLUMN status INT DEFAULT 0;
// $_configuration['allow_session_status'] = false;

// Set the default tab in the admin session list. Values: all, close, active, custom.
//$_configuration['default_session_list_view'] = 'all';

// Search user by extra field in the user list.
//$_configuration['user_search_on_extra_fields'] = ['extra_fields' => ['variable1', 'variable2']];

// user subscription to a session rather than to a base course
// user session is created at first subscription
//$_configuration['catalog_course_subscription_in_user_s_session'] = false;
// user session duration in days - after the session end date, more subscriptions are prevented
//$_configuration['user_s_session_duration'] = 3*365;
// id of the admin to attach user session
//$_configuration['session_automatic_creation_user_id'] = 1;

// Skip scorm package file names clean up
//$_configuration['skip_scorm_package_clean_up'] = false;

// Course chat: Send message on button click only, if false then send on enter too.
//$_configuration['course_chat_send_message_only_on_button'] = true;

// Course catalog show extra fields (visible and filtered)
//$_configuration['allow_course_extra_field_in_catalog'] = false;

// Course catalog links behaviour.
/*
$_configuration['course_catalog_settings'] = [
    'link_settings' => [
        'info_url' => 'course_description_popup', // course description popup page
        'title_url' => 'course_home', // Course home URL
        'image_url' => 'course_about', // Course about URL
    ],
    'hide_course_title'
    'redirect_after_subscription' => 'course_home', // or 'course_catalog' to stay in the page
    'extra_fields_in_search_form' => ['variable1', 'variable2'],
    'extra_fields_in_course_block' => ['variable3', 'variable4'],
    'standard_sort_options' => [
        //  1 means allow sorting in ascending order
        // -1 means allow sorting in descending order
        'title' => 1,
        'creation_date' => -1,
        'count_users' => -1, // subscription count
        'point_info/point_average' => -1, // average score
        'point_info/total_score' => -1, // score sum
        'point_info/users' => -1, // vote count
    ],
    'extra_field_sort_options' => [
        'variable5' => -1,
        'variable6' => 1,
    ],
];
*/

// Page "My Courses" shows specific course extra fields (CourseManager::getExtraFieldsToBePresented)
/*$_configuration['my_course_course_extrafields_to_be_presented'] = [
    'fields' => ['mots_cles', 'duree_en_min', 'format'],
];*/

// Disable fields to add an attachment when creating and announcement.
//$_configuration['disable_announcement_attachment'] = false;

// Disable sending emails.
//$_configuration['disable_send_mail'] = false;

// CKEditor font names
/*$_configuration['ck_editor_font_names'] = [
    'names' => [
        'Arial' => 'Arial, Helvetica, sans-serif',
        'Comic Sans MS' => 'Comic Sans MS, cursive',
        'Courier New' => 'Courier New, Courier, monospace',
        'Georgia' => 'Georgia, serif',
        'Lucida Sans Unicode' => 'Lucida Sans Unicode, Lucida Grande, sans-serif',
        'Tahoma' => 'Tahoma, Geneva, sans-serif',
        'Times New Roman' => 'Times New Roman, Times, serif',
        'Trebuchet MS' => 'Trebuchet MS, Helvetica, sans-serif',
        'Verdana' => 'Verdana, Geneva, sans-serif',
    ]
];*/

/* Show download files button after finishing all LP. Example: ABC is the course code, and 1 and 100 are the doc id
$_configuration['download_files_after_all_lp_finished'] = ['courses' => ['ABC' => [1, 100]]];
*/

// Show/Hide password field in user profile. Adds a customizable link depending on the user status.
/*
$_configuration['auth_password_links'] = [
    'profiles' => [
        5 => [
            'azure' => [
                'show_password_field' => false,
                'extra_link' => '<h4>Change!</h4><a href="www.example.com">Wachtwoord aanpassen</span></a>'
            ],
            'extldap' => [
                'show_password_field' => true,
                'extra_link' => '<h4>Change!</h4><a href="www.example.com">Wachtwoord aanpassen</span></a>'
            ]
        ]
    ]
];
*/

// Show unsubscribe buttons on page "My courses"
//$_configuration['enable_unsubscribe_button_on_my_course_page'] = false;

// Allow LP category in sessions.
// ALTER TABLE c_lp_category ADD COLUMN session_id INT(11) DEFAULT NULL;
//$_configuration['allow_session_lp_category'] = false;

// Enable recording of all answers (even temporary) in the track_e_attempt_recording table
// This requires a column to be added to the table with the following query:
// ALTER TABLE track_e_attempt_recording ADD COLUMN answer longtext default '' AFTER question_id;
//$_configuration['quiz_answer_extra_recording'] = false;

// Disable clean results for teachers
// $_configuration['disable_clean_exercise_results_for_teachers'] = true;

// Show certainty degree question result in Exercises
// $_configuration['show_exercise_question_certainty_ribbon_result'] = false;

//Allows to add increment in minutes to the date range component timepicker, example: 5,10,30 minutes
//$_configuration['timepicker_increment'] = 5;

//Allows teachers to edit survey questions after students have answered them
//$_configuration['survey_allow_answered_question_edit'] = false;

// Allows prevent to the user before leaving a learning path
//$_configuration['lp_prevents_beforeunload'] = false;

// Disable slideshow documents
//$_configuration['disable_slideshow_documents'] = false;

// Disable search documents
//$_configuration['disable_search_documents'] = false;

// Disable available space in the document tool
//$_configuration['disable_document_quota_message_for_students'] = false;

// Show a donation suggestion message on the course creation page
//$_configuration['course_creation_donate_message_show'] = false;
//$_configuration['course_creation_donate_link'] = '<some donate button html>';

// Allow my student publications page
//$_configuration['allow_my_student_publication_page'] = false;

// Show handpicked "popular" courses on the home page instead of users-chosen
// courses.
// Create an extra field for courses called "popular_courses" (type CHECKBOX) OR
// INSERT extra_field (extra_field_type, field_type, variable, display_text, visible_to_self, changeable, created_at)
// VALUES (2, 13, 'popular_courses', 'Popular course', 1, 1, NOW());
// $_configuration['popular_courses_handpicked'] = false;

// Default items per page in main/mySpace/users.php
// $_configuration['my_space_users_items_per_page'] = 10;

// Add teachers column in course list.
// $_configuration['add_teachers_in_course_list'] = false;

// Allow teachers and admins to see students as friends on social network
// $_configuration['social_make_teachers_friend_all'] = false;

// Prevent the use of images copy-paste as base64 in the editor to avoid
// filling the database with images
//$_configuration['ck_editor_block_image_copy_paste'] = false;

// Shows a link to the "my lps" page in the /index.php and /user_portal.php page.
// It also enables the main/lp/my_list.php page.
//$_configuration['show_my_lps_page'] = false;

// Disables access to the main/lp/my_list.php page
//$_configuration['disable_my_lps_page'] = false;

// When exercise is finished send results by email to users, depending the settings below:
// Requires a new Exercise Extra field type called with variable = "notifications".
/*$_configuration['exercise_finished_notification_settings'] = [
    'notification_teacher' => [ // Notification label
        'for teacher' => [ // for teacher
            'send_notification_if_user_in_extra_field' => [
                'company_variable' => ['Company A', 'Company B'],
            ],
            'email' => 'teacher1@example.com,teacher2@example.com', // multiple emails allowed
            'attempts' => [
                [
                    'is_block_by_percentage' => true,
                    'status' => 'passed', // passed/failed/all (depends in the exercise pass %)
                    'content' => 'MailAttemptPassed', // exercise extra field
                    'content_default' => 'Hi, ((user_lastname)) ', // value if MailAttemptPassed is empty
                    'add_pdf' => 'PdfExerciseExtraField', // exercise extra field
                ],
                [
                    'status' => 'failed',
                    'content' => 'MailAttemptFailed',
                ],
                [
                    'status' => 'all',
                    'content' => 'MailAttemptAll',
                ],
                [
                    'status' => 'all',
                    'attempt' => 1,
                    'content' => 'MailAttemptAttempt1', // exercise extra field,
                ],
                [
                    'status' => 'failed',
                    'attempt' => 2,
                    'content' => 'MailAttemptFailed2', // exercise extra field,
                    // if Exercise failed and attempt = 2 then the student will be subscribe to course code:
                    'post_actions' => [
                        'subscribe_student_to_courses' => ['SECOND_ATTEMPT'],
                    ],
                ],
            ],
        ],
        'for admin' => [
            'email' => 'admin@example.com',
            'attempts' => [
                [
                    'status' => 'failed',
                    'content' => 'MailAttemptFailed',
                ],
            ],
        ],
    ],
    'notification_coach' => [ // Label
        'for coach ' => [ // for teacher
            'email' => 'coach@example.com',
            'attempts' => [
                [
                    'status' => 'passed',
                    'content' => 'MailAttemptPassed', // exercise extra field,
                ],
                [
                    'status' => 'failed',
                    'content' => 'MailAttemptFailed', // exercise extra field,
                ],
            ],
        ],
    ],
];*/

// Shows a marker if the course was shared in other portals.
//$_configuration['multiple_access_url_show_shared_course_marker'] = false;

// Add option to copy a session with its course-session content BT#17832
//$_configuration['duplicate_specific_session_content_on_session_copy'] = false;

// Allow add usergroups to a LP BT#17854
//CREATE TABLE c_lp_rel_usergroup (id INT AUTO_INCREMENT NOT NULL, lp_id INT NOT NULL, usergroup_id INT NOT NULL, c_id INT NOT NULL, session_id INT, created_at DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB;
//CREATE TABLE c_lp_category_rel_usergroup (id INT AUTO_INCREMENT NOT NULL, lp_category_id INT NOT NULL, usergroup_id INT NOT NULL, c_id INT NOT NULL, session_id INT, created_at DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB;
//$_configuration['allow_lp_subscription_to_usergroups'] = false;

// Gradebook student pdf export settings
/*$_configuration['gradebook_pdf_export_settings'] = [
    'hide_score_weight' => true,
    'hide_feedback_textarea' => true,
];*/

// Use exercise score in platform settings in gradebook total rows/columns.
//$_configuration['gradebook_use_exercise_score_settings_in_total'] = false;

// Use exercise score in platform settings in gradebook total rows/columns.
//$_configuration['gradebook_use_exercise_score_settings_in_total'] = false;

// Show a link on the results page to download an answers report
//$_configuration['quiz_results_answers_report'] = false;

// Hide the breadcrumb navigation (for example if you don't want users to go
// sniffing around a specific course). Should be combined with hiding the menu
//$_configuration['breadcrumb_hide'] = false;

// Hide the sidebar completely to avoid users navigating away.
// Warning: this currently leaves a weird empty space where the sidebar should
// be. We recommend using this only in very specific circumstances.
//$_configuration['sidebar_hide'] = false;

// Block question categories BT#17789
//ALTER TABLE track_e_exercises ADD COLUMN blocked_categories LONGTEXT;
// Requires an exercise extra field "block_category" type checkbox (Yes)
//$_configuration['block_category_questions'] = false;

// Make questions mandatory selectable when using question select type = 5 (category-random)
//ALTER TABLE c_quiz_question_rel_category ADD COLUMN mandatory INT DEFAULT 0;
//$_configuration['allow_mandatory_question_in_category'] = false;

// Resource sequence: Validate course in the same session.
//$_configuration['course_sequence_valid_only_in_same_session'] = false;

// Allow time per question. BT#17791
// Requires a question text extra field called "time", value in seconds.
// ALTER TABLE track_e_attempt ADD COLUMN seconds_spent INT;
//$_configuration['allow_time_per_question'] = true;

// Disable change user visibility tool icon.
//$_configuration['disable_change_user_visibility_for_public_courses'] = true;

// Add another layer of security by checking if the user is disabled at every page load (might generate considerable extra DB load)
// $_configuration['security_block_inactive_users_immediately'] = false;

// Allow all office suite documents to be uploaded in the "My files" section of the social network
//$_configuration['social_myfiles_office_files_upload_allowed'] = false;

// Enable a "Previous question" button in surveys
// $_configuration['survey_backwards_enable'] = false;

// All courses with category MY_CATEGORY will be used as course templates BT#18083
// $_configuration['course_category_code_to_use_as_model'] = 'MY_CATEGORY';

// Shows the best exercise score attempt for a student in the reports.
/*$_configuration['add_exercise_best_attempt_in_report'] = [
    'courses' => [
        'ABC' => [88, 89], // Where ABC is the course code and 88 is the exercise id
    ]
];*/

// KEEP THIS AT THE END
// -------- Custom DB changes
// Add user activation by confirmation email
// This option prevents the new user to login in the platform if your account is not confirmed via email
// You need add a new option called "confirmation" to the registration settings
//INSERT INTO settings_options (variable, value, display_text) VALUES ('allow_registration', 'confirmation', 'MailConfirmation');
// ------ (End) Custom DB changes
