/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;

public class UnoUrl {
    private static final String FORMAT_ERROR = "syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname";
    private static final String VALUE_CHAR_SET = "!$&'()*+-./:?@_~";
    private static final String OID_CHAR_SET = "!$&'()*+-./:?@_~,=";
    private UnoUrlPart connection;
    private UnoUrlPart protocol;
    private String rootOid;

    private UnoUrl(UnoUrlPart unoUrlPart, UnoUrlPart unoUrlPart2, String string) {
        this.connection = unoUrlPart;
        this.protocol = unoUrlPart2;
        this.rootOid = string;
    }

    public String getConnection() {
        return this.connection.getPartTypeName();
    }

    public String getProtocol() {
        return this.protocol.getPartTypeName();
    }

    public String getRootOid() {
        return this.rootOid;
    }

    public HashMap getProtocolParameters() {
        return this.protocol.getPartParameters();
    }

    public HashMap getConnectionParameters() {
        return this.connection.getPartParameters();
    }

    public String getProtocolParametersAsString() {
        return this.protocol.getUninterpretedParameterString();
    }

    public String getConnectionParametersAsString() {
        return this.connection.getUninterpretedParameterString();
    }

    public String getProtocolAndParametersAsString() {
        return this.protocol.getUninterpretedString();
    }

    public String getConnectionAndParametersAsString() {
        return this.connection.getUninterpretedString();
    }

    private static int hexToInt(int n) throws IllegalArgumentException {
        boolean bl;
        char c = Character.toLowerCase((char)n);
        boolean bl2 = '0' <= c && c <= '9';
        boolean bl3 = bl = 'a' <= c && c <= 'f' || bl2;
        if (!bl) {
            throw new IllegalArgumentException("Invalid UTF-8 hex byte '" + c + "'.");
        }
        return bl2 ? n - 48 : 10 + ((char)c - 97) & 0xF;
    }

    private static String decodeUTF8(String string) throws IllegalArgumentException {
        int n;
        int n2;
        Vector<Integer> vector = new Vector<Integer>();
        for (n2 = 0; n2 < string.length(); ++n2) {
            int n3 = string.charAt(n2);
            if (n3 == 37) {
                n = UnoUrl.hexToInt(string.charAt(++n2));
                int n4 = UnoUrl.hexToInt(string.charAt(++n2));
                n3 = n << 4 | n4;
            }
            vector.addElement(new Integer(n3));
        }
        n2 = vector.size();
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            Integer n5 = (Integer)vector.elementAt(n);
            byArray[n] = (byte)(n5 & 0xFF);
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Couldn't convert parameter string to UTF-8 string:" + unsupportedEncodingException.getMessage());
        }
    }

    private static HashMap buildParamHashMap(String string) throws IllegalArgumentException {
        char c;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        do {
            c = ',';
            String string2 = "";
            String string3 = "";
            while (n < string.length()) {
                char c2 = string.charAt(n++);
                c = c2;
                if (c2 == '=') break;
                string2 = string2 + c;
            }
            while (n < string.length()) {
                char c3 = string.charAt(n++);
                c = c3;
                if (c3 == ',' || c == 59) break;
                string3 = string3 + c;
            }
            if (string2.length() <= 0 || string3.length() <= 0) continue;
            if (!UnoUrl.isAlphaNumeric(string2)) {
                throw new IllegalArgumentException("The parameter key '" + string2 + "' may only consist of alpha numeric ASCII characters.");
            }
            if (!UnoUrl.isValidString(string3, "!$&'()*+-./:?@_~%")) {
                throw new IllegalArgumentException("The parameter value for key '" + string2 + "' contains illegal characters.");
            }
            hashMap.put(string2, UnoUrl.decodeUTF8(string3));
        } while (n < string.length() && c == 44);
        return hashMap;
    }

    private static UnoUrlPart parseUnoUrlPart(String string) throws IllegalArgumentException {
        String string2 = string;
        String string3 = "";
        int n = string.indexOf(",");
        if (n != -1) {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
        }
        if (!UnoUrl.isAlphaNumeric(string2)) {
            throw new IllegalArgumentException("The part name '" + string2 + "' may only consist of alpha numeric ASCII characters.");
        }
        HashMap hashMap = UnoUrl.buildParamHashMap(string3);
        return new UnoUrlPart(string3, string2, hashMap);
    }

    private static boolean isAlphaNumeric(String string) {
        return UnoUrl.isValidString(string, null);
    }

    private static boolean isValidString(String string, String string2) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = string.charAt(i);
            boolean bl2 = bl = 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9';
            if (!bl && string2 != null) {
                boolean bl3 = bl = string2.indexOf(c) != -1;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static UnoUrl parseUnoUrl(String string) throws IllegalArgumentException {
        String string2;
        String string3 = string;
        int n = string3.indexOf(58);
        if (n != -1 && !"uno".equals(string2 = string3.substring(0, n).trim())) {
            throw new IllegalArgumentException("Uno Urls must start with 'uno:'. syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname");
        }
        if ((n = (string3 = string3.substring(n + 1).trim()).indexOf(59)) == -1) {
            throw new IllegalArgumentException("'" + string + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        string2 = string3.substring(0, n).trim();
        string3 = string3.substring(n + 1).trim();
        UnoUrlPart unoUrlPart = UnoUrl.parseUnoUrlPart(string2);
        n = string3.indexOf(59);
        if (n == -1) {
            throw new IllegalArgumentException("'" + string + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        String string4 = string3.substring(0, n).trim();
        string3 = string3.substring(n + 1).trim();
        UnoUrlPart unoUrlPart2 = UnoUrl.parseUnoUrlPart(string4);
        String string5 = string3.trim();
        if (!UnoUrl.isValidString(string5, OID_CHAR_SET)) {
            throw new IllegalArgumentException("Root OID '" + string5 + "' contains illegal characters.");
        }
        return new UnoUrl(unoUrlPart, unoUrlPart2, string5);
    }

    private static class UnoUrlPart {
        private String partTypeName;
        private HashMap partParameters;
        private String uninterpretedParameterString;

        public UnoUrlPart(String string, String string2, HashMap hashMap) {
            this.uninterpretedParameterString = string;
            this.partTypeName = string2;
            this.partParameters = hashMap;
        }

        public String getPartTypeName() {
            return this.partTypeName;
        }

        public HashMap getPartParameters() {
            return this.partParameters;
        }

        public String getUninterpretedParameterString() {
            return this.uninterpretedParameterString;
        }

        public String getUninterpretedString() {
            StringBuffer stringBuffer = new StringBuffer(this.partTypeName);
            if (this.uninterpretedParameterString.length() > 0) {
                stringBuffer.append(',');
                stringBuffer.append(this.uninterpretedParameterString);
            }
            return stringBuffer.toString();
        }
    }
}

