/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.AccessibleRelation;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JLabel;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class Table
extends DescendantManager
implements Accessible {
    protected Table(XAccessible xAccessible, XAccessibleContext xAccessibleContext, boolean bl) {
        super(xAccessible, xAccessibleContext, bl);
    }

    protected void setActiveDescendant(Accessible accessible) {
        Accessible accessible2 = this.activeDescendant;
        this.activeDescendant = accessible;
        this.firePropertyChange("AccessibleActiveDescendant", accessible2, accessible);
    }

    protected void setActiveDescendant(Object object) {
        TableCell tableCell = null;
        try {
            XAccessible xAccessible;
            if (AnyConverter.isObject((Object)object) && (xAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object)) != null) {
                tableCell = new TableCell(this, xAccessible);
            }
            this.setActiveDescendant(tableCell);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void add(XAccessible xAccessible) {
        if (xAccessible != null) {
            TableCell tableCell = new TableCell(this, xAccessible);
            this.firePropertyChange("AccessibleChild", null, tableCell.getAccessibleContext());
        }
    }

    protected void remove(XAccessible xAccessible) {
        if (xAccessible != null) {
            TableCell tableCell = new TableCell(this, xAccessible);
            this.firePropertyChange("AccessibleChild", tableCell.getAccessibleContext(), null);
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTableListener(this);
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleTable(this);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TableCell
    extends Component
    implements Accessible {
        private /* synthetic */ Table this$0;
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext;

        private /* synthetic */ void finit$() {
            this.accessibleContext = null;
        }

        static Table access$0(TableCell tableCell) {
            return tableCell.this$0;
        }

        public TableCell(Table table, XAccessible xAccessible) {
            this.this$0 = table;
            this.finit$();
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] objectArray) {
            try {
                ArrayList<TableCell> arrayList = new ArrayList<TableCell>(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface((Class)Table.class$("com.sun.star.accessibility.XAccessible"), (Object)objectArray[i]);
                    if (xAccessible == null) continue;
                    arrayList.add(new TableCell(this.this$0, xAccessible));
                }
                arrayList.trimToSize();
                return arrayList.toArray();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                try {
                    AccessibleTableCell accessibleTableCell;
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null && (accessibleTableCell = new AccessibleTableCell(this, xAccessibleContext)) != null) {
                        accessibleTableCell.setAccessibleParent(this.this$0);
                        this.accessibleContext = accessibleTableCell;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.accessibleContext;
        }

        protected class AccessibleTableCell
        extends AccessibleContext {
            private /* synthetic */ TableCell this$1;
            XAccessibleContext unoAccessibleContext;

            public AccessibleTableCell(TableCell tableCell, XAccessibleContext xAccessibleContext) {
                this.this$1 = tableCell;
                this.unoAccessibleContext = xAccessibleContext;
            }

            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleName(String string) {
            }

            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleDescription(String string) {
            }

            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole accessibleRole = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    if (accessibleRole != null) {
                        return accessibleRole;
                    }
                    return AccessibleRole.LABEL;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale locale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(locale.Language, locale.Country);
                }
                catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                    throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    return TableCell.access$0(this.this$1).getLocale();
                }
            }

            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException runtimeException) {
                    return -1;
                }
            }

            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            public Accessible getAccessibleChild(int n) {
                Accessible accessible = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    Accessible accessible2 = TableCell.access$0((TableCell)this.this$1).activeDescendant;
                    if (accessible2 instanceof TableCell && ((TableCell)accessible2).unoAccessible.equals(xAccessible)) {
                        accessible = accessible2;
                    } else if (xAccessible != null) {
                        accessible = new TableCell(TableCell.access$0(this.this$1), xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return accessible;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    return AccessibleStateAdapter.getAccessibleStateSet(this.this$1, this.unoAccessibleContext.getAccessibleStateSet());
                }
                catch (RuntimeException runtimeException) {
                    return AccessibleStateAdapter.getDefunctStateSet();
                }
            }

            public AccessibleRelationSet getAccessibleRelationSet() {
                try {
                    XAccessibleRelationSet xAccessibleRelationSet = this.unoAccessibleContext.getAccessibleRelationSet();
                    if (xAccessibleRelationSet == null) {
                        return null;
                    }
                    AccessibleRelationSet accessibleRelationSet = new AccessibleRelationSet();
                    int n = xAccessibleRelationSet.getRelationCount();
                    block10: for (int i = 0; i < n; ++i) {
                        AccessibleRelation accessibleRelation = xAccessibleRelationSet.getRelation(i);
                        switch (accessibleRelation.RelationType) {
                            case 3: {
                                accessibleRelationSet.add(new javax.accessibility.AccessibleRelation("controlledBy", this.this$1.create(accessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 4: {
                                accessibleRelationSet.add(new javax.accessibility.AccessibleRelation("controllerFor", this.this$1.create(accessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 6: {
                                accessibleRelationSet.add(new javax.accessibility.AccessibleRelation("labeledBy", this.this$1.create(accessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 5: {
                                accessibleRelationSet.add(new javax.accessibility.AccessibleRelation("labelFor", this.this$1.create(accessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 7: {
                                accessibleRelationSet.add(new javax.accessibility.AccessibleRelation("memberOf", this.this$1.create(accessibleRelation.TargetSet)));
                                continue block10;
                            }
                        }
                    }
                    return accessibleRelationSet;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)Table.class$("com.sun.star.accessibility.XAccessibleComponent"), (Object)this.unoAccessibleContext);
                    if (xAccessibleComponent != null) {
                        return new AccessibleComponentImpl(xAccessibleComponent);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface((Class)Table.class$("com.sun.star.accessibility.XAccessibleAction"), (Object)this.unoAccessibleContext);
                    if (xAccessibleAction != null) {
                        return new AccessibleActionImpl(xAccessibleAction);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleText getAccessibleText() {
                if (TableCell.access$0((TableCell)this.this$1).disposed) {
                    return null;
                }
                try {
                    XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface((Class)Table.class$("com.sun.star.accessibility.XAccessibleText"), (Object)this.unoAccessibleContext);
                    if (xAccessibleText != null) {
                        return new AccessibleTextImpl(xAccessibleText);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface((Class)Table.class$("com.sun.star.accessibility.XAccessibleValue"), (Object)this.unoAccessibleContext);
                    if (xAccessibleValue != null) {
                        return new AccessibleValueImpl(xAccessibleValue);
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage xAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface((Class)Table.class$("com.sun.star.accessibility.XAccessibleImage"), (Object)this.unoAccessibleContext);
                    if (xAccessibleImage != null) {
                        AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{new AccessibleIconImpl(xAccessibleImage)};
                        return accessibleIconArray;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    protected class AccessibleTable
    extends DescendantManager.AccessibleDescendantManager
    implements AccessibleExtendedTable {
        private /* synthetic */ Table this$0;
        protected XAccessibleTable unoAccessibleTable;

        public AccessibleTable(Table table) {
            this.this$0 = table;
            super(table);
            this.unoAccessibleTable = (XAccessibleTable)UnoRuntime.queryInterface((Class)Table.class$("com.sun.star.accessibility.XAccessibleTable"), (Object)table.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public javax.accessibility.AccessibleTable getAccessibleTable() {
            return this;
        }

        public Accessible getAccessibleChild(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.this$0.unoAccessibleContext.getAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TableCell && xAccessible.equals(((TableCell)accessible2).unoAccessible) ? accessible2 : new TableCell(this.this$0, xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.this$0.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y));
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TableCell && xAccessible.equals(((TableCell)accessible2).unoAccessible) ? accessible2 : new TableCell(this.this$0, xAccessible);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleSelection(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.this$0.unoAccessibleSelection.getSelectedAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TableCell && xAccessible.equals(((TableCell)accessible2).unoAccessible) ? accessible2 : new TableCell(this.this$0, xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleAt(int n, int n2) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = this.unoAccessibleTable.getAccessibleCellAt(n, n2);
                if (xAccessible != null) {
                    Accessible accessible2 = this.this$0.activeDescendant;
                    accessible = accessible2 instanceof TableCell && xAccessible.equals(((TableCell)accessible2).unoAccessible) ? accessible2 : new TableCell(this.this$0, xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleCaption() {
            return null;
        }

        public int getAccessibleColumnCount() {
            try {
                return this.unoAccessibleTable.getAccessibleColumnCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public Accessible getAccessibleColumnDescription(int n) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleColumnDescription(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public int getAccessibleColumnExtentAt(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleColumnExtentAt(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0;
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public javax.accessibility.AccessibleTable getAccessibleColumnHeader() {
            return null;
        }

        public int getAccessibleRowCount() {
            try {
                return this.unoAccessibleTable.getAccessibleRowCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public Accessible getAccessibleRowDescription(int n) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleRowDescription(n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public int getAccessibleRowExtentAt(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleRowExtentAt(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0;
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public javax.accessibility.AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public Accessible getAccessibleSummary() {
            return null;
        }

        public int[] getSelectedAccessibleColumns() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleColumns();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public int[] getSelectedAccessibleRows() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleRows();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public boolean isAccessibleColumnSelected(int n) {
            try {
                return this.unoAccessibleTable.isAccessibleColumnSelected(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public boolean isAccessibleRowSelected(int n) {
            try {
                return this.unoAccessibleTable.isAccessibleRowSelected(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public boolean isAccessibleSelected(int n, int n2) {
            try {
                return this.unoAccessibleTable.isAccessibleSelected(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public void setAccessibleCaption(Accessible accessible) {
        }

        public void setAccessibleColumnDescription(int n, Accessible accessible) {
        }

        public void setAccessibleColumnHeader(javax.accessibility.AccessibleTable accessibleTable) {
        }

        public void setAccessibleRowDescription(int n, Accessible accessible) {
        }

        public void setAccessibleRowHeader(javax.accessibility.AccessibleTable accessibleTable) {
        }

        public void setAccessibleSummary(Accessible accessible) {
        }

        public int getAccessibleColumn(int n) {
            try {
                return this.unoAccessibleTable.getAccessibleColumn(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        public int getAccessibleIndex(int n, int n2) {
            try {
                return this.unoAccessibleTable.getAccessibleIndex(n, n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        public int getAccessibleRow(int n) {
            try {
                return this.unoAccessibleTable.getAccessibleRow(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }
    }

    protected class AccessibleTableListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        private /* synthetic */ Table this$0;

        protected AccessibleTableListener(Table table) {
            this.this$0 = table;
            super(table);
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 5: {
                    this.this$0.setActiveDescendant(accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        this.this$0.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    this.this$0.add(accessibleEventObject.NewValue);
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

