/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Build;
import org.openoffice.java.accessibility.NativeFrame;

public class Frame
extends java.awt.Frame
implements Accessible,
NativeFrame {
    protected XAccessibleComponent unoAccessibleComponent;
    boolean opened;
    boolean visible;
    boolean active;
    EventQueue eventQueue;
    Component initialComponent;
    protected AccessibleContext accessibleContext;

    private /* synthetic */ void finit$() {
        this.opened = false;
        this.visible = false;
        this.active = false;
        this.eventQueue = null;
        this.initialComponent = null;
        this.accessibleContext = null;
    }

    protected Frame(XAccessibleComponent xAccessibleComponent) {
        this.finit$();
        this.initialize(xAccessibleComponent);
    }

    protected Frame(String string, XAccessibleComponent xAccessibleComponent) {
        super(string);
        this.finit$();
        this.initialize(xAccessibleComponent);
    }

    private void initialize(XAccessibleComponent xAccessibleComponent) {
        this.unoAccessibleComponent = xAccessibleComponent;
        this.eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface((Class)Frame.class$("com.sun.star.accessibility.XAccessibleEventBroadcaster"), (Object)this.unoAccessibleComponent);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener((XAccessibleEventListener)new AccessibleFrameListener(this));
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Component getInitialComponent() {
        return this.initialComponent;
    }

    public void setInitialComponent(Component component) {
        this.initialComponent = component;
    }

    public Integer getHWND() {
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (bl) {
                if (!this.opened) {
                    this.postWindowEvent(200);
                    this.opened = true;
                }
                this.postComponentEvent(102);
            } else {
                this.postComponentEvent(103);
            }
        }
    }

    public void dispose() {
        this.setVisible(false);
        this.postWindowEvent(202);
    }

    protected void postWindowEvent(int n) {
        this.eventQueue.postEvent(new WindowEvent(this, n));
    }

    protected void postComponentEvent(int n) {
        this.eventQueue.postEvent(new ComponentEvent(this, n));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFrame(this);
            this.accessibleContext.setAccessibleName(this.getTitle());
        }
        return this.accessibleContext;
    }

    protected class AccessibleFrame
    extends Frame.AccessibleAWTFrame {
        private /* synthetic */ Frame this$0;
        protected ComponentListener accessibleComponentHandler;
        protected WindowListener accessibleWindowHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        private /* synthetic */ void finit$() {
            this.accessibleComponentHandler = null;
            this.accessibleWindowHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        static /* synthetic */ Frame access$3(AccessibleFrame accessibleFrame, Frame frame) {
            accessibleFrame.this$0 = frame;
            return accessibleFrame.this$0;
        }

        static Frame access$0(AccessibleFrame accessibleFrame) {
            return accessibleFrame.this$0;
        }

        protected AccessibleFrame(Frame frame) {
            this.this$0 = frame;
            super(frame);
            this.finit$();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleWindowHandler = new AccessibleWindowHandler(this);
                this.this$0.addWindowListener(this.accessibleWindowHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler(this);
                this.this$0.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler(this);
                this.this$0.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                this.this$0.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                this.this$0.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                this.this$0.removeWindowListener(this.accessibleWindowHandler);
                this.accessibleWindowHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if ((this.this$0.getExtendedState() & 1) > 0) {
                accessibleStateSet.add(AccessibleState.ICONIFIED);
            }
            return accessibleStateSet;
        }

        public Color getBackground() {
            try {
                return new Color(this.this$0.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            try {
                return new Color(this.this$0.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return this.this$0.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return this.this$0.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return this.this$0.isShowing();
        }

        public boolean contains(java.awt.Point point) {
            try {
                return this.this$0.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = this.this$0.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point point = this.this$0.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setLocation(java.awt.Point point) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = this.this$0.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle rectangle) {
        }

        public Dimension getSize() {
            try {
                Size size = this.this$0.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(this.this$0.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return this.this$0.isFocusable();
        }

        public void requestFocus() {
            this.this$0.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleFrame this$1;

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    this.this$1.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    this.this$1.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }

            protected AccessibleContainerHandler(AccessibleFrame accessibleFrame) {
                this.this$1 = accessibleFrame;
            }
        }

        protected class AccessibleWindowHandler
        implements WindowListener {
            private /* synthetic */ AccessibleFrame this$1;

            public void windowActivated(WindowEvent windowEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.ACTIVE);
                if (Build.DEBUG) {
                    System.err.println("[frame] " + this.this$1.this$0.getTitle() + " is now active");
                }
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (Build.DEBUG) {
                    System.err.println("[frame] " + this.this$1.this$0.getTitle() + " has been closed");
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                if (Build.DEBUG) {
                    System.err.println("[frame] " + this.this$1.this$0.getTitle() + " is closing");
                }
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.ACTIVE, null);
                if (Build.DEBUG) {
                    System.err.println("[frame] " + this.this$1.this$0.getTitle() + " is no longer active");
                }
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                if (Build.DEBUG) {
                    System.err.println("[frame] " + this.this$1.this$0.getTitle() + " is no longer iconified");
                }
            }

            public void windowIconified(WindowEvent windowEvent) {
                if (Build.DEBUG) {
                    System.err.println("[frame] " + this.this$1.this$0.getTitle() + " has been iconified");
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (Build.DEBUG) {
                    System.err.println("[frame] " + this.this$1.this$0.getTitle() + " has been opened");
                }
            }

            protected AccessibleWindowHandler(AccessibleFrame accessibleFrame) {
                this.this$1 = accessibleFrame;
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            private /* synthetic */ AccessibleFrame this$1;

            public void componentHidden(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.this$1.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            protected AccessibleComponentHandler(AccessibleFrame accessibleFrame) {
                this.this$1 = accessibleFrame;
            }
        }
    }

    protected class AccessibleFrameListener
    implements XAccessibleEventListener {
        private /* synthetic */ Frame this$0;

        protected AccessibleFrameListener(Frame frame) {
            this.this$0 = frame;
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    this.this$0.active = bl;
                    if (bl) {
                        AccessibleObjectFactory.postWindowActivated(this.this$0);
                        break;
                    }
                    AccessibleObjectFactory.postWindowLostFocus(this.this$0);
                    break;
                }
                case 13: {
                    if (Build.DEBUG) {
                        System.err.println("[frame]" + this.this$0.getTitle() + (bl ? " is now " : " is no longer ") + "iconified");
                    }
                    this.this$0.postWindowEvent(bl ? 203 : 204);
                    break;
                }
                case 30: {
                    this.this$0.setVisible(bl);
                    break;
                }
                default: {
                    if (!Build.DEBUG) break;
                    System.err.println("[frame]: " + this.this$0.getTitle() + "unexpected state change " + s);
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                String string = AnyConverter.toString((Object)object);
                this.this$0.setTitle(string);
                AccessibleContext accessibleContext = this.this$0.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                AccessibleContext accessibleContext = this.this$0.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleVisibleDataEvent() {
            AccessibleContext accessibleContext = this.this$0.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", null, null);
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 1: {
                    this.handleNameChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        AccessibleObjectFactory.removeChild(this.this$0, accessibleEventObject.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    AccessibleObjectFactory.addChild((Container)this.this$0, accessibleEventObject.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataEvent();
                    break;
                }
                default: {
                    if (!Build.DEBUG) break;
                    System.out.println(this + ": unhandled accessibility event id=" + accessibleEventObject.EventId);
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

