/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.flagstone.transform.Background;
import com.flagstone.transform.DefineTag;
import com.flagstone.transform.DoAction;
import com.flagstone.transform.MovieHeader;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.Place2;
import com.flagstone.transform.Remove;
import com.flagstone.transform.Remove2;
import com.flagstone.transform.ShowFrame;
import com.flagstone.transform.action.Action;
import com.flagstone.transform.action.BasicAction;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.datatype.WebPalette;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.shape.ShapeTag;
import com.flagstone.transform.util.image.ImageDecoder;
import com.flagstone.transform.util.image.ImageRegistry;
import com.flagstone.transform.util.image.ImageShape;
import com.flagstone.transform.util.shape.Canvas;
import com.flagstone.transform.util.sound.SoundFactory;
import com.hammurapi.jcapture.ButtonManager;
import com.hammurapi.jcapture.Movie;
import com.hammurapi.jcapture.VideoEncoder;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class SwfEncoder
implements VideoEncoder {
    @Override
    public String getFileExtension() {
        return "swf";
    }

    @Override
    public String getMimeType() {
        return "application/x-shockwave-flash";
    }

    @Override
    public String toString() {
        return "SWF";
    }

    @Override
    public Dimension encode(VideoEncoder.Config config, Movie source, OutputStream out) throws Exception {
        int minImgLayer;
        AtomicInteger uid = new AtomicInteger();
        int maxId = 65535;
        ButtonManager manager = null;
        if (config.isToolBar()) {
            manager = new ButtonManager();
            manager.loadLibrary(this.getClass().getResource("toolbar_buttons.swf"));
            uid.set(manager.maxIdentifier() + 1);
        }
        Canvas path = new Canvas();
        path.setPixels(false);
        int imgLayer = minImgLayer = 10;
        int maxImgLayer = maxId - 1000;
        int mouseLayer = maxImgLayer + 1;
        int mouseUid = -1;
        Place2 mousePlace = null;
        ImageTag mouseImage = null;
        int layer = maxImgLayer + 2;
        int totalWork = 0;
        for (VideoEncoder.Fragment frg : source.getFragments()) {
            totalWork = frg.getFrames().size() + 1;
        }
        ProgressMonitor progressMonitor = new ProgressMonitor(config.getParentComponent(), "Encoding to SWF", "Composing movie", 0, totalWork);
        int progressCounter = 0;
        progressMonitor.setNote("Composing movie");
        boolean firstFrame = true;
        Dimension ret = null;
        IdentityHashMap<VideoEncoder.Fragment.Frame.Shape.Image, ImageTag> imageCache = new IdentityHashMap<VideoEncoder.Fragment.Frame.Shape.Image, ImageTag>();
        com.flagstone.transform.Movie movie = new com.flagstone.transform.Movie();
        Point prevMouseLocation = null;
        int frameNo = 0;
        for (VideoEncoder.Fragment fragment : source.getFragments()) {
            SoundFactory soundFactory = null;
            boolean soundHeaderAdded = false;
            File audio = fragment.getAudio();
            if (audio != null) {
                progressMonitor.setNote("Loading sound");
                soundFactory = new SoundFactory();
                if (config.getMp3command() != null && config.getMp3command().trim().length() > 0) {
                    audio = new File(audio.getAbsolutePath() + ".mp3");
                    Runtime runtime = Runtime.getRuntime();
                    Process proc = runtime.exec(MessageFormat.format(config.getMp3command(), fragment.getAudio().getAbsolutePath(), audio.getAbsolutePath()));
                    proc.waitFor();
                    if (!fragment.getAudio().delete()) {
                        fragment.getAudio().deleteOnExit();
                    }
                }
                soundFactory.read(audio);
            }
            progressMonitor.setProgress(++progressCounter);
            if (progressMonitor.isCanceled()) {
                return null;
            }
            for (VideoEncoder.Fragment.Frame frame : fragment.getFrames()) {
                MovieTag soundBlock;
                if (progressMonitor.isCanceled()) {
                    return null;
                }
                boolean addStop = false;
                ++frameNo;
                if (firstFrame) {
                    firstFrame = false;
                    MovieHeader header = new MovieHeader();
                    header.setCompressed(true);
                    header.setFrameRate(source.getFramesPerSecond());
                    int toolbarHeight = 580;
                    int toolbarWidth = 9900;
                    int toolbarX = 0;
                    int toolbarY = frame.getSize().height * 20;
                    int movieWidth = frame.getSize().width * 20;
                    int movieHeight = frame.getSize().height * 20;
                    if (config.isToolBar()) {
                        movieHeight += toolbarHeight;
                    }
                    ret = new Dimension(movieWidth / 20, movieHeight / 20);
                    float toolbarScaleX = (float)movieWidth / (float)toolbarWidth;
                    float toolbarScaleY = 1.0f;
                    Bounds movieBounds = new Bounds(0, 0, movieWidth, movieHeight);
                    header.setFrameSize(movieBounds);
                    movie.add((MovieTag)header);
                    movie.add((MovieTag)new Background(WebPalette.WHITE.color()));
                    if (config.isToolBar()) {
                        List<DefineTag> toolbarDefinitions = manager.getDefinitions();
                        movie.getObjects().addAll(toolbarDefinitions);
                        Place2 placeBackground = manager.getButton("background", layer++, 0, 0);
                        placeBackground.setTransform(new CoordTransform(toolbarScaleX, toolbarScaleY, 0.0f, 0.0f, toolbarX, toolbarY));
                        movie.add((MovieTag)placeBackground);
                        movie.add((MovieTag)manager.getButton("play_button", layer++, toolbarX + 500, toolbarY + toolbarHeight / 2));
                        movie.add((MovieTag)manager.getButton("progress_bar", layer++, toolbarX + 1000, toolbarY + toolbarHeight / 2));
                        movie.add((MovieTag)manager.getButton("volume_control", layer++, toolbarX + 5600, toolbarY + toolbarHeight / 2));
                        if (!config.isPlay()) {
                            addStop = true;
                        }
                    }
                }
                if (!soundHeaderAdded && soundFactory != null) {
                    movie.add(soundFactory.streamHeader(source.getFramesPerSecond()));
                    soundHeaderAdded = true;
                }
                if (soundFactory != null && (soundBlock = soundFactory.streamSound()) != null) {
                    movie.add(soundBlock);
                }
                for (VideoEncoder.Fragment.Frame.Shape shape : frame.getShapes()) {
                    ImageTag imageTag;
                    block35: {
                        VideoEncoder.Fragment.Frame.Shape.Image image;
                        VideoEncoder.Fragment.Frame.Shape.ShapeContent shapeContent;
                        if (shape.getContent().coversEverything() || imgLayer == maxImgLayer) {
                            for (int i = minImgLayer; i <= imgLayer; ++i) {
                                movie.add((MovieTag)new Remove2(i));
                            }
                            imgLayer = minImgLayer;
                        }
                        if ((shapeContent = shape.getContent()) instanceof VideoEncoder.Fragment.Frame.Shape.Image) {
                            image = (VideoEncoder.Fragment.Frame.Shape.Image)shapeContent;
                        } else if (shape.getContent() instanceof VideoEncoder.Fragment.Frame.Shape.ImageReference) {
                            image = ((VideoEncoder.Fragment.Frame.Shape.ImageReference)shapeContent).getImage();
                        } else {
                            throw new IllegalArgumentException("Unexpected content type: " + shapeContent);
                        }
                        imageTag = (ImageTag)imageCache.get(image);
                        if (imageTag == null) {
                            try {
                                ImageDecoder decoder = ImageRegistry.getImageProvider((String)("image/" + config.getImageFormat().toLowerCase()));
                                decoder.read((InputStream)new ByteArrayInputStream(image.getImage().getImageBytes()));
                                imageTag = decoder.defineImage(uid.incrementAndGet());
                                imageCache.put(image, imageTag);
                                movie.add((MovieTag)imageTag);
                            }
                            catch (Exception e) {
                                System.err.println("Error encoding image at frame " + frameNo + ": " + e);
                                e.printStackTrace();
                                if (JOptionPane.showConfirmDialog(config.getParentComponent(), "Error encoding image (" + image.getImage().getWidth() + "*" + image.getImage().getHeight() + ") at frame " + frameNo + ": " + e + ". Continue encoding?", "Encoding error", 0, 0) != 1) break block35;
                                throw e;
                            }
                        }
                    }
                    int shapeId = uid.incrementAndGet();
                    ShapeTag shapeTag = new ImageShape().defineShape(shapeId, imageTag);
                    Place2 place = Place2.show((int)shapeTag.getIdentifier(), (int)imgLayer++, (int)(shape.getLocation().x * 20), (int)(shape.getLocation().y * 20));
                    movie.add((MovieTag)shapeTag);
                    movie.add((MovieTag)place);
                }
                Point mouseLocation = frame.getMousePointer();
                if (mouseLocation != null) {
                    if (mouseImage == null) {
                        BufferedImage mouseBi = ImageIO.read(this.getClass().getResource("mouse.png"));
                        if (config.getScreenScale() < 0.99 || config.getScreenScale() > 1.01) {
                            BufferedImage scaled = new BufferedImage((int)((double)mouseBi.getWidth() * config.getScreenScale()), (int)((double)mouseBi.getHeight() * config.getScreenScale()), mouseBi.getType());
                            Graphics2D g = scaled.createGraphics();
                            g.setComposite(AlphaComposite.Src);
                            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g.drawImage(mouseBi, 0, 0, scaled.getWidth(), scaled.getHeight(), null);
                            g.dispose();
                            mouseBi = scaled;
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)mouseBi, "PNG", baos);
                        baos.close();
                        ImageDecoder decoder = ImageRegistry.getImageProvider((String)"image/png");
                        decoder.read((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                        mouseImage = decoder.defineImage(uid.incrementAndGet());
                        movie.add((MovieTag)mouseImage);
                    }
                    if (!mouseLocation.equals(prevMouseLocation)) {
                        prevMouseLocation = mouseLocation;
                        mouseUid = uid.incrementAndGet();
                        ShapeTag mShape = new ImageShape().defineShape(uid.incrementAndGet(), mouseImage);
                        mousePlace = mousePlace == null ? Place2.show((int)mShape.getIdentifier(), (int)mouseLayer, (int)(mouseLocation.x * 20), (int)(mouseLocation.y * 20)) : Place2.replace((int)mShape.getIdentifier(), (int)mouseLayer, (int)(mouseLocation.x * 20), (int)(mouseLocation.y * 20));
                        movie.add((MovieTag)mShape);
                        movie.add((MovieTag)mousePlace);
                    }
                } else if (mouseUid != -1) {
                    Remove remove = new Remove(mouseUid, mouseLayer);
                    movie.add((MovieTag)remove);
                }
                if (addStop) {
                    DoAction cmd = new DoAction(new ArrayList());
                    cmd.add((Action)BasicAction.STOP);
                    movie.add((MovieTag)cmd);
                }
                movie.add((MovieTag)ShowFrame.getInstance());
                progressMonitor.setProgress(++progressCounter);
            }
            progressMonitor.setProgress(++progressCounter);
            if (soundFactory != null) {
                MovieTag block;
                progressMonitor.setNote("Recording trailing sound");
                while ((block = soundFactory.streamSound()) != null) {
                    movie.add(block);
                    movie.add((MovieTag)ShowFrame.getInstance());
                }
            }
            if (audio == null || audio.delete()) continue;
            audio.deleteOnExit();
        }
        if (!config.isLoop()) {
            ArrayList<BasicAction> actions = new ArrayList<BasicAction>();
            actions.add(BasicAction.STOP);
            actions.add(BasicAction.END);
            DoAction doAction = new DoAction(actions);
            movie.add((MovieTag)doAction);
            movie.add((MovieTag)ShowFrame.getInstance());
        }
        progressMonitor.setProgress(++progressCounter);
        progressMonitor.setNote("Encoding movie");
        movie.encodeToStream(out);
        source.close();
        return ret;
    }
}

