/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.MappedImage;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class Region
extends Rectangle {
    private static final int TRANSPARENT_COLOR = new Color(0, 0, 0, 0).getRGB();
    private BufferedImage master;
    private BufferedImage prev;
    private int grabRange;
    private MappedImage image;
    private boolean transparency;
    private Point imageLocation;
    private String format;
    private FileChannel channel;
    private Region masterImageRegion;
    private long imageHash;
    private boolean coversEverything;

    public Region(BufferedImage master, String format, FileChannel channel, BufferedImage prev, boolean transparency, int x, int y, int grabRange) {
        this.master = master;
        this.format = format;
        this.channel = channel;
        this.prev = prev;
        this.transparency = transparency;
        this.grabRange = grabRange;
        this.setBounds(x - grabRange, y - grabRange, grabRange * 2 + 1, grabRange * 2 + 1);
    }

    public Region(MappedImage master) throws IOException {
        this.image = master;
        this.grabRange = 0;
        this.imageLocation = new Point(0, 0);
        this.coversEverything = true;
        this.setBounds(0, 0, master.getWidth(), master.getHeight());
        BufferedImage img = master.getImage();
        int sw = master.getWidth();
        for (int sx = 0; sx < sw; ++sx) {
            int sh = master.getHeight();
            for (int sy = 0; sy < sh; ++sy) {
                this.imageHash ^= (long)img.getRGB(sx, sy);
                Long.rotateRight(this.imageHash, 1);
            }
        }
    }

    public void grabImage() throws IOException {
        if (this.image == null) {
            int imageHeight;
            int heightDelta;
            this.imageLocation = new Point(Math.max(0, this.x), Math.max(0, this.y));
            int imageWidth = this.width;
            int widthDelta = imageWidth + this.imageLocation.x - this.master.getWidth();
            if (widthDelta > 0) {
                imageWidth -= widthDelta;
            }
            if ((heightDelta = (imageHeight = this.height) + this.imageLocation.y - this.master.getHeight()) > 0) {
                imageHeight -= heightDelta;
            }
            BufferedImage bImage = new BufferedImage(imageWidth, imageHeight, 2);
            for (int x = 0; x < imageWidth; ++x) {
                for (int y = 0; y < imageHeight; ++y) {
                    int oldPixel;
                    int xt = x + this.imageLocation.x;
                    int yt = y + this.imageLocation.y;
                    int newPixel = this.master.getRGB(xt, yt);
                    int pixelRGB = newPixel == (oldPixel = this.prev.getRGB(xt, yt)) && this.transparency ? TRANSPARENT_COLOR : newPixel;
                    bImage.setRGB(x, y, pixelRGB);
                    this.imageHash ^= (long)pixelRGB;
                    Long.rotateRight(this.imageHash, 1);
                }
            }
            this.image = new MappedImage(bImage, this.format, this.channel);
            this.master = null;
            this.prev = null;
        }
    }

    public MappedImage getImage() {
        return this.image;
    }

    public Point getImageLocation() {
        return this.imageLocation;
    }

    boolean merge(int x, int y) {
        if (this.image != null) {
            throw new IllegalStateException("Image already grabbed");
        }
        if (this.contains(x, y)) {
            int newMinX = Math.min(x - this.grabRange, this.x);
            int newMinY = Math.min(y - this.grabRange, this.y);
            int newMaxX = Math.max(x + this.grabRange, this.x + this.width);
            int newMaxY = Math.max(y + this.grabRange, this.y + this.height);
            this.setBounds(newMinX, newMinY, newMaxX - newMinX, newMaxY - newMinY);
            return true;
        }
        return false;
    }

    boolean merge(Region region) {
        if (region == this) {
            throw new IllegalArgumentException("Self-merge");
        }
        if (this.image != null) {
            throw new IllegalStateException("Image already grabbed");
        }
        if (this.intersects(region)) {
            int newMinX = Math.min(region.x, this.x);
            int newMinY = Math.min(region.y, this.y);
            int newMaxX = Math.max(region.x + region.width, this.x + this.width);
            int newMaxY = Math.max(region.y + region.height, this.y + this.height);
            this.setBounds(newMinX, newMinY, newMaxX - newMinX, newMaxY - newMinY);
            return true;
        }
        return false;
    }

    public Region getMasterImageRegion() {
        return this.masterImageRegion;
    }

    public void setMasterImageRegion(Region masterImageRegion) {
        this.masterImageRegion = masterImageRegion;
        while (this.masterImageRegion.getMasterImageRegion() != null) {
            this.masterImageRegion = this.masterImageRegion.getMasterImageRegion();
        }
    }

    public boolean imageEquals(Region other) throws IOException {
        if (this.image == null) {
            throw new IllegalStateException("Image not grabbed");
        }
        MappedImage otherImage = other.getImage();
        if (otherImage == null || this.imageHash != other.imageHash || this.image.getHeight() != otherImage.getHeight() || this.image.getWidth() != otherImage.getWidth()) {
            return false;
        }
        BufferedImage bImage = this.image.getImage();
        BufferedImage oImage = otherImage.getImage();
        int sw = bImage.getWidth();
        for (int sx = 0; sx < sw; ++sx) {
            int sh = bImage.getHeight();
            for (int sy = 0; sy < sh; ++sy) {
                if (bImage.getRGB(sx, sy) == oImage.getRGB(sx, sy)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean dedup(Region sr) throws IOException {
        if (this.imageEquals(sr)) {
            this.setMasterImageRegion(sr);
            this.image = null;
            return true;
        }
        return false;
    }

    public boolean coversEverything() {
        return this.coversEverything;
    }
}

