/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.Movie;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.Place2;
import com.flagstone.transform.datatype.CoordTransform;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public class ButtonManager {
    private final Map<String, Place2> buttons = new HashMap<String, Place2>();
    private final List<DefineTag> definitions = new ArrayList<DefineTag>();

    public void loadLibrary(URL libUrl) throws IOException, DataFormatException {
        Movie movie = new Movie();
        movie.decodeFromUrl(libUrl);
        this.findDefinitions(movie, this.definitions);
        this.findButtons(movie, this.buttons);
    }

    public int maxIdentifier() {
        int identifier = 0;
        for (DefineTag object : this.definitions) {
            if (object.getIdentifier() <= identifier) continue;
            identifier = object.getIdentifier();
        }
        return identifier;
    }

    public List<DefineTag> getDefinitions() {
        ArrayList<DefineTag> list = new ArrayList<DefineTag>(this.definitions.size());
        Iterator<DefineTag> iter = this.definitions.iterator();
        while (iter.hasNext()) {
            list.add((DefineTag)iter.next().copy());
        }
        return list;
    }

    public Place2 getButton(String name, int layer, int xpos, int ypos) {
        Place2 place = this.buttons.get(name).copy();
        place.setLayer(layer);
        place.setTransform(new CoordTransform(1.0f, 1.0f, 0.0f, 0.0f, xpos, ypos));
        return place;
    }

    private void findDefinitions(Movie movie, List<DefineTag> list) {
        for (MovieTag object : movie.getObjects()) {
            if (!(object instanceof DefineTag)) continue;
            list.add((DefineTag)object);
        }
    }

    private void findButtons(Movie movie, Map<String, Place2> list) {
        for (MovieTag object : movie.getObjects()) {
            Place2 place;
            if (!(object instanceof Place2) || (place = (Place2)object).getName() == null) continue;
            list.put(place.getName(), place);
        }
    }
}

