/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.fillstyle.Interpolation;
import com.flagstone.transform.fillstyle.MorphGradient;
import com.flagstone.transform.fillstyle.Spread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MorphFocalGradientFill
implements FillStyle {
    private static final int SPREAD_MASK = 192;
    private static final int INTER_MASK = 48;
    private static final int GRADIENT_MASK = 15;
    private static final String FORMAT = "MorphFocalGradientFill: { spread=%s; interpolation=%s; startFocalPoint=%f; endFocalPoint=%f; startTransform=%s; endTransform=%s; gradients=%s}";
    private CoordTransform startTransform;
    private CoordTransform endTransform;
    private int spread;
    private int interpolation;
    private int startFocalPoint;
    private int endFocalPoint;
    private List<MorphGradient> gradients;
    private transient int count;

    public MorphFocalGradientFill(SWFDecoder coder, Context context) throws IOException {
        this.startTransform = new CoordTransform(coder);
        this.endTransform = new CoordTransform(coder);
        this.count = coder.readByte() & 0xF;
        this.spread = this.count & 0xC0;
        this.interpolation = this.count & 0x30;
        this.count &= 0xF;
        this.gradients = new ArrayList<MorphGradient>(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.gradients.add(new MorphGradient(coder, context));
        }
        this.startFocalPoint = coder.readSignedShort();
        this.endFocalPoint = coder.readSignedShort();
    }

    public MorphFocalGradientFill(CoordTransform startMatrix, CoordTransform endMatrix, Spread spreadType, Interpolation interpolationType, float startPoint, float endPoint, List<MorphGradient> list) {
        this.setStartTransform(startMatrix);
        this.setEndTransform(endMatrix);
        this.setSpread(spreadType);
        this.setInterpolation(interpolationType);
        this.setStartFocalPoint(startPoint);
        this.setEndFocalPoint(endPoint);
        this.setGradients(list);
    }

    public MorphFocalGradientFill(MorphFocalGradientFill object) {
        this.spread = object.spread;
        this.interpolation = object.interpolation;
        this.startTransform = object.startTransform;
        this.endTransform = object.endTransform;
        this.startFocalPoint = object.startFocalPoint;
        this.endFocalPoint = object.endFocalPoint;
        this.gradients = new ArrayList<MorphGradient>(object.gradients);
    }

    public Spread getSpread() {
        return Spread.fromInt(this.spread);
    }

    public void setSpread(Spread spreadType) {
        this.spread = spreadType.getValue();
    }

    public Interpolation getInterpolation() {
        return Interpolation.fromInt(this.interpolation);
    }

    public void setInterpolation(Interpolation interp) {
        this.interpolation = interp.getValue();
    }

    public float getStartFocalPoint() {
        return (float)this.startFocalPoint / 256.0f;
    }

    public void setStartFocalPoint(float point) {
        this.startFocalPoint = (int)(point * 256.0f);
    }

    public float getEndFocalPoint() {
        return (float)this.endFocalPoint / 256.0f;
    }

    public void setEndFocalPoint(float point) {
        this.endFocalPoint = (int)(point * 256.0f);
    }

    public MorphFocalGradientFill add(MorphGradient aGradient) {
        if (aGradient == null) {
            throw new IllegalArgumentException();
        }
        if (this.gradients.size() == 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients.add(aGradient);
        return this;
    }

    public List<MorphGradient> getGradients() {
        return this.gradients;
    }

    public void setGradients(List<MorphGradient> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (this.gradients.size() > 15) {
            throw new IllegalStateException("Maximum number of gradients exceeded.");
        }
        this.gradients = list;
    }

    public CoordTransform getStartTransform() {
        return this.startTransform;
    }

    public CoordTransform getEndTransform() {
        return this.endTransform;
    }

    public void setStartTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.startTransform = matrix;
    }

    public void setEndTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.endTransform = matrix;
    }

    @Override
    public MorphFocalGradientFill copy() {
        return new MorphFocalGradientFill(this);
    }

    public String toString() {
        return String.format(FORMAT, new Object[]{this.getSpread(), this.getInterpolation(), Float.valueOf(this.getStartFocalPoint()), Float.valueOf(this.getEndFocalPoint()), this.startTransform.toString(), this.endTransform.toString(), this.gradients.toString()});
    }

    @Override
    public int prepareToEncode(Context context) {
        int length = 6 + this.startTransform.prepareToEncode(context) + this.endTransform.prepareToEncode(context);
        this.count = this.gradients.size();
        for (MorphGradient gradient : this.gradients) {
            length += gradient.prepareToEncode(context);
        }
        return length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(19);
        this.startTransform.encode(coder, context);
        this.endTransform.encode(coder, context);
        coder.writeByte(this.count | this.spread | this.interpolation);
        for (MorphGradient gradient : this.gradients) {
            gradient.encode(coder, context);
        }
        coder.writeShort(this.startFocalPoint);
        coder.writeShort(this.endFocalPoint);
    }
}

