/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import java.io.IOException;

public final class MorphBitmapFill
implements FillStyle {
    private static final String FORMAT = "MorphBitmapFill: { identifier=%d; start=%s; end=%s}";
    private static final int CLIPPED_MASK = 1;
    private static final int SMOOTHED_MASK = 2;
    private transient int type;
    private int identifier;
    private CoordTransform startTransform;
    private CoordTransform endTransform;

    public MorphBitmapFill(int fillType, SWFDecoder coder) throws IOException {
        this.type = fillType;
        this.identifier = coder.readUnsignedShort();
        this.startTransform = new CoordTransform(coder);
        this.endTransform = new CoordTransform(coder);
    }

    public MorphBitmapFill(boolean tiled, boolean smoothed, int uid, CoordTransform start, CoordTransform end) {
        this.type = 64;
        this.setTiled(tiled);
        this.setSmoothed(smoothed);
        this.setIdentifier(uid);
        this.setStartTransform(start);
        this.setEndTransform(end);
    }

    public MorphBitmapFill(MorphBitmapFill object) {
        this.type = object.type;
        this.identifier = object.identifier;
        this.startTransform = object.startTransform;
        this.endTransform = object.endTransform;
    }

    public boolean isTiled() {
        return (this.type & 1) != 0;
    }

    public void setTiled(boolean tiled) {
        this.type = tiled ? (this.type &= 0xFFFFFFFE) : (this.type |= 1);
    }

    public boolean isSmoothed() {
        return (this.type & 2) != 0;
    }

    public void setSmoothed(boolean smoothed) {
        this.type = smoothed ? (this.type &= 0xFFFFFFFD) : (this.type |= 2);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public CoordTransform getStartTransform() {
        return this.startTransform;
    }

    public CoordTransform getEndTransform() {
        return this.endTransform;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public void setStartTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.startTransform = matrix;
    }

    public void setEndTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.endTransform = matrix;
    }

    @Override
    public MorphBitmapFill copy() {
        return new MorphBitmapFill(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.startTransform, this.endTransform);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 3 + this.startTransform.prepareToEncode(context) + this.endTransform.prepareToEncode(context);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.type);
        coder.writeShort(this.identifier);
        this.startTransform.encode(coder, context);
        this.endTransform.encode(coder, context);
    }
}

