/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class ScalingGrid
implements DefineTag {
    private static final String FORMAT = "ScalingGrid: { identifier=%d; bounds=%s}";
    private int identifier;
    private Bounds bounds;
    private transient int length;

    public ScalingGrid(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        this.identifier = coder.readUnsignedShort();
        this.bounds = new Bounds(coder);
    }

    public ScalingGrid(int uid, Bounds rect) {
        this.setIdentifier(uid);
        this.setBounds(rect);
    }

    public ScalingGrid(ScalingGrid object) {
        this.identifier = object.identifier;
        this.bounds = object.bounds;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void setBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = rect;
    }

    @Override
    public ScalingGrid copy() {
        return new ScalingGrid(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.bounds.toString());
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2 + this.bounds.prepareToEncode(context);
        return 2 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(0x1380 | this.length);
        coder.writeShort(this.identifier);
        this.bounds.encode(coder, context);
    }
}

